SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='143', script='V143__3.176.175.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.176.175' WHERE conf_chave='VERSAO_SAUDE';
UPDATE config SET conf_valor_string='Compatível com a versão PEC: 3.0.13 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';

/* #246124 - Tipos de receitas na dispensação*/
CREATE TABLE tipo_receita (
  tr_codigo BIGSERIAL NOT NULL,
  tr_desc CHARACTER VARYING,
  CONSTRAINT tipo_receita_pkey PRIMARY KEY (tr_codigo)
);

INSERT INTO tipo_receita (tr_desc)   VALUES ('SUS');
INSERT INTO tipo_receita (tr_desc)   VALUES ('PARTICULAR');
INSERT INTO tipo_receita (tr_desc)   VALUES ('FORA DO MUNICÍPIO');

ALTER TABLE movimento ADD COLUMN tr_codigo INTEGER;

ALTER TABLE movimento ADD CONSTRAINT fk_tr_codigo FOREIGN KEY (tr_codigo) REFERENCES tipo_receita (tr_codigo);
/* #246124 - Fim*/

/* #234622 - ALTERAÇÃO TELA EXAMES II */
ALTER TABLE requisicao_exames ADD COLUMN data_solicitacao DATE;
ALTER TABLE requisicao_exames ADD COLUMN data_realizacao DATE;
ALTER TABLE requisicao_exames ADD COLUMN data_resultado DATE;
/* #234622 - Fim */

/* #267056 - Trigger que dispara os dados do paciente para o eSUS dispara exceção ao salvar o mesmo */
CREATE OR REPLACE FUNCTION esus_cadastro_individual()
  RETURNS trigger AS
$BODY$
DECLARE
	usu_codigo_conf bigint;
	eci_sexo character(20);
	eci_raca character(20);
	eci_nacionalidade character(20);
	eci_exportado integer;
	eci_origem_prontuario boolean;
	linha RECORD;
BEGIN
	SELECT usu_origem_prontuario INTO eci_origem_prontuario FROM usuario WHERE usu_codigo = NEW.usu_codigo;

	IF (TG_OP='DELETE') THEN
		DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
		RAISE NOTICE 'DELETE''.';
	ELSE
		IF (eci_origem_prontuario = FALSE) THEN
			FOR linha IN
			SELECT
				usu.usu_codigo,
				uni.uni_cnes AS eci_cnes,
				usr.cnes_cod_cns AS eci_usr_cns,
				uni.uni_codigo_ibge AS eci_usr_codigo_ibge,
				usu.usu_data_cad AS eci_dtatendimento,
				cid.cid_codigo_ibge AS eci_usu_codigo_ibge,
				usu.usu_datanasc AS eci_usu_dtnascimento,
				usu.cd_nacionalidade AS eci_usu_nacionalidade,
				usu.usu_nome AS eci_usu_nome,
				usu.usu_mae AS eci_usu_mae,
				usu.rac_codigo AS eci_usu_raca,
				usu.usu_sexo AS eci_usu_sexo,
				usu.usu_freq_escolar AS eci_usu_escola,
				usu.usu_deficiencia AS eci_usu_deficiencia,
				usu.usu_sit_rua AS eci_usu_sit_rua,
				usu.usu_cartao_sus AS eci_usu_cns
			FROM
				usuario AS usu
				INNER JOIN
				usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
				INNER JOIN
				unidade AS uni ON usu.uni_codigo=uni.uni_codigo
				LEFT JOIN
				cidade AS cid ON usu.cid_codigo_nasc=cid.cid_codigo
			WHERE
				usu.usu_codigo = NEW.usu_codigo LOOP
				-- Validação de sexo
				IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
				-- Validação nacionalidade
				IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
				IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '3 L'; END IF;
				IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '2 L'; END IF;
				-- Validação Raça
				IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
				IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
				IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
				IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
				IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
				IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
				SELECT count(*) into eci_exportado from esus_cadastro_individual where usu_codigo = NEW.usu_codigo;
				IF (TG_OP='UPDATE' AND eci_exportado > 0) THEN

					INSERT INTO esus_cadastro_individual
					(usu_codigo,
					 eci_usr_cnes,
					 eci_usr_profissional_cns,
					 eci_usr_codigo_ibge,
					 eci_usr_dtatendimento,
					 eci_usu_codigo_ibge,
					 eci_usu_dtnascimento,
					 eci_usu_nacionalidade,
					 eci_usu_nome,
					 eci_usu_mae,
					 eci_usu_raca,
					 eci_usu_sexo,
					 eci_usu_escola,
					 eci_usu_deficiencia,
					 eci_usu_cns,
					 eci_tipo_dado_serializado,
					 eci_usu_sit_rua,
					 uuid_ficha_ori)
					VALUES
						(linha.usu_codigo,
							linha.eci_cnes,
							linha.eci_usr_cns,
							linha.eci_usr_codigo_ibge,
							NOW(),
							linha.eci_usu_codigo_ibge,
							linha.eci_usu_dtnascimento,
							eci_nacionalidade,
							linha.eci_usu_nome,
							linha.eci_usu_mae,
							eci_raca,
						 eci_sexo,
						 linha.eci_usu_escola,
						 linha.eci_usu_deficiencia,
						 linha.eci_usu_cns,
						 '2 L',
						 linha.eci_usu_sit_rua,
						 (select uuid_ficha
							from esus_cadastro_individual
							where usu_codigo = linha.usu_codigo
							order by eci_codigo asc
							limit 1));

					RAISE NOTICE 'UPDATE''.';

				ELSE
					-- INSERÇÃO
					INSERT INTO esus_cadastro_individual
					(usu_codigo,
					 eci_usr_cnes,
					 eci_usr_profissional_cns,
					 eci_usr_codigo_ibge,
					 eci_usr_dtatendimento,
					 eci_usu_codigo_ibge,
					 eci_usu_dtnascimento,
					 eci_usu_nacionalidade,
					 eci_usu_nome,
					 eci_usu_mae,
					 eci_usu_raca,
					 eci_usu_sexo,
					 eci_usu_escola,
					 eci_usu_deficiencia,
					 eci_usu_cns,
					 eci_tipo_dado_serializado,
					 eci_usu_sit_rua)
					VALUES
						(linha.usu_codigo,
							linha.eci_cnes,
							linha.eci_usr_cns,
							linha.eci_usr_codigo_ibge,
							NOW(),
							linha.eci_usu_codigo_ibge,
							linha.eci_usu_dtnascimento,
							eci_nacionalidade,
							linha.eci_usu_nome,
							linha.eci_usu_mae,
							eci_raca,
						 eci_sexo,
						 linha.eci_usu_escola,
						 linha.eci_usu_deficiencia,
						 linha.eci_usu_cns,
						 '2 L',
						 linha.eci_usu_sit_rua);
				END IF;
			END LOOP;
		END IF;
		RAISE NOTICE 'INSERT''.';
	END IF;
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION esus_cadastro_individual()
  OWNER TO social;
/* #267056 - Fim */
