SET search_path = social;
/***************
**  OBSERVACAO **
****************/
-- LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='146', script='V146__3.179.178.sql', installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.179.178' WHERE conf_chave='VERSAO_SAUDE';
-- UPDATE config SET conf_valor_string='Compatível com a versão PEC: 3.0.13 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';

/* 271775 - Implementação de Solução Tecnológica III */
ALTER TABLE usuario ADD COLUMN usu_codigo_agentic INTEGER;
ALTER TABLE usuarios ADD COLUMN usr_codigo_agentic INTEGER;
ALTER TABLE medico ADD COLUMN med_codigo_agentic INTEGER;
ALTER TABLE agenda ADD COLUMN age_codigo_agentic INTEGER;
ALTER TABLE agendamento ADD COLUMN age_codigo_agentic INTEGER;
ALTER TABLE agendamento_exame ADD COLUMN agex_codigo_agentic INTEGER;
ALTER TABLE agendamento_externo ADD COLUMN agee_codigo_agentic INTEGER;
/* 271775 - Fim */

/* 272132 - Refatorar Tela Cadastros/Médicos */
ALTER TABLE medico ADD COLUMN med_end_cidade  VARCHAR(120) NULL;
ALTER TABLE medico ADD COLUMN med_end_uf      CHAR(2) NULL;
ALTER TABLE medico ADD COLUMN med_tipo_pessoa CHAR NULL;
ALTER TABLE medico ADD COLUMN med_con_codigo  INTEGER NULL;
ALTER TABLE medico ADD COLUMN med_especialidade  VARCHAR(255) NULL;
ALTER TABLE medico ALTER COLUMN med_end_celular TYPE varchar(40) USING med_end_celular::varchar(40);

UPDATE medico SET med_tipo_pessoa = 'J' WHERE med_nome_fantasia IS NOT NULL;
UPDATE medico SET med_tipo_pessoa = 'F' WHERE med_nome_fantasia IS NULL;
UPDATE medico SET med_con_codigo = 71   WHERE prestador_servico = 'M';
UPDATE medico SET med_con_codigo = 66   WHERE prestador_servico = 'E';

INSERT INTO permissoes (perm_descricao, perm_programa, perm_objeto)
VALUES ('CADASTRO DE MEDICOS', 'zf/medicos/cadastro-medicos', 'zf/medicos/cadastro-medicos');
/* 272132 - Fim */

/*249131 - Implementação de ficha Complementar - Síndrome Neurológica por Zika/Microcefalia */
INSERT INTO permissoes(perm_descricao, perm_programa, perm_objeto) VALUES ('Ficha Complementar', 'zf/programas-federais/ficha-complementar','zf/programas-federais/ficha-complementar');

CREATE TABLE IF NOT EXISTS esus_ficha_complementar
(
  efc_codigo BIGSERIAL NOT NULL,
  usr_codigo INTEGER NOT NULL,
  esp_codigo INTEGER NOT NULL,
  uni_codigo INTEGER NOT NULL,
  usr_equipe_codigo INTEGER,
  efc_data DATE,
  efc_cod_igbe_mun CHARACTER VARYING(7),
  efc_turno  INTEGER NOT NULL,
  usu_codigo INTEGER NOT NULL,
  efc_usu_responsavel INTEGER,
  efc_data_olhinho DATE,
  efc_res_olhinho INTEGER,
  efc_data_fundo DATE,
  efc_res_fundo INTEGER,
  efc_data_orelhinha DATE,
  efc_res_orelhinha INTEGER,
  efc_data_transfontanela DATE,
  efc_res_transfontanela INTEGER,
  efc_data_tomografia DATE,
  efc_res_tomografia INTEGER,
  efc_data_ressonancia DATE,
  efc_res_ressonancia INTEGER,
  uuid_ficha CHARACTER VARYING(60),
  CONSTRAINT pk_ficha_complementar PRIMARY KEY (efc_codigo),
  CONSTRAINT fk_ficha_complementar_usr_codigo FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo),
  CONSTRAINT fk_ficha_complementar_uni_codigo FOREIGN KEY (uni_codigo) REFERENCES unidade (uni_codigo),
  CONSTRAINT fk_ficha_complementar_usu_codigo FOREIGN KEY (usu_codigo) REFERENCES usuario (usu_codigo)
);

COMMENT ON COLUMN esus_ficha_complementar.efc_turno IS '1 - Manhã, 2 - Tarde, 3 - Noite';
COMMENT ON COLUMN esus_ficha_complementar.efc_res_olhinho IS '1 - Presente bilateral, 2 - Duvidoso ou ausente';
COMMENT ON COLUMN esus_ficha_complementar.efc_res_fundo IS '3 - Normal, 4 - Alterado';
COMMENT ON COLUMN esus_ficha_complementar.efc_res_orelhinha IS '5 - Passou, 6 - Falhou';
COMMENT ON COLUMN esus_ficha_complementar.efc_res_transfontanela IS '7 - Normal, 8 - Sugestivo de infecção congênita, 9 - Outras alterações, 10 - Indeterminado';
COMMENT ON COLUMN esus_ficha_complementar.efc_res_tomografia IS '11 - Normal, 12 - Sugestivo de infecção congênita, 13 - Outras alterações, 14 - Indeterminado';
COMMENT ON COLUMN esus_ficha_complementar.efc_res_ressonancia IS '15 - Normal, 16 - Sugestivo de infecção congênita, 17 - Outras alterações, 18 - Indeterminado';


/*249131 - Fim*/


/*278842 - Micro-area no cadastro individual */

CREATE OR REPLACE FUNCTION esus_cadastro_individual()
  RETURNS trigger AS
$BODY$
DECLARE
  usu_codigo_conf bigint;
  eci_sexo character(20);
  eci_raca character(20);
  eci_nacionalidade character(20);
  eci_exportado integer;
  eci_origem_prontuario boolean;
  linha RECORD;
BEGIN
IF (TG_OP='INSERT') THEN
  SELECT usu_origem_prontuario INTO eci_origem_prontuario FROM usuario WHERE usu_codigo = NEW.usu_codigo;
 ELSE
  SELECT usu_origem_prontuario INTO eci_origem_prontuario FROM usuario WHERE usu_codigo = OLD.usu_codigo;
END IF;
  IF (TG_OP='DELETE') THEN
    DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
    RAISE NOTICE 'DELETE''.';
  ELSE
    IF (eci_origem_prontuario = FALSE) THEN
      FOR linha IN
      SELECT
        usu.usu_codigo,
        uni.uni_cnes AS eci_cnes,
        usr.cnes_cod_cns AS eci_usr_cns,
        uni.uni_codigo_ibge AS eci_usr_codigo_ibge,
        usu.usu_data_cad AS eci_dtatendimento,
        cid.cid_codigo_ibge AS eci_usu_codigo_ibge,
        usu.usu_datanasc AS eci_usu_dtnascimento,
        usu.cd_nacionalidade AS eci_usu_nacionalidade,
        usu.usu_nome AS eci_usu_nome,
        usu.usu_mae AS eci_usu_mae,
        usu.rac_codigo AS eci_usu_raca,
        usu.usu_sexo AS eci_usu_sexo,
        usu.usu_freq_escolar AS eci_usu_escola,
        usu.usu_deficiencia AS eci_usu_deficiencia,
        usu.usu_sit_rua AS eci_usu_sit_rua,
        usu.usu_cartao_sus AS eci_usu_cns,
        mic.mic_descricao AS eci_usu_microarea,
        usu.usu_microarea_fa AS eci_usu_microarea_fa,
        esp.cod_cbo AS eci_usr_cbo
      FROM
        usuario AS usu
        INNER JOIN
        usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
        INNER JOIN
        unidade AS uni ON usu.uni_codigo=uni.uni_codigo
        INNER JOIN
        especialidade AS esp ON usu.usr_esp_codigo=esp.esp_codigo
        LEFT JOIN
        cidade AS cid ON usu.cid_codigo_nasc=cid.cid_codigo
        INNER JOIN
        microarea AS mic ON usu.usu_microarea=mic.mic_codigo
      WHERE
        usu.usu_codigo = NEW.usu_codigo LOOP
        -- Validação de sexo
        IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
        -- Validação nacionalidade
        IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
        IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '3 L'; END IF;
        IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '2 L'; END IF;
        -- Validação Raça
        IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
        IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
        IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
        IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
        IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
        IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
        SELECT count(*) into eci_exportado from esus_cadastro_individual where usu_codigo = NEW.usu_codigo;
        IF (TG_OP='UPDATE' AND eci_exportado > 0) THEN

          INSERT INTO esus_cadastro_individual
          (usu_codigo,
           eci_usr_cnes,
           eci_usr_profissional_cns,
           eci_usr_codigo_ibge,
           eci_usr_dtatendimento,
           eci_usu_codigo_ibge,
           eci_usu_dtnascimento,
           eci_usu_nacionalidade,
           eci_usu_nome,
           eci_usu_mae,
           eci_usu_raca,
           eci_usu_sexo,
           eci_usu_escola,
           eci_usu_deficiencia,
           eci_usu_cns,
           eci_tipo_dado_serializado,
           eci_usu_sit_rua,
	         eci_usu_microarea,
	         eci_usu_microarea_fa,
	         eci_usr_cbo,
           uuid_ficha_ori
           )
          VALUES
            (linha.usu_codigo,
              linha.eci_cnes,
              linha.eci_usr_cns,
              linha.eci_usr_codigo_ibge,
              NOW(),
              linha.eci_usu_codigo_ibge,
              linha.eci_usu_dtnascimento,
              eci_nacionalidade,
              linha.eci_usu_nome,
              linha.eci_usu_mae,
              eci_raca,
             eci_sexo,
             linha.eci_usu_escola,
             linha.eci_usu_deficiencia,
             linha.eci_usu_cns,
             '2 L',
             linha.eci_usu_sit_rua,
	           linha.eci_usu_microarea,
	           linha.eci_usu_microarea_fa,
	           linha.eci_usr_cbo,
             (select uuid_ficha
              from esus_cadastro_individual
              where usu_codigo = linha.usu_codigo
              order by eci_codigo asc
              limit 1));

          RAISE NOTICE 'UPDATE''.';

        ELSE
          -- INSERÇÃO
          INSERT INTO esus_cadastro_individual
          (usu_codigo,
           eci_usr_cnes,
           eci_usr_profissional_cns,
           eci_usr_codigo_ibge,
           eci_usr_dtatendimento,
           eci_usu_codigo_ibge,
           eci_usu_dtnascimento,
           eci_usu_nacionalidade,
           eci_usu_nome,
           eci_usu_mae,
           eci_usu_raca,
           eci_usu_sexo,
           eci_usu_escola,
           eci_usu_deficiencia,
           eci_usu_cns,
           eci_tipo_dado_serializado,
           eci_usu_sit_rua,
           eci_usu_microarea,
           eci_usu_microarea_fa,
           eci_usr_cbo)
          VALUES
            (linha.usu_codigo,
              linha.eci_cnes,
              linha.eci_usr_cns,
              linha.eci_usr_codigo_ibge,
              NOW(),
              linha.eci_usu_codigo_ibge,
              linha.eci_usu_dtnascimento,
              eci_nacionalidade,
              linha.eci_usu_nome,
              linha.eci_usu_mae,
              eci_raca,
             eci_sexo,
             linha.eci_usu_escola,
             linha.eci_usu_deficiencia,
             linha.eci_usu_cns,
             '2 L',
             linha.eci_usu_sit_rua,
             linha.eci_usu_microarea,
             linha.eci_usu_microarea_fa,
             linha.eci_usr_cbo);
        END IF;
      END LOOP;
    END IF;
    RAISE NOTICE 'INSERT''.';
  END IF;
  RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

/*278842 - Fim*/


/* 274778 - Solução Tecnológica: Flag para Validar Integração */
ALTER TABLE usuario ADD COLUMN usu_sera_integrado BOOLEAN DEFAULT true;
/* 274778 - Fim */


/* 279062 - Ficha de atividade coletiva não exporta */
CREATE OR REPLACE FUNCTION esus_atividade_coletiva()
  RETURNS trigger AS
$BODY$
DECLARE
  linha RECORD;
  ibge INTEGER;
BEGIN
  SELECT conf_valor_int INTO ibge FROM config WHERE conf_chave = 'CID_CODIGO_IBGE';
  FOR linha IN
  SELECT
    tb_fav.co_cds_ficha_ativ_col,
    tb_fav.dt_ativ_col AS eav_dt_atividade,
    tb_fav.qt_participante_programado AS eav_num_participantes_prog,
    tb_fav.qt_participante_ativ AS eav_num_participantes,
    tb_fav.ds_local_ativ AS eav_local_atividade,
    tb_fav.hr_inicio AS eav_hora_inicio,
    tb_fav.hr_fim AS eav_hora_fim,
    usr.cnes_cod_cns AS eav_responsavel_cns,
    uni.uni_cnes AS eav_uni_cnes,
    tb_fav.cod_equipe_ine AS eav_responsavel_ine,
    tb_fav.cod_cnes_unidade AS eav_responsavel_cnes,
    tb_fav.qt_avaliacao_alterada AS eav_num_aval_alteradas,
    tb_fav.tp_cds_ativ_col AS eav_atividade_tipo,
    tb_fav.co_inep_escola AS eav_inep,
    tb_fav.pse_educacao AS eav_educacao,
    tb_fav.pse_saude AS eav_saude
  FROM
    tb_cds_ficha_ativ_col AS tb_fav
    INNER JOIN
    usuarios AS usr ON tb_fav.usr_codigo=usr.usr_codigo
    LEFT JOIN
    unidade AS uni ON tb_fav.uni_codigo=uni.uni_codigo
  WHERE
    tb_fav.co_cds_ficha_ativ_col=NEW.co_cds_ficha_ativ_col  LOOP

    IF (TG_OP='INSERT') THEN
      IF linha.co_cds_ficha_ativ_col IS NOT NULL THEN
        INSERT INTO esus_atividade_coletiva(
          co_cds_ficha_ativ_col,
          eav_dt_atividade,
          eav_num_participantes_prog,
          eav_num_participantes,
          eav_local_atividade,
          eav_hora_inicio,
          eav_hora_fim,
          eav_responsavel_cns,
          eav_responsavel_cnes,
          eav_responsavel_ine,
          eav_num_aval_alteradas,
          eav_atividade_tipo,
          eav_codigo_ibge,
          eav_inep,
          eav_uni_cnes,
          eav_educacao,
          eav_saude
        ) VALUES (
          linha.co_cds_ficha_ativ_col,
          linha.eav_dt_atividade,
          linha.eav_num_participantes_prog,
          linha.eav_num_participantes,
          linha.eav_local_atividade,
          linha.eav_hora_inicio,
          linha.eav_hora_fim,
          linha.eav_responsavel_cns,
          linha.eav_responsavel_cnes,
          linha.eav_responsavel_ine,
          linha.eav_num_aval_alteradas,
          linha.eav_atividade_tipo,
          ibge,
          linha.eav_inep,
          linha.eav_uni_cnes,
          linha.eav_educacao,
          linha.eav_saude
        );
        RETURN NEW;
      END IF;
    ELSE
      IF linha.co_cds_ficha_ativ_col IS NOT NULL THEN
        UPDATE esus_atividade_coletiva
        SET co_cds_ficha_ativ_col = linha.co_cds_ficha_ativ_col,
          eav_dt_atividade = linha.eav_dt_atividade,
          eav_num_participantes_prog = linha.eav_num_participantes_prog,
          eav_num_participantes = linha.eav_num_participantes,
          eav_local_atividade = linha.eav_local_atividade,
          eav_hora_inicio = linha.eav_hora_inicio,
          eav_hora_fim = linha.eav_hora_fim,
          eav_responsavel_cns = linha.eav_responsavel_cns,
          eav_responsavel_cnes  = linha.eav_responsavel_cnes,
          eav_responsavel_ine  = linha.eav_responsavel_ine,
          eav_num_aval_alteradas = linha.eav_num_aval_alteradas,
          eav_atividade_tipo = linha.eav_atividade_tipo,
          eav_codigo_ibge = ibge,
          eav_inep = linha.eav_inep,
          eav_uni_cnes = linha.eav_uni_cnes,
          eav_educacao = linha.eav_educacao,
          eav_saude = linha.eav_saude
        WHERE
          co_cds_ficha_ativ_col=NEW.co_cds_ficha_ativ_col;
        RETURN NEW;
      END IF;
    END IF;
  END LOOP;
  RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql VOLATILE
COST 100;

/* 274778 - Fim */