SET search_path = social;
/***************
**  OBSERVACAO **
****************/
-- LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='151', script='V151__3.184.183.sql', installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.184.183' WHERE conf_chave='VERSAO_SAUDE';
-- UPDATE config SET conf_valor_string='Compatível com a versão PEC: 3.1.13 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';

/* 44713 - Campo para cadastro de campanha */
CREATE TABLE IF NOT EXISTS vacina_campanha(
  vcam_codigo BIGSERIAL NOT NULL,
  vcam_nome CHARACTER VARYING (150),
  vcam_ano INT NOT NULL,
  vcam_abreviacao CHARACTER VARYING(20),
  CONSTRAINT pk_vacina_campanha PRIMARY KEY (vcam_codigo)
);

ALTER TABLE vacina_usuario ADD COLUMN vcam_codigo INTEGER;

ALTER TABLE vacina_usuario ADD CONSTRAINT fk_vacina_campanha FOREIGN KEY (vcam_codigo) REFERENCES vacina_campanha (vcam_codigo);
/*44713 - Fim*/

/*249394 - Implementação de ficha de Vacinação*/
INSERT INTO permissoes (perm_descricao,
                        perm_programa,
                        perm_objeto
                       ) VALUES (
                        'Ficha de Vacinação',
                        'zf/programas-federais/ficha-vacinacao',
                        'zf/programas-federais/ficha-vacinacao');

CREATE TABLE IF NOT EXISTS tb_vacina_imunobiologico(
  tvi_codigo BIGSERIAL NOT NULL,
  tvi_descricao CHARACTER VARYING (250),
  tvi_sigla CHARACTER VARYING (11)
);

INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (1,'Imunoglobulina anti tetânica','IGTH');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (2,'Soro tetânico','SAT');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (3,'Soro aracnídico / Escorpiônico','SARC');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (4,'Soro escorpiônico','SESCOR');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (5,'Dupla infantil','DT');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (6,'Soro elapídico','SELAP');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (7,'Soro rábico humano','SARH');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (8,'Soro botrópico','SBOTR');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (9,'Hepatite B','HB');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (10,'Soro diftérico','SAD');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (11,'Soro botrópico/crotálico','SBOCR');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (12,'Soro botrópico/laquético','SBOLAQ');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (14,'Febre amarela','FA');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (15,'BCG','BCG');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (16,'Soro crotálico','SCROT');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (17,'Haemophilus tipo b','Hib');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (18,'Raiva em cultivo celular (Embrião)','Embrião');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (19,'Imunoglobulina anti varicela zoster','IGVZ');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (20,'Imunoglobulina anti hepatite B','IGHB');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (21,'Pneumocócica 23V','Pncc23V');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (22,'Poliomielite inativada','VIP');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (23,'Imunoglobulina anti rábica','IGRH');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (24,'Tríplice viral','SCR');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (25,'Dupla adulto','dT');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (26,'Pneumocócica 10V','Pncc10V');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (28,'Poliomielite oral (Bivalente)','VOP');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (30,'Febre tifóide (polissacarídica)','FTp');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (31,'Soro loxoscélico','SLOXO');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (32,'Soro lonômico','SLONO');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (33,'Influenza Trivalente','FLU3V');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (34,'Varicela(atenuada)','Varc');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (35,'Hepatite A (CRIE)','HA');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (36,'Dupla viral','SR');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (37,'Raiva em cultivo celular Vero','Vero');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (38,'Soro botulínico trivalente','SBOTULBI');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (41,'Meningocócica conjugada C','Men Conj C');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (42,'DTP/HB/Hib','Penta');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (45,'Vacina rotavírus humano','VRH');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (46,'Tríplice bacteriana','DTP');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (47,'Tríplice acelular infantil','DTPa');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (51,'Febre tifóide (atenuada)','Fta');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (55,'Hepatite A Pediátrica','HAped');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (56,'Tetra Viral','Tetra Viral');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (57,'Tríplice bacteriana acelular (adulto)- dTpa','DTPa');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (67,'HPV Quadrivalente','HPV Quadri');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (69,'Soro botulínico bivalente','SBOTULBI');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (75,'Cólera oral','Cólera');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (82,'Vacina Dengue 1, 2, 3 e 4 (recomb e atenuada)','Dengue');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (83,'Vacina ads hepatite A (inativada, virossomal)','HAadulto');
INSERT INTO tb_vacina_imunobiologico (tvi_codigo,tvi_descricao, tvi_sigla) VALUES (84,'Febre Amarela - Dose fracionada (0,1 ml)','FA (0,1 ml)');

CREATE TABLE IF NOT EXISTS tb_vacina_estrategia(
  tve_codigo BIGSERIAL NOT NULL,
  tve_descricao CHARACTER VARYING (250)
);

INSERT INTO tb_vacina_estrategia (tve_codigo,tve_descricao) VALUES (1,'Rotina');
INSERT INTO tb_vacina_estrategia (tve_codigo,tve_descricao) VALUES (2,'Especial');
INSERT INTO tb_vacina_estrategia (tve_codigo,tve_descricao) VALUES (3,'Bloqueio');
INSERT INTO tb_vacina_estrategia (tve_codigo,tve_descricao) VALUES (4,'Intensificação');
INSERT INTO tb_vacina_estrategia (tve_codigo,tve_descricao) VALUES (5,'Campanha');
INSERT INTO tb_vacina_estrategia (tve_codigo,tve_descricao) VALUES (7,'Soroterapia');
INSERT INTO tb_vacina_estrategia (tve_codigo,tve_descricao) VALUES (10,'Multivacinação');

CREATE TABLE IF NOT EXISTS tb_vacina_dose(
  tvd_codigo BIGSERIAL NOT NULL,
  tvd_descricao CHARACTER VARYING (250),
  tvd_sigla CHARACTER VARYING (5)
);

INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (1,'1ª Dose','D1');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (2,'2ª Dose','D2');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (3,'3ª Dose','D3');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (4,'4ª Dose','D4');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (5,'5ª Dose','D5');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (6,'1º Reforço','R1');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (7,'2º Reforço','R2');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (8,'Dose','D');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (9,'Única','DU');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (10,'Revacinação','REV');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (11,'Tratamento com uma dose','T1');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (12,'Tratamento com duas doses','T2');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (13,'Tratamento com três doses','T3');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (14,'Tratamento com quatro doses','T4');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (15,'Tratamento com cinco doses','T5');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (16,'Tratamento com seis doses','T6');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (17,'Tratamento com sete doses','T7');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (18,'Tratamento com oito doses','T8');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (19,'Tratamento com nove doses','T9');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (20,'Tratamento com dez doses','T10');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (21,'Tratamento com onze doses','T11');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (22,'Tratamento com doze doses','T12');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (23,'Tratamento com treze doses','T13');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (24,'Tratamento com quatorze doses','T14');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (25,'Tratamento com quinze doses','T15');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (26,'Tratamento com dezesseis doses','T16');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (27,'Tratamento com dezessete doses','T17');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (28,'Tratamento com dezoito doses','T18');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (29,'Tratamento com dezenove doses','T19');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (30,'Tratamento com vinte doses','T20');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (31,'Tratamento com vinte quatro doses','T24');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (32,'1ª Dose Revacinação','D1REV');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (33,'2ª Dose Revacinação','D2REV');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (34,'3ª Dose Revacinação','D3REV');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (35,'4ª Dose Revacinação','D4REV');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (36,'Dose Inicial','DI');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (37,'Dose Adicional','DA');
INSERT INTO tb_vacina_dose (tvd_codigo,tvd_descricao, tvd_sigla) VALUES (38,'Reforço','REF');

CREATE TABLE IF NOT EXISTS esus_ficha_vacinacao(
  efv_codigo BIGSERIAL NOT NULL,
  usr_codigo INTEGER NOT NULL,
  esp_codigo INTEGER NOT NULL,
  uni_codigo INTEGER NOT NULL,
  usr_equipe_codigo INTEGER,
  efv_data DATE,
  efv_cod_igbe_mun CHARACTER VARYING(7),
  efv_turno INTEGER NOT NULL,
  usu_codigo INTEGER NOT NULL,
  co_local_atend INTEGER NOT NULL,
  efv_viajante BOOLEAN,
  efv_hanseniase BOOLEAN,
  efv_gestante BOOLEAN,
  efv_puerpera BOOLEAN,
  uuid_ficha CHARACTER VARYING(60),
  CONSTRAINT pk_esus_ficha_vacinacao PRIMARY KEY (efv_codigo),
  CONSTRAINT fk_esus_ficha_vacinacao_usr_codigo FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo),
  CONSTRAINT fk_esus_ficha_vacinacao_uni_codigo FOREIGN KEY (uni_codigo) REFERENCES unidade (uni_codigo),
  CONSTRAINT fk_esus_ficha_vacinacao_usu_codigo FOREIGN KEY (usu_codigo) REFERENCES usuario (usu_codigo)
);

CREATE TABLE IF NOT EXISTS esus_ficha_vacinacao_vacinas (
  fvv_codigo BIGSERIAL NOT NULL,
  efv_codigo INTEGER NOT NULL,
  tvi_codigo INTEGER NOT NULL,
  tve_codigo INTEGER NOT NULL,
  tvd_codigo INTEGER NOT NULL,
  tvd_lote CHARACTER VARYING (30),
  tvd_fabricante CHARACTER VARYING (60)
);

/*249394 - Fim*/