ALTER TABLE inventario_produto
ALTER COLUMN invp_lote TYPE character varying(80);

ALTER TABLE inventario_produto_lote_quantidade
ALTER COLUMN invplq_lote TYPE character varying(80);

ALTER TABLE produto ADD COLUMN pro_horus character varying;

insert into permissoes (perm_descricao,perm_programa,perm_objeto) values ('Horus','zf/horus/index','zf/horus/index');

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.49.48' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.31.20' WHERE conf_chave='VERSAO_COMUM';



CREATE OR REPLACE FUNCTION migra_schema()
  RETURNS void AS
$BODY$
	declare
		r RECORD;
		sql TEXT;
	begin
		for r in select * from information_schema.tables where table_schema in ('acaosocial', 'common', 'public', 'guiche') order by table_schema, table_name 
		loop
			sql = 'alter table ' || r.table_schema || '.' || r.table_name || ' set schema social ';
			execute sql;
		end loop;
	end
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION migra_schema()
  OWNER TO postgres;



select migra_schema();

CREATE OR REPLACE FUNCTION social.atetobpa()
  RETURNS trigger AS
$BODY$
DECLARE
  linha RECORD;
  bpaCodigo bigint;
  ciCodigo bigint;  
    
BEGIN

	FOR linha IN    SELECT age.uni_codigo,
						   ate.med_codigo,
						   ate.usu_codigo,
						   ate.ate_data,
						   proc.proc_codigo,
						   proc.proc_bpa_tipo,
						   cd10.cd10_codigo,
						   sispn_codigo,
						   age.age_emergencia
					  FROM atendimento AS ate
					  JOIN agendamento AS age
						ON age.age_codigo=ate.age_codigo
					  JOIN procedimento AS proc
						ON proc.proc_codigo_sus='0301010110'
					 LEFT JOIN cid10 AS cd10
						ON cd10.cd10_codigo=ate.cd10_codigo
					 WHERE ate.ate_codigo=NEW.ate_codigo LOOP
					 
				-- verificar ci
				IF linha.age_emergencia = 'S' THEN 
					SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Urgencia' AND ci_ativo='S' INTO ciCodigo;
				ELSE
					SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
				END IF;
		
				-- somente se h um sispn_codigo (FK com Pr-Natal)
				IF linha.sispn_codigo IS NOT NULL THEN
					  
					INSERT INTO BPA (uni_codigo,
									 usr_codigo,
									 usu_codigo,
									 bpa_data,
									 proc_codigo,
									 ci_codigo,
									 bpa_tipo,
									 bpa_cd10_codigo, 
									 bpa_origem,
									 bpa_origem_codigo)
							 VALUES (linha.uni_codigo,
									 linha.med_codigo,
									 linha.usu_codigo,
									 linha.ate_data,
									 NEW.proc_codigo,
									 ciCodigo,
									 linha.proc_bpa_tipo,
									 NEW.cd10_codigo,
									 'atendimento',
									 NEW.ate_codigo);
					RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma insero na tabela ''atendimento'', informando um cdigo do ''sis pr-natal''.';				 
					
				END IF;

				
			END LOOP;
				
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION social.atetobpa()
  OWNER TO postgres;


CREATE OR REPLACE FUNCTION social.atetobpadel()
  RETURNS trigger AS
$BODY$
    
BEGIN

	DELETE FROM bpa WHERE bpa_origem='atendimento' AND bpa_origem_codigo=OLD.ate_codigo;
	RAISE NOTICE 'Um registro na tabela ''bpa'' foi deletado devido uma excluso na tabela ''atendimento''.*';
	RETURN OLD;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION social.atetobpadel()
  OWNER TO postgres;
-- Function: social.atetobpaup()

-- DROP FUNCTION social.atetobpaup();

CREATE OR REPLACE FUNCTION social.atetobpaup()
  RETURNS trigger AS
$BODY$
DECLARE
  linha RECORD;
  bpaCodigo bigint;
  ciCodigo bigint;  
    
BEGIN

	FOR linha IN    SELECT age.uni_codigo,
						   ate.med_codigo,
						   ate.usu_codigo,
						   ate.ate_data,
						   proc.proc_codigo,
						   proc.proc_bpa_tipo,
						   cd10.cd10_codigo,
						   sispn_codigo,
						   age.age_emergencia
					  FROM atendimento AS ate
					  JOIN agendamento AS age
						ON age.age_codigo=ate.age_codigo
					  JOIN procedimento AS proc
						ON proc.proc_codigo_sus='0301010110'
					 LEFT JOIN cid10 AS cd10
						ON cd10.cd10_codigo=ate.cd10_codigo
					 WHERE ate.ate_codigo=NEW.ate_codigo LOOP
					 
				-- verificar ci
				IF linha.age_emergencia = 'S' THEN 
					SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Urgencia' AND ci_ativo='S' INTO ciCodigo;
				ELSE
					SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
				END IF;
		
				-- somente se h um sispn_codigo (FK com Pr-Natal)
				IF linha.sispn_codigo IS NOT NULL THEN
				
					-- procura na tabela bpa
					SELECT bpa_codigo 
					  FROM bpa
					 WHERE bpa_origem = 'atendimento'
					   AND bpa_origem_codigo = NEW.ate_codigo
					  INTO bpaCodigo;
					  
					INSERT INTO BPA (uni_codigo,
									 usr_codigo,
									 usu_codigo,
									 bpa_data,
									 proc_codigo,
									 ci_codigo,
									 bpa_tipo,
									 bpa_cd10_codigo, 
									 bpa_origem,
									 bpa_origem_codigo)
							 VALUES (linha.uni_codigo,
									 linha.med_codigo,
									 linha.usu_codigo,
									 linha.ate_data,
									 NEW.proc_codigo,
									 ciCodigo,
									 linha.proc_bpa_tipo,
									 NEW.cd10_codigo,
									 'atendimento',
									 NEW.ate_codigo);
					RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma insero na tabela ''atendimento'', informando um cdigo do ''sis pr-natal''.';				 
					
				END IF;

				
			END LOOP;
				
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION social.atetobpaup()
  OWNER TO postgres;

-- Function: social.itxtobap()

-- DROP FUNCTION social.itxtobap();

CREATE OR REPLACE FUNCTION social.itxtobap()
  RETURNS trigger AS
$BODY$DECLARE
  linha RECORD;
  bpaCodigo bigint;
  ciCodigo bigint;  
BEGIN

	FOR linha IN SELECT a.usu_codigo,
			       ai.med_codigo_coleta,
			       ci.proc_codigo,
			       p.proc_bpa_tipo,
			       p.proc_nome,
			       'P' as itx_urgente,
			       c.col_data_coleta,
			       ai.usr_codigo
			  FROM coleta c
			  join agenda_itens ai
			    on ai.agei_codigo = c.agei_codigo
			  join agenda a 
			    on a.age_codigo = ai.age_codigo
			  join convenio_itens ci
			    on ci.coni_codigo = ai.coni_codigo
			  join procedimento p
			    on p.proc_codigo = ci.proc_codigo
			 WHERE c.col_codigo=NEW.col_codigo LOOP	
		 SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
				
						-- Buscar se j foi feito um BPA
									
					SELECT bpa_codigo 
					  FROM bpa
					 WHERE bpa_origem = 'coleta'
					   AND bpa_origem_codigo = NEW.col_codigo
					  INTO bpaCodigo;
					  
						IF FOUND THEN					
							-- Atualiza BPA
							UPDATE bpa
							   SET med_codigo  = linha.med_codigo_coleta,
							       usr_codigo  = linha.usr_codigo,
								   usu_codigo  = linha.usu_codigo,
								   bpa_data    = linha.col_data_coleta,
								   proc_codigo = linha.proc_codigo,
								   ci_codigo = ciCodigo,
								   bpa_tipo = linha.proc_bpa_tipo
							 WHERE bpa_codigo = bpaCodigo;
							 RAISE NOTICE 'Um registro na tabela ''bpa'' foi atualizado devido uma alterao na tabela ''coleta''.';
						ELSE						
							-- Se no houver,  cria	   
							INSERT INTO BPA (med_codigo,
								 usr_codigo,
								 usu_codigo,
								 bpa_data,
								 proc_codigo,
								 ci_codigo,
								 bpa_tipo,
							  -- bpa_cd10_codigo, -- NULL
								 bpa_origem,
								 bpa_origem_codigo)
							VALUES (linha.med_codigo_coleta,
								 linha.usr_codigo,
								 linha.usu_codigo,
								 linha.col_data_coleta,
								 linha.proc_codigo,
								 ciCodigo,
								 linha.proc_bpa_tipo,
							  -- NEW.cd10_codigo,
								 'coleta',
								 NEW.col_codigo);
							RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma alterao na tabela ''coleta''.';				 
					END IF; -- status
				END LOOP;
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION social.itxtobap()
  OWNER TO postgres;
-- Function: social.itxtobpadel()

-- DROP FUNCTION social.itxtobpadel();

CREATE OR REPLACE FUNCTION social.itxtobpadel()
  RETURNS trigger AS
$BODY$
    
BEGIN

	DELETE FROM bpa WHERE bpa_origem='coleta' AND bpa_origem_codigo=OLD.col_codigo;
	RAISE NOTICE 'Um registro na tabela ''bpa'' foi deletado devido uma excluso na tabela ''coleta''.';
	RETURN OLD;
	
END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION social.itxtobpadel()
  OWNER TO postgres;
-- Function: social.pattobpa()

-- DROP FUNCTION social.pattobpa();

CREATE OR REPLACE FUNCTION social.pattobpa()
  RETURNS trigger AS
$BODY$
DECLARE
  linha RECORD;
  ci_codigo bigint;  
  codigo bigint; -- ate_codigo, pc_codigo ou pe_codigo
    
BEGIN

	-- Posto de Enfermagem?
	IF NEW.pe_codigo IS NOT NULL THEN
	
		 SELECT INTO linha
					 uni_codigo,
					 pat.usr_codigo,
					 usu_codigo,
					 ate_data AS bpa_data,
					 proc.proc_codigo,
					 proc_bpa_tipo AS bpa_tipo,
					 pat.cd10_codigo AS bpa_cd10_codigo,
					 'procedimento_atendimetno' AS bpa_origem,
					 pat.pat_codigo AS bpa_origem_codigo
			    FROM procedimento_atendimento AS pat
			    JOIN posto_enfermagem AS pe
				  ON pe.pe_codigo=pat.pe_codigo
			    JOIN atendimento AS ate
				  ON ate.ate_codigo=pe.ate_codigo
			    JOIN procedimento AS proc
				  ON proc.proc_codigo=pat.proc_codigo
			   WHERE pat.pat_codigo=NEW.pat_codigo;
			 
	-- Pr-consulta?
	ELSIF NEW.pc_codigo IS NOT NULL THEN
				
		 SELECT INTO linha
					 uni_codigo,
					 pat.usr_codigo,
					 age.usu_codigo,
					 age_data AS bpa_data,
					 proc.proc_codigo,
					 proc_bpa_tipo AS bpa_tipo,
					 pat.cd10_codigo AS bpa_cd10_codigo,
					 'procedimento_atendimetno' AS bpa_origem,
					 pat.pat_codigo AS bpa_origem_codigo
				FROM procedimento_atendimento AS pat
				JOIN pre_consulta AS pc
				  ON pc.pc_codigo=pat.pc_codigo
				JOIN agendamento AS age
				  ON age.age_codigo=pc.age_codigo
				JOIN procedimento AS proc
				  ON proc.proc_codigo=pat.proc_codigo
			   WHERE pat.pat_codigo=NEW.pat_codigo;
			  
	-- Atendimento?
	ELSIF NEW.ate_codigo IS NOT NULL THEN	
		SELECT INTO linha
					uni_codigo,
					pat.usr_codigo,
					ate.usu_codigo,
					ate_data AS bpa_data,
					proc.proc_codigo,
					proc_bpa_tipo AS bpa_tipo,
					pat.cd10_codigo AS bpa_cd10_codigo,
					'procedimento_atendimetno' AS bpa_origem,
					pat.pat_codigo AS bpa_origem_codigo
			   FROM procedimento_atendimento AS pat
			   JOIN atendimento AS ate
				 ON ate.ate_codigo=pat.ate_codigo
			   JOIN procedimento AS proc
				 ON proc.proc_codigo=pat.proc_codigo
			  WHERE pat.pat_codigo=NEW.pat_codigo;
			  
	END IF;					

	-- verificar acidente de trabalho
	SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ci_codigo;
	
	INSERT INTO BPA (uni_codigo,
					 usr_codigo,
					 usu_codigo,
					 bpa_data,
					 proc_codigo,
					 ci_codigo,
					 bpa_tipo,
					 bpa_cd10_codigo,
					 bpa_origem,
					 bpa_origem_codigo)
			 VALUES (linha.uni_codigo,
					 linha.usr_codigo,
					 linha.usu_codigo,
					 linha.bpa_data,
					 linha.proc_codigo,
					 ci_codigo,
					 linha.bpa_tipo,
					 linha.bpa_cd10_codigo,
					 'procedimento_atendimento',
					 NEW.pat_codigo);						
						
	RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma insero na tabela ''procedimento_atendimento''.';
				
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION social.pattobpa()
  OWNER TO postgres;
-- Function: social.pattobpadel()

-- DROP FUNCTION social.pattobpadel();

CREATE OR REPLACE FUNCTION social.pattobpadel()
  RETURNS trigger AS
$BODY$
    
BEGIN

	DELETE FROM bpa WHERE bpa_origem='procedimento_atendimento' AND bpa_origem_codigo=OLD.pat_codigo;
	RAISE NOTICE 'Um registro na tabela ''bpa'' foi deletado devido uma excluso na tabela ''procedimento_atendimento''.';
	RETURN OLD;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION social.pattobpadel()
  OWNER TO postgres;

-- Function: social.calcula_estoque_lote_validade(bigint, bigint, date, character varying, date)

-- DROP FUNCTION social.calcula_estoque_lote_validade(bigint, bigint, date, character varying, date);

CREATE OR REPLACE FUNCTION social.calcula_estoque_lote_validade(bigint, bigint, date, character varying, date)
  RETURNS numeric AS
$BODY$
DECLARE
    row RECORD;
    saldoini      numeric := 0;
    saldofinal    numeric := 0;    
    entradas      numeric := 0;        
    saidas        numeric := 0;        
    produto       integer := 0;
    setor         integer := 0;
    dataestoq     date;
    data_saldoini date;
    LOTE          varchar(20);
    validade      date;

BEGIN
    SETOR := $2;
    PRODUTO := $1;
    DATAESTOQ := $3;
    lote := $4;
    validade := $5;

    SELECT SUM(sal_qtde) INTO SALDOFINAL
      FROM saldo AS sal
     WHERE set_codigo=SETOR
       AND pro_codigo=PRODUTO
       AND sal_lote=lote
       AND sal_validade=validade;
      
       
    RETURN SALDOFINAL;
END; $BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION social.calcula_estoque_lote_validade(bigint, bigint, date, character varying, date)
  OWNER TO postgres;

-- Function: social.difference(text, text)

-- DROP FUNCTION social.difference(text, text);

CREATE OR REPLACE FUNCTION social.difference(text, text)
  RETURNS integer AS
'$libdir/fuzzystrmatch', 'difference'
  LANGUAGE c IMMUTABLE STRICT
  COST 1;
ALTER FUNCTION social.difference(text, text)
  OWNER TO postgres;

-- Function: social.dmetaphone(text)

-- DROP FUNCTION social.dmetaphone(text);

CREATE OR REPLACE FUNCTION social.dmetaphone(text)
  RETURNS text AS
'$libdir/fuzzystrmatch', 'dmetaphone'
  LANGUAGE c IMMUTABLE STRICT
  COST 1;
ALTER FUNCTION social.dmetaphone(text)
  OWNER TO postgres;
-- Function: social.dmetaphone_alt(text)

-- DROP FUNCTION social.dmetaphone_alt(text);

CREATE OR REPLACE FUNCTION social.dmetaphone_alt(text)
  RETURNS text AS
'$libdir/fuzzystrmatch', 'dmetaphone_alt'
  LANGUAGE c IMMUTABLE STRICT
  COST 1;
ALTER FUNCTION social.dmetaphone_alt(text)
  OWNER TO postgres;

  -- Function: social.levenshtein(text, text)

-- DROP FUNCTION social.levenshtein(text, text);

CREATE OR REPLACE FUNCTION social.levenshtein(text, text)
  RETURNS integer AS
'$libdir/fuzzystrmatch', 'levenshtein'
  LANGUAGE c IMMUTABLE STRICT
  COST 1;
ALTER FUNCTION social.levenshtein(text, text)
  OWNER TO postgres;
-- Function: social.levenshtein(text, text, integer, integer, integer)

-- DROP FUNCTION social.levenshtein(text, text, integer, integer, integer);

CREATE OR REPLACE FUNCTION social.levenshtein(text, text, integer, integer, integer)
  RETURNS integer AS
'$libdir/fuzzystrmatch', 'levenshtein_with_costs'
  LANGUAGE c IMMUTABLE STRICT
  COST 1;
ALTER FUNCTION social.levenshtein(text, text, integer, integer, integer)
  OWNER TO postgres;
-- Function: social.metaphone(text, integer)

-- DROP FUNCTION social.metaphone(text, integer);

CREATE OR REPLACE FUNCTION social.metaphone(text, integer)
  RETURNS text AS
'$libdir/fuzzystrmatch', 'metaphone'
  LANGUAGE c IMMUTABLE STRICT
  COST 1;
ALTER FUNCTION social.metaphone(text, integer)
  OWNER TO postgres;
-- Function: social.retira_acentos(text)

-- DROP FUNCTION social.retira_acentos(text);

CREATE OR REPLACE FUNCTION social.retira_acentos(text)
  RETURNS text AS
$BODY$
DECLARE a varchar;
BEGIN
  SELECT translate($1,
	 text '',
	 text 'AEIOUAEIOUAOAEIOUAEIOUCaeiouaeiouaoaeiooaeiouc') INTO a;
  RETURN a;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION social.retira_acentos(text)
  OWNER TO postgres;
-- Function: social.soundex(text)

-- DROP FUNCTION social.soundex(text);

CREATE OR REPLACE FUNCTION social.soundex(text)
  RETURNS text AS
'$libdir/fuzzystrmatch', 'soundex'
  LANGUAGE c IMMUTABLE STRICT
  COST 1;
ALTER FUNCTION social.soundex(text)
  OWNER TO postgres;
-- Function: social.text_soundex(text)

-- DROP FUNCTION social.text_soundex(text);

CREATE OR REPLACE FUNCTION social.text_soundex(text)
  RETURNS text AS
'$libdir/fuzzystrmatch', 'soundex'
  LANGUAGE c IMMUTABLE STRICT
  COST 1;
ALTER FUNCTION social.text_soundex(text)
  OWNER TO postgres;
CREATE OR REPLACE FUNCTION bytea_import(IN p_path text, OUT p_result bytea)
 RETURNS bytea AS
$BODY$
declare
 l_oid oid;
 r record;
begin
 p_result := '';
 select lo_import(p_path) into l_oid;
 for r in ( select data 
            from pg_largeobject 
            where loid = l_oid 
            order by pageno ) loop
   p_result = p_result || r.data;
 end loop;
 perform lo_unlink(l_oid);
end;$BODY$
 LANGUAGE plpgsql VOLATILE
 COST 100;
ALTER FUNCTION bytea_import(text)
 OWNER TO postgres; 
 
 DROP SCHEMA public cascade;
 
 CREATE SEQUENCE social.seq_dom_codigo;

 
 ALTER TABLE domicilio
   ALTER COLUMN dom_codigo SET DEFAULT nextval(('seq_dom_codigo'::text)::regclass);
ALTER TABLE domicilio
  DROP CONSTRAINT fk_domicilio_rua;
ALTER TABLE domicilio
  DROP CONSTRAINT fk_domicilio_tb_ms_tipo_domicilio;
ALTER TABLE domicilio
  ADD CONSTRAINT fk_domicilio_rua FOREIGN KEY (rua_codigo)
      REFERENCES rua (rua_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE domicilio
  ADD CONSTRAINT fk_domicilio_tb_ms_tipo_domicilio FOREIGN KEY (co_tipo_domicilio)
      REFERENCES tb_ms_tipo_domicilio (co_tipo_domicilio) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION;

