

CREATE SCHEMA social;



CREATE TABLE tuberculose (
    tub_codigo bigint NOT NULL,
    usu_codigo integer NOT NULL,
    enf_codigo integer,
    med_codigo integer,
    tub_data_cadastro date NOT NULL,
    tub_nome_investigador character varying(50),
    tub_tratamento_supervisionado character(1),
    tub_drogas character(1),
    tub_status character(1)
);


--
-- TOC entry 144 (class 1259 OID 279751)
-- Dependencies: 143 7
-- Name: Tuberculose_tub_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE "Tuberculose_tub_codigo_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social."Tuberculose_tub_codigo_seq" OWNER TO postgres;

--
-- TOC entry 5155 (class 0 OID 0)
-- Dependencies: 144
-- Name: Tuberculose_tub_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE "Tuberculose_tub_codigo_seq" OWNED BY tuberculose.tub_codigo;


--
-- TOC entry 5156 (class 0 OID 0)
-- Dependencies: 144
-- Name: Tuberculose_tub_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('"Tuberculose_tub_codigo_seq"', 1, false);


--
-- TOC entry 145 (class 1259 OID 279753)
-- Dependencies: 3444 7
-- Name: age_tipo; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE age_tipo (
    agetipo_codigo bigint DEFAULT nextval(('seq_agetipo_codigo'::text)::regclass) NOT NULL,
    agetipo_desc character varying(40) NOT NULL,
    age_descricao character varying(255)
);


ALTER TABLE social.age_tipo OWNER TO postgres;

--
-- TOC entry 146 (class 1259 OID 279757)
-- Dependencies: 3446 7
-- Name: agenda; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE agenda (
    age_codigo bigint NOT NULL,
    usu_codigo bigint,
    usr_codigo integer,
    usr_data_insert timestamp without time zone,
    med_codigo bigint,
    ate_codigo bigint,
    usr_codigo_medico bigint,
    age_status character(1) DEFAULT 'A'::bpchar NOT NULL,
    age_data_insert timestamp with time zone
);


ALTER TABLE social.agenda OWNER TO postgres;

--
-- TOC entry 147 (class 1259 OID 279761)
-- Dependencies: 146 7
-- Name: agenda_age_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE agenda_age_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.agenda_age_codigo_seq OWNER TO postgres;

--
-- TOC entry 5158 (class 0 OID 0)
-- Dependencies: 147
-- Name: agenda_age_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE agenda_age_codigo_seq OWNED BY agenda.age_codigo;


--
-- TOC entry 5159 (class 0 OID 0)
-- Dependencies: 147
-- Name: agenda_age_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('agenda_age_codigo_seq', 168, true);


--
-- TOC entry 148 (class 1259 OID 279763)
-- Dependencies: 3448 7
-- Name: agenda_itens; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE agenda_itens (
    agei_codigo bigint NOT NULL,
    age_codigo bigint,
    agei_data date,
    agei_hora time without time zone,
    coni_codigo bigint,
    agei_valor double precision,
    usr_codigo bigint,
    agei_status character(1) DEFAULT 'A'::bpchar,
    med_codigo_coleta bigint,
    uni_codigo_coleta bigint
);


ALTER TABLE social.agenda_itens OWNER TO postgres;

--
-- TOC entry 5160 (class 0 OID 0)
-- Dependencies: 148
-- Name: COLUMN agenda_itens.agei_status; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN agenda_itens.agei_status IS 'A - Agendado
R - Recepsionado
F - Falta
C - Cancelado
T - Transferncia';


--
-- TOC entry 149 (class 1259 OID 279767)
-- Dependencies: 148 7
-- Name: agenda_itens_agei_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE agenda_itens_agei_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.agenda_itens_agei_codigo_seq OWNER TO postgres;

--
-- TOC entry 5161 (class 0 OID 0)
-- Dependencies: 149
-- Name: agenda_itens_agei_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE agenda_itens_agei_codigo_seq OWNED BY agenda_itens.agei_codigo;


--
-- TOC entry 5162 (class 0 OID 0)
-- Dependencies: 149
-- Name: agenda_itens_agei_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('agenda_itens_agei_codigo_seq', 439, true);


--
-- TOC entry 150 (class 1259 OID 279769)
-- Dependencies: 3449 3450 3451 3452 3453 3454 3455 7
-- Name: agendamento; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE agendamento (
    age_codigo bigint DEFAULT nextval(('seq_age_codigo'::text)::regclass) NOT NULL,
    age_data date NOT NULL,
    med_codigo bigint NOT NULL,
    age_hora character varying(5),
    usu_codigo bigint,
    age_tipo character varying(2),
    age_atendido character(1) DEFAULT 'N'::bpchar,
    age_paciente character varying(60),
    uni_codigo bigint NOT NULL,
    age_item character(2),
    age_status character(1),
    esp_codigo bigint,
    age_valor_proc numeric(9,2) DEFAULT 0,
    agt_codigo bigint,
    usr_codigo_alt bigint,
    usr_codigo_cad bigint,
    dt_cadastro timestamp without time zone DEFAULT now(),
    age_item2 character varying(2),
    dt_atualizacao timestamp with time zone DEFAULT now(),
    age_data_atend timestamp without time zone,
    age_falta_medico character(1),
    age_emergencia character(1) DEFAULT 'N'::bpchar,
    age_timestamp timestamp without time zone,
    proc_codigo_sus character varying(10),
    age_ordem integer DEFAULT 0 NOT NULL
);


ALTER TABLE social.agendamento OWNER TO postgres;

--
-- TOC entry 5163 (class 0 OID 0)
-- Dependencies: 150
-- Name: COLUMN agendamento.age_tipo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN agendamento.age_tipo IS 'ES - ESPECIALIDADE
CB - CLINICA BASICA';


--
-- TOC entry 5164 (class 0 OID 0)
-- Dependencies: 150
-- Name: COLUMN agendamento.age_atendido; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN agendamento.age_atendido IS 'S - Recepcionado
A - Atendido
N - Agendado
T - Transferido
F - Faltoso';


--
-- TOC entry 151 (class 1259 OID 279779)
-- Dependencies: 3456 3457 3458 7
-- Name: agendamento_exame; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE agendamento_exame (
    agex_codigo bigint NOT NULL,
    usu_codigo bigint,
    agex_data_cad timestamp without time zone,
    agex_status character(1) DEFAULT 'A'::bpchar,
    med_codigo_responsavel bigint DEFAULT 0,
    esp_codigo_responsavel bigint DEFAULT 0,
    agt_codigo bigint,
    cod_controle character(50)
);


ALTER TABLE social.agendamento_exame OWNER TO postgres;

--
-- TOC entry 152 (class 1259 OID 279785)
-- Dependencies: 151 7
-- Name: agendamento_exame_agex_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE agendamento_exame_agex_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.agendamento_exame_agex_codigo_seq OWNER TO postgres;

--
-- TOC entry 5167 (class 0 OID 0)
-- Dependencies: 152
-- Name: agendamento_exame_agex_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE agendamento_exame_agex_codigo_seq OWNED BY agendamento_exame.agex_codigo;


--
-- TOC entry 5168 (class 0 OID 0)
-- Dependencies: 152
-- Name: agendamento_exame_agex_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('agendamento_exame_agex_codigo_seq', 1395, true);


--
-- TOC entry 153 (class 1259 OID 279787)
-- Dependencies: 7
-- Name: agendamento_exame_lista; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE agendamento_exame_lista (
    agexl_codigo bigint NOT NULL,
    agex_codigo bigint,
    usu_codigo bigint,
    med_codigo bigint NOT NULL,
    proc_codigo bigint,
    agexl_data date NOT NULL,
    agexl_hora character varying(5),
    agexl_status character(1),
    usr_codigo_alt bigint,
    usr_codigo_cad bigint,
    agexl_dt_cadastro date,
    agexl_dt_atualizacao timestamp without time zone,
    agexl_status_time timestamp without time zone,
    uni_codigo bigint,
    req_codigo bigint
);


ALTER TABLE social.agendamento_exame_lista OWNER TO postgres;

--
-- TOC entry 154 (class 1259 OID 279790)
-- Dependencies: 153 7
-- Name: agendamento_exame_lista_agexl_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE agendamento_exame_lista_agexl_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.agendamento_exame_lista_agexl_codigo_seq OWNER TO postgres;

--
-- TOC entry 5170 (class 0 OID 0)
-- Dependencies: 154
-- Name: agendamento_exame_lista_agexl_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE agendamento_exame_lista_agexl_codigo_seq OWNED BY agendamento_exame_lista.agexl_codigo;


--
-- TOC entry 5171 (class 0 OID 0)
-- Dependencies: 154
-- Name: agendamento_exame_lista_agexl_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('agendamento_exame_lista_agexl_codigo_seq', 6085, true);


--
-- TOC entry 155 (class 1259 OID 279792)
-- Dependencies: 3461 3462 3463 7
-- Name: agendamento_excluido; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE agendamento_excluido (
    age_codigo bigint DEFAULT nextval(('seq_age_codigo'::text)::regclass) NOT NULL,
    age_data date NOT NULL,
    med_codigo bigint NOT NULL,
    age_hora character varying(5),
    usu_codigo bigint,
    age_tipo character varying(2),
    age_atendido character(1) DEFAULT 'N'::bpchar,
    age_paciente character varying(60),
    uni_codigo bigint NOT NULL,
    age_item character(2),
    age_status character(1),
    esp_codigo bigint,
    age_valor_proc numeric(9,2) DEFAULT 0,
    agt_codigo bigint,
    usr_codigo_alt bigint,
    usr_codigo_cad bigint,
    dt_cadastro timestamp without time zone,
    age_item2 character varying(2),
    dt_atualizacao date,
    age_data_atend timestamp without time zone,
    age_falta_medico character(1),
    age_timestamp timestamp without time zone,
    usr_codigo_exc bigint,
    age_data_exc timestamp without time zone,
    age_observacao text NOT NULL
);


ALTER TABLE social.agendamento_excluido OWNER TO postgres;

--
-- TOC entry 156 (class 1259 OID 279801)
-- Dependencies: 3465 7
-- Name: agendamento_externo; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE agendamento_externo (
    agee_codigo bigint NOT NULL,
    usu_codigo bigint NOT NULL,
    esp_codigo bigint NOT NULL,
    med_codigo bigint,
    proc_codigo bigint,
    usr_codigo_solicitante bigint,
    usr_codigo bigint NOT NULL,
    med_codigo_prestador bigint,
    agee_data date,
    agee_hora character(5),
    agee_valor numeric(10,2),
    agee_observacao text,
    agee_situacao integer,
    agee_data_cad date DEFAULT ('now'::text)::date NOT NULL,
    agee_hora_cad character(5) NOT NULL,
    uni_codigo bigint NOT NULL,
    med_codigo_solicitante bigint,
    agee_num_reg character varying(20)
);


ALTER TABLE social.agendamento_externo OWNER TO postgres;

--
-- TOC entry 5172 (class 0 OID 0)
-- Dependencies: 156
-- Name: COLUMN agendamento_externo.med_codigo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN agendamento_externo.med_codigo IS 'Mdico (externo) para onde o paciente est sendo encaminhado.';


--
-- TOC entry 5173 (class 0 OID 0)
-- Dependencies: 156
-- Name: COLUMN agendamento_externo.proc_codigo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN agendamento_externo.proc_codigo IS 'agravo';


--
-- TOC entry 5174 (class 0 OID 0)
-- Dependencies: 156
-- Name: COLUMN agendamento_externo.usr_codigo_solicitante; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN agendamento_externo.usr_codigo_solicitante IS 'Mdico (usr) que pediu o encaminhamento';


--
-- TOC entry 5175 (class 0 OID 0)
-- Dependencies: 156
-- Name: COLUMN agendamento_externo.usr_codigo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN agendamento_externo.usr_codigo IS 'Usurio que registrou o encaminhamento externo';


--
-- TOC entry 5176 (class 0 OID 0)
-- Dependencies: 156
-- Name: COLUMN agendamento_externo.med_codigo_prestador; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN agendamento_externo.med_codigo_prestador IS 'Prestador de servio (med_codigo)';


--
-- TOC entry 157 (class 1259 OID 279808)
-- Dependencies: 156 7
-- Name: agendamento_externo_agee_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE agendamento_externo_agee_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.agendamento_externo_agee_codigo_seq OWNER TO postgres;

--
-- TOC entry 5177 (class 0 OID 0)
-- Dependencies: 157
-- Name: agendamento_externo_agee_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE agendamento_externo_agee_codigo_seq OWNED BY agendamento_externo.agee_codigo;


--
-- TOC entry 5178 (class 0 OID 0)
-- Dependencies: 157
-- Name: agendamento_externo_agee_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('agendamento_externo_agee_codigo_seq', 1, true);


--
-- TOC entry 158 (class 1259 OID 279810)
-- Dependencies: 3466 3467 3468 7
-- Name: agendamento_teste; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE agendamento_teste (
    age_codigo bigint DEFAULT nextval(('seq_age_codigo'::text)::regclass) NOT NULL,
    age_data date NOT NULL,
    med_codigo bigint NOT NULL,
    age_hora character varying(5),
    usu_codigo bigint,
    age_tipo character varying(2),
    age_atendido character(1) DEFAULT 'N'::bpchar,
    age_paciente character varying(60),
    uni_codigo bigint NOT NULL,
    age_item character(2),
    age_timestamp bigint,
    age_status character(1),
    usr_codigo bigint,
    esp_codigo bigint,
    age_valor_proc numeric(9,2) DEFAULT 0,
    agt_codigo bigint
);


ALTER TABLE social.agendamento_teste OWNER TO postgres;

--
-- TOC entry 159 (class 1259 OID 279816)
-- Dependencies: 7
-- Name: aih; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE aih (
    aih_codigo bigint NOT NULL,
    med_codigo_solicitante bigint,
    aih_cnes_soli bigint,
    usr_codigo bigint,
    aih_dataini date,
    aih_data_alta date,
    aih_principais_sintomas text,
    aih_justificativa_internacao text,
    aih_principais_resultados text,
    aih_diag_ini character varying(255),
    aih_clinica character varying(100),
    aih_ci bigint,
    aih_tipo_doc_proc_soli character(3),
    aih_n_doc_prof_solicitante character varying(50),
    aih_data_solicitacao date,
    aih_vinculo_previdencia character varying(20),
    aih_tipo_doc_autorizacao character(3),
    aih_n_doc_prof_autorizador character varying(50),
    aih_data_autorizacao date,
    aih_numero_aih character varying(99),
    aih_segunda_via character(1),
    pac_aih_codigo bigint,
    usu_codigo bigint,
    aih_tipo_acidente character varying(100),
    aih_cnpj_seguradora bigint,
    aih_n_bilhete bigint,
    aih_serie character varying(100),
    aih_cnpj_da_empresa bigint,
    aih_cnae_da_empresa bigint,
    aih_mes_compet smallint,
    aih_ano_compet integer,
    aih_ativo character(1),
    aih_dt_cadastro date,
    aih_alteradopor smallint,
    aih_observacao text,
    aih_cadastrado_por bigint,
    aih_prontuario_hospital character varying(50),
    med_solicitante_proc bigint,
    med_autorizador bigint,
    aih_cid_cod_princ bigint,
    aih_cid_cod_secun bigint,
    aih_cid_cod_terc bigint,
    aih_desc_proc_soli bigint
);


ALTER TABLE social.aih OWNER TO postgres;

--
-- TOC entry 160 (class 1259 OID 279822)
-- Dependencies: 3470 3471 7
-- Name: apac; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE apac (
    apac_codigo bigint NOT NULL,
    pac_codigo bigint,
    pac_apac_codigo bigint,
    uni_sol_codigo bigint,
    uni_sol_apac_codigo bigint,
    med_sol_codigo bigint,
    med_sol_apac_codigo bigint,
    orgao_codigo bigint,
    orgao_apac_codigo bigint,
    uni_pres_codigo bigint,
    uni_pres_apac_codigo bigint,
    med_aud_codigo bigint,
    med_aud_apac_codigo bigint,
    cd10_codigo bigint,
    apac_periodo_validade date,
    apac_convenio character(1),
    apac_convenio_nome character varying(200),
    apac_hipotese character varying(200),
    apac_resumo_exame_fisico text,
    apac_segunda_via character(1) DEFAULT 'N'::bpchar,
    apac_periodo_validade_fim date,
    apac_mes_competencia integer,
    apac_ano_competencia integer,
    apac_dt_cadastro date DEFAULT ('now'::text)::date,
    apac_num character varying(99)
);


ALTER TABLE social.apac OWNER TO postgres;

--
-- TOC entry 161 (class 1259 OID 279830)
-- Dependencies: 7
-- Name: apac_procedimento; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE apac_procedimento (
    apac_codigo bigint,
    proc_codigo bigint,
    proc_apac_codigo bigint
);


ALTER TABLE social.apac_procedimento OWNER TO postgres;

--
-- TOC entry 162 (class 1259 OID 279833)
-- Dependencies: 3473 3474 3475 3476 7
-- Name: especialidade; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE especialidade (
    esp_codigo bigint DEFAULT nextval(('seq_esp_codigo'::text)::regclass) NOT NULL,
    esp_nome character varying(255) NOT NULL,
    esp_agend_antecipado character(1) DEFAULT 'N'::bpchar,
    proc_codigo bigint,
    esp_custo numeric(9,4),
    cod_cbo character varying(20),
    esp_tipo character varying(1),
    esp_pre_consulta boolean DEFAULT true NOT NULL,
    esp_encaminhamento boolean DEFAULT false NOT NULL
);


ALTER TABLE social.especialidade OWNER TO postgres;

--
-- TOC entry 163 (class 1259 OID 279840)
-- Dependencies: 3477 3478 3479 3480 3481 3482 3483 3484 7
-- Name: itens_movimento; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE itens_movimento (
    ite_codigo bigint DEFAULT nextval(('seq_ite_codigo'::text)::regclass) NOT NULL,
    mov_codigo bigint NOT NULL,
    pro_codigo bigint NOT NULL,
    ite_vlrdesc real,
    ite_lote character varying(20) DEFAULT 'SEM_LOTE'::character varying,
    ite_validade date DEFAULT '2900-12-31'::date,
    usr_codigo bigint,
    ite_timestamp bigint,
    ite_ip character varying(15),
    ite_status character(1) DEFAULT 'A'::bpchar NOT NULL,
    ite_quantidade numeric(20,4),
    ite_consolidado character(1) DEFAULT 'N'::bpchar NOT NULL,
    ite_vlrunit numeric(20,4),
    ite_qtde_solicitada numeric(20,4),
    ite_posologia text,
    ite_detalhes_tratamento text,
    ite_observacoes text,
    ite_qtde_dia bigint,
    ite_vlrtotal numeric(20,2) DEFAULT 0.0,
    ite_lote_bkp character varying(20),
    ite_validade_bkp date,
    ite_dose integer DEFAULT 1 NOT NULL,
    ite_dose_lote integer DEFAULT 1 NOT NULL
);


ALTER TABLE social.itens_movimento OWNER TO postgres;

--
-- TOC entry 5179 (class 0 OID 0)
-- Dependencies: 163
-- Name: TABLE itens_movimento; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON TABLE itens_movimento IS 'CUIDADO!
Ao fazer UPDATE, INSERT ou DELETE nesta tabela, disparar um TRIGGER que atualizar a tabela saude.saldo (estoque).
Caso a inteno no seja alterar a quantidade em estoque, por precauo, desabilite o TRIGGER correspondente  operao que ser realizada!';


--
-- TOC entry 5180 (class 0 OID 0)
-- Dependencies: 163
-- Name: COLUMN itens_movimento.ite_lote; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN itens_movimento.ite_lote IS 'Para produtos marcados como no possui validade (tabela produto, campo pro_validade = ''N'') o LOTE deve ser SEM_LOTE';


--
-- TOC entry 5181 (class 0 OID 0)
-- Dependencies: 163
-- Name: COLUMN itens_movimento.ite_validade; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN itens_movimento.ite_validade IS 'Para produtos marcados como no possui validade (tabela produto, campo pro_validade = ''N'') a VALIDADE deve ser 31/12/2900';


--
-- TOC entry 5182 (class 0 OID 0)
-- Dependencies: 163
-- Name: COLUMN itens_movimento.ite_consolidado; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN itens_movimento.ite_consolidado IS 'S - SIM
N - NAO';


--
-- TOC entry 5183 (class 0 OID 0)
-- Dependencies: 163
-- Name: COLUMN itens_movimento.ite_lote_bkp; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN itens_movimento.ite_lote_bkp IS 'Campo para armazenar o ite_lote do movimento para segurana.';


--
-- TOC entry 5184 (class 0 OID 0)
-- Dependencies: 163
-- Name: COLUMN itens_movimento.ite_validade_bkp; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN itens_movimento.ite_validade_bkp IS 'Campo para armazenar a data de validade para bkp.';


--
-- TOC entry 164 (class 1259 OID 279854)
-- Dependencies: 3485 3486 3487 7
-- Name: medico; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE medico (
    med_codigo bigint DEFAULT nextval(('seq_med_codigo'::text)::regclass) NOT NULL,
    med_crm character varying(10) NOT NULL,
    med_nome character varying(60) NOT NULL,
    uf_codigo_crm bigint NOT NULL,
    med_email character varying(100),
    med_endereco character varying(200),
    cid_codigo bigint,
    med_cpf character varying(11),
    med_rg character varying(15),
    prestador_servico character(1) DEFAULT 'N'::bpchar,
    gex_tipo character(1),
    med_cnes bigint,
    med_tipo_prestador character(2),
    med_cnpj character varying(20),
    med_end_numero character(10),
    med_end_complemento character varying(50),
    med_end_bairro character varying(30),
    med_end_cep character varying(10),
    med_end_telefone character varying(14),
    med_end_celular character varying(14),
    med_vinculo character varying(20),
    med_carga_horaria character varying(5),
    med_nome_fantasia character varying(60),
    med_mantenedora character varying(60),
    med_regional character varying(60),
    logra_codigo bigint,
    proc_tipo_manut smallint DEFAULT 1 NOT NULL,
    rua_codigo bigint,
    med_tipoagendamento character varying(1),
    logra_codigo_res integer,
    med_endereco_res character(200),
    med_end_numero_res character(200),
    med_end_complemento_res character(200),
    med_end_bairro_res character(200),
    med_end_cep_res character(200),
    med_end_telefone_res character(200),
    med_banco character(200),
    med_agencia character(200),
    med_tp_conta character(200),
    med_conta_nro character(100),
    quota_qtde character(1),
    cnes bigint,
    med_matricula character varying(20),
    med_validade_lib timestamp without time zone
);


ALTER TABLE social.medico OWNER TO postgres;

--
-- TOC entry 5186 (class 0 OID 0)
-- Dependencies: 164
-- Name: COLUMN medico.proc_tipo_manut; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN medico.proc_tipo_manut IS '
(1) Unitrio: manutencao da agenda eh feita somente pelos procedimentos do Laboratorio
(2) Por periodo: a manutencao da agenda eh feita por periodo';


--
-- TOC entry 5187 (class 0 OID 0)
-- Dependencies: 164
-- Name: COLUMN medico.med_tipoagendamento; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN medico.med_tipoagendamento IS 'Q - Controle de exames por quantidade de procedimentos
V - Controle de exames por valor
P - Controle de exames por paciente
D - Controle de exames por demanda';


--
-- TOC entry 165 (class 1259 OID 279863)
-- Dependencies: 3488 7
-- Name: movimento; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE movimento (
    mov_codigo bigint DEFAULT nextval(('seq_mov_codigo'::text)::regclass) NOT NULL,
    mov_data date NOT NULL,
    mov_tipo character(1) NOT NULL,
    for_codigo bigint,
    usu_codigo bigint,
    mov_desconto real,
    mov_observacao text,
    cond_codigo bigint,
    ate_codigo bigint,
    set_entrada bigint,
    set_saida bigint,
    mov_nr_nota character varying(15),
    mov_dt_nota date,
    usr_codigo bigint,
    mov_ip character varying(15),
    mov_total_nota numeric(15,2),
    mov_data_inclusao date,
    mov_entrada character(1),
    mov_saida character(1),
    mov_acrescimo real,
    mov_tipo_acrescimo character varying(60),
    inv_codigo bigint,
    mov_num_receita bigint,
    gru_codigo bigint,
    age_codigo bigint,
    mov_requisitante character varying(200),
    req_codigo bigint,
    usr_codigo_responsavel bigint,
    eve_codigo bigint,
    med_codigo_interno bigint,
    med_codigo_externo bigint
);


ALTER TABLE social.movimento OWNER TO postgres;

--
-- TOC entry 5189 (class 0 OID 0)
-- Dependencies: 165
-- Name: COLUMN movimento.mov_tipo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN movimento.mov_tipo IS 'E - Entrada
S - Saida
T - Transferencia';


--
-- TOC entry 5190 (class 0 OID 0)
-- Dependencies: 165
-- Name: COLUMN movimento.mov_entrada; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN movimento.mov_entrada IS 'E - ENTRADA NORMAL
A - ENTRADA POR AJUSTE
M - ENTRADA POR EMPRESTIMO
I - ENTRADA POR INVENTARIO
D - ENTRADA POR DOACAO
P - ENTRADA POR PERMUTA
O - OUTRAS ENTRADAS
T - TRANSFERENCIA
V - DEVOLUCAO DE SETORES


';


--
-- TOC entry 5191 (class 0 OID 0)
-- Dependencies: 165
-- Name: COLUMN movimento.mov_saida; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN movimento.mov_saida IS 'S - SAIDA POR CONSUMO
D - DISPENSACAO PARA PACIENTE
M - SAIDA POR EMPRESTIMO
P - SAIDA POR PERMUTA
I - SAIDA POR INVENTARIO
A - SAIDA POR AJUSTE
R - SAIDA POR PERDAS
O - OUTRAS SAIDAS
T - TRANSFERENCIA';


--
-- TOC entry 5192 (class 0 OID 0)
-- Dependencies: 165
-- Name: COLUMN movimento.age_codigo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN movimento.age_codigo IS 'Codigo do agendamento qdo o paciente nao tiver a receita realizada atravs de um atendimento';


--
-- TOC entry 5193 (class 0 OID 0)
-- Dependencies: 165
-- Name: COLUMN movimento.med_codigo_interno; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN movimento.med_codigo_interno IS 'Esta coluna representa o mdico (cdigo de usurio do sistema) que solicitou o medicamento.  informado no momento da dispensao.';


--
-- TOC entry 5194 (class 0 OID 0)
-- Dependencies: 165
-- Name: COLUMN movimento.med_codigo_externo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN movimento.med_codigo_externo IS 'Esta coluna representa o mdico (cdigo de mdico externo - medico.prestador_servico = ''N'') que solicitou o medicamento.  informado no momento da dispensao.';


--
-- TOC entry 166 (class 1259 OID 279870)
-- Dependencies: 3489 3490 3491 3492 3493 7
-- Name: procedimento; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE procedimento (
    proc_codigo bigint DEFAULT nextval(('seq_proc_codigo'::text)::regclass) NOT NULL,
    proc_nome character varying(255) NOT NULL,
    proc_classificacao_amb character varying(15),
    proc_classificacao_sus character varying(15),
    proc_exame character(1) DEFAULT 'N'::bpchar,
    proc_valor numeric(9,2),
    gex_tipo character(1),
    med_codigo bigint,
    proc_valor_custo numeric(9,2),
    proc_intervalo_min integer DEFAULT 0,
    proc_val11 numeric(9,2),
    proc_val12 numeric(9,2),
    proc_val13 numeric(9,2),
    proc_tempo smallint,
    proc_ptosato smallint,
    proc_ptosanest smallint,
    proc_versao smallint,
    proc_result character varying(255),
    proc_adperm smallint,
    proc_grupo bigint,
    proc_sexo smallint,
    proc_idade_minima smallint,
    proc_idade_maxima smallint,
    proc_sipac character(1),
    proc_qtdemaxima bigint,
    proc_qtdedias bigint,
    proc_vlsh numeric(9,2),
    proc_vlsa numeric(9,2),
    proc_vlsp numeric(9,2),
    proc_qtdepontos bigint,
    proc_sexo_novo character(1),
    proc_cofinan character(2),
    proc_corubrica character(6),
    proc_competencia character varying(6),
    proc_complexidade character(1),
    proc_instrucoes character varying(250),
    proc_ativo character(1),
    proc_codigo_sus character varying(10),
    proc_dtcompetencia date,
    proc_tipo_codigo bigint,
    proc_bpa_tipo character(1) DEFAULT 'C'::bpchar NOT NULL,
    proc_cadastrado_manualmente boolean DEFAULT false NOT NULL
);


ALTER TABLE social.procedimento OWNER TO postgres;

--
-- TOC entry 5196 (class 0 OID 0)
-- Dependencies: 166
-- Name: COLUMN procedimento.proc_intervalo_min; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN procedimento.proc_intervalo_min IS 'intervalo mnimo
de dias entre dois exames';


--
-- TOC entry 5197 (class 0 OID 0)
-- Dependencies: 166
-- Name: COLUMN procedimento.proc_instrucoes; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN procedimento.proc_instrucoes IS 'Instrucoes que devem ser passadas ao paciente no momento da requisicao do exame';


--
-- TOC entry 167 (class 1259 OID 279881)
-- Dependencies: 3494 3495 7
-- Name: produto; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE produto (
    pro_codigo bigint DEFAULT nextval(('seq_pro_codigo'::text)::regclass) NOT NULL,
    gru_codigo bigint NOT NULL,
    pro_nome character varying(255) NOT NULL,
    pro_unidade character varying(3),
    pro_barcode character varying(15),
    pro_custo real,
    pro_embalagem character varying(60),
    pro_descricao_tecnica text,
    pro_observacao character varying(300),
    pro_codpro character varying(13),
    pro_saida character(1) NOT NULL,
    pro_entrada character(1) NOT NULL,
    pro_emprestimo character(1),
    pro_dispensacao character(1) NOT NULL,
    pro_transferencia character(1),
    pro_tipo character(1),
    psico_codigo bigint,
    umed_codigo bigint,
    pro_situacao character(1),
    pro_validade character(1) DEFAULT 'N'::bpchar,
    pro_fracionado character varying(1),
    pro_bula text
);


ALTER TABLE social.produto OWNER TO postgres;

--
-- TOC entry 5199 (class 0 OID 0)
-- Dependencies: 167
-- Name: COLUMN produto.pro_custo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN produto.pro_custo IS 'custo inicial do produto';


--
-- TOC entry 5200 (class 0 OID 0)
-- Dependencies: 167
-- Name: COLUMN produto.pro_tipo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN produto.pro_tipo IS 'M - MEDICAMENTOS
T - MATERIAL HOSPITALAR
D - PRODUTO DE CONSUMO - DIVERSOS';


--
-- TOC entry 5201 (class 0 OID 0)
-- Dependencies: 167
-- Name: COLUMN produto.pro_situacao; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN produto.pro_situacao IS 'A - ativo
I - inativo';


--
-- TOC entry 5202 (class 0 OID 0)
-- Dependencies: 167
-- Name: COLUMN produto.pro_validade; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN produto.pro_validade IS 'S - Possui Lote e Validade
N - No possui Lote e Validade';


--
-- TOC entry 168 (class 1259 OID 279889)
-- Dependencies: 3496 3497 3498 7
-- Name: unidade; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE unidade (
    uni_codigo bigint DEFAULT nextval(('seq_uni_codigo'::text)::regclass) NOT NULL,
    uni_desc character varying(60) NOT NULL,
    uni_endereco character varying(60),
    uni_responsavel character varying(60),
    uni_movimenta_estoque character(1) DEFAULT 'N'::bpchar,
    uni_cnpj character varying(25),
    uni_tipo character(1) DEFAULT 'U'::bpchar,
    uni_cnes character varying(20),
    uni_numero character varying(5),
    uni_cep character varying(9),
    uni_codigo_ibge character varying(20)
);


ALTER TABLE social.unidade OWNER TO postgres;

--
-- TOC entry 5204 (class 0 OID 0)
-- Dependencies: 168
-- Name: COLUMN unidade.uni_tipo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN unidade.uni_tipo IS 'U : Unidade Normal
L: Localizacao do Prontuario';


--
-- TOC entry 169 (class 1259 OID 279895)
-- Dependencies: 3499 3500 3501 3502 3503 3504 3505 3506 3507 3508 3509 7
-- Name: usuario; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE usuario (
    usu_codigo bigint DEFAULT nextval(('seq_usu_codigo'::text)::regclass) NOT NULL,
    usu_nome character varying(60) NOT NULL,
    fam_codigo bigint,
    usu_observacao text,
    usu_sexo character(1) NOT NULL,
    usu_datanasc date,
    cid_codigo_nasc bigint,
    usu_dt_entrada_pais date,
    usu_sit_familiar character varying(2),
    usu_ocupacao character varying(30),
    usu_cbo_r1 integer,
    usu_pis_pasep character varying(20),
    usu_cpf character varying(15),
    usu_cartao_p_sus character varying(15),
    usu_cartao_sus character varying(30),
    usu_tipo_certidao integer,
    usu_cert_cartorio character varying(60),
    usu_cert_livro character varying(10),
    usu_cert_termo character varying(10),
    usu_cert_emissao date,
    usu_rg character varying(15),
    usu_rg_compl character varying(10),
    usu_rg_dt_emissao date,
    usu_ctps character varying(10),
    usu_ctps_serie character varying(7),
    usu_ctps_dt_emissao date,
    usu_tit_eleitor character varying(14),
    usu_tit_eleitor_zona character varying(4),
    usu_tit_eleitor_secao character varying(4),
    usu_mae character varying(60),
    usu_pai character varying(60),
    rac_codigo character varying(2),
    usu_cisvir character varying(15),
    usu_end_rua character varying(60),
    usu_end_nr character varying(5),
    usu_end_compl character varying(20),
    usu_end_bairro character varying(30),
    usu_end_cep character varying(9),
    usu_end_cidade character varying(60),
    usu_cidade_nasc character varying(60),
    usu_fone character varying(15),
    usu_celular character varying(15),
    usu_same character varying(15),
    usu_prontuario character varying(15) DEFAULT nextval(('seq_prontuario'::text)::regclass),
    uni_origem bigint,
    usu_freq_escolar character(1),
    uni_unidade_bkp character varying(50),
    usr_cad integer,
    usr_alt integer,
    dt_add timestamp with time zone,
    dt_update integer,
    usu_ibge_codigo character varying(50),
    id_rua bigint,
    usu_resp_nome character varying(100),
    usu_resp_doc_tipo character varying(10),
    usu_resp_doc character varying(30),
    usr_cad_dt timestamp without time zone DEFAULT now(),
    usr_alt_dt timestamp without time zone DEFAULT now(),
    muni_cd_cod_ibge_resid character varying(7) DEFAULT ''::character varying,
    uni_unidade bigint DEFAULT 0,
    muni_cd_cod_ibge_nasc character varying(7),
    id_usuario character varying(58) DEFAULT ''::character varying NOT NULL,
    cd_nacionalidade character varying(3),
    dt_naturalizacao date,
    dt_preenchimento_form date,
    dt_inclusao date,
    dt_alteracao date,
    nr_uso_municipal character varying(20),
    nr_portaria_naturalizacao character varying(16),
    uf_codigo_pac character varying(2),
    usu_escolaridade character varying(2),
    usu_st_conjugal character varying(2),
    usu_nr_ficha bigint,
    usu_cadastrador character(6),
    usu_bolsa_alimentacao character(1),
    usu_prodea character(1),
    usu_nome_operador character(8),
    usu_situacao_emprego character(2),
    usu_renda_media numeric(20,2),
    usu_doencas text,
    usu_habitos_vida text,
    usu_nr_lote character varying(5),
    usu_reservista character varying(20),
    usu_cnh_numero character varying(30),
    usu_cnh_categoria character varying(2),
    usu_fone_recado character varying(15),
    usu_email character varying(100),
    usu_zona_residencia character varying(2),
    usu_estado_civil character(1),
    usu_conjuge character varying(60),
    nesp_codigo bigint,
    usu_bolsa_familia character(1),
    usu_transporte_publico character(1),
    usu_cert_civil_emissor character varying(60),
    usu_nis character varying(11),
    usu_data_cad date,
    usu_qtd_comodos bigint,
    usu_prontuario_num bigint,
    usu_cert_cartorio_nasc character varying(200),
    usu_cert_livro_nasc character varying(200),
    usu_cert_lv_fls_nasc character varying(200),
    usu_cert_termo_nasc character varying(200),
    usu_gestor character(1),
    codigo_secretaria integer,
    pais_codigo character varying(3),
    usu_codigo_sus character varying(58),
    usu_dt_obito date,
    usu_obito character(1),
    usu_uf_cert_civil character varying(2),
    uf_sigla_rg character varying(2),
    uf_sigla_ctps character varying(2),
    usu_ativacao character varying(1) DEFAULT 'S'::character varying,
    usu_dt_ativacao_desativacao date DEFAULT ('now'::text)::date,
    usu_cert_emissao_nasc date,
    usu_tipo_esgoto character varying(2),
    usu_tipo_const_casa character varying(2),
    usu_rede_eletrica character varying(1),
    usu_tipo_abast_agua character varying(2),
    usu_cbo_r character varying(10),
    usu_cert_lv_fls character varying(200),
    usu_codigo_pai integer,
    usu_codigo_mae integer,
    usu_codigo_conjuge integer,
    usu_codigo_enc character varying(32),
    usu_codigo_ver character varying(2),
    ecd_codigo character varying(2),
    dom_codigo bigint,
    usu_plano_saude character(1) DEFAULT 'N'::bpchar,
    usu_desc_plano_saude character varying(30),
    etn_codigo bigint,
    usu_fator_rh character(1),
    usu_tipo_sanguineo character(2),
    usu_rg_emissor character varying(20),
    usu_bloqueado boolean DEFAULT false NOT NULL,
    uni_codigo_obito bigint,
    cd10_codigo_obito bigint,
    usu_nome_resp character(250)
);


ALTER TABLE social.usuario OWNER TO postgres;

--
-- TOC entry 5206 (class 0 OID 0)
-- Dependencies: 169
-- Name: COLUMN usuario.usu_prontuario; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN usuario.usu_prontuario IS 'prontuario da ams';


--
-- TOC entry 5207 (class 0 OID 0)
-- Dependencies: 169
-- Name: COLUMN usuario.id_rua; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN usuario.id_rua IS 'id_rua = saude.rua.rua_codigo';


--
-- TOC entry 170 (class 1259 OID 279912)
-- Dependencies: 3419 7
-- Name: agendamentoteste; Type: VIEW; Schema: social; Owner: postgres
--


--
-- TOC entry 171 (class 1259 OID 279917)
-- Dependencies: 3510 7
-- Name: agente; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE agente (
    agt_codigo bigint DEFAULT nextval(('seq_agt_codigo'::text)::regclass) NOT NULL,
    agt_numero bigint NOT NULL,
    uni_codigo bigint,
    agt_responsavel character varying(60),
    agt_descricao character varying(60)
);


ALTER TABLE social.agente OWNER TO postgres;

--
-- TOC entry 172 (class 1259 OID 279921)
-- Dependencies: 7
-- Name: aih2; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE aih2 (
    aih_codigo bigint NOT NULL,
    med_codigo_solicitante bigint,
    med_codigo_executante bigint,
    aih_cnes_soli bigint,
    aih_cnes_exec bigint,
    usr_codigo bigint,
    aih_paciente_nome character varying(255),
    aih_paciente_rg character varying(20),
    aih_paciente_cpf character varying(20),
    aih_prontuario character varying(50),
    aih_cns bigint,
    aih_data_nasc date,
    aih_sexo character(1),
    aih_mae_responsavel_nome character varying(255),
    aih_mae_responsavel_rg character varying(255),
    aih_mae_responsavel_cpf character varying(20),
    aih_fone character varying(14),
    aih_endereco character varying(255),
    aih_numero bigint,
    aih_bairro character varying(100),
    aih_cidade character varying(100),
    aih_ibge_codigo character varying(50),
    aih_uf character(2),
    aih_cep character varying(10),
    aih_dataini date,
    aih_data_alta date,
    aih_principais_sintomas text,
    aih_justificativa_internacao text,
    aih_principais_resultados text,
    aih_diag_ini character varying(255),
    aih_cid_cod_princ character varying(50),
    aih_cid_cod_secun character varying(50),
    aih_cid_cod_terc character varying(50),
    aih_desc_proc_soli character varying(255),
    aih_proc_codigo bigint,
    aih_clinica character varying(100),
    aih_ci bigint,
    aih_tipo_doc_proc_soli character(3),
    aih_n_doc_prof_solicitante character varying(50),
    med_solicitante_proc character varying(255),
    aih_data_solicitacao date,
    aih_vinculo_previdencia character varying(20),
    med_autorizador character varying(255),
    aih_tipo_doc_autorizacao character(3),
    aih_n_doc_prof_autorizador character varying(50),
    aih_data_autorizacao date,
    aih_cod_orgao_emissor character varying(100),
    aih_numero_aih bigint,
    aih_segunda_via character(1)
);


ALTER TABLE social.aih2 OWNER TO postgres;

--
-- TOC entry 173 (class 1259 OID 279927)
-- Dependencies: 172 7
-- Name: aih2_aih_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE aih2_aih_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.aih2_aih_codigo_seq OWNER TO postgres;

--
-- TOC entry 5209 (class 0 OID 0)
-- Dependencies: 173
-- Name: aih2_aih_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE aih2_aih_codigo_seq OWNED BY aih2.aih_codigo;


--
-- TOC entry 5210 (class 0 OID 0)
-- Dependencies: 173
-- Name: aih2_aih_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('aih2_aih_codigo_seq', 1, false);


--
-- TOC entry 174 (class 1259 OID 279929)
-- Dependencies: 159 7
-- Name: aih_aih_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE aih_aih_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.aih_aih_codigo_seq OWNER TO postgres;

--
-- TOC entry 5211 (class 0 OID 0)
-- Dependencies: 174
-- Name: aih_aih_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE aih_aih_codigo_seq OWNED BY aih.aih_codigo;


--
-- TOC entry 5212 (class 0 OID 0)
-- Dependencies: 174
-- Name: aih_aih_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('aih_aih_codigo_seq', 1, false);


--
-- TOC entry 175 (class 1259 OID 279931)
-- Dependencies: 3512 3513 3514 3515 7
-- Name: aih_apac_numero; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE aih_apac_numero (
    codigo bigint NOT NULL,
    num_ini bigint DEFAULT 0 NOT NULL,
    num_fim bigint DEFAULT 0 NOT NULL,
    num_prox bigint DEFAULT 0 NOT NULL,
    tipo character varying(4) DEFAULT 'APAC'::character varying NOT NULL
);


ALTER TABLE social.aih_apac_numero OWNER TO postgres;

--
-- TOC entry 176 (class 1259 OID 279938)
-- Dependencies: 175 7
-- Name: aih_apac_numero_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE aih_apac_numero_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.aih_apac_numero_codigo_seq OWNER TO postgres;

--
-- TOC entry 5213 (class 0 OID 0)
-- Dependencies: 176
-- Name: aih_apac_numero_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE aih_apac_numero_codigo_seq OWNED BY aih_apac_numero.codigo;


--
-- TOC entry 5214 (class 0 OID 0)
-- Dependencies: 176
-- Name: aih_apac_numero_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('aih_apac_numero_codigo_seq', 1, false);


--
-- TOC entry 177 (class 1259 OID 279940)
-- Dependencies: 3518 7
-- Name: aih_apac_numeros_resto; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE aih_apac_numeros_resto (
    aan_codigo bigint NOT NULL,
    aan_codigo_fk integer,
    aan_numero_resto character varying(20),
    aan_tipo character varying(5) DEFAULT 'APAC'::character varying,
    aan_emuso character varying(1)
);


ALTER TABLE social.aih_apac_numeros_resto OWNER TO postgres;

--
-- TOC entry 178 (class 1259 OID 279944)
-- Dependencies: 177 7
-- Name: aih_apac_numeros_resto_aan_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE aih_apac_numeros_resto_aan_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.aih_apac_numeros_resto_aan_codigo_seq OWNER TO postgres;

--
-- TOC entry 5215 (class 0 OID 0)
-- Dependencies: 178
-- Name: aih_apac_numeros_resto_aan_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE aih_apac_numeros_resto_aan_codigo_seq OWNED BY aih_apac_numeros_resto.aan_codigo;


--
-- TOC entry 5216 (class 0 OID 0)
-- Dependencies: 178
-- Name: aih_apac_numeros_resto_aan_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('aih_apac_numeros_resto_aan_codigo_seq', 1, false);


--
-- TOC entry 179 (class 1259 OID 279946)
-- Dependencies: 3520 7
-- Name: aih_apac_numeros_resto_bkp; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE aih_apac_numeros_resto_bkp (
    aan_codigo bigint NOT NULL,
    aan_codigo_fk integer,
    aan_numero_resto character varying(20),
    aan_tipo character varying(5) DEFAULT 'APAC'::character varying
);


ALTER TABLE social.aih_apac_numeros_resto_bkp OWNER TO postgres;

--
-- TOC entry 180 (class 1259 OID 279950)
-- Dependencies: 179 7
-- Name: aih_apac_numeros_resto_bkp_aan_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE aih_apac_numeros_resto_bkp_aan_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.aih_apac_numeros_resto_bkp_aan_codigo_seq OWNER TO postgres;

--
-- TOC entry 5217 (class 0 OID 0)
-- Dependencies: 180
-- Name: aih_apac_numeros_resto_bkp_aan_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE aih_apac_numeros_resto_bkp_aan_codigo_seq OWNED BY aih_apac_numeros_resto_bkp.aan_codigo;


--
-- TOC entry 5218 (class 0 OID 0)
-- Dependencies: 180
-- Name: aih_apac_numeros_resto_bkp_aan_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('aih_apac_numeros_resto_bkp_aan_codigo_seq', 1, false);


--
-- TOC entry 181 (class 1259 OID 279952)
-- Dependencies: 7
-- Name: aih_paciente; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE aih_paciente (
    pac_codigo bigint NOT NULL,
    pac_nome character varying(100),
    pac_sexo character(1),
    pac_rg character varying(25),
    pac_cpf character varying(25),
    pac_cns character varying(25),
    pac_prontuario character varying(50),
    pac_mae_responsavel_nome character varying(255),
    pac_mae_responsavel_rg character varying(255),
    pac_mae_responsavel_cpf character varying(20),
    pac_end_rua character varying(60),
    pac_end_nr character varying(5),
    pac_end_compl character varying(20),
    pac_end_bairro character varying(30),
    pac_end_cep character varying(9),
    pac_end_cidade character varying(60),
    pac_dt_nasc date,
    pac_telefone character varying(15),
    pac_ibge_codigo character varying(50)
);


ALTER TABLE social.aih_paciente OWNER TO postgres;

--
-- TOC entry 182 (class 1259 OID 279958)
-- Dependencies: 181 7
-- Name: aih_paciente_pac_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE aih_paciente_pac_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.aih_paciente_pac_codigo_seq OWNER TO postgres;

--
-- TOC entry 5219 (class 0 OID 0)
-- Dependencies: 182
-- Name: aih_paciente_pac_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE aih_paciente_pac_codigo_seq OWNED BY aih_paciente.pac_codigo;


--
-- TOC entry 5220 (class 0 OID 0)
-- Dependencies: 182
-- Name: aih_paciente_pac_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('aih_paciente_pac_codigo_seq', 1, false);


--
-- TOC entry 183 (class 1259 OID 279960)
-- Dependencies: 7
-- Name: ajuda; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE ajuda (
    id integer NOT NULL,
    modulo text,
    sub_1 text,
    ajusub1 text,
    sub_3 text,
    pal_chave character varying(100),
    pal_chave2 character varying(100),
    arquivo path
);


ALTER TABLE social.ajuda OWNER TO postgres;

--
-- TOC entry 184 (class 1259 OID 279966)
-- Dependencies: 3523 7
-- Name: alerta; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE alerta (
    ale_codigo bigint NOT NULL,
    ale_desc character varying(100) NOT NULL,
    usu_codigo bigint NOT NULL,
    usr_codigo bigint NOT NULL,
    ale_data timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE social.alerta OWNER TO postgres;

--
-- TOC entry 185 (class 1259 OID 279970)
-- Dependencies: 184 7
-- Name: alerta_ale_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE alerta_ale_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.alerta_ale_codigo_seq OWNER TO postgres;

--
-- TOC entry 5222 (class 0 OID 0)
-- Dependencies: 185
-- Name: alerta_ale_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE alerta_ale_codigo_seq OWNED BY alerta.ale_codigo;


--
-- TOC entry 5223 (class 0 OID 0)
-- Dependencies: 185
-- Name: alerta_ale_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('alerta_ale_codigo_seq', 2, true);


--
-- TOC entry 186 (class 1259 OID 279972)
-- Dependencies: 3524 3525 7
-- Name: anamnese; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE anamnese (
    ana_codigo bigint NOT NULL,
    ana_questao text,
    ana_tipo_resposta smallint DEFAULT 1,
    ana_tipo_resposta_opt text DEFAULT ''::text
);


ALTER TABLE social.anamnese OWNER TO postgres;

--
-- TOC entry 5224 (class 0 OID 0)
-- Dependencies: 186
-- Name: COLUMN anamnese.ana_tipo_resposta; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN anamnese.ana_tipo_resposta IS '1 = TEXT : texto comum (gera input)
2 = TEXTAREA(X) : texto comum (gera um textarea com X linhas)
3 = RADIO: mais de uma opo (nica)
4 = CHECK: mais de uma opo (mltiplas)';


--
-- TOC entry 5225 (class 0 OID 0)
-- Dependencies: 186
-- Name: COLUMN anamnese.ana_tipo_resposta_opt; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN anamnese.ana_tipo_resposta_opt IS 'Depende do campo ana_tipo_resposta.
- TEXT : fica vazio
- TEXTAREA : (X) texto comum (gera um textarea com X linhas)
- RADIO : Opcao 1; Opcao 2; Opcao 3 
- CHECK : Opcao 1; Opcao 2; Opcao 3 ';


--
-- TOC entry 187 (class 1259 OID 279980)
-- Dependencies: 186 7
-- Name: anamnese_ana_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE anamnese_ana_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.anamnese_ana_codigo_seq OWNER TO postgres;

--
-- TOC entry 5226 (class 0 OID 0)
-- Dependencies: 187
-- Name: anamnese_ana_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE anamnese_ana_codigo_seq OWNED BY anamnese.ana_codigo;


--
-- TOC entry 5227 (class 0 OID 0)
-- Dependencies: 187
-- Name: anamnese_ana_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('anamnese_ana_codigo_seq', 5, true);


--
-- TOC entry 188 (class 1259 OID 279982)
-- Dependencies: 3528 7
-- Name: anamnese_atendimento; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE anamnese_atendimento (
    ana_codigo bigint NOT NULL,
    ate_codigo bigint NOT NULL,
    ana_pergunta text NOT NULL,
    ana_resposta text NOT NULL,
    ana_dt_cadastro timestamp without time zone DEFAULT now(),
    usr_codigo bigint
);


ALTER TABLE social.anamnese_atendimento OWNER TO postgres;

--
-- TOC entry 5228 (class 0 OID 0)
-- Dependencies: 188
-- Name: TABLE anamnese_atendimento; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON TABLE anamnese_atendimento IS 'perguntas/respostas referentes a Anamnese feita durante o Atendimento';


--
-- TOC entry 189 (class 1259 OID 279989)
-- Dependencies: 188 7
-- Name: anamnese_atendimento_ana_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE anamnese_atendimento_ana_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.anamnese_atendimento_ana_codigo_seq OWNER TO postgres;

--
-- TOC entry 5229 (class 0 OID 0)
-- Dependencies: 189
-- Name: anamnese_atendimento_ana_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE anamnese_atendimento_ana_codigo_seq OWNED BY anamnese_atendimento.ana_codigo;


--
-- TOC entry 5230 (class 0 OID 0)
-- Dependencies: 189
-- Name: anamnese_atendimento_ana_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('anamnese_atendimento_ana_codigo_seq', 1, false);


--
-- TOC entry 190 (class 1259 OID 279991)
-- Dependencies: 3529 3530 7
-- Name: anamnese_especialidade; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE anamnese_especialidade (
    ana_codigo bigint NOT NULL,
    esp_codigo bigint NOT NULL,
    ana_pergunta text NOT NULL,
    ana_ordem smallint DEFAULT 1,
    ana_dt_cadastro timestamp without time zone DEFAULT now(),
    usr_codigo bigint
);


ALTER TABLE social.anamnese_especialidade OWNER TO postgres;

--
-- TOC entry 5231 (class 0 OID 0)
-- Dependencies: 190
-- Name: TABLE anamnese_especialidade; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON TABLE anamnese_especialidade IS 'perguntas referentes a Anamnese de uma determinada Especialidade';


--
-- TOC entry 191 (class 1259 OID 279999)
-- Dependencies: 190 7
-- Name: anamnese_especialidade_ana_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE anamnese_especialidade_ana_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.anamnese_especialidade_ana_codigo_seq OWNER TO postgres;

--
-- TOC entry 5232 (class 0 OID 0)
-- Dependencies: 191
-- Name: anamnese_especialidade_ana_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE anamnese_especialidade_ana_codigo_seq OWNED BY anamnese_especialidade.ana_codigo;


--
-- TOC entry 5233 (class 0 OID 0)
-- Dependencies: 191
-- Name: anamnese_especialidade_ana_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('anamnese_especialidade_ana_codigo_seq', 1, false);


--
-- TOC entry 192 (class 1259 OID 280001)
-- Dependencies: 3532 3533 7
-- Name: anamnese_medico; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE anamnese_medico (
    ana_codigo bigint NOT NULL,
    med_codigo bigint NOT NULL,
    esp_codigo bigint NOT NULL,
    ana_pergunta text NOT NULL,
    ana_ordem smallint DEFAULT 1,
    ana_dt_cadastro timestamp without time zone DEFAULT now(),
    usr_codigo bigint
);


ALTER TABLE social.anamnese_medico OWNER TO postgres;

--
-- TOC entry 5234 (class 0 OID 0)
-- Dependencies: 192
-- Name: TABLE anamnese_medico; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON TABLE anamnese_medico IS 'perguntas referentes a Anamnese de um determinado Medico atendendo a uma Especialidade';


--
-- TOC entry 193 (class 1259 OID 280009)
-- Dependencies: 192 7
-- Name: anamnese_medico_ana_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE anamnese_medico_ana_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.anamnese_medico_ana_codigo_seq OWNER TO postgres;

--
-- TOC entry 5235 (class 0 OID 0)
-- Dependencies: 193
-- Name: anamnese_medico_ana_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE anamnese_medico_ana_codigo_seq OWNED BY anamnese_medico.ana_codigo;


--
-- TOC entry 5236 (class 0 OID 0)
-- Dependencies: 193
-- Name: anamnese_medico_ana_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('anamnese_medico_ana_codigo_seq', 1, false);


--
-- TOC entry 194 (class 1259 OID 280011)
-- Dependencies: 7
-- Name: anamnese_tipo; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE anamnese_tipo (
    ana_tp_codigo bigint NOT NULL,
    ana_tp_descricao character varying(99)
);


ALTER TABLE social.anamnese_tipo OWNER TO postgres;

--
-- TOC entry 5237 (class 0 OID 0)
-- Dependencies: 194
-- Name: TABLE anamnese_tipo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON TABLE anamnese_tipo IS 'Os diferentes tipos de form. para Anamnese. ex: odontolgico';


--
-- TOC entry 195 (class 1259 OID 280014)
-- Dependencies: 194 7
-- Name: anamnese_tipo_ana_tp_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE anamnese_tipo_ana_tp_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.anamnese_tipo_ana_tp_codigo_seq OWNER TO postgres;

--
-- TOC entry 5238 (class 0 OID 0)
-- Dependencies: 195
-- Name: anamnese_tipo_ana_tp_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE anamnese_tipo_ana_tp_codigo_seq OWNED BY anamnese_tipo.ana_tp_codigo;


--
-- TOC entry 5239 (class 0 OID 0)
-- Dependencies: 195
-- Name: anamnese_tipo_ana_tp_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('anamnese_tipo_ana_tp_codigo_seq', 1, false);


--
-- TOC entry 196 (class 1259 OID 280016)
-- Dependencies: 7
-- Name: anamnese_tipo_rel; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE anamnese_tipo_rel (
    ana_codigo bigint,
    ana_tp_codigo bigint
);


ALTER TABLE social.anamnese_tipo_rel OWNER TO postgres;

--
-- TOC entry 197 (class 1259 OID 280019)
-- Dependencies: 3536 7
-- Name: andamento_requisicao; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE andamento_requisicao (
    areq_codigo bigint DEFAULT nextval(('seq_areq_codigo'::text)::regclass) NOT NULL,
    rcom_codigo bigint,
    areq_descricao text,
    areq_data date
);


ALTER TABLE social.andamento_requisicao OWNER TO postgres;

--
-- TOC entry 198 (class 1259 OID 280026)
-- Dependencies: 160 7
-- Name: apac_apac_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE apac_apac_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.apac_apac_codigo_seq OWNER TO postgres;

--
-- TOC entry 5241 (class 0 OID 0)
-- Dependencies: 198
-- Name: apac_apac_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE apac_apac_codigo_seq OWNED BY apac.apac_codigo;


--
-- TOC entry 5242 (class 0 OID 0)
-- Dependencies: 198
-- Name: apac_apac_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('apac_apac_codigo_seq', 1, false);


--
-- TOC entry 199 (class 1259 OID 280028)
-- Dependencies: 7
-- Name: apac_backup; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE apac_backup (
    apac_codigo bigint,
    pac_codigo bigint,
    pac_apac_codigo bigint,
    uni_sol_codigo bigint,
    uni_sol_apac_codigo bigint,
    med_sol_codigo bigint,
    med_sol_apac_codigo bigint,
    orgao_codigo bigint,
    orgao_apac_codigo bigint,
    uni_pres_codigo bigint,
    uni_pres_apac_codigo bigint,
    med_aud_codigo bigint,
    med_aud_apac_codigo bigint,
    cd10_codigo bigint,
    apac_periodo_validade date,
    apac_convenio character(1),
    apac_convenio_nome character varying(200),
    apac_hipotese character varying(200),
    apac_resumo_exame_fisico text,
    apac_segunda_via character(1),
    apac_periodo_validade_fim date,
    apac_mes_competencia integer,
    apac_ano_competencia integer,
    apac_dt_cadastro date,
    apac_num character varying(99)
);


ALTER TABLE social.apac_backup OWNER TO postgres;

--
-- TOC entry 200 (class 1259 OID 280034)
-- Dependencies: 7
-- Name: apac_medico; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE apac_medico (
    med_codigo bigint NOT NULL,
    med_crm character varying(10) NOT NULL,
    med_nome character varying(60) NOT NULL,
    med_cpf character varying(11),
    med_rg character varying(15)
);


ALTER TABLE social.apac_medico OWNER TO postgres;

--
-- TOC entry 201 (class 1259 OID 280037)
-- Dependencies: 200 7
-- Name: apac_medico_med_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE apac_medico_med_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.apac_medico_med_codigo_seq OWNER TO postgres;

--
-- TOC entry 5243 (class 0 OID 0)
-- Dependencies: 201
-- Name: apac_medico_med_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE apac_medico_med_codigo_seq OWNED BY apac_medico.med_codigo;


--
-- TOC entry 5244 (class 0 OID 0)
-- Dependencies: 201
-- Name: apac_medico_med_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('apac_medico_med_codigo_seq', 1, false);


--
-- TOC entry 202 (class 1259 OID 280039)
-- Dependencies: 3539 7
-- Name: apac_paciente; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE apac_paciente (
    pac_codigo bigint NOT NULL,
    pac_nome character varying(100),
    pac_sexo character(1),
    pac_cpf_cns character varying(25),
    pac_mae_responsavel character varying(200),
    pac_end_rua character varying(60),
    pac_end_nr character varying(5),
    pac_end_compl character varying(20),
    pac_end_bairro character varying(30),
    pac_end_cep character varying(9),
    pac_end_cidade character varying(60),
    pac_dt_nasc date,
    pac_telefone character varying(15),
    pac_pai character varying(200),
    pac_tem_convenio character(1) DEFAULT 'N'::bpchar,
    pac_convenio_nome character varying(200)
);


ALTER TABLE social.apac_paciente OWNER TO postgres;

--
-- TOC entry 203 (class 1259 OID 280046)
-- Dependencies: 202 7
-- Name: apac_paciente_pac_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE apac_paciente_pac_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.apac_paciente_pac_codigo_seq OWNER TO postgres;

--
-- TOC entry 5245 (class 0 OID 0)
-- Dependencies: 203
-- Name: apac_paciente_pac_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE apac_paciente_pac_codigo_seq OWNED BY apac_paciente.pac_codigo;


--
-- TOC entry 5246 (class 0 OID 0)
-- Dependencies: 203
-- Name: apac_paciente_pac_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('apac_paciente_pac_codigo_seq', 1, false);


--
-- TOC entry 204 (class 1259 OID 280048)
-- Dependencies: 3541 7
-- Name: apac_procedimento_cad; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE apac_procedimento_cad (
    proc_codigo bigint NOT NULL,
    proc_nome character varying(99),
    proc_numero character varying(99),
    med_codigo bigint,
    proc_valor numeric(9,2),
    proc_tipo character varying(2) DEFAULT 'Q'::character varying
);


ALTER TABLE social.apac_procedimento_cad OWNER TO postgres;

--
-- TOC entry 205 (class 1259 OID 280052)
-- Dependencies: 204 7
-- Name: apac_procedimento_cad_proc_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE apac_procedimento_cad_proc_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.apac_procedimento_cad_proc_codigo_seq OWNER TO postgres;

--
-- TOC entry 5247 (class 0 OID 0)
-- Dependencies: 205
-- Name: apac_procedimento_cad_proc_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE apac_procedimento_cad_proc_codigo_seq OWNED BY apac_procedimento_cad.proc_codigo;


--
-- TOC entry 5248 (class 0 OID 0)
-- Dependencies: 205
-- Name: apac_procedimento_cad_proc_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('apac_procedimento_cad_proc_codigo_seq', 65, true);


--
-- TOC entry 206 (class 1259 OID 280054)
-- Dependencies: 3543 7
-- Name: apac_unidade; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE apac_unidade (
    uni_codigo bigint NOT NULL,
    uni_desc character varying(60) NOT NULL,
    uni_localizacao character varying(60) NOT NULL,
    uni_responsavel character varying(60) NOT NULL,
    uni_cnpj character varying(25) DEFAULT ''::character varying
);


ALTER TABLE social.apac_unidade OWNER TO postgres;

--
-- TOC entry 207 (class 1259 OID 280058)
-- Dependencies: 206 7
-- Name: apac_unidade_uni_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE apac_unidade_uni_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.apac_unidade_uni_codigo_seq OWNER TO postgres;

--
-- TOC entry 5249 (class 0 OID 0)
-- Dependencies: 207
-- Name: apac_unidade_uni_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE apac_unidade_uni_codigo_seq OWNED BY apac_unidade.uni_codigo;


--
-- TOC entry 5250 (class 0 OID 0)
-- Dependencies: 207
-- Name: apac_unidade_uni_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('apac_unidade_uni_codigo_seq', 1, false);


--
-- TOC entry 208 (class 1259 OID 280060)
-- Dependencies: 3544 7
-- Name: apresentacao_produto; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE apresentacao_produto (
    apre_codigo bigint DEFAULT nextval(('seq_apre_codigo'::text)::regclass) NOT NULL,
    pro_codigo bigint NOT NULL,
    apre_desc character varying(100) NOT NULL,
    apre_fatormultiplic integer
);


ALTER TABLE social.apresentacao_produto OWNER TO postgres;

--
-- TOC entry 209 (class 1259 OID 280064)
-- Dependencies: 3545 7
-- Name: area; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE area (
    area_codigo bigint DEFAULT nextval(('seq_area_codigo'::text)::regclass) NOT NULL,
    area_desc character varying(40) NOT NULL,
    area_obs character varying(100),
    area_modulo integer
);


ALTER TABLE social.area OWNER TO postgres;

--
-- TOC entry 210 (class 1259 OID 280068)
-- Dependencies: 3546 3547 3548 3549 7
-- Name: areas_interesse; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE areas_interesse (
    pes_codigo bigint DEFAULT (0)::bigint NOT NULL,
    area bigint DEFAULT (0)::bigint NOT NULL,
    experiencia character(1) DEFAULT '0'::bpchar NOT NULL,
    qualificacao character varying(30) DEFAULT ''::character varying
);


ALTER TABLE social.areas_interesse OWNER TO postgres;

--
-- TOC entry 211 (class 1259 OID 280075)
-- Dependencies: 3550 3551 3552 3553 3554 3555 3556 3557 3558 3559 3560 7
-- Name: atendimento; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE atendimento (
    ate_codigo bigint DEFAULT nextval(('seq_ate_codigo'::text)::regclass) NOT NULL,
    ate_data date NOT NULL,
    ate_hora character varying(5) NOT NULL,
    med_codigo bigint,
    usu_codigo bigint NOT NULL,
    ate_descatend text,
    ate_observacao text,
    age_codigo bigint,
    ate_valor_proc numeric(9,2) DEFAULT 0,
    ate_datafinal date,
    uni_codigo bigint DEFAULT 277,
    ate_horafinal character varying(5),
    ate_pressao character varying(20),
    ate_temperatura character varying(20),
    ate_diagnostico character varying(300),
    cd10_codigo bigint,
    ate_encaminhamento character(1),
    ate_acidentetrab character(1),
    hos_codigo bigint,
    ate_reclamacao text,
    ate_exame_fisico character(255),
    ate_tratamento character(255),
    cd10_codigos character(50),
    cd10_codigot character(50),
    esp_codigo_encaminhamento character(50),
    ate_curativo character(200),
    ate_curativos character(200),
    ate_peso integer,
    ate_altura numeric(3,3),
    ate_finalizado character(1),
    sispn_codigo integer,
    ate_tipo_consulta_prenatal integer,
    ate_observacao_prenatal character(30),
    ate_classificacao_prenatal character varying(2),
    ate_puericultura boolean DEFAULT false NOT NULL,
    ate_pre_natal boolean DEFAULT false NOT NULL,
    ate_cancer boolean DEFAULT false NOT NULL,
    ate_dst boolean DEFAULT false NOT NULL,
    ate_diabetes boolean DEFAULT false NOT NULL,
    ate_hipertensao boolean DEFAULT false NOT NULL,
    ate_hanseniase boolean DEFAULT false NOT NULL,
    ate_tuberculose boolean DEFAULT false NOT NULL
);


ALTER TABLE social.atendimento OWNER TO postgres;

--
-- TOC entry 5252 (class 0 OID 0)
-- Dependencies: 211
-- Name: COLUMN atendimento.ate_encaminhamento; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN atendimento.ate_encaminhamento IS 'A - ALTA
I - INTERNACAO 
S - AMBULATORIO SUS
O - OBITO';


--
-- TOC entry 5253 (class 0 OID 0)
-- Dependencies: 211
-- Name: COLUMN atendimento.hos_codigo; Type: COMMENT; Schema: social; Owner: postgres
--

COMMENT ON COLUMN atendimento.hos_codigo IS 'Codigo do hospital para onde foi encaminhado o paciente';


--
-- TOC entry 212 (class 1259 OID 280092)
-- Dependencies: 3561 7
-- Name: atendimento_familia; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE atendimento_familia (
    atf_codigo bigint DEFAULT nextval(('seq_atf_codigo'::text)::regclass) NOT NULL,
    atf_data date NOT NULL,
    atf_hora character varying(5) NOT NULL,
    agt_codigo bigint NOT NULL,
    fam_codigo bigint NOT NULL,
    usu_codigo bigint NOT NULL,
    cd10_codigo bigint NOT NULL,
    atf_descatend text,
    atf_observacao text
);


ALTER TABLE social.atendimento_familia OWNER TO postgres;

--
-- TOC entry 213 (class 1259 OID 280099)
-- Dependencies: 3562 3563 3564 3565 3566 3567 7
-- Name: atendimento_municipe; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE atendimento_municipe (
    pes_codigo bigint DEFAULT (0)::bigint NOT NULL,
    cod_atend bigint DEFAULT (0)::bigint NOT NULL,
    data date NOT NULL,
    cod_ins bigint DEFAULT (0)::bigint NOT NULL,
    atendente character varying(50) DEFAULT ''::character varying NOT NULL,
    observacao character varying(255) DEFAULT ''::character varying,
    dtinsert timestamp without time zone NOT NULL,
    usuaultalter character varying(20) DEFAULT ''::character varying,
    dtultalter timestamp without time zone,
    usuainsert bigint,
    agr_codigo integer,
    tps_codigo integer,
    esp_codigo integer
);


ALTER TABLE social.atendimento_municipe OWNER TO postgres;

--
-- TOC entry 214 (class 1259 OID 280108)
-- Dependencies: 7
-- Name: atendimento_pam; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE atendimento_pam (
    ate_codigo bigint NOT NULL,
    ate_data date NOT NULL,
    ate_hora character varying(5) NOT NULL,
    med_codigo bigint,
    usu_codigo bigint NOT NULL,
    ate_datafinal date,
    uni_codigo bigint,
    ate_horafinal character varying(5)
);


ALTER TABLE social.atendimento_pam OWNER TO postgres;

--
-- TOC entry 215 (class 1259 OID 280111)
-- Dependencies: 3568 3569 3570 3571 3572 3573 3574 3575 7
-- Name: atestado; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE atestado (
    atest_codigo bigint DEFAULT nextval(('seq_atestado'::text)::regclass) NOT NULL,
    ate_codigo bigint,
    age_codigo bigint,
    consulta_medica character(1) DEFAULT 'N'::bpchar,
    acompanhando_filho character(1) DEFAULT 'N'::bpchar,
    retorno_trabalho character(1) DEFAULT 'N'::bpchar,
    repouso_hs character(1) DEFAULT 'N'::bpchar,
    repouso_hoje character(1) DEFAULT 'N'::bpchar,
    repouso_dia character(1) DEFAULT 'N'::bpchar,
    tipo_obs character(1) DEFAULT 'N'::bpchar,
    acompanhando character varying(200),
    retornoaotrabalho character varying(200),
    repousohs_ini character varying(5),
    repousohs_final character varying(5),
    repousodias character varying(5),
    tipoobs character varying(200),
    obs character varying(255),
    cid_codigo bigint,
    dt_atestado timestamp without time zone
);


ALTER TABLE social.atestado OWNER TO postgres;

--
-- TOC entry 724 (class 1259 OID 292232)
-- Dependencies: 7
-- Name: autentificacao; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE autentificacao (
    aut_codigo bigint NOT NULL,
    aut_nome character varying(150) NOT NULL,
    aut_codigo_validacao integer,
    aut_data_validacao date,
    aut_senha character varying(150),
    aut_data date
);


ALTER TABLE social.autentificacao OWNER TO postgres;

--
-- TOC entry 723 (class 1259 OID 292230)
-- Dependencies: 724 7
-- Name: autentificacao_aut_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE autentificacao_aut_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.autentificacao_aut_codigo_seq OWNER TO postgres;

--
-- TOC entry 5256 (class 0 OID 0)
-- Dependencies: 723
-- Name: autentificacao_aut_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE autentificacao_aut_codigo_seq OWNED BY autentificacao.aut_codigo;


--
-- TOC entry 5257 (class 0 OID 0)
-- Dependencies: 723
-- Name: autentificacao_aut_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('autentificacao_aut_codigo_seq', 1, false);


--
-- TOC entry 216 (class 1259 OID 280125)
-- Dependencies: 7
-- Name: avaliacao_puerperal; Type: TABLE; Schema: social; Owner: postgres; Tablespace: 
--

CREATE TABLE avaliacao_puerperal (
    ava_codigo bigint NOT NULL,
    ava_peso numeric,
    ava_temperatura double precision,
    ava_pressao_sistolica smallint,
    ava_pressao_diastolica smallint,
    ava_caracteristicas_loquios character varying(60),
    ava_hemorragia character(1),
    ava_infeccao character(1),
    ava_amamentacao character(1),
    ava_motivo_nao_amamentacao character varying(60),
    ava_catacteristicas_das_mamas integer,
    ava_sexo character(1),
    ava_tamanho smallint,
    ava_apgar character varying(10),
    ava_parkim character varying(10),
    ate_codigo integer
);


ALTER TABLE social.avaliacao_puerperal OWNER TO postgres;

--
-- TOC entry 217 (class 1259 OID 280131)
-- Dependencies: 216 7
-- Name: avaliacao_puerperal_ava_codigo_seq; Type: SEQUENCE; Schema: social; Owner: postgres
--

CREATE SEQUENCE avaliacao_puerperal_ava_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE social.avaliacao_puerperal_ava_codigo_seq OWNER TO postgres;

--
-- TOC entry 5258 (class 0 OID 0)
-- Dependencies: 217
-- Name: avaliacao_puerperal_ava_codigo_seq; Type: SEQUENCE OWNED BY; Schema: social; Owner: postgres
--

ALTER SEQUENCE avaliacao_puerperal_ava_codigo_seq OWNED BY avaliacao_puerperal.ava_codigo;


--
-- TOC entry 5259 (class 0 OID 0)
-- Dependencies: 217
-- Name: avaliacao_puerperal_ava_codigo_seq; Type: SEQUENCE SET; Schema: social; Owner: postgres
--

SELECT pg_catalog.setval('avaliacao_puerperal_ava_codigo_seq', 1, false);



