CREATE TABLE motivos_faltas
(
   mof_codigo bigserial, 
   mof_descricao character varying, 
    PRIMARY KEY (mof_codigo)
) 
WITH (
  OIDS = FALSE
)
;
insert into motivoS_faltaS(mof_descricao) values ('REUNIO');
insert into motivoS_faltaS(mof_descricao) values ('ATESTADO');
insert into motivoS_faltaS(mof_descricao) values ('BITO');
insert into motivoS_faltaS(mof_descricao) values ('VIAGEM');
insert into motivoS_faltaS(mof_descricao) values ('OUTROS');

alter table grade_horario add column mof_codigo integer;
ALTER TABLE grade_horario ADD FOREIGN KEY (mof_codigo) REFERENCES motivos_faltas (mof_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE viagem_usuario ADD COLUMN via_observacao text;
ALTER TABLE viagem_usuario RENAME via_observacao  TO viausu_observacao;

drop table a;
drop table aih_apac_numeros_resto_bkp;
drop table apac_backup;
drop table colunas;
drop table estado2;
drop table logradouros;
drop table noticias;

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.51.50' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.32.21' WHERE conf_chave='VERSAO_COMUM';

ALTER TABLE domicilio
   ALTER COLUMN dom_codigo SET DEFAULT nextval(('seq_dom_codigo'::text)::regclass);
ALTER TABLE domicilio
  DROP CONSTRAINT fk_domicilio_rua;
ALTER TABLE domicilio
  DROP CONSTRAINT fk_domicilio_tb_ms_tipo_domicilio;
ALTER TABLE domicilio
  ADD CONSTRAINT fk_domicilio_rua FOREIGN KEY (rua_codigo)
      REFERENCES rua (rua_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE domicilio
  ADD CONSTRAINT fk_domicilio_tb_ms_tipo_domicilio FOREIGN KEY (co_tipo_domicilio)
      REFERENCES tb_ms_tipo_domicilio (co_tipo_domicilio) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION;
	  
CREATE SEQUENCE seq_dom_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_dom_codigo
  OWNER TO postgres;
