UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.55.54' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.36.25' WHERE conf_chave='VERSAO_COMUM';

CREATE TABLE odonto_tratamento
(
  odo_trat_codigo bigserial NOT NULL,
  odo_trat_dtinicial timestamp without time zone,
  odo_trat_dtfinal timestamp without time zone,
  odo_trat_status character(1),
  ate_codigo_origem bigint,
  CONSTRAINT odonto_tratamento_pkey PRIMARY KEY (odo_trat_codigo),
  CONSTRAINT atendimento_ate_codigo_fkey FOREIGN KEY (ate_codigo_origem)
      REFERENCES atendimento (ate_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE odonto_tratamento
  OWNER TO postgres;

CREATE TABLE odonto_procedimentos_controle
(
  odo_pcon_codigo bigserial NOT NULL,
  odo_trat_codigo bigint NOT NULL,
  ate_codigo bigint NOT NULL,
  CONSTRAINT odonto_procedimentos_controle_pkey PRIMARY KEY (odo_pcon_codigo),
  CONSTRAINT atendimento_ate_codigo_fkey FOREIGN KEY (ate_codigo)
      REFERENCES atendimento (ate_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT odonto_tratamento_odo_trat_codigo_fkey FOREIGN KEY (odo_trat_codigo)
      REFERENCES odonto_tratamento (odo_trat_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE odonto_procedimentos_controle
  OWNER TO postgres;
  
CREATE TABLE odonto_procedimentos
(
  odo_proc_codigo bigserial NOT NULL,
  odo_pcon_codigo bigint NOT NULL,
  proc_codigo bigint NOT NULL,
  odo_proc_dentenum integer,
  odo_proc_denteface character varying(10),
  odo_proc_denteanot text,
  odo_proc_dtprogramada date,
  odo_proc_status boolean,
  odo_proc_dtcadastro timestamp without time zone DEFAULT now(),
  CONSTRAINT odonto_procedimentos_pkey PRIMARY KEY (odo_proc_codigo),
  CONSTRAINT odonto_procedimentos_controle_odo_pcon_codigo_fkey FOREIGN KEY (odo_pcon_codigo)
      REFERENCES odonto_procedimentos_controle (odo_pcon_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT procedimento_proc_codigo_fkey FOREIGN KEY (proc_codigo)
      REFERENCES procedimento (proc_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE odonto_procedimentos
  OWNER TO postgres;

CREATE TABLE odonto_procedimentos_realizados
(
  odo_preal_codigo bigserial NOT NULL,
  odo_pcon_codigo bigint NOT NULL,
  proc_codigo bigint NOT NULL,
  odo_preal_dentenum integer,
  odo_preal_denteface character varying(10),
  odo_preal_denteanot text,
  odo_preal_dtcadastro timestamp without time zone DEFAULT now(),
  CONSTRAINT odonto_procedimentos_realizados_pkey PRIMARY KEY (odo_preal_codigo),
  CONSTRAINT odonto_procedimentos_controle_odo_pcon_codigo_fkey FOREIGN KEY (odo_pcon_codigo)
      REFERENCES odonto_procedimentos_controle (odo_pcon_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT procedimento_proc_codigo_fkey FOREIGN KEY (proc_codigo)
      REFERENCES procedimento (proc_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE odonto_procedimentos_realizados
  OWNER TO postgres;

  
CREATE OR REPLACE FUNCTION converte_procedimentos_odonto()
  RETURNS void AS
$BODY$
DECLARE
	rec RECORD;
	rec2 RECORD;
	cod INTEGER;	-- codigo da ultima ocorrencia
	next_odo_trat INTEGER;
	cod_ate INTEGER;
	next_odo_pcon INTEGER;
	codigo_od INTEGER;
	
BEGIN
	
	FOR rec IN
		SELECT distinct age_codigo,
		       od_data,
		       od_datafinal
		  FROM odonto
		 ORDER BY age_codigo
	LOOP	

		SELECT ate_codigo INTO cod_ate FROM atendimento WHERE age_codigo = rec.age_codigo;
		SELECT od_codigo INTO codigo_od FROM odonto WHERE age_codigo = rec.age_codigo LIMIT 1;
		next_odo_trat = (SELECT nextval('odonto_tratamento_odo_trat_codigo_seq') as odo);
		IF cod_ate IS NOT NULL THEN
			INSERT INTO odonto_tratamento (odo_trat_codigo,
							   odo_trat_dtinicial,
							   odo_trat_dtfinal,
							   ate_codigo_origem,
							   odo_trat_status)
							   VALUES (next_odo_trat,
							   rec.od_data,
							   rec.od_datafinal,
							   cod_ate,
							   'F');
							   
			next_odo_pcon = (SELECT nextval('odonto_procedimentos_controle_odo_pcon_codigo_seq') as odo);
				INSERT INTO odonto_procedimentos_controle (odo_pcon_codigo,
								   odo_trat_codigo,
								   ate_codigo)
								VALUES(next_odo_pcon,
									   next_odo_trat,
									   cod_ate);
			FOR rec2 IN
			  SELECT od_codigo,
					 od_hist_data,
					 dente_num,
					 dente_face,
					 dente_situacao,
					 dente_anotacao,
					 od_finalizado
				FROM odonto_historico
			   WHERE od_codigo = codigo_od
			   --ORDER BY age_codigo
			LOOP
			  IF rec2.dente_situacao <> '4' THEN 
				  INSERT INTO odonto_procedimentos_realizados (odo_pcon_codigo,
										   proc_codigo,
										   odo_preal_dentenum,
										   odo_preal_denteface,
										   odo_preal_denteanot,
										   odo_preal_dtcadastro)
									VALUES (next_odo_pcon,
										(CASE WHEN rec2.dente_situacao = '1' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010023')
											  WHEN rec2.dente_situacao = '2' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010023')
											  WHEN rec2.dente_situacao = '3' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010023')
											  WHEN rec2.dente_situacao = '5' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0414020120')
											  WHEN rec2.dente_situacao = '6' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0414020120')
											  WHEN rec2.dente_situacao = '7' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0101020066')
											  WHEN rec2.dente_situacao = '8' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0101020066')
											  WHEN rec2.dente_situacao = '9' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010015')
											  WHEN rec2.dente_situacao = '10' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010015')
											  WHEN rec2.dente_situacao = '11' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010015')
										  END ),
										  rec2.dente_num,
										  REPLACE(rec2.dente_face, ';', ''),
										  rec2.dente_anotacao,
										  rec2.od_hist_data);

			  END IF;
			END LOOP;
		END IF;
	END LOOP;
END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION converte_procedimentos_odonto()
  OWNER TO postgres;

select * from converte_procedimentos_odonto();

CREATE OR REPLACE FUNCTION operacoesodontobpa()
  RETURNS trigger AS
$BODY$
DECLARE 
linha RECORD;
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM bpa WHERE bpa_origem = 'odontograma' AND bpa_origem_codigo = OLD.odo_preal_codigo;
		RETURN OLD;
		-- Procedimento e BPA excluido com sucesso
	ELSE 
		FOR linha IN	
		SELECT 
			odpr.odo_preal_codigo,
			odpr.odo_preal_dtcadastro,
			proc.proc_codigo,
			proc.proc_bpa_tipo,
			ate.uni_codigo,
			ate.med_codigo,
			ate.usu_codigo
		FROM 
			odonto_procedimentos_realizados AS odpr
		INNER JOIN 
			procedimento AS proc ON odpr.proc_codigo = proc.proc_codigo
		INNER JOIN 
			odonto_procedimentos_controle AS odpc ON odpr.odo_pcon_codigo = odpc.odo_pcon_codigo
		INNER JOIN
			atendimento AS ate ON odpc.ate_codigo = ate.ate_codigo
		WHERE 
			odpr.odo_preal_codigo = NEW.odo_preal_codigo  LOOP
			-- Operao de Insert
			IF (TG_OP = 'INSERT') THEN
				INSERT 	INTO bpa
							(uni_codigo,usr_codigo,usu_codigo,proc_codigo,ci_codigo,bpa_tipo,bpa_origem,bpa_origem_codigo,bpa_ativo,bpa_data_alt)
						VALUES
							(linha.uni_codigo,linha.med_codigo,linha.usu_codigo,linha.proc_codigo,'16',linha.proc_bpa_tipo,'odontograma',linha.odo_preal_codigo,'t',linha.odo_preal_dtcadastro);
				RETURN NEW;
				-- Procedimento e BPA inserido com sucesso!
			END IF;
			-- Operao de Update
			IF (TG_OP = 'UPDATE') THEN
				UPDATE bpa
					SET 
						uni_codigo = linha.uni_codigo,
						usr_codigo = linha.med_codigo,
						usu_codigo = linha.usu_codigo,
						proc_codigo = linha.proc_codigo,
						ci_codigo = '16',
						bpa_tipo = linha.proc_bpa_tipo,
						bpa_origem = 'odontograma',
						bpa_origem_codigo = linha.odo_preal_codigo,
						bpa_ativo = 't',
						bpa_data_alt = linha.odo_preal_dtcadastro
					WHERE
						bpa_origem = 'odontograma' AND
						bpa_origem_codigo = linha.odo_preal_codigo;
				RETURN NEW;
				-- Procedimento e BPA atualizado com sucesso!
			END IF;
		END LOOP;
	END IF;
END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION operacoesodontobpa()
  OWNER TO postgres;

CREATE TRIGGER atualizaodontobpa
  AFTER INSERT OR UPDATE OR DELETE
  ON odonto_procedimentos_realizados
  FOR EACH ROW
  EXECUTE PROCEDURE operacoesodontobpa();


