UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.56.55' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.37.25' WHERE conf_chave='VERSAO_COMUM';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.19.17' WHERE conf_chave='VERSAO_SOCIAL';

CREATE TABLE acesso
(
  ace_codigo bigserial NOT NULL,
  ace_descricao character varying,
  ace_pai bigint,
  ace_caminho character varying,
  ace_modulo integer,
  ace_imagem character varying,
  CONSTRAINT acesso_pkey PRIMARY KEY (ace_codigo )
)
WITH (
  OIDS=FALSE
);
ALTER TABLE acesso
  OWNER TO postgres;
  
ALTER TABLE usuarios ADD COLUMN usr_modulos character(1);
COMMENT ON COLUMN usuarios.usr_modulos IS 'A - AO SOCIAL
S - SADE
T - TODOS';
  
CREATE TABLE conselho
(
   con_codigo bigserial, 
   con_descricao character varying, 
    PRIMARY KEY (con_codigo)
) 
WITH (
  OIDS = FALSE
)
;

CREATE TABLE unidade_usuarios
(
   unu_codigo bigserial, 
   uni_codigo integer, 
   usr_codigo integer, 
    PRIMARY KEY (unu_codigo), 
    FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
    FOREIGN KEY (uni_codigo) REFERENCES unidade (uni_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;
ALTER TABLE usuarios DROP CONSTRAINT unique_usr_email;
update usuarios set usr_ativo = 'N' where usr_ativo is null;

ALTER TABLE usuarios ADD COLUMN con_codigo integer;
ALTER TABLE usuarios ADD FOREIGN KEY (con_codigo) REFERENCES conselho (con_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE unidade ADD COLUMN cod_ins integer;

ALTER TABLE unidade
   ALTER COLUMN uni_endereco TYPE character varying;

CREATE OR REPLACE FUNCTION converte_instituicoes_unidade()
  RETURNS void AS
$BODY$
DECLARE
	rec RECORD;
	cod INTEGER;	-- codigo da ultima ocorrencia
	
BEGIN
	
	FOR rec IN
		SELECT *
		  FROM instituicoes
		 ORDER BY cod_ins
	LOOP	
		INSERT INTO unidade (uni_desc,
				     uni_endereco,
				     uni_responsavel,
				     uni_tipo,
				     uni_numero,
				     uni_cep,
				     uni_codigo_ibge,
				     cod_ins)
		              VALUES(rec.nome,
				     rec.logradouro || ', ' || rec.bairro,
				     rec.responsavel,
				     'U',
				     rec.numero,
				     rec.cep,
				     (select cid_codigo_ibge from cidade where cid_codigo = rec.cid_codigo),
				     rec.cod_ins);
		              
	END LOOP;
	drop table instituicoes;
END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION converte_instituicoes_unidade()
  OWNER TO postgres;

select converte_instituicoes_unidade();

CREATE OR REPLACE VIEW instituicoes AS 
	SELECT cod_ins,
	       uni_desc as nome,
	       uni_endereco as logradouro,
	       uni_numero as numero,
	       uni_cep as cep,
	       uni_responsavel as responsavel,
	       (select cid_codigo from cidade where cid_codigo_ibge = u.uni_codigo_ibge) as cid_codigo
	  FROM unidade AS u
	 where cod_ins is not null;
  
 

