UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.59.58' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.39.27' WHERE conf_chave='VERSAO_COMUM';

CREATE TABLE tipo_ficha
(
   tpf_codigo bigserial, 
   tpf_descricao character varying, 
    PRIMARY KEY (tpf_codigo)
) 
WITH (
  OIDS = FALSE
)
;
INSERT INTO tipo_ficha VALUES (1,'MULHER');
INSERT INTO tipo_ficha VALUES (2,'IDOSO');
INSERT INTO tipo_ficha VALUES (3,'CRIANÇA/ADOLESCENTE');
INSERT INTO tipo_ficha VALUES (4,'DEFICIÊNCIA');
INSERT INTO tipo_ficha VALUES (5,'POPULAÇÃO DE RUA');
INSERT INTO tipo_ficha VALUES (6,'MEDIDA SOCIOEDUCATIVA');

CREATE TABLE ficha_mulher
(
  fim_codigo bigserial NOT NULL,
  fim_estuda boolean,
  fim_serie character varying,
  fim_periodo character varying,
  fim_nome_escola character varying,
  fim_responsavel_contato character varying,
  fim_telefone_contato character varying,
  fim_principais_habilidades character varying,
  fim_frequentou_cursos boolean,
  fim_frequentou_cursos_quais character varying,
  fim_estudou_ate_quando character varying,
  fim_motivo_desistencia character varying,
  fim_responsabilidades character varying,
  fim_responsabilidades_com_familiares character varying,
  fim_religiao boolean,
  fim_grupo_atividade boolean,
  fim_atividade character varying,
  fim_trabalha boolean,
  co_ocupacao integer,
  fim_trabalha_tempo character varying,
  fim_trabalha_onde character varying,
  fim_horario_trabalho character varying,
  fim_satisfeito_trabalho boolean,
  fim_vinculo_empregatico character varying,
  fim_profissao_desejada character varying,
  fim_area_interesse character varying,
  fim_aposentado boolean,
  fim_quanto_recebe character varying,
  fim_pencionista boolean,
  fim_pencionista_quanto_recebe character varying,
  fim_bpc boolean,
  fim_bpc_quanto_recebe character varying,
  fim_cad_unico boolean,
  fim_bolsa_familia boolean,
  fim_bolsa_familia_quanto_recebe character varying,
  fim_recebe_cesta_basica boolean,
  fim_inserida_programas integer,
  fim_problemas_saude boolean,
  fim_problemas_saude_quais character varying,
  fim_possui_doencas boolean,
  fim_possui_doencas_quais character varying,
  fim_toma_medicamentos boolean,
  fim_tratamento_especialista boolean,
  fim_fumante boolean,
  fim_realizou_tratamento boolean,
  fim_realizou_tratamento_onde character varying,
  fim_possui_limitacoes_fisicas boolean,
  fim_possui_limitacoes_fisicas_quais character varying,
  fim_procedencia_medicamentos character varying,
  fim_tratamento_odontologico boolean,
  fim_tratamento_odontologico_tempo character varying,
  fim_uso_bebida boolean,
  fim_uso_drogas boolean,
  fim_uso_drogas_quais character varying,
  fim_tratamento_desintoxicacao boolean,
  fim_tratamento_desintoxicacao_onde character varying,
  fim_forma_acesso_servico integer,
  CONSTRAINT ficha_mulher_pkey PRIMARY KEY (fim_codigo )
)
WITH (
  OIDS=FALSE
);

 CREATE TABLE ficha_idoso
(
  fii_codigo bigserial NOT NULL,
  fii_estudou_ate_quando boolean,
  fii_frequentou_cursos_quais character varying,
  fii_aposentado boolean,
  fii_quanto_recebe character varying,
  fii_pencionista boolean,
  fii_pencionista_quanto_recebe character varying,
  fii_bpc boolean,
  fii_bpc_quanto_recebe character varying,
  fii_cad_unico boolean,
  fii_bolsa_familia boolean,
  fii_bolsa_familia_quanto_recebe character varying,
  fii_recebe_cesta_basica boolean,
  fii_inserida_programas integer,
  fii_problemas_saude boolean,
  fii_problemas_saude_quais character varying,
  fii_possui_doencas boolean,
  fii_possui_doencas_quais character varying,
  fii_toma_medicamentos boolean,
  fii_fumante boolean,
  fii_possui_limitacoes_fisicas boolean,
  fii_possui_limitacoes_fisicas_quais character varying,
  fii_procedencia_medicamentos character varying,
  fii_tratamento_odontologico boolean,
  fii_uso_bebida boolean,
  fii_forma_acesso_servico integer,
  CONSTRAINT ficha_idoso_pkey PRIMARY KEY (fii_codigo )
)
WITH (
  OIDS=FALSE
);

CREATE TABLE ficha_crianca_adolescente
(
  fica_codigo bigserial NOT NULL,
  fica_estuda boolean,
  fica_serie character varying,
  fica_periodo character varying,
  fica_nome_escola character varying,
  fica_responsavel_contato character varying,
  fica_telefone_contato character varying,
  fica_principais_habilidades character varying,
  fica_pais_participam_da_vida_escolar boolean,
  fica_pais_participam_da_vida_escolar_como character varying,
  fica_frequentou_cursos boolean,
  fica_frequentou_cursos_quais character varying,
  fica_estudou_ate_quando character varying,
  fica_motivo_desistencia character varying,
  fica_responsabilidades character varying,
  fica_responsabilidades_com_familiares character varying,
  fica_religiao boolean,
  fica_grupo_atividade boolean,
  fica_atividade character varying,
  fica_trabalha boolean,
  co_ocupacao integer,
  fica_trabalha_tempo character varying,
  fica_trabalha_onde character varying,
  fica_horario_trabalho character varying,
  fica_satisfeito_trabalho boolean,
  fica_vinculo_empregatico character varying,
  fica_profissao_desejada character varying,
  fica_area_interesse character varying,
  fica_aposentado boolean,
  fica_quanto_recebe character varying,
  fica_pencionista boolean,
  fica_pencionista_quanto_recebe character varying,
  fica_bpc boolean,
  fica_bpc_quanto_recebe character varying,
  fica_cad_unico boolean,
  fica_bolsa_familia boolean,
  fica_bolsa_familia_quanto_recebe character varying,
  fica_recebe_cesta_basica boolean,
  fica_inserida_programas integer,
  fica_problemas_saude boolean,
  fica_problemas_saude_quais character varying,
  fica_possui_doencas boolean,
  fica_possui_doencas_quais character varying,
  fica_toma_medicamentos boolean,
  fica_tratamento_especialista boolean,
  fica_fumante boolean,
  fica_realizou_tratamento boolean,
  fica_realizou_tratamento_onde character varying,
  fica_possui_limitacoes_fisicas boolean,
  fica_possui_limitacoes_fisicas_quais character varying,
  fica_procedencia_medicamentos character varying,
  fica_tratamento_odontologico boolean,
  fica_tratamento_odontologico_tempo character varying,
  fica_uso_bebida boolean,
  fica_uso_drogas boolean,
  fica_uso_drogas_quais character varying,
  fica_tratamento_desintoxicacao boolean,
  fica_tratamento_desintoxicacao_onde character varying,
  fica_forma_acesso_servico integer,
  CONSTRAINT ficha_cricanca_adolescente_pkey PRIMARY KEY (fica_codigo )
)
WITH (
  OIDS=FALSE
);



 CREATE TABLE ficha_deficiente
(
  fid_codigo bigserial NOT NULL,
  fid_estudou_ate_quando boolean,
  fid_frequentou_cursos_quais character varying,
  fid_aposentado boolean,
  fid_quanto_recebe character varying,
  fid_pencionista boolean,
  fid_pencionista_quanto_recebe character varying,
  fid_bpc boolean,
  fid_bpc_quanto_recebe character varying,
  fid_cad_unico boolean,
  fid_bolsa_familia boolean,
  fid_bolsa_familia_quanto_recebe character varying,
  fid_recebe_cesta_basica boolean,
  fid_inserida_programas integer,
  fid_problemas_saude boolean,
  fid_problemas_saude_quais character varying,
  fid_possui_doencas boolean,
  fid_possui_doencas_quais character varying,
  fid_toma_medicamentos boolean,
  fid_fumante boolean,
  fid_possui_limitacoes_fisicas boolean,
  fid_possui_limitacoes_fisicas_quais character varying,
  fid_procedencia_medicamentos character varying,
  fid_tratamento_odontologico boolean,
  fid_uso_bebida boolean,
  fid_forma_acesso_servico integer,
  fid_responsabilidades_dentro_de_casa character varying,
  fid_quem_lava_suas_roupas character varying,
  fid_quem_faz_comida character varying,
  fid_quem_faz_compras character varying,
  fid_alguem_ajuda_cuidar character varying,
  fid_contribui_com_atividades_domesticas boolean,
  fid_religiao boolean,
  fid_religiao_qual boolean,
  fid_atividades_fora_de_casa boolean,
  fid_atividades_fora_de_casa_quais character varying,
  CONSTRAINT ficha_deficiente_pkey PRIMARY KEY (fid_codigo )
)
WITH (
  OIDS=FALSE
);



 CREATE TABLE ficha_populacao_rua
(
  fip_codigo bigserial NOT NULL,
  fip_estudou_ate_quando boolean,
  fip_frequentou_cursos_quais character varying,
  fip_aposentado boolean,
  fip_quanto_recebe character varying,
  fip_pencionista boolean,
  fip_pencionista_quanto_recebe character varying,
  fip_bpc boolean,
  fip_bpc_quanto_recebe character varying,
  fip_cad_unico boolean,
  fip_bolsa_familia boolean,
  fip_bolsa_familia_quanto_recebe character varying,
  fip_recebe_cesta_basica boolean,
  fip_inserida_programas integer,
  fip_problemas_saude boolean,
  fip_problemas_saude_quais character varying,
  fip_possui_doencas boolean,
  fip_possui_doencas_quais character varying,
  fip_toma_medicamentos boolean,
  fip_fumante boolean,
  fip_possui_limitacoes_fisicas boolean,
  fip_possui_limitacoes_fisicas_quais character varying,
  fip_procedencia_medicamentos character varying,
  fip_tratamento_odontologico boolean,
  fip_uso_bebida boolean,
  fip_forma_acesso_servico integer,
  fip_responsabilidades_dentro_de_casa character varying,
  fip_quem_lava_suas_roupas character varying,
  fip_quem_faz_comida character varying,
  fip_quem_faz_compras character varying,
  fip_alguem_ajuda_cuidar character varying,
  fip_contribui_com_atividades_domesticas boolean,
  fip_religiao boolean,
  fip_religiao_qual boolean,
  fip_atividades_fora_de_casa boolean,
  fip_atividades_fora_de_casa_quais character varying,
  CONSTRAINT ficha_populacao_rua_pkey PRIMARY KEY (fip_codigo )
)
WITH (
  OIDS=FALSE
);

CREATE TABLE ficha_medida_socioeducativa
(
  fims_codigo bigserial NOT NULL,
  fims_estuda boolean,
  fims_serie character varying,
  fims_periodo character varying,
  fims_nome_escola character varying,
  fims_responsavel_contato character varying,
  fims_telefone_contato character varying,
  fims_principais_habilidades character varying,
  fims_pais_participam_da_vida_escolar boolean,
  fims_pais_participam_da_vida_escolar_como character varying,
  fims_frequentou_cursos boolean,
  fims_frequentou_cursos_quais character varying,
  fims_estudou_ate_quando character varying,
  fims_motivo_desistencia character varying,
  fims_responsabilidades character varying,
  fims_responsabilidades_com_familiares character varying,
  fims_religiao boolean,
  fims_grupo_atividade boolean,
  fims_atividade character varying,
  fims_trabalha boolean,
  co_ocupacao integer,
  fims_trabalha_tempo character varying,
  fims_trabalha_onde character varying,
  fims_horario_trabalho character varying,
  fims_satisfeito_trabalho boolean,
  fims_vinculo_empregatico character varying,
  fims_profissao_desejada character varying,
  fims_area_interesse character varying,
  fims_aposentado boolean,
  fims_quanto_recebe character varying,
  fims_pencionista boolean,
  fims_pencionista_quanto_recebe character varying,
  fims_bpc boolean,
  fims_bpc_quanto_recebe character varying,
  fims_cad_unico boolean,
  fims_bolsa_familia boolean,
  fims_bolsa_familia_quanto_recebe character varying,
  fims_recebe_cesta_basica boolean,
  fims_inserida_programas integer,
  fims_problemas_saude boolean,
  fims_problemas_saude_quais character varying,
  fims_possui_doencas boolean,
  fims_possui_doencas_quais character varying,
  fims_toma_medicamentos boolean,
  fims_tratamento_especialista boolean,
  fims_fumante boolean,
  fims_realizou_tratamento boolean,
  fims_realizou_tratamento_onde character varying,
  fims_possui_limitacoes_fisicas boolean,
  fims_possui_limitacoes_fisicas_quais character varying,
  fims_procedencia_medicamentos character varying,
  fims_tratamento_odontologico boolean,
  fims_tratamento_odontologico_tempo character varying,
  fims_uso_bebida boolean,
  fims_uso_drogas boolean,
  fims_uso_drogas_quais character varying,
  fims_tratamento_desintoxicacao boolean,
  fims_tratamento_desintoxicacao_onde character varying,
  fims_medida integer,
  fims_numero_oficio character varying,
  fims_numero_processo integer,
  fims_data_medida timestamp without time zone,
  fims_prazo_medida character varying,
  fims_data_entrada_recebimento_creas timestamp without time zone,
  fims_data_apresentação_adolescente timestamp without time zone,
  fims_atual_medida character(1),
  fims_atual_medida_qntd_vezes integer,
  fims_ato_infracional character varying,
  CONSTRAINT ficha_medida_socioeducativa_pkey PRIMARY KEY (fims_codigo )
)
WITH (
  OIDS=FALSE
);

CREATE TABLE tipo_medida
(
   tim_codigo bigserial, 
   tim_descricao character varying, 
    PRIMARY KEY (tim_codigo)
) 
WITH (
  OIDS = FALSE
)
;
insert into tipo_medida  values (1,'Liberdade Assistida');
insert into tipo_medida  values (2,'Prestação de Serviço a comunidade');
insert into tipo_medida  values (3,'Outros Encaminhamentos');

ALTER TABLE ficha_mulher ADD COLUMN tipo_ficha integer;
ALTER TABLE ficha_mulher ADD FOREIGN KEY (tipo_ficha) REFERENCES tipo_ficha (tpf_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_idoso ADD COLUMN tipo_ficha integer;
ALTER TABLE ficha_idoso ADD FOREIGN KEY (tipo_ficha) REFERENCES tipo_ficha (tpf_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_deficiente ADD COLUMN tipo_ficha integer;
ALTER TABLE ficha_deficiente ADD FOREIGN KEY (tipo_ficha) REFERENCES tipo_ficha (tpf_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_medida_socioeducativa ADD COLUMN tipo_ficha integer;
ALTER TABLE ficha_medida_socioeducativa ADD FOREIGN KEY (tipo_ficha) REFERENCES tipo_ficha (tpf_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_populacao_rua ADD COLUMN tipo_ficha integer;
ALTER TABLE ficha_populacao_rua ADD FOREIGN KEY (tipo_ficha) REFERENCES tipo_ficha (tpf_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_crianca_adolescente ADD COLUMN tipo_ficha integer;
ALTER TABLE ficha_crianca_adolescente ADD FOREIGN KEY (tipo_ficha) REFERENCES tipo_ficha (tpf_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_mulher
   ALTER COLUMN fim_religiao TYPE character varying;

ALTER TABLE ficha_medida_socioeducativa
   ALTER COLUMN fims_religiao TYPE character varying;

 ALTER TABLE ficha_crianca_adolescente
   ALTER COLUMN fica_religiao TYPE character varying;

 ALTER TABLE ficha_mulher
   ALTER COLUMN fim_grupo_atividade TYPE character varying;

ALTER TABLE ficha_medida_socioeducativa
   ALTER COLUMN fims_grupo_atividade TYPE character varying;

 ALTER TABLE ficha_crianca_adolescente
   ALTER COLUMN fica_grupo_atividade TYPE character varying;
   
  ALTER TABLE ficha_idoso
   ALTER COLUMN fii_estudou_ate_quando TYPE character varying;
   
   ALTER TABLE ficha_deficiente
   ALTER COLUMN fid_estudou_ate_quando TYPE character varying;



ALTER TABLE ficha_deficiente
   ALTER COLUMN fid_religiao TYPE character varying;
ALTER TABLE ficha_deficiente
   ALTER COLUMN fid_religiao_qual TYPE character varying;
   
   
ALTER TABLE ficha_populacao_rua
   ALTER COLUMN fip_estudou_ate_quando TYPE character varying;
   
   
ALTER TABLE ficha_populacao_rua
   ALTER COLUMN fip_religiao_qual TYPE character varying;
   
   ALTER TABLE ficha_medida_socioeducativa
   ALTER COLUMN fims_grupo_atividade TYPE character varying;
   
ALTER TABLE ficha_medida_socioeducativa ADD COLUMN fims_forma_acesso_servico integer;

ALTER TABLE agendamento ADD COLUMN tpf_codigo integer;
ALTER TABLE agendamento ADD FOREIGN KEY (tpf_codigo) REFERENCES tipo_ficha (tpf_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

