UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.60.59' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.40.28' WHERE conf_chave='VERSAO_COMUM';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.21.19' WHERE conf_chave='VERSAO_SOCIAL';

CREATE TABLE atendimento_social
(
  ats_codigo bigserial NOT NULL,
  age_codigo integer,
  ats_descricao text,
  ats_plantao_social boolean,
  ats_abertura_cadastro boolean,
  ats_visita_domiciliar boolean,
  ats_atualizacao_documentos boolean,
  ats_beneficio_prestacao_continuada boolean,
  ats_cad_unico_inclusao boolean,
  ats_cad_unico_atualizacao boolean,
  ats_cad_unico_baixa_renda_copel boolean,
  ats_cad_unico_pbf boolean,
  ats_cad_unico_inscricao_concurso boolean,
  ats_cad_unico_inss_5 boolean,
  ats_cad_unico_curso_promatec boolean,
  ats_cad_unico_carteira_idoso boolean,
  ats_cad_unico_bpc boolean,
  ats_cad_unico_minha_casa boolean,
  ats_cad_unico_telefone_popular boolean,
  CONSTRAINT atendimento_social_pkey PRIMARY KEY (ats_codigo ),
  CONSTRAINT atendimento_social_age_codigo_fkey FOREIGN KEY (age_codigo)
      REFERENCES agendamento (age_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE atendimento_social
  OWNER TO postgres;

ALTER TABLE atendimento_social ADD COLUMN ats_cadunico boolean;

insert into acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo) values ('Prontuário Eletrônico',54,'zf/prontuario',13);

ALTER TABLE ficha_crianca_adolescente ADD COLUMN age_codigo bigint;
ALTER TABLE ficha_crianca_adolescente ADD CONSTRAINT agendamento_fkey FOREIGN KEY (age_codigo)
REFERENCES agendamento (age_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;
 
ALTER TABLE  ficha_deficiente ADD COLUMN age_codigo bigint;
ALTER TABLE ficha_deficiente ADD CONSTRAINT agendamento_fkey FOREIGN KEY (age_codigo)
REFERENCES agendamento (age_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_idoso ADD COLUMN age_codigo bigint;
ALTER TABLE ficha_idoso ADD CONSTRAINT agendamento_fkey FOREIGN KEY (age_codigo)
REFERENCES agendamento (age_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_medida_socioeducativa ADD COLUMN age_codigo bigint;
ALTER TABLE ficha_medida_socioeducativa ADD CONSTRAINT agendamento_fkey FOREIGN KEY (age_codigo)
REFERENCES agendamento (age_codigo) MATCH SIMPLE 
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_mulher ADD COLUMN age_codigo bigint;
ALTER TABLE ficha_mulher ADD CONSTRAINT agendamento_fkey FOREIGN KEY (age_codigo)
REFERENCES agendamento (age_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_populacao_rua ADD COLUMN age_codigo bigint;
ALTER TABLE ficha_populacao_rua ADD CONSTRAINT agendamento_fkey FOREIGN KEY (age_codigo)
REFERENCES agendamento (age_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_crianca_adolescente ADD COLUMN usu_codigo bigint;
ALTER TABLE ficha_crianca_adolescente ADD CONSTRAINT usuario_fkey FOREIGN KEY (usu_codigo)
REFERENCES usuario (usu_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;
 
ALTER TABLE  ficha_deficiente ADD COLUMN usu_codigo bigint;
ALTER TABLE ficha_deficiente ADD CONSTRAINT usuario_fkey FOREIGN KEY (usu_codigo)
REFERENCES usuario (usu_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_idoso ADD COLUMN usu_codigo bigint;
ALTER TABLE ficha_idoso ADD CONSTRAINT usuario_fkey FOREIGN KEY (usu_codigo)
REFERENCES usuario (usu_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_medida_socioeducativa ADD COLUMN usu_codigo bigint;
ALTER TABLE ficha_medida_socioeducativa ADD CONSTRAINT usuario_fkey FOREIGN KEY (usu_codigo)
REFERENCES usuario (usu_codigo) MATCH SIMPLE 
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_mulher ADD COLUMN usu_codigo bigint;
ALTER TABLE ficha_mulher ADD CONSTRAINT usuario_fkey FOREIGN KEY (usu_codigo)
REFERENCES usuario (usu_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ficha_populacao_rua ADD COLUMN usu_codigo bigint;
ALTER TABLE ficha_populacao_rua ADD CONSTRAINT usuario_fkey FOREIGN KEY (usu_codigo)
REFERENCES usuario (usu_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

