UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.61.60' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.41.29' WHERE conf_chave='VERSAO_COMUM';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.22.20' WHERE conf_chave='VERSAO_SOCIAL';

-- Table: convenio_dias_semana_agendamento

-- DROP TABLE convenio_dias_semana_agendamento;

CREATE TABLE convenio_dias_semana_agendamento
(
  condi_age_codigo bigserial NOT NULL,
  condi_age_dia integer NOT NULL,
  coni_codigo bigint NOT NULL,
  condi_age_cota_dia integer,
  condi_age_intervalo numeric,
  condi_age_encaixe smallint,
  CONSTRAINT pk_condi_age_codigo PRIMARY KEY (condi_age_codigo),
  CONSTRAINT fk_coni_codigo FOREIGN KEY (coni_codigo)
      REFERENCES convenio_itens (coni_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE convenio_dias_semana_agendamento
  OWNER TO postgres;
  
ALTER TABLE convenio_horarios ADD COLUMN condi_age_codigo integer;
ALTER TABLE convenio_horarios ADD FOREIGN KEY (condi_age_codigo) REFERENCES convenio_dias_semana_agendamento (condi_age_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

-- Table: encaminhamento_externo

-- DROP TABLE encaminhamento_externo;

CREATE TABLE encaminhamento_externo
(
  enc_ext_codigo bigserial NOT NULL,
  ate_codigo bigint NOT NULL,
  usr_codigo bigint,
  enc_ext_agendado_para varchar(100),
  enc_ext_contato varchar(100),
  enc_ext_data date DEFAULT now(),
  enc_ext_hora varchar(20),
  enc_ext_internacao boolean NOT NULL DEFAULT false,
  enc_ext_urgencia boolean NOT NULL DEFAULT false,
  enc_ext_descricao text NOT NULL,
  enc_ext_data_cad timestamp without time zone NOT NULL DEFAULT now(),
  CONSTRAINT pk_enc_ext_codigo PRIMARY KEY (enc_ext_codigo),
  CONSTRAINT fk_ate_codigo 	FOREIGN KEY (ate_codigo)
	REFERENCES atendimento (ate_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
	REFERENCES usuarios (usr_codigo) MATCH SIMPLE 
	ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE encaminhamento_externo
  OWNER TO postgres;
  
ALTER TABLE ficha_medida_socioeducativa RENAME COLUMN fims_data_apresentao_adolescente TO fims_data_apresentacao_adolescente;

INSERT INTO CONFIG (CONF_CHAVE,CONF_LABEL,CONF_READONLY,CONF_TIPO,CONF_VALOR_INT) VALUES ('LIMIT_GUIA_DIAGNOSTICO','Limite de Histrico para Guia','f',3,4);
INSERT INTO CONFIG (CONF_CHAVE,CONF_LABEL,CONF_READONLY,CONF_TIPO,CONF_VALOR_BOOL) VALUES ('GUIA_DIAGNOSTICO','Guia de Diagnostico','f',2,'f');
insert into permissoes(perm_descricao,perm_programa,perm_objeto) VALUES ('Guia de Diagnstico','zf/default/guia-diagnostico','Guia de diagnstico');
ALTER TABLE alerta ADD COLUMN ale_data_insert timestamp without time zone DEFAULT CURRENT_DATE;
ALTER TABLE retorno DROP CONSTRAINT retorno_pc_codigo_fkey;
ALTER TABLE pre_consulta ADD COLUMN pc_data_insert timestamp without time zone DEFAULT CURRENT_DATE;
ALTER TABLE atendimento ADD COLUMN ate_data_insert timestamp without time zone DEFAULT CURRENT_DATE;

CREATE OR REPLACE FUNCTION converte_horarios_agenda_profissional()
	RETURNS void AS
$BODY$
DECLARE
	rec RECORD;
	rec2 RECORD;
	condi_age_codigo_dia INTEGER;
	coni_codigo_dia INTEGER;
BEGIN
	FOR rec IN 
		-- Percorrendo os dias de convnio da tabela convenio_dias_semana e migrando os dados para a convenio_dias_semana_agendamento
		SELECT DISTINCT 
			condi.condi_dia AS condi_age_dia, 
			condi.coni_codigo AS coni_codigo,
			coni.coni_cota_dia AS condi_age_cota_dia,
			coni.coni_encaixe AS condi_age_encaixe,
			coni.coni_intervalo AS condi_age_intervalo
		FROM 
			convenio_dias_semana AS condi
		INNER JOIN 
			convenio_horarios AS convh ON condi.coni_codigo=convh.coni_codigo
		INNER JOIN
			convenio_itens AS coni ON condi.coni_codigo=coni.coni_codigo
		INNER JOIN
			convenio AS conv ON coni.conv_codigo=conv.conv_codigo
	LOOP
		-- Inserindo os novos dias de convnio
		INSERT INTO convenio_dias_semana_agendamento
						(condi_age_dia,
						 coni_codigo,
						 condi_age_cota_dia,
						 condi_age_encaixe,
						 condi_age_intervalo)
					VALUES
						(rec.condi_age_dia,
						 rec.coni_codigo,
						 rec.condi_age_cota_dia,
						 rec.condi_age_encaixe,
						 rec.condi_age_intervalo);
		 -- Pegando o cdigo do ltimo registro inserido para realizar os vinculos com os horrios
		 SELECT condi_age_codigo INTO condi_age_codigo_dia FROM convenio_dias_semana_agendamento ORDER BY condi_age_codigo DESC LIMIT 1; 
		 SELECT coni_codigo INTO coni_codigo_dia FROM convenio_dias_semana_agendamento ORDER BY condi_age_codigo DESC LIMIT 1; 
		 -- Listando os horrios antigos e inserindo os mesmos mas j vinculando com os dias de agendamento
		 FOR rec2 IN 
			SELECT 
				hora_codigo,
				hora_inicial,
				hora_final
			FROM
				convenio_horarios
			WHERE
				coni_codigo = coni_codigo_dia AND
				condi_age_codigo IS NULL
		LOOP
			-- Inserindo os horrios vinculado ao dia de atendimento
			INSERT INTO convenio_horarios
							(hora_inicial,
							 hora_final,
							 coni_codigo,
							 condi_age_codigo)
						VALUES
							(rec2.hora_inicial,
							 rec2.hora_final,
							 coni_codigo_dia,
							 condi_age_codigo_dia);
		END LOOP;
	END LOOP;
END
$BODY$
	LANGUAGE plpgsql VOLATILE
	COST 100;
ALTER FUNCTION converte_horarios_agenda_profissional()
	OWNER TO postgres;
	
SELECT converte_horarios_agenda_profissional();

ALTER TABLE escolaridade
   ALTER COLUMN ecd_codigo TYPE character varying;


update acesso set ace_caminho = 'man_esc.php' where ace_codigo = 7;
ALTER TABLE evento
   ALTER COLUMN eve_data_fim DROP NOT NULL;
   
COMMENT ON COLUMN evento.eve_status IS 'A- ABEERTO
N - ANDAMENTO
F - FECHADO
';

ALTER TABLE grupo_atendimento_usuario DROP COLUMN gruate_codigo;
ALTER TABLE grupo_atendimento_usuario ADD COLUMN eve_codigo integer;
ALTER TABLE grupo_atendimento_usuario ADD FOREIGN KEY (eve_codigo) REFERENCES evento (eve_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
