update estado_civil set estc_descricao = 'Viuvo' where estc_codigo = '3';
update estado_civil set estc_descricao = 'Uniao consensual' where estc_codigo = '5';
update estado_civil set estc_descricao = 'Invalido' where estc_codigo = 'X';

ALTER TABLE pre_consulta ADD COLUMN pc_clas_risco integer;
COMMENT ON COLUMN pre_consulta.pc_clas_risco IS '0 = Imediato(vermelho)
1 = 20 min (amarelo)
2 = 60 min(verde)
3 = 4 horas(azul)';

ALTER TABLE pre_consulta ADD COLUMN pc_glicose double precision;


CREATE OR REPLACE FUNCTION public.pattobpa()
  RETURNS trigger AS
$BODY$
DECLARE
  linha RECORD;
  ci_codigo bigint;  
  codigo bigint; -- ate_codigo, pc_codigo ou pe_codigo
    
BEGIN

	-- Posto de Enfermagem?
	IF NEW.pe_codigo IS NOT NULL THEN
	
		 SELECT INTO linha
					 uni_codigo,
					 pat.usr_codigo,
					 usu_codigo,
					 ate_data AS bpa_data,
					 proc.proc_codigo,
					 proc_bpa_tipo AS bpa_tipo,
					 pat.cd10_codigo AS bpa_cd10_codigo,
					 'procedimento_atendimetno' AS bpa_origem,
					 pat.pat_codigo AS bpa_origem_codigo
			    FROM procedimento_atendimento AS pat
			    JOIN posto_enfermagem AS pe
				  ON pe.pe_codigo=pat.pe_codigo
			    JOIN atendimento AS ate
				  ON ate.ate_codigo=pe.ate_codigo
			    JOIN procedimento AS proc
				  ON proc.proc_codigo=pat.proc_codigo
			   WHERE pat.pat_codigo=NEW.pat_codigo;
			 
	-- Pr-consulta?
	ELSIF NEW.pc_codigo IS NOT NULL THEN
				
		 SELECT INTO linha
					 uni_codigo,
					 pat.usr_codigo,
					 age.usu_codigo,
					 age_data AS bpa_data,
					 proc.proc_codigo,
					 proc_bpa_tipo AS bpa_tipo,
					 pat.cd10_codigo AS bpa_cd10_codigo,
					 'procedimento_atendimetno' AS bpa_origem,
					 pat.pat_codigo AS bpa_origem_codigo
				FROM procedimento_atendimento AS pat
				JOIN pre_consulta AS pc
				  ON pc.pc_codigo=pat.pc_codigo
				JOIN agendamento AS age
				  ON age.age_codigo=pc.age_codigo
				JOIN procedimento AS proc
				  ON proc.proc_codigo=pat.proc_codigo
			   WHERE pat.pat_codigo=NEW.pat_codigo;
			  
	-- Atendimento?
	ELSIF NEW.ate_codigo IS NOT NULL THEN	
		SELECT INTO linha
					uni_codigo,
					pat.usr_codigo,
					ate.usu_codigo,
					ate_data AS bpa_data,
					proc.proc_codigo,
					proc_bpa_tipo AS bpa_tipo,
					pat.cd10_codigo AS bpa_cd10_codigo,
					'procedimento_atendimetno' AS bpa_origem,
					pat.pat_codigo AS bpa_origem_codigo
			   FROM procedimento_atendimento AS pat
			   JOIN atendimento AS ate
				 ON ate.ate_codigo=pat.ate_codigo
			   JOIN procedimento AS proc
				 ON proc.proc_codigo=pat.proc_codigo
			  WHERE pat.pat_codigo=NEW.pat_codigo;
			  
	END IF;					

	-- verificar acidente de trabalho
	SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ci_codigo;
	
	INSERT INTO BPA (uni_codigo,
					 usr_codigo,
					 usu_codigo,
					 bpa_data,
					 proc_codigo,
					 ci_codigo,
					 bpa_tipo,
					 bpa_cd10_codigo,
					 bpa_origem,
					 bpa_origem_codigo)
			 VALUES (linha.uni_codigo,
					 linha.usr_codigo,
					 linha.usu_codigo,
					 linha.bpa_data,
					 linha.proc_codigo,
					 ci_codigo,
					 linha.bpa_tipo,
					 linha.bpa_cd10_codigo,
					 'procedimento_atendimento',
					 NEW.pat_codigo);						
						
	RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma insero na tabela ''procedimento_atendimento''.';
				
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

INSERT INTO usuarios (usr_codigo,usr_login,usr_senha,usr_nome,usr_email,usr_tipo_medico)VALUES(99999,'upa',MD5('123'),' MDICO DA UPA','upas@uol.com.br','M');


INSERT INTO medico_especialidade (med_codigo,esp_codigo)VALUES(99999,1054);


CREATE TABLE atendimento_internacao
(
   atin_codigo bigserial NOT NULL, 
   ate_codigo integer, 
   int_codigo bigint, 
    PRIMARY KEY (atin_codigo), 
    FOREIGN KEY (ate_codigo) REFERENCES atendimento (ate_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;
CREATE TABLE internacao_observacao
(
   io_codigo bigserial, 
   io_status character(1), 
   io_observacao text, 
    PRIMARY KEY (io_codigo)
) 
WITH (
  OIDS = FALSE
)
;

ALTER TABLE internacao_observacao ADD COLUMN qua_codigo bigint;
ALTER TABLE internacao_observacao ADD COLUMN lei_codigo bigint;
ALTER TABLE internacao_observacao ADD FOREIGN KEY (lei_codigo) REFERENCES leito (lei_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE internacao_observacao ADD FOREIGN KEY (qua_codigo) REFERENCES quarto (qua_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE atendimento_internacao DROP COLUMN int_codigo;
ALTER TABLE atendimento_internacao ADD COLUMN io_codigo bigint;
ALTER TABLE atendimento_internacao ADD FOREIGN KEY (io_codigo) REFERENCES internacao_observacao (io_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE internacao_observacao ADD COLUMN io_internado boolean;
COMMENT ON COLUMN internacao_observacao.io_internado IS 'coluna que define se o paciente est internado ou se ele est na fila de espera';
COMMENT ON COLUMN internacao_observacao.io_status IS 'coluna que define se o paciente foi encaminhado para observao ou se foi internado I = internado O = Observao';
ALTER TABLE internacao_observacao ADD COLUMN usr_codigo bigint;
ALTER TABLE internacao_observacao ADD FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
COMMENT ON COLUMN internacao_observacao.usr_codigo IS 'Coluna que fala o usurio que fez';
ALTER TABLE internacao_observacao ADD COLUMN io_data_cadastro timestamp with time zone;

ALTER TABLE internacao_observacao DROP COLUMN qua_codigo;
ALTER TABLE internacao_observacao DROP COLUMN lei_codigo;


ALTER TABLE usuario ADD COLUMN usu_importacao text;


COMMENT ON COLUMN agendamento.age_atendido IS 'S - Recepcionado
A - Atendido
N - Agendado
T - Transferido
F - Faltoso
E - Em atendimento';

DROP TABLE registro;

CREATE TABLE registro
(
  nome character varying(60) NOT NULL,
  modulo character varying(3) NOT NULL,
  validade date NOT NULL,
  dataliberacao date,
  situacao character(1),
  codigo character varying(10),
  senha character varying(100),
  hashsalt character(200) NOT NULL,
  CONSTRAINT registro_pkey PRIMARY KEY (modulo , hashsalt )
)
WITH (
  OIDS=FALSE
);

ALTER TABLE convenio_itens ADD COLUMN coni_ativo character(1);
ALTER TABLE quarto DROP COLUMN qua_nrleitos;
