UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.64.63' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.44.32' WHERE conf_chave='VERSAO_COMUM';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.25.23' WHERE conf_chave='VERSAO_SOCIAL';

insert into config(conf_chave,conf_label,conf_tipo,conf_valor_bool) values('CADASTRO_AISE','Cadastro Unico AISE',2,'f');
alter table psf add column usu_chefe bigint;

DROP VIEW v_consumo_tp_mov;
DROP VIEW v_consumo;
DROP VIEW v_produto_centroestoc;
DROP VIEW v_movimentacao;
DROP VIEW v_inventario;
DROP VIEW v_movimentacao_all;
DROP VIEW reqtransf_naoconsolid;
DROP VIEW agendamentoteste;
DROP VIEW contaprontuarios;
DROP VIEW mov_naoconsolid;
DROP VIEW mov_naoconsolid2;
DROP VIEW mov_naoconsolid_antiga;
DROP VIEW mov_naoconsolid_rel;
DROP VIEW produtosemsaldoant;
DROP VIEW quantidade_prontuario;
DROP VIEW req_atendido;
DROP VIEW req_dispensado;
DROP VIEW req_naoconsolid;
DROP VIEW reqtransf_atendido;
DROP VIEW reqtransf_dispensado;
DROP VIEW v_atend_pam;
DROP VIEW view_apac;
DROP VIEW view_qtde_grade;
DROP VIEW view_qtde_medico;

ALTER TABLE movimento ALTER COLUMN mov_entrada TYPE character(20);
ALTER TABLE movimento ALTER COLUMN mov_saida TYPE character(20);

-- View: agendamentoteste

-- DROP VIEW agendamentoteste;

CREATE OR REPLACE VIEW agendamentoteste AS 
 SELECT y.data, y.consultas, y.medicamentos, y.exame, y.aih, y.apac, 
    COALESCE(y.consultas, 0::numeric) + COALESCE(y.medicamentos, 0::numeric) + COALESCE(y.exame, 0::numeric) + COALESCE(y.aih, 0::numeric) + COALESCE(y.apac, 0::numeric) AS valordetudo
   FROM ( SELECT ( SELECT sum(z.custosim) AS custosim
                   FROM ( SELECT sum(e.esp_custo) AS custosim, 
                                CASE
                                    WHEN a.age_atendido = 'A'::bpchar THEN 'SIM'::text
                                    WHEN a.age_atendido = 'S'::bpchar THEN 'SIM'::text
                                    ELSE NULL::text
                                END AS atendido
                           FROM agendamento a
                      JOIN especialidade e ON a.esp_codigo = e.esp_codigo
                 JOIN usuario u ON a.usu_codigo = u.usu_codigo
            JOIN medico m ON a.med_codigo = m.med_codigo
       JOIN unidade un ON u.uni_origem = un.uni_codigo
      WHERE a.age_item <> 'EX'::bpchar AND to_char(a.age_data::timestamp with time zone, 'mm/yyyy'::text) = x.data AND (a.age_atendido = ANY (ARRAY['A'::bpchar, 'S'::bpchar]))
      GROUP BY a.age_atendido) z
                  GROUP BY z.atendido) AS consultas, 
            ( SELECT sum(faltosos.valor) AS somatudo
                   FROM ( SELECT sum(verifica_preco(xsw.codigo, xsw.set_saida, xsw.mov_data) * xsw.qtde) AS valor, 
                            to_char(xsw.mov_data::timestamp with time zone, 'mm/yyyy'::text) AS mes
                           FROM ( SELECT p.pro_codigo AS codigo, 
                                    im.ite_quantidade AS qtde, m.mov_data, 
                                    m.set_saida
                                   FROM movimento m
                              JOIN itens_movimento im ON m.mov_codigo = im.mov_codigo
                         JOIN produto p ON p.pro_codigo = im.pro_codigo
                        WHERE m.mov_saida = 'D'::bpchar AND to_char(m.mov_data::timestamp with time zone, 'mm/yyyy'::text) = x.data) xsw
                          GROUP BY to_char(xsw.mov_data::timestamp with time zone, 'mm/yyyy'::text)) faltosos) AS medicamentos, 
            ( SELECT valoratendido.custosim AS somaexame
                   FROM ( SELECT sum(p.proc_valor) AS custosim, 
                            to_char(ael.agexl_data::timestamp with time zone, 'mm/yyyy'::text) AS datas
                           FROM agendamento_exame ae
                      JOIN agendamento_exame_lista ael ON ae.agex_codigo = ael.agex_codigo
                 JOIN procedimento p ON p.proc_codigo = ael.proc_codigo
            JOIN usuario u ON ae.usu_codigo = u.usu_codigo
       JOIN unidade un ON u.uni_origem = un.uni_codigo
      WHERE to_char(ael.agexl_data::timestamp with time zone, 'mm/yyyy'::text) = x.data
      GROUP BY to_char(ael.agexl_data::timestamp with time zone, 'mm/yyyy'::text)) valoratendido) AS exame, 
            ( SELECT valor.valor
                   FROM ( SELECT to_char(xe.datainicial::timestamp with time zone, 'mm/yyyy'::text) AS dataaih, 
                            sum(xe.valorhospitalar + xe.servicoprofissional) AS valor
                           FROM ( SELECT a.aih_dataini AS datainicial, 
                                    h.proc_vlsa AS valorhospitalar, 
                                    h.proc_vlsp AS servicoprofissional
                                   FROM aih a
                              JOIN procedimento h ON a.aih_desc_proc_soli = h.proc_codigo
                         JOIN medico m ON a.med_codigo_solicitante = m.med_codigo
                    JOIN usuario u ON a.usu_codigo = u.usu_codigo
                   WHERE to_char(a.aih_dataini::timestamp with time zone, 'mm/yyyy'::text) = x.data) xe
                          GROUP BY to_char(xe.datainicial::timestamp with time zone, 'mm/yyyy'::text)) valor) AS aih, 
            ( SELECT valor.valor
                   FROM ( SELECT to_char(xe.apac_dt_cadastro::timestamp with time zone, 'mm/yyyy'::text) AS dataapac, 
                            sum(xe.valorhospitalar + xe.servicoprofissional) AS valor
                           FROM ( SELECT a.apac_dt_cadastro, 
                                    p.proc_vlsa AS valorhospitalar, 
                                    p.proc_vlsp AS servicoprofissional
                                   FROM apac a
                              JOIN usuario u ON u.usu_codigo = a.pac_codigo
                         JOIN apac_procedimento ap ON a.apac_codigo = ap.apac_codigo
                    JOIN procedimento p ON ap.proc_codigo = p.proc_codigo
               JOIN unidade uni ON a.uni_sol_codigo = uni.uni_codigo
          JOIN medico m ON a.med_sol_codigo = m.med_codigo
         WHERE to_char(a.apac_dt_cadastro::timestamp with time zone, 'mm/yyyy'::text) = x.data) xe
                          GROUP BY to_char(xe.apac_dt_cadastro::timestamp with time zone, 'mm/yyyy'::text)) valor) AS apac, 
            x.data
           FROM ( SELECT DISTINCT to_char(a.age_data::timestamp with time zone, 'mm/yyyy'::text) AS data
                   FROM agendamento a
                  WHERE a.age_item <> 'EX'::bpchar AND to_char(a.age_data::timestamp with time zone, 'yyyy'::text) = '2011'::text AND a.age_data >= '2011-01-01'::date AND a.age_data <= '2011-12-31'::date AND a.age_atendido <> 'T'::bpchar
                  ORDER BY to_char(a.age_data::timestamp with time zone, 'mm/yyyy'::text)) x) y;

ALTER TABLE agendamentoteste
  OWNER TO postgres;

-- View: contaprontuarios

-- DROP VIEW contaprontuarios;

CREATE OR REPLACE VIEW contaprontuarios AS 
 SELECT usuario.usu_codigo, usuario.usu_nome, usuario.usu_prontuario, 
    count(usuario.usu_prontuario::bigint) AS conta
   FROM usuario
  WHERE usuario.usu_prontuario IS NOT NULL
  GROUP BY usuario.usu_codigo, usuario.usu_nome, usuario.usu_prontuario;

ALTER TABLE contaprontuarios
  OWNER TO postgres;

-- View: mov_naoconsolid

-- DROP VIEW mov_naoconsolid;

CREATE OR REPLACE VIEW mov_naoconsolid AS 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_saida) AS setor, 
            mov.mov_saida AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_saida AS codsetor, mov.mov_tipo, 
            mov.mov_saida AS operacao, '-'::text AS sinal, 
            mov.set_entrada AS codsetorsolicit, 
            get_setor(mov.set_entrada) AS nomesetorsolicit, it.ite_codigo, 
                CASE
                    WHEN mov.mov_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(mov.set_saida)::text
                    WHEN mov.mov_saida = 'D'::bpchar THEN ('DISPENSACAO PARA PACIENTE '::text || ' - '::text) || (( SELECT substr(usuario.usu_nome::text, 1, 20) AS substr
                       FROM usuario
                      WHERE usuario.usu_codigo = mov.usu_codigo))
                    WHEN mov.mov_saida = 'P'::bpchar THEN 'SAIDA DE PERMUTA'::text
                    WHEN mov.mov_saida = 'I'::bpchar THEN 'SAIDA POR INVENTARIO'::text
                    WHEN mov.mov_saida = 'A'::bpchar THEN 'SAIDA POR AJUSTE'::text
                    WHEN mov.mov_saida = 'R'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-PE'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-VV'::bpchar THEN 'SAIDA POR VALIDADE VENCIDA'::text
					WHEN mov.mov_saida = 'S-AEA'::bpchar THEN 'SAIDA POR AMOSTRA, EXPOSIÇÃO E ANÁLISE'::text
					WHEN mov.mov_saida = 'S-DEP'::bpchar THEN 'DEVOLUÇÃO DE ENTRADA DE PRODUTO'::text
					WHEN mov.mov_saida = 'S-TR'::bpchar THEN 'SAÍDA POR TRANSFERÊNCIA E REMANEJAMENTO'::text
					WHEN mov.mov_saida = 'S-D'::bpchar THEN 'SAÍDA POR DOAÇÃO'::text
					WHEN mov.mov_saida = 'S-AS'::bpchar THEN 'SAÍDA POR APREENSÃO SANITÁRIA'::text
					WHEN mov.mov_saida = 'S-E'::bpchar THEN 'SAÍDA PARA EMPRÉSTIMO'::text
					WHEN mov.mov_saida = 'S-P'::bpchar THEN 'SAÍDA PARA PACIENTE NÃO IDENTIFICADO'::text
					WHEN mov.mov_saida = 'S-AE'::bpchar THEN 'SAÍDA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_saida = 'O'::bpchar THEN 'OUTRAS SAIDAS'::text
                    WHEN mov.mov_saida = 'M'::bpchar THEN 'SAIDA POR EMPRESTIMO'::text
                    WHEN mov.mov_saida = 'T'::bpchar THEN ('SAIDA POR TRANSFERENCIA PARA '::text || ' '::text) || get_setor(mov.set_entrada)::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_qtde_solicitada
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'S'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'N'::bpchar
UNION 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_entrada) AS setor, 
            mov.mov_entrada AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_entrada AS codsetor, mov.mov_tipo, 
            mov.mov_entrada AS operacao, '+'::text AS sinal, 
            mov.set_saida AS codsetorsolicit, 
            get_setor(mov.set_saida) AS nomesetorsolicit, it.ite_codigo, 
                CASE
                    WHEN mov.mov_entrada = 'E-SI'::bpchar THEN 'ENTRADA POR SALDO DE IMPLANTAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-C'::bpchar THEN 'ENTRADA POR CONCORRÊNCIA'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-CONV'::bpchar THEN 'ENTRADA POR CONVITE'::text
                    WHEN mov.mov_entrada = 'D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-P'::bpchar THEN 'ENTRADA POR PREGÃO'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'A'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-AE'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-EVENTUAL'::bpchar THEN 'ENTRADA POR ENTRADA EVENTUAL'::text
                    WHEN mov.mov_entrada = 'E-O'::bpchar THEN 'ENTRADA POR ENTRADA ORDINÁRIA'::text
                    WHEN mov.mov_entrada = 'E-TP'::bpchar THEN 'ENTRADA POR TOMADA DE PREÇOS'::text
                    WHEN mov.mov_entrada = 'E-INEX'::bpchar THEN 'ENTRADA POR INEXIGIBILIDADE'::text
                    WHEN mov.mov_entrada = 'P'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E-PER'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E'::bpchar THEN 'ENTRADA DE NOTA FISCAL'::text
                    WHEN mov.mov_entrada = 'M'::bpchar THEN 'ENTRADA DE EMPRESTIMO'::text
                    WHEN mov.mov_entrada = 'I'::bpchar THEN 'ENTRADA DE INVENTARIO'::text
                    WHEN mov.mov_entrada = 'O'::bpchar THEN 'OUTRAS ENTRADAS'::text
                    WHEN mov.mov_entrada = 'T'::bpchar THEN 'ENTRADA POR TRANSFERENCIA DE'::text || get_setor(mov.set_entrada)::text
                    WHEN mov.mov_entrada = 'v'::bpchar THEN 'DEVOLUCAO DE SETORES'::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_qtde_solicitada
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND mov.mov_tipo = 'E'::bpchar AND it.ite_consolidado = 'N'::bpchar;

ALTER TABLE mov_naoconsolid
  OWNER TO postgres;

-- View: mov_naoconsolid2

-- DROP VIEW mov_naoconsolid2;

CREATE OR REPLACE VIEW mov_naoconsolid2 AS 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_saida) AS setor, 
            mov.mov_saida AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_saida AS codsetor, mov.mov_tipo, 
            mov.mov_saida AS operacao, '-'::text AS sinal, 
            mov.set_entrada AS codsetorsolicit, 
            get_setor(mov.set_entrada) AS nomesetorsolicit, it.ite_codigo, 
                CASE
                    WHEN mov.mov_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(mov.set_saida)::text
                    WHEN mov.mov_saida = 'D'::bpchar THEN ('DISPENSACAO PARA PACIENTE '::text || ' - '::text) || (( SELECT substr(usuario.usu_nome::text, 1, 20) AS substr
                       FROM usuario
                      WHERE usuario.usu_codigo = mov.usu_codigo))
                    WHEN mov.mov_saida = 'P'::bpchar THEN 'SAIDA DE PERMUTA'::text
                    WHEN mov.mov_saida = 'I'::bpchar THEN 'SAIDA POR INVENTARIO'::text
                    WHEN mov.mov_saida = 'A'::bpchar THEN 'SAIDA POR AJUSTE'::text
                    WHEN mov.mov_saida = 'R'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-PE'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-VV'::bpchar THEN 'SAIDA POR VALIDADE VENCIDA'::text
  					WHEN mov.mov_saida = 'S-AEA'::bpchar THEN 'SAIDA POR AMOSTRA, EXPOSIÇÃO E ANÁLISE'::text
					WHEN mov.mov_saida = 'S-DEP'::bpchar THEN 'DEVOLUÇÃO DE ENTRADA DE PRODUTO'::text
					WHEN mov.mov_saida = 'S-TR'::bpchar THEN 'SAÍDA POR TRANSFERÊNCIA E REMANEJAMENTO'::text
					WHEN mov.mov_saida = 'S-D'::bpchar THEN 'SAÍDA POR DOAÇÃO'::text
					WHEN mov.mov_saida = 'S-AS'::bpchar THEN 'SAÍDA POR APREENSÃO SANITÁRIA'::text
					WHEN mov.mov_saida = 'S-E'::bpchar THEN 'SAÍDA PARA EMPRÉSTIMO'::text
					WHEN mov.mov_saida = 'S-P'::bpchar THEN 'SAÍDA PARA PACIENTE NÃO IDENTIFICADO'::text
					WHEN mov.mov_saida = 'S-AE'::bpchar THEN 'SAÍDA POR AJUSTE DE ESTOQUE'::text
					WHEN mov.mov_saida = 'O'::bpchar THEN 'OUTRAS SAIDAS'::text
                    WHEN mov.mov_saida = 'M'::bpchar THEN 'SAIDA POR EMPRESTIMO'::text
                    WHEN mov.mov_saida = 'T'::bpchar THEN ('SAIDA POR TRANSFERENCIA PARA '::text || ' '::text) || get_setor(mov.set_entrada)::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_qtde_solicitada
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'S'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'N'::bpchar
UNION 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_entrada) AS setor, 
            mov.mov_entrada AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_entrada AS codsetor, mov.mov_tipo, 
            mov.mov_entrada AS operacao, '+'::text AS sinal, 
            mov.set_saida AS codsetorsolicit, 
            get_setor(mov.set_saida) AS nomesetorsolicit, it.ite_codigo, 
                CASE
                    WHEN mov.mov_entrada = 'E-SI'::bpchar THEN 'ENTRADA POR SALDO DE IMPLANTAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-C'::bpchar THEN 'ENTRADA POR CONCORRÊNCIA'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-CONV'::bpchar THEN 'ENTRADA POR CONVITE'::text
                    WHEN mov.mov_entrada = 'D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-P'::bpchar THEN 'ENTRADA POR PREGÃO'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'A'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-AE'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-EVENTUAL'::bpchar THEN 'ENTRADA POR ENTRADA EVENTUAL'::text
                    WHEN mov.mov_entrada = 'E-O'::bpchar THEN 'ENTRADA POR ENTRADA ORDINÁRIA'::text
                    WHEN mov.mov_entrada = 'E-TP'::bpchar THEN 'ENTRADA POR TOMADA DE PREÇOS'::text
                    WHEN mov.mov_entrada = 'E-INEX'::bpchar THEN 'ENTRADA POR INEXIGIBILIDADE'::text
                    WHEN mov.mov_entrada = 'P'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E-PER'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E'::bpchar THEN 'ENTRADA DE NOTA FISCAL'::text
                    WHEN mov.mov_entrada = 'M'::bpchar THEN 'ENTRADA DE EMPRESTIMO'::text
                    WHEN mov.mov_entrada = 'I'::bpchar THEN 'ENTRADA DE INVENTARIO'::text
                    WHEN mov.mov_entrada = 'O'::bpchar THEN 'OUTRAS ENTRADAS'::text
                    WHEN mov.mov_entrada = 'T'::bpchar THEN 'ENTRADA POR TRANSFERENCIA DE'::text || get_setor(mov.set_entrada)::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_qtde_solicitada
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'E'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'N'::bpchar;

ALTER TABLE mov_naoconsolid2
  OWNER TO postgres;

-- View: mov_naoconsolid_antiga

-- DROP VIEW mov_naoconsolid_antiga;

CREATE OR REPLACE VIEW mov_naoconsolid_antiga AS 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_saida) AS setor, 
            mov.mov_saida AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_saida AS codsetor, mov.mov_tipo, 
            mov.mov_saida AS operacao, '-'::text AS sinal, 
            mov.set_entrada AS codsetorsolicit, 
            get_setor(mov.set_entrada) AS nomesetorsolicit, it.ite_codigo, 
                CASE
                    WHEN mov.mov_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(mov.set_saida)::text
                    WHEN mov.mov_saida = 'D'::bpchar THEN ('DISPENSACAO PARA PACIENTE '::text || ' - '::text) || (( SELECT substr(usuario.usu_nome::text, 1, 20) AS substr
                       FROM usuario
                      WHERE usuario.usu_codigo = mov.usu_codigo))
                    WHEN mov.mov_saida = 'P'::bpchar THEN 'SAIDA DE PERMUTA'::text
                    WHEN mov.mov_saida = 'I'::bpchar THEN 'SAIDA POR INVENTARIO'::text
                    WHEN mov.mov_saida = 'A'::bpchar THEN 'SAIDA POR AJUSTE'::text
                    WHEN mov.mov_saida = 'R'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-PE'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-VV'::bpchar THEN 'SAIDA POR VALIDADE VENCIDA'::text
					WHEN mov.mov_saida = 'S-AEA'::bpchar THEN 'SAIDA POR AMOSTRA, EXPOSIÇÃO E ANÁLISE'::text
					WHEN mov.mov_saida = 'S-DEP'::bpchar THEN 'DEVOLUÇÃO DE ENTRADA DE PRODUTO'::text
					WHEN mov.mov_saida = 'S-TR'::bpchar THEN 'SAÍDA POR TRANSFERÊNCIA E REMANEJAMENTO'::text
					WHEN mov.mov_saida = 'S-D'::bpchar THEN 'SAÍDA POR DOAÇÃO'::text
					WHEN mov.mov_saida = 'S-AS'::bpchar THEN 'SAÍDA POR APREENSÃO SANITÁRIA'::text
					WHEN mov.mov_saida = 'S-E'::bpchar THEN 'SAÍDA PARA EMPRÉSTIMO'::text
					WHEN mov.mov_saida = 'S-P'::bpchar THEN 'SAÍDA PARA PACIENTE NÃO IDENTIFICADO'::text
					WHEN mov.mov_saida = 'S-AE'::bpchar THEN 'SAÍDA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_saida = 'O'::bpchar THEN 'OUTRAS SAIDAS'::text
                    WHEN mov.mov_saida = 'M'::bpchar THEN 'SAIDA POR EMPRESTIMO'::text
                    WHEN mov.mov_saida = 'T'::bpchar THEN ('SAIDA POR TRANSFERENCIA PARA '::text || ' '::text) || get_setor(mov.set_entrada)::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_qtde_solicitada
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'S'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'N'::bpchar
UNION 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_entrada) AS setor, 
            mov.mov_entrada AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_entrada AS codsetor, mov.mov_tipo, 
            mov.mov_entrada AS operacao, '+'::text AS sinal, 
            mov.set_saida AS codsetorsolicit, 
            get_setor(mov.set_saida) AS nomesetorsolicit, it.ite_codigo, 
                CASE
                    WHEN mov.mov_entrada = 'E-SI'::bpchar THEN 'ENTRADA POR SALDO DE IMPLANTAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-C'::bpchar THEN 'ENTRADA POR CONCORRÊNCIA'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-CONV'::bpchar THEN 'ENTRADA POR CONVITE'::text
                    WHEN mov.mov_entrada = 'D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-P'::bpchar THEN 'ENTRADA POR PREGÃO'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'A'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-AE'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-EVENTUAL'::bpchar THEN 'ENTRADA POR ENTRADA EVENTUAL'::text
                    WHEN mov.mov_entrada = 'E-O'::bpchar THEN 'ENTRADA POR ENTRADA ORDINÁRIA'::text
                    WHEN mov.mov_entrada = 'E-TP'::bpchar THEN 'ENTRADA POR TOMADA DE PREÇOS'::text
                    WHEN mov.mov_entrada = 'E-INEX'::bpchar THEN 'ENTRADA POR INEXIGIBILIDADE'::text
                    WHEN mov.mov_entrada = 'P'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E-PER'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E'::bpchar THEN 'ENTRADA DE NOTA FISCAL'::text
                    WHEN mov.mov_entrada = 'M'::bpchar THEN 'ENTRADA DE EMPRESTIMO'::text
                    WHEN mov.mov_entrada = 'I'::bpchar THEN 'ENTRADA DE INVENTARIO'::text
                    WHEN mov.mov_entrada = 'O'::bpchar THEN 'OUTRAS ENTRADAS'::text
                    WHEN mov.mov_entrada = 'T'::bpchar THEN 'ENTRADA POR TRANSFERENCIA DE'::text || get_setor(mov.set_entrada)::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_qtde_solicitada
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND mov.mov_tipo = 'E'::bpchar AND it.ite_consolidado = 'N'::bpchar;

ALTER TABLE mov_naoconsolid_antiga
  OWNER TO postgres;

-- View: mov_naoconsolid_rel

-- DROP VIEW mov_naoconsolid_rel;

CREATE OR REPLACE VIEW mov_naoconsolid_rel AS 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_saida) AS setor, 
            mov.mov_saida AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_saida AS codsetor, mov.mov_tipo, 
            mov.mov_saida AS operacao, '-'::text AS sinal, 
            mov.set_entrada AS codsetorsolicit, 
            get_setor(mov.set_entrada) AS nomesetorsolicit, it.ite_codigo, 
                CASE
                    WHEN mov.mov_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(mov.set_saida)::text
                    WHEN mov.mov_saida = 'D'::bpchar THEN ('DISPENSACAO PARA PACIENTE '::text || ' - '::text) || (( SELECT substr(usuario.usu_nome::text, 1, 20) AS substr
                       FROM usuario
                      WHERE usuario.usu_codigo = mov.usu_codigo))
                    WHEN mov.mov_saida = 'P'::bpchar THEN 'SAIDA DE PERMUTA'::text
                    WHEN mov.mov_saida = 'I'::bpchar THEN 'SAIDA POR INVENTARIO'::text
                    WHEN mov.mov_saida = 'A'::bpchar THEN 'SAIDA POR AJUSTE'::text
                    WHEN mov.mov_saida = 'R'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-PE'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-VV'::bpchar THEN 'SAIDA POR VALIDADE VENCIDA'::text
					WHEN mov.mov_saida = 'S-AEA'::bpchar THEN 'SAIDA POR AMOSTRA, EXPOSIÇÃO E ANÁLISE'::text
					WHEN mov.mov_saida = 'S-DEP'::bpchar THEN 'DEVOLUÇÃO DE ENTRADA DE PRODUTO'::text
					WHEN mov.mov_saida = 'S-TR'::bpchar THEN 'SAÍDA POR TRANSFERÊNCIA E REMANEJAMENTO'::text
					WHEN mov.mov_saida = 'S-D'::bpchar THEN 'SAÍDA POR DOAÇÃO'::text
					WHEN mov.mov_saida = 'S-AS'::bpchar THEN 'SAÍDA POR APREENSÃO SANITÁRIA'::text
					WHEN mov.mov_saida = 'S-E'::bpchar THEN 'SAÍDA PARA EMPRÉSTIMO'::text
					WHEN mov.mov_saida = 'S-P'::bpchar THEN 'SAÍDA PARA PACIENTE NÃO IDENTIFICADO'::text
					WHEN mov.mov_saida = 'S-AE'::bpchar THEN 'SAÍDA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_saida = 'O'::bpchar THEN 'OUTRAS SAIDAS'::text
                    WHEN mov.mov_saida = 'M'::bpchar THEN 'SAIDA POR EMPRESTIMO'::text
                    WHEN mov.mov_saida = 'T'::bpchar THEN ('SAIDA POR TRANSFERENCIA PARA '::text || ' '::text) || get_setor(mov.set_entrada)::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_qtde_solicitada
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'S'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'N'::bpchar
UNION 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_entrada) AS setor, 
            mov.mov_entrada AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_entrada AS codsetor, mov.mov_tipo, 
            mov.mov_entrada AS operacao, '+'::text AS sinal, 
            mov.set_saida AS codsetorsolicit, 
            get_setor(mov.set_saida) AS nomesetorsolicit, it.ite_codigo, 
                CASE
                    WHEN mov.mov_entrada = 'E-SI'::bpchar THEN 'ENTRADA POR SALDO DE IMPLANTAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-C'::bpchar THEN 'ENTRADA POR CONCORRÊNCIA'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-CONV'::bpchar THEN 'ENTRADA POR CONVITE'::text
                    WHEN mov.mov_entrada = 'D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-P'::bpchar THEN 'ENTRADA POR PREGÃO'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'A'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-AE'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-EVENTUAL'::bpchar THEN 'ENTRADA POR ENTRADA EVENTUAL'::text
                    WHEN mov.mov_entrada = 'E-O'::bpchar THEN 'ENTRADA POR ENTRADA ORDINÁRIA'::text
                    WHEN mov.mov_entrada = 'E-TP'::bpchar THEN 'ENTRADA POR TOMADA DE PREÇOS'::text
                    WHEN mov.mov_entrada = 'E-INEX'::bpchar THEN 'ENTRADA POR INEXIGIBILIDADE'::text
                    WHEN mov.mov_entrada = 'P'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E-PER'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E'::bpchar THEN 'ENTRADA DE NOTA FISCAL'::text
                    WHEN mov.mov_entrada = 'M'::bpchar THEN 'ENTRADA DE EMPRESTIMO'::text
                    WHEN mov.mov_entrada = 'I'::bpchar THEN 'ENTRADA DE INVENTARIO'::text
                    WHEN mov.mov_entrada = 'O'::bpchar THEN 'OUTRAS ENTRADAS'::text
                    WHEN mov.mov_entrada = 'T'::bpchar THEN 'ENTRADA POR TRANSFERENCIA DE'::text || get_setor(mov.set_entrada)::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_qtde_solicitada
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'E'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'N'::bpchar;

ALTER TABLE mov_naoconsolid_rel
  OWNER TO postgres;

-- View: produtosemsaldoant

-- DROP VIEW produtosemsaldoant;

CREATE OR REPLACE VIEW produtosemsaldoant AS 
 SELECT precoanterior.produto, precoanterior.data, precoanterior.preco
   FROM precoanterior
  WHERE NOT (precoanterior.produto IN ( SELECT saldo.pro_codigo
           FROM saldo));

ALTER TABLE produtosemsaldoant
  OWNER TO postgres;

-- View: quantidade_prontuario

-- DROP VIEW quantidade_prontuario;

CREATE OR REPLACE VIEW quantidade_prontuario AS 
 SELECT usuario.usu_prontuario_num, 
    count(usuario.usu_prontuario_num) AS contaprontuario
   FROM usuario
  WHERE usuario.usu_prontuario_num IS NOT NULL
  GROUP BY usuario.usu_prontuario_num
  ORDER BY usuario.usu_prontuario_num;

ALTER TABLE quantidade_prontuario
  OWNER TO postgres;

-- View: req_atendido

-- DROP VIEW req_atendido;

CREATE OR REPLACE VIEW req_atendido AS 
 SELECT to_char(req.req_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
    req.req_data, req.req_nr_nota, get_setor(req.set_saida) AS setor, 
    req.req_saida AS tipomovim, it.pro_codigo, produto.pro_nome, req.req_codigo, 
    req.set_saida AS codsetor, req.req_tipo, req.req_saida AS operacao, 
    '-' AS sinal, req.set_entrada AS codsetorsolicit, 
    get_setor(req.set_entrada) AS nomesetorsolicit, it.ireq_codigo, 
        CASE
            WHEN req.req_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(req.set_saida)::text
            ELSE NULL::text
        END AS desc_movimentacao, 
    it.ireq_quantidade, it.ireq_qtde_solicitada, 
        CASE
            WHEN it.ireq_consolidado = 'R'::bpchar THEN 'REQUISITADO '::text
            WHEN it.ireq_consolidado = 'D'::bpchar THEN 'DISPENSADO  '::text
            WHEN it.ireq_consolidado = 'A'::bpchar THEN 'ATENDIDO    '::text
            WHEN it.ireq_consolidado = 'C'::bpchar THEN 'CANCELADO   '::text
            ELSE NULL::text
        END AS desc_status, 
    it.ireq_consolidado
   FROM requisicao req, itens_requisicao it, produto
  WHERE req.req_codigo = it.req_codigo AND it.pro_codigo = produto.pro_codigo AND req.req_tipo = 'S'::bpchar AND it.ireq_consolidado = 'A'::bpchar;

ALTER TABLE req_atendido
  OWNER TO postgres;

-- View: req_dispensado

-- DROP VIEW req_dispensado;

CREATE OR REPLACE VIEW req_dispensado AS 
 SELECT to_char(req.req_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
    req.req_data, req.req_nr_nota, get_setor(req.set_saida) AS setor, 
    req.req_saida AS tipomovim, it.pro_codigo, produto.pro_nome, req.req_codigo, 
    req.set_saida AS codsetor, req.req_tipo, req.req_saida AS operacao, 
    '-' AS sinal, req.set_entrada AS codsetorsolicit, 
    get_setor(req.set_entrada) AS nomesetorsolicit, it.ireq_codigo, 
        CASE
            WHEN req.req_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(req.set_saida)::text
            ELSE NULL::text
        END AS desc_movimentacao, 
    it.ireq_quantidade, it.ireq_qtde_solicitada, 
        CASE
            WHEN it.ireq_consolidado = 'R'::bpchar THEN 'REQUISITADO '::text
            WHEN it.ireq_consolidado = 'D'::bpchar THEN 'DISPENSADO  '::text
            WHEN it.ireq_consolidado = 'A'::bpchar THEN 'ATENDIDO    '::text
            WHEN it.ireq_consolidado = 'C'::bpchar THEN 'CANCELADO   '::text
            ELSE NULL::text
        END AS desc_status, 
    it.ireq_consolidado, it.ireq_status
   FROM requisicao req, itens_requisicao it, produto
  WHERE req.req_codigo = it.req_codigo AND it.pro_codigo = produto.pro_codigo AND req.req_tipo = 'S'::bpchar AND it.ireq_consolidado = 'D'::bpchar;

ALTER TABLE req_dispensado
  OWNER TO postgres;

-- View: req_naoconsolid

-- DROP VIEW req_naoconsolid;

CREATE OR REPLACE VIEW req_naoconsolid AS 
 SELECT to_char(req.req_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
    req.req_data, req.req_nr_nota, get_setor(req.set_saida) AS setor, 
    req.req_saida AS tipomovim, it.pro_codigo, produto.pro_nome, req.req_codigo, 
    req.set_saida AS codsetor, req.req_tipo, req.req_saida AS operacao, 
    '-' AS sinal, req.set_entrada AS codsetorsolicit, 
    get_setor(req.set_entrada) AS nomesetorsolicit, it.ireq_codigo, 
        CASE
            WHEN req.req_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(req.set_saida)::text
            ELSE NULL::text
        END AS desc_movimentacao, 
    it.ireq_quantidade, it.ireq_qtde_solicitada, 
        CASE
            WHEN it.ireq_consolidado = 'R'::bpchar THEN 'REQUISITADO '::text
            WHEN it.ireq_consolidado = 'D'::bpchar THEN 'DISPENSADO  '::text
            WHEN it.ireq_consolidado = 'A'::bpchar THEN 'ATENDIDO    '::text
            WHEN it.ireq_consolidado = 'C'::bpchar THEN 'CANCELADO   '::text
            ELSE NULL::text
        END AS desc_status, 
    it.ireq_consolidado
   FROM requisicao req, itens_requisicao it, produto
  WHERE req.req_codigo = it.req_codigo AND it.pro_codigo = produto.pro_codigo AND req.req_tipo = 'S'::bpchar AND it.ireq_consolidado = 'R'::bpchar;

ALTER TABLE req_naoconsolid
  OWNER TO postgres;

-- View: reqtransf_atendido

-- DROP VIEW reqtransf_atendido;

CREATE OR REPLACE VIEW reqtransf_atendido AS 
 SELECT to_char(req.req_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
    req.req_data, req.req_nr_nota, get_setor(req.set_saida) AS setor, 
    req.req_saida AS tipomovim, it.pro_codigo, produto.pro_nome, req.req_codigo, 
    req.set_saida AS codsetor, req.req_tipo, req.req_saida AS operacao, 
    '-' AS sinal, req.set_entrada AS codsetorsolicit, 
    get_setor(req.set_entrada) AS nomesetorsolicit, it.ireq_codigo, 
        CASE
            WHEN req.req_saida = 'T'::bpchar THEN (('REQUISICAO DE TRANSFERENCIA '::text || get_setor(req.set_saida)::text) || ' PARA '::text) || get_setor(req.set_entrada)::text
            ELSE NULL::text
        END AS desc_movimentacao, 
    it.ireq_quantidade, it.ireq_qtde_solicitada, 
        CASE
            WHEN it.ireq_consolidado = 'R'::bpchar THEN 'REQUISITADO '::text
            WHEN it.ireq_consolidado = 'D'::bpchar THEN 'DISPENSADO  '::text
            WHEN it.ireq_consolidado = 'A'::bpchar THEN 'ATENDIDO    '::text
            WHEN it.ireq_consolidado = 'C'::bpchar THEN 'CANCELADO   '::text
            ELSE NULL::text
        END AS desc_status, 
    it.ireq_consolidado
   FROM requisicao req, itens_requisicao it, produto
  WHERE req.req_codigo = it.req_codigo AND it.pro_codigo = produto.pro_codigo AND req.req_tipo = 'T'::bpchar AND it.ireq_consolidado = 'A'::bpchar;

ALTER TABLE reqtransf_atendido
  OWNER TO postgres;

-- View: reqtransf_dispensado

-- DROP VIEW reqtransf_dispensado;

CREATE OR REPLACE VIEW reqtransf_dispensado AS 
 SELECT to_char(req.req_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
    req.req_data, req.req_nr_nota, get_setor(req.set_saida) AS setor, 
    req.req_saida AS tipomovim, it.pro_codigo, produto.pro_nome, req.req_codigo, 
    req.set_saida AS codsetor, req.req_tipo, req.req_saida AS operacao, 
    '-' AS sinal, req.set_entrada AS codsetorsolicit, 
    get_setor(req.set_entrada) AS nomesetorsolicit, it.ireq_codigo, 
        CASE
            WHEN req.req_saida = 'T'::bpchar THEN (('REQUISICAO DE TRANSFERENCIA '::text || get_setor(req.set_saida)::text) || ' PARA '::text) || get_setor(req.set_entrada)::text
            ELSE NULL::text
        END AS desc_movimentacao, 
    it.ireq_quantidade, it.ireq_qtde_solicitada, 
        CASE
            WHEN it.ireq_consolidado = 'R'::bpchar THEN 'REQUISITADO '::text
            WHEN it.ireq_consolidado = 'D'::bpchar THEN 'DISPENSADO  '::text
            WHEN it.ireq_consolidado = 'A'::bpchar THEN 'ATENDIDO    '::text
            WHEN it.ireq_consolidado = 'C'::bpchar THEN 'CANCELADO   '::text
            ELSE NULL::text
        END AS desc_status, 
    it.ireq_consolidado
   FROM requisicao req, itens_requisicao it, produto
  WHERE req.req_codigo = it.req_codigo AND it.pro_codigo = produto.pro_codigo AND req.req_tipo = 'T'::bpchar AND it.ireq_consolidado = 'D'::bpchar;

ALTER TABLE reqtransf_dispensado
  OWNER TO postgres;

-- View: reqtransf_naoconsolid

-- DROP VIEW reqtransf_naoconsolid;

CREATE OR REPLACE VIEW reqtransf_naoconsolid AS 
 SELECT to_char(req.req_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
    req.req_data, req.req_nr_nota, get_setor(req.set_saida) AS setor, 
    req.req_saida AS tipomovim, it.pro_codigo, produto.pro_nome, req.req_codigo, 
    req.set_saida AS codsetor, req.req_tipo, req.req_saida AS operacao, 
    '-' AS sinal, req.set_entrada AS codsetorsolicit, 
    get_setor(req.set_entrada) AS nomesetorsolicit, it.ireq_codigo, 
        CASE
            WHEN req.req_saida = 'T'::bpchar THEN (('REQUISICAO DE TRANSFERENCIA '::text || get_setor(req.set_saida)::text) || ' PARA '::text) || get_setor(req.set_entrada)::text
            ELSE NULL::text
        END AS desc_movimentacao, 
    it.ireq_quantidade, it.ireq_qtde_solicitada, 
        CASE
            WHEN it.ireq_consolidado = 'R'::bpchar THEN 'REQUISITADO '::text
            WHEN it.ireq_consolidado = 'D'::bpchar THEN 'DISPENSADO  '::text
            WHEN it.ireq_consolidado = 'A'::bpchar THEN 'ATENDIDO    '::text
            WHEN it.ireq_consolidado = 'C'::bpchar THEN 'CANCELADO   '::text
            ELSE NULL::text
        END AS desc_status, 
    it.ireq_consolidado
   FROM requisicao req, itens_requisicao it, produto
  WHERE req.req_codigo = it.req_codigo AND it.pro_codigo = produto.pro_codigo AND req.req_tipo = 'T'::bpchar AND it.ireq_consolidado = 'R'::bpchar;

ALTER TABLE reqtransf_naoconsolid
  OWNER TO postgres;

-- View: v_atend_pam

-- DROP VIEW v_atend_pam;

CREATE OR REPLACE VIEW v_atend_pam AS 
 SELECT atendimento.ate_codigo, atendimento.usu_codigo, atendimento.med_codigo, 
    usuario.usu_nome, 
    to_char(usuario.usu_datanasc::timestamp with time zone, 'DD/MM/YYYY'::text) AS datanasc, 
    usuario.usu_same, usuario.usu_cisvir, atendimento.ate_hora, 
    atendimento.ate_data, usuario.usu_sexo, 
    calcula_idade(usuario.usu_codigo) AS idade, atendimento.ate_datafinal, 
    atendimento.ate_horafinal, usuario.usu_end_cidade, 
    usuario.muni_cd_cod_ibge_resid, 
        CASE
            WHEN usuario.muni_cd_cod_ibge_resid IS NULL THEN 'CIDADE NAO INFORMADA NO CADASTRO DO PACIENTE'::character varying
            WHEN usuario.muni_cd_cod_ibge_resid::text = ''::text THEN 'CIDADE NAO INFORMADA NO CADASTRO DO PACIENTE'::character varying
            WHEN usuario.muni_cd_cod_ibge_resid IS NOT NULL THEN ( SELECT cidade.cid_nome
               FROM cidade
              WHERE usuario.muni_cd_cod_ibge_resid::text = cidade.cid_codigo_ibge::text)
            ELSE NULL::character varying
        END AS nomecidade
   FROM atendimento, usuario
  WHERE atendimento.usu_codigo = usuario.usu_codigo;

ALTER TABLE v_atend_pam
  OWNER TO postgres;

-- View: view_apac

-- DROP VIEW view_apac;

CREATE OR REPLACE VIEW view_apac AS 
 SELECT a.apac_codigo, a.apac_num, a.apac_ano_competencia, 
    a.apac_mes_competencia, a.apac_dt_cadastro, 
        CASE
            WHEN a.pac_codigo IS NOT NULL THEN a.pac_codigo
            WHEN a.pac_apac_codigo IS NOT NULL THEN a.pac_apac_codigo
            ELSE 0::bigint
        END AS usu_codigo, 
        CASE
            WHEN a.pac_codigo IS NOT NULL THEN p0.usu_nome
            WHEN a.pac_apac_codigo IS NOT NULL THEN p1.pac_nome
            ELSE 'none'::character varying
        END AS pac_nome, 
        CASE
            WHEN a.pac_codigo IS NOT NULL THEN p0.usu_cpf
            WHEN a.pac_apac_codigo IS NOT NULL THEN p1.pac_cpf_cns
            ELSE 'none'::character varying
        END AS pac_cpf, 
        CASE
            WHEN a.uni_sol_codigo IS NOT NULL THEN u0.uni_desc
            WHEN a.uni_sol_apac_codigo IS NOT NULL THEN u1.uni_desc
            ELSE 'none'::character varying
        END AS uni_sol_desc, 
        CASE
            WHEN a.med_sol_codigo IS NOT NULL THEN m0.med_nome
            WHEN a.med_sol_apac_codigo IS NOT NULL THEN m1.med_nome
            ELSE 'none'::character varying
        END AS med_nome, 
        CASE
            WHEN a.med_sol_codigo IS NOT NULL THEN m0.med_cpf
            WHEN a.med_sol_apac_codigo IS NOT NULL THEN m1.med_cpf
            ELSE 'none'::character varying
        END AS med_cpf, 
        CASE
            WHEN a.orgao_codigo IS NOT NULL THEN u2.uni_desc
            WHEN a.orgao_apac_codigo IS NOT NULL THEN u3.uni_desc
            ELSE 'none'::character varying
        END AS orgao_desc, 
        CASE
            WHEN a.orgao_codigo IS NOT NULL THEN u2.uni_codigo
            WHEN a.orgao_apac_codigo IS NOT NULL THEN u3.uni_codigo
            ELSE 0::bigint
        END AS orgao_codigo, 
        CASE
            WHEN a.uni_pres_codigo IS NOT NULL THEN (((u4.uni_desc::text || ', '::text) || COALESCE(u4.uni_cnpj, '000.000.000-00'::character varying)::text) || ', '::text) || u4.uni_codigo::text
            WHEN a.uni_pres_apac_codigo IS NOT NULL THEN (((u5.uni_desc::text || ', '::text) || COALESCE(u5.uni_cnpj, '000.000.000-00'::character varying)::text) || ', '::text) || u5.uni_codigo::text
            ELSE 'none'::text
        END AS uni_pres_desc, 
        CASE
            WHEN a.uni_pres_codigo IS NOT NULL THEN COALESCE(u4.uni_cnpj, '000.000.000-00'::character varying)
            WHEN a.uni_pres_apac_codigo IS NOT NULL THEN COALESCE(u5.uni_cnpj, '000.000.000-00'::character varying)
            ELSE 'none'::character varying
        END AS uni_pres_cpf, 
        CASE
            WHEN a.med_aud_codigo IS NOT NULL THEN m2.med_nome
            WHEN a.med_aud_apac_codigo IS NOT NULL THEN m3.med_nome
            ELSE 'none'::character varying
        END AS med_aud_nome, 
        CASE
            WHEN a.med_aud_codigo IS NOT NULL THEN COALESCE(m2.med_cpf, '000.000.000-00'::character varying)
            WHEN a.med_aud_apac_codigo IS NOT NULL THEN COALESCE(m3.med_cpf, '000.000.000-00'::character varying)
            ELSE 'none'::character varying
        END AS med_aud_cpf, 
    to_char(a.apac_periodo_validade::timestamp with time zone, 'DD/MM/YYYY'::text) AS periodo_validade, 
    to_char(a.apac_periodo_validade_fim::timestamp with time zone, 'DD/MM/YYYY'::text) AS periodo_validade_fim, 
    a.apac_segunda_via
   FROM apac a
   LEFT JOIN usuario p0 ON p0.usu_codigo = a.pac_codigo
   LEFT JOIN apac_paciente p1 ON p1.pac_codigo = a.pac_apac_codigo
   LEFT JOIN unidade u0 ON u0.uni_codigo = a.uni_sol_codigo
   LEFT JOIN apac_unidade u1 ON u1.uni_codigo = a.uni_sol_apac_codigo
   LEFT JOIN medico m0 ON m0.med_codigo = a.med_sol_codigo
   LEFT JOIN apac_medico m1 ON m1.med_codigo = a.med_sol_apac_codigo
   LEFT JOIN unidade u2 ON u2.uni_codigo = a.orgao_codigo
   LEFT JOIN apac_unidade u3 ON u3.uni_codigo = a.orgao_apac_codigo
   LEFT JOIN unidade u4 ON u4.uni_codigo = a.uni_pres_codigo
   LEFT JOIN apac_unidade u5 ON u5.uni_codigo = a.uni_pres_apac_codigo
   LEFT JOIN medico m2 ON m2.med_codigo = a.med_aud_codigo
   LEFT JOIN apac_medico m3 ON m3.med_codigo = a.med_aud_apac_codigo;

ALTER TABLE view_apac
  OWNER TO postgres;

-- View: view_qtde_grade

-- DROP VIEW view_qtde_grade;

CREATE OR REPLACE VIEW view_qtde_grade AS 
 SELECT grade_medico.esp_codigo, grade_medico.age_tipo, grade_medico.age_item, 
    grade_medico.med_codigo, grade_medico.uni_codigo, grade_medico.gra_data, 
    grade_medico.gra_hora_ini, sum(grade_medico.gra_qtde) AS qtde
   FROM grade_medico
  GROUP BY grade_medico.esp_codigo, grade_medico.age_tipo, grade_medico.age_item, grade_medico.med_codigo, grade_medico.uni_codigo, grade_medico.gra_data, grade_medico.gra_hora_ini;

ALTER TABLE view_qtde_grade
  OWNER TO postgres;

-- View: view_qtde_medico

-- DROP VIEW view_qtde_medico;

CREATE OR REPLACE VIEW view_qtde_medico AS 
 SELECT agendamento.esp_codigo, agendamento.med_codigo, agendamento.uni_codigo, 
    agendamento.age_data, agendamento.age_hora, agendamento.age_item, 
    agendamento.age_tipo, count(agendamento.age_codigo) AS qtde, 
    agendamento.age_atendido
   FROM agendamento
  GROUP BY agendamento.med_codigo, agendamento.esp_codigo, agendamento.uni_codigo, agendamento.age_data, agendamento.age_hora, agendamento.age_item, agendamento.age_tipo, agendamento.age_atendido;

ALTER TABLE view_qtde_medico
  OWNER TO postgres;

-- View: v_movimentacao

-- DROP VIEW v_movimentacao;

CREATE OR REPLACE VIEW v_movimentacao AS 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_saida) AS setor, 
            mov.mov_saida AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_saida AS codsetor, mov.mov_tipo, 
            mov.mov_saida AS operacao, '-'::text AS sinal, 
            mov.set_entrada AS codsetorsolicit, 
            get_setor(mov.set_entrada) AS nomesetorsolicit, 
                CASE
                    WHEN mov.mov_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(mov.set_saida)::text
                    WHEN mov.mov_saida = 'D'::bpchar THEN ('DISPENSACAO PARA PACIENTE '::text || ' - '::text) || (( SELECT substr(usuario.usu_nome::text, 1, 20) AS substr
                       FROM usuario
                      WHERE usuario.usu_codigo = mov.usu_codigo))
                    WHEN mov.mov_saida = 'P'::bpchar THEN 'SAIDA DE PERMUTA'::text
                    WHEN mov.mov_saida = 'I'::bpchar THEN 'SAIDA POR INVENTARIO'::text
                    WHEN mov.mov_saida = 'A'::bpchar THEN 'SAIDA POR AJUSTE'::text
                    WHEN mov.mov_saida = 'R'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-PE'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-VV'::bpchar THEN 'SAIDA POR VALIDADE VENCIDA'::text
					WHEN mov.mov_saida = 'S-AEA'::bpchar THEN 'SAIDA POR AMOSTRA, EXPOSIÇÃO E ANÁLISE'::text
					WHEN mov.mov_saida = 'S-DEP'::bpchar THEN 'DEVOLUÇÃO DE ENTRADA DE PRODUTO'::text
					WHEN mov.mov_saida = 'S-TR'::bpchar THEN 'SAÍDA POR TRANSFERÊNCIA E REMANEJAMENTO'::text
					WHEN mov.mov_saida = 'S-D'::bpchar THEN 'SAÍDA POR DOAÇÃO'::text
					WHEN mov.mov_saida = 'S-AS'::bpchar THEN 'SAÍDA POR APREENSÃO SANITÁRIA'::text
					WHEN mov.mov_saida = 'S-E'::bpchar THEN 'SAÍDA PARA EMPRÉSTIMO'::text
					WHEN mov.mov_saida = 'S-P'::bpchar THEN 'SAÍDA PARA PACIENTE NÃO IDENTIFICADO'::text
					WHEN mov.mov_saida = 'S-AE'::bpchar THEN 'SAÍDA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_saida = 'O'::bpchar THEN 'OUTRAS SAIDAS'::text
                    WHEN mov.mov_saida = 'M'::bpchar THEN 'SAIDAS DE EMPRESTIMOS'::text
                    WHEN mov.mov_saida = 'T'::bpchar THEN 'SAIDA POR TRANSFERENCIA PARA '::text || get_setor(mov.set_saida)::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_vlrunit, mov.age_codigo, mov.usu_codigo
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'S'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
UNION ALL 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_entrada) AS setor, 
            mov.mov_entrada AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_entrada AS codsetor, mov.mov_tipo, 
            mov.mov_entrada AS operacao, '+'::text AS sinal, 
            mov.set_saida AS codsetorsolicit, 
            get_setor(mov.set_saida) AS nomesetorsolicit, 
                CASE
                    WHEN mov.mov_entrada = 'E-SI'::bpchar THEN 'ENTRADA POR SALDO DE IMPLANTAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-C'::bpchar THEN 'ENTRADA POR CONCORRÊNCIA'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-CONV'::bpchar THEN 'ENTRADA POR CONVITE'::text
                    WHEN mov.mov_entrada = 'D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-P'::bpchar THEN 'ENTRADA POR PREGÃO'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'A'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-AE'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-EVENTUAL'::bpchar THEN 'ENTRADA POR ENTRADA EVENTUAL'::text
                    WHEN mov.mov_entrada = 'E-O'::bpchar THEN 'ENTRADA POR ENTRADA ORDINÁRIA'::text
                    WHEN mov.mov_entrada = 'E-TP'::bpchar THEN 'ENTRADA POR TOMADA DE PREÇOS'::text
                    WHEN mov.mov_entrada = 'E-INEX'::bpchar THEN 'ENTRADA POR INEXIGIBILIDADE'::text
                    WHEN mov.mov_entrada = 'P'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E-PER'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E'::bpchar THEN 'ENTRADA DE NOTA FISCAL'::text
                    WHEN mov.mov_entrada = 'M'::bpchar THEN 'ENTRADA DE EMPRESTIMO'::text
                    WHEN mov.mov_entrada = 'I'::bpchar THEN 'ENTRADA DE INVENTARIO'::text
                    WHEN mov.mov_entrada = 'O'::bpchar THEN 'OUTRAS ENTRADAS'::text
                    WHEN mov.mov_entrada = 'T'::bpchar THEN 'ENTRADA POR TRANSFERENCIA DE'::text || get_setor(mov.set_entrada)::text
                    WHEN mov.mov_entrada = 'v'::bpchar THEN 'DEVOLUCAO DE SETORES'::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_vlrunit, mov.age_codigo, mov.usu_codigo
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'E'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
  ORDER BY 2, 10;

ALTER TABLE v_movimentacao
  OWNER TO postgres;
GRANT ALL ON TABLE v_movimentacao TO postgres;

-- View: v_produto_centroestoc

-- DROP VIEW v_produto_centroestoc;

CREATE OR REPLACE VIEW v_produto_centroestoc AS 
        ( SELECT DISTINCT v_movimentacao.codsetor, 
            v_movimentacao.setor AS nomesetor, v_movimentacao.pro_codigo, 
            v_movimentacao.pro_nome
           FROM v_movimentacao
          ORDER BY v_movimentacao.codsetor, v_movimentacao.setor, v_movimentacao.pro_codigo, v_movimentacao.pro_nome)
UNION 
        ( SELECT DISTINCT saldo.set_codigo AS codsetor, 
            get_setor(saldo.set_codigo) AS nomesetor, saldo.pro_codigo, 
            get_produto(saldo.pro_codigo) AS pro_nome
           FROM saldo
          ORDER BY saldo.set_codigo, get_setor(saldo.set_codigo), saldo.pro_codigo, get_produto(saldo.pro_codigo));

ALTER TABLE v_produto_centroestoc
  OWNER TO postgres;
GRANT ALL ON TABLE v_produto_centroestoc TO postgres;
GRANT ALL ON TABLE v_produto_centroestoc TO public;

CREATE OR REPLACE VIEW v_consumo AS 
 SELECT get_cod_grupo(v_movimentacao.pro_codigo) AS gru_codigo, get_nome_grupo(v_movimentacao.pro_codigo) AS gru_nome, v_movimentacao.pro_codigo, v_movimentacao.pro_nome, v_movimentacao.codsetor, v_movimentacao.setor, sum(COALESCE(v_movimentacao.ite_quantidade, 0::numeric)) AS consumo, verifica_preco(v_movimentacao.pro_codigo, v_movimentacao.codsetor, v_movimentacao.mov_data) AS preco, v_movimentacao.mov_data
   FROM v_movimentacao, v_produto_centroestoc
  WHERE v_movimentacao.pro_codigo = v_produto_centroestoc.pro_codigo AND v_movimentacao.codsetor = v_produto_centroestoc.codsetor AND v_movimentacao.sinal = '-'::text
  GROUP BY get_cod_grupo(v_movimentacao.pro_codigo), get_nome_grupo(v_movimentacao.pro_codigo), v_movimentacao.pro_codigo, v_movimentacao.pro_nome, v_movimentacao.codsetor, v_movimentacao.setor, v_movimentacao.mov_data;

ALTER TABLE v_consumo
  OWNER TO postgres;
GRANT ALL ON TABLE v_consumo TO postgres;
GRANT ALL ON TABLE v_consumo TO public;

-- View: v_movimentacao

-- DROP VIEW v_movimentacao;

CREATE OR REPLACE VIEW v_movimentacao AS 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_saida) AS setor, 
            mov.mov_saida AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_saida AS codsetor, mov.mov_tipo, 
            mov.mov_saida AS operacao, '-'::text AS sinal, 
            mov.set_entrada AS codsetorsolicit, 
            get_setor(mov.set_entrada) AS nomesetorsolicit, 
                CASE
                    WHEN mov.mov_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(mov.set_saida)::text
                    WHEN mov.mov_saida = 'D'::bpchar THEN ('DISPENSACAO PARA PACIENTE '::text || ' - '::text) || (( SELECT substr(usuario.usu_nome::text, 1, 20) AS substr
                       FROM usuario
                      WHERE usuario.usu_codigo = mov.usu_codigo))
                    WHEN mov.mov_saida = 'P'::bpchar THEN 'SAIDA DE PERMUTA'::text
                    WHEN mov.mov_saida = 'I'::bpchar THEN 'SAIDA POR INVENTARIO'::text
                    WHEN mov.mov_saida = 'A'::bpchar THEN 'SAIDA POR AJUSTE'::text
                    WHEN mov.mov_saida = 'R'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-PE'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-VV'::bpchar THEN 'SAIDA POR VALIDADE VENCIDA'::text
					WHEN mov.mov_saida = 'S-AEA'::bpchar THEN 'SAIDA POR AMOSTRA, EXPOSIÇÃO E ANÁLISE'::text
					WHEN mov.mov_saida = 'S-DEP'::bpchar THEN 'DEVOLUÇÃO DE ENTRADA DE PRODUTO'::text
					WHEN mov.mov_saida = 'S-TR'::bpchar THEN 'SAÍDA POR TRANSFERÊNCIA E REMANEJAMENTO'::text
					WHEN mov.mov_saida = 'S-D'::bpchar THEN 'SAÍDA POR DOAÇÃO'::text
					WHEN mov.mov_saida = 'S-AS'::bpchar THEN 'SAÍDA POR APREENSÃO SANITÁRIA'::text
					WHEN mov.mov_saida = 'S-E'::bpchar THEN 'SAÍDA PARA EMPRÉSTIMO'::text
					WHEN mov.mov_saida = 'S-P'::bpchar THEN 'SAÍDA PARA PACIENTE NÃO IDENTIFICADO'::text
					WHEN mov.mov_saida = 'S-AE'::bpchar THEN 'SAÍDA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_saida = 'O'::bpchar THEN 'OUTRAS SAIDAS'::text
                    WHEN mov.mov_saida = 'M'::bpchar THEN 'SAIDAS DE EMPRESTIMOS'::text
                    WHEN mov.mov_saida = 'T'::bpchar THEN 'SAIDA POR TRANSFERENCIA PARA '::text || get_setor(mov.set_saida)::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_vlrunit, mov.age_codigo, mov.usu_codigo
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'S'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
UNION ALL 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_entrada) AS setor, 
            mov.mov_entrada AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_entrada AS codsetor, mov.mov_tipo, 
            mov.mov_entrada AS operacao, '+'::text AS sinal, 
            mov.set_saida AS codsetorsolicit, 
            get_setor(mov.set_saida) AS nomesetorsolicit, 
                CASE
                    WHEN mov.mov_entrada = 'E-SI'::bpchar THEN 'ENTRADA POR SALDO DE IMPLANTAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-C'::bpchar THEN 'ENTRADA POR CONCORRÊNCIA'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-CONV'::bpchar THEN 'ENTRADA POR CONVITE'::text
                    WHEN mov.mov_entrada = 'D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-P'::bpchar THEN 'ENTRADA POR PREGÃO'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'A'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-AE'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-EVENTUAL'::bpchar THEN 'ENTRADA POR ENTRADA EVENTUAL'::text
                    WHEN mov.mov_entrada = 'E-O'::bpchar THEN 'ENTRADA POR ENTRADA ORDINÁRIA'::text
                    WHEN mov.mov_entrada = 'E-TP'::bpchar THEN 'ENTRADA POR TOMADA DE PREÇOS'::text
                    WHEN mov.mov_entrada = 'E-INEX'::bpchar THEN 'ENTRADA POR INEXIGIBILIDADE'::text
                    WHEN mov.mov_entrada = 'P'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E-PER'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E'::bpchar THEN 'ENTRADA DE NOTA FISCAL'::text
                    WHEN mov.mov_entrada = 'M'::bpchar THEN 'ENTRADA DE EMPRESTIMO'::text
                    WHEN mov.mov_entrada = 'I'::bpchar THEN 'ENTRADA DE INVENTARIO'::text
                    WHEN mov.mov_entrada = 'O'::bpchar THEN 'OUTRAS ENTRADAS'::text
                    WHEN mov.mov_entrada = 'T'::bpchar THEN 'ENTRADA POR TRANSFERENCIA DE'::text || get_setor(mov.set_entrada)::text
                    WHEN mov.mov_entrada = 'v'::bpchar THEN 'DEVOLUCAO DE SETORES'::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_vlrunit, mov.age_codigo, mov.usu_codigo
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'E'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
  ORDER BY 2, 10;

ALTER TABLE v_movimentacao
  OWNER TO postgres;
GRANT ALL ON TABLE v_movimentacao TO postgres;

-- View: v_consumo_tp_mov

-- DROP VIEW v_consumo_tp_mov;

CREATE OR REPLACE VIEW v_consumo_tp_mov AS 
 SELECT get_cod_grupo(v_movimentacao.pro_codigo) AS gru_codigo, 
    get_nome_grupo(v_movimentacao.pro_codigo) AS gru_nome, 
    v_movimentacao.pro_codigo, v_movimentacao.pro_nome, v_movimentacao.codsetor, 
    v_movimentacao.setor, 
    sum(COALESCE(v_movimentacao.ite_quantidade, 0::numeric)) AS consumo, 
    verifica_preco(v_movimentacao.pro_codigo, v_movimentacao.codsetor, v_movimentacao.mov_data) AS preco, 
    v_movimentacao.mov_data, v_movimentacao.tipomovim, v_movimentacao.sinal
   FROM v_movimentacao, v_produto_centroestoc
  WHERE v_movimentacao.pro_codigo = v_produto_centroestoc.pro_codigo AND v_movimentacao.codsetor = v_produto_centroestoc.codsetor AND v_movimentacao.sinal = '-'::text
  GROUP BY get_cod_grupo(v_movimentacao.pro_codigo), get_nome_grupo(v_movimentacao.pro_codigo), v_movimentacao.pro_codigo, v_movimentacao.pro_nome, v_movimentacao.codsetor, v_movimentacao.setor, v_movimentacao.mov_data, v_movimentacao.tipomovim, v_movimentacao.sinal;

ALTER TABLE v_consumo_tp_mov
  OWNER TO postgres;
GRANT ALL ON TABLE v_consumo_tp_mov TO postgres;
GRANT ALL ON TABLE v_consumo_tp_mov TO public;

-- View: v_inventario

-- DROP VIEW v_inventario;

CREATE OR REPLACE VIEW v_inventario AS 
 SELECT inventario.inv_codigo, inventario.inv_data, inventario.set_codigo, 
    inventario.gru_codigo, inventario.inv_responsavel, inventario.inv_equipe, 
    inventario_produto.pro_codigo, inventario_produto.invp_quantidade, 
    setor.set_nome, produto.pro_nome, grupo.gru_nome, 
    calcula_estoque(inventario_produto.pro_codigo, inventario.set_codigo, inventario.inv_data) AS estoqueatual, 
    inventario_produto.invp_status
   FROM inventario, inventario_produto, setor, grupo, produto
  WHERE inventario.inv_codigo = inventario_produto.inv_codigo AND inventario.set_codigo = setor.set_codigo AND inventario.gru_codigo = grupo.gru_codigo AND inventario_produto.pro_codigo = produto.pro_codigo AND inventario_produto.invp_status = 'A'::bpchar;

ALTER TABLE v_inventario
  OWNER TO postgres;

-- View: v_movimentacao_all

-- DROP VIEW v_movimentacao_all;

CREATE OR REPLACE VIEW v_movimentacao_all AS 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_saida) AS setor, 
            mov.mov_saida AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_saida AS codsetor, mov.mov_tipo, 
            mov.mov_saida AS operacao, '-'::text AS sinal, 
            mov.set_entrada AS codsetorsolicit, 
            get_setor(mov.set_entrada) AS nomesetorsolicit, 
                CASE
                    WHEN mov.mov_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(mov.set_saida)::text
                    WHEN mov.mov_saida = 'D'::bpchar THEN ('DISPENSACAO PARA PACIENTE '::text || ' - '::text) || (( SELECT substr(usuario.usu_nome::text, 1, 20) AS substr
                       FROM usuario usuario
                      WHERE usuario.usu_codigo = mov.usu_codigo))
                    WHEN mov.mov_saida = 'P'::bpchar THEN 'SAIDA DE PERMUTA'::text
                    WHEN mov.mov_saida = 'I'::bpchar THEN 'SAIDA POR INVENTARIO'::text
                    WHEN mov.mov_saida = 'A'::bpchar THEN 'SAIDA POR AJUSTE'::text
                    WHEN mov.mov_saida = 'R'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-PE'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-VV'::bpchar THEN 'SAIDA POR VALIDADE VENCIDA'::text
					WHEN mov.mov_saida = 'S-AEA'::bpchar THEN 'SAIDA POR AMOSTRA, EXPOSIÇÃO E ANÁLISE'::text
					WHEN mov.mov_saida = 'S-DEP'::bpchar THEN 'DEVOLUÇÃO DE ENTRADA DE PRODUTO'::text
					WHEN mov.mov_saida = 'S-TR'::bpchar THEN 'SAÍDA POR TRANSFERÊNCIA E REMANEJAMENTO'::text
					WHEN mov.mov_saida = 'S-D'::bpchar THEN 'SAÍDA POR DOAÇÃO'::text
					WHEN mov.mov_saida = 'S-AS'::bpchar THEN 'SAÍDA POR APREENSÃO SANITÁRIA'::text
					WHEN mov.mov_saida = 'S-E'::bpchar THEN 'SAÍDA PARA EMPRÉSTIMO'::text
					WHEN mov.mov_saida = 'S-P'::bpchar THEN 'SAÍDA PARA PACIENTE NÃO IDENTIFICADO'::text
					WHEN mov.mov_saida = 'S-AE'::bpchar THEN 'SAÍDA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_saida = 'O'::bpchar THEN 'OUTRAS SAIDAS'::text
                    WHEN mov.mov_saida = 'M'::bpchar THEN 'SAIDAS DE EMPRESTIMOS'::text
                    WHEN mov.mov_saida = 'T'::bpchar THEN 'SAIDA POR TRANSFERENCIA PARA '::text || get_setor(mov.set_saida)::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_vlrunit, mov.age_codigo, mov.usu_codigo
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'S'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
UNION ALL 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data, 
            mov.mov_data, mov.mov_nr_nota, get_setor(mov.set_entrada) AS setor, 
            mov.mov_entrada AS tipomovim, it.pro_codigo, produto.pro_nome, 
            mov.mov_codigo, mov.set_entrada AS codsetor, mov.mov_tipo, 
            mov.mov_entrada AS operacao, '+'::text AS sinal, 
            mov.set_saida AS codsetorsolicit, 
            get_setor(mov.set_saida) AS nomesetorsolicit, 
                CASE
                    WHEN mov.mov_entrada = 'E-SI'::bpchar THEN 'ENTRADA POR SALDO DE IMPLANTAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-C'::bpchar THEN 'ENTRADA POR CONCORRÊNCIA'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-CONV'::bpchar THEN 'ENTRADA POR CONVITE'::text
                    WHEN mov.mov_entrada = 'D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-D'::bpchar THEN 'ENTRADA POR DOAÇÃO'::text
                    WHEN mov.mov_entrada = 'E-P'::bpchar THEN 'ENTRADA POR PREGÃO'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAÇÃO'::text
                    WHEN mov.mov_entrada = 'A'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-AE'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-EVENTUAL'::bpchar THEN 'ENTRADA POR ENTRADA EVENTUAL'::text
                    WHEN mov.mov_entrada = 'E-O'::bpchar THEN 'ENTRADA POR ENTRADA ORDINÁRIA'::text
                    WHEN mov.mov_entrada = 'E-TP'::bpchar THEN 'ENTRADA POR TOMADA DE PREÇOS'::text
                    WHEN mov.mov_entrada = 'E-INEX'::bpchar THEN 'ENTRADA POR INEXIGIBILIDADE'::text
                    WHEN mov.mov_entrada = 'P'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E-PER'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E'::bpchar THEN 'ENTRADA DE NOTA FISCAL'::text
                    WHEN mov.mov_entrada = 'M'::bpchar THEN 'ENTRADA DE EMPRESTIMO'::text
                    WHEN mov.mov_entrada = 'I'::bpchar THEN 'ENTRADA DE INVENTARIO'::text
                    WHEN mov.mov_entrada = 'O'::bpchar THEN 'OUTRAS ENTRADAS'::text
                    WHEN mov.mov_entrada = 'T'::bpchar THEN 'ENTRADA POR TRANSFERENCIA DE'::text || get_setor(mov.set_entrada)::text
                    WHEN mov.mov_entrada = 'v'::bpchar THEN 'DEVOLUCAO DE SETORES'::text
                    ELSE NULL::text
                END AS desc_movimentacao, 
            it.ite_quantidade, it.ite_vlrunit, mov.age_codigo, mov.usu_codigo
           FROM movimento mov, itens_movimento it, produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'E'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
  ORDER BY 2, 10;

ALTER TABLE v_movimentacao_all
  OWNER TO postgres;
