UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.68.67' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.48.36' WHERE conf_chave='VERSAO_COMUM';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.27.25' WHERE conf_chave='VERSAO_SOCIAL';

CREATE TABLE social.requisicao_materiais
(
   rem_codigo bigserial, 
   set_codigo_req bigint, 
   set_codigo_sol bigint, 
   rem_status character, 
   rem_data timestamp without time zone, 
   usr_codigo bigint, 
   CONSTRAINT rem_codigo PRIMARY KEY (rem_codigo), 
   CONSTRAINT set_requisitante FOREIGN KEY (set_codigo_req) REFERENCES setor (set_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT set_solicitado FOREIGN KEY (set_codigo_sol) REFERENCES setor (set_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT usr_codigo FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;

CREATE TABLE social.requisicao_materiais_itens
(
   remi_codigo bigserial, 
   rem_codigo bigint, 
   pro_codigo bigint, 
   remi_status character(1), 
   PRIMARY KEY (remi_codigo), 
   FOREIGN KEY (rem_codigo) REFERENCES requisicao_materiais (rem_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   FOREIGN KEY (pro_codigo) REFERENCES produto (pro_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;

CREATE TABLE social.requisicao_materiais_itens_lote
(
   remil_codigo bigserial, 
   remi_codigo bigint, 
   remil_lote character varying, 
   remil_quantidade integer, 
   PRIMARY KEY (remil_codigo), 
   FOREIGN KEY (remi_codigo) REFERENCES requisicao_materiais_itens (remi_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;
insert into permissoes (perm_descricao,perm_programa,perm_objeto) values ('Materiais - Requisiao/requisicao-materiais','zf/materiais/requisicao-materiais','zf/materiais/requisicao-materiais');

ALTER TABLE requisicao_materiais
  ADD COLUMN rem_observacao text;

ALTER TABLE pre_consulta
   ALTER COLUMN pc_peso TYPE numeric(9,3);
   
INSERT INTO config 
  (conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool)
VALUES
  ('IMPRIMIR_PACIENTES_TELEFONE','Imprimir telefone dos pacientes na recepo, sem o diagnstico?','f','2','f');

ALTER TABLE requisicao_materiais_itens
ADD COLUMN remi_quantidade integer;

insert into permissoes (perm_descricao,perm_programa,perm_objeto) values ('Materiais - Requisiao/envio-de-materiais','zf/materiais/envio-de-materiais','zf/materiais/envio-de-materiais');