ALTER TABLE quarto ADD PRIMARY KEY (qua_codigo);


CREATE TABLE sinais_vitais
(
  si_codigo bigserial NOT NULL,
  ate_codigo bigint,
  si_temperatura double precision,
  si_peso double precision,
  si_altura double precision,
  si_freq_cardiaca smallint,
  si_freq_respiratoria smallint,
  si_perimetro_cefalico double precision,
  si_dados text,
  usr_codigo bigint,
  si_pressao_sistolica smallint,
  si_pressao_diastolica smallint,
  si_data timestamp without time zone,
  esp_codigo bigint, -- Um enfermeiro pode ter mais de uma especialidade, ou a especialidade pode ser alterada. O histrico deve exibir a especialidade que o usr estava logado no momento do atendimento.
  si_clas_risco integer, -- 0 = Imediato(vermelho)...
  si_glicose double precision,
  CONSTRAINT sinais_vitais_pkey PRIMARY KEY (si_codigo ),
  CONSTRAINT sinais_vitais_ate_codigo_fkey FOREIGN KEY (ate_codigo)
      REFERENCES atendimento (ate_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT saude_ate_codigo_altura CHECK (si_altura >= 0::double precision),
  CONSTRAINT saude_ate_codigo_peso CHECK (si_peso >= 0::double precision)
)
WITH (
  OIDS=FALSE
);
COMMENT ON COLUMN sinais_vitais.esp_codigo IS 'Um enfermeiro pode ter mais de uma especialidade, ou a especialidade pode ser alterada. O histrico deve exibir a especialidade que o usr estava logado no momento do atendimento.';
COMMENT ON COLUMN sinais_vitais.si_clas_risco IS '0 = Imediato(vermelho)
1 = 20 min (amarelo)
2 = 60 min(verde)
3 = 4 horas(azul)';

ALTER TABLE atendimento ADD COLUMN ate_atendido character(1) DEFAULT 'N';
COMMENT ON COLUMN atendimento.ate_atendido IS 'N - No atendido
S - paciente Atendido';

ALTER TABLE paciente_leito ADD COLUMN io_codigo bigint;
ALTER TABLE leito_grade ADD COLUMN io_codigo bigint;
ALTER TABLE leito_grade ADD FOREIGN KEY (io_codigo) REFERENCES internacao_observacao (io_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


INSERT INTO config (conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool) VALUES
		    ('AGENDA_EXAME_DT_RETROATIVA','Permitir Agendar Exame com Data Retroativa','f','2','t');

ALTER TABLE leito_grade DROP COLUMN usu_codigo;
ALTER TABLE leito_grade DROP COLUMN lei_codigo;

CREATE TRIGGER bpa
  AFTER UPDATE OR INSERT
  ON coleta
  FOR EACH ROW
  EXECUTE PROCEDURE public.itxtobap();

-- Trigger: bpadel on itensdoexame

-- DROP TRIGGER bpadel ON itensdoexame;
ALTER TABLE bpa
	ALTER COLUMN uni_codigo DROP NOT NULL;
ALTER TABLE public.bpa ADD COLUMN med_codigo bigint;
ALTER TABLE public.bpa ADD FOREIGN KEY (med_codigo) REFERENCES medico (med_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

CREATE TRIGGER bpadel
  AFTER DELETE
  ON coleta
  FOR EACH ROW
  EXECUTE PROCEDURE public.itxtobpadel();
  
CREATE OR REPLACE FUNCTION public.itxtobpadel() RETURNS trigger AS
	$BODY$
		
	BEGIN

		DELETE FROM bpa WHERE bpa_origem='coleta' AND bpa_origem_codigo=OLD.col_codigo;
		RAISE NOTICE 'Um registro na tabela ''bpa'' foi deletado devido uma excluso na tabela ''coleta''.';
		RETURN OLD;
		
	END
	$BODY$
	LANGUAGE plpgsql VOLATILE
COST 100;

CREATE OR REPLACE FUNCTION itxtobap() RETURNS trigger AS
$BODY$DECLARE
  linha RECORD;
  bpaCodigo bigint;
  ciCodigo bigint;  
BEGIN

	FOR linha IN SELECT a.usu_codigo,
			       ai.med_codigo_coleta,
			       ci.proc_codigo,
			       p.proc_bpa_tipo,
			       p.proc_nome,
			       'P' as itx_urgente,
			       c.col_data_coleta,
			       ai.usr_codigo
			  FROM coleta c
			  join agenda_itens ai
			    on ai.agei_codigo = c.agei_codigo
			  join agenda a 
			    on a.age_codigo = ai.age_codigo
			  join convenio_itens ci
			    on ci.coni_codigo = ai.coni_codigo
			  join procedimento p
			    on p.proc_codigo = ci.proc_codigo
			 WHERE c.col_codigo=NEW.col_codigo LOOP	
		 SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
				
						-- Buscar se j foi feito um BPA
									
					SELECT bpa_codigo 
					  FROM bpa
					 WHERE bpa_origem = 'coleta'
					   AND bpa_origem_codigo = NEW.col_codigo
					  INTO bpaCodigo;
					  
						IF FOUND THEN					
							-- Atualiza BPA
							UPDATE bpa
							   SET med_codigo  = linha.med_codigo_coleta,
							       usr_codigo  = linha.usr_codigo,
								   usu_codigo  = linha.usu_codigo,
								   bpa_data    = linha.col_data_coleta,
								   proc_codigo = linha.proc_codigo,
								   ci_codigo = ciCodigo,
								   bpa_tipo = linha.proc_bpa_tipo
							 WHERE bpa_codigo = bpaCodigo;
							 RAISE NOTICE 'Um registro na tabela ''bpa'' foi atualizado devido uma alterao na tabela ''coleta''.';
						ELSE						
							-- Se no houver,  cria	   
							INSERT INTO BPA (med_codigo,
								 usr_codigo,
								 usu_codigo,
								 bpa_data,
								 proc_codigo,
								 ci_codigo,
								 bpa_tipo,
							  -- bpa_cd10_codigo, -- NULL
								 bpa_origem,
								 bpa_origem_codigo)
							VALUES (linha.med_codigo_coleta,
								 linha.usr_codigo,
								 linha.usu_codigo,
								 linha.col_data_coleta,
								 linha.proc_codigo,
								 ciCodigo,
								 linha.proc_bpa_tipo,
							  -- NEW.cd10_codigo,
								 'coleta',
								 NEW.col_codigo);
							RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma alterao na tabela ''coleta''.';				 
					END IF; -- status
				END LOOP;
	RETURN NEW;

END
$BODY$
LANGUAGE plpgsql VOLATILE
COST 100;

CREATE TABLE tb_registro
(
   co_registro character varying(2), 
   no_registro character varying(50), 
   dt_competencia character(6)
) 
WITH (
  OIDS = FALSE
)
;

CREATE TABLE rl_procedimento_registro
(
   co_procedimento character varying(10), 
   co_registro character varying(2), 
   dt_competencia character(6)
) 
WITH (
  OIDS = FALSE
)
;



