UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.72.71' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.52.40' WHERE conf_chave='VERSAO_COMUM';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.28.26' WHERE conf_chave='VERSAO_SOCIAL';

  ALTER TABLE tipodeexame
  ADD UNIQUE (proc_codigo, cte_codigo);
  

  insert into permissoes (perm_descricao,perm_programa,perm_objeto) values ('ZF - Print Laudos','zf/laboratorio/laudos','zf/laboratorio/laudos');

  INSERT INTO config 
  (conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool)
VALUES
  ('VALOR_VIA_MEDICAMENTOS','Valor na via de medicamentos','f','2','t');
  
ALTER TABLE tipoexame_grupo ADD CONSTRAINT tipodeexame_grupo_proc_codigo_txg_codigo_key UNIQUE (proc_codigo, gruex_codigo);

ALTER TABLE agenda_itens ADD COLUMN usr_codigo_bioquimico bigint;
ALTER TABLE agenda_itens ADD CONSTRAINT agenda_itens_usr_codigo_bioquimico_fk FOREIGN KEY (usr_codigo_bioquimico)
REFERENCES usuarios (usr_codigo) MATCH SIMPLE 
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE itensanalise ADD COLUMN historico boolean;


INSERT INTO usuarios (usr_login,usr_senha,usr_nome,usr_requisicao,usr_consolidacao_automatica,usr_ativo,usr_mestre,usr_transferencia,usr_tipo,usr_tipo_medico) 
VALUES
 ('bioquimico_geral','202cb962ac59075b964b07152d234b70','BIOQUIMICO GERAL','S','S','N','N','N','U','B');

UPDATE agenda_itens SET usr_codigo_bioquimico = (SELECT usr_codigo FROM usuarios WHERE usr_login = 'bioquimico_geral');

-- Function: operacoesiitensmovimentohorus()

-- DROP FUNCTION operacoesiitensmovimentohorus();

CREATE OR REPLACE FUNCTION operacoesiitensmovimentohorus()
  RETURNS trigger AS
$BODY$
DECLARE 
linha RECORD;
tpxml character(1);
ite_validade date;
ite_vlrunit character varying(20);
ite_lote character varying(20);
tpmov character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM horus_dados WHERE hor_dad_origem = 'itensmovimento' AND hor_dad_origem_codigo = OLD.ite_codigo;
		RETURN OLD;	
	ELSE
		FOR linha IN
			SELECT 
				mov.mov_data,
				mov.mov_tipo, 
				mov.mov_saida,
				mov.mov_entrada,
				pro.pro_codigo,
				pro.pro_horus,
				ite.ite_vlrunit,
				ite.ite_validade,
				ite.ite_lote,
				ite.ite_quantidade,
				ite.ite_codigo,
				count(ite.ite_codigo) AS num_registros,
				uni.uni_cnes
			FROM 
				itens_movimento AS ite
			INNER JOIN
				movimento AS mov ON ite.mov_codigo=mov.mov_codigo 
			INNER JOIN 
				produto AS pro ON ite.pro_codigo=pro.pro_codigo
			INNER JOIN 
				setor AS set ON mov.set_entrada=set.set_codigo OR mov.set_saida=set.set_codigo
			INNER JOIN 
				unidade AS uni ON set.uni_codigo=uni.uni_codigo
			WHERE 
				pro.pro_horus IS NOT NULL AND
				(mov.mov_entrada IN ('E-SI','E-C','E-DL','E-CONV','E-D','E-P','E-AE','E-EVENTUAL','E-O','E-TP','E-INEX','E-PER') OR 
				mov.mov_saida IN ('S-VV','S-PE','S-AEA','S-DEP','S-D','S-TR','S-AS','S-E','S-P','S-AE','D')) AND
				mov.mov_tipo IS NOT NULL AND
				pro.pro_codigo IS NOT NULL AND
				ite.ite_quantidade IS NOT NULL AND
				uni.uni_cnes IS NOT NULL AND
				ite.ite_codigo = NEW.ite_codigo 
			GROUP BY 
				mov.mov_data,
				mov.mov_tipo, 
				mov.mov_saida,
				mov.mov_entrada,
				pro.pro_codigo,
				pro.pro_horus,
				ite.ite_vlrunit,
				ite.ite_validade,
				ite.ite_lote,
				ite.ite_quantidade,
				ite.ite_codigo,
				uni.uni_cnes LOOP

				RAISE NOTICE 'ite_vlrunit: %.', NEW.ite_vlrunit;
					
				IF (linha.num_registros > 0) THEN
					-- Validando Campo Lote
					IF (linha.ite_lote IS NULL) THEN
						ite_lote = '0';
					ELSE
						ite_lote = linha.ite_lote;
					END IF;
					-- Validando Valor do Item
					IF (linha.ite_vlrunit IS NULL) THEN
						ite_vlrunit = '0.0000';
					ELSE
						ite_vlrunit = linha.ite_vlrunit;
					END IF;
					-- Validando item da validade
					IF (linha.ite_validade IS NULL) THEN 
						ite_validade = (SELECT((DATE_PART('DAY', CURRENT_DATE)||'/'||DATE_PART('MONTH', CURRENT_DATE)||'/'||DATE_PART('YEAR', CURRENT_DATE))::DATE + interval '3 year')::DATE);
					ELSE
						ite_validade = linha.ite_validade;
					END IF;
					-- Valida tipo de XML(tpxml)
					IF (linha.mov_tipo = 'S' AND linha.mov_saida = 'D') THEN 
						tpxml = 'D';
						tpmov = 'D'; 
					END IF;
					IF (linha.mov_tipo = 'S' AND linha.mov_saida <> 'D') THEN 
						tpxml = linha.mov_tipo;
						tpmov = linha.mov_saida; 
					END IF;
					IF (linha.mov_tipo = 'E') THEN 
						tpxml = linha.mov_tipo;
						tpmov = linha.mov_entrada; 
					END IF;
					-- Insert 
					IF (TG_OP = 'INSERT') THEN
						INSERT 	INTO horus_dados 
									(hor_dad_tpxml, hor_dad_status_envio, hor_dad_counidadecnes, hor_dad_nuproduto, hor_dad_tpproduto, hor_dad_vlitem, hor_dad_dtvalidade, hor_dad_nulote, hor_dad_qtd, hor_dad_nucnspaciente, hor_dad_tpmovimentacao, hor_dad_dtcadastro, hor_dad_origem, hor_dad_origem_codigo,hor_dad_dtrecebimentoprod)
								VALUES
									(tpxml,'F',linha.uni_cnes,linha.pro_horus,'B',ite_vlrunit,ite_validade,ite_lote,linha.ite_quantidade,'0',tpmov,NOW(),'itensmovimento',linha.ite_codigo,linha.mov_data);
						RETURN NEW;
					END IF;
					-- Update
					IF (TG_OP = 'UPDATE') THEN
						UPDATE horus_dados 
						   SET hor_dad_tpxml = tpxml, 
							   hor_dad_counidadecnes = linha.uni_cnes, 
							   hor_dad_nuproduto = linha.pro_horus, 
							   hor_dad_tpproduto = 'B', 
							   hor_dad_vlitem = linha.ite_vlrunit, 
							   hor_dad_dtvalidade = ite_validade, 
							   hor_dad_nulote = ite_lote, 
							   hor_dad_qtd = linha.ite_quantidade, 
							   hor_dad_nucnspaciente = '0', 
							   hor_dad_tpmovimentacao = tpmov, 
							   hor_dad_dtcadastro = NOW(), 
							   hor_dad_origem = 'itensmovimento', 
							   hor_dad_origem_codigo = linha.ite_codigo
						WHERE
							   hor_dad_origem = 'itensmovimento' AND 
							   hor_dad_origem_codigo = NEW.ite_codigo;
						RETURN NEW;	
					END IF;
				END IF;
		END LOOP;
	END IF;
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION operacoesiitensmovimentohorus()
  OWNER TO postgres;

ALTER TABLE itens_movimento 
DISABLE TRIGGER atualizahorus;   

ALTER TABLE itensanalise
   ALTER COLUMN ite_itemdoexame TYPE character varying;
   
   
alter table itensanalise add column ite_ordem integer;

CREATE OR REPLACE FUNCTION itxtobap()
  RETURNS trigger AS
$BODY$DECLARE
  linha RECORD;
  bpaCodigo bigint;
  ciCodigo bigint;  
BEGIN

	FOR linha IN SELECT DISTINCT
		       a.usu_codigo,
		       ai.med_codigo_coleta,
		       p.proc_codigo,
		       p.proc_bpa_tipo,
		       p.proc_nome,
		       'P' as itx_urgente,
		       c.col_data_coleta,
		       ai.usr_codigo
		  FROM coleta c
		  join agenda_itens ai
		    on ai.agei_codigo = c.agei_codigo
		  join agenda a 
		    on a.age_codigo = ai.age_codigo
		  join convenio_itens ci
		    on ci.coni_codigo = ai.coni_codigo
		  left join grupoexame gruex
		    on gruex.gruex_codigo = ci.gruex_codigo
		  left join tipoexame_grupo txg
		    on txg.gruex_codigo=gruex.gruex_codigo
		  join procedimento p
		    on p.proc_codigo = ci.proc_codigo or txg.proc_codigo=p.proc_codigo
		 WHERE c.col_codigo=NEW.col_codigo 
	 LOOP	
		SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
				
						-- Buscar se já foi feito um BPA
									
			SELECT bpa_codigo 
			  FROM bpa
			 WHERE bpa_origem = 'coleta'
			   AND bpa_origem_codigo = NEW.col_codigo
			   and proc_codigo = linha.proc_codigo
			  INTO bpaCodigo;
					  
			IF FOUND THEN					
				-- Atualiza BPA
				UPDATE bpa
				   SET med_codigo  = linha.med_codigo_coleta,
				       usr_codigo  = linha.usr_codigo,
					   usu_codigo  = linha.usu_codigo,
					   bpa_data    = linha.col_data_coleta,
					   proc_codigo = linha.proc_codigo,
					   ci_codigo = ciCodigo,
					   bpa_tipo = linha.proc_bpa_tipo
				 WHERE bpa_codigo = bpaCodigo;
				 RAISE NOTICE 'Um registro na tabela ''bpa'' foi atualizado devido uma alteração na tabela ''coleta''.';
			ELSE						
				-- Se não houver,  cria	   
				INSERT INTO BPA (med_codigo,
					 usr_codigo,
					 usu_codigo,
					 bpa_data,
					 proc_codigo,
					 ci_codigo,
					 bpa_tipo,
				  -- bpa_cd10_codigo, -- NULL
					 bpa_origem,
					 bpa_origem_codigo)
				VALUES (linha.med_codigo_coleta,
					 linha.usr_codigo,
					 linha.usu_codigo,
					 linha.col_data_coleta,
					 linha.proc_codigo,
					 ciCodigo,
					 linha.proc_bpa_tipo,
				  -- NEW.cd10_codigo,
					 'coleta',
					 NEW.col_codigo);
			RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma alteração na tabela ''coleta''.';				 
			END IF; -- status
	END LOOP;
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION itxtobap()
  OWNER TO postgres;
