UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.74.73.1' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.54.42' WHERE conf_chave='VERSAO_COMUM';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.28.26' WHERE conf_chave='VERSAO_SOCIAL';

UPDATE unidade SET uni_desc = retira_acentos(uni_desc); 
UPDATE usuarios SET usr_nome = retira_acentos(usr_nome);
UPDATE medico SET med_nome = retira_acentos(med_nome);

INSERT INTO config (conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool) VALUES ('MODULO_UNIDADES','Habilitar mdulo de unidades?','f','2','f');
INSERT INTO config (conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool) VALUES ('MODULO_PRESTADOR','Habilitar mdulo de prestador de servios?','f','2','f');
INSERT INTO config (conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool) VALUES ('MODULO_USUARIOS','Habilitar mdulo de usurios','f','2','f');

INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('CNES','zf/programasfederais/cnes','zf/programasfederais/cnes');
INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('Usurios: Cadastro de usurio','zf/usuarios/usuarios','zf/usuarios/usuarios');
INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('ZF:AGENDACATEGORIADECONVENIOS','zf/agenda/categoria-de-convenios','zf/agenda/categoria-de-convenios');


ALTER TABLE unidade ADD COLUMN cnes_ativo CHAR(1);
ALTER TABLE medico ADD COLUMN cnes_ativo CHAR(1);

INSERT INTO config (conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool) VALUES ('IMPORTACAO_CNES','Liberar Importao do CNES','t','2','f');

CREATE TABLE categoria_convenios
(
  catc_codigo bigserial NOT NULL,
  catc_nome character varying(255),
  PRIMARY KEY (catc_codigo)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE categoria_convenios
  OWNER TO postgres;

CREATE TABLE categoria_convenios_vinculos
(
   catcv_codigo bigserial, 
   catc_codigo bigint, 
   conv_codigo bigint,
   PRIMARY KEY (catcv_codigo), 
   FOREIGN KEY (catc_codigo) REFERENCES categoria_convenios (catc_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   FOREIGN KEY (conv_codigo) REFERENCES convenio (conv_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
);

CREATE TABLE categoria_convenios_procedimentos
(
   catcp_codigo bigserial, 
   catc_codigo bigint, 
   proc_codigo bigint,
   PRIMARY KEY (catcp_codigo), 
   FOREIGN KEY (catc_codigo) REFERENCES categoria_convenios (catc_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   FOREIGN KEY (proc_codigo) REFERENCES procedimento (proc_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
);

ALTER TABLE categoria_convenios_procedimentos ADD CONSTRAINT categoria_convenios_procedimentos_catc_codigo_proc_codigo_key UNIQUE (catc_codigo, proc_codigo);

INSERT INTO unidade_usuarios(uni_codigo, usr_codigo)
SELECT DISTINCT
log.uni_codigo, log.id_login
FROM
logon AS log
INNER JOIN
unidade AS uni ON log.uni_codigo=uni.uni_codigo
INNER JOIN
usuarios AS usr ON log.id_login=usr.usr_codigo;