UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.75.74' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.55.43' WHERE conf_chave='VERSAO_COMUM';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.28.26' WHERE conf_chave='VERSAO_SOCIAL';

CREATE TABLE agenda_bioquimicos_responsavel(
	agebr_codigo bigserial,
	age_codigo bigint,
	usr_codigo bigint,
	PRIMARY KEY(agebr_codigo),
	FOREIGN KEY(age_codigo) REFERENCES agenda(age_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION,
	FOREIGN KEY(usr_codigo) REFERENCES usuarios(usr_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS = FALSE
);


CREATE TABLE social.produto_subgrupo
(
   pros_codigo bigserial, 
   pros_descricao character varying, 
   PRIMARY KEY (pros_codigo)
) 
WITH (
  OIDS = FALSE
)
;

ALTER TABLE produto
  ADD COLUMN pros_codigo bigint;
ALTER TABLE produto
  ADD FOREIGN KEY (pros_codigo) REFERENCES produto_subgrupo (pros_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

  ALTER TABLE procedimento
  ADD COLUMN proc_apelido character varying;
  
INSERT INTO config 
  (conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool)
VALUES
  ('ENCAMINHAMENTO_SIMPLES','Encaminhamento Simples','f','2','t');

INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ADSTRINGENTE');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'AINES');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANALGESICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANESTÉSICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIALERGICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIANÊMICOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIANGINOSO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIARRÍTIMICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIASMÁTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIBACTERIANO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIBIÓTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTICOAGULANTE');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTICONVULSIONANTE');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIDEPRESSIVO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIDIABÉTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIEMÉTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIFÚNGICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIGOTOSO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIHELMINTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIHIPERTENSIVO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIHISTAMINICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTILIPIDEMICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIMALÁRICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIPARASITÁRIOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIPSICÓTICOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTISIOLÍTICOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIULCEROSOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIVIRAIS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'BENZODIAZEPÍNICOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'BETA BLOQUEADOR');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'BRONCODILATADOR');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'CORTICÓIDES');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'DIURÉTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ESCABICIDAS E PEDICULICIDAS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'EXPECTORANTE');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'HORMÔNIO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'HORMONIO TIREOIDEANO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'LAXANTES');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'METABOLISMO ÓSSEO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'REPOSITOR');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'SAIS DE REIDRATAÇÃO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'VASODILATADORES');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'VITAMINA DO COMPLEXO B');