UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.76.75' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.56.44' WHERE conf_chave='VERSAO_COMUM';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.28.26' WHERE conf_chave='VERSAO_SOCIAL';

CREATE TABLE categoria_configuracao (cac_codigo bigserial NOT NULL,
				     cac_descricao character varying NOT NULL);


ALTER table categoria_configuracao ADD CONSTRAINT cac_codigo_pkey PRIMARY KEY (cac_codigo);
ALTER TABLE config ADD COLUMN cac_codigo bigint;
ALTER TABLE config ADD CONSTRAINT cac_codigo_fkey FOREIGN KEY (cac_codigo) REFERENCES categoria_configuracao (cac_codigo);

INSERT INTO config 
	(conf_chave, conf_label, conf_readonly, conf_tipo, conf_valor_bool)
	VALUES
	('IMPRIMIR_COMPROVANTES_MOVIMENTACAO','Imprimir comprovantes de movimentação','f','2','t');


INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('ZF: APELIDO DE EXAMES','zf/default/procedimento','zf/default/procedimento');
	

insert into categoria_configuracao(cac_codigo,cac_descricao)values(1,'LABORATORIO');
insert into categoria_configuracao(cac_codigo,cac_descricao)values(3,'PRONTUÁRIO');
insert into categoria_configuracao(cac_codigo,cac_descricao)values(5,'FARMÁCIA');
insert into categoria_configuracao(cac_codigo,cac_descricao)values(6,'DEFAULT');
insert into categoria_configuracao(cac_codigo,cac_descricao)values(7,'AGENDAMENTO');
insert into categoria_configuracao(cac_codigo,cac_descricao)values(8,'LEITO');
insert into categoria_configuracao(cac_codigo,cac_descricao)values(9,'USUARIOS');
insert into categoria_configuracao(cac_codigo,cac_descricao)values(11,'MATERIAIS');



UPDATE config SET cac_codigo = 3 WHERE conf_chave = 'CID_OBRIGATORIO';
UPDATE config SET cac_codigo = 5 WHERE conf_chave = 'DIA_EXPORTACAO_HORUS';
UPDATE config SET cac_codigo = 4 WHERE conf_chave = 'USU_CODIGO_RESPONSAVEL';
UPDATE config SET cac_codigo = 1 WHERE conf_chave = 'ENCAMINHAMENTO_RAIOX';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'MODULO_PRESTADOR';
UPDATE config SET cac_codigo = 7 WHERE conf_chave = 'TIPO_ATENDIMENTO_AGENDAMENTO';
UPDATE config SET cac_codigo = 7 WHERE conf_chave = 'DADOS_PACIENTE_AGENDAMENTO';
UPDATE config SET cac_codigo = 9 WHERE conf_chave = 'MODULO_USUARIOS';
UPDATE config SET cac_codigo = 3 WHERE conf_chave = 'ENCAMINHAMENTO_SIMPLES';
UPDATE config SET cac_codigo = 8 WHERE conf_chave = 'LEITO_TEMPO_ALERTA';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'VERSAO_SAUDE';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'DATA_INSTALACAO_COMUM';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'VERSAO_COMUM';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'NOME_CIDADE';
UPDATE config SET cac_codigo = 3 WHERE conf_chave = 'PRONTUARIO_ATENDIMENTO_TEXTAREAUNICO';
UPDATE config SET cac_codigo = 3 WHERE conf_chave = 'PRONTUARIO_ATENDIMENTO_TEMPOPARAREABRIR';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'CID_CODIGO_IBGE';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'SIGLA_MUNICIPIO';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'GOOGLEANALYTICS';
UPDATE config SET cac_codigo = 7 WHERE conf_chave = 'AGENDA_MOSTRAR_N_OPCOES';
UPDATE config SET cac_codigo = 8 WHERE conf_chave = 'LEITO_TEMPO_FILA';
UPDATE config SET cac_codigo = 7 WHERE conf_chave = 'AGENDA_MOSTRAR_N_OPCOES';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'BUSCA_CARTAO_FAMILIA';
UPDATE config SET cac_codigo = 5 WHERE conf_chave = 'VALOR_VIA_MEDICAMENTOS';
UPDATE config SET cac_codigo = 5 WHERE conf_chave = 'VALIDADE_DOS_MEDICAMENTOS';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'DATA_INSTALACAO_SAUDE';
UPDATE config SET cac_codigo = 3 WHERE conf_chave = 'CID_OBRIGATORIO';
UPDATE config SET cac_codigo = 5 WHERE conf_chave = 'DIA_EXPORTACAO_HORUS';
UPDATE config SET cac_codigo = 1 WHERE conf_chave = 'AGENDA_EXAME_DT_RETROATIVA';
UPDATE config SET cac_codigo = 3 WHERE conf_chave = 'PRONTUARIO_FINALIZAR_E_IMPRIMIR';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'MODULO_UNIDADES';
UPDATE config SET cac_codigo = 5 WHERE conf_chave = 'LOTE_AUTOMATICO';
UPDATE config SET cac_codigo = 1 WHERE conf_chave = 'VALOR_GUIA_EXAME';
UPDATE config SET cac_codigo = 3 WHERE conf_chave = 'TEMPO_ESPERA';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'DATA_INSTALACAO_SOCIAL';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'VERSAO_SOCIAL';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'PROXY_ENDERECO';
UPDATE config SET cac_codigo = 5 WHERE conf_chave = 'MODO_PRODUCAO_HORUS';
UPDATE config SET cac_codigo = 3 WHERE conf_chave = 'LIMIT_GUIA_DIAGNOSTICO';
UPDATE config SET cac_codigo = 4 WHERE conf_chave = 'CADASTRO_AISE';
UPDATE config SET cac_codigo = 7 WHERE conf_chave = 'IMPRIMIR_PACIENTES_TELEFONE';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'PROXY_PORTA';
UPDATE config SET cac_codigo = 5 WHERE conf_chave = 'RECEITA_MODELO_ANVISA';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'PROXY_USUARIO';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'NOME_DEPARTAMENTO_SOCIAL';
UPDATE config SET cac_codigo = 5 WHERE conf_chave = 'FARMACIA_TEMPO_HISTORICO';
UPDATE config SET cac_codigo = 5 WHERE conf_chave = 'VIA_FARMACIA';
UPDATE config SET cac_codigo = 7 WHERE conf_chave = 'GUIA_DIAGNOSTICO';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'GRUPO_DOENCAS';
UPDATE config SET cac_codigo = 7 WHERE conf_chave = 'IMPRIMIR_PRIMEIRO_HORARIO';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'UTF8';
UPDATE config SET cac_codigo = 5 WHERE conf_chave = 'VALIDADE_RECEITA';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'ATUALIZACAO';
UPDATE config SET cac_codigo = 6 WHERE conf_chave = 'PROXY_SENHA';
UPDATE config SET cac_codigo = 5 WHERE conf_chave = 'FARMACIA_DISPENSACAO_LISTARSOMENTECOMSALDO';
UPDATE config SET cac_codigo = 11 WHERE conf_chave = 'IMPRIMIR_COMPROVANTES_MOVIMENTACAO';


ALTER TABLE usuarios_permissoes
   ALTER COLUMN nivel_i DROP NOT NULL;
ALTER TABLE usuarios_permissoes
   ALTER COLUMN nivel_a DROP NOT NULL;
ALTER TABLE usuarios_permissoes
   ALTER COLUMN nivel_d DROP NOT NULL;
ALTER TABLE usuarios_permissoes
   ALTER COLUMN nivel_l DROP NOT NULL;
ALTER TABLE usuarios_permissoes
   ALTER COLUMN nivel_b DROP NOT NULL;
   
-- Function: operacoesiitensmovimentohorus()

-- DROP FUNCTION operacoesiitensmovimentohorus();

CREATE OR REPLACE FUNCTION operacoesiitensmovimentohorus()
  RETURNS trigger AS
$BODY$
DECLARE 
linha RECORD;
tpxml character(1);
ite_validade date;
ite_vlrunit character varying(20);
ite_lote character varying(20);
tpmov character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM horus_dados WHERE hor_dad_origem = 'itensmovimento' AND hor_dad_origem_codigo = OLD.ite_codigo;
		RETURN OLD;	
	ELSE
		FOR linha IN
			SELECT 
				mov.mov_data,
				mov.mov_tipo, 
				mov.mov_saida,
				mov.mov_entrada,
				mov.set_entrada,
				mov.set_saida,
				pro.pro_codigo,
				pro.pro_horus,
				ite.ite_vlrunit,
				ite.ite_validade,
				ite.ite_lote,
				ite.ite_quantidade,
				ite.ite_codigo,
				count(ite.ite_codigo) AS num_registros,
				uni.uni_cnes
			FROM 
				itens_movimento AS ite
			INNER JOIN
				movimento AS mov ON ite.mov_codigo=mov.mov_codigo 
			INNER JOIN 
				produto AS pro ON ite.pro_codigo=pro.pro_codigo
			INNER JOIN 
				setor AS set ON mov.set_entrada=set.set_codigo OR mov.set_saida=set.set_codigo
			INNER JOIN 
				unidade AS uni ON set.uni_codigo=uni.uni_codigo
			WHERE 
				pro.pro_horus IS NOT NULL AND
				mov.mov_tipo IS NOT NULL AND
				pro.pro_codigo IS NOT NULL AND
				ite.ite_quantidade IS NOT NULL AND
				uni.uni_cnes IS NOT NULL AND
				ite.ite_codigo = NEW.ite_codigo 
			GROUP BY 
				mov.mov_data,
				mov.mov_tipo, 
				mov.mov_saida,
				mov.mov_entrada,
				mov.set_entrada,
				mov.set_saida,
				pro.pro_codigo,
				pro.pro_horus,
				ite.ite_vlrunit,
				ite.ite_validade,
				ite.ite_lote,
				ite.ite_quantidade,
				ite.ite_codigo,
				uni.uni_cnes LOOP

				RAISE NOTICE 'ite_vlrunit: %.', NEW.ite_vlrunit;
					
				IF (linha.num_registros > 0) THEN
					-- Validando Campo Lote
					IF (linha.ite_lote IS NULL) THEN
						ite_lote = '0';
					ELSE
						ite_lote = linha.ite_lote;
					END IF;
					-- Validando Valor do Item
					IF (linha.ite_vlrunit IS NULL) THEN
						ite_vlrunit = '0.0000';
					ELSE
						ite_vlrunit = linha.ite_vlrunit;
					END IF;
					-- Validando item da validade
					IF (linha.ite_validade IS NULL) THEN 
						ite_validade = (SELECT((DATE_PART('DAY', CURRENT_DATE)||'/'||DATE_PART('MONTH', CURRENT_DATE)||'/'||DATE_PART('YEAR', CURRENT_DATE))::DATE + interval '3 year')::DATE);
					ELSE
						ite_validade = linha.ite_validade;
					END IF;
					-- Valida tipo de XML(tpxml)
					IF (linha.mov_tipo <> 'T') THEN
						IF (linha.mov_tipo = 'S' AND linha.mov_saida = 'D') THEN 
							tpxml = 'D';
							tpmov = 'D'; 
						END IF;
						IF (linha.mov_tipo = 'S' AND linha.mov_saida <> 'D') THEN 
							tpxml = linha.mov_tipo;
							tpmov = linha.mov_saida; 
						END IF;
						IF (linha.mov_tipo = 'E') THEN 
							tpxml = linha.mov_tipo;
							tpmov = linha.mov_entrada; 
						END IF;
						-- Insert 
						IF (TG_OP = 'INSERT') THEN
							INSERT 	INTO horus_dados 
										(hor_dad_tpxml, hor_dad_status_envio, hor_dad_counidadecnes, hor_dad_nuproduto, hor_dad_tpproduto, hor_dad_vlitem, hor_dad_dtvalidade, hor_dad_nulote, hor_dad_qtd, hor_dad_nucnspaciente, hor_dad_tpmovimentacao, hor_dad_dtcadastro, hor_dad_origem, hor_dad_origem_codigo,hor_dad_dtrecebimentoprod)
									VALUES
										(tpxml,'F',linha.uni_cnes,linha.pro_horus,'B',ite_vlrunit,ite_validade,ite_lote,linha.ite_quantidade,'0',tpmov,NOW(),'itensmovimento',linha.ite_codigo,linha.mov_data);
							RETURN NEW;
						END IF;
					ELSE 
						-- Insert 
						IF (TG_OP = 'INSERT') THEN
						
							INSERT 	INTO horus_dados 
										(hor_dad_tpxml, hor_dad_status_envio, hor_dad_counidadecnes, hor_dad_nuproduto, hor_dad_tpproduto, hor_dad_vlitem, hor_dad_dtvalidade, hor_dad_nulote, hor_dad_qtd, hor_dad_nucnspaciente, hor_dad_tpmovimentacao, hor_dad_dtcadastro, hor_dad_origem, hor_dad_origem_codigo,hor_dad_dtrecebimentoprod)
									VALUES
										('E','F',linha.uni_cnes,linha.pro_horus,'B',ite_vlrunit,ite_validade,ite_lote,linha.ite_quantidade,'0','E-AE',NOW(),'itensmovimento',linha.ite_codigo,linha.mov_data);
										
							INSERT 	INTO horus_dados 
										(hor_dad_tpxml, hor_dad_status_envio, hor_dad_counidadecnes, hor_dad_nuproduto, hor_dad_tpproduto, hor_dad_vlitem, hor_dad_dtvalidade, hor_dad_nulote, hor_dad_qtd, hor_dad_nucnspaciente, hor_dad_tpmovimentacao, hor_dad_dtcadastro, hor_dad_origem, hor_dad_origem_codigo,hor_dad_dtrecebimentoprod)
									VALUES
										('S','F',linha.uni_cnes,linha.pro_horus,'B',ite_vlrunit,ite_validade,ite_lote,linha.ite_quantidade,'0','S-AE',NOW(),'itensmovimento',linha.ite_codigo,linha.mov_data);
							RETURN NEW;
						END IF;
					END IF;
					-- Update
					IF (TG_OP = 'UPDATE') THEN
						UPDATE horus_dados 
						   SET hor_dad_tpxml = tpxml, 
							   hor_dad_counidadecnes = linha.uni_cnes, 
							   hor_dad_nuproduto = linha.pro_horus, 
							   hor_dad_tpproduto = 'B', 
							   hor_dad_vlitem = linha.ite_vlrunit, 
							   hor_dad_dtvalidade = ite_validade, 
							   hor_dad_nulote = ite_lote, 
							   hor_dad_qtd = linha.ite_quantidade, 
							   hor_dad_nucnspaciente = '0', 
							   hor_dad_tpmovimentacao = tpmov, 
							   hor_dad_dtcadastro = NOW(), 
							   hor_dad_origem = 'itensmovimento', 
							   hor_dad_origem_codigo = linha.ite_codigo
						WHERE
							   hor_dad_origem = 'itensmovimento' AND 
							   hor_dad_origem_codigo = NEW.ite_codigo;
						RETURN NEW;	
					END IF;
				END IF;
		END LOOP;
	END IF;
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION operacoesiitensmovimentohorus()
  OWNER TO postgres;
  
  INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ADSTRINGENTE');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'AINES');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANALGESICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANESTÉSICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIALERGICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIANÊMICOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIANGINOSO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIARRÍTIMICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIASMÁTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIBACTERIANO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIBIÓTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTICOAGULANTE');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTICONVULSIONANTE');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIDEPRESSIVO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIDIABÉTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIEMÉTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIFÚNGICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIGOTOSO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIHELMINTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIHIPERTENSIVO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIHISTAMINICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTILIPIDEMICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIMALÁRICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIPARASITÁRIOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIPSICÓTICOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTISIOLÍTICOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIULCEROSOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ANTIVIRAIS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'BENZODIAZEPÍNICOS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'BETA BLOQUEADOR');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'BRONCODILATADOR');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'CORTICÓIDES');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'DIURÉTICO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'ESCABICIDAS E PEDICULICIDAS');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'EXPECTORANTE');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'HORMÔNIO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'HORMONIO TIREOIDEANO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'LAXANTES');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'METABOLISMO ÓSSEO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'REPOSITOR');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'SAIS DE REIDRATAÇÃO');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'VASODILATADORES');
INSERT INTO produto_subgrupo (pros_codigo, pros_descricao) VALUES (nextval('produto_subgrupo_pros_codigo_seq'), 'VITAMINA DO COMPLEXO B');

