UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.79.78' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.59.47' WHERE conf_chave='VERSAO_COMUM';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.28.26' WHERE conf_chave='VERSAO_SOCIAL';

CREATE TABLE tb_tipo_localidade(
  co_tipo_localidade bigserial,
  no_tipo_localidade character varying(60),
  sg_tipo_localidade character(1),
  PRIMARY KEY (co_tipo_localidade)	
);

ALTER TABLE cidade ADD COLUMN cid_nu_cep character varying(20);
ALTER TABLE cidade ADD COLUMN cid_nu_dne character varying(20);
ALTER TABLE cidade ADD COLUMN cid_nome_abreviatura character varying(60);
ALTER TABLE cidade ADD COLUMN tp_localidade integer;
ALTER TABLE cidade ADD FOREIGN KEY(tp_localidade) REFERENCES tb_tipo_localidade (co_tipo_localidade) ON UPDATE NO ACTION ON DELETE NO ACTION; 
ALTER TABLE cidade ADD COLUMN co_situacao_localidade integer;
ALTER TABLE cidade ADD FOREIGN KEY(co_situacao_localidade) REFERENCES tb_situacao_localidade (co_situacao_localidade) ON UPDATE NO ACTION ON DELETE NO ACTION; 
ALTER TABLE cidade ADD COLUMN cid_nome_filtro character varying(60);

ALTER TABLE estado ADD COLUMN uf_nu_cep character varying(20);
ALTER TABLE estado ADD COLUMN uf_nu_dne character varying(20);
ALTER TABLE estado ADD COLUMN uf_no_identificador character varying(20);

ALTER TABLE pais ADD COLUMN sg_pais_2 character varying(20);
ALTER TABLE pais ADD COLUMN sg_pais_3 character varying(20);
ALTER TABLE pais ADD COLUMN no_pais_portugues character varying(60);
ALTER TABLE pais ADD COLUMN no_pais_ingles character varying(60);
ALTER TABLE pais ADD COLUMN no_pais_frances character varying(60);
ALTER TABLE pais ADD COLUMN no_pais_portugues_filtro character varying(60);
ALTER TABLE pais ALTER COLUMN pais_codigo TYPE character varying(20);

CREATE SEQUENCE seq_pais_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1000
  CACHE 1;
ALTER TABLE seq_pais_codigo
  OWNER TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_pais_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_pais_codigo TO public;

CREATE TABLE bairro (
 bai_codigo bigserial,
 cid_codigo integer,
 bai_co_cep character varying,
 bai_co_dne character varying,
 bai_nome character varying,
 bai_abreviatura character varying,
 bai_filtro character varying,
 PRIMARY KEY(bai_codigo), 
 FOREIGN KEY(cid_codigo) REFERENCES cidade 
 ON UPDATE NO ACTION ON DELETE NO ACTION
);

ALTER TABLE rua ADD COLUMN bai_codigo integer;
ALTER TABLE rua ADD FOREIGN KEY (bai_codigo)  REFERENCES bairro ON UPDATE NO ACTION ON DELETE NO ACTION;

CREATE OR REPLACE FUNCTION remove_caracter_acento(stexto text)
  RETURNS text AS
$BODY$
DECLARE
  stextonovo TEXT;
BEGIN
  stextonovo := translate(stexto, '','');       
  stextonovo := translate(stextonovo, '','');   
  stextonovo := translate(stextonovo, '','');   
  stextonovo := translate(stextonovo, '','');   
  stextonovo := translate(stextonovo, '','');   
  stextonovo := translate(stextonovo, '','');   
  stextonovo := translate(stextonovo, '','');   
  stextonovo := translate(stextonovo, '','');   
  stextonovo := translate(stextonovo, '','');   
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '','');  
  stextonovo := translate(stextonovo, '',''); 
  stextonovo := translate(stextonovo, '',''); 
  stextonovo := translate(stextonovo, '',''); 
  stextonovo := translate(stextonovo, '',''); 
  stextonovo := translate(stextonovo, '',''); 
  stextonovo := translate(stextonovo, '',''); 
  stextonovo := translate(stextonovo, '',''); 
  stextonovo := translate(stextonovo, '',''); 
  stextonovo := translate(stextonovo, '',''); 
  stextonovo := translate(stextonovo, '','');
  RETURN stextonovo;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION remove_caracter_acento(text)
  OWNER TO postgres;

ALTER TABLE tb_ms_tipo_logradouro ADD COLUMN ds_nu_cep character varying;
ALTER TABLE tb_ms_tipo_logradouro ADD COLUMN ds_nu_dne character varying;
ALTER TABLE tb_ms_tipo_logradouro ADD COLUMN ds_tipo_logradouro_filtro character varying;

CREATE TABLE tb_titulo_patente (
 co_titulo_patente bigserial,
 nu_cep character varying,
 nu_dne character varying,
 no_titulo_patente character varying,
 no_titulo_patente_abreviatura character varying,
 PRIMARY KEY(co_titulo_patente)	
);

CREATE TABLE tb_tipo_paridade(
 co_tipo_paridade bigserial,
 no_tipo_paridade character varying,
 sg_tipo_paridade character varying,
 PRIMARY KEY(co_tipo_paridade)
);


ALTER TABLE rua ADD COLUMN rua_nu_cep character varying;
ALTER TABLE rua ADD COLUMN rua_nu_dne character varying;
ALTER TABLE rua ADD COLUMN rua_no_preposicao character varying;
ALTER TABLE rua ADD COLUMN rua_nome_abreviatura character varying;
ALTER TABLE rua ADD COLUMN rua_nu_inicial_trecho character varying;
ALTER TABLE rua ADD COLUMN rua_nu_final_trecho character varying;
ALTER TABLE rua ADD COLUMN rua_nu_seccionamento_dne character varying;
ALTER TABLE rua ADD COLUMN rua_sg_tipo_registro character varying;
ALTER TABLE rua ADD COLUMN rua_no_logradouro_filtro character varying;
ALTER TABLE rua ADD COLUMN rua_no_logradouro_exibicao character varying;
ALTER TABLE rua ADD COLUMN co_titulo_patente integer; 
ALTER TABLE rua ADD FOREIGN KEY (co_titulo_patente) REFERENCES tb_titulo_patente ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE rua ADD COLUMN tp_paridade integer;
ALTER TABLE rua ADD FOREIGN KEY (tp_paridade) REFERENCES tb_tipo_paridade ON UPDATE NO ACTION ON DELETE NO ACTION;   

CREATE TABLE movimento_bkp
(
  mov_codigo bigint NOT NULL,
  mov_data date NOT NULL,
  mov_tipo character(1) NOT NULL,
  for_codigo bigint,
  usu_codigo bigint,
  mov_desconto real,
  mov_observacao text,
  cond_codigo bigint,
  ate_codigo bigint,
  set_entrada bigint,
  set_saida bigint,
  mov_nr_nota character varying(15),
  mov_dt_nota date,
  usr_codigo bigint,
  mov_ip character varying(15),
  mov_total_nota numeric(15,2),
  mov_data_inclusao date,
  mov_entrada character(20),
  mov_saida character(20),
  mov_acrescimo real,
  mov_tipo_acrescimo character varying(60),
  inv_codigo bigint,
  mov_num_receita bigint,
  gru_codigo bigint,
  age_codigo bigint,
  mov_requisitante character varying(200),
  req_codigo bigint,
  usr_codigo_responsavel bigint,
  eve_codigo bigint,
  med_codigo_interno bigint,
  med_codigo_externo bigint,
  CONSTRAINT movimento_bkp_pkey PRIMARY KEY (mov_codigo),
  CONSTRAINT "$1" FOREIGN KEY (for_codigo)
      REFERENCES fornecedor (for_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT "$2" FOREIGN KEY (usu_codigo)
      REFERENCES usuario (usu_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT "$3" FOREIGN KEY (cond_codigo)
      REFERENCES condpagto (cond_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT "$4" FOREIGN KEY (ate_codigo)
      REFERENCES atendimento (ate_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_evento FOREIGN KEY (eve_codigo)
      REFERENCES evento (eve_codigo) MATCH FULL
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_medico_externo FOREIGN KEY (med_codigo_externo)
      REFERENCES medico (med_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_medico_interno FOREIGN KEY (med_codigo_interno)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_setor_entrada FOREIGN KEY (set_entrada)
      REFERENCES setor (set_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_setor_saida FOREIGN KEY (set_saida)
      REFERENCES setor (set_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE movimento_bkp
  OWNER TO postgres;


CREATE TABLE itens_movimento_bkp
(
  ite_codigo bigint NOT NULL,
  mov_codigo bigint NOT NULL,
  pro_codigo bigint NOT NULL,
  ite_vlrdesc real,
  ite_lote character varying(20) DEFAULT 'SEM_LOTE'::character varying,
  ite_validade date DEFAULT '2900-12-31'::date,
  usr_codigo bigint,
  ite_timestamp bigint,
  ite_ip character varying(15),
  ite_status character(1) NOT NULL DEFAULT 'A'::bpchar,
  ite_quantidade numeric(20,4),
  ite_consolidado character(1) NOT NULL DEFAULT 'N'::bpchar,
  ite_vlrunit numeric(20,2),
  ite_qtde_solicitada numeric(20,4),
  ite_posologia text,
  ite_detalhes_tratamento text,
  ite_observacoes text,
  ite_qtde_dia bigint,
  ite_vlrtotal numeric(20,2) DEFAULT 0.0,
  ite_lote_bkp character varying(20),
  ite_validade_bkp date,
  ite_dose integer NOT NULL DEFAULT 1,
  ite_dose_lote integer NOT NULL DEFAULT 1,
  ite_duracao integer,
  CONSTRAINT itens_movimento_bkp_pkey PRIMARY KEY (ite_codigo),
  CONSTRAINT "$1" FOREIGN KEY (mov_codigo)
      REFERENCES movimento_bkp (mov_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT "$2" FOREIGN KEY (pro_codigo)
      REFERENCES produto (pro_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

ALTER TABLE controlefracionado  DROP CONSTRAINT "FK_ite_codigo";