UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.81.80' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.61.49' WHERE conf_chave='VERSAO_COMUM';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.28.26' WHERE conf_chave='VERSAO_SOCIAL';

drop view v_consumo;
drop view v_consumo_tp_mov;
drop view v_produto_centroestoc;
drop view v_movimentacao;
drop view v_movimentacao_all;

ALTER TABLE itens_movimento
   ALTER COLUMN ite_vlrunit TYPE numeric(20,4);

ALTER TABLE itens_movimento
   ALTER COLUMN ite_vlrtotal TYPE numeric(20,4);

CREATE OR REPLACE VIEW v_movimentacao_all AS 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data,
            mov.mov_data,
            mov.mov_nr_nota,
            get_setor(mov.set_saida) AS setor,
            mov.mov_saida AS tipomovim,
            it.pro_codigo,
            produto.pro_nome,
            mov.mov_codigo,
            mov.set_saida AS codsetor,
            mov.mov_tipo,
            mov.mov_saida AS operacao,
            '-'::text AS sinal,
            mov.set_entrada AS codsetorsolicit,
            get_setor(mov.set_entrada) AS nomesetorsolicit,
                CASE
                    WHEN mov.mov_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(mov.set_saida)::text
                    WHEN mov.mov_saida = 'D'::bpchar THEN ('DISPENSACAO PARA PACIENTE '::text || ' - '::text) || (( SELECT substr(usuario.usu_nome::text, 1, 20) AS substr
                       FROM usuario usuario
                      WHERE usuario.usu_codigo = mov.usu_codigo))
                    WHEN mov.mov_saida = 'P'::bpchar THEN 'SAIDA DE PERMUTA'::text
                    WHEN mov.mov_saida = 'I'::bpchar THEN 'SAIDA POR INVENTARIO'::text
                    WHEN mov.mov_saida = 'A'::bpchar THEN 'SAIDA POR AJUSTE'::text
                    WHEN mov.mov_saida = 'R'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-PE'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-VV'::bpchar THEN 'SAIDA POR VALIDADE VENCIDA'::text
                    WHEN mov.mov_saida = 'S-AEA'::bpchar THEN 'SAIDA POR AMOSTRA, EXPOSIO E ANLISE'::text
                    WHEN mov.mov_saida = 'S-DEP'::bpchar THEN 'DEVOLUO DE ENTRADA DE PRODUTO'::text
                    WHEN mov.mov_saida = 'S-TR'::bpchar THEN 'SADA POR TRANSFERNCIA E REMANEJAMENTO'::text
                    WHEN mov.mov_saida = 'S-D'::bpchar THEN 'SADA POR DOAO'::text
                    WHEN mov.mov_saida = 'S-AS'::bpchar THEN 'SADA POR APREENSO SANITRIA'::text
                    WHEN mov.mov_saida = 'S-E'::bpchar THEN 'SADA PARA EMPRSTIMO'::text
                    WHEN mov.mov_saida = 'S-P'::bpchar THEN 'SADA PARA PACIENTE NO IDENTIFICADO'::text
                    WHEN mov.mov_saida = 'S-AE'::bpchar THEN 'SADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_saida = 'O'::bpchar THEN 'OUTRAS SAIDAS'::text
                    WHEN mov.mov_saida = 'M'::bpchar THEN 'SAIDAS DE EMPRESTIMOS'::text
                    WHEN mov.mov_saida = 'T'::bpchar THEN 'SAIDA POR TRANSFERENCIA PARA '::text || get_setor(mov.set_saida)::text
                    ELSE NULL::text
                END AS desc_movimentacao,
            it.ite_quantidade,
            it.ite_vlrunit,
            mov.age_codigo,
            mov.usu_codigo
           FROM movimento mov,
            itens_movimento it,
            produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'S'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
UNION ALL
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data,
            mov.mov_data,
            mov.mov_nr_nota,
            get_setor(mov.set_entrada) AS setor,
            mov.mov_entrada AS tipomovim,
            it.pro_codigo,
            produto.pro_nome,
            mov.mov_codigo,
            mov.set_entrada AS codsetor,
            mov.mov_tipo,
            mov.mov_entrada AS operacao,
            '+'::text AS sinal,
            mov.set_saida AS codsetorsolicit,
            get_setor(mov.set_saida) AS nomesetorsolicit,
                CASE
                    WHEN mov.mov_entrada = 'E-SI'::bpchar THEN 'ENTRADA POR SALDO DE IMPLANTAO'::text
                    WHEN mov.mov_entrada = 'E-C'::bpchar THEN 'ENTRADA POR CONCORRNCIA'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAO'::text
                    WHEN mov.mov_entrada = 'E-CONV'::bpchar THEN 'ENTRADA POR CONVITE'::text
                    WHEN mov.mov_entrada = 'D'::bpchar THEN 'ENTRADA POR DOAO'::text
                    WHEN mov.mov_entrada = 'E-D'::bpchar THEN 'ENTRADA POR DOAO'::text
                    WHEN mov.mov_entrada = 'E-P'::bpchar THEN 'ENTRADA POR PREGO'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAO'::text
                    WHEN mov.mov_entrada = 'A'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-AE'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-EVENTUAL'::bpchar THEN 'ENTRADA POR ENTRADA EVENTUAL'::text
                    WHEN mov.mov_entrada = 'E-O'::bpchar THEN 'ENTRADA POR ENTRADA ORDINRIA'::text
                    WHEN mov.mov_entrada = 'E-TP'::bpchar THEN 'ENTRADA POR TOMADA DE PREOS'::text
                    WHEN mov.mov_entrada = 'E-INEX'::bpchar THEN 'ENTRADA POR INEXIGIBILIDADE'::text
                    WHEN mov.mov_entrada = 'P'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E-PER'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E'::bpchar THEN 'ENTRADA DE NOTA FISCAL'::text
                    WHEN mov.mov_entrada = 'M'::bpchar THEN 'ENTRADA DE EMPRESTIMO'::text
                    WHEN mov.mov_entrada = 'I'::bpchar THEN 'ENTRADA DE INVENTARIO'::text
                    WHEN mov.mov_entrada = 'O'::bpchar THEN 'OUTRAS ENTRADAS'::text
                    WHEN mov.mov_entrada = 'T'::bpchar THEN 'ENTRADA POR TRANSFERENCIA DE'::text || get_setor(mov.set_entrada)::text
                    WHEN mov.mov_entrada = 'v'::bpchar THEN 'DEVOLUCAO DE SETORES'::text
                    ELSE NULL::text
                END AS desc_movimentacao,
            it.ite_quantidade,
            it.ite_vlrunit,
            mov.age_codigo,
            mov.usu_codigo
           FROM movimento mov,
            itens_movimento it,
            produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'E'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
  ORDER BY 2, 10;

CREATE OR REPLACE VIEW v_movimentacao AS 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data,
            mov.mov_data,
            mov.mov_nr_nota,
            get_setor(mov.set_saida) AS setor,
            mov.mov_saida AS tipomovim,
            it.pro_codigo,
            produto.pro_nome,
            mov.mov_codigo,
            mov.set_saida AS codsetor,
            mov.mov_tipo,
            mov.mov_saida AS operacao,
            '-'::text AS sinal,
            mov.set_entrada AS codsetorsolicit,
            get_setor(mov.set_entrada) AS nomesetorsolicit,
                CASE
                    WHEN mov.mov_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(mov.set_saida)::text
                    WHEN mov.mov_saida = 'D'::bpchar THEN ('DISPENSACAO PARA PACIENTE '::text || ' - '::text) || (( SELECT substr(usuario.usu_nome::text, 1, 20) AS substr
                       FROM usuario
                      WHERE usuario.usu_codigo = mov.usu_codigo))
                    WHEN mov.mov_saida = 'P'::bpchar THEN 'SAIDA DE PERMUTA'::text
                    WHEN mov.mov_saida = 'I'::bpchar THEN 'SAIDA POR INVENTARIO'::text
                    WHEN mov.mov_saida = 'A'::bpchar THEN 'SAIDA POR AJUSTE'::text
                    WHEN mov.mov_saida = 'R'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-PE'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-VV'::bpchar THEN 'SAIDA POR VALIDADE VENCIDA'::text
                    WHEN mov.mov_saida = 'S-AEA'::bpchar THEN 'SAIDA POR AMOSTRA, EXPOSIO E ANLISE'::text
                    WHEN mov.mov_saida = 'S-DEP'::bpchar THEN 'DEVOLUO DE ENTRADA DE PRODUTO'::text
                    WHEN mov.mov_saida = 'S-TR'::bpchar THEN 'SADA POR TRANSFERNCIA E REMANEJAMENTO'::text
                    WHEN mov.mov_saida = 'S-D'::bpchar THEN 'SADA POR DOAO'::text
                    WHEN mov.mov_saida = 'S-AS'::bpchar THEN 'SADA POR APREENSO SANITRIA'::text
                    WHEN mov.mov_saida = 'S-E'::bpchar THEN 'SADA PARA EMPRSTIMO'::text
                    WHEN mov.mov_saida = 'S-P'::bpchar THEN 'SADA PARA PACIENTE NO IDENTIFICADO'::text
                    WHEN mov.mov_saida = 'S-AE'::bpchar THEN 'SADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_saida = 'O'::bpchar THEN 'OUTRAS SAIDAS'::text
                    WHEN mov.mov_saida = 'M'::bpchar THEN 'SAIDAS DE EMPRESTIMOS'::text
                    WHEN mov.mov_saida = 'T'::bpchar THEN 'SAIDA POR TRANSFERENCIA PARA '::text || get_setor(mov.set_saida)::text
                    ELSE NULL::text
                END AS desc_movimentacao,
            it.ite_quantidade,
            it.ite_vlrunit,
            mov.age_codigo,
            mov.usu_codigo
           FROM movimento mov,
            itens_movimento it,
            produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'S'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
UNION ALL
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data,
            mov.mov_data,
            mov.mov_nr_nota,
            get_setor(mov.set_entrada) AS setor,
            mov.mov_entrada AS tipomovim,
            it.pro_codigo,
            produto.pro_nome,
            mov.mov_codigo,
            mov.set_entrada AS codsetor,
            mov.mov_tipo,
            mov.mov_entrada AS operacao,
            '+'::text AS sinal,
            mov.set_saida AS codsetorsolicit,
            get_setor(mov.set_saida) AS nomesetorsolicit,
                CASE
                    WHEN mov.mov_entrada = 'E-SI'::bpchar THEN 'ENTRADA POR SALDO DE IMPLANTAO'::text
                    WHEN mov.mov_entrada = 'E-C'::bpchar THEN 'ENTRADA POR CONCORRNCIA'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAO'::text
                    WHEN mov.mov_entrada = 'E-CONV'::bpchar THEN 'ENTRADA POR CONVITE'::text
                    WHEN mov.mov_entrada = 'D'::bpchar THEN 'ENTRADA POR DOAO'::text
                    WHEN mov.mov_entrada = 'E-D'::bpchar THEN 'ENTRADA POR DOAO'::text
                    WHEN mov.mov_entrada = 'E-P'::bpchar THEN 'ENTRADA POR PREGO'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAO'::text
                    WHEN mov.mov_entrada = 'A'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-AE'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-EVENTUAL'::bpchar THEN 'ENTRADA POR ENTRADA EVENTUAL'::text
                    WHEN mov.mov_entrada = 'E-O'::bpchar THEN 'ENTRADA POR ENTRADA ORDINRIA'::text
                    WHEN mov.mov_entrada = 'E-TP'::bpchar THEN 'ENTRADA POR TOMADA DE PREOS'::text
                    WHEN mov.mov_entrada = 'E-INEX'::bpchar THEN 'ENTRADA POR INEXIGIBILIDADE'::text
                    WHEN mov.mov_entrada = 'P'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E-PER'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E'::bpchar THEN 'ENTRADA DE NOTA FISCAL'::text
                    WHEN mov.mov_entrada = 'M'::bpchar THEN 'ENTRADA DE EMPRESTIMO'::text
                    WHEN mov.mov_entrada = 'I'::bpchar THEN 'ENTRADA DE INVENTARIO'::text
                    WHEN mov.mov_entrada = 'O'::bpchar THEN 'OUTRAS ENTRADAS'::text
                    WHEN mov.mov_entrada = 'T'::bpchar THEN 'ENTRADA POR TRANSFERENCIA DE'::text || get_setor(mov.set_entrada)::text
                    WHEN mov.mov_entrada = 'v'::bpchar THEN 'DEVOLUCAO DE SETORES'::text
                    ELSE NULL::text
                END AS desc_movimentacao,
            it.ite_quantidade,
            it.ite_vlrunit,
            mov.age_codigo,
            mov.usu_codigo
           FROM movimento mov,
            itens_movimento it,
            produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'E'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
  ORDER BY 2, 10;

CREATE OR REPLACE VIEW v_produto_centroestoc AS 
        ( SELECT DISTINCT v_movimentacao.codsetor,
            v_movimentacao.setor AS nomesetor,
            v_movimentacao.pro_codigo,
            v_movimentacao.pro_nome
           FROM v_movimentacao
          ORDER BY v_movimentacao.codsetor, v_movimentacao.setor, v_movimentacao.pro_codigo, v_movimentacao.pro_nome)
UNION
        ( SELECT DISTINCT saldo.set_codigo AS codsetor,
            get_setor(saldo.set_codigo) AS nomesetor,
            saldo.pro_codigo,
            get_produto(saldo.pro_codigo) AS pro_nome
           FROM saldo
          ORDER BY saldo.set_codigo, get_setor(saldo.set_codigo), saldo.pro_codigo, get_produto(saldo.pro_codigo));

CREATE OR REPLACE VIEW v_consumo AS 
 SELECT get_cod_grupo(v_movimentacao.pro_codigo) AS gru_codigo,
    get_nome_grupo(v_movimentacao.pro_codigo) AS gru_nome,
    v_movimentacao.pro_codigo,
    v_movimentacao.pro_nome,
    v_movimentacao.codsetor,
    v_movimentacao.setor,
    sum(COALESCE(v_movimentacao.ite_quantidade, 0::numeric)) AS consumo,
    verifica_preco(v_movimentacao.pro_codigo, v_movimentacao.codsetor, v_movimentacao.mov_data) AS preco,
    v_movimentacao.mov_data
   FROM v_movimentacao,
    v_produto_centroestoc
  WHERE v_movimentacao.pro_codigo = v_produto_centroestoc.pro_codigo AND v_movimentacao.codsetor = v_produto_centroestoc.codsetor AND v_movimentacao.sinal = '-'::text
  GROUP BY get_cod_grupo(v_movimentacao.pro_codigo), get_nome_grupo(v_movimentacao.pro_codigo), v_movimentacao.pro_codigo, v_movimentacao.pro_nome, v_movimentacao.codsetor, v_movimentacao.setor, v_movimentacao.mov_data;

CREATE OR REPLACE VIEW v_consumo_tp_mov AS 
 SELECT get_cod_grupo(v_movimentacao.pro_codigo) AS gru_codigo,
    get_nome_grupo(v_movimentacao.pro_codigo) AS gru_nome,
    v_movimentacao.pro_codigo,
    v_movimentacao.pro_nome,
    v_movimentacao.codsetor,
    v_movimentacao.setor,
    sum(COALESCE(v_movimentacao.ite_quantidade, 0::numeric)) AS consumo,
    verifica_preco(v_movimentacao.pro_codigo, v_movimentacao.codsetor, v_movimentacao.mov_data) AS preco,
    v_movimentacao.mov_data,
    v_movimentacao.tipomovim,
    v_movimentacao.sinal
   FROM v_movimentacao,
    v_produto_centroestoc
  WHERE v_movimentacao.pro_codigo = v_produto_centroestoc.pro_codigo AND v_movimentacao.codsetor = v_produto_centroestoc.codsetor AND v_movimentacao.sinal = '-'::text
  GROUP BY get_cod_grupo(v_movimentacao.pro_codigo), get_nome_grupo(v_movimentacao.pro_codigo), v_movimentacao.pro_codigo, v_movimentacao.pro_nome, v_movimentacao.codsetor, v_movimentacao.setor, v_movimentacao.mov_data, v_movimentacao.tipomovim, v_movimentacao.sinal;

CREATE OR REPLACE VIEW v_movimentacao_all AS 
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data,
            mov.mov_data,
            mov.mov_nr_nota,
            get_setor(mov.set_saida) AS setor,
            mov.mov_saida AS tipomovim,
            it.pro_codigo,
            produto.pro_nome,
            mov.mov_codigo,
            mov.set_saida AS codsetor,
            mov.mov_tipo,
            mov.mov_saida AS operacao,
            '-'::text AS sinal,
            mov.set_entrada AS codsetorsolicit,
            get_setor(mov.set_entrada) AS nomesetorsolicit,
                CASE
                    WHEN mov.mov_saida = 'S'::bpchar THEN 'SAIDA DE REQUISICAO PARA '::text || get_setor(mov.set_saida)::text
                    WHEN mov.mov_saida = 'D'::bpchar THEN ('DISPENSACAO PARA PACIENTE '::text || ' - '::text) || (( SELECT substr(usuario.usu_nome::text, 1, 20) AS substr
                       FROM usuario usuario
                      WHERE usuario.usu_codigo = mov.usu_codigo))
                    WHEN mov.mov_saida = 'P'::bpchar THEN 'SAIDA DE PERMUTA'::text
                    WHEN mov.mov_saida = 'I'::bpchar THEN 'SAIDA POR INVENTARIO'::text
                    WHEN mov.mov_saida = 'A'::bpchar THEN 'SAIDA POR AJUSTE'::text
                    WHEN mov.mov_saida = 'R'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-PE'::bpchar THEN 'SAIDA POR PERDAS'::text
                    WHEN mov.mov_saida = 'S-VV'::bpchar THEN 'SAIDA POR VALIDADE VENCIDA'::text
                    WHEN mov.mov_saida = 'S-AEA'::bpchar THEN 'SAIDA POR AMOSTRA, EXPOSIO E ANLISE'::text
                    WHEN mov.mov_saida = 'S-DEP'::bpchar THEN 'DEVOLUO DE ENTRADA DE PRODUTO'::text
                    WHEN mov.mov_saida = 'S-TR'::bpchar THEN 'SADA POR TRANSFERNCIA E REMANEJAMENTO'::text
                    WHEN mov.mov_saida = 'S-D'::bpchar THEN 'SADA POR DOAO'::text
                    WHEN mov.mov_saida = 'S-AS'::bpchar THEN 'SADA POR APREENSO SANITRIA'::text
                    WHEN mov.mov_saida = 'S-E'::bpchar THEN 'SADA PARA EMPRSTIMO'::text
                    WHEN mov.mov_saida = 'S-P'::bpchar THEN 'SADA PARA PACIENTE NO IDENTIFICADO'::text
                    WHEN mov.mov_saida = 'S-AE'::bpchar THEN 'SADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_saida = 'O'::bpchar THEN 'OUTRAS SAIDAS'::text
                    WHEN mov.mov_saida = 'M'::bpchar THEN 'SAIDAS DE EMPRESTIMOS'::text
                    WHEN mov.mov_saida = 'T'::bpchar THEN 'SAIDA POR TRANSFERENCIA PARA '::text || get_setor(mov.set_saida)::text
                    ELSE NULL::text
                END AS desc_movimentacao,
            it.ite_quantidade,
            it.ite_vlrunit,
            mov.age_codigo,
            mov.usu_codigo
           FROM movimento mov,
            itens_movimento it,
            produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'S'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
UNION ALL
         SELECT to_char(mov.mov_data::timestamp with time zone, 'DD/MM/YYYY'::text) AS data,
            mov.mov_data,
            mov.mov_nr_nota,
            get_setor(mov.set_entrada) AS setor,
            mov.mov_entrada AS tipomovim,
            it.pro_codigo,
            produto.pro_nome,
            mov.mov_codigo,
            mov.set_entrada AS codsetor,
            mov.mov_tipo,
            mov.mov_entrada AS operacao,
            '+'::text AS sinal,
            mov.set_saida AS codsetorsolicit,
            get_setor(mov.set_saida) AS nomesetorsolicit,
                CASE
                    WHEN mov.mov_entrada = 'E-SI'::bpchar THEN 'ENTRADA POR SALDO DE IMPLANTAO'::text
                    WHEN mov.mov_entrada = 'E-C'::bpchar THEN 'ENTRADA POR CONCORRNCIA'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAO'::text
                    WHEN mov.mov_entrada = 'E-CONV'::bpchar THEN 'ENTRADA POR CONVITE'::text
                    WHEN mov.mov_entrada = 'D'::bpchar THEN 'ENTRADA POR DOAO'::text
                    WHEN mov.mov_entrada = 'E-D'::bpchar THEN 'ENTRADA POR DOAO'::text
                    WHEN mov.mov_entrada = 'E-P'::bpchar THEN 'ENTRADA POR PREGO'::text
                    WHEN mov.mov_entrada = 'E-DL'::bpchar THEN 'ENTRADA POR DISPENSA DE LICITAO'::text
                    WHEN mov.mov_entrada = 'A'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-AE'::bpchar THEN 'ENTRADA POR AJUSTE DE ESTOQUE'::text
                    WHEN mov.mov_entrada = 'E-EVENTUAL'::bpchar THEN 'ENTRADA POR ENTRADA EVENTUAL'::text
                    WHEN mov.mov_entrada = 'E-O'::bpchar THEN 'ENTRADA POR ENTRADA ORDINRIA'::text
                    WHEN mov.mov_entrada = 'E-TP'::bpchar THEN 'ENTRADA POR TOMADA DE PREOS'::text
                    WHEN mov.mov_entrada = 'E-INEX'::bpchar THEN 'ENTRADA POR INEXIGIBILIDADE'::text
                    WHEN mov.mov_entrada = 'P'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E-PER'::bpchar THEN 'ENTRADA POR PERMUTA'::text
                    WHEN mov.mov_entrada = 'E'::bpchar THEN 'ENTRADA DE NOTA FISCAL'::text
                    WHEN mov.mov_entrada = 'M'::bpchar THEN 'ENTRADA DE EMPRESTIMO'::text
                    WHEN mov.mov_entrada = 'I'::bpchar THEN 'ENTRADA DE INVENTARIO'::text
                    WHEN mov.mov_entrada = 'O'::bpchar THEN 'OUTRAS ENTRADAS'::text
                    WHEN mov.mov_entrada = 'T'::bpchar THEN 'ENTRADA POR TRANSFERENCIA DE'::text || get_setor(mov.set_entrada)::text
                    WHEN mov.mov_entrada = 'v'::bpchar THEN 'DEVOLUCAO DE SETORES'::text
                    ELSE NULL::text
                END AS desc_movimentacao,
            it.ite_quantidade,
            it.ite_vlrunit,
            mov.age_codigo,
            mov.usu_codigo
           FROM movimento mov,
            itens_movimento it,
            produto
          WHERE mov.mov_codigo = it.mov_codigo AND it.pro_codigo = produto.pro_codigo AND (mov.mov_tipo = 'E'::bpchar OR mov.mov_tipo = 'T'::bpchar) AND it.ite_consolidado = 'S'::bpchar
  ORDER BY 2, 10;
  

ALTER TABLE unidade ADD COLUMN uni_bairro character varying(20);
