UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.85.84' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.64.52' WHERE conf_chave='VERSAO_COMUM';


CREATE OR REPLACE FUNCTION persisteestoqueupdate()
  RETURNS trigger AS
$BODY$
DECLARE
	vmov_tipo	character(1);
	vset_entrada	bigint;
	vset_saida	bigint;
	vsal_codigo	bigint;
	vpro_codigo	bigint;
	vset_codigo	bigint;
	vsal_data	date;
	vsal_qtde	integer;
	vpro_custo	numeric(9,4);
	vsal_lote	character varying(20);
	vsal_validade	date;
	vnova_qtde	integer;
	vqtdeold	integer;
	vqtdenew	integer;
BEGIN
	vqtdeold := trunc(OLD.ite_quantidade);
	vqtdenew := trunc(NEW.ite_quantidade);

	RAISE NOTICE 'Mov_codigo: %.', OLD.mov_codigo;
	RAISE NOTICE 'Pro_codigo: %.', OLD.pro_codigo;
	RAISE NOTICE 'Ite_lote: %.', NEW.ite_lote;
	RAISE NOTICE 'Ite_validade: %.', NEW.ite_validade;
	RAISE NOTICE 'Ite_quantidadeOLD: %', vqtdeold;
	RAISE NOTICE 'Ite_quantidadeNEW: %', vqtdenew;

	--descobrir o tipo de movimento para definir se vai somar ou subtrair
	SELECT mov_tipo,
	       set_entrada,
	       set_saida
	  INTO vmov_tipo,
	       vset_entrada,
	       vset_saida
	  FROM movimento 
	 WHERE mov_codigo = OLD.mov_codigo;

	RAISE NOTICE 'mov_tipo: %', vmov_tipo;
	RAISE NOTICE 'set_entrada: %', vset_entrada;
	RAISE NOTICE 'set_saida: %', vset_saida;

	--vsal_qtde := 0;
	
	RAISE NOTICE 'vsal_qtde: %', vsal_qtde;
	
	--se mov_tipo for (S)aída ou (T)ransferência
	IF vmov_tipo <> 'E' THEN

		--calcular o estoque atual
		SELECT trunc(sal_qtde)
		  INTO vsal_qtde
		  FROM saldo 
		 WHERE set_codigo = vset_saida
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade;

		IF NOT FOUND THEN
			vsal_qtde = 0;
		END IF;

		--calcular novo saldo
		vnova_qtde := vsal_qtde - vqtdenew + vqtdeold;

		RAISE NOTICE 'vnova_qtde: %', vnova_qtde;
		RAISE NOTICE 'vQtdenew: %', vqtdenew;
		RAISE NOTICE 'vQtdeold: %', vqtdeold;
		RAISE NOTICE 'vnova_qtde: %', vnova_qtde;
		RAISE NOTICE 'new.pro_codigo: %', OLD.pro_codigo;
		RAISE NOTICE 'new.ite_lote: %', OLD.ite_lote;
		RAISE NOTICE 'new.ite_validade: %', OLD.ite_validade;
		--atualizar o estoque na tabela saldo
		UPDATE saldo 
		   SET sal_qtde = vnova_qtde,
		       sal_data = CURRENT_DATE,
		       sal_lote = NEW.ite_lote,
		       sal_validade = NEW.ite_validade
		 WHERE set_codigo = vset_saida
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade; 
		   
	END IF;
	--se mov_tipo for (E)ntrada ou (T)ransferência
	IF vmov_tipo <> 'S' THEN

		--calcular o estoque atual
		SELECT trunc(sal_qtde)
		  INTO vsal_qtde
		  FROM saldo 
		 WHERE set_codigo = vset_entrada
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade;

		IF NOT FOUND THEN
			vsal_qtde = 0;
		END IF;

		--calcular novo saldo
		vnova_qtde := vsal_qtde - vqtdeold + vqtdenew;

		--atualizar o estoque na tabela saldo
		UPDATE saldo 
		   SET sal_qtde = vnova_qtde,
		       sal_data = CURRENT_DATE,
		       sal_lote = NEW.ite_lote,
		       sal_validade = NEW.ite_validade
		 WHERE set_codigo = vset_entrada
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade;

	END IF;
	
	RETURN NEW;
END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION persisteestoqueupdate()
  OWNER TO postgres;


  