UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.86.85' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.65.53' WHERE conf_chave='VERSAO_COMUM';

CREATE OR REPLACE FUNCTION atualiza_permissoes(usr bigint)
  RETURNS void AS
$BODY$

DECLARE

	rec RECORD;
	teste INT8 := -1;


BEGIN
	-- limpa permissoes sem vinculo (td mundo)
	DELETE FROM usuarios_permissoes 
		WHERE perm_codigo NOT IN ( SELECT perm_codigo FROM permissoes );

	-- varre as permissoes
	FOR rec IN
		SELECT perm_codigo FROM permissoes ORDER BY 1
	LOOP
		
		-- verifica se aquele usuario tem aquela permissao
		SELECT COUNT(perus_codigo) INTO teste
			FROM usuarios_permissoes 
			WHERE usr_codigo = usr AND perm_codigo = rec.perm_codigo;

		--RAISE NOTICE 'teste = (%)', teste;

		-- insere 'negando' tudo
		IF( teste < 1 ) THEN

			INSERT INTO usuarios_permissoes 
				( usr_codigo, perm_set, nivel_i, nivel_a, nivel_d, nivel_l,  nivel_b, perm_codigo )
				VALUES 
				( usr, 'S', 'S', 'S', 'S', 'S', 'S', rec.perm_codigo);

		END IF;


	END LOOP;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION atualiza_permissoes(bigint)
  OWNER TO postgres;
  
  CREATE OR REPLACE FUNCTION inserir_bairros()
  RETURNS void AS
$BODY$

DECLARE
	rec RECORD;
	bairro character varying;

BEGIN

	FOR rec IN select distinct retira_acentos(TRIM(both from  UPPER(rua_bairro))) as rua_bairro from rua order by rua_bairro
	LOOP

		INSERT INTO bairro (bai_nome) VALUES (rec.rua_bairro);
	END LOOP;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION inserir_bairros()
  OWNER TO postgres;

select inserir_bairros();
drop function inserir_bairros();


 CREATE OR REPLACE FUNCTION converter_bairros()
 RETURNS void AS
$BODY$

DECLARE
	rec RECORD;
	bairro character varying;
	bai_codigo_c integer;

BEGIN
	
	FOR rec IN 
		select dom_codigo,
			retira_acentos(TRIM(both from  UPPER(rua_bairro))) as rua_bairro
		  from domicilio d
		  join rua r
		    on r.rua_codigo=d.rua_codigo
	LOOP
		-- verifica se aquele usuario tem aquela permissao
		SELECT bai_codigo into bai_codigo_c from bairro where bai_nome = rec.rua_bairro limit 1;
		UPDATE domicilio SET bai_codigo = bai_codigo_c WHERE dom_codigo = rec.dom_codigo;
	END LOOP;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION converter_bairros()
  OWNER TO postgres;

select * from converter_bairros();
drop function converter_bairros();

ALTER TABLE domicilio
   ALTER COLUMN dom_complemento TYPE character varying;
   
insert permissoes (perm_descricao,perm_programa,perm_objeto) values ('ZF - Default - Cadastro de Rua','zf/default/rua','zf/default/rua');
