UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.87.86' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.66.54' WHERE conf_chave='VERSAO_COMUM';

CREATE TABLE social.as_prontuario_suas (
  asps_codigo            bigint NOT NULL,
  asps_num_prontuario    integer NOT NULL,
  /* Keys */
  CONSTRAINT as_prontuario_suas_pkey
    PRIMARY KEY (asps_codigo)
) WITH (
    OIDS = FALSE
  );
ALTER TABLE social.as_prontuario_suas
  OWNER TO postgres;

CREATE SEQUENCE seq_asps_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asps_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asps_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asps_codigo TO public;
ALTER TABLE as_prontuario_suas ALTER COLUMN asps_codigo SET DEFAULT nextval(('seq_asps_codigo'::text)::regclass);

CREATE TABLE social.as_prontuario_suas_usuario (
  aspsu_codigo      bigint NOT NULL,
  asps_codigo       bigint NOT NULL,
  usu_codigo        bigint NOT NULL,
  aspsu_num_ordem   integer NOT NULL,
  aspsu_parentesco  integer NOT NULL,
  aspsu_ativo       boolean DEFAULT false,
  /* Foreign keys */
  CONSTRAINT fk_asps_codigo
    FOREIGN KEY (asps_codigo)
    REFERENCES social.as_prontuario_suas(asps_codigo), 
  CONSTRAINT fk_usu_codigo
    FOREIGN KEY (usu_codigo)
    REFERENCES social.usuario(usu_codigo)
) WITH (
	OIDS = FALSE
);
ALTER TABLE social.as_prontuario_suas_usuario
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsu_codigo
 INCREMENT 1
 MINVALUE 1 
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;
ALTER TABLE seq_aspsu_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsu_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsu_codigo TO public;
ALTER TABLE as_prontuario_suas_usuario ALTER COLUMN aspsu_codigo SET DEFAULT nextval(('seq_aspsu_codigo'::text)::regclass);  

CREATE TABLE social.asps_primeiro_atendimento (
  aspt_codigo               bigint NOT NULL,
  asps_codigo               bigint,
  aspt_forma_acesso         text,
  aspt_encaminhamento       text,
  aspt_razoes_necessidades  text,
  aspt_bolsa_familia        boolean DEFAULT FALSE,
  aspt_bpc                  boolean DEFAULT FALSE,
  aspt_peti                 boolean DEFAULT FALSE,
  aspt_paefi                boolean DEFAULT FALSE,
  aspt_outros               boolean DEFAULT FALSE,
  aspt_prog_prioritarios    text,
  /* Keys */
  CONSTRAINT asps_primeiro_atendimento_pkey
    PRIMARY KEY (aspt_codigo),
  /* Foreign keys */
  CONSTRAINT fk_asps_codigo
    FOREIGN KEY (asps_codigo)
    REFERENCES social.as_prontuario_suas(asps_codigo)
) WITH (
    OIDS = FALSE
);
ALTER TABLE social.asps_primeiro_atendimento
  OWNER TO postgres;  
CREATE SEQUENCE seq_aspt_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspt_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspt_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspt_codigo TO public;
ALTER TABLE asps_primeiro_atendimento ALTER COLUMN aspt_codigo SET DEFAULT nextval(('seq_aspt_codigo'::text)::regclass);

CREATE TABLE social.asps_obs_cf
(
  aspso_codigo bigint NOT NULL,
  asps_codigo bigint,
  usr_codigo bigint,
  aspso_obs text,
  aspso_data timestamp,
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_obs_cf
  OWNER TO postgres;
CREATE SEQUENCE seq_aspso_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspso_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspso_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspso_codigo TO public;
ALTER TABLE asps_obs_cf ALTER COLUMN aspso_codigo SET DEFAULT nextval(('seq_aspso_codigo'::text)::regclass);  

CREATE TABLE social.asps_espec_sociais_cf
(
  aspses_codigo bigint NOT NULL,
  asps_codigo bigint,
  aspses_fam_situacao_rua boolean DEFAULT FALSE,
  aspses_fam_quilombada boolean DEFAULT FALSE,
  aspses_fam_ribeirinha boolean DEFAULT FALSE,
  aspses_fam_cigana boolean DEFAULT FALSE,
  aspses_fam_indigena_residente boolean DEFAULT FALSE,
  aspses_fam_indigena_retnia text,
  aspses_fam_indigena_nresidente boolean DEFAULT FALSE,
  aspses_fam_indigena_nretnia text,
  aspses_outros boolean DEFAULT FALSE,
  aspses_data timestamp,
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_espec_sociais_cf
  OWNER TO postgres;

CREATE SEQUENCE seq_aspses_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspses_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE asps_espec_sociais_cf TO postgres;
GRANT SELECT, UPDATE ON TABLE asps_espec_sociais_cf TO public;
ALTER TABLE asps_espec_sociais_cf ALTER COLUMN aspses_codigo SET DEFAULT nextval(('seq_aspses_codigo'::text)::regclass);  

CREATE TABLE asps_condicoes_habitacionais
(
  aspsch_codigo bigint NOT NULL DEFAULT nextval(('seq_aspsch_codigo'::text)::regclass),
  asps_codigo bigint,
  aspsch_tipo_residencia text,
  aspsch_material text,
  aspsch_acesso_energia text,
  aspsch_possui_agua boolean DEFAULT true,
  aspsch_forma_abastecimento text,
  aspsch_escoamento_sanit text,
  aspsch_coleta_lixo text,
  aspsch_num_comodos int DEFAULT NULL,
  aspsch_num_comodos_utilizado int DEFAULT NULL,
  aspsch_num_pessoas_comodos int DEFAULT NULL,
  aspsch_acessibilidade text,
  aspsch_domicilio_area_risco boolean DEFAULT false,
  aspsch_domicilio_area_geografica boolean DEFAULT false,
  aspsch_domicilio_area_conflito boolean DEFAULT false,
  aspsch_data timestamp without time zone,
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_condicoes_habitacionais
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsch_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsch_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE asps_condicoes_habitacionais TO postgres;
GRANT SELECT, UPDATE ON TABLE asps_condicoes_habitacionais TO public;
ALTER TABLE asps_condicoes_habitacionais ALTER COLUMN aspsch_codigo SET DEFAULT nextval(('seq_aspsch_codigo'::text)::regclass);

CREATE TABLE social.asps_obs_ch
(
  aspscho_codigo bigint NOT NULL,
  asps_codigo bigint,
  usr_codigo bigint,
  aspscho_obs text,
  aspscho_data timestamp,
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_obs_ch
  OWNER TO postgres;
CREATE SEQUENCE seq_aspscho_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspscho_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspscho_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspscho_codigo TO public;
ALTER TABLE asps_obs_ch ALTER COLUMN aspscho_codigo SET DEFAULT nextval(('seq_aspscho_codigo'::text)::regclass);  

CREATE TABLE social.asps_log
(
  aspsl_codigo bigint NOT NULL,
  asps_codigo bigint,
  usr_codigo bigint,
  aspsl_modulo text NOT NULL,
  aspsl_data timestamp,
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_log
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsl_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsl_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE asps_log TO postgres;
GRANT SELECT, UPDATE ON TABLE asps_log TO public;
ALTER TABLE asps_log ALTER COLUMN aspsl_codigo SET DEFAULT nextval(('seq_aspsl_codigo'::text)::regclass);

CREATE TABLE social.asps_desc_programa_ce
(
  aspsdp_codigo bigint NOT NULL,
  asps_codigo bigint,
  usu_codigo bigint,
  aspsdp_data_ocorrencia timestamp,
  aspsdp_efeito integer,
  aspsdp_suspenso boolean DEFAULT FALSE,
  aspsdp_data timestamp DEFAULT NOW(), 
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
      REFERENCES usuario (usu_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_desc_programa_ce
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsdp_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsdp_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsdp_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsdp_codigo TO public;
ALTER TABLE asps_desc_programa_ce ALTER COLUMN aspsdp_codigo SET DEFAULT nextval(('seq_aspsdp_codigo'::text)::regclass);  

CREATE TABLE social.asps_obs_ce
(
  aspsceo_codigo bigint NOT NULL,
  asps_codigo bigint,
  usr_codigo bigint,
  aspsceo_obs text,
  aspsceo_data timestamp DEFAULT NOW(),
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_obs_ce
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsceo_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsceo_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsceo_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsceo_codigo TO public;
ALTER TABLE asps_obs_ce ALTER COLUMN aspsceo_codigo SET DEFAULT nextval(('seq_aspsceo_codigo'::text)::regclass);  

CREATE TABLE social.asps_registro_simplificado
(
  aspsrs_codigo bigint,
  asps_codigo bigint,
  usr_codigo bigint,
  usu_codigo bigint,
  aspsrs_data_atendimento timestamp DEFAULT NOW(),
  aspsrs_descricao text,
  aspsrs_codigo_desc integer,
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
      REFERENCES usuario (usu_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_registro_simplificado
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsrs_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsrs_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE asps_registro_simplificado TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsrs_codigo TO public;
ALTER TABLE asps_registro_simplificado ALTER COLUMN aspsrs_codigo SET DEFAULT nextval(('seq_aspsrs_codigo'::text)::regclass);

CREATE TABLE social.as_programas_sociais
(
  ps_codigo bigint,
  ps_nome character varying(60),
  ps_dtcadastro date DEFAULT NOW(),
  CONSTRAINT pk_ps_codigo PRIMARY KEY(ps_codigo)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.as_programas_sociais
  OWNER TO postgres;
CREATE SEQUENCE seq_ps_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_ps_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_ps_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_ps_codigo TO public;
ALTER TABLE as_programas_sociais ALTER COLUMN ps_codigo SET DEFAULT nextval(('seq_ps_codigo'::text)::regclass);

INSERT INTO as_programas_sociais (ps_codigo,ps_nome) VALUES ('1','PAIF');
INSERT INTO as_programas_sociais (ps_codigo,ps_nome) VALUES ('2','PAEFI');
INSERT INTO as_programas_sociais (ps_codigo,ps_nome) VALUES ('3','BPC');
INSERT INTO as_programas_sociais (ps_codigo,ps_nome) VALUES ('4','BOLSA FAMLIA');
INSERT INTO as_programas_sociais (ps_codigo,ps_nome) VALUES ('5','PETI');

CREATE TABLE social.asps_anot_programas_ct
(
  aspsap_codigo bigint,
  asps_codigo bigint,
  usu_codigo bigint,
  ps_codigo bigint, 
  aspsap_vlr_recebido numeric(20,2),
  aspsap_dtinicio date,
  aspsap_dtfinal date,
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
      REFERENCES usuario (usu_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_ps_codigo FOREIGN KEY (ps_codigo)
      REFERENCES as_programas_sociais (ps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION 
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_anot_programas_ct
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsap_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsap_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsap_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsap_codigo TO public;
ALTER TABLE asps_anot_programas_ct ALTER COLUMN aspsap_codigo SET DEFAULT nextval(('seq_aspsap_codigo'::text)::regclass);

CREATE TABLE social.asps_obs_ct
(
  aspscto_codigo bigint NOT NULL,
  asps_codigo bigint,
  usr_codigo bigint,
  aspscto_obs text,
  aspscto_data timestamp DEFAULT NOW(),
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_obs_ct
  OWNER TO postgres;
CREATE SEQUENCE seq_aspscto_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspscto_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE asps_obs_ct TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsceo_codigo TO public;
ALTER TABLE asps_obs_ct ALTER COLUMN aspscto_codigo SET DEFAULT nextval(('seq_aspscto_codigo'::text)::regclass);  

CREATE TABLE social.asps_anot_saude_cs
(
  aspsas_codigo bigint,
  asps_codigo bigint,
  aspsas_cuidado_constante boolean,
  aspsas_resp_cuidado_constante character varying,
  aspsas_inseguranca_alimentar boolean,
  aspsas_inseguranca_alimentar_data timestamp,
  aspsas_doenca_grave boolean,
  aspsas_tipo_doenca_grave character varying,
  aspsas_remedio_controlado boolean,
  aspsas_alcoolatra boolean,
  aspsas_alcoolatra_data timestamp,
  aspsas_drogado boolean,
  aspsas_tipo_droga character varying,
  aspsas_drogado_data timestamp,
  aspsas_data timestamp DEFAULT NOW(),
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_anot_saude_cs
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsas_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsas_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsas_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsas_codigo TO public;
ALTER TABLE asps_anot_saude_cs ALTER COLUMN aspsas_codigo SET DEFAULT nextval(('seq_aspsas_codigo'::text)::regclass);

CREATE TABLE social.asps_reg_gestante_cs
(
  aspsrg_codigo bigint NOT NULL,
  asps_codigo bigint,
  usu_codigo bigint,
  aspsrg_meses integer,
  aspsrg_prenatal boolean,
  aspsrg_data timestamp DEFAULT NOW(), 
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
      REFERENCES usuario (usu_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_reg_gestante_cs
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsrg_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsrg_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsrg_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsrg_codigo TO public;
ALTER TABLE asps_reg_gestante_cs ALTER COLUMN aspsrg_codigo SET DEFAULT nextval(('seq_aspsrg_codigo'::text)::regclass);  

CREATE TABLE social.asps_desc_programa_cs
(
  aspsdpcs_codigo bigint NOT NULL,
  asps_codigo bigint,
  usu_codigo bigint,
  aspsdpcs_data_ocorrencia timestamp,
  aspsdpcs_efeito integer,
  aspsdpcs_suspenso boolean DEFAULT FALSE,
  aspsdpcs_data timestamp DEFAULT NOW(), 
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
      REFERENCES usuario (usu_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_desc_programa_cs
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsdpcs_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsdpcs_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsdpcs_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsdpcs_codigo TO public;
ALTER TABLE asps_desc_programa_cs ALTER COLUMN aspsdpcs_codigo SET DEFAULT nextval(('seq_aspsdpcs_codigo'::text)::regclass);  

CREATE TABLE social.asps_obs_cs
(
  aspscso_codigo bigint NOT NULL,
  asps_codigo bigint,
  usr_codigo bigint,
  aspscso_obs text,
  aspscso_data timestamp DEFAULT NOW(),
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_obs_ct
  OWNER TO postgres;
CREATE SEQUENCE seq_aspscso_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspscso_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspscso_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspscso_codigo TO public;
ALTER TABLE asps_obs_cs ALTER COLUMN aspscso_codigo SET DEFAULT nextval(('seq_aspscso_codigo'::text)::regclass);

CREATE TABLE social.asps_convivencia_familiar (
  aspscf_codigo             bigint NOT NULL,
  asps_codigo               bigint,
  aspscf_anos_estado		integer,
  aspscf_res_estado        	boolean,
  aspscf_anos_municipio		integer,
  aspscf_res_municipio    	boolean,
  aspscf_anos_bairro		integer,
  aspscf_res_bairro        	boolean,
  aspscf_ameacada        	boolean,
  aspscf_parente_rede      	boolean,
  aspscf_vizinho_rede      	boolean,
  aspscf_grupo_rede      	boolean,
  aspscf_movimento      	boolean,
  aspscf_crianca_lazer		boolean,
  aspscf_idoso_lazer		boolean,
  aspscf_companhia			boolean,
  aspscf_conflito 			character varying,
  aspscf_rel_conjugal		character varying,
  aspscf_rel_familiar		character varying,
  aspscf_rel_irmaos			character varying,
  /* Keys */
  CONSTRAINT asps_convivencia_familiar_pkey
    PRIMARY KEY (aspscf_codigo),
  /* Foreign keys */
  CONSTRAINT fk_asps_codigo
    FOREIGN KEY (asps_codigo)
    REFERENCES social.as_prontuario_suas(asps_codigo)
) WITH (
    OIDS = FALSE
);
ALTER TABLE social.asps_convivencia_familiar
  OWNER TO postgres;  
CREATE SEQUENCE seq_aspscf_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspscf_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspscf_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspscf_codigo TO public;
ALTER TABLE asps_convivencia_familiar ALTER COLUMN aspscf_codigo SET DEFAULT nextval(('seq_aspscf_codigo'::text)::regclass);

CREATE TABLE social.asps_obs_cc
(
  aspscco_codigo bigint NOT NULL,
  asps_codigo bigint,
  usr_codigo bigint,
  aspscco_obs text,
  aspscco_data timestamp DEFAULT NOW(),
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_obs_cc
  OWNER TO postgres;
CREATE SEQUENCE seq_aspscco_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspscco_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspscco_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspscco_codigo TO public;
ALTER TABLE asps_obs_cc ALTER COLUMN aspscco_codigo SET DEFAULT nextval(('seq_aspscco_codigo'::text)::regclass);

CREATE TABLE as_prontuario_suas_unidade
(
  aspsuni_codigo bigint NOT NULL,
  asps_codigo bigint NOT NULL,
  uni_codigo bigint NOT NULL,
  aspsuni_dtinicio date,
  aspsuni_dtfinal date,
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_uni_codigo FOREIGN KEY (uni_codigo)
      REFERENCES unidade (uni_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE as_prontuario_suas_unidade
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsuni_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsuni_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsuni_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsuni_codigo TO public;
ALTER TABLE as_prontuario_suas_unidade ALTER COLUMN aspsuni_codigo SET DEFAULT nextval(('seq_aspsuni_codigo'::text)::regclass);

ALTER TABLE domicilio ADD COLUMN dom_as_localizacao character varying(60);
ALTER TABLE domicilio ADD COLUMN dom_as_abrigo boolean;
ALTER TABLE domicilio ALTER COLUMN  dom_complemento TYPE character varying;

ALTER TABLE unidade ADD COLUMN uni_as boolean;
ALTER TABLE unidade ADD COLUMN uni_astipo varchar(20);
ALTER TABLE unidade ADD COLUMN uni_asnumero varchar(20);

ALTER TABLE usuario ADD COLUMN usu_as_aposentado boolean;
ALTER TABLE usuario ADD COLUMN usu_as_bpc boolean;
ALTER TABLE usuario ADD COLUMN usu_asdeficiencia boolean;
ALTER TABLE usuario ADD COLUMN usu_asdoc_cnprov character varying(20);
ALTER TABLE usuario ADD COLUMN usu_asdoc_rgprov character varying(20);
ALTER TABLE usuario ADD COLUMN usu_asdoc_ctpsprov character varying(20);
ALTER TABLE usuario ADD COLUMN usu_asdoc_cpfprov character varying(20);
ALTER TABLE usuario ADD COLUMN usu_asdoc_teprov character varying(20);
ALTER TABLE usuario ADD COLUMN usu_as_apelido character varying(60);
ALTER TABLE usuario ADD COLUMN usu_asps_ativo boolean DEFAULT false;
ALTER TABLE usuario ADD COLUMN usu_asps_ref boolean DEFAULT false;
ALTER TABLE usuario ADD COLUMN as_usu_alfabetizado boolean DEFAULT TRUE;
ALTER TABLE usuario ADD COLUMN as_usu_estuda boolean DEFAULT TRUE;
ALTER TABLE usuario ADD COLUMN as_usu_escolaridade integer;
ALTER TABLE usuario ADD COLUMN as_cond_ocupacao integer;
ALTER TABLE usuario ADD COLUMN as_possui_qualificacao boolean DEFAULT FALSE;
ALTER TABLE usuario ADD COLUMN as_possui_qualificacao_qual character varying;
ALTER TABLE usuario ADD COLUMN as_renda_mensal numeric(20,2);
ALTER TABLE usuario ADD COLUMN usu_as_tipo_deficiencia integer;
ALTER TABLE usuario ADD COLUMN usu_as_cuidado_constante boolean;
ALTER TABLE usuario ADD COLUMN usu_as_resp_cuidado character varying;
ALTER TABLE usuario ADD COLUMN usu_as_doenca_grava boolean;
ALTER TABLE usuario ADD COLUMN usu_as_remedio_controlado boolean;
ALTER TABLE usuario ADD COLUMN usu_as_alcoolatra boolean;
ALTER TABLE usuario ADD COLUMN usu_as_drogado boolean;

CREATE TABLE social.as_estabelecimentos
(
  ase_codigo bigint,
  ase_nome character varying(60),
  ase_cep character varying(60),
  ase_logradouro character varying(60),
  ase_num integer,
  ase_complemento character varying(60),
  ase_bairro character varying(60),
  ase_situacao boolean default false,
  ps_dtcadastro date DEFAULT NOW(),
  CONSTRAINT pk_ase_codigo PRIMARY KEY(ase_codigo)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.as_estabelecimentos
  OWNER TO postgres;
CREATE SEQUENCE seq_ase_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_ase_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_ase_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_ase_codigo TO public;
ALTER TABLE as_estabelecimentos ALTER COLUMN ase_codigo SET DEFAULT nextval(('seq_ase_codigo'::text)::regclass);

CREATE TABLE social.as_encaminhamento_codigos
(
  asec_codigo bigint,
  asec_titulo text,
  asec_num integer,
  asec_dtcadastro date DEFAULT NOW(),
  CONSTRAINT pk_asec_codigo_codigo PRIMARY KEY(asec_codigo)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.as_encaminhamento_codigos
  OWNER TO postgres;
CREATE SEQUENCE seq_asec_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asec_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asec_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asec_codigo TO public;
ALTER TABLE as_encaminhamento_codigos ALTER COLUMN asec_codigo SET DEFAULT nextval(('seq_asec_codigo'::text)::regclass);

INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('05','Para Servios de Convivncia e Fortalecimento de Vnculos voltados a crianas e adolescentes'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('06','Para Servios de Convivncia e Fortalecimento de Vnculos voltados para idosos'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('07','Para atualizao cadastral no Cadnico (inclusive quando realizada nesta prpria Unidade)'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('08','Para incluso no Cadnico (inclusive quando realizada nesta prpria Unidade)');
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('09','Para o INSS, visando acesso ao BPC'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('10','Para o INSS, visando acesso a outros direitos, que no o BPC'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('11','Para acesso a Benefcios Eventuais'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('12','Para acesso a Documentao Civil (Certido de Nascimento, RG, Carteira de Trabalho, etc)'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('13','Encaminhamento do CRAS para o CREAS (marcao exclusiva para o CRAS)'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('14','Encaminhamento do CREAS para o CRAS (marcao exclusiva para o CREAS)'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('15','Encaminhamento para outras unidades/servios de Proteo Social Especial'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('30','Para Servios de Sade Bucal (por exemplo: Brasil Sorridente)'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('31','Para Servios de Sade Mental'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('32','Para Servios de Sade voltados ao acesso de rteses e prteses para pessoas com deficincia'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('33','Para Unidades de Sade da Famlia'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('34','Para outros servios ou unidades do Sistema nico de Sade'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('40','Para Educao  Creche e Pr-escola (ensino infantil)');
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('41','Para Educao  Rede regular de ensino (ensino fundamental e ensino mdio)'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('42','Para Educao de Jovens de Adultos (por exemplo: Brasil Alfabetizado)'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('50','Para Servios, Programas ou Projetos voltados  capacitao profissional'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('51','Para Servios, Programas ou Projetos voltados  gerao de trabalho e renda'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('52','Para Servios, Programas ou Projetos voltados  intermediao de mo-de-obra');
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('53','Para acesso a microcrdito');
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('54','Para o Programa BPC-Trabalho');
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('60','Para programa da rea de habitao');
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('61','Para acesso  Tarifa Social de Energia Eltrica'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('70','Para Conselho Tutelar'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('71','Para Poder Judicirio'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('72','Para Ministrio Pblico'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('73','Para Defensoria Pblica'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('74','Para Delegacias (especializadas ou no)');
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('85','Outros encaminhamentos (cdigo livre, a ser utilizado conforme interesse especfico de cada municpio)');
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('86','Outros encaminhamentos (cdigo livre, a ser utilizado conforme interesse especfico de cada municpio)'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('87','Outros encaminhamentos (cdigo livre, a ser utilizado conforme interesse especfico de cada municpio)'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('88','Outros encaminhamentos (cdigo livre, a ser utilizado conforme interesse especfico de cada municpio)'); 
INSERT INTO as_encaminhamento_codigos (asec_num,asec_titulo) VALUES ('89','Outros encaminhamentos (cdigo livre, a ser utilizado conforme interesse especfico de cada municpio)');

CREATE TABLE social.as_atendimento_tipo
(
  asat_codigo bigint NOT NULL,
  asat_codigo_num integer NOT NULL,
  asat_nome character varying,
  asat_situacao boolean default true,
  asat_data timestamp DEFAULT NOW(),
  CONSTRAINT pk_asat_codigo PRIMARY KEY (asat_codigo)

) WITH (
  OIDS=FALSE
);
ALTER TABLE social.as_atendimento_tipo
  OWNER TO postgres;
CREATE SEQUENCE seq_asat_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asat_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asat_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asat_codigo TO public;
ALTER TABLE as_atendimento_tipo ALTER COLUMN asat_codigo SET DEFAULT nextval(('seq_asat_codigo'::text)::regclass);

INSERT INTO as_atendimento_tipo (asat_codigo_num,asat_nome) VALUES ('1','Atendimento socioassistencial individualizado');
INSERT INTO as_atendimento_tipo (asat_codigo_num,asat_nome) VALUES ('2','Atendimento em atividade coletiva de carter continuado'); 
INSERT INTO as_atendimento_tipo (asat_codigo_num,asat_nome) VALUES ('3','Participao em atividade coletiva de carter no continuado'); 
INSERT INTO as_atendimento_tipo (asat_codigo_num,asat_nome) VALUES ('4','Cadastramento/Atualizao Cadastral'); 
INSERT INTO as_atendimento_tipo (asat_codigo_num,asat_nome) VALUES ('5',' Acompanhamento de MSE'); 
INSERT INTO as_atendimento_tipo (asat_codigo_num,asat_nome) VALUES ('6','Solicitao/Concesso de Benefcio Eventual'); 
INSERT INTO as_atendimento_tipo (asat_codigo_num,asat_nome) VALUES ('7','Visita Domiciliar'); 
INSERT INTO as_atendimento_tipo (asat_codigo_num,asat_nome) VALUES ('9','Outros');


CREATE TABLE social.as_atendimento_basicocras
(
  asab_codigo bigint NOT NULL,
  uni_codigo bigint,
  usr_codigo bigint,
  usu_codigo bigint,
  asat_codigo bigint,
  asab_descricao text,
  asab_parecer text,
  asab_parecer_social text,
  asab_data timestamp DEFAULT NOW(),
  CONSTRAINT pk_asab_codigo PRIMARY KEY (asab_codigo),
  CONSTRAINT fk_uni_codigo FOREIGN KEY (uni_codigo)
      REFERENCES unidade (uni_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
	REFERENCES usuario (usu_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_asat_codigo FOREIGN KEY (asat_codigo)
	REFERENCES as_atendimento_tipo (asat_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.as_atendimento_basicocras
  OWNER TO postgres;
CREATE SEQUENCE seq_asab_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asab_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asab_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asab_codigo TO public;
ALTER TABLE as_atendimento_basicocras ALTER COLUMN asab_codigo SET DEFAULT nextval(('seq_asab_codigo'::text)::regclass);

ALTER TABLE usuario ADD COLUMN usu_as_situacao boolean DEFAULT true;

ALTER TABLE grupo_acesso ADD COLUMN grac_num integer;
INSERT INTO grupo_acesso (grac_descricao,grac_num) VALUES ('Curso superior completo','1');

ALTER TABLE beneficios_municipe RENAME TO beneficios_municipe_old;

CREATE TABLE as_beneficios_tipo
(
  asbt_codigo bigint NOT NULL,
  asbt_nome character varying NOT NULL,
  asbt_num integer,
  asbt_situacao boolean default true,
  asbt_dtcadastro timestamp default now(),
  CONSTRAINT pk_asbt_codigo PRIMARY KEY (asbt_codigo)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE as_beneficios_tipo
  OWNER TO postgres;
CREATE SEQUENCE seq_asbt_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asbt_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asbt_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asbt_codigo TO public;
ALTER TABLE as_beneficios_tipo ALTER COLUMN asbt_codigo SET DEFAULT nextval(('seq_asbt_codigo'::text)::regclass);

INSERT INTO as_beneficios_tipo (asbt_num,asbt_nome) VALUES ('1','Auxlio Natalidade'); 
INSERT INTO as_beneficios_tipo (asbt_num,asbt_nome) VALUES ('2','Auxlio Funeral'); 
INSERT INTO as_beneficios_tipo (asbt_num,asbt_nome) VALUES ('3','Item/Kit especfico para enfrentamento de situaes de Emergncia ou Calamidade Pblica'); 
INSERT INTO as_beneficios_tipo (asbt_num,asbt_nome) VALUES ('4','Cesta Bsica'); 
INSERT INTO as_beneficios_tipo (asbt_num,asbt_nome) VALUES ('5','Aluguel social/pagamento de aluguel'); 
INSERT INTO as_beneficios_tipo (asbt_num,asbt_nome) VALUES ('6','Outros');

ALTER TABLE beneficios ADD CONSTRAINT pk_cod_ben PRIMARY KEY (cod_ben);
ALTER TABLE beneficios DROP COLUMN ambito;
ALTER TABLE beneficios DROP COLUMN usuainsert;
ALTER TABLE beneficios DROP COLUMN dtultalter;
ALTER TABLE beneficios DROP COLUMN usuaultalter;
ALTER TABLE beneficios RENAME COLUMN dtinsert TO ben_dtcadastro; 
ALTER TABLE beneficios ADD COLUMN valor numeric(20,2);

CREATE TABLE as_beneficios_cidadao
(
  asbc_codigo bigint,
  asbt_codigo bigint,
  cod_ben bigint,
  uni_codigo bigint,
  ase_codigo bigint,
  usu_codigo bigint,
  usr_codigo bigint,
  asbt_qtd integer,
  asbt_obs text,
  asbt_concedido boolean,
  asbt_dtentrega date,  
  asbt_dtcadastro timestamp default now(),
  CONSTRAINT pk_asbc_codigo PRIMARY KEY (asbc_codigo),
  CONSTRAINT asbt_codigo FOREIGN KEY (asbt_codigo)
      REFERENCES as_beneficios_tipo (asbt_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_cod_ben FOREIGN KEY (cod_ben)
      REFERENCES beneficios (cod_ben) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_uni_codigo FOREIGN KEY (uni_codigo)
      REFERENCES unidade (uni_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION, 	
  CONSTRAINT fk_ase_codigo FOREIGN KEY (ase_codigo)
	  REFERENCES as_estabelecimentos (ase_codigo) MATCH SIMPLE
	  ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
	  REFERENCES usuarios (usr_codigo) MATCH SIMPLE
	  ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
	  REFERENCES usuario (usu_codigo) MATCH SIMPLE
	  ON UPDATE NO ACTION ON DELETE NO ACTION	
)
WITH (
  OIDS=FALSE
);
ALTER TABLE as_beneficios_cidadao
  OWNER TO postgres;
CREATE SEQUENCE seq_asbc_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asbc_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsuni_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asbc_codigo TO public;
ALTER TABLE as_beneficios_cidadao ALTER COLUMN asbc_codigo SET DEFAULT nextval(('seq_asbc_codigo'::text)::regclass);

CREATE TABLE as_situacoes_violacao
(
  assv_codigo bigint NOT NULL,
  assv_nome character varying NOT NULL,
  assv_num integer,
  assv_situacao boolean default true,
  assv_dtcadastro timestamp default now(),
  CONSTRAINT pk_assv_codigo PRIMARY KEY (assv_codigo)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE as_situacoes_violacao
  OWNER TO postgres;
CREATE SEQUENCE seq_assv_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_assv_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_assv_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_assv_codigo TO public;
ALTER TABLE as_situacoes_violacao ALTER COLUMN assv_codigo SET DEFAULT nextval(('seq_assv_codigo'::text)::regclass);

INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Trabalho Infantil','1');
INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Explorao Sexual','2'); 
INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Abuso/Violncia Sexual','3');
INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Violncia Fsica','4'); 
INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Violncia Psicolgica','5'); 
INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Negligncia contra idoso','6');
INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Negligncia contra criana','7');
INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Negligncia contra PCD','8');
INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Trajetria de Rua','9');
INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Trfico de Pessoas','10');
INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Violncia Patrimonial contra Idoso ou PCD','11');
INSERT INTO as_situacoes_violacao (assv_nome,assv_num) VALUES ('Outra','12');

CREATE TABLE as_registros_violacao
(
  asrv_codigo bigint NOT NULL,
  assv_codigo bigint NOT NULL,
  asps_codigo bigint NOT NULL,
  asrv_persiste boolean NOT NULL,
  asrv_dtinicio timestamp NOT NULL,
  asrv_dtfinal timestamp,
  CONSTRAINT pk_asrv_codigo PRIMARY KEY (asrv_codigo),
  CONSTRAINT fk_assv_codigo FOREIGN KEY (assv_codigo)
   REFERENCES as_situacoes_violacao (assv_codigo) MATCH SIMPLE
   ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo) 
	REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE as_registros_violacao
  OWNER TO postgres;
CREATE SEQUENCE seq_asrv_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asrv_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asrv_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asrv_codigo TO public;
ALTER TABLE as_registros_violacao ALTER COLUMN asrv_codigo SET DEFAULT nextval(('seq_asrv_codigo'::text)::regclass);

CREATE TABLE social.asps_obs_sv
(
  aspsvo_codigo bigint NOT NULL,
  asps_codigo bigint,
  usr_codigo bigint,
  aspsvo_obs text,
  aspsvo_data timestamp DEFAULT NOW(),
  CONSTRAINT pk_aspsvo_codigo PRIMARY KEY (aspsvo_codigo),
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_obs_sv
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsvo_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsvo_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsvo_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsvo_codigo TO public;
ALTER TABLE asps_obs_sv ALTER COLUMN aspsvo_codigo SET DEFAULT nextval(('seq_aspsvo_codigo'::text)::regclass);

CREATE TABLE social.asps_hist_acolhimento
(
  aspsha_codigo bigint,
  asps_codigo bigint,
  usu_codigo bigint,
  aspsha_motivo text,
  aspsha_dtinicio date,
  aspsha_dtfinal date,
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
      REFERENCES usuario (usu_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_hist_acolhimento
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsha_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsha_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsha_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsha_codigo TO public;
ALTER TABLE asps_hist_acolhimento ALTER COLUMN aspsha_codigo SET DEFAULT nextval(('seq_aspsha_codigo'::text)::regclass);

CREATE TABLE social.asps_obs_ha
(
  aspshao_codigo bigint NOT NULL,
  asps_codigo bigint,
  usr_codigo bigint,
  aspshao_obs text,
  aspshao_data timestamp DEFAULT NOW(),
  CONSTRAINT pk_aspshao_codigo PRIMARY KEY (aspshao_codigo),
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_obs_ha
  OWNER TO postgres;
CREATE SEQUENCE seq_aspshao_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspshao_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspshao_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspshao_codigo TO public;
ALTER TABLE asps_obs_ha ALTER COLUMN aspshao_codigo SET DEFAULT nextval(('seq_aspshao_codigo'::text)::regclass);  

CREATE TABLE as_encaminhamento
(
  asenc_codigo bigint,
  asec_codigo bigint,
  uni_codigo bigint,
  ase_codigo bigint,
  usu_codigo bigint,
  usr_codigo bigint,
  asenc_motivo text,
  asenc_data timestamp default now(),
  CONSTRAINT pk_asenc_codigo PRIMARY KEY (asenc_codigo),
  CONSTRAINT fk_asec_codigo FOREIGN KEY (asec_codigo)
      REFERENCES as_encaminhamento_codigos (asec_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_uni_codigo FOREIGN KEY (uni_codigo)
      REFERENCES unidade (uni_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION, 	
  CONSTRAINT fk_ase_codigo FOREIGN KEY (ase_codigo)
	  REFERENCES as_estabelecimentos (ase_codigo) MATCH SIMPLE
	  ON UPDATE NO ACTION ON DELETE NO ACTION, 		
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
	  REFERENCES usuario (usu_codigo) MATCH SIMPLE
	  ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
	  REFERENCES usuarios (usr_codigo) MATCH SIMPLE
	  ON UPDATE NO ACTION ON DELETE NO ACTION  
)
WITH (
  OIDS=FALSE
);
ALTER TABLE as_encaminhamento
  OWNER TO postgres;
CREATE SEQUENCE seq_asenc_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asenc_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asenc_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asenc_codigo TO public;
ALTER TABLE as_encaminhamento ALTER COLUMN asenc_codigo SET DEFAULT nextval(('seq_asenc_codigo'::text)::regclass);

CREATE TABLE social.as_atendimentocol_unidades
(
  asau_codigo bigint NOT NULL,
  asau_num integer,
  asau_titulo character varying,
  CONSTRAINT pk_asau_codigo PRIMARY KEY (asau_codigo)
)
WITH (
  OIDS=FALSE
);
CREATE SEQUENCE seq_asau_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asau_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asau_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asau_codigo TO public;
ALTER TABLE as_atendimentocol_unidades ALTER COLUMN asau_codigo SET DEFAULT nextval(('seq_asau_codigo'::text)::regclass);

INSERT INTO as_atendimentocol_unidades (asau_num,asau_titulo) VALUES ('1','Nesta prpria Unidade');
INSERT INTO as_atendimentocol_unidades (asau_num,asau_titulo) VALUES ('2','Em outra Unidade Pblica da rede Socioassistencial'); 
INSERT INTO as_atendimentocol_unidades (asau_num,asau_titulo) VALUES ('3','Em unidade/entidade privada da rede socioassistencial');     
INSERT INTO as_atendimentocol_unidades (asau_num,asau_titulo) VALUES ('4','Em unidade de rede de educao');
INSERT INTO as_atendimentocol_unidades (asau_num,asau_titulo) VALUES ('9','Outra unidade vinculada a outras polticas');

CREATE TABLE social.as_atendimentocol_programas
(
  asap_codigo bigint NOT NULL,
  asap_num integer,
  asap_titulo character varying,
  CONSTRAINT pk_asap_codigo PRIMARY KEY (asap_codigo)
)
WITH (
  OIDS=FALSE
);
CREATE SEQUENCE seq_asap_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asap_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asap_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asap_codigo TO public;
ALTER TABLE as_atendimentocol_programas ALTER COLUMN asap_codigo SET DEFAULT nextval(('seq_asap_codigo'::text)::regclass);

INSERT INTO as_atendimentocol_programas (asap_num,asap_titulo) VALUES ('1','Servio de Convivncia e Fortalecimento de Vnculos para crianas ou adolescentes'); 
INSERT INTO as_atendimentocol_programas (asap_num,asap_titulo) VALUES ('2','Servio de Convivncia e Fortalecimento de Vnculos para Idosos'); 
INSERT INTO as_atendimentocol_programas (asap_num,asap_titulo) VALUES ('3','Grupo especfico desenvolvido pelo PAIF');
INSERT INTO as_atendimentocol_programas (asap_num,asap_titulo) VALUES ('4','Grupo especfico desenvolvido pelo PAEFI');
INSERT INTO as_atendimentocol_programas (asap_num,asap_titulo) VALUES ('5','Programas ou projetos especficos da Assistncia Social que no configurem servios continuados');
INSERT INTO as_atendimentocol_programas (asap_num,asap_titulo) VALUES ('6','Programas ou projetos de outras polticas setoriais (Educao, Esporte,Cultura etc)');
INSERT INTO as_atendimentocol_programas (asap_num,asap_titulo) VALUES ('99','Outros');

CREATE TABLE social.as_atendimentocol_grupo
(
  asag_codigo bigint NOT NULL,
  asau_codigo bigint,
  asap_codigo bigint,
  usr_codigo bigint,
  asag_titulo character varying NOT NULL,
  asag_status boolean DEFAULT TRUE,
  asag_data timestamp DEFAULT NOW(),
  CONSTRAINT pk_asag_codigo PRIMARY KEY (asag_codigo),
  CONSTRAINT fk_asau_codigo FOREIGN KEY (asau_codigo)
	REFERENCES as_atendimentocol_unidades (asau_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_asap_codigo FOREIGN KEY (asap_codigo)
    REFERENCES as_atendimentocol_programas (asap_codigo) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
    REFERENCES usuarios (usr_codigo) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.as_atendimentocol_grupo
  OWNER TO postgres;
CREATE SEQUENCE seq_asag_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asag_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asag_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asag_codigo TO public;
ALTER TABLE as_atendimentocol_grupo ALTER COLUMN asag_codigo SET DEFAULT nextval(('seq_asag_codigo'::text)::regclass);  

CREATE TABLE social.as_atendimentocol_participantes
(
  asapar_codigo bigint NOT NULL,
  asag_codigo bigint,
  usu_codigo bigint,
  asapar_dtingresso date,
  asapar_dtsaida date,
  asapar_status boolean,
  CONSTRAINT pk_asapar_codigo PRIMARY KEY (asapar_codigo),
  CONSTRAINT fk_asag_codigo FOREIGN KEY (asag_codigo)
	REFERENCES as_atendimentocol_grupo (asag_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
    REFERENCES usuario (usu_codigo) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.as_atendimentocol_participantes
  OWNER TO postgres;
CREATE SEQUENCE seq_asapar_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asapar_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asapar_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asapar_codigo TO public;
ALTER TABLE as_atendimentocol_participantes ALTER COLUMN asapar_codigo SET DEFAULT nextval(('seq_asapar_codigo'::text)::regclass);  

CREATE TABLE social.as_atendimentocol_encontros
(
  asae_codigo bigint NOT NULL,
  asag_codigo bigint,
  ase_codigo bigint,
  asae_titulo character varying NOT NULL,
  asae_descricao text,
  asae_descricao_res text,
  asae_dtinicio timestamp,
  asae_dtfinal timestamp,
  asae_status boolean,
  CONSTRAINT pk_asae_codigo PRIMARY KEY (asae_codigo),
  CONSTRAINT fk_asag_codigo FOREIGN KEY (asag_codigo)
	REFERENCES as_atendimentocol_grupo (asag_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_ase_codigo FOREIGN KEY (ase_codigo)
    REFERENCES as_estabelecimentos (ase_codigo) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.as_atendimentocol_encontros
  OWNER TO postgres;
CREATE SEQUENCE seq_asae_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asae_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asae_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asae_codigo TO public;
ALTER TABLE as_atendimentocol_encontros ALTER COLUMN asae_codigo SET DEFAULT nextval(('seq_asae_codigo'::text)::regclass);  

CREATE TABLE social.as_atendimentocol_respencontro
(
  asar_codigo bigint NOT NULL,
  asae_codigo bigint,
  usr_codigo bigint,
  CONSTRAINT pk_asar_codigo PRIMARY KEY (asar_codigo),
  CONSTRAINT fk_asae_codigo FOREIGN KEY (asae_codigo)
	REFERENCES as_atendimentocol_encontros (asae_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
    REFERENCES usuarios (usr_codigo) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.as_atendimentocol_respencontro
  OWNER TO postgres;
CREATE SEQUENCE seq_asar_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asar_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asar_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asar_codigo TO public;
ALTER TABLE as_atendimentocol_respencontro ALTER COLUMN asar_codigo SET DEFAULT nextval(('seq_asar_codigo'::text)::regclass);  


CREATE TABLE social.as_atendimentocol_encontroshist
(
  asaeh_codigo bigint NOT NULL,
  asae_codigo bigint,
  usu_codigo bigint,
  asaeh_presenca boolean,
  asaeh_motivo character varying,
  CONSTRAINT pk_asaeh_codigo PRIMARY KEY (asaeh_codigo),
  CONSTRAINT fk_asae_codigo FOREIGN KEY (asae_codigo)
	REFERENCES as_atendimentocol_encontros (asae_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
    REFERENCES usuario (usu_codigo) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.as_atendimentocol_encontroshist
  OWNER TO postgres;
CREATE SEQUENCE seq_asaeh_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asaeh_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_asaeh_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_asaeh_codigo TO public;
ALTER TABLE as_atendimentocol_encontroshist ALTER COLUMN asaeh_codigo SET DEFAULT nextval(('seq_asaeh_codigo'::text)::regclass);

ALTER TABLE secretaria ADD COLUMN sec_as boolean;
ALTER TABLE secretaria ADD COLUMN sec_bairro character varying;
ALTER TABLE unidade ADD COLUMN uni_asbairro varchar(255);

DELETE FROM acesso_usuarios;
DELETE FROM grupo_acesso_permissoes;
DELETE FROM acesso; 

INSERT INTO acesso (ace_descricao,ace_modulo) VALUES ('Acesso','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo) VALUES ('Permisses',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Acesso')))),'zf/acesso/grupo','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
	   
INSERT INTO acesso (ace_descricao,ace_modulo) VALUES ('Cadastros','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo,ace_imagem) VALUES ('Benefcios',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Cadastros')))),'zf/default/beneficios','13','WebSocialSocial/imgs/beneficios_on.png');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
	
INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo,ace_imagem) VALUES ('Estabelecimentos',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Cadastros')))),'zf/default/estabelecimentos','13','WebSocialSocial/imgs/instituicoes_on.png');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
	
INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo) VALUES ('Unidades',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Cadastros')))),'zf/default/unidade/index','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

INSERT INTO acesso (ace_descricao,ace_modulo) VALUES ('Atendimento','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
	   
INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo) VALUES ('Atendimento Bsico',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Atendimento')))),'zf/atendimentocras/atendimento-basico','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
	   
INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo,ace_imagem) VALUES ('Benefcios Eventuais',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Atendimento')))),'zf/atendimentocras/beneficios-cidadao','13','WebSocialSocial/imgs/beneficioporinteresse_on.png');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo) VALUES ('Encaminhamento',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Atendimento')))),'zf/atendimentocras/encaminhamento','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
	   
INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo) VALUES ('Coletivo(Grupo)',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Atendimento')))),'zf/atendimentocras/atendimento-coletivo','13');  
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

INSERT INTO acesso (ace_descricao,ace_modulo) VALUES ('Pronturios SUAS','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo) VALUES ('Dados Pronturios SUAS',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Pronturios SUAS'))) AND ace_pai IS NULL),'zf/suas/familia/index','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

INSERT INTO acesso (ace_descricao,ace_modulo) VALUES ('Usurios','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo,ace_imagem) VALUES ('Dados Usurios',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Usurios'))) AND ace_pai IS NULL),'zf/usuarios/usuarios','13','WebSocialSocial/imgs/usuarios_on.png');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

INSERT INTO acesso (ace_descricao,ace_modulo) VALUES ('Cidados','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo,ace_imagem) VALUES ('Dados Cidado',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Cidados'))) AND ace_pai IS NULL),'zf/cidadao/cidadao/index','13','WebSocialSocial/imgs/cidadao_on.png');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;