UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.89.88' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.68.56' WHERE conf_chave='VERSAO_COMUM';

ALTER TABLE as_atendimentocol_grupo ADD COLUMN uni_codigo bigint;
ALTER TABLE as_atendimentocol_grupo ADD CONSTRAINT fk_uni_codigo FOREIGN KEY (uni_codigo)
REFERENCES unidade (uni_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

INSERT INTO acesso (ace_descricao,ace_modulo) VALUES ('Relatrios','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

INSERT INTO acesso (ace_descricao,ace_pai,ace_caminho,ace_modulo) VALUES ('Atendimentos Mensal CRAS',(SELECT ace_codigo FROM acesso WHERE TRIM(UPPER(retira_acentos(ace_descricao))) = TRIM(UPPER(retira_acentos('Relatrios'))) AND ace_pai IS NULL),'zf/relatorio/atendimento-mensal-cras/form-rel','13');
INSERT INTO acesso_usuarios  (usr_codigo, ace_codigo)
       SELECT (SELECT usr_codigo FROM usuarios WHERE usr_login='admin') AS usr_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;
INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
       SELECT (SELECT grac_codigo FROM grupo_acesso WHERE TRIM(UPPER(retira_acentos(grac_descricao)))=TRIM(UPPER(retira_acentos('Administrador')))) AS grac_codigo, (SELECT ace_codigo FROM acesso ORDER BY ace_codigo DESC LIMIT 1) as ace_codigo;

CREATE TABLE social.as_tipo_medida_socioeducativa
(
  astms_codigo bigint,
  astms_nome character varying,
  astms_num integer,
  CONSTRAINT pk_astms_codigo PRIMARY KEY (astms_codigo)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.as_tipo_medida_socioeducativa
  OWNER TO postgres;
CREATE SEQUENCE seq_astms_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_astms_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_astms_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_astms_codigo TO public;
ALTER TABLE as_tipo_medida_socioeducativa ALTER COLUMN astms_codigo SET DEFAULT nextval(('seq_astms_codigo'::text)::regclass);

INSERT INTO as_tipo_medida_socioeducativa (astms_nome,astms_num) VALUES ('Liberdade Assistida (LA)','1');
INSERT INTO as_tipo_medida_socioeducativa (astms_nome,astms_num) VALUES ('Prestao de Servios  Comunidade(PSC)','2');
INSERT INTO as_tipo_medida_socioeducativa (astms_nome,astms_num) VALUES ('Advertncia','3');
INSERT INTO as_tipo_medida_socioeducativa (astms_nome,astms_num) VALUES ('Obrigao de Reparar o Dano','4');
INSERT INTO as_tipo_medida_socioeducativa (astms_nome,astms_num) VALUES ('Semi-Liberdade','5');
INSERT INTO as_tipo_medida_socioeducativa (astms_nome,astms_num) VALUES ('Internao','6');
	   
CREATE TABLE social.asps_medidas_socioeducativas
(
  aspsms_codigo bigint,
  asps_codigo bigint,
  usu_codigo bigint,
  astms_codigo bigint,
  aspsms_num_processo integer,
  aspsms_dtinicio date,
  aspsms_dtfinal date,
  aspsms_creas boolean,
  CONSTRAINT pk_aspsms_codigo PRIMARY KEY (aspsms_codigo),
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
      REFERENCES usuario (usu_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_astms_codigo FOREIGN KEY (astms_codigo)
      REFERENCES as_tipo_medida_socioeducativa (astms_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION	
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_medidas_socioeducativas
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsms_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsms_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsms_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsms_codigo TO public;
ALTER TABLE asps_medidas_socioeducativas ALTER COLUMN aspsms_codigo SET DEFAULT nextval(('seq_aspsms_codigo'::text)::regclass);

CREATE TABLE social.asps_obs_ms
(
  aspsmso_codigo bigint NOT NULL,
  asps_codigo bigint,
  usr_codigo bigint,
  aspsmso_obs text,
  aspsmso_data timestamp DEFAULT NOW(),
  CONSTRAINT pk_aspsmso_codigo PRIMARY KEY (aspsmso_codigo),
  CONSTRAINT fk_asps_codigo FOREIGN KEY (asps_codigo)
      REFERENCES as_prontuario_suas (asps_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.asps_obs_ms
  OWNER TO postgres;
CREATE SEQUENCE seq_aspsmso_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_aspsmso_codigo
  OWNER TO postgres;
GRANT ALL ON TABLE seq_aspsmso_codigo TO postgres;
GRANT SELECT, UPDATE ON TABLE seq_aspsmso_codigo TO public;
ALTER TABLE asps_obs_ms ALTER COLUMN aspsmso_codigo SET DEFAULT nextval(('seq_aspsmso_codigo'::text)::regclass);  

INSERT INTO config  (conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool,cac_codigo) values ('BUSCA_TAG_NOME_MAE','Buscar com Tag M* nome da Mae','FALSE','2','TRUE','6');
  