UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.90.89' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.70.58' WHERE conf_chave='VERSAO_COMUM';

CREATE TABLE tb_pergunta
(
  co_seq_pergunta integer NOT NULL,
  ds_local character varying,
  ds_pergunta character varying,
  co_pergunta_pai integer,
  co_contexto_pergunta integer,
  tp_pergunta integer,
  CONSTRAINT tb_pergunta_pkey PRIMARY KEY (co_seq_pergunta)
)
WITH (
  OIDS=FALSE
);


CREATE TABLE tb_pergunta_detalhe
(
  co_pergunta_detalhe integer NOT NULL,
  co_pergunta integer, -- 
  ds_local character varying,
  ds_pergunta_detalhe character varying,
  no_identificador character varying,
  CONSTRAINT tb_pergunta_detalhe_pkey PRIMARY KEY (co_pergunta_detalhe),
  CONSTRAINT tb_pergunta_detalhe_co_pergunta_fkey FOREIGN KEY (co_pergunta)
      REFERENCES tb_pergunta (co_seq_pergunta) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

COMMENT ON COLUMN tb_pergunta_detalhe.co_pergunta IS '
';

CREATE TABLE tb_cds_cad_individual
(
  co_unidade_saude integer,
  dt_cad_individual timestamp without time zone,
  st_envio integer,
  co_envio integer,
  tp_cds_origem integer,
  co_cbo integer,
  co_unico_ficha character varying,
  st_recusa_cad integer,
  st_responsavel_familiar numeric,
  co_seq_cds_cad_individual integer NOT NULL,
  co_cds_prof_cadastrante integer,
  usu_codigo integer,
  CONSTRAINT tb_cds_cad_individual_pkey PRIMARY KEY (co_seq_cds_cad_individual)
)
WITH (
  OIDS=FALSE
);


CREATE TABLE tb_cds_cidadao_resposta
(
  co_seq_cds_cidadao_resposta integer NOT NULL,
  co_pergunta integer,
  co_pergunta_detalhe integer,
  ds_resposta character varying,
  co_cds_cad_individual integer,
  CONSTRAINT tb_cds_cidadao_resposta_pkey PRIMARY KEY (co_seq_cds_cidadao_resposta),
  CONSTRAINT tb_cds_cidadao_resposta_co_pergunta_detalhe_fkey FOREIGN KEY (co_pergunta_detalhe)
      REFERENCES tb_pergunta_detalhe (co_pergunta_detalhe) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT tb_cds_cidadao_resposta_co_pergunta_fkey FOREIGN KEY (co_pergunta)
      REFERENCES tb_pergunta (co_seq_pergunta) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);


  CREATE TABLE tb_contexto_pergunta
(
  co_contexto_pergunta bigint NOT NULL,
  ds_contexto_pergunta character varying,
  CONSTRAINT tb_contexto_pergunta_pkey PRIMARY KEY (co_contexto_pergunta)
)
WITH (
  OIDS=FALSE
);

 



insert into permissoes (perm_descricao,perm_programa,perm_objeto)values('E-SUS:  Cadastro Individual','zf/programasfederais/cadastro-individual','zf/programasfederais/cadastro-individual');


  
-- Lista de Atividades
CREATE TABLE social.tb_cds_tipo_ativ_col
(
  co_cds_tipo_ativ_col bigint NOT NULL,
  no_cds_tipo_ativ_col character(255),
  no_identificador character(255),
  CONSTRAINT co_cds_tipo_ativ_col PRIMARY KEY (co_cds_tipo_ativ_col)
)
WITH (
  OIDS=FALSE
);
  
CREATE SEQUENCE social.seq_co_cds_tipo_ativ_col
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
GRANT SELECT, UPDATE ON TABLE seq_co_cds_tipo_ativ_col TO public;
ALTER TABLE tb_cds_tipo_ativ_col ALTER COLUMN co_cds_tipo_ativ_col SET DEFAULT nextval(('seq_co_cds_tipo_ativ_col'::text)::regclass);

INSERT INTO tb_cds_tipo_ativ_col (co_cds_tipo_ativ_col,no_cds_tipo_ativ_col,no_identificador) VALUES (1,'REUNIO DE EQUIPE','REUNIAO_DE_EQUIPE');
INSERT INTO tb_cds_tipo_ativ_col (co_cds_tipo_ativ_col,no_cds_tipo_ativ_col,no_identificador) VALUES (2,'REUNIO COM OUTRAS EQUIPES DE SADE','REUNIAO_COM_OUTRAS_EQUIPES_DE_SAUDE');
INSERT INTO tb_cds_tipo_ativ_col (co_cds_tipo_ativ_col,no_cds_tipo_ativ_col,no_identificador) VALUES (3,'REUNIO INTERSETORIAL / CONSELHO LOCAL DE SADE / CONTROLE','REUNIAO_INTERSETORIAL_CONSELHO_LOCAL_DE_SAUDE_CONTROLE');
INSERT INTO tb_cds_tipo_ativ_col (co_cds_tipo_ativ_col,no_cds_tipo_ativ_col,no_identificador) VALUES (4,'EDUCACAO EM SADE','EDUCACAO_EM_SAUDE');
INSERT INTO tb_cds_tipo_ativ_col (co_cds_tipo_ativ_col,no_cds_tipo_ativ_col,no_identificador) VALUES (5,'ATENDIMENTO EM GRUPO','ATENDIMENTO_EM_GRUPO');
INSERT INTO tb_cds_tipo_ativ_col (co_cds_tipo_ativ_col,no_cds_tipo_ativ_col,no_identificador) VALUES (6,'AVALIAO / PROCEDIMENTO COLETIVO','AVALIACAO_PROCEDIMENTO_COLETIVO');
INSERT INTO tb_cds_tipo_ativ_col (co_cds_tipo_ativ_col,no_cds_tipo_ativ_col,no_identificador) VALUES (7,'MOBILIZAO SOCIAL','MOBILIZACAO_SOCIAL');

-- Salva dados da ficha e responsvel
CREATE TABLE tb_cds_ficha_ativ_col
(
  co_cds_ficha_ativ_col bigint NOT NULL,
  usr_codigo bigint,
  tp_cds_ativ_col bigint,
  dt_ativ_col timestamp without time zone,
  hr_inicio timestamp without time zone,
  hr_fim timestamp without time zone,
  co_inep_escola integer,
  qt_participante_programado integer,
  ds_local_ativ character(100),
  st_envio integer NOT NULL DEFAULT 0,
  co_envio integer,
  tp_cds_origem integer,
  co_unico_ficha character(96),
  qt_avaliacao_alterada integer,
  qt_participante_ativ integer,
  co_localidade_origem integer,
  st_enfileirado integer NOT NULL DEFAULT 0,
  cod_cnes_unidade character varying(20),
  cod_equipe_ine character varying(20),
  CONSTRAINT co_cds_ficha_ativ_col_pk PRIMARY KEY (co_cds_ficha_ativ_col),
  CONSTRAINT fk_tp_cds_ativ_col FOREIGN KEY (tp_cds_ativ_col)
      REFERENCES tb_cds_tipo_ativ_col (co_cds_tipo_ativ_col) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
  
CREATE SEQUENCE social.seq_co_cds_ficha_ativ_col
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
GRANT SELECT, UPDATE ON TABLE seq_co_cds_ficha_ativ_col TO public;
ALTER TABLE tb_cds_ficha_ativ_col ALTER COLUMN co_cds_ficha_ativ_col SET DEFAULT nextval(('seq_co_cds_ficha_ativ_col'::text)::regclass);

-- Salva profissionais participantes do evento
CREATE TABLE rl_cds_ficha_ativ_col_prof
(
  co_cds_ficha_ativ_col bigint NOT NULL,
  usr_codigo bigint NOT NULL,
  co_rl_cds_ficha_ativ_col_prof bigint NOT NULL,
  cbo character varying(20),
  CONSTRAINT co_rl_cds_ficha_ativ_col_prof_pk PRIMARY KEY (co_rl_cds_ficha_ativ_col_prof),
  CONSTRAINT fk_co_cds_ficha_ativ_col FOREIGN KEY (co_cds_ficha_ativ_col)
      REFERENCES tb_cds_ficha_ativ_col (co_cds_ficha_ativ_col) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo)
      REFERENCES usuarios (usr_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

CREATE SEQUENCE seq_co_rl_cds_ficha_ativ_col_prof
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;


-- Salva participantes do evento
CREATE TABLE tb_cds_ativ_col_participante
(
  co_cds_ativ_col_participnt bigint NOT NULL,
  co_cds_ficha_ativ_col bigint,
  usu_codigo bigint,
  dt_nascimento timestamp without time zone,
  st_avaliacao_alterada numeric(1,0),
  st_cessou_habito_fumar numeric(1,0),
  st_abandonou_grupo numeric(1,0),
  nu_peso integer DEFAULT 0,
  nu_altura integer DEFAULT 0,
  CONSTRAINT co_cds_ativ_col_participnt PRIMARY KEY (co_cds_ativ_col_participnt),
  CONSTRAINT fk_co_cds_ficha_ativ_col FOREIGN KEY (co_cds_ficha_ativ_col)
      REFERENCES tb_cds_ficha_ativ_col (co_cds_ficha_ativ_col) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
      REFERENCES usuario (usu_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
  
CREATE SEQUENCE social.seq_co_cds_ativ_col_participnt
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
GRANT SELECT, UPDATE ON TABLE seq_co_cds_ativ_col_participnt TO public;
ALTER TABLE tb_cds_ativ_col_participante ALTER COLUMN co_cds_ativ_col_participnt SET DEFAULT nextval(('seq_co_cds_ativ_col_participnt'::text)::regclass);

-- Tema para reunio
CREATE TABLE tb_cds_ativ_col_tema
(
  co_cds_ativ_col_tema bigint NOT NULL,
  no_cds_ativ_col_tema character(255),
  no_identificador character(255),
  CONSTRAINT co_cds_ativ_col_tema PRIMARY KEY (co_cds_ativ_col_tema)
)
WITH (
  OIDS=FALSE
);

CREATE SEQUENCE social.seq_co_cds_ativ_col_tema
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE tb_cds_ativ_col_tema ALTER COLUMN co_cds_ativ_col_tema SET DEFAULT nextval(('seq_co_cds_ativ_col_tema'::text)::regclass);

INSERT INTO tb_cds_ativ_col_tema (co_cds_ativ_col_tema,no_cds_ativ_col_tema,no_identificador) VALUES (1,'QUESTES ADMINISTRATIVAS / FUNCIONAMENTO','QUESTOES_ADMINISTRATIVAS_FUNCIONAMENTO');
INSERT INTO tb_cds_ativ_col_tema (co_cds_ativ_col_tema,no_cds_ativ_col_tema,no_identificador) VALUES (2,'PROCESSOS DE TRABALHO','PROCESSOS_DE_TRABALHO');
INSERT INTO tb_cds_ativ_col_tema (co_cds_ativ_col_tema,no_cds_ativ_col_tema,no_identificador) VALUES (3,'DIAGNSTICO DO TERRITRIO / MONITORAMENTO DO TERRITRIO','DIAGNOSTICO_DO_TERRITORIO_MONITORAMENTO_DO_TERRITORIO');
INSERT INTO tb_cds_ativ_col_tema (co_cds_ativ_col_tema,no_cds_ativ_col_tema,no_identificador) VALUES (4,'PLANEJAMENTO / MONITORAMENTO DAS AES DA EQUIPE','PLANEJAMENTO_MONITORAMENTO_DAS_ACOES_DA_EQUIPE');
INSERT INTO tb_cds_ativ_col_tema (co_cds_ativ_col_tema,no_cds_ativ_col_tema,no_identificador) VALUES (5,'DISCUSSO DE CASO / PROJETO TERAPUTICO SINGULAR','DISCUSSAO_DE_CASO_PROJETO_TERAPEUTICO_SINGULAR');
INSERT INTO tb_cds_ativ_col_tema (co_cds_ativ_col_tema,no_cds_ativ_col_tema,no_identificador) VALUES (6,'EDUCAO PERMANENTE','EDUCACAO_PERMANENTE');
INSERT INTO tb_cds_ativ_col_tema (co_cds_ativ_col_tema,no_cds_ativ_col_tema,no_identificador) VALUES (7,'OUTROS','OUTROS');
  
-- Relao tem para reunio, Ficha Coletiva
CREATE TABLE rl_cds_ficha_ativ_col_tema
(
  co_cds_ficha_ativ_col bigint NOT NULL,
  co_cds_ativ_col_tema bigint NOT NULL,
  co_rl_cds_ficha_ativ_col_tema bigint,
  CONSTRAINT fk_co_cds_ativ_col_tema FOREIGN KEY (co_cds_ativ_col_tema)
      REFERENCES tb_cds_ativ_col_tema (co_cds_ativ_col_tema) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_co_cds_ficha_ativ_col FOREIGN KEY (co_cds_ficha_ativ_col)
      REFERENCES tb_cds_ficha_ativ_col (co_cds_ficha_ativ_col) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

CREATE SEQUENCE seq_co_rl_cds_ficha_ativ_col_tema
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;


-- Pblico Alvo;
CREATE TABLE tb_cds_ativ_col_publico_alvo
(
  co_cds_ativ_col_publico_alvo bigint NOT NULL,
  no_cds_ativ_col_publico_alvo character(255),
  no_identificador character(255),
  CONSTRAINT co_cds_ativ_col_publico_alvo PRIMARY KEY (co_cds_ativ_col_publico_alvo)
)
WITH (
  OIDS=FALSE
);

CREATE SEQUENCE social.seq_co_cds_ativ_col_publico_alvo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE tb_cds_ativ_col_publico_alvo ALTER COLUMN co_cds_ativ_col_publico_alvo SET DEFAULT nextval(('seq_co_cds_ativ_col_publico_alvo'::text)::regclass);

INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (1,'COMUNIDADE EM GERAL','COMUNIDADE_EM_GERAL');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (2,'CRIANA 0 A 3 ANOS','CRIANCA_0_A_3_ANOS');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (3,'CRIANA 4 A 5 ANOS','CRIANCA_4_A_5_ANOS');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (4,'CRIANA 6 A 11 ANOS','CRIANCA_6_A_11_ANOS');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (5,'ADOLESCENTE','ADOLESCENTE');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (6,'MULHER','MULHER');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (7,'GESTANTE','GESTANTE');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (8,'HOMEM','HOMEM');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (9,'FAMLIA','FAMILIARES');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (10,'IDOSO','IDOSO');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (11,'MES E PAIS','MAES_E_PAIS');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (12,'PESSOAS COM DOENAS CRNICAS','PESSOAS_COM_DOENCAS_CRONICAS');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (13,'USURIO DE TABACO','USUARIO_DE_TABACO');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (14,'USURIO DE LCOOL','USUARIO_DE_ALCOOL');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (15,'USURIO DE OUTRAS DROGAS','USUARIO_DE_OUTRAS_DROGAS');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (16,'PORTADOR DE SOFRIMENTO MENTAL / SADE MENTAL','PESSOA_DE_SOFRIMENTO_MENTAL_SAUDE_MENTAL');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (17,'PROFISSIONAL DE EDUCAO','PROFISSIONAL_DE_EDUCACAO');
INSERT INTO tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo,no_cds_ativ_col_publico_alvo,no_identificador) VALUES (18,'Outros','OUTROS');

-- Relao Pblico Alvo, Ficha Coletiva
CREATE TABLE rl_cds_ficha_ativ_col_pub_alvo
(
  co_cds_ficha_ativ_col bigint NOT NULL,
  co_cds_ativ_col_publico_alvo bigint NOT NULL,
  co_rl_cds_ficha_ativ_col_pub_alvo bigint NOT NULL,
  CONSTRAINT co_rl_cds_ficha_ativ_col_pub_alvo_pk PRIMARY KEY (co_rl_cds_ficha_ativ_col_pub_alvo),
  CONSTRAINT fk_co_cds_ativ_col_publico_alvo FOREIGN KEY (co_cds_ativ_col_publico_alvo)
      REFERENCES tb_cds_ativ_col_publico_alvo (co_cds_ativ_col_publico_alvo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_co_cds_ficha_ativ_col FOREIGN KEY (co_cds_ficha_ativ_col)
      REFERENCES tb_cds_ficha_ativ_col (co_cds_ficha_ativ_col) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

CREATE SEQUENCE seq_co_rl_cds_ficha_ativ_col_pub_alvo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;


-- Prticas / Temas para Sade
CREATE TABLE social.tb_cds_ativ_col_pratica
(
  co_cds_ativ_col_pratica bigint NOT NULL,
  no_cds_ativ_col_pratica character(255),
  no_identificador character(255),
  CONSTRAINT co_cds_ativ_col_pratica PRIMARY KEY (co_cds_ativ_col_pratica)
)
WITH (
  OIDS=FALSE
);

CREATE SEQUENCE social.seq_co_cds_ativ_col_pratica
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE tb_cds_ativ_col_pratica ALTER COLUMN co_cds_ativ_col_pratica SET DEFAULT nextval(('seq_co_cds_ativ_col_pratica'::text)::regclass);

INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (1,'ALIMENTAO SAUDVEL','ALIMENTACAO_SAUDAVEL');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (2,'APLICAO TPICA DE FLOR','APLICACAO_TOPICA_DE_FLUOR');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (3,'SADE OCULAR','SAUDE_OCULAR');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (4,'AUTOCUIDADO DE PESSOAS COM DOENAS CRNICAS','AUTOCUIDADO_DE_PESSOAS_COM_DOENCAS_CRONICAS');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (5,'CIDADANIA E DIREITOS HUMANOS','CIDADANIA_E_DIREITOS_HUMANOS');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (6,'SADE DO TRABALHADOR','SAUDE_DO_TRABALHADOR');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (7,'DEPENDNCIA QUMICA (TABACO, LCOOL E OUTRAS DROGAS)','DEPENDENCIA_QUIMICA_TABACO_ALCOOL_E_OUTRAS_DROGAS');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (8,'ENVELHECIMENTO (CLIMATRIO, ANDROPAUSA, ETC.)','ENVELHECIMENTO_CLIMATERIO_ANDROPAUSA_ETC');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (9,'ESCOVAO DENTAL SUPERVISIONADA','ESCOVACAO_DENTAL_SUPERVISIONADA');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (10,'PLANTAS MEDICINAIS / FITOTERAPIA','PLANTAS_MEDICINAIS_FITOTERAPIA');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (11,'PRTICAS CORPORAIS / ATIVIDADE FSICA','PRATICAS_CORPORAIS_ATIVIDADE_FISICA');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (12,'PRTICAS CORPORAIS E MENTAIS EM PIC','PRATICAS_CORPORAIS_E_MENTAIS_EM_PIC');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (13,'PREVENO DA VIOLNCIA E PROMOO DA CULTURA DA PAZ','PREVENCAO_DA_VIOLENCIA_E_PROMOCAO_DA_CULTURA_DA_PAZ');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (14,'SADE AMBIENTAL','SAUDE_AMBIENTAL');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (15,'SADE BUCAL','SAUDE_BUCAL');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (16,'SADE MENTAL','SAUDE_MENTAL');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (17,'SADE SEXUAL E REPRODUTIVA','SAUDE_SEXUAL_E_REPRODUTIVA');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (18,'SEMANA SADE NA ESCOLA','SEMANA_SAUDE_NA_ESCOLA');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (19,'AGRAVOS NEGLIGENCIADOS	','AGRAVOS_NEGLIGENCIADOS');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (20,'ANTROPOMETRIA','ANTROPOMETRIA');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (21,'OUTROS','OUTROS');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (22,'SADE ADITIVA','SAUDE_ADITIVA');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (23,'DESENVOLVIMENTO DA LINGUAGEM','DESENVOLVIMENTO_DA_LINGUAGEM');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (24,'VERIFICAO DA SITUAO VACINAL','VERIFICACAO_DA_SITUACAO_VACINAL');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (25,'PROGRAMA NACIONAL DE CONTROLE DO TABAGISMO SESSO 1','PROGRAMA_NACIONAL_CONTROLE_TABAGISMO_1');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (26,'PROGRAMA NACIONAL DE CONTROLE DO TABAGISMO SESSO 2','PROGRAMA_NACIONAL_CONTROLE_TABAGISMO_2');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (27,'PROGRAMA NACIONAL DE CONTROLE DO TABAGISMO SESSO 3','PROGRAMA_NACIONAL_CONTROLE_TABAGISMO_3');
INSERT INTO tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica,no_cds_ativ_col_pratica,no_identificador) VALUES (28,'PROGRAMA NACIONAL DE CONTROLE DO TABAGISMO SESSO 4','PROGRAMA_NACIONAL_CONTROLE_TABAGISMO_4');

-- Relao Prticas/Temas para sade, Ficha
CREATE TABLE rl_cds_ficha_ativ_col_pratica
(
  co_cds_ficha_ativ_col bigint NOT NULL,
  co_cds_ativ_col_pratica bigint NOT NULL,
  co_rl_cds_ficha_ativ_col_pratica bigint NOT NULL,
  CONSTRAINT co_rl_cds_ficha_ativ_col_pratica_pk PRIMARY KEY (co_rl_cds_ficha_ativ_col_pratica),
  CONSTRAINT fk_co_cds_ativ_col_pratica FOREIGN KEY (co_cds_ativ_col_pratica)
      REFERENCES tb_cds_ativ_col_pratica (co_cds_ativ_col_pratica) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_co_cds_ficha_ativ_col FOREIGN KEY (co_cds_ficha_ativ_col)
      REFERENCES tb_cds_ficha_ativ_col (co_cds_ficha_ativ_col) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

CREATE SEQUENCE seq_co_rl_cds_ficha_ativ_col_pratica
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;


insert into permissoes (perm_descricao,perm_programa,perm_objeto) values('E - SUS: PSF','zf/domicilio/psf','zf/domicilio/psf');

CREATE TABLE social.tb_cds_domicilio_resposta
(
   co_seq_cds_domicilio_resposta bigint, 
   co_cds_cad_domiciliar integer, 
   co_pergunta integer, 
   co_pergunta_detalhe integer, 
   ds_resposta character varying, 
   co_resposta integer, 
   PRIMARY KEY (co_seq_cds_domicilio_resposta), 
   FOREIGN KEY (co_pergunta) REFERENCES tb_pergunta (co_seq_pergunta) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   FOREIGN KEY (co_pergunta_detalhe) REFERENCES tb_pergunta_detalhe (co_pergunta_detalhe) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;

ALTER TABLE tb_cds_domicilio_resposta
  DROP COLUMN co_seq_cds_domicilio_resposta;
ALTER TABLE tb_cds_domicilio_resposta
  ADD COLUMN co_seq_cds_domicilio_resposta bigserial;
  
  ALTER TABLE psicotropicos
  ADD COLUMN psico_exige_codigo boolean;


  
  CREATE TABLE social.tb_cds_visita_dom_motivo
(
   co_cds_visita_dom_motivo bigint, 
   no_cds_visita_dom_motivo character varying, 
   no_identificador character varying, 
   PRIMARY KEY (co_cds_visita_dom_motivo)
) 
WITH (
  OIDS = FALSE
)
;
CREATE TABLE social.tb_cds_visita_dom_desfecho
(
   co_cds_visita_dom_desfecho bigint, 
   no_cds_visita_dom_desfecho character varying, 
   no_identificador character varying, 
   PRIMARY KEY (co_cds_visita_dom_desfecho)
) 
WITH (
  OIDS = FALSE
)
;

CREATE TABLE social.rl_cds_visita_dom_motivo
(
   co_cds_visita_domiciliar_rl bigserial, 
   co_cds_visita_domiciliar bigint, 
   co_cds_visita_dom_motivo bigint, 
   PRIMARY KEY (co_cds_visita_domiciliar_rl), 
   FOREIGN KEY (co_cds_visita_dom_motivo) REFERENCES tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;

CREATE TABLE tb_cds_visita_domiciliar
(
  co_seq_cds_visita_domiciliar bigserial NOT NULL,
  usu_codigo bigint,
  st_acompanhada_outro_prof boolean,
  co_cds_visita_dom_desfecho bigint,
  CONSTRAINT tb_cds_visita_domiciliar_pkey PRIMARY KEY (co_seq_cds_visita_domiciliar),
  CONSTRAINT tb_cds_visita_domiciliar_co_cds_visita_dom_desfecho_fkey FOREIGN KEY (co_cds_visita_dom_desfecho)
      REFERENCES tb_cds_visita_dom_desfecho (co_cds_visita_dom_desfecho) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

ALTER TABLE tb_cds_visita_domiciliar
  DROP COLUMN usu_codigo;
ALTER TABLE tb_cds_visita_domiciliar
  ADD COLUMN ate_codigo bigint;

  ALTER TABLE psicotropicos
  ADD COLUMN psico_exige_codigo boolean;

ALTER TABLE atendimento ADD COLUMN ate_tipo character varying;
ALTER TABLE requisicao_exames ADD COLUMN proc_solicitado character varying(1);
ALTER TABLE requisicao_exames ADD COLUMN proc_avaliado character varying(1);

-- Tipo atendimento
CREATE TABLE social.TB_CDS_TIPO_ATEND (
    CO_CDS_TIPO_ATEND bigint NOT NULL,
    NO_CDS_TIPO_ATEND VARCHAR(255) NOT NULL,
    NO_IDENTIFICADOR VARCHAR(255) NOT NULL,
	CONSTRAINT CO_CDS_TIPO_ATEND_pkey PRIMARY KEY(CO_CDS_TIPO_ATEND)
);

CREATE SEQUENCE social.seq_CO_CDS_TIPO_ATEND
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE TB_CDS_TIPO_ATEND ALTER COLUMN CO_CDS_TIPO_ATEND SET DEFAULT nextval(('seq_co_cds_tipo_atend'::text)::regclass);


-- Tipo de consulta
CREATE TABLE social.tipo_consulta (
    tp_cod bigint NOT NULL,
    tp_nome VARCHAR(255) NOT NULL,
    tp_identificador VARCHAR(255) NOT NULL,
	CONSTRAINT tp_cod PRIMARY KEY(tp_cod)
);

CREATE SEQUENCE social.seq_tp_cod
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE tipo_consulta ALTER COLUMN tp_cod SET DEFAULT nextval(('seq_tp_cod'::text)::regclass);

INSERT INTO tipo_consulta (tp_cod,tp_nome,tp_identificador) VALUES ('1','PRIMEIRA CONSULTA ODONTOLGICA PROGRAMADA',	'PRIMEIRA_CONSULTA_ODONTOLOGICA_PROGRAMATICA');
INSERT INTO tipo_consulta (tp_cod,tp_nome,tp_identificador) VALUES ('2','CONSULTA DE RETORNO EM ODONTOLOGIA',	'CONSULTA_DE_RETORNO_EM_ODONTOLOGIA');
INSERT INTO tipo_consulta (tp_cod,tp_nome,tp_identificador) VALUES ('3','CONSULTA DE CONCLUSO DE TRATAMENTO','CONSULTA_DE_CONCLUSAO_DO_TRATAMENTO');
INSERT INTO tipo_consulta (tp_cod,tp_nome,tp_identificador) VALUES ('4','CONSULTA DE MANUTENO EM ODONTOLOGIA',	'CONSULTA_DE_MANUTENCAO_EM_ODONTOLOGIA');
INSERT INTO tipo_consulta (tp_cod,tp_nome,tp_identificador) VALUES ('99','NO SE APLICA (NA)','NAO_SE_APLICA');

ALTER TABLE agendamento ADD COLUMN tp_cod bigint;
ALTER TABLE agendamento ADD CONSTRAINT tp_cod_fkey FOREIGN KEY(tp_cod)
REFERENCES tipo_consulta(tp_cod) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

CREATE TABLE social.TB_CDS_TIPO_VIG_SAUDE_BUCAL (
    CO_CDS_TIPO_VIG_SAUDE_BUCAL bigint NOT NULL,
    NO_CDS_TIPO_VIG_SAUDE_BUCAL VARCHAR(255) NOT NULL,
    NO_IDENTIFICADOR VARCHAR(255) NOT NULL,
	CONSTRAINT CO_CDS_TIPO_VIG_SAUDE_BUCAL_pkey PRIMARY KEY(CO_CDS_TIPO_VIG_SAUDE_BUCAL)
);

CREATE SEQUENCE social.seq_CO_CDS_TIPO_VIG_SAUDE_BUCAL
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE TB_CDS_TIPO_VIG_SAUDE_BUCAL ALTER COLUMN CO_CDS_TIPO_VIG_SAUDE_BUCAL SET DEFAULT nextval(('seq_co_cds_tipo_vig_saude_bucal'::text)::regclass);

INSERT INTO TB_CDS_TIPO_VIG_SAUDE_BUCAL (CO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_IDENTIFICADOR) VALUES ('1','ABCESSO DENTO ALVEOLAR','ABSCESSO_DENTO_ALVEOLAR');
INSERT INTO TB_CDS_TIPO_VIG_SAUDE_BUCAL (CO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_IDENTIFICADOR) VALUES ('2','ALTERAO EM TECIDOS MOLES','ALTERACAO_EM_TECIDOS_MOLES');
INSERT INTO TB_CDS_TIPO_VIG_SAUDE_BUCAL (CO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_IDENTIFICADOR) VALUES ('3','DOR DE DENTE','DOR_DE_DENTE');
INSERT INTO TB_CDS_TIPO_VIG_SAUDE_BUCAL (CO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_IDENTIFICADOR) VALUES ('4','FENDAS OU FISSURAS LBIO PALATAIS','FENDAS_OU_FISSURAS_LABIO_PALATAIS');
INSERT INTO TB_CDS_TIPO_VIG_SAUDE_BUCAL (CO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_IDENTIFICADOR) VALUES ('5','FLUOROSE DENTRIA MODERADA OU SEVERA','FLUOROSE_DENTARIA_MODERADA_OU_SEVERA');
INSERT INTO TB_CDS_TIPO_VIG_SAUDE_BUCAL (CO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_IDENTIFICADOR) VALUES ('6','TRAUMATISMO DENTO ALVEOLAR','TRAUMATISMO_DENTO_ALVEOLAR');
INSERT INTO TB_CDS_TIPO_VIG_SAUDE_BUCAL (CO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_CDS_TIPO_VIG_SAUDE_BUCAL,NO_IDENTIFICADOR) VALUES ('99','NO IDENTIFICADO','NAO_IDENTIFICADO');

CREATE TABLE social.rl_cds_atend_odont_tip_vig_buc (
    co_rl_cds_atend_odont_tip_vig_buc bigint NOT NULL,
	ate_codigo bigint NOT NULL,
    tp_cds_vig_saude_bucal bigint NOT NULL,
	CONSTRAINT co_rl_cds_atend_odont_tip_vig_buc_pkey PRIMARY KEY(co_rl_cds_atend_odont_tip_vig_buc),
	CONSTRAINT ate_codigo_fkey FOREIGN KEY(ate_codigo)
	REFERENCES atendimento(ate_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT tp_cds_vig_saude_bucal_fkey FOREIGN KEY(tp_cds_vig_saude_bucal)
	REFERENCES  tb_cds_tipo_vig_saude_bucal(co_cds_tipo_vig_saude_bucal) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION
);

CREATE SEQUENCE social.seq_co_rl_cds_atend_odont_tip_vig_buc
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE rl_cds_atend_odont_tip_vig_buc ALTER COLUMN co_rl_cds_atend_odont_tip_vig_buc SET DEFAULT nextval(('seq_co_rl_cds_atend_odont_tip_vig_buc'::text)::regclass);

CREATE TABLE social.TB_CDS_TIPO_CONDUTA (
    CO_CDS_TIPO_CONDUTA bigint NOT NULL,
    NO_CDS_TIPO_CONDUTA VARCHAR(255) NOT NULL,
    NO_IDENTIFICADOR VARCHAR(255) NOT NULL,
	CONSTRAINT CO_CDS_TIPO_CONDUTA_pkey PRIMARY KEY(CO_CDS_TIPO_CONDUTA) 
);

CREATE SEQUENCE social.seq_CO_CDS_TIPO_CONDUTA
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE TB_CDS_TIPO_CONDUTA ALTER COLUMN CO_CDS_TIPO_CONDUTA SET DEFAULT nextval(('seq_co_cds_tipo_conduta'::text)::regclass);

INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('1','RETORNO PARA CONSULTA AGENDADA','RETORNO_PARA_CONSULTA_AGENDADA');
INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('2','RETORNO P/ CUIDADO CONTINUADO/PROGRAMADO','RETORNO_PARA_CUIDADO_CONTINUADO_PROGRAMADO');
INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('3','AGENDAMENTO P/ NASF','AGENDAMENTO_PARA_NASF');
INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('4','ENCAMINHAMENTO P/ SERVIO ESPECIALIZADO','ENCAMINHAMENTO_PARA_SERVICO_ESPECIALIZADO');
INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('5','ENCAMINHAMENTO P/ CAPS','ENCAMINHAMENTO_PARA_CAPS');
INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('6','ENCAMINHAMENTO P/ INTERNAO HOSPITALAR','ENCAMINHAMENTO_PARA_INTERNACAO_HOSPITALAR');
INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('7','ENCAMINHAMENTO P/ URGNCIA',	'ENCAMINHAMENTO_PARA_URGENCIA');
INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('8','ENCAMINHAMENTO P/ SERVIO DE ATENO DOMICILIAR','ENCAMINHAMENTO_PARA_SERVICAO_ATENCAO_DOMICILIAR');
INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('9','ALTA DO EPISDIO','ALTA_DO_EPISODIO');
INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('10','ENCAMINHAMENTO INTERSETORIAL','ENCAMINHAMENTO_INTERSETORIAL');
INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('11','ENCAMINHAMENTO INTERNO NO DIA','ENCAMINHAMENTO_INTERNO_DO_DIA');
INSERT INTO TB_CDS_TIPO_CONDUTA (CO_CDS_TIPO_CONDUTA,NO_CDS_TIPO_CONDUTA, NO_IDENTIFICADOR) VALUES ('12','AGENDAMENTO PARA GRUPOS','AGENDAMENTO_PARA_GRUPOS');

INSERT INTO social.categoria_configuracao(cac_codigo,cac_descricao) VALUES ('13','SI-PNI');

UPDATE agendamento SET tat_codigo = null;

DELETE FROM tipo_atendimento;

ALTER TABLE tipo_atendimento
   ALTER COLUMN tat_chave TYPE character varying;
   ALTER TABLE tipo_atendimento
   ALTER COLUMN tat_tipo TYPE character varying;
   
INSERT INTO tipo_atendimento (tat_codigo,tat_tipo,tat_chave) VALUES ('1','CONSULTA AGENDADA PROGRAMADA / CUIDADO CONTINUADO','CONSULTA_AGENDADA_PROGRAMADA_CUIDADO_CONTINUADO');
INSERT INTO tipo_atendimento (tat_codigo,tat_tipo,tat_chave) VALUES ('2','CONSULTA AGENDADA','CONSULTA_AGENDADA');
INSERT INTO tipo_atendimento (tat_codigo,tat_tipo,tat_chave) VALUES ('3','DEMANDA ESPONTNEA','DEMANDA_ESPONTANEA');
INSERT INTO tipo_atendimento (tat_codigo,tat_tipo,tat_chave) VALUES ('4','ESCUTA INICIAL / ORIENTAO','ESCUTA_INICIAL_ORIENTACAO');
INSERT INTO tipo_atendimento (tat_codigo,tat_tipo,tat_chave) VALUES ('5','CONSULTA NO DIA','CONSULTA_NO_DIA');
INSERT INTO tipo_atendimento (tat_codigo,tat_tipo,tat_chave) VALUES ('6','ATENDIMENTO DE URGNCIA','ATENDIMENTO_DE_URGENCIA');

insert into config (conf_chave,conf_label,conf_tipo,cac_codigo,conf_readonly,conf_valor_bool,conf_valor_string) values ('SIGLA_SISTEMA','Siga do Sistema','1','13','TRUE','FALSE','WSS');
insert into config (conf_chave,conf_label,conf_tipo,cac_codigo,conf_readonly,conf_valor_bool,conf_valor_string) values ('NOME_DO_SISTEMA','Nome do Sistema','1','13','TRUE','FALSE','WebSocialSaude');
insert into config (conf_chave,conf_label,conf_tipo,cac_codigo,conf_readonly,conf_valor_bool,conf_valor_string) values ('CODIGO_DO_SISTEMA','Codigo do Sistema','1','13','FALSE','FALSE','1234');
insert into config (conf_chave,conf_label,conf_tipo,cac_codigo,conf_readonly,conf_valor_bool,conf_valor_string) values ('SENHA_DO_ARQUIVO','Senha do Arquivo','1','13','FALSE','FALSE','0112');

CREATE TABLE social.tb_cds_tipo_encam_odonto (
    CO_CDS_TIPO_ENCAM_ODONTO bigint NOT NULL,
    NO_CDS_TIPO_ENCAM_ODONTO VARCHAR(255) NOT NULL,
    NO_IDENTIFICADOR VARCHAR(255) NOT NULL,
	CONSTRAINT CO_CDS_TIPO_ENCAM_ODONTO_PKEY PRIMARY KEY(CO_CDS_TIPO_ENCAM_ODONTO) 
);

CREATE SEQUENCE social.seq_CO_CDS_TIPO_ENCAM_ODONTO
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE tb_cds_tipo_encam_odonto ALTER COLUMN CO_CDS_TIPO_ENCAM_ODONTO SET DEFAULT nextval(('seq_co_cds_tipo_encam_odonto'::text)::regclass);

CREATE TABLE social.rl_cds_atend_odonto_tipo_encam (
    co_rl_cds_atend_odonto_tipo_encam bigint NOT NULL,
	ate_codigo bigint NOT NULL,
    tp_cds_encam_odonto bigint NOT NULL,
	CONSTRAINT co_rl_cds_atend_odonto_tipo_encam_pkey PRIMARY KEY(co_rl_cds_atend_odonto_tipo_encam),
	CONSTRAINT ate_codigo_fkey FOREIGN KEY(ate_codigo)
	REFERENCES atendimento(ate_codigo) MATCH SIMPLE 
	ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT tp_cds_encam_odonto_fkey FOREIGN KEY(tp_cds_encam_odonto)
	REFERENCES tb_cds_tipo_encam_odonto(co_cds_tipo_encam_odonto) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION
);

CREATE SEQUENCE social.seq_co_rl_cds_atend_odonto_tipo_encam
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE rl_cds_atend_odonto_tipo_encam ALTER COLUMN co_rl_cds_atend_odonto_tipo_encam SET DEFAULT nextval(('seq_co_rl_cds_atend_odonto_tipo_encam'::text)::regclass);

INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('1','PACIENTES COM NECESSIDADES ESPECIAIS','PACIENTES_COM_NECESSIDADES_ESPECIAIS');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('2','CIRURGIA BMF','CIRURGIA_BMF');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('3','ENDODONTIA','ENDODONTIA');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('4','ESTOMATOLOGIA','ESTOMATOLOGIA');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('5','IMPLANTODONTIA','IMPLANTODONTIA');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('6','ODONTOTERAPIA','ODONTOPEDIATRIA');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('7','ORTODONTIA/ORTOPEDIA','ORTODONTIA_ORTOPEDIA');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('8','PERIODONTIA','PERIODONTIA');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('9','PRTESE DENTRIA','PROTESE_DENTARIA');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('10','RADIOLOGIA','RADIOLOGIA');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('11','OUTROS','OUTROS');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('12','AGENDAMENTO P/ OUTROS PROFISSIONAIS AB','AGENDAMENTO_P_OUTROS_PROFISSIONAIS_AB');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('13','AGENDAMENTO P/ NASF','AGENDAMENTO_P_NASF');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('14','AGENDAMENTO P/ GRUPOS','AGENDAMENTO_P_GRUPOS');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('15','TRATAMENTO CONCLUDO','TRATAMENTO_CONCLUIDO');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('16','RETORNO PARA CONSULTA AGENDADA','RETORNO_PARA_CONSULTA_AGENDADA');
INSERT INTO tb_cds_tipo_encam_odonto(CO_CDS_TIPO_ENCAM_ODONTO,NO_CDS_TIPO_ENCAM_ODONTO,NO_IDENTIFICADOR) VALUES ('99','NO SE APLICA (NA)','NAO_SE_APLICA');


INSERT INTO tb_cds_visita_dom_desfecho (co_cds_visita_dom_desfecho, no_cds_visita_dom_desfecho, no_identificador) VALUES (1, 'VISITA REALIZADA', 'VISITA_REALIZADA');
INSERT INTO tb_cds_visita_dom_desfecho (co_cds_visita_dom_desfecho, no_cds_visita_dom_desfecho, no_identificador) VALUES (2, 'VISITA RECUSADA', 'VISITA_RECUSADA');
INSERT INTO tb_cds_visita_dom_desfecho (co_cds_visita_dom_desfecho, no_cds_visita_dom_desfecho, no_identificador) VALUES (3, 'AUSENTE', 'AUSENTE');

INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (32, 'SINTOMTICOS RESPIRATRIOS', 'SINTOMATICOS_RESPIRATORIOS');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (33, 'TABAGISTA', 'TABAGISTA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (1, 'CADASTRAMENTO/ATUALIZAO', 'CADASTRAMENTO_ATUALIZACAO');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (2, 'CONSULTA', 'CONSULTA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (3, 'EXAME', 'EXAME');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (4, 'VACINA', 'VACINA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (5, 'GESTANTE', 'GESTANTE');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (6, 'PURPERA', 'PUERPERA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (7, 'RECM-NASCIDO', 'RECEMNASCIDO');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (8, 'CRIANA', 'CRIANCA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (9, 'PESSOA COM DESNUTRIO', 'DESNUTRICAO');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (10, 'PESSOA EM REABILITAO OU COM DEFICINCIA', 'REABILITACAO_DEFICIENCIA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (11, 'PESSOA COM HIPERTENSO', 'HIPERTENSAO');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (12, 'PESSOA COM DIABETES', 'DIABETES');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (13, 'PESSOA COM ASMA', 'ASMA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (14, 'PESSOA COM DPOC/ENFISEMA', 'DPOC_ENFISEMA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (15, 'PESSSOA COM CNCER', 'CANCER');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (16, 'PESSOA COM OUTRAS DOENAS CRNICAS', 'OUTRASDOENCASCRONICAS');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (17, 'PESSOA COM HANSENASE', 'HANSENIASE');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (18, 'PESSOA COM TUBERCULOSE', 'TUBERCULOSE');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (19, 'DOMICILIADOS/ACAMADOS', 'DOMICILIADOS_ACAMADOS');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (20, 'CONDIES DE VULNERABILIDADE SOCIAL', 'VULNERABILIDADE_SOCIAL');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (21, 'CONDICIONALIDADES DO BOLSA FAMLIA', 'BOLSA_FAMILIA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (22, 'SADE MENTAL', 'SAUDE_MENTAL');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (23, 'USURIO DE LCOOL', 'USUARIO_ALCOOL');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (24, 'USURIO DE OUTRAS DROGAS', 'USUARIO_OUTRAS_DROGAS');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (25, 'EGRESSO DE INTERNAO', 'EGRESSO_INTERNACAO');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (26, 'CONTROLE DE AMBIENTES/VETORES', 'CONTROLE_AMBIENTES_VETORES');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (27, 'CONVITE PARA ATIVIDADES COLETIVAS/CAMPANHA DE SADE', 'CONVITE_ATIVIDADES_CAMPANHA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (28, 'OUTROS', 'OUTROS');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (29, 'Visita Peridica', 'VISITA_PERIODICA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (30, 'CONDICIONALIDADES DO BOLSA FAMLIA - Busca Ativa', 'CONDICIONALIDADES_BOLSA_FAMILIA');
INSERT INTO tb_cds_visita_dom_motivo (co_cds_visita_dom_motivo, no_cds_visita_dom_motivo, no_identificador) VALUES (31, 'Orientao / Preveno', 'ORIENTACAO_PREVENCAO');

INSERT INTO tb_contexto_pergunta (co_contexto_pergunta, ds_contexto_pergunta) VALUES (1, 'CDS:cadastro individual');
INSERT INTO tb_contexto_pergunta (co_contexto_pergunta, ds_contexto_pergunta) VALUES (2, 'CDS:cadastro de domiclio');

INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (1, 'pt_BR', 'CRIANAS DE 0 A 9 ANOS, COM QUEM FICA?', NULL, 1, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (2, 'pt_BR', 'FREQUENTA CURANDEIRO(A) / BENZEDEIRO?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (3, 'pt_BR', 'PARTICIPA DE ALGUM GRUPO COMUNITRIO?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (4, 'pt_BR', 'POSSUI PLANO DE SADE PRIVADO?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (5, 'pt_BR', ' MEMBRO DE POVO OU COMUNIDADE TRADICIONAL?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (6, 'pt_BR', 'SE SIM, QUAL?', 5, 1, 4);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (7, 'pt_BR', 'DESEJA INFORMAR ORIENTAO SEXUAL / IDENTIDADE DE GNERO?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (8, 'pt_BR', 'SE SIM, QUAL?', 7, 1, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (9, 'pt_BR', 'TEM ALGUMA DEFICINCIA?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (10, 'pt_BR', 'SE SIM, QUAL?', 9, 1, 3);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (11, 'pt_BR', 'EST EM SITUAO DE RUA?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (12, 'pt_BR', 'TEMPO EM SITUAO DE RUA?', NULL, 1, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (13, 'pt_BR', ' ACOMPANHADO POR OUTRA INSTITUIO?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (14, 'pt_BR', 'SE SIM, QUAL?', 13, 1, 4);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (15, 'pt_BR', 'RECEBE ALGUM BENEFCIO?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (16, 'pt_BR', 'POSSUI REFERNCIA FAMILIAR?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (17, 'pt_BR', 'VISITA ALGUM FAMILIAR COM FREQUNCIA?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (18, 'pt_BR', 'SE SIM, QUAL  O GRAU DE PARENTESCO?', 17, 1, 4);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (19, 'pt_BR', ' GESTANTE?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (20, 'pt_BR', 'SE SIM, QUAL  A MATERNIDADE DE REFERNCIA?', 19, 1, 4);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (21, 'pt_BR', 'SOBRE SEU PESO, VOC SE CONSIDERA?', NULL, 1, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (22, 'pt_BR', ' FUMANTE?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (23, 'pt_BR', ' DEPENDENTE OU ABUSA DE LCOOL?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (24, 'pt_BR', ' DEPENDENTE OU ABUSA DE OUTRAS DROGAS?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (25, 'pt_BR', 'TEM HIPERTENSO ARTERIAL?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (26, 'pt_BR', 'TEM DIABETES?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (27, 'pt_BR', 'TEVE AVC / DERRAME?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (28, 'pt_BR', 'TEVE INFARTO?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (29, 'pt_BR', 'TEM DOENA CARDACA / DO CORAO?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (30, 'pt_BR', 'SE SIM, QUAIS?', 29, 1, 3);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (31, 'pt_BR', 'TEM OU TEVE PROBLEMAS NOS RINS?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (32, 'pt_BR', 'SE SIM, QUAIS?', 31, 1, 3);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (33, 'pt_BR', 'TEM DOENA RESPIRATRIA / NO PULMO?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (34, 'pt_BR', 'SE SIM, QUAIS?', 33, 1, 3);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (35, 'pt_BR', 'TEM HANSENASE?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (36, 'pt_BR', 'TEM TUBERCULOSE?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (37, 'pt_BR', 'TEM OU TEVE CNCER?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (38, 'pt_BR', 'TEVE ALGUMA INTERNAO NOS LTIMOS 12 MESES?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (39, 'pt_BR', 'SE SIM, QUAL A CAUSA?', 38, 1, 4);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (40, 'pt_BR', 'FEZ OU FAZ TRATAMENTO COM PSIQUIATRA OU TEVE INTERNAO POR PROBLEMA DE SADE MENTAL?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (41, 'pt_BR', 'EST ACAMADO?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (42, 'pt_BR', 'EST DOMICILIADO?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (43, 'pt_BR', 'USA PLANTAS MEDICINAIS?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (44, 'pt_BR', 'SE SIM, QUAIS?', 43, 1, 4);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (45, 'pt_BR', 'USA OUTRAS PRTICAS INTEGRATIVAS E COMPLEMENTARES?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (46, 'pt_BR', 'OUTRAS CONDIES DE SADE?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (47, 'pt_BR', 'SE SIM, QUAIS?', 46, 1, 4);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (48, 'pt_BR', 'QUANTAS VEZES SE ALIMENTA AO DIA?', NULL, 1, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (49, 'pt_BR', 'QUAL A ORIGEM DA ALIMENTAO?', NULL, 1, 3);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (50, 'pt_BR', 'TEM ACESSO A HIGIENE PESSOAL?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (51, 'pt_BR', 'SE SIM, QUAIS?', 50, 1, 3);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (52, 'pt_BR', 'SITUAO CONJUGAL', NULL, 1, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (53, 'pt_BR', 'OCUPAO', NULL, 1, 4);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (54, 'pt_BR', 'FREQUENTA ESCOLA?', NULL, 1, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (55, 'pt_BR', 'QUAL  O CURSO MAIS ELEVADO QUE FREQUENTA OU FREQUENTOU?', NULL, 1, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (56, 'pt_BR', 'SITUAO NO MERCADO DE TRABALHO', NULL, 1, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (57, 'pt_BR', 'SITUAO DE MORADIA / POSSE DA TERRA', NULL, 2, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (58, 'pt_BR', 'LOCALIZAO', NULL, 2, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (59, 'pt_BR', 'TIPO DE DOMICLIO', NULL, 2, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (60, 'pt_BR', 'N de Moradores', NULL, 2, 4);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (61, 'pt_BR', 'N de Cmodos', NULL, 2, 4);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (62, 'pt_BR', 'TIPO DE ACESSO AO DOMICLIO', NULL, 2, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (63, 'pt_BR', 'Disponibilidade de Energia Eltrica?', NULL, 2, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (64, 'pt_BR', 'DESTINO DO LIXO', NULL, 2, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (65, 'pt_BR', 'TRATAMENTO DE GUA NO DOMICLIO', NULL, 2, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (66, 'pt_BR', 'EM CASO DE REA DE PRODUO RURAL: Condio de Posse e Uso da Terra', NULL, 2, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (67, 'pt_BR', 'MATERIAL PREDOMINANTE NA CONSTRUO DAS PAREDES EXTERNAS DE SEU DOMICLIO', NULL, 2, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (68, 'pt_BR', 'ABASTECIMENTO DE GUA', NULL, 2, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (69, 'pt_BR', 'FORMA DE ESCOAMENTO DO BANHEIRO OU SANITRIO', NULL, 2, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (70, 'pt_BR', 'ANIMAIS NO DOMICLIO?', NULL, 2, 1);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (71, 'pt_BR', 'QUAL(IS)?', 70, 2, 3);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (72, 'pt_BR', 'Quantos:', 70, 2, 4);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (1000, 'pt_BR', 'Sada do cidado do cadastro', NULL, 1, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (1001, 'pt_BR', 'Relao de parentesco com o responsvel familia', NULL, 1, 2);

INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (1, 1, 'pt_BR', 'Adulto Responsvel', 'ADULTO_RESPONSAVEL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (2, 1, 'pt_BR', 'Outra(s) Criana(s)', 'OUTRAS_CRIANCAS');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (3, 1, 'pt_BR', 'Sozinha', 'SOZINHA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (4, 1, 'pt_BR', 'Outro', 'OUTRO_CRIANCAS_0_A_9_ANOS_COM_QUEM_FICA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (5, 8, 'pt_BR', 'Heterossexual', 'HETEROSSEXUAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (6, 8, 'pt_BR', 'Gay', 'GAY');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (7, 8, 'pt_BR', 'Lsbica', 'LESBICA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (8, 8, 'pt_BR', 'Bissexual', 'BISSEXUAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (9, 8, 'pt_BR', 'Travesti', 'TRAVESTI');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (10, 8, 'pt_BR', 'Transsexual', 'TRANSSEXUAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (11, 8, 'pt_BR', 'Outro', 'OUTRO_ORIENTACAO_SEXUAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (12, 10, 'pt_BR', 'Auditiva', 'AUDITIVA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (13, 10, 'pt_BR', 'Visual', 'VISUAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (14, 10, 'pt_BR', 'Intelectual/Cognitiva', 'INTELECTUAL_COGNITIVA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (15, 10, 'pt_BR', 'Fsica', 'FISICA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (16, 10, 'pt_BR', 'Outra', 'OUTRA_DEFICIENCIA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (17, 12, 'pt_BR', '< 6 meses', 'MENOS_6_MESES');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (18, 12, 'pt_BR', '6 a 12 meses', 'SEIS_A_12_MESES');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (19, 12, 'pt_BR', '1 a 5 anos', 'UM_A_5_ANOS');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (20, 12, 'pt_BR', '> 5 anos', 'MAIS_DE_5_ANOS');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (21, 21, 'pt_BR', 'Abaixo do Peso', 'ABAIXO_DO_PESO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (22, 21, 'pt_BR', 'Peso Adequado', 'PESO_ADEQUADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (23, 21, 'pt_BR', 'Acima do Peso', 'ACIMA_DO_PESO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (24, 30, 'pt_BR', 'Insuficincia Cardaca', 'INSUFICIENCIA_CARDIACA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (25, 30, 'pt_BR', 'Outro', 'OUTRO_DOENCA_CARDIACA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (26, 30, 'pt_BR', 'No Sabe', 'NAO_SABE_DOENCA_CARDIACA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (27, 32, 'pt_BR', 'Insuficincia Renal', 'INSUFICIENCIA_RENAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (28, 32, 'pt_BR', 'Outro', 'OUTRO_PROBLEMA_RINS');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (29, 32, 'pt_BR', 'No Sabe', 'NAO_SABE_PROBLEMA_RINS');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (30, 34, 'pt_BR', 'Asma', 'ASMA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (31, 34, 'pt_BR', 'DPOC/Enfisema', 'DPOC_ENFISEMA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (32, 34, 'pt_BR', 'Outro', 'OUTRO_DOENCA_RESPIRATORIA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (33, 34, 'pt_BR', 'No Sabe', 'NAO_SABE_DOENCA_RESPIRATORIA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (34, 48, 'pt_BR', '1 vez', 'UMA_POR_DIA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (35, 48, 'pt_BR', '2 ou 3 vezes', 'DUAS_A_3_POR_DIA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (36, 48, 'pt_BR', 'mais de 3 vezes', 'MAIS_DE_3');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (37, 49, 'pt_BR', 'Restaurante Popular', 'RESTAURANTE_POPULAR');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (38, 49, 'pt_BR', 'Doao Grupo Religioso', 'DOACAO_GRUPO_RELIGIOSO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (39, 49, 'pt_BR', 'Doao Restaurante', 'DOACAO_RESTAURANTE');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (40, 49, 'pt_BR', 'Doao de Popular', 'DOACAO_DE_POPULAR');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (41, 49, 'pt_BR', 'Outros', 'OUTROS_ORIGEM_ALIMENTACAO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (42, 51, 'pt_BR', 'Banho', 'BANHO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (43, 51, 'pt_BR', 'Acesso ao Sanitrio', 'ACESSO_AO_SANITARIO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (44, 51, 'pt_BR', 'Higiene Bucal', 'HIGIENE_BUCAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (45, 51, 'pt_BR', 'Outros', 'OUTROS_ACESSO_HIGIENE');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (46, 52, 'pt_BR', 'Solteiro (a)', 'SOLTEIRO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (47, 52, 'pt_BR', 'Casado (a) / Convvio com Companheiro', 'CASADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (48, 52, 'pt_BR', 'Divorciado(a) / Separado (a)', 'DIVORCIADO_SEPARADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (49, 52, 'pt_BR', 'Vivo(a)', 'VIUVO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (50, 52, 'pt_BR', 'Outros', 'OUTRA_SITUACAO_CONJUGAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (51, 55, 'pt_BR', 'Creche', 'CRECHE_CURSO_MAIS_ELEVADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (52, 55, 'pt_BR', 'Pr-escola (exceto CA)', 'PRE_ESCOLA_EXCETO_CA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (53, 55, 'pt_BR', 'Classe Alfabetizada - CA', 'CLASSE_ALFABETIZADA_CA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (54, 55, 'pt_BR', 'Ensino Fundamental 1 a 4 sries', 'ENSINO_FUNDAMENTAL_1_4_SERIES');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (55, 55, 'pt_BR', 'Ensino Fundamental 5 a 8 sries', 'ENSINO_FUNDAMENTAL_5_8_SERIES');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (56, 55, 'pt_BR', 'Ensino Fundamental Completo', 'ENSINO_FUNDAMENTAL_COMPLETO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (57, 55, 'pt_BR', 'Ensino Fundamental Especial', 'ENSINO_FUNDAMENTAL_ESPECIAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (58, 55, 'pt_BR', 'Ensino Fundamental EJA - sries iniciais (Supletivo 1 a 4)', 'ENSINO_FUNDAMENTAL_EJA_SERIES_INICIAIS_SUPLETIVO_1_4');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (59, 55, 'pt_BR', 'Ensino Fundamental EJA - sries iniciais (Supletivo 5 a 8)', 'ENSINO_FUNDAMENTAL_EJA_SERIES_INICIAIS_SUPLETIVO_5_8');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (60, 55, 'pt_BR', 'Ensino Mdio, Mdio 2 Ciclo (Cientfico, Tcnico e etc)', 'ENSINO_MEDIO_MEDIO_2_CICLO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (61, 55, 'pt_BR', 'Ensino Mdio Especial', 'ENSINO_MEDIO_ESPECIAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (62, 55, 'pt_BR', 'Ensino Mdio EJA (Supletivo)', 'ENSINO_MEDIO_EJA_SUPLETIVO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (63, 55, 'pt_BR', 'Superior, Aperfeioamento, Especializao, Mestrado, Doutorado', 'SUPERIOR_APERFEICOAMENTO_ESPECIALIZACAO_MESTRADO_DOUTORADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (64, 55, 'pt_BR', 'Alfabetizao para Adultos (Mobral, etc)', 'ALFABETIZACAO_PARA_ADULTROS_MOBRAL_ETC');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (65, 55, 'pt_BR', 'Nenhum', 'NENHUM');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (66, 56, 'pt_BR', 'Empregador', 'EMPREGADOR');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (67, 56, 'pt_BR', 'Assalariado com carteira de trabalho', 'ASSALARIADO_COM_CARTEIRA_TRABALHO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (68, 56, 'pt_BR', 'Assalariado sem carteira de trabalho', 'ASSALARIADO_SEM_CARTEIRA_TRABALHO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (69, 56, 'pt_BR', 'Autnomo com previdncia social', 'AUTONOMO_COM_PREVIDENCIA_SOCIAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (70, 56, 'pt_BR', 'Autnomo sem previdncia social', 'AUTONOMO_SEM_PREVIDENCIA_SOCIAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (71, 56, 'pt_BR', 'Aposentado/Pensionista', 'APOSENTADO_PENSIONISTA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (72, 56, 'pt_BR', 'Desempregado', 'DESEMPREGADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (73, 56, 'pt_BR', 'No trabalha', 'NAO_TRABALHA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (74, 56, 'pt_BR', 'Outro', 'OUTRO_SITUACAO_MERCADO_TRABALHO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (75, 57, 'pt_BR', 'Prprio', 'PROPRIO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (76, 57, 'pt_BR', 'Financiado', 'FINANCIADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (77, 57, 'pt_BR', 'Alugado', 'ALUGADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (78, 57, 'pt_BR', 'Arrendado', 'ARRENDADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (79, 57, 'pt_BR', 'Cedido', 'CEDIDO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (80, 57, 'pt_BR', 'Invaso', 'INVASAO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (81, 57, 'pt_BR', 'Situao de Rua', 'SITUACAO_DE_RUA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (82, 57, 'pt_BR', 'Outra', 'OUTRA_SITUACAO_DE_MORADIA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (83, 58, 'pt_BR', 'Urbana', 'URBANA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (84, 58, 'pt_BR', 'Rural', 'RURAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (85, 59, 'pt_BR', 'Casa', 'CASA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (86, 59, 'pt_BR', 'Apartamento', 'APARTAMENTO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (87, 59, 'pt_BR', 'Cmodo', 'COMODO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (88, 59, 'pt_BR', 'Outro', 'OUTRO_TIPO_DE_DOMICILIO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (89, 62, 'pt_BR', 'Asfalto', 'ASFALTO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (90, 62, 'pt_BR', 'Cho Batido', 'CHAO_BATIDO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (91, 62, 'pt_BR', 'Fluvial', 'FLUVIAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (92, 62, 'pt_BR', 'Outro', 'OUTRO_TIPO_DE_ACESSO_AO_DOMICILIO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (93, 64, 'pt_BR', 'Coletado', 'COLETADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (94, 64, 'pt_BR', 'Queimado', 'QUEIMADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (95, 64, 'pt_BR', 'Cu Aberto', 'CEU_ABERTO_DESTINO_DO_LIXO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (96, 64, 'pt_BR', 'Outro', 'OUTRO_DESTINO_DO_LIXO_');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (97, 65, 'pt_BR', 'Filtrao', 'FILTRACAO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (98, 65, 'pt_BR', 'Fervura', 'FERVURA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (99, 65, 'pt_BR', 'Clorao', 'CLORACAO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (100, 65, 'pt_BR', 'Sem Tratamento', 'SEM_TRATAMENTO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (101, 66, 'pt_BR', 'Proprietrio', 'PROPRIETARIO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (102, 66, 'pt_BR', 'Parceiro(a) / Meeiro(a)', 'PARCEIROA_MEEIROA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (103, 66, 'pt_BR', 'Assentado(a)', 'ASSENTADOA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (104, 66, 'pt_BR', 'Posseiro', 'POSSEIRO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (105, 66, 'pt_BR', 'Arrendatrio(a)', 'ARRENDATARIOA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (106, 66, 'pt_BR', 'Comodatrio(a)', 'COMODATARIOA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (107, 66, 'pt_BR', 'Beneficirio(a) do Banco da Terra', 'BENEFICIARIOA_DO_BANCO_DA_TERRA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (108, 66, 'pt_BR', 'No se aplica', 'NAO_SE_APLICA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (109, 67, 'pt_BR', 'Alvenaria/Tijolo: Com Revestimento', 'ALVENARIATIJOLO_COM_REVESTIMENTO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (110, 67, 'pt_BR', 'Alvenaria/Tijolo: Sem Revestimento', 'ALVENARIATIJOLO_SEM_REVESTIMENTO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (111, 67, 'pt_BR', 'Taipa: Com Revestimento', 'TAIPA_COM_REVESTIMENTO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (112, 67, 'pt_BR', 'Taipa: Sem Revestimento', 'TAIPA_SEM_REVESTIMENTO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (113, 67, 'pt_BR', 'Outros: Madeira Emparelhada', 'OUTROS_MADEIRA_EMPARELHADA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (114, 67, 'pt_BR', 'Outros: Material Aproveitado', 'OUTROS_MATERIAL_APROVEITADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (115, 67, 'pt_BR', 'Outros: Palha', 'OUTROS_PALHA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (116, 67, 'pt_BR', 'Outros: Outro Material', 'OUTROS_OUTRO_MATERIAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (117, 68, 'pt_BR', 'Rede Encanada at o Domiclio', 'REDE_ENCANADA_ATE_O_DOMICILIO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (118, 68, 'pt_BR', 'Poo / Nascente no Domiclio', 'POCO_NASCENTE_NO_DOMICILIO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (119, 68, 'pt_BR', 'Cisterna', 'CISTERNA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (120, 68, 'pt_BR', 'Carro Pipa', 'CARRO_PIPA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (121, 68, 'pt_BR', 'Outro', 'OUTRO_ABASTECIMENTO_DE_AGUA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (122, 69, 'pt_BR', 'Rede Coletora de Esgoto ou Pluvial', 'REDE_COLETORA_DE_ESGOTO_OU_PLUVIAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (123, 69, 'pt_BR', 'Fossa Sptica', 'FOSSA_SEPTICA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (124, 69, 'pt_BR', 'Fossa Rudimentar', 'FOSSA_RUDIMENTAR');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (125, 69, 'pt_BR', 'Direto para um Rio, Lago ou Mar', 'DIRETO_PARA_UM_RIO_LAGO_OU_MAR');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (126, 69, 'pt_BR', 'Cu Aberto', 'CEU_ABERTO_ESCOAMENTO_DO_BANHEIRO_OU_SANITARIO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (127, 69, 'pt_BR', 'Outra Forma', 'OUTRA_FORMA_DE_ESCOAMENTO_DO_BANHEIRO_OU_SANITARIO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (128, 71, 'pt_BR', 'Gato', 'GATO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (129, 71, 'pt_BR', 'Cachorro', 'CACHORRO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (130, 71, 'pt_BR', 'Pssaro', 'PASSARO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (131, 71, 'pt_BR', 'De Criao (porco, galinha...)', 'DE_CRIACAO_PORCO_GALINHA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (132, 71, 'pt_BR', 'Outros', 'OUTROS_ANIMAIS_NO_DOMICILIO_QUAIS');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (133, 1, 'pt_BR', 'Adolescente', 'ADOLESCENTE');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (134, 1, 'pt_BR', 'Creche', 'CRECHE_CRIANCAS_0_A_9_ANOS_COM_QUEM_FICA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (135, 1000, 'pt_BR', 'bito', 'SAIDA_CIDADAO_OBITO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (136, 1000, 'pt_BR', 'Mudana de territrio', 'SAIDA_CIDADAO_MUDANCA_TERRITORIO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (137, 1001, 'pt_BR', 'Cnjuge ou companheiro(a)', 'CONJUGE_OU_COMPANHEIRO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (138, 1001, 'pt_BR', 'Filho(a)', 'FILHO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (139, 1001, 'pt_BR', 'Enteado(a)', 'ENTEADO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (140, 1001, 'pt_BR', 'Neto(a) ou bisneto(a)', 'NETO_OU_BISNETO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (141, 1001, 'pt_BR', 'Pai ou me', 'PAI_OU_MAE');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (142, 1001, 'pt_BR', 'Sogro(a)', 'SOGRO');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (143, 1001, 'pt_BR', 'Irmo ou irm', 'IRMAO_OU_IRMA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (144, 1001, 'pt_BR', 'Genro ou nora', 'GENRO_OU_NORA');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (145, 1001, 'pt_BR', 'Outro parente', 'OUTRO_PARENTE');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (146, 1001, 'pt_BR', 'No parente', 'NAO_PARENTE');

CREATE TABLE tb_tipo_pergunta
(
  co_tipo_pergunta integer NOT NULL,
  ds_tipo_pergunta character varying,
  CONSTRAINT tb_tipo_pergunta_pkey PRIMARY KEY (co_tipo_pergunta)
)
WITH (
  OIDS=FALSE
);

INSERT INTO tb_tipo_pergunta (co_tipo_pergunta, ds_tipo_pergunta) VALUES (1, 'SIM E NAO');
INSERT INTO tb_tipo_pergunta (co_tipo_pergunta, ds_tipo_pergunta) VALUES (2, 'UMA ESCOLHA');
INSERT INTO tb_tipo_pergunta (co_tipo_pergunta, ds_tipo_pergunta) VALUES (3, 'VARIAS ESCOLHAS');
INSERT INTO tb_tipo_pergunta (co_tipo_pergunta, ds_tipo_pergunta) VALUES (4, 'DESCRITIVO');

CREATE TABLE social.tb_ciap
(
   co_seq_ciap bigint, 
   co_ciap character varying, 
   ds_ciap character varying, 
   ds_ciap_filtro character varying, 
   co_sexo integer, 
   st_filtro_padrao integer, 
   PRIMARY KEY (co_seq_ciap)
) 
WITH (
  OIDS = FALSE
)
;

INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (365, 'K04', 'PALPITAES/PERCEPO DOS BATIMENTOS CARDACOS', 'palpitacoes/percepcao dos batimentos cardiacos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (366, 'K05', 'OUTRAS IRREGULARIDADES DOS BATIMENTOS CARDACOS', 'outras irregularidades dos batimentos cardiacos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (367, 'K06', 'VEIAS PROEMINENTES', 'veias proeminentes', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (368, 'K07', 'TORNOZELOS INCHADOS/EDEMA', 'tornozelos inchados/edema', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (370, 'K24', 'MEDO DE DOENA CARDACA', 'medo de doenca cardiaca', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (371, 'K25', 'MEDO DE HIPERTENSO', 'medo de hipertensao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (372, 'K27', 'MEDO DE OUTRA DOENA CARDIOVASCULAR', 'medo de outra doenca cardiovascular', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (373, 'K28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (374, 'K29', 'OUTROS SINAIS/SINTOMAS CARDIOVASCULARES', 'outros sinais/sintomas cardiovasculares', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (375, 'K70', 'DOENA INFECCIOSA DO APARELHO CIRCULATRIO', 'doenca infecciosa do aparelho circulatorio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (376, 'K71', 'FEBRE REUMTICA/CARDIOPATIA', 'febre reumatica/cardiopatia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (377, 'K72', 'NEOPLASIA DO APARELHO CIRCULATRIO', 'neoplasia do aparelho circulatorio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (378, 'K73', 'MALFORMAES CONGNITAS DO APARELHO CIRCULATRIO', 'malformacoes congenitas do aparelho circulatorio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (379, 'K74', 'DOENA CARDACA ISQUMICA COM ANGINA', 'doenca cardiaca isquemica com angina', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (380, 'K75', 'INFARTO OU ENFARTE AGUDO MIOCRDIO', 'infarto ou enfarte agudo miocardio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (381, 'K76', 'DOENA CARDACA ISQUMICA SEM ANGINA', 'doenca cardiaca isquemica sem angina', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (382, 'K77', 'INSUFICINCIA CARDACA', 'insuficiencia cardiaca', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (383, 'K78', 'FIBRILAO/FLUTTER AURICULAR/ ATRIAL', 'fibrilacao/flutter auricular/ atrial', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (384, 'K79', 'TAQUICARDIA PAROXSTICA', 'taquicardia paroxistica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (385, 'K80', 'ARRITMIA CARDACA NE', 'arritmia cardiaca ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (386, 'K81', 'SOPRO CARDACO/ARTERIAL NE', 'sopro cardiaco/arterial ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (387, 'K82', 'DOENA CARDIOPULMONAR', 'doenca cardiopulmonar', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (388, 'L16', 'SINAIS/SINTOMAS DO TORNOZELO', 'sinais/sintomas do tornozelo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (389, 'L17', 'SINAIS/SINTOMAS DO P/DEDOS P', 'sinais/sintomas do pe/dedos pe', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (225, 'L84', 'DOENAS OU SNDROMES DA COLUNA SEM IRRADIAO DE DOR', 'doencas ou sindromes da coluna sem irradiacao de dor', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (226, 'L85', 'DEFORMAO ADQUIRIDA DA COLUNA', 'deformacao adquirida da coluna', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (227, 'L86', 'SNDROME VERTEBRAL COM IRRADIAO DOR', 'sindrome vertebral com irradiacao dor', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (228, 'L87', 'BURSITE/TENDINITE/SINOVITE NE', 'bursite/tendinite/sinovite ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (229, 'L88', 'ARTRITE REUMATIDE/SEROPOSITIVA', 'artrite reumatoide/seropositiva', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (230, 'L89', 'OSTEOARTROSE DO QUADRIL', 'osteoartrose do quadril', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (231, 'R23', 'SINAIS/SINTOMAS DA VOZ', 'sinais/sintomas da voz', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (232, 'L90', 'OSTEOARTROSE DO JOELHO', 'osteoartrose do joelho', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (233, 'L91', 'OUTRAS OSTEOARTROSES', 'outras osteoartroses', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (234, 'L92', 'SNDROME DO OMBRO DOLOROSO', 'sindrome do ombro doloroso', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (235, 'L93', 'COTOVELO DE TENISTA', 'cotovelo de tenista', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (236, 'L94', 'OSTEOCONDROSE', 'osteocondrose', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (237, 'L95', 'OSTEOPOROSE', 'osteoporose', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (238, 'L96', 'LESO INTERNA AGUDA DO JOELHO', 'lesao interna aguda do joelho', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (239, 'L97', 'NEOPLASIA BENIGNA/INCERTAS', 'neoplasia benigna/incertas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (240, 'L98', 'MALFORMAO ADQUIRIDA DE UM MEMBRO', 'malformacao adquirida de um membro', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (241, 'L99', 'OUTRA DOENA DO APARELHO MSCULO-ESQUELTICO', 'outra doenca do aparelho musculo-esqueletico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (242, 'N01', 'CEFALIA', 'cefaleia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (243, 'N03', 'DORES DA FACE', 'dores da face', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (244, 'N04', 'SNDROME DAS PERNAS INQUIETAS', 'sindrome das pernas inquietas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (245, 'N05', 'FORMIGAMENTO/ PARESTESIA NOS DEDOS DAS MOS/PS', 'formigamento/ parestesia nos dedos das maos/pes', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (246, 'N06', 'OUTRAS ALTERAES DA SENSIBILIDADE', 'outras alteracoes da sensibilidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (247, 'N07', 'CONVULSES/ATAQUES', 'convulsoes/ataques', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (248, 'N08', 'MOVIMENTOS INVOLUNTRIOS ANORMAIS', 'movimentos involuntarios anormais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (249, 'N16', 'ALTERAES DO OLFATO/GOSTO', 'alteracoes do olfato/gosto', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (250, 'N17', 'VERTIGENS/TONTURAS', 'vertigens/tonturas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (251, 'N18', 'PARALISIA/FRAQUEZA', 'paralisia/fraqueza', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (252, 'N19', 'PERTURBAES DA FALA', 'perturbacoes da fala', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (253, 'N26', 'MEDO DE CNCER DO SISTEMA NEUROLGICO', 'medo de cancer do sistema neurologico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (254, 'N27', 'MEDO DE OUTRAS DOENAS NEUROLGICAS', 'medo de outras doencas neurologicas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (255, 'N28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (256, 'N29', 'SINAIS/SINTOMAS DO SISTEMA NEUROLGICO, OUTROS', 'sinais/sintomas do sistema neurologico, outros', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (257, 'N70', 'POLIOMIELITE', 'poliomielite', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (258, 'N71', 'MENINGITE/ENCEFALITE', 'meningite/encefalite', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (259, 'N72', 'TTANO', 'tetano', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (260, 'N73', 'OUTRA INFECO NEUROLGICA', 'outra infeccao neurologica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (261, 'N74', 'NEOPLASIA MALIGNA DO SISTEMA NEUROLGICO', 'neoplasia maligna do sistema neurologico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (262, 'N76', 'NEOPLASIA DO SISTEMA NEUROLGICO DE NATUREZA INCERTA', 'neoplasia do sistema neurologico de natureza incerta', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (263, 'N79', 'CONCUSSO', 'concussao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (264, 'N80', 'OUTRAS LESES CRANIANAS', 'outras lesoes cranianas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (265, 'N81', 'OUTRA LESO DO SISTEMA NEUROLGICO', 'outra lesao do sistema neurologico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (266, 'N85', 'MALFORMAES CONGNITAS', 'malformacoes congenitas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (267, 'N86', 'ESCLEROSE MLTIPLA', 'esclerose multipla', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (268, 'N87', 'PARKINSONISMO', 'parkinsonismo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (269, 'N88', 'EPILEPSIA', 'epilepsia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (270, 'N89', 'ENXAQUECA', 'enxaqueca', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (271, 'N90', 'CEFALIA DE CLUSTER', 'cefaleia de cluster', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (272, 'N91', 'PARALISIA FACIAL/PARALISIA DE BELL', 'paralisia facial/paralisia de bell', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (273, 'N92', 'NEVRALGIA DO TRIGMIO', 'nevralgia do trigemio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (274, 'N93', 'SNDROME DO TNEL DO CARPO/ SNDROME DO CANAL CRPICO', 'sindrome do tunel do carpo/ sindrome do canal carpico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (275, 'N94', 'NEURITE/ NEVRITE/NEUROPATIA PERIFRICA', 'neurite/ nevrite/neuropatia periferica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (276, 'N95', 'CEFALIA TENSIONAL', 'cefaleia tensional', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (277, 'N99', 'OUTRAS DOENAS DO SISTEMA NEUROLGICO', 'outras doencas do sistema neurologico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (175, 'K83', 'DOENA VALVULAR CARDACA NE', 'doenca valvular cardiaca ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (176, 'K84', 'OUTRAS DOENAS CARDACAS', 'outras doencas cardiacas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (177, 'K85', 'PRESSO ARTERIAL ELEVADA', 'pressao arterial elevada', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (179, 'K87', 'HIPERTENSO COM COMPLICAES', 'hipertensao com complicacoes', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (180, 'K88', 'HIPOTENSO POSTURAL', 'hipotensao postural', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (181, 'K89', 'ISQUMIA/ ACIDENTE CEREBRAL TRANSITRIA(O)', 'isquemia/ acidente cerebral transitoria(o)', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (182, 'K90', 'TROMBOSE/ACIDENTE VASCULAR CEREBRAL', 'trombose/acidente vascular cerebral', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (183, 'K91', 'DOENA VASCULAR CEREBRAL', 'doenca vascular cerebral', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (184, 'K92', 'ATEROSCLEROSE/DOENA VASCULAR PERIFRICA', 'aterosclerose/doenca vascular periferica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (185, 'K93', 'EMBOLIA PULMONAR', 'embolia pulmonar', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (186, 'K94', 'FLEBITE/TROMBOFLEBITE', 'flebite/tromboflebite', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (187, 'K95', 'VEIAS VARICOSAS DA PERNA', 'veias varicosas da perna', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (188, 'K96', 'HEMORRIDAS', 'hemorroidas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (189, 'K99', 'OUTRAS DOENAS DO APARELHO CIRCULATRIO', 'outras doencas do aparelho circulatorio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (190, 'L01', 'SINAIS/SINTOMAS DO PESCOO', 'sinais/sintomas do pescoco', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (191, 'L02', 'SINAIS/SINTOMAS DA REGIO DORSAL', 'sinais/sintomas da regiao dorsal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (192, 'L03', 'SINAIS/SINTOMAS DA REGIO LOMBAR', 'sinais/sintomas da regiao lombar', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (193, 'L04', 'SINAIS/SINTOMAS DO TRAX', 'sinais/sintomas do torax', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (194, 'L05', 'SINAIS/SINTOMAS DA AXILA', 'sinais/sintomas da axila', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (487, 'U07', 'OUTROS SINAIS/SINTOMAS URINRIOS', 'outros sinais/sintomas urinarios', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (488, 'U08', 'RETENO URINRIA', 'retencao urinaria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (489, 'U13', 'SINAIS/SINTOMAS DA BEXIGA, OUTROS', 'sinais/sintomas da bexiga, outros', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (490, 'U14', 'SINAIS/SINTOMAS DOS RINS', 'sinais/sintomas dos rins', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (491, 'U26', 'MEDO DE CNCER NO APARELHO URINRIO', 'medo de cancer no aparelho urinario', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (492, 'U27', 'MEDO DE OUTRA DOENA URINRIA', 'medo de outra doenca urinaria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (493, 'U28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (494, 'U70', 'PIELONEFRITE', 'pielonefrite', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (495, 'U71', 'CISTITE/OUTRA INFECO URINRIA', 'cistite/outra infeccao urinaria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (496, 'U72', 'URETRITE', 'uretrite', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (497, 'U75', 'NEOPLASIA MALIGNA DO RIM', 'neoplasia maligna do rim', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (498, 'U76', 'NEOPLASIA BENIGNA DO RIM', 'neoplasia benigna do rim', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (499, 'U77', 'NEOPLASIA MALIGNA DO APARELHO URINRIO, OUTRA', 'neoplasia maligna do aparelho urinario, outra', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (500, 'U78', 'NEOPLASIA BENIGNA DO APARELHO URINRIO', 'neoplasia benigna do aparelho urinario', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (501, 'U79', 'NEOPLASIA DO APARELHO URINRIO NE', 'neoplasia do aparelho urinario ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (502, 'U80', 'LESES TRAUMTICAS DO APARELHO URINRIO', 'lesoes traumaticas do aparelho urinario', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (503, 'U85', 'MALFORMAO CONGNITA DO APARELHO URINRIO', 'malformacao congenita do aparelho urinario', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (504, 'U88', 'GLOMERULONEFRITE/ SINDROME NEFRTICA', 'glomerulonefrite/ sindrome nefrotica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (505, 'U90', 'ALBUMINRIA/PROTEINRIA ORTOSTTICA', 'albuminuria/proteinuria ortostatica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (506, 'U95', 'CLCULO URINRIO', 'calculo urinario', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (507, 'U98', 'ANLISE DE URINA ANORMAL NE', 'analise de urina anormal ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (508, 'U99', 'OUTRAS DOENAS URINRIAS', 'outras doencas urinarias', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (509, 'W01', 'QUESTO SOBRE GRAVIDEZ', 'questao sobre gravidez', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (510, 'W02', 'MEDO DE ESTAR GRVIDA', 'medo de estar gravida', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (511, 'W03', 'HEMORRAGIA ANTES DO PARTO', 'hemorragia antes do parto', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (512, 'W05', 'VMITOS/NUSEAS DURANTE A GRAVIDEZ', 'vomitos/nauseas durante a gravidez', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (513, 'W10', 'CONTRACEPO PS-COITAL', 'contracepcao pos-coital', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (514, 'W11', 'CONTRACEPO ORAL', 'contracepcao oral', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (515, 'W12', 'CONTRACEPO INTRA-UTERINA/ DISPOSITIVO INTRAUTERINO/ DIU', 'contracepcao intra-uterina/ dispositivo intrauterino/ diu', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (516, 'W13', 'ESTERILIZAO', 'esterilizacao', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (517, 'W14', 'CONTRACEPO/OUTROS', 'contracepcao/outros', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (519, 'P18', 'ABUSO DE MEDICAO', 'abuso de medicacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (521, 'P20', 'ALTERAES DA MEMRIA', 'alteracoes da memoria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (522, 'P22', 'SINAIS/SINTOMAS RELACIONADOS AO COMPORTAMENTO DA CRIANA', 'sinais/sintomas relacionados ao comportamento da crianca', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (523, 'P23', 'SINAIS/SINTOMAS RELACIONADOS AO COMPORTAMENTO DO ADOLESCENTE', 'sinais/sintomas relacionados ao comportamento do adolescente', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (524, 'P24', 'DIFICULDADES ESPECIFICAS DE APRENDIZAGEM', 'dificuldades especificas de aprendizagem', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (525, 'P25', 'PROBLEMAS DA FASE DE VIDA DE ADULTO', 'problemas da fase de vida de adulto', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (526, 'P27', 'MEDO DE PERTURBAES MENTAIS', 'medo de perturbacoes mentais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (527, 'S12', 'PICADA OU MORDEDURA DE INSETO', 'picada ou mordedura de inseto', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (528, 'P28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (529, 'P29', 'SINAIS/SINTOMAS PSICOLGICOS, OUTROS', 'sinais/sintomas psicologicos, outros', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (530, 'P70', 'DEMNCIA', 'demencia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (531, 'P71', 'OUTRAS PSICOSES ORGNICAS NE', 'outras psicoses organicas ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (532, 'P72', 'ESQUIZOFRENIA', 'esquizofrenia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (533, 'P73', 'PSICOSE AFETIVA', 'psicose afetiva', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (534, 'P74', 'DISTRBIO ANSIOSO/ESTADO DE ANSIEDADE', 'disturbio ansioso/estado de ansiedade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (535, 'P75', 'SOMATIZAO', 'somatizacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (536, 'P76', 'PERTURBAES DEPRESSIVAS', 'perturbacoes depressivas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (537, 'P77', 'SUICDIO/TENTATIVA DE SUICDIO', 'suicidio/tentativa de suicidio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (538, 'P78', 'NEURASTENIA', 'neurastenia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (539, 'P79', 'FOBIA/PERTURBAO COMPULSIVA', 'fobia/perturbacao compulsiva', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (540, 'P80', 'PERTURBAES DE PERSONALIDADE', 'perturbacoes de personalidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (541, 'P81', 'PERTURBAO HIPERCINTICA', 'perturbacao hipercinetica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (542, 'P82', 'ESTRESSE PS TRAUMTICO', 'estresse pos traumatico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (543, 'P85', 'RETARDO/ ATRASO MENTAL', 'retardo/ atraso mental', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (544, 'P86', 'ANOREXIA NERVOSA, BULIMIA', 'anorexia nervosa, bulimia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (545, 'P98', 'OUTRAS PSICOSES NE', 'outras psicoses ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (546, 'P99', 'OUTRAS PERTURBAES PSICOLGICAS', 'outras perturbacoes psicologicas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (547, 'S13', 'MORDEDURA ANIMAL/HUMANA', 'mordedura animal/humana', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (548, 'S14', 'QUEIMADURA/ESCALDO', 'queimadura/escaldao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (549, 'R01', 'DOR ATRIBUDA AO APARELHO RESPIRATRIO', 'dor atribuida ao aparelho respiratorio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (550, 'R02', 'DIFICULDADE RESPIRATRIA, DISPNEIA', 'dificuldade respiratoria, dispneia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (551, 'R03', 'RESPIRAO RUIDOSA', 'respiracao ruidosa', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (552, 'R04', 'OUTROS PROBLEMAS RESPIRATRIOS', 'outros problemas respiratorios', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (553, 'R05', 'TOSSE', 'tosse', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (554, 'R06', 'HEMORRAGIA NASAL/EPISTAXE', 'hemorragia nasal/epistaxe', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (555, 'R07', 'ESPIRRO/CONGESTO NASAL', 'espirro/congestao nasal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (556, 'R08', 'OUTROS SINAIS/SINTOMAS NASAIS', 'outros sinais/sintomas nasais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (557, 'R09', 'SINAIS/SINTOMAS DOS SEIOS PARANASAIS', 'sinais/sintomas dos seios paranasais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (558, 'R21', 'SINAIS/SINTOMAS DA GARGANTA', 'sinais/sintomas da garganta', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (559, 'R26', 'MEDO DE CNCER DO APARELHO RESPIRATRIO', 'medo de cancer do aparelho respiratorio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (560, 'R27', 'MEDO DE OUTRAS DOENAS RESPIRATRIAS', 'medo de outras doencas respiratorias', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (561, 'R28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (562, 'R29', 'SINAIS/SINTOMAS DO APARELHO RESPIRATRIO, OUTROS', 'sinais/sintomas do aparelho respiratorio, outros', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (563, 'R71', 'TOSSE CONVULSA/ PERTUSSIS', 'tosse convulsa/ pertussis', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (564, 'R72', 'INFECO ESTREPTOCCICA DA OROFARINGE', 'infeccao estreptococica da orofaringe', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (565, 'R73', 'ABCESSO/FURNCULO NO NARIZ', 'abcesso/furunculo no nariz', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (566, 'R74', 'INFECO AGUDA DO APARELHO RESPIRATRIO SUPERIOR (IVAS)', 'infeccao aguda do aparelho respiratorio superior (ivas)', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (567, 'R75', 'SINUSITE CRNICA/AGUDA', 'sinusite cronica/aguda', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (568, 'R76', 'AMIGDALITE AGUDA', 'amigdalite aguda', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (569, 'R77', 'LARINGITE/TRAQUETE AGUDA', 'laringite/traqueite aguda', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (570, 'R78', 'BRONQUITE/BRONQUIOLITE AGUDA', 'bronquite/bronquiolite aguda', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (571, 'R79', 'BRONQUITE CRNICA', 'bronquite cronica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (572, 'R80', 'GRIPE', 'gripe', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (573, 'R81', 'PNEUMONIA', 'pneumonia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (574, 'R82', 'PLEURITE/DERRAME PLEURAL', 'pleurite/derrame pleural', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (575, 'R83', 'OUTRA INFECO RESPIRATRIA', 'outra infeccao respiratoria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (576, 'R84', 'NEOPLASIA MALIGNA DOS BRNQUIOS/PULMO', 'neoplasia maligna dos bronquios/pulmao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (577, 'R85', 'OUTRA NEOPLASIA RESPIRATRIA MALIGNA', 'outra neoplasia respiratoria maligna', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (578, 'R86', 'NEOPLASIA BENIGNA RESPIRATRIA', 'neoplasia benigna respiratoria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (579, 'R87', 'CORPO ESTRANHO NARIZ/LARINGE/BRNQUIOS', 'corpo estranho nariz/laringe/bronquios', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (29, 'B81', 'ANEMIA PERNICIOSA/DEFICINCIA DE FOLATOS', 'anemia perniciosa/deficiencia de folatos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (30, 'D74', 'NEOPLASIA MALIGNA DO ESTMAGO', 'neoplasia maligna do estomago', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (31, 'D75', 'NEOPLASIA MALIGNA DO CLON/RETO', 'neoplasia maligna do colon/reto', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (32, 'D76', 'NEOPLASIA MALIGNA DO PNCREAS', 'neoplasia maligna do pancreas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (33, 'D77', 'NEOPLASIA MALIGNA DO APARELHO DIGESTIVO NE', 'neoplasia maligna do aparelho digestivo ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (34, 'D78', 'NEOPLASIA BENIGNA DO APARELHO DIGESTIVO/INCERTA', 'neoplasia benigna do aparelho digestivo/incerta', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (35, 'S15', 'CORPO ESTRANHO NA PELE', 'corpo estranho na pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (36, 'D79', 'CORPO ESTRANHO NO APARELHO DIGESTIVO', 'corpo estranho no aparelho digestivo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (37, 'D80', 'OUTRAS LESES TRAUMTICAS', 'outras lesoes traumaticas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (38, 'D81', 'MALFORMAES CONGNITAS DO APARELHO DIGESTIVO', 'malformacoes congenitas do aparelho digestivo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (39, 'D82', 'DOENA DOS DENTES/GENGIVAS', 'doenca dos dentes/gengivas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (40, 'D83', 'DOENA DA BOCA/LNGUA/LBIOS', 'doenca da boca/lingua/labios', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (41, 'D84', 'DOENA DO ESFAGO', 'doenca do esofago', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (42, 'D85', 'LCERA DO DUODENO', 'ulcera do duodeno', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (43, 'F72', 'BLEFARITE/HORDOLO/CALZIO', 'blefarite/hordeolo/calazio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (44, 'D86', 'LCERA PPTICA, OUTRA', 'ulcera peptica, outra', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (45, 'D87', 'ALTERAES FUNCIONAIS ESTMAGO', 'alteracoes funcionais estomago', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (46, 'D88', 'APENDICITE', 'apendicite', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (47, 'D89', 'HRNIA INGUINAL', 'hernia inguinal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (48, 'D90', 'HRNIA DE HIATO /DIAFRAGMTICA', 'hernia de hiato /diafragmatica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (49, 'D91', 'HRNIA ABDOMINAL, OUTRAS', 'hernia abdominal, outras', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (50, 'D92', 'DOENA DIVERTICULAR INTESTINAL', 'doenca diverticular intestinal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (51, 'D93', 'SNDROME DO CLON IRRITVEL', 'sindrome do colon irritavel', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (52, 'D94', 'ENTERITE CRNICA/COLITE ULCEROSA', 'enterite cronica/colite ulcerosa', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (53, 'B82', 'OUTRAS ANEMIAS NE', 'outras anemias ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (54, 'B83', 'PRPURA/DEFEITOS DE COAGULAO', 'purpura/defeitos de coagulacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (55, 'B84', 'GLBULOS BRANCOS ANORMAIS', 'globulos brancos anormais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (56, 'B87', 'ESPLENOMEGALIA', 'esplenomegalia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (57, 'B90', 'INFECO POR VIH/ HIV/SIDA/ AIDS', 'infeccao por vih/ hiv/sida/ aids', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (58, 'B99', 'OUTRA DOENA DO SANGUE/LINFTICOS/BAO', 'outra doenca do sangue/linfaticos/baco', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (59, 'D01', 'DOR ABDOMINAL GENERALIZADA/CLICAS', 'dor abdominal generalizada/colicas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (60, 'D02', 'DORES ABDOMINAIS, EPIGSTRICAS', 'dores abdominais, epigastricas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (61, 'D03', 'AZIA/ QUEIMAO', 'azia/ queimacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (62, 'D04', 'DOR ANAL/RETAL', 'dor anal/retal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (63, 'D05', 'IRRITAO PERIANAL', 'irritacao perianal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (139, 'A08', 'INCHAO', 'inchaco', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (64, 'D06', 'OUTRAS DORES ABDOMINAIS LOCALIZADAS', 'outras dores abdominais localizadas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (65, 'D07', 'DISPEPSIA/INDIGESTO', 'dispepsia/indigestao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (66, 'D08', 'FLATULNCIA /GASES/ERUCTAES', 'flatulencia /gases/eructacoes', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (67, 'D11', 'DIARREIA', 'diarreia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (68, 'D12', 'OBSTIPAO', 'obstipacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (69, 'D13', 'ICTERCIA', 'ictericia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (70, 'D14', 'HEMATMESE/VMITO SANGUE', 'hematemese/vomito sangue', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (71, 'D15', 'MELENA', 'melena', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (72, 'D16', 'HEMORRAGIA RETAL', 'hemorragia retal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (73, 'D17', 'INCONTINNCIA FECAL', 'incontinencia fecal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (74, 'D18', 'ALTERAES NAS FEZES/MOV. INTESTINAIS', 'alteracoes nas fezes/mov. intestinais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (75, 'D19', 'SINAIS/SINTOMAS DOS DENTES/GENGIVAS', 'sinais/sintomas dos dentes/gengivas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (76, 'D20', 'SINAIS/SINTOMAS DA BOCA/LNGUA/LBIOS', 'sinais/sintomas da boca/lingua/labios', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (77, 'D21', 'PROBLEMAS DE DEGLUTIO', 'problemas de degluticao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (78, 'D23', 'HEPATOMEGALIA', 'hepatomegalia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (79, 'D24', 'MASSA ABDOMINAL NE', 'massa abdominal ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (80, 'D25', 'DISTENSO ABDOMINAL', 'distensao abdominal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (81, 'D26', 'MEDO DE CNCER NO APARELHO DIGESTIVO', 'medo de cancer no aparelho digestivo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (82, 'D27', 'MEDO DE OUTRAS DOENAS APARELHO DIGESTIVO', 'medo de outras doencas aparelho digestivo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (83, 'D28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (84, 'D29', 'OUTROS SINAIS/SINTOMAS DIGESTIVOS', 'outros sinais/sintomas digestivos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (85, 'D70', 'INFECO GASTROINTESTINAL', 'infeccao gastrointestinal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (86, 'D71', 'CAXUMBA/PAROTIDITE EPIDMICA', 'caxumba/parotidite epidemica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (87, 'D72', 'HEPATITE VIRAL', 'hepatite viral', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (88, 'D73', 'GASTROENTERITE, PRESUMVEL INFECO', 'gastroenterite, presumivel infeccao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (89, '49', 'OUTROS PROCEDIMENTOS PREVENTIVOS', 'outros procedimentos preventivos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (90, 'R24', 'HEMOPTISE', 'hemoptise', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (91, 'S20', 'CALOS/CALOSIDADES', 'calos/calosidades', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (92, 'Y82', 'HIPOSPDIAS', 'hipospadias', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (93, '30', 'EXAME MDICO/AVALIAO DE SADE - COMPLETO', 'exame medico/avaliacao de saude - completo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (94, '31', 'EXAME MDICO/AVALIAO DE  SADE - PARCIAL', 'exame medico/avaliacao de  saude - parcial', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (95, '32', 'TESTE DE SENSIBILIDADE', 'teste de sensibilidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (96, '33', 'EXAME MICROBIOLGICO/IMUNOLGICO', 'exame microbiologico/imunologico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (97, '34', 'ANLISE DE SANGUE', 'analise de sangue', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (98, '35', 'ANLISE DE URINA', 'analise de urina', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (99, '36', 'ANLISE DE FEZES', 'analise de fezes', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (100, '37', 'CITOLOGIA ESFOLIATIVA/HISTOLOGIA', 'citologia esfoliativa/histologia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (101, '38', 'OUTRAS ANLISES LABORATORIAIS NE', 'outras analises laboratoriais ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (102, '39', 'TESTE DE FUNO FSICA', 'teste de funcao fisica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (103, '40', 'ENDOSCOPIA DIAGNSTICA', 'endoscopia diagnostica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (104, '41', 'RADIOLOGIA DIAGNSTICA', 'radiologia diagnostica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (105, '42', 'ELETROCARDIOGRAMA', 'eletrocardiograma', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (106, '43', 'OUTROS PROCEDIMENTOS DIAGNSTICOS', 'outros procedimentos diagnosticos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (107, '44', 'VACINAO/MEDICAO PREVENTIVA', 'vacinacao/medicacao preventiva', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (108, '45', 'EDUCAO EM SADE/ACONSELHAMENTO/DIETA', 'educacao em saude/aconselhamento/dieta', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (109, '46', 'CONSULTA COM PROFISSIONAL DE APS', 'consulta com profissional de aps', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (110, '47', 'CONSULTA COM ESPECIALISTA', 'consulta com especialista', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (111, '48', 'ESCLARECIMENTO/DISCUSSO DO MOTIVO DA CONSULTA', 'esclarecimento/discussao do motivo da consulta', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (112, '50', 'MEDICAO/PRESCRIO/RENOVAO/ INJEO', 'medicacao/prescricao/renovacao/ injecao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (113, '51', 'INCISO/DRENAGEM/ASPIRAO/REMOO', 'incisao/drenagem/aspiracao/remocao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (114, '52', 'EXCISO /BIOPSIA/REMOO/DEBRIDAMENTO/CAUTERIZAO', 'excisao /biopsia/remocao/debridamento/cauterizacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (115, '53', 'CATETERIZAO/INTUBAO', 'cateterizacao/intubacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (116, '54', 'REPARAO/SUTURA/GESSO/PRTESE', 'reparacao/sutura/gesso/protese', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (117, '55', 'INJEO LOCAL /INFILTRAO', 'injecao local /infiltracao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (118, '56', 'LIGADURA/COMPRESSA /TAMPONAMENTO', 'ligadura/compressa /tamponamento', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (120, '58', 'ACONSELHAMENTO/ESCUTA TERAPUTICA', 'aconselhamento/escuta terapeutica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (121, '59', 'OUTROS PROCEDIMENTOS TERAPUTICOS/PEQUENA CIRURGIA NE', 'outros procedimentos terapeuticos/pequena cirurgia ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (122, '60', 'RESULTADOS DE ANLISES/PROCEDIMENTOS', 'resultados de analises/procedimentos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (123, '61', 'CONTRA REFERNCIA DE OUTRO PRESTADOR - RESULTADO DE EXAMES/TESTE/ ANLISE', 'contra referencia de outro prestador - resultado de exames/teste/ analise', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (124, '62', 'PROCEDIMENTO ADMINISTRATIVO', 'procedimento administrativo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (125, '63', 'CONSULTA DE SEGUIMENTO NO ESPECIFICADA', 'consulta de seguimento nao especificada', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (126, '64', 'EPISDIO / PROBLEMA INICIADO PELO PRESTADOR', 'episodio / problema iniciado pelo prestador', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (127, '65', 'EPISDIO / PROBLEMA INICIADO POR OUTRO NE', 'episodio / problema iniciado por outro ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (128, '66', 'REFERENCIADO A OUTRO PRESTADOR /ENFERMEIRO /ASSISTENTE SOCIAL/TERAPEUTA', 'referenciado a outro prestador /enfermeiro /assistente social/terapeuta', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (129, '67', 'REFERENCIADO PARA MDICO/ESPECIALISTA/CLNICA/HOSPITAL', 'referenciado para medico/especialista/clinica/hospital', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (130, '68', 'OUTRAS REFERENCIAES NE', 'outras referenciacoes ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (131, '69', 'OUTRO MOTIVO DE CONSULTA NE', 'outro motivo de consulta ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (132, 'A01', 'DOR GENERALIZADA /MLTIPLA', 'dor generalizada /multipla', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (133, 'A02', 'ARREPIOS/ CALAFRIOS', 'arrepios/ calafrios', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (134, 'A03', 'FEBRE', 'febre', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (135, 'A04', 'DEBILIDADE/CANSAO GERAL/FADIGA', 'debilidade/cansaco geral/fadiga', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (136, 'A05', 'SENTIR-SE DOENTE', 'sentir-se doente', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (137, 'A06', 'DESMAIO/SNCOPE', 'desmaio/sincope', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (138, 'A07', 'COMA', 'coma', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (140, 'A09', 'PROBLEMAS DE SUDORESE', 'problemas de sudorese', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (141, 'A10', 'SANGRAMENTO/HEMORRAGIA NE', 'sangramento/hemorragia ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (142, 'A11', 'DORES TORCICAS NE', 'dores toracicas ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (143, 'A13', 'RECEIO/MEDO DO TRATAMENTO', 'receio/medo do tratamento', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (144, 'A16', 'CRIANA IRRITVEL', 'crianca irritavel', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (145, 'A18', 'PREOCUPAO COM APARNCIA', 'preocupacao com aparencia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (146, 'A20', 'PEDIDO/DISCUSSO EUTANSIA', 'pedido/discussao eutanasia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (147, 'A21', 'FATOR DE RISCO DE MALIGNIDADE', 'fator de risco de malignidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (148, 'A23', 'FATOR DE RISCO NE', 'fator de risco ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (149, 'A25', 'MEDO DE MORRER/MEDO DA MORTE', 'medo de morrer/medo da morte', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (150, 'A26', 'MEDO DE CNCER NE', 'medo de cancer ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (151, 'A27', 'MEDO DE OUTRA DOENA NE', 'medo de outra doenca ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (152, 'A28', 'LIMITAO FUNCIONAL/INCAPACIDADE NE', 'limitacao funcional/incapacidade ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (153, 'A29', 'OUTROS SINAIS/SINTOMAS GERAIS', 'outros sinais/sintomas gerais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (155, 'D10', 'VOMITO', 'vomito', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (156, 'A94', 'MORBIDADE PERINATAL, OUTRA', 'morbidade perinatal, outra', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (157, 'A95', 'MORTALIDADE PERINATAL', 'mortalidade perinatal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (158, 'A96', 'MORTE', 'morte', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (159, 'A71', 'SARAMPO', 'sarampo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (160, 'A72', 'VARICELA', 'varicela', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (161, 'A73', 'MALRIA', 'malaria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (162, 'A74', 'RUBOLA', 'rubeola', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (163, 'A75', 'MONONUCLEOSE INFECCIOSA', 'mononucleose infecciosa', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (164, 'A76', 'OUTRO EXANTEMA VIRAL', 'outro exantema viral', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (167, 'A79', 'CARCINOMATOSE (LOCALIZAO PRIMRIA DESCONHECIDA)', 'carcinomatose (localizacao primaria desconhecida)', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (168, 'A80', 'LESO TRAUMTICA/ACIDENTE NE', 'lesao traumatica/acidente ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (169, 'A81', 'POLITRAUMATISMOS/FERIMENTOS MLTIPLOS', 'politraumatismos/ferimentos multiplos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (170, 'A82', 'EFEITO SECUNDRIO DE LESO TRAUMTICA', 'efeito secundario de lesao traumatica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (171, 'A84', 'INTOXICAO POR MEDICAMENTO', 'intoxicacao por medicamento', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (172, 'A85', 'EFEITO ADVERSO DE FRMACO DOSE CORRETA', 'efeito adverso de farmaco dose correta', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (173, 'A86', 'EFEITO TXICO DE SUBSTNCIA NO MEDICINAL', 'efeito toxico de substancia nao medicinal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (174, 'A87', 'COMPLICAES DE TRATAMENTO MDICO', 'complicacoes de tratamento medico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (1, 'A88', 'EFEITO ADVERSO DE FATOR FSICO', 'efeito adverso de fator fisico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (2, 'A89', 'EFEITO DA PRTESE', 'efeito da protese', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (3, 'A90', 'MALFORMAO CONGNITA NE/MLTIPLAS', 'malformacao congenita ne/multiplas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (4, 'A91', 'INVESTIGAO COM RESULTADO ANORMAL NE', 'investigacao com resultado anormal ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (5, 'A92', 'ALERGIA/REAO ALRGICA NE', 'alergia/reacao alergica ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (6, 'A93', 'RECM NASCIDO PREMATURO', 'recem nascido prematuro', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (7, 'D09', 'NUSEA', 'nausea', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (8, 'A97', 'SEM DOENA', 'sem doenca', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (9, 'A98', 'MEDICINA PREVENTIVA/MANUTENO DA SADE', 'medicina preventiva/manutencao da saude', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (10, 'A99', 'OUTRAS DOENAS GERAIS NE', 'outras doencas gerais ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (11, 'B02', 'GNGLIO LINFTICO AUMENTADO/DOLOROSO', 'ganglio linfatico aumentado/doloroso', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (12, 'B04', 'SINAIS/SINTOMAS SANGUE', 'sinais/sintomas sangue', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (13, 'B25', 'MEDO DE VIH/ HIV/SIDA/ AIDS', 'medo de vih/ hiv/sida/ aids', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (14, 'B26', 'MEDO DE CNCER NO SANGUE/LINFTICO', 'medo de cancer no sangue/linfatico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (15, 'B27', 'MEDO DE OUTRAS DOENAS DO SANGUE /VASOS LINFTICOS', 'medo de outras doencas do sangue /vasos linfaticos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (16, 'B28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (17, 'B29', 'OUTROS SINAIS/ SINTOMAS DO SANGUE/ SISTEMA LINFTICO/ BAO NE', 'outros sinais/ sintomas do sangue/ sistema linfatico/ baco ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (18, 'B70', 'LINFADENITE AGUDA', 'linfadenite aguda', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (19, 'B71', 'LINFADENITE CRNICA NE', 'linfadenite cronica ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (20, 'B72', 'DOENA DE HODGKIN/LINFOMAS', 'doenca de hodgkin/linfomas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (21, 'B73', 'LEUCEMIA', 'leucemia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (22, 'B74', 'OUTRA NEOPLASIA MALIGNA NO SANGUE', 'outra neoplasia maligna no sangue', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (23, 'B75', 'NEOPLASIA BENIGNA NE', 'neoplasia benigna ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (24, 'B76', 'ROTURA TRAUMTICA DO BAO', 'rotura traumatica do baco', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (25, 'B77', 'OUTRAS LESES TRAUMTICAS DO SANGUE/LINFA/BAO', 'outras lesoes traumaticas do sangue/linfa/baco', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (26, 'B78', 'ANEMIA HEMOLTICA HEREDITRIA', 'anemia hemolitica hereditaria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (27, 'B79', 'OUTRA MALFORMAO CONGNITA DO SANGUE/LINFTICA', 'outra malformacao congenita do sangue/linfatica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (28, 'B80', 'ANEMIA POR DEFICINCIA FERRO', 'anemia por deficiencia ferro', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (195, 'L07', 'SINAIS/SINTOMAS DA MANDBULA', 'sinais/sintomas da mandibula', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (196, 'L08', 'SINAIS/SINTOMAS DOS OMBROS', 'sinais/sintomas dos ombros', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (197, 'L09', 'SINAIS/SINTOMAS DOS BRAOS', 'sinais/sintomas dos bracos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (198, 'L10', 'SINAIS/SINTOMAS DOS COTOVELOS', 'sinais/sintomas dos cotovelos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (199, 'L11', 'SINAIS/SINTOMAS DOS PUNHOS', 'sinais/sintomas dos punhos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (200, 'L12', 'SINAIS/SINTOMAS DAS MOS E DEDOS', 'sinais/sintomas das maos e dedos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (201, 'L13', 'SINAIS/SINTOMAS DO QUADRIL', 'sinais/sintomas do quadril', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (202, 'L14', 'SINAIS/SINTOMAS DA COXA/PERNA', 'sinais/sintomas da coxa/perna', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (203, 'L15', 'SINAIS/SINTOMAS DO JOELHO', 'sinais/sintomas do joelho', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (204, 'L18', 'DORES MUSCULARES', 'dores musculares', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (205, 'L19', 'SINAIS/SINTOMAS MUSCULARES NE', 'sinais/sintomas musculares ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (206, 'L20', 'SINAIS/SINTOMAS DAS ARTICULAES NE', 'sinais/sintomas das articulacoes ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (207, 'L26', 'MEDO DE CNCER NO APARELHO MSCULO-ESQUELTICO', 'medo de cancer no aparelho musculo-esqueletico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (208, 'L27', 'MEDO DE DOENA NO APARELHO MSCULO-ESQUELTICO, OUTRO', 'medo de doenca no aparelho musculo-esqueletico, outro', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (209, 'L28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (210, 'L29', 'OUTROS SINAIS/SINTOMAS DO APARELHO MSCULO-ESQUELTICO', 'outros sinais/sintomas do aparelho musculo-esqueletico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (211, 'L70', 'INFECES DO APARELHO MSCULO-ESQUELTICO', 'infeccoes do aparelho musculo-esqueletico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (212, 'L71', 'NEOPLASIA MALIGNA DO APARELHO MSCULO-ESQUELTICO', 'neoplasia maligna do aparelho musculo-esqueletico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (213, 'L72', 'FRATURA: RDIO/CBITO', 'fratura: radio/cubito', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (214, 'L73', 'FRATURA: TBIA/PERNIO/ FBULA', 'fratura: tibia/peronio/ fibula', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (215, 'L74', 'FRATURA: OSSO DA MO/P', 'fratura: osso da mao/pe', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (216, 'L75', 'FRATURA: FMUR', 'fratura: femur', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (217, 'L76', 'OUTRAS FRATURAS', 'outras fraturas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (218, 'L77', 'ENTORSES E DISTENSES DO TORNOZELO', 'entorses e distensoes do tornozelo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (219, 'L78', 'ENTORSES E DISTENSES DO JOELHO', 'entorses e distensoes do joelho', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (220, 'L79', 'ENTORSES E DISTENSES DAS ARTICULAES NE', 'entorses e distensoes das articulacoes ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (221, 'L80', 'LUXAO/SUBLUXAO', 'luxacao/subluxacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (222, 'L81', 'TRAUMATISMOS DO APARELHO MUSCULOESQUELTICO NE', 'traumatismos do aparelho musculoesqueletico ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (223, 'L82', 'MALFORMAES CONGNITAS DO APARELHO MSCULO-ESQUELTICO', 'malformacoes congenitas do aparelho musculo-esqueletico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (224, 'L83', 'DOENAS OU SNDROMES DA COLUNA CERVICAL', 'doencas ou sindromes da coluna cervical', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (278, 'P01', 'SENSAO DE ANSIEDADE/NERVOSISMO/TENSO', 'sensacao de ansiedade/nervosismo/tensao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (279, 'P02', 'REAO AGUDA AO ESTRESSE', 'reacao aguda ao estresse', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (280, 'P03', 'TRISTEZA/ SENSAO DE DEPRESSO', 'tristeza/ sensacao de depressao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (281, 'P04', 'SENTIR/COMPORTAR-SE DE FORMA IRRITVEL/ZANGADA', 'sentir/comportar-se de forma irritavel/zangada', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (282, 'P05', 'SENSAO/COMPORTAMENTO SENIL', 'sensacao/comportamento senil', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (283, 'P06', 'PERTURBAO DO SONO', 'perturbacao do sono', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (284, 'P07', 'DIMINUIO DO DESEJO SEXUAL', 'diminuicao do desejo sexual', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (285, 'R25', 'EXPECTORAO/MUCOSIDADE ANORMAL', 'expectoracao/mucosidade anormal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (286, 'P08', 'DIMINUIO DA SATISFAO SEXUAL', 'diminuicao da satisfacao sexual', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (287, 'P09', 'PREOCUPAO COM A PREFERNCIA SEXUAL', 'preocupacao com a preferencia sexual', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (288, 'P10', 'GAGUEJAR/BALBUCIAR/TIQUES', 'gaguejar/balbuciar/tiques', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (289, 'P11', 'PROBLEMAS DE ALIMENTAO DA CRIANA', 'problemas de alimentacao da crianca', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (290, 'P12', 'MOLHAR A CAMA/ENURESE', 'molhar a cama/enurese', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (291, 'P13', 'ENCOPRESE/OUTROS PROBLEMAS DE INCONTINNCIA FECAL', 'encoprese/outros problemas de incontinencia fecal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (292, 'P15', 'ABUSO CRNICO DE LCOOL', 'abuso cronico de alcool', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (294, 'D95', 'FISSURA ANAL / ABCESSO PERIANAL', 'fissura anal / abcesso perianal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (295, 'D96', 'LOMBRIGAS /OUTROS PARASITAS', 'lombrigas /outros parasitas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (296, 'D97', 'DOENAS DO FGADO /NE', 'doencas do figado /ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (297, 'D98', 'COLECISTITE, COLELITIASE', 'colecistite, colelitiase', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (298, 'D99', 'OUTRA DOENA DO APARELHO DIGESTIVO', 'outra doenca do aparelho digestivo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (299, 'F01', 'DOR NO OLHO', 'dor no olho', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (300, 'F02', 'OLHO VERMELHO', 'olho vermelho', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (301, 'F03', 'SECREO OCULAR', 'secrecao ocular', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (302, 'F04', 'MOSCAS VOLANTES/PONTOS LUMINOSOS/ESCOTOMAS/ MANCHAS', 'moscas volantes/pontos luminosos/escotomas/ manchas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (303, 'F05', 'OUTRAS PERTURBAES VISUAIS', 'outras perturbacoes visuais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (304, 'F13', 'SENSAES OCULARES ANORMAIS', 'sensacoes oculares anormais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (305, 'F14', 'MOVIMENTOS OCULARES ANORMAIS', 'movimentos oculares anormais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (306, 'F15', 'APARNCIA ANORMAL NOS OLHOS', 'aparencia anormal nos olhos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (307, 'F16', 'SINAIS/SINTOMAS DAS PLPEBRAS', 'sinais/sintomas das palpebras', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (308, 'F17', 'SINAIS/SINTOMAS RELACIONADOS A CULOS', 'sinais/sintomas relacionados a oculos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (309, 'F18', 'SINAIS/SINTOMAS RELACIONADOS A LENTES DE CONTATO', 'sinais/sintomas relacionados a lentes de contato', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (310, 'F27', 'MEDO DE DOENA OCULAR', 'medo de doenca ocular', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (311, 'F28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (312, 'F29', 'OUTROS SINAIS/SINTOMAS OCULARES', 'outros sinais/sintomas oculares', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (313, 'F70', 'CONJUNTIVITE INFECCIOSA', 'conjuntivite infecciosa', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (314, 'F71', 'CONJUNTIVITE ALRGICA', 'conjuntivite alergica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (315, 'H86', 'SURDEZ', 'surdez', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (316, 'F73', 'OUTRAS INFECES/INFLAMAES OCULARES', 'outras infeccoes/inflamacoes oculares', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (317, 'F74', 'NEOPLASIA DO OLHO/ANEXOS', 'neoplasia do olho/anexos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (318, 'F75', 'CONTUSO/HEMORRAGIA OCULAR', 'contusao/hemorragia ocular', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (319, 'F76', 'CORPO ESTRANHO OCULAR', 'corpo estranho ocular', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (320, 'F79', 'OUTRAS LESES TRAUMTICAS OCULARES', 'outras lesoes traumaticas oculares', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (321, 'F80', 'OBSTRUO CANAL LACRIMAL DA CRIANA', 'obstrucao canal lacrimal da crianca', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (322, 'F81', 'OUTRAS MALFORMAES CONGNITAS DO OLHO', 'outras malformacoes congenitas do olho', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (323, 'F82', 'DESCOLAMENTO DA RETINA', 'descolamento da retina', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (324, 'F83', 'RETINOPATIA', 'retinopatia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (325, 'F84', 'DEGENERAO MACULAR', 'degeneracao macular', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (326, 'F85', 'ULCERA DA CRNEA', 'ulcera da cornea', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (327, 'F86', 'TRACOMA', 'tracoma', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (328, 'F91', 'ERRO DE REFRAO', 'erro de refracao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (329, 'F92', 'CATARATA', 'catarata', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (330, 'F93', 'GLAUCOMA', 'glaucoma', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (331, 'F94', 'CEGUEIRA', 'cegueira', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (332, 'F95', 'ESTRABISMO', 'estrabismo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (333, 'F99', 'OUTRA DOENAS OCULARES/ANEXOS', 'outra doencas oculares/anexos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (334, 'H01', 'DOR DE OUVIDOS', 'dor de ouvidos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (335, 'H02', 'PROBLEMAS DE AUDIO', 'problemas de audicao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (336, 'H03', 'ACUFENO, ZUMBIDOS, RUDO, ASSOBIOS', 'acufeno, zumbidos, ruido, assobios', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (337, 'H04', 'SECREO NO OUVIDO', 'secrecao no ouvido', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (442, 'S91', 'PSORASE', 'psoriase', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (338, 'H05', 'HEMORRAGIA NO OUVIDO', 'hemorragia no ouvido', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (339, 'H13', 'SENSAO DE OUVIDO TAPADO', 'sensacao de ouvido tapado', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (340, 'H15', 'PREOCUPAO COM A APARNCIA DAS ORELHAS', 'preocupacao com a aparencia das orelhas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (341, 'N75', 'NEOPLASIA BENIGNA DO SISTEMA NEUROLGICO', 'neoplasia benigna do sistema neurologico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (342, 'H27', 'MEDO DE DOENA DO OUVIDO', 'medo de doenca do ouvido', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (343, 'H28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (344, 'H29', 'OUTROS SINAIS/SINTOMAS OUVIDO', 'outros sinais/sintomas ouvido', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (345, 'H70', 'OTITE EXTERNA', 'otite externa', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (346, 'H71', 'OTITE MEDIA AGUDA/MIRINGITE', 'otite media aguda/miringite', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (347, 'H72', 'OTITE MDIA SEROSA', 'otite media serosa', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (348, 'H73', 'INFECO DA TROMPA DE EUSTQUIO', 'infeccao da trompa de eustaquio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (349, 'H74', 'OTITE MEDIA CRNICA', 'otite media cronica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (350, 'H75', 'NEOPLASIA DO OUVIDO', 'neoplasia do ouvido', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (351, 'H76', 'CORPO ESTRANHO DO OUVIDO', 'corpo estranho do ouvido', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (352, 'H77', 'PERFURAO DO TMPANO', 'perfuracao do timpano', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (354, 'H79', 'OUTROS TRAUMATISMOS DO OUVIDO', 'outros traumatismos do ouvido', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (355, 'H80', 'MALFORMAES CONGNITAS DO OUVIDO', 'malformacoes congenitas do ouvido', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (356, 'H81', 'CERMEN NO OUVIDO EM EXCESSO', 'cerumen no ouvido em excesso', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (357, 'H82', 'SNDROME VERTIGINOSA', 'sindrome vertiginosa', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (358, 'H83', 'OTOESCLEROSE', 'otoesclerose', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (359, 'H84', 'PRESBIACUSIA', 'presbiacusia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (360, 'H85', 'LESO ACSTICA', 'lesao acustica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (361, 'H99', 'OUTRA DOENA DO OUVIDO/MASTIDE', 'outra doenca do ouvido/mastoide', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (362, 'K01', 'DOR ATRIBUDA AO CORAO', 'dor atribuida ao coracao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (363, 'K02', 'SENSAO DE PRESSO/APERTO ATRIBUDA AO CORAO', 'sensacao de pressao/aperto atribuida ao coracao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (364, 'K03', 'DORES ATRIBUDAS AO APARELHO CIRCULATRIO NE', 'dores atribuidas ao aparelho circulatorio ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (580, 'R88', 'OUTRA LESO RESPIRATRIA', 'outra lesao respiratoria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (581, 'R89', 'MALFORMAO CONGNITA DO APARELHO RESPIRATRIO', 'malformacao congenita do aparelho respiratorio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (390, 'R90', 'HIPERTROFIA DAS AMGDALAS/ADENIDES', 'hipertrofia das amigdalas/adenoides', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (391, 'R92', 'NEOPLASIA RESPIRATRIA NE', 'neoplasia respiratoria ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (394, 'R97', 'RINITE ALRGICA', 'rinite alergica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (395, 'R98', 'SNDROME DE HIPERVENTILAO', 'sindrome de hiperventilacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (396, 'R99', 'OUTRAS DOENAS RESPIRATRIAS', 'outras doencas respiratorias', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (397, 'S01', 'DOR/SENSIBILIDADE DOLOROSA DA PELE', 'dor/sensibilidade dolorosa da pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (398, 'S02', 'PRURIDO', 'prurido', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (399, 'S03', 'VERRUGAS', 'verrugas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (400, 'S04', 'TUMOR/INCHAO LOCALIZADO', 'tumor/inchaco localizado', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (401, 'S05', 'TUMORES/INCHAOS GENERALIZADOS', 'tumores/inchacos generalizados', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (402, 'S06', 'ERUPO CUTNEA LOCALIZADA', 'erupcao cutanea localizada', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (403, 'S07', 'ERUPO CUTNEA GENERALIZADA', 'erupcao cutanea generalizada', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (404, 'S08', 'ALTERAES DA COR DA PELE', 'alteracoes da cor da pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (405, 'S09', 'INFECO DOS DEDOS DAS MOS/PS', 'infeccao dos dedos das maos/pes', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (406, 'S10', 'FURNCULO/CARBNCULO', 'furunculo/carbunculo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (407, 'S11', 'INFECO PS-TRAUMTICA DA PELE', 'infeccao pos-traumatica da pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (408, 'S16', 'TRAUMATISMO/CONTUSO', 'traumatismo/contusao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (409, 'S17', 'ABRASO/ARRANHO/BOLHAS', 'abrasao/arranhao/bolhas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (410, 'S18', 'LACERAO/CORTE', 'laceracao/corte', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (411, 'S19', 'OUTRA LESO CUTNEA', 'outra lesao cutanea', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (412, 'S21', 'SINAIS/SINTOMAS DA TEXTURA DA PELE', 'sinais/sintomas da textura da pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (413, 'S22', 'SINAIS/SINTOMAS DAS UNHAS', 'sinais/sintomas das unhas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (414, 'S23', 'QUEDA DE CABELO/CALVCIE', 'queda de cabelo/calvicie', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (415, 'S24', 'SINAIS/SINTOMAS DO CABELO/COURO CABELUDO', 'sinais/sintomas do cabelo/couro cabeludo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (416, 'S26', 'MEDO DE CNCER DE PELE', 'medo de cancer de pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (417, 'S27', 'MEDO DE OUTRA DOENA DA PELE', 'medo de outra doenca da pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (418, 'S28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (419, 'S29', 'SINAIS/SINTOMAS DA PELE, OUTROS', 'sinais/sintomas da pele, outros', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (420, 'S70', 'HERPES ZOSTER', 'herpes zoster', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (421, 'S71', 'HERPES SIMPLES', 'herpes simples', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (422, 'S72', 'ESCABIOSE/OUTRAS ACARASES', 'escabiose/outras acariases', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (423, 'S73', 'PEDICULOSE/OUTRAS INFECES DA PELE', 'pediculose/outras infeccoes da pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (424, 'S74', 'DERMATOFITOSE', 'dermatofitose', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (425, 'S75', 'MONILASE ORAL/CANDIDASE NA PELE', 'moniliase oral/candidiase na pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (426, 'S76', 'OUTRAS INFECES DA PELE', 'outras infeccoes da pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (427, 'S77', 'NEOPLASIAS MALIGNAS DA PELE', 'neoplasias malignas da pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (428, 'S78', 'LIPOMA', 'lipoma', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (429, 'S79', 'NEOPLASIA CUTNEA BENIGNA/INCERTA', 'neoplasia cutanea benigna/incerta', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (430, 'S80', 'CERATOSE/ QUERATOSE SOLAR/QUEIMADURA SOLAR', 'ceratose/ queratose solar/queimadura solar', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (431, 'S81', 'HEMANGIOMA/LINFANGIOMA', 'hemangioma/linfangioma', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (432, 'S82', 'NEVOS/SINAIS DA PELE', 'nevos/sinais da pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (433, 'S83', 'LESES DA PELE CONGNITAS, OUTRAS', 'lesoes da pele congenitas, outras', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (434, 'S84', 'IMPETIGO', 'impetigo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (435, 'S85', 'CISTO PILONIDAL/FISTULA', 'cisto pilonidal/fistula', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (436, 'S86', 'DERMATITE SEBORREICA', 'dermatite seborreica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (437, 'S87', 'DERMATITE/ECZEMA ATPICO', 'dermatite/eczema atopico', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (438, 'T86', 'HIPOTIROIDISMO/MIXEDEMA', 'hipotiroidismo/mixedema', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (439, 'S88', 'DERMATITE DE CONTATO/ALRGICA', 'dermatite de contato/alergica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (440, 'S89', 'DERMATITE DAS FRALDAS', 'dermatite das fraldas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (441, 'S90', 'PITIRASE ROSADA', 'pitiriase rosada', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (443, 'S92', 'DOENA DAS GLNDULAS SUDORPARAS', 'doenca das glandulas sudoriparas', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (444, 'S93', 'CISTO SEBCEO', 'cisto sebaceo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (445, 'S94', 'UNHA ENCRAVADA', 'unha encravada', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (446, 'S95', 'MOLUSCO CONTAGIOSO', 'molusco contagioso', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (447, 'S96', 'ACNE', 'acne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (448, 'S97', 'LCERA CRNICA DA PELE', 'ulcera cronica da pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (449, 'S98', 'URTICRIA', 'urticaria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (450, 'S99', 'OUTRAS DOENAS DA PELE', 'outras doencas da pele', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (451, 'T01', 'SEDE EXCESSIVA', 'sede excessiva', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (452, 'T02', 'APETITE EXCESSIVO', 'apetite excessivo', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (453, 'T03', 'PERDA DE APETITE', 'perda de apetite', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (454, 'T04', 'PROBLEMAS ALIMENTARES DE LACTENTE/CRIANA', 'problemas alimentares de lactente/crianca', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (455, 'T05', 'PROBLEMAS ALIMENTARES DO ADULTO', 'problemas alimentares do adulto', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (456, 'T07', 'AUMENTO DE PESO', 'aumento de peso', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (457, 'T08', 'PERDA DE PESO', 'perda de peso', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (458, 'T10', 'ATRASO DO CRESCIMENTO', 'atraso do crescimento', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (459, 'T11', 'DESIDRATAO', 'desidratacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (460, 'T26', 'MEDO DE CNCER DO SISTEMA ENDCRINO', 'medo de cancer do sistema endocrino', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (461, 'U29', 'SINAIS/SINTOMAS APARELHO URINRIO, OUTROS', 'sinais/sintomas aparelho urinario, outros', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (462, 'T27', 'MEDO DE OUTRA DOENA ENDCRINA/METABLICA', 'medo de outra doenca endocrina/metabolica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (463, 'T28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (464, 'T29', 'SINAIS/SINTOMAS ENDOCRINOLGICOS/METABOLICOS/NUTRICIONAIS, OUTROS', 'sinais/sintomas endocrinologicos/metabolicos/nutricionais, outros', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (465, 'T70', 'INFECO ENDCRINA', 'infeccao endocrina', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (466, 'T71', 'NEOPLASIA MALIGNA DA TIRIDE', 'neoplasia maligna da tiroide', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (467, 'T72', 'NEOPLASIA BENIGNA DA TIRIDE', 'neoplasia benigna da tiroide', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (468, 'T73', 'OUTRA NEOPLASIA ENDCRINA NE', 'outra neoplasia endocrina ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (469, 'T78', 'CISTO DO CANAL TIROGLOSSO', 'cisto do canal tiroglosso', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (470, 'T80', 'MALFORMAO CONGNITA ENDCRINA/METABLICA', 'malformacao congenita endocrina/metabolica', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (471, 'T81', 'BCIO', 'bocio', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (473, 'T83', 'EXCESSO DE PESO', 'excesso de peso', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (474, 'T85', 'HIPERTIROIDISMO/TIREOTOXICOSE', 'hipertiroidismo/tireotoxicose', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (475, 'T87', 'HIPOGLICEMIA', 'hipoglicemia', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (476, 'T89', 'DIABETES INSULINO-DEPENDENTE', 'diabetes insulino-dependente', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (479, 'T92', 'GOTA', 'gota', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (480, 'T93', 'ALTERAO NO METABOLISMO DOS LPIDOS', 'alteracao no metabolismo dos lipidos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (481, 'T99', 'OUTRAS DOENAS ENDOCRINOLGICA/METABLICA/NUTRICIONAIS', 'outras doencas endocrinologica/metabolica/nutricionais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (482, 'U01', 'DISRIA/MICO DOLOROSA', 'disuria/miccao dolorosa', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (483, 'U02', 'MICO FREQUENTE/URGNCIA URINRIA/ POLACIRIA', 'miccao frequente/urgencia urinaria/ polaciuria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (484, 'U04', 'INCONTINNCIA URINRIA', 'incontinencia urinaria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (485, 'U05', 'OUTROS PROBLEMAS COM A MICO', 'outros problemas com a miccao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (486, 'U06', 'HEMATRIA', 'hematuria', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (605, 'Z13', 'PROBLEMA COMPORTAMENTAL DO PARCEIRO/  COMPANHEIRO', 'problema comportamental do parceiro/  companheiro', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (606, 'Z14', 'PROBLEMA POR DOENA DO PARCEIRO/ COMPANHEIRO', 'problema por doenca do parceiro/ companheiro', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (607, 'Z15', 'PERDA OU FALECIMENTO DO PARCEIRO/ COMPANHEIRO', 'perda ou falecimento do parceiro/ companheiro', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (608, 'Z16', 'PROBLEMA DE RELACIONAMENTO COM CRIANA', 'problema de relacionamento com crianca', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (609, 'Z18', 'PROBLEMA COM CRIANA DOENTE', 'problema com crianca doente', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (610, 'Z19', 'PERDA OU FALECIMENTO DE CRIANA', 'perda ou falecimento de crianca', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (611, 'Z20', 'PROBLEMA DE RELACIONAMENTO COM FAMILIARES', 'problema de relacionamento com familiares', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (612, 'Z21', 'PROBLEMA COMPORTAMENTAL DE FAMILIAR', 'problema comportamental de familiar', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (613, 'Z22', 'PROBLEMA POR DOENA FAMILIAR', 'problema por doenca familiar', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (614, 'Z23', 'PERDA/FALECIMENTO DE FAMILIAR', 'perda/falecimento de familiar', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (615, 'Z24', 'PROBLEMA DE RELACIONAMENTO COM AMIGOS', 'problema de relacionamento com amigos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (616, 'Z25', 'ATO OU ACONTECIMENTO VIOLENTO', 'ato ou acontecimento violento', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (617, 'Z27', 'MEDO DE PROBLEMA SOCIAL', 'medo de problema social', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (618, 'Z28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (619, 'Z29', 'PROBLEMA SOCIAL NE', 'problema social ne', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (620, 'W15', 'INFERTILIDADE/SUBFERTILDADE', 'infertilidade/subfertildade', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (621, 'W17', 'HEMORRAGIA PS-PARTO', 'hemorragia pos-parto', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (623, 'W19', 'SINAIS/SINTOMAS DA MAMA/LACTAO', 'sinais/sintomas da mama/lactacao', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (624, 'W21', 'PREOCUPAO COM A IMAGEM CORPORAL NA GRAVIDEZ', 'preocupacao com a imagem corporal na gravidez', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (625, 'W27', 'MEDO DE COMPLICAES NA GRAVIDEZ', 'medo de complicacoes na gravidez', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (626, 'W28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (627, 'W29', 'SINAIS/SINTOMAS DA GRAVIDEZ, OUTROS', 'sinais/sintomas da gravidez, outros', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (628, 'W70', 'SEPSIS/INFECO PUERPERAL', 'sepsis/infeccao puerperal', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (629, 'W71', 'INFECES QUE COMPLICAM A GRAVIDEZ', 'infeccoes que complicam a gravidez', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (630, 'W72', 'NEOPLASIA MALIGNA RELACIONADA COM GRAVIDEZ', 'neoplasia maligna relacionada com gravidez', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (631, 'W73', 'NEOPLASIA BENIGNA/INCERTA RELACIONADA COM A GRAVIDEZ', 'neoplasia benigna/incerta relacionada com a gravidez', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (632, 'W75', 'LESES TRAUMTICAS QUE COMPLICAM A GRAVIDEZ', 'lesoes traumaticas que complicam a gravidez', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (633, 'W76', 'MALFORMAO CONGNITA QUE COMPLICA A GRAVIDEZ', 'malformacao congenita que complica a gravidez', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (707, 'Y05', 'SINAIS/SINTOMAS DO ESCROTO/TESTCULOS, OUTROS', 'sinais/sintomas do escroto/testiculos, outros', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (708, 'Y06', 'SINAIS/SINTOMAS DA PRSTATA', 'sinais/sintomas da prostata', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (709, 'Y07', 'IMPOTNCIA NE', 'impotencia ne', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (693, 'X84', 'VAGINITE/VULVITE NE', 'vaginite/vulvite ne', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (710, 'Y08', 'SINAIS/SINTOMAS DA FUNO SEXUAL MASCULINA, OUTROS', 'sinais/sintomas da funcao sexual masculina, outros', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (711, 'Y10', 'INFERTILIDADE/SUBFERTILDADE MASCULINA', 'infertilidade/subfertildade masculina', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (712, 'Y13', 'ESTERILIZAO MASCULINA', 'esterilizacao masculina', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (713, 'Y14', 'PLANEJAMENTO FAMILIAR, OUTROS', 'planejamento familiar, outros', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (714, 'Y16', 'SINAIS/SINTOMAS DA MAMA MASCULINA', 'sinais/sintomas da mama masculina', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (715, 'Y24', 'MEDO DE DISFUNO SEXUAL MASCULINA', 'medo de disfuncao sexual masculina', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (716, 'Y25', 'MEDO DE DOENA SEXUALMENTE TRANSMISSVEL', 'medo de doenca sexualmente transmissivel', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (717, 'Y26', 'MEDO DE CNCER GENITAL MASCULINO', 'medo de cancer genital masculino', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (718, 'Y27', 'MEDO DE DOENA GENITAL MASCULINA, OUTRA', 'medo de doenca genital masculina, outra', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (719, 'Y28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (720, 'Y29', 'SINAIS/SINTOMAS, OUTROS', 'sinais/sintomas, outros', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (721, 'Y70', 'SFILIS MASCULINA', 'sifilis masculina', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (722, 'Y71', 'GONORRIA MASCULINA', 'gonorreia masculina', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (723, 'Y72', 'HERPES GENITAL', 'herpes genital', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (724, 'Y73', 'PROSTATITE/VESICULITE SEMINAL', 'prostatite/vesiculite seminal', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (725, 'Y74', 'ORQUITE/EPIDIDIMITE', 'orquite/epididimite', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (726, 'Y75', 'BALANITE/ BALANOPOSTITE', 'balanite/ balanopostite', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (635, 'W79', 'GRAVIDEZ NO DESEJADA', 'gravidez nao desejada', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (636, 'W80', 'GRAVIDEZ ECTPICA', 'gravidez ectopica', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (637, 'W81', 'TOXEMIA GRAVDICA/ DHEG', 'toxemia gravidica/ dheg', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (638, 'W82', 'ABORTO ESPONTNEO', 'aborto espontaneo', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (641, 'W85', 'DIABETES GESTACIONAL', 'diabetes gestacional', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (642, 'W90', 'PARTO SEM COMPLICAES DE NASCIDO VIVO', 'parto sem complicacoes de nascido vivo', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (643, 'W91', 'PARTO SEM COMPLICAES DE NATIMORTO', 'parto sem complicacoes de natimorto', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (644, 'W92', 'PARTO COM COMPLICAES DE NASCIDO VIVO', 'parto com complicacoes de nascido vivo', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (645, 'W93', 'PARTO COM COMPLICAES DE NATIMORTO', 'parto com complicacoes de natimorto', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (646, 'W94', 'MASTITE PUERPERAL', 'mastite puerperal', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (647, 'W95', 'OUTROS PROBLEMAS DA MAMA DURANTE GRAVIDEZ/PUERPRIO', 'outros problemas da mama durante gravidez/puerperio', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (648, 'W96', 'OUTRAS COMPLICAES DO PUERPRIO', 'outras complicacoes do puerperio', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (649, 'W99', 'OUTROS PROBLEMAS DA GRAVIDEZ/PARTO', 'outros problemas da gravidez/parto', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (650, 'X01', 'DOR GENITAL', 'dor genital', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (651, 'X02', 'DORES MENSTRUAIS', 'dores menstruais', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (652, 'X03', 'DORES INTERMENSTRUAIS', 'dores intermenstruais', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (653, 'X04', 'RELAO SEXUAL DOLOROSA NA MULHER', 'relacao sexual dolorosa na mulher', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (654, 'X05', 'MENSTRUAO ESCASSA/AUSENTE', 'menstruacao escassa/ausente', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (655, 'X06', 'MENSTRUAO EXCESSIVA', 'menstruacao excessiva', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (656, 'X07', 'MENSTRUAO IRREGULAR/FREQUENTE', 'menstruacao irregular/frequente', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (657, 'X08', 'HEMORRAGIA INTERMENSTRUAL', 'hemorragia intermenstrual', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (658, 'X09', 'SINAIS/SINTOMAS PR-MENSTRUAIS', 'sinais/sintomas pre-menstruais', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (659, 'X10', 'DESEJO DE ALTERAR A DATA MENSTRUAO', 'desejo de alterar a data menstruacao', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (660, 'X11', 'SINAIS/SINTOMAS DA MENOPAUSA/ CLIMATRIO', 'sinais/sintomas da menopausa/ climaterio', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (661, 'X12', 'HEMORRAGIA PS-MENOPAUSA', 'hemorragia pos-menopausa', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (662, 'X13', 'HEMORRAGIA PS-COITAL', 'hemorragia pos-coital', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (663, 'X14', 'SECREO VAGINAL', 'secrecao vaginal', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (664, 'X15', 'SINAIS/SINTOMAS DA VAGINA', 'sinais/sintomas da vagina', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (665, 'X16', 'SINAIS/SINTOMAS DA VULVA', 'sinais/sintomas da vulva', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (666, 'X17', 'SINAIS/SINTOMAS DA PLVIS FEMININA', 'sinais/sintomas da pelvis feminina', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (667, 'X18', 'DOR NA MAMA FEMININA', 'dor na mama feminina', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (668, 'X19', 'TUMOR OU NDULO NA MAMA FEMININA', 'tumor ou nodulo na mama feminina', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (669, 'X20', 'SINAIS/SINTOMAS DO MAMILO DA MULHER', 'sinais/sintomas do mamilo da mulher', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (670, 'X21', 'SINAIS/SINTOMAS DA MAMA FEMININA, OUTROS', 'sinais/sintomas da mama feminina, outros', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (671, 'X22', 'PREOCUPAO COM A APARNCIA DA MAMA FEMININA', 'preocupacao com a aparencia da mama feminina', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (672, 'X23', 'MEDO DE DOENA DE TRANSMISSO SEXUAL', 'medo de doenca de transmissao sexual', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (673, 'X24', 'MEDO DE DISFUNO SEXUAL', 'medo de disfuncao sexual', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (674, 'X25', 'MEDO DE CNCER GENITAL', 'medo de cancer genital', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (675, 'X26', 'MEDO DE CNCER NA MAMA', 'medo de cancer na mama', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (676, 'X27', 'MEDO DE OUTRA DOENA GENITAL/MAMA', 'medo de outra doenca genital/mama', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (677, 'X28', 'LIMITAO FUNCIONAL/INCAPACIDADE', 'limitacao funcional/incapacidade', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (678, 'X29', 'SINAIS/SINTOMAS DO APARELHO GENITAL FEMININO, OUTRA', 'sinais/sintomas do aparelho genital feminino, outra', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (679, 'X70', 'SFILIS FEMININA', 'sifilis feminina', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (680, 'X71', 'GONORRIA FEMININA', 'gonorreia feminina', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (681, 'X72', 'CANDIDASE GENITAL FEMININA', 'candidiase genital feminina', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (682, 'X73', 'TRICOMONASE GENITAL FEMININA', 'tricomoniase genital feminina', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (683, 'X74', 'DOENA INFLAMATRIA PLVICA', 'doenca inflamatoria pelvica', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (684, 'X75', 'NEOPLASIA MALIGNA DO COLO', 'neoplasia maligna do colo', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (685, 'X76', 'NEOPLASIA MALIGNA DA MAMA FEMININA', 'neoplasia maligna da mama feminina', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (686, 'X77', 'NEOPLASIA MALIGNA GENITAL FEMININA, OUTRA', 'neoplasia maligna genital feminina, outra', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (687, 'X78', 'FIBROMIOMA UTERINO', 'fibromioma uterino', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (688, 'X79', 'NEOPLASIA BENIGNA DA MAMA FEMININA/ FIBROADENOMA', 'neoplasia benigna da mama feminina/ fibroadenoma', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (689, 'X80', 'NEOPLASIA BENIGNA GENITAL', 'neoplasia benigna genital', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (690, 'X81', 'NEOPLASIA GENITAL FEMININA, OUTRA/NE', 'neoplasia genital feminina, outra/ne', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (691, 'X82', 'LESO TRAUMTICA GENITAL FEMININA', 'lesao traumatica genital feminina', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (692, 'X83', 'MALFORMAES CONGNITAS GENITAIS', 'malformacoes congenitas genitais', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (694, 'X85', 'DOENA DO COLO NE', 'doenca do colo ne', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (695, 'X86', 'ESFREGAO DE PAPANICOLAU/COLPOCITOLOGIA ONCTICA ANORMAL', 'esfregaco de papanicolau/colpocitologia oncotica anormal', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (696, 'X87', 'PROLAPSO UTERO-VAGINAL', 'prolapso utero-vaginal', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (697, 'X88', 'DOENA FIBROCSTICA DA MAMA', 'doenca fibrocistica da mama', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (698, 'X89', 'SNDROME DA TENSO PR-MENSTRUAL', 'sindrome da tensao pre-menstrual', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (699, 'X90', 'HERPES GENITAL FEMININO', 'herpes genital feminino', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (700, 'X91', 'CONDILOMA ACUMINADO FEMININO', 'condiloma acuminado feminino', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (701, 'X92', 'INFECO POR CLAMDIA', 'infeccao por clamidia', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (702, 'X99', 'DOENA GENITAL FEMININA, OUTRA', 'doenca genital feminina, outra', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (703, 'Y01', 'DOR NO PNIS', 'dor no penis', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (704, 'Y02', 'DOR NO ESCROTO/TESTCULOS', 'dor no escroto/testiculos', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (705, 'Y03', 'SECREO URETRAL', 'secrecao uretral', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (706, 'Y04', 'SINAIS/SINTOMAS DO PNIS, OUTROS', 'sinais/sintomas do penis, outros', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (582, 'Y76', 'CONDILOMA ACUMINADO', 'condiloma acuminado', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (583, 'Y77', 'NEOPLASIA MALIGNA DA PRSTATA', 'neoplasia maligna da prostata', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (584, 'Y78', 'NEOPLASIA MALIGNA GENITAL MASCULINA, OUTRA', 'neoplasia maligna genital masculina, outra', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (585, 'Y79', 'NEOPLASIA BENIGNA GENITAL MASCULINA NE', 'neoplasia benigna genital masculina ne', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (586, 'Y80', 'TRAUMATISMO GENITAL MASCULINO, OUTRO', 'traumatismo genital masculino, outro', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (587, 'Y81', 'FIMOSE/PREPCIO REDUNDANTE', 'fimose/prepucio redundante', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (588, 'Y83', 'TESTCULO NO DESCIDO/ CRIPTORQUIDIA/ TESTCULO ECTPICO', 'testiculo nao descido/ criptorquidia/ testiculo ectopico', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (589, 'Y84', 'MALFORMAO GENITAL CONGNITA MASCULINA, OUTRA', 'malformacao genital congenita masculina, outra', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (590, 'Y85', 'HIPERTROFIA BENIGNA DA PRSTATA/ HIPERPLASIA PROSTTICA BENIGNA', 'hipertrofia benigna da prostata/ hiperplasia prostatica benigna', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (591, 'Y86', 'HIDROCELE', 'hidrocele', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (592, 'Y99', 'DOENA GENITAL MASCULINA, OUTRA', 'doenca genital masculina, outra', 0, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (593, 'Z01', 'POBREZA/PROBLEMAS ECONMICOS', 'pobreza/problemas economicos', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (594, 'Z02', 'PROBLEMAS RELACIONADOS A GUA/ALIMENTAO', 'problemas relacionados a agua/alimentacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (595, 'Z03', 'PROBLEMAS DE HABITAO/VIZINHANA', 'problemas de habitacao/vizinhanca', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (596, 'Z04', 'PROBLEMA SOCIO-CULTURAL', 'problema socio-cultural', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (597, 'Z05', 'PROBLEMAS COM CONDIES DE TRABALHO', 'problemas com condicoes de trabalho', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (598, 'Z06', 'PROBLEMAS DE DESEMPREGO', 'problemas de desemprego', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (599, 'Z07', 'PROBLEMAS RELACIONADOS COM EDUCAO', 'problemas relacionados com educacao', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (600, 'Z08', 'PROBLEMA RELACIONADO COM SISTEMA DE SEGURANA SOCIAL', 'problema relacionado com sistema de seguranca social', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (601, 'Z09', 'PROBLEMA DE ORDEM LEGAL', 'problema de ordem legal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (602, 'Z10', 'PROBLEMA RELACIONADO COM SISTEMA DE SADE', 'problema relacionado com sistema de saude', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (603, 'Z11', 'PROBLEMA RELACIONADO COM ESTAR DOENTE', 'problema relacionado com estar doente', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (604, 'Z12', 'PROBLEMA DE RELACIONAMENTO COM PARCEIRO/ CONJUGAL', 'problema de relacionamento com parceiro/ conjugal', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (750, 'ABP025', 'FENDAS OU FISSURAS LBIO PALATAIS', 'fendas ou fissuras labio palatais', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (751, 'ABP026', 'FLUOROSE DENTRIA MODERADA OU SEVERA', 'fluorose dentaria moderada ou severa', 2, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (369, 'K22', 'FATOR DE RISCO PARA DOENA CARDIOVASCULAR', 'fator de risco para doenca cardiovascular', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (178, 'K86', 'HIPERTENSO SEM COMPLICAES', 'hipertensao sem complicacoes', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (518, 'P17', 'ABUSO DO TABACO', 'abuso do tabaco', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (520, 'P19', 'ABUSO DE DROGAS', 'abuso de drogas', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (119, '57', 'MEDICINA FSICA/REABILITAO', 'medicina fisica/reabilitacao', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (154, 'A70', 'TUBERCULOSE', 'tuberculose', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (165, 'A77', 'DENGUE E OUTRAS DOENAS VIRAIS NE', 'dengue e outras doencas virais ne', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (166, 'A78', 'HANSENASE E OUTRAS DOENAS INFECCIOSAS NE', 'hanseniase e outras doencas infecciosas ne', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (293, 'P16', 'ABUSO AGUDO DE LCOOL', 'abuso agudo de alcool', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (392, 'R95', 'DOENA PULMONAR OBSTRUTIVA CRNICA', 'doenca pulmonar obstrutiva cronica', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (393, 'R96', 'ASMA', 'asma', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (472, 'T82', 'OBESIDADE', 'obesidade', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (477, 'T90', 'DIABETES NO INSULINO-DEPENDENTE', 'diabetes nao insulino-dependente', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (478, 'T91', 'DEFICINCIA VITAMNICA/NUTRICIONAL', 'deficiencia vitaminica/nutricional', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (622, 'W18', 'SINAIS/SINTOMAS PS-PARTO', 'sinais/sintomas pos-parto', 1, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (634, 'W78', 'GRAVIDEZ', 'gravidez', 1, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (729, 'ABP003', 'SAUDE SEXUAL E REPRODUTIVA', 'saude sexual e reprodutiva', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (730, 'ABP004', 'PUERICULTURA', 'puericultura', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (731, 'ABP005', 'HIPERTENSAO ARTERIAL', 'hipertensao arterial', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (732, 'ABP006', 'DIABETES', 'diabetes', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (733, 'ABP007', 'OBESIDADE', 'obesidade', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (734, 'ABP008', 'DESNUTRICAO', 'desnutricao', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (735, 'ABP009', 'ASMA', 'asma', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (736, 'ABP010', 'DPOC', 'dpoc', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (737, 'ABP011', 'TABAGISMO', 'tabagismo', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (738, 'ABP012', 'USUARIO DE ALCOOL', 'usuario de alcool', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (739, 'ABP013', 'USUARIO DE OUTRAS DROGAS', 'usuario de outras drogas', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (740, 'ABP014', 'SAUDE MENTAL', 'saude mental', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (741, 'ABP015', 'REABILITACAO', 'reabilitacao', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (743, 'ABP017', 'TUBERCULOSE', 'tuberculose', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (744, 'ABP018', 'HANSENIASE', 'hanseniase', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (745, 'ABP019', 'DENGUE', 'dengue', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (746, 'ABP020', 'DST', 'dst', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (747, 'ABP022', 'RASTREAMENTO DE CANCER DO COLO DO UTERO', 'rastreamento de cancer do colo do utero', 1, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (748, 'ABP023', 'RASTREAMENTO DE CANCER DE MAMA', 'rastreamento de cancer de mama', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (727, 'ABP001', 'PRE-NATAL', 'pre-natal', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (728, 'ABP002', 'PUERPERIO (ATE 42 DIAS)', 'puerperio (ate 42 dias)', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (749, 'ABP024', 'RASTREAMENTO DE RISCO CARDIOVASCULAR', 'rastreamento de risco cardiovascular', 2, 0);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (639, 'W83', 'ABORTO PROVOCADO', 'aborto provocado', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (640, 'W84', 'GRAVIDEZ DE ALTO RISCO', 'gravidez de alto risco', 1, 1);
INSERT INTO tb_ciap (co_seq_ciap, co_ciap, ds_ciap, ds_ciap_filtro, co_sexo, st_filtro_padrao) VALUES (353, 'H78', 'FIBRILAO/FLUTTER AURICULAR/ATRIAL', 'fibrilacao/flutter auricular/atrial', 2, 1);

CREATE TABLE social.rl_cds_atend_individual_ciap
(
   id bigserial, 
   ate_codigo bigint, 
   co_ciap bigint, 
   PRIMARY KEY (id), 
   FOREIGN KEY (ate_codigo) REFERENCES atendimento (ate_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   FOREIGN KEY (co_ciap) REFERENCES tb_ciap (co_seq_ciap) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;

CREATE TABLE social.rl_ciap_cid10
(
   co_ciap bigint, 
   co_cid10 bigint, 
   PRIMARY KEY (co_ciap, co_cid10)
) 
WITH (
  OIDS = FALSE
)
;

INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9594);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9606);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9615);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9616);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9617);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9618);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9619);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9620);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9648);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9649);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9308);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9319);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9330);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9595);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9607);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9621);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (1, 9635);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 4854);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 13778);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 13779);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 13781);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 13782);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 13783);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 13784);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 13785);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 13786);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 9682);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 9693);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 9703);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 9714);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 13751);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 13762);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 13769);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 14137);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 14147);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 14158);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 14167);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (2, 14178);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7883);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7884);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7885);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7887);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7861);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7866);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7871);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7888);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7893);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7902);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7913);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7924);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7933);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7941);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7948);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (3, 7959);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8323);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8324);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8206);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8209);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8214);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8220);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8226);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8237);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8254);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8265);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8276);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8287);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8298);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8309);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8320);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8325);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (4, 8335);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (5, 9643);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (5, 9644);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (5, 9645);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (5, 9646);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (5, 9647);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (6, 6931);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (7, 8013);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (8, 13489);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (8, 13509);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13676);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13498);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13556);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13562);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13572);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13582);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13615);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13625);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13633);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13637);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13641);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13655);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13732);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (9, 13951);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 1541);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 1542);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 1674);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 1675);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 1761);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 8200);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13959);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13961);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13962);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13963);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13964);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13965);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13966);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13967);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13968);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 14006);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 14007);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 14008);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 14009);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 14010);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 14012);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 14013);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 14110);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 14118);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 14190);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13520);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13530);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13540);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13547);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13605);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13736);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13743);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13787);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13791);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13795);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13799);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13810);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13820);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13831);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (10, 13837);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (11, 8169);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (12, 8199);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (13, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (14, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (15, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (16, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (17, 8199);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (18, 4887);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (19, 4085);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (20, 1337);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (20, 1344);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (20, 1350);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (20, 1361);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (20, 1368);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (21, 1384);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (21, 1393);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (21, 1402);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (21, 1408);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (21, 1416);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (22, 1084);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (22, 1143);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (22, 1307);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (22, 1373);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (22, 1380);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (22, 1422);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (23, 1538);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (23, 1672);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (23, 1736);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (23, 1745);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (24, 8619);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (25, 9151);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (26, 1792);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (26, 1800);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (26, 1806);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (27, 1828);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (27, 1839);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (27, 1843);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (27, 7880);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (27, 7886);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (28, 1762);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (29, 1767);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (29, 1774);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (30, 996);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (31, 1024);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (31, 1025);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (31, 1013);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (31, 1026);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (32, 1045);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 920);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 950);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 1039);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 1135);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 1137);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 1142);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 910);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 921);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 929);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 933);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 938);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 944);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 951);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 987);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 1006);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 1031);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 1040);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 1054);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (33, 1157);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 1569);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 1756);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 1757);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 4589);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 4708);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 4709);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 4724);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 1430);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 1434);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 1496);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 1506);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 1510);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 1521);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 1572);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (34, 1676);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8352);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8354);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8355);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8356);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8357);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8358);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8359);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8360);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8441);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8442);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8443);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8444);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8495);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8497);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8498);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8499);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8500);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8569);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8570);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8571);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8653);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8654);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8782);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8783);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8858);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8859);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8914);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8915);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8983);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 8984);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 9110);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 9121);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 9132);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 9142);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (35, 9143);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (36, 9167);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8357);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8367);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8377);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8385);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8438);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8440);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8620);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8621);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8622);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8623);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8624);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8625);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8627);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 8628);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 9258);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 9259);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 9260);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 9263);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 9264);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (37, 9265);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7367);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7496);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7503);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7507);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7516);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7526);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7536);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7543);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7549);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7556);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7567);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (38, 7576);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4390);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4391);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4392);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4393);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4394);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4395);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4396);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4398);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4399);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4400);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4403);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4411);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4422);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4433);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4441);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4447);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4457);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4464);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (39, 4470);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 343);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 344);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 617);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4493);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4495);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4496);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4497);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4498);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4499);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4500);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4502);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4503);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4504);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4505);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4506);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4509);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4510);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4477);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (40, 4488);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (41, 4511);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (41, 4512);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (41, 4515);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (41, 4525);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (42, 4539);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (43, 3217);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (43, 3220);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (44, 2062);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (44, 4529);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (44, 4549);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (44, 4559);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (45, 4582);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (45, 4583);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (45, 4584);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (45, 4585);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (45, 4586);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (45, 4587);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (45, 4588);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (45, 4590);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (45, 4591);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (45, 4569);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (46, 4596);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (46, 4597);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (46, 4592);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (47, 4605);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (48, 4627);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (49, 4612);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (49, 4619);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (49, 4623);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (49, 4631);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (49, 4635);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (50, 4674);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (51, 4683);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (52, 4654);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (52, 4639);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (52, 4644);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1831);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1832);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1833);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1834);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1840);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1842);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1844);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1845);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1737);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1779);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1785);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1812);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1822);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (53, 1835);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (54, 1846);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (54, 1847);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (54, 1848);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (54, 1849);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (54, 1857);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (55, 1867);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (55, 1868);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (55, 8205);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (55, 1869);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (56, 8020);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (56, 8021);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (57, 559);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (57, 8213);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (57, 13604);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (57, 530);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (57, 541);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (57, 549);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (57, 554);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1898);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 4092);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 4093);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 4094);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 8204);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1874);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1883);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1887);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1893);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1899);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1910);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1921);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1929);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1935);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1940);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 1947);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (58, 8201);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (59, 8008);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (59, 8012);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (60, 8009);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (61, 8014);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (62, 4691);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (62, 4716);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (62, 8010);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (62, 8011);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (63, 4982);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (63, 4985);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (64, 8009);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (64, 8010);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (64, 8011);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (65, 4580);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (66, 8016);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (67, 4658);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (67, 4688);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (68, 4670);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (68, 4687);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (69, 8022);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (70, 4859);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (71, 4860);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (72, 4713);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (73, 8017);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (74, 8029);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (74, 8030);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (75, 4397);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (75, 4462);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (75, 13780);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (76, 4494);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (76, 4500);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (76, 4507);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (76, 4508);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (76, 4509);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (76, 4510);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (76, 8031);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (76, 8197);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (77, 8015);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (78, 8019);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (78, 8021);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (79, 8025);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (80, 8025);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (81, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (82, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (83, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (84, 4420);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (84, 8013);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (84, 8023);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (84, 8026);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (84, 8027);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (84, 8028);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (84, 8032);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (85, 1);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (85, 5);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (85, 11);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (85, 17);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (85, 24);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (85, 35);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (85, 43);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (85, 54);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (85, 61);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (86, 566);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (87, 508);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (87, 511);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (87, 516);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (87, 521);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (87, 527);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (88, 68);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (90, 7981);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (91, 5192);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (92, 7618);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (132, 8152);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (133, 8199);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (134, 8147);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (135, 3182);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (135, 8157);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (136, 8157);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (137, 8159);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (138, 8091);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (139, 8199);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (140, 8177);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (141, 8168);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (142, 8000);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (143, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (144, 8196);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (145, 8132);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (146, 13967);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (147, 14014);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (147, 14057);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 13970);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 13971);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 13972);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 13973);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 13974);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 13975);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 13982);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14033);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14034);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14035);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14038);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14039);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14040);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14041);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14069);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14070);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14071);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14072);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14073);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14074);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14075);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14120);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14121);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14122);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14123);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14124);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14125);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14126);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14127);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 13593);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 13649);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14025);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14042);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14051);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14077);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14087);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (148, 14128);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (149, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (150, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (151, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (152, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (152, 14192);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (152, 14195);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (152, 14196);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (152, 14197);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (152, 13989);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (153, 8065);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (153, 8195);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (153, 8199);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (154, 6207);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (154, 6208);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (154, 69);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (154, 80);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (154, 90);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (154, 95);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (154, 105);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (154, 865);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (155, 2646);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (155, 8013);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7077);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7109);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7148);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7190);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7197);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7223);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7242);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6873);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6884);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6895);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6906);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6916);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6926);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6936);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6940);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6948);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6956);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6964);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6972);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6979);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6989);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6993);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 6997);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7002);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7012);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7019);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7025);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7030);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7035);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7044);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7052);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7059);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7068);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7078);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7086);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7095);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7099);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7110);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7120);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7125);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7128);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7132);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7141);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7149);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7159);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7167);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7175);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7181);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7191);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7198);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7205);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7209);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7213);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7224);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7233);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7243);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (156, 7250);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (157, 7249);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (157, 8345);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (158, 8345);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (158, 8349);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (158, 8350);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (158, 8346);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (159, 486);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (160, 470);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (161, 722);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (161, 706);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (161, 710);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (161, 714);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (161, 718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (162, 494);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (163, 573);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (164, 421);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (164, 484);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (164, 485);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (164, 500);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (164, 502);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (164, 503);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (164, 504);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (164, 506);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (164, 507);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 425);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 426);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 440);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 459);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 467);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 586);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 587);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 589);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 590);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 389);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 427);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 435);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 441);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 445);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 451);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 560);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 591);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (165, 899);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 181);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 182);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 183);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 184);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 185);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 201);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 204);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 205);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 206);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 207);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 209);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 210);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 246);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 248);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 249);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 250);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 251);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 310);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 311);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 319);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 345);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 346);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 347);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 348);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 355);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 356);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 624);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 625);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 626);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 705);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 744);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 745);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 746);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 752);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 864);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 872);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 877);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 878);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 909);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 4798);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 111);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 119);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 127);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 134);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 141);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 147);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 151);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 156);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 160);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 166);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 175);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 211);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 218);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 227);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 234);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 239);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 252);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 338);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 357);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 363);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 371);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 627);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 636);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 644);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 652);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 657);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 663);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 669);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 676);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 684);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 693);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 697);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 723);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 732);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 747);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 879);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (166, 889);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1091);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1138);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1144);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1145);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1146);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1336);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1429);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1494);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1495);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1298);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1316);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (167, 1326);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8639);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8642);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8644);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8646);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8649);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8650);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 9125);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 9136);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 9147);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 9149);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 9150);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 9151);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 9262);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 9267);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8445);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8475);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8501);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8532);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8542);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8608);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8689);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8750);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8819);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8885);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 8949);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (168, 9017);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8486);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8487);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8488);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8490);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8491);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8492);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8579);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8626);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8637);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8638);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8646);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8647);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8648);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8649);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8650);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 9105);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 9106);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 9107);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8557);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 8560);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 9045);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 9053);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 9061);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 9072);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 9080);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 9089);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (169, 9268);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9651);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9652);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9653);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9655);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9656);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9658);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9659);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9660);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9801);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9802);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9752);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9761);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9770);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9780);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9790);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9793);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (170, 9803);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9339);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9350);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9359);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9370);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9378);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9389);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9396);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9406);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9416);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9427);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9438);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9449);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9460);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9469);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (171, 9480);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (172, 1829);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (172, 1841);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (172, 2980);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (172, 4098);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (172, 4972);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (172, 4973);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (172, 9748);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (172, 9749);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 1830);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 1841);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9522);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9541);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9583);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9491);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9498);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9506);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9516);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9523);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9534);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9542);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9553);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9561);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9567);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9573);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (173, 9584);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 4850);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 4853);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 6799);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 6829);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 6830);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 6831);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9742);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9743);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9744);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9745);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9746);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9747);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9750);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9751);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 2353);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 3205);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 3520);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 3654);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 4101);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 4362);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 5864);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 6377);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 6545);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 6743);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 6818);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9661);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9671);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9725);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (174, 9733);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (175, 3791);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (175, 3797);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (175, 3803);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (175, 3809);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3834);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3835);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3836);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3837);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3839);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3840);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3841);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3842);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3843);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 6832);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3777);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3844);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3849);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3858);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3868);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3891);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (176, 3902);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (177, 7976);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (178, 3700);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (179, 3962);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (179, 3701);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (179, 3704);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (179, 3707);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (179, 3712);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (180, 4096);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (180, 4097);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (180, 4099);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (180, 4100);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (181, 2982);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (182, 3941);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (182, 2990);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (182, 3906);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (182, 3917);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (182, 3927);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (182, 3931);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3958);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3959);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3961);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3963);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3964);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3965);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3966);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3967);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3942);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3949);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3968);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (183, 3973);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (184, 7974);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (184, 3980);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (184, 4004);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (184, 4009);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (185, 3759);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (186, 4045);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (186, 4080);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (186, 4083);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (186, 4038);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (186, 4046);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (187, 4055);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (187, 4057);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (187, 4082);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (188, 4058);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4029);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4031);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4032);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4081);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4084);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4091);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4112);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 9103);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 3986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 3996);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4018);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4033);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4069);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4072);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 4107);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 5460);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 5466);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (189, 8163);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (190, 5596);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (190, 5598);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (191, 5596);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (191, 5602);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (191, 5603);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (191, 5604);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (192, 5592);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (192, 5596);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (192, 5601);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (193, 7999);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (193, 8075);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (194, 8075);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (195, 4454);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (195, 4475);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (195, 8058);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (195, 8075);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (196, 5454);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (196, 5455);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (196, 5456);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (197, 5730);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (197, 8058);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (197, 8075);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (198, 5454);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (198, 5455);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (198, 5456);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (199, 5454);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (199, 5455);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (199, 5456);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (200, 5454);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (200, 5455);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (200, 5456);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (200, 5730);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (200, 8058);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (200, 8075);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (201, 5454);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (201, 5455);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (201, 5456);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (201, 8074);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (202, 5730);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (202, 8058);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (202, 8075);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (203, 5454);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (203, 5455);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (203, 5456);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (204, 5607);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (204, 5608);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (204, 5609);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (204, 5610);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (204, 5724);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (204, 5725);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (204, 5727);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (204, 5730);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (204, 8058);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (205, 5625);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (205, 5626);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (205, 5732);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (206, 5454);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (206, 5455);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (206, 5456);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (206, 5458);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (206, 5459);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (207, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (208, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (209, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (210, 8065);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (210, 8073);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (210, 8075);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5544);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5545);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5546);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5547);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5606);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5636);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5637);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5673);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5674);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5263);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5269);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (211, 5783);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (212, 1141);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (212, 1096);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (212, 1103);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (212, 1162);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (213, 8725);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (214, 8924);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (214, 8925);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (214, 8926);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (214, 8927);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (214, 8928);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (214, 8929);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (214, 8930);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (214, 8931);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (214, 8932);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (215, 8791);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (215, 8992);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (216, 8866);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8374);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8375);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8376);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8378);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8379);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8380);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8381);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8923);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 9108);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 9119);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 9130);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 9144);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8452);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8508);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8581);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (217, 8661);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (218, 9006);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (219, 8938);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (219, 8940);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8387);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8388);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8464);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8465);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8466);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8521);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8522);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8523);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8597);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8675);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8676);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8677);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8678);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8739);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8740);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8741);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8805);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8806);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8807);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8808);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8809);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 8877);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 9004);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 9007);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 9008);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 9112);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 9123);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 9134);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (220, 9145);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 5421);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 5422);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8383);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8386);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8460);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8461);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8462);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8463);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8518);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8519);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8520);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8591);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8592);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8593);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8594);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8671);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8672);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8673);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8674);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8737);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8738);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8802);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8803);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8804);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8876);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8934);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 8935);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 9002);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 9003);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 9005);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 9112);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 9123);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 9134);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (221, 9145);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 5729);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8434);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8438);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8483);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8488);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8496);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8518);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8566);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8567);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8591);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8595);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8646);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8649);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8650);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8652);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8705);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8715);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8716);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8779);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8780);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8781);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8856);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8857);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8912);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8913);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8979);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 9104);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 9148);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8484);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8489);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8557);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8560);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8697);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8706);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8710);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8757);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8766);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8770);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8774);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8829);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8840);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8843);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8851);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8892);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8899);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8903);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8907);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8959);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8967);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8970);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8974);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 8978);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 9024);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 9031);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 9035);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 9041);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 9120);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (222, 9131);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7687);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7697);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7708);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7726);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7731);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7738);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7748);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7759);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7763);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7770);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7779);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7790);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7801);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (223, 7811);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5531);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5532);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5534);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5535);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5536);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5537);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5542);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5552);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5553);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5554);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5555);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5589);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5590);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5593);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5594);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5556);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (224, 5573);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5531);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5532);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5536);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5542);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5543);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5548);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5549);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5551);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5554);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5555);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5583);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5584);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5585);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5586);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5587);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5591);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5592);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5593);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5594);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 8596);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 8598);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (225, 5556);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (226, 5538);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (226, 5539);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (226, 5510);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (226, 5517);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 5552);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 5553);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 5581);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 5582);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 5583);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 5584);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 5585);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 5586);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 5587);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 5599);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 5600);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (227, 3046);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5638);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5639);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5640);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5641);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5642);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5654);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5655);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5675);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5676);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5677);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5678);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5679);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5680);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5715);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5720);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5721);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5722);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5661);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5681);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (228, 5703);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (229, 5540);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (229, 5290);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (229, 5297);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (229, 5313);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (230, 5369);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (231, 8142);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (232, 5379);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (233, 5347);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (233, 5361);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (233, 5387);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (233, 5395);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (234, 5395);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (234, 5694);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (235, 5716);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (236, 5526);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (236, 5824);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (236, 5831);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (236, 5842);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (237, 5733);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (237, 5742);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (237, 5752);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (238, 8936);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (238, 8937);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (238, 8939);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (238, 8941);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (239, 1753);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (239, 1754);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (239, 1543);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (239, 1575);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (240, 5401);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (240, 5409);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5423);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5424);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5425);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5426);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5427);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5450);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5451);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5452);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5453);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5457);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5458);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5459);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5533);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5597);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5620);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5621);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5622);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5623);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5624);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5625);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5627);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5628);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5651);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5652);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5653);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5656);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5657);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5728);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5731);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 9657);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 14154);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 14188);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5278);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5285);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5305);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5321);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5333);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5339);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5352);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5428);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5438);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5476);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5481);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5486);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5492);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5503);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5565);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5611);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5629);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5643);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5658);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5681);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5690);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5765);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5773);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5793);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5800);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5804);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5814);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5848);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5855);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 5874);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (241, 14098);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (242, 2979);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (242, 2981);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (242, 8151);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (243, 3010);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (243, 8151);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (244, 2919);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (245, 8036);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (246, 8034);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (246, 8035);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (246, 8037);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (246, 8038);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (247, 8160);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 2912);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 2913);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 2914);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 2915);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 2916);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 2917);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 2918);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 2919);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 2920);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 8056);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 8057);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 8059);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 8060);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (248, 8070);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (249, 8102);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (250, 8101);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (251, 3211);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (251, 3144);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (251, 3148);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (251, 3155);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (252, 8133);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (253, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (254, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (255, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (256, 5726);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (256, 8062);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (256, 8063);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (256, 8064);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (256, 8065);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (256, 8070);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (256, 8071);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (256, 8072);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (256, 8075);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (256, 8066);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (257, 409);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (257, 871);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (257, 376);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 182);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 203);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 410);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 411);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 412);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 413);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 464);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 465);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 622);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 742);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 875);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 2838);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 393);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 403);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 414);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 2831);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 2839);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 2843);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 2849);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (258, 2855);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (259, 186);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (259, 187);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (259, 188);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (260, 423);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (260, 424);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (260, 2864);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (260, 2865);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (260, 2866);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (260, 383);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (260, 2860);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (261, 1147);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (261, 1260);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (261, 1264);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (261, 1275);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (262, 1755);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (262, 1713);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (262, 1717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (263, 8412);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8372);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8373);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8380);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8381);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8413);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8414);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8415);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8416);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8417);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8418);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8419);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8420);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8421);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8423);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8424);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8425);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8426);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8428);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8430);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8431);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8433);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8436);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8437);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (264, 8438);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 8438);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 9100);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 9101);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 9102);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 9113);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 9114);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 9124);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 9135);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 9146);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 8389);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 8467);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 8524);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 8599);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 8679);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 8742);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 8810);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 8878);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 8942);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (265, 9009);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (266, 7269);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (266, 7259);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (266, 7263);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (266, 7270);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (266, 7275);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (266, 7285);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (266, 7296);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (266, 7304);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (267, 2936);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (268, 2887);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (268, 2895);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (268, 2888);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (269, 2951);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (269, 2962);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (270, 2977);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (270, 2968);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (271, 2976);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (272, 3013);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (272, 3029);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (273, 3009);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (273, 3011);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (273, 3012);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (274, 3053);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3054);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3055);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3056);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3057);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3058);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3059);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3105);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 5726);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3035);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3046);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3060);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3070);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3075);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3078);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3085);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3090);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (275, 3096);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (276, 2978);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2178);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2867);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2921);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2928);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2929);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2931);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2932);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3177);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3179);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3180);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3181);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3183);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3184);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3185);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3186);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3187);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3188);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3211);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 5726);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 14189);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2868);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2876);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2882);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2896);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2902);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2933);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2937);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 2942);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3021);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3106);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3112);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3119);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3127);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3136);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3163);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3170);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3189);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3194);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3200);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (277, 3212);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (278, 8114);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (279, 2611);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (279, 2613);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (279, 2614);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (279, 2615);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (280, 8116);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (280, 8117);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (281, 8115);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (281, 8118);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (281, 8119);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (281, 8120);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (282, 8158);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (283, 2649);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (283, 3000);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (284, 2659);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (285, 8005);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (286, 2660);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (286, 2661);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (286, 2662);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (286, 2663);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (286, 2664);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (286, 2665);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (286, 2666);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (286, 2667);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (286, 2668);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (287, 2701);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (287, 2707);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (287, 2717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (288, 2825);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (288, 2826);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (288, 2827);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (288, 2814);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (289, 2823);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (289, 2824);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (290, 2821);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (291, 2822);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (292, 2410);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (292, 2411);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (292, 2412);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (292, 2413);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (292, 2414);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (292, 2415);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (292, 2416);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (292, 2417);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (292, 2418);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (292, 2930);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (293, 2409);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (294, 4694);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (294, 4701);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 797);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 798);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 807);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 822);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 823);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 753);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 760);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 769);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 780);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 784);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 789);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 792);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 799);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 808);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 813);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 817);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 824);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 831);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (295, 834);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (296, 741);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (296, 876);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (296, 4742);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (296, 4749);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (296, 4760);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (296, 4764);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (296, 4770);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (296, 4778);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (296, 4786);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (296, 4797);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (297, 4839);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (297, 4800);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (297, 4808);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (297, 4813);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (297, 4821);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4655);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4656);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4657);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4658);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4666);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4667);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4668);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4669);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4671);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4672);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4673);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4689);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4690);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4692);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4693);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4710);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4711);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4712);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4714);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4715);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4716);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4840);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4851);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4852);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4855);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4856);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4857);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4861);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4862);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4863);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 14113);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 14114);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 14152);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 14187);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4581);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4598);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4659);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4727);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4731);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4736);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4830);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4831);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4841);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (298, 4864);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (299, 3513);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (300, 3514);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (301, 3243);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (302, 3493);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (303, 3493);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (303, 3494);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (303, 3495);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (303, 3499);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (303, 3500);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (303, 3509);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (304, 3514);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (305, 3510);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (306, 3514);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (307, 3228);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (307, 3229);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (307, 3230);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (307, 3231);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (307, 3232);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (307, 3233);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (307, 3234);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (307, 3235);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (308, 13777);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (309, 13777);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (310, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (311, 3506);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (311, 3507);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (311, 3508);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (311, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (312, 3514);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (312, 3515);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (313, 354);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (313, 3265);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (313, 3267);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (313, 3268);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (313, 3269);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (313, 3270);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (313, 3271);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (313, 3272);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (313, 578);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (313, 3281);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (314, 3266);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (315, 3634);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (315, 3636);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (315, 3637);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (315, 3638);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (315, 3639);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (315, 3623);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 466);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 740);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3244);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3245);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3251);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3252);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3294);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3295);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3296);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3297);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3298);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3299);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3430);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3431);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3236);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3322);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3328);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3337);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3365);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (316, 3379);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (317, 1492);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (317, 1760);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (317, 1250);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (317, 1638);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (318, 3277);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (318, 3514);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (318, 8353);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (318, 8402);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (319, 9152);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 3294);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 3436);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 3437);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8354);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8363);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8401);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8403);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8404);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8405);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8406);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8407);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8408);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8409);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8410);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 8438);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (320, 9237);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (321, 7314);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7309);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7310);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7311);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7312);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7313);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7315);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7316);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7317);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7322);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7330);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7339);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (322, 7346);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (323, 3382);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (324, 3396);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (324, 3397);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (324, 3398);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (324, 3400);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (324, 3406);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (325, 3399);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (326, 3293);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (326, 3316);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (327, 874);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (327, 349);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (328, 3432);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (328, 3482);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (329, 3341);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (329, 3347);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (329, 3360);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (330, 3409);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (330, 3419);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (331, 3502);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (331, 3503);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (331, 3504);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (331, 3505);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (332, 3458);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (332, 3466);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (332, 3476);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3226);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3227);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3234);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3235);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3241);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3242);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3246);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3247);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3248);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3249);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3253);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3254);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3255);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3256);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3257);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3258);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3274);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3275);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3276);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3278);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3279);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3280);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3320);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3321);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3401);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3402);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3403);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3404);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3405);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3430);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3431);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3432);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3433);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3434);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3435);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3438);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3439);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3444);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3496);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3497);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3498);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3512);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3514);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 14155);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3259);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3287);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3300);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3305);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3355);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3360);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3371);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3389);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3422);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3440);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3445);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3454);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3516);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (333, 3520);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (334, 3641);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (335, 3639);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (335, 3647);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (336, 3646);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (337, 3642);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (338, 3643);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (339, 3649);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (340, 8132);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (341, 1673);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (341, 1647);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (341, 1651);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (342, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (343, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (344, 3649);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (344, 3650);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (345, 3524);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (345, 3540);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (346, 3555);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (346, 3559);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (346, 3560);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (346, 3573);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (346, 3586);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (346, 3588);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (346, 3561);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (347, 3547);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (348, 3565);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (348, 3568);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (349, 3556);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (349, 3557);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (349, 3558);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (349, 3560);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (349, 3574);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (349, 3575);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (349, 3576);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (349, 3577);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (349, 3578);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (349, 3587);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (349, 3598);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1061);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1125);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1163);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1320);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1447);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1463);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1532);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1576);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1597);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1692);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1754);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (350, 1758);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (351, 9157);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (352, 3579);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (353, 8356);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (354, 8365);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (354, 8423);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (354, 8429);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (354, 8435);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (354, 8437);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (354, 8438);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (354, 9613);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (355, 7350);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (355, 7358);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (356, 3536);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (357, 422);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (357, 3615);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (357, 3617);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (357, 3618);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (357, 3619);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (357, 3607);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (358, 3601);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (359, 3635);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (360, 3620);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3534);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3535);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3537);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3538);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3539);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3588);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3589);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3621);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3622);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3645);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3648);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3649);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3650);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3590);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (361, 3651);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (362, 7998);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (363, 7998);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (364, 8006);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (365, 7966);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (365, 7967);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (365, 7968);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (366, 7969);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (367, 4030);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (367, 4083);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (368, 8173);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (369, 14036);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (369, 14037);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (369, 14076);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (370, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (371, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (372, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (373, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (374, 7977);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (374, 8006);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (375, 208);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (375, 588);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (375, 623);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (375, 3815);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (375, 3772);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (375, 3784);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (375, 3788);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (375, 3816);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (375, 3823);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (375, 3828);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (376, 3659);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (376, 3660);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (376, 3666);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (376, 3669);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (376, 3675);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (376, 3681);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (376, 3687);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (376, 3694);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (377, 1086);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (377, 1136);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (377, 1539);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (377, 1540);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (377, 1760);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (378, 3838);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (378, 7378);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (378, 7388);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (378, 7396);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (378, 7406);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (378, 7414);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (378, 7424);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (378, 7435);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (378, 7445);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (378, 7453);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (379, 3745);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (379, 3747);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (379, 3748);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (379, 3718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (380, 3746);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (380, 3723);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (380, 3730);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (380, 3735);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (381, 3749);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (382, 3887);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (383, 3877);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (384, 3872);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (385, 3878);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (386, 8006);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (386, 7970);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (387, 3762);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (387, 3767);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (388, 5454);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (388, 5455);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (388, 5456);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (389, 5454);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (389, 5455);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (389, 5456);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (389, 5719);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (389, 5730);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (389, 8058);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (389, 8075);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (390, 4227);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (390, 4228);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (391, 1687);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (391, 1688);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (391, 1689);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (391, 1690);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (391, 1691);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (391, 1692);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (391, 1693);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (391, 1443);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (392, 4261);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (392, 4267);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (393, 4277);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (393, 4272);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (394, 4199);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (395, 7990);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4224);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4225);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4226);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4227);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4278);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4279);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4280);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4292);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4293);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4330);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4331);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4332);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 14112);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4217);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4239);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4248);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4281);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4284);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4294);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4299);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4310);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4318);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4322);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4333);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4348);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4351);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4371);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4375);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (396, 4385);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (397, 8038);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (398, 4986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (398, 4987);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (399, 498);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (400, 8041);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (400, 8042);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (400, 8043);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (400, 8044);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (400, 8045);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (400, 8047);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (400, 8054);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (401, 8046);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (401, 8054);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (402, 5055);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (402, 8039);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (403, 5055);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (403, 8039);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (404, 5180);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (404, 5181);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (404, 5182);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (404, 5183);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (404, 8049);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (404, 8050);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (404, 8051);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (404, 8054);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (405, 4881);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (406, 4872);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (407, 9654);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8352);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8359);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8360);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8440);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8443);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8444);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8494);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8496);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8566);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8567);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8652);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8715);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8716);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8779);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8780);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8781);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8856);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8857);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8912);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8913);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8979);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8980);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8981);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 8982);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 9110);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 9121);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 9132);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (408, 9142);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8352);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8358);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8359);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8360);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8441);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8442);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8443);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8444);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8495);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8497);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8498);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8499);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8500);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8569);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8570);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8571);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8653);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8654);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8782);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8783);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8858);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8859);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8914);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8915);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8983);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 8984);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 9110);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 9121);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 9132);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (409, 9142);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8362);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8364);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8366);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8368);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8369);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8370);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8573);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8574);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8580);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 9111);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 9122);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 9133);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 9143);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8445);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8501);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8656);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8720);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8785);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8861);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8917);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (410, 8986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8352);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8358);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8359);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8360);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8441);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8442);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8443);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8444);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8495);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8497);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8498);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8499);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8500);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8569);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8570);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8571);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8653);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8654);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8655);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8719);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8782);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8783);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8784);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8858);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8859);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8860);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8914);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8915);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8916);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8983);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8984);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 8985);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 9110);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 9121);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 9142);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (411, 9131);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (412, 8053);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (413, 5092);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (413, 5095);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (413, 5096);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (413, 5098);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (413, 8198);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (413, 5099);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (414, 5102);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (414, 5108);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (414, 5112);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (414, 5118);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (415, 5126);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (415, 5131);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (416, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (417, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (418, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (419, 8052);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (419, 8054);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (420, 476);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (421, 461);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (421, 462);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (421, 463);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (421, 468);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (421, 469);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (422, 848);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (422, 858);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (422, 860);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (423, 859);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (423, 861);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (423, 862);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (423, 863);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (423, 842);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (423, 849);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (424, 599);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (424, 609);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (425, 619);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (426, 244);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (426, 4882);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (426, 4883);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (426, 4884);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (426, 4885);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (426, 4886);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (426, 5251);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (426, 321);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (426, 332);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (426, 4897);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (427, 1140);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (427, 1111);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (427, 1122);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (428, 1554);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (429, 1758);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (429, 1449);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (429, 1460);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (429, 1594);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (430, 5059);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (430, 5065);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (430, 5073);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (430, 5082);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (430, 5086);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (431, 1564);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (432, 1584);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (433, 7821);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (433, 7829);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (433, 7835);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (433, 7851);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (434, 4868);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (434, 4869);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (435, 4894);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (436, 4933);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (437, 4929);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (438, 1963);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (438, 1958);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (438, 1964);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (439, 4974);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (439, 4975);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (439, 4976);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (439, 4989);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (439, 4992);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (439, 4993);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (439, 4995);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (439, 4996);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (439, 4939);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (439, 4950);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (439, 4961);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (440, 4938);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (441, 5015);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (442, 4997);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (443, 4990);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (443, 5161);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (443, 5164);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (443, 5172);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (444, 5154);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (445, 5091);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (446, 501);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (447, 5138);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (448, 4054);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (448, 4056);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (448, 5208);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (448, 5249);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (448, 5255);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (449, 5032);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 4928);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 4970);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 4991);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 4994);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5031);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5048);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5050);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5051);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5052);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5053);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5054);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5093);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5094);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5097);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5153);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5155);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5156);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5157);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5159);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5160);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5162);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5163);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5178);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5184);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5185);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5186);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5187);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5188);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5189);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5190);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5191);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5200);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5207);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5252);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5253);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5254);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5256);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5257);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5258);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5259);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 14153);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 4902);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 4911);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 4916);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 4923);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 4977);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5006);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5016);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5023);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5042);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5056);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5147);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5193);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5201);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5209);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5219);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5223);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5230);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5234);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5244);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (450, 5260);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (451, 8187);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (452, 8188);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (453, 8186);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (454, 8189);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (455, 8189);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (456, 8191);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (457, 8190);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (457, 8193);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (458, 2147);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (458, 8183);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (458, 8184);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (459, 2336);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (460, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (461, 8090);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (462, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (463, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (464, 8192);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (465, 1989);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (466, 1284);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (467, 1659);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (468, 1493);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (468, 1285);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (468, 1289);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (468, 1660);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (468, 1725);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (469, 7882);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (470, 7881);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (470, 7882);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (470, 1953);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (471, 1973);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (472, 2223);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (473, 2223);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (474, 1979);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (475, 2056);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (475, 2058);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (475, 2059);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (475, 2060);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (475, 2061);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (475, 2064);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (476, 2001);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (477, 2012);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (477, 2023);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (477, 2034);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (477, 2045);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2156);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2157);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2158);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2159);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2163);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2164);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2177);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2179);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2180);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2181);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2187);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2196);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2197);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2198);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2160);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2165);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2182);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2188);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2191);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2199);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2210);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (478, 2215);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (479, 5326);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (480, 2290);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 1990);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 1991);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 1992);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 1993);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 1994);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 1995);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2063);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2144);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2145);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2146);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2148);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2149);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2150);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2151);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2222);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2235);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2363);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 6834);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 1996);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2065);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2070);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2077);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2083);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2090);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2098);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2102);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2107);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2116);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2123);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2128);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2133);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2138);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2152);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2229);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2236);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2243);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2248);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2257);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2262);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2270);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2278);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2285);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2300);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2305);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2314);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2323);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2328);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2337);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2347);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 2353);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (481, 5756);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (482, 8076);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (483, 8084);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (484, 6111);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (484, 6112);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (484, 8081);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (485, 8083);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (485, 8088);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (486, 8080);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (486, 5907);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (487, 8090);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (488, 8082);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (489, 8087);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (489, 8090);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (490, 6042);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (491, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (492, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (493, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (493, 14194);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (494, 5981);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (494, 5987);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (494, 6007);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (494, 6009);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (494, 5982);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (495, 6108);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (495, 6062);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (496, 300);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (496, 302);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (496, 309);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (496, 621);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (496, 6087);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (497, 1231);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (497, 1232);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (498, 1234);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (499, 1233);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (499, 1245);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (500, 1630);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (501, 1490);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (501, 1491);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (501, 1705);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (502, 8630);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (502, 8631);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (502, 8632);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (502, 8633);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (502, 9177);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (502, 9178);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (502, 9261);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (502, 9266);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (503, 7642);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (503, 7650);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (503, 7659);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (503, 7669);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (503, 7676);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (504, 6006);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (504, 6008);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (504, 5885);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (504, 5896);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (504, 5918);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (504, 5929);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (504, 5940);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (504, 5962);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (504, 5973);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (504, 5999);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (504, 6010);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (505, 6110);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (506, 6029);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (506, 6034);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (506, 6039);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (507, 6109);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (507, 8241);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (507, 8242);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (507, 8243);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6028);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6048);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6113);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6114);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 8089);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 9181);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 9182);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 14115);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 14116);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 5951);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 5988);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6018);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6024);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6043);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6049);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6053);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6058);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6070);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6076);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6084);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6092);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6097);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (508, 6104);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (509, 13681);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (510, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (511, 6490);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (511, 6643);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (512, 6494);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (513, 13665);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (514, 13666);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (515, 13663);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (515, 13667);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (516, 13664);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (517, 13662);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (517, 13668);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (517, 13669);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (518, 2485);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (519, 2675);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (519, 2441);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (519, 2507);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (520, 2419);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (520, 2430);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (520, 2441);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (520, 2452);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (520, 2463);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (520, 2474);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (520, 2496);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (520, 2507);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (521, 8095);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (522, 2828);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (522, 2829);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (522, 8182);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (522, 2790);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (522, 2797);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (522, 2801);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (522, 2808);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (523, 2828);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (523, 2829);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (523, 2790);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (523, 2797);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (523, 2808);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (524, 2772);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (524, 2773);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (524, 2758);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (524, 2765);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (524, 8137);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (525, 13896);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (526, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8352);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8354);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8355);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8356);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8357);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8358);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8359);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8360);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8441);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8442);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8443);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8444);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8495);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8497);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8498);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8499);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8500);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8569);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8570);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8571);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8653);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8654);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8782);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8783);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8858);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8859);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8914);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8915);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8983);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 8984);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 9110);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 9121);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 9132);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (527, 9142);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (528, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 2647);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 2648);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 2698);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 2828);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 2829);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8121);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8122);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8124);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8125);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8126);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8127);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8128);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8129);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8130);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8131);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8132);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 13939);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 13940);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 13980);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 13981);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 13983);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (529, 8107);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (530, 2383);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (530, 2364);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (530, 2369);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (530, 2376);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (530, 2922);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (531, 2384);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (531, 2407);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (531, 2385);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (531, 2390);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (531, 2401);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (532, 2528);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (532, 2540);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (532, 2547);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (532, 2518);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (532, 2529);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (532, 2541);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (533, 2582);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (533, 2549);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (533, 2555);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (534, 2598);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (534, 2599);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (534, 2601);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (534, 2602);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (534, 2603);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (535, 2628);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (535, 2629);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (535, 2630);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (535, 2616);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (536, 2583);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (536, 2584);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (536, 2585);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (536, 2590);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (536, 2600);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (536, 2670);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (536, 2566);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (536, 2573);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (536, 2586);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (537, 14125);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (538, 2636);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (539, 2591);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (539, 2604);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (540, 2688);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (540, 2695);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (540, 2696);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (540, 2697);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (540, 2699);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (540, 2700);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (540, 2727);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (540, 2677);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (540, 2689);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (540, 2723);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (541, 2785);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (542, 2612);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (543, 2728);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (543, 2733);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (543, 2738);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (543, 2743);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (543, 2748);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (543, 2753);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (544, 2641);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (544, 2642);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (544, 2643);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (544, 2644);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (544, 2645);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (545, 2548);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (545, 2671);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (545, 2533);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (546, 2637);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (546, 2638);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (546, 2639);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (546, 2672);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (546, 2673);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (546, 2674);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (546, 2676);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (546, 2783);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (546, 2784);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (546, 2830);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (546, 2774);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (547, 9143);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (548, 9183);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (548, 9192);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (548, 9201);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (548, 9210);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (548, 9219);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (548, 9228);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (548, 9277);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (548, 9286);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (548, 9297);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (549, 7997);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (550, 7986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (551, 7988);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (552, 7987);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (552, 7989);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (552, 7991);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (552, 7994);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (553, 7984);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (554, 7979);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (555, 4227);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (555, 7993);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (556, 4227);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (557, 4227);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (558, 7996);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (558, 8006);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (559, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (560, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (561, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (561, 14193);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (562, 7980);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (562, 7982);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (562, 7983);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (562, 7992);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (562, 8002);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (562, 8004);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (562, 8006);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (563, 196);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (564, 4123);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (564, 4127);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (565, 4223);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (566, 463);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (566, 505);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (566, 4113);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (566, 4124);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (566, 4125);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (566, 4137);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (567, 4114);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (567, 4209);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (568, 4128);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (568, 4129);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (568, 4235);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (569, 4135);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (569, 4245);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (569, 4130);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (570, 4198);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (570, 4255);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (570, 4183);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (570, 4194);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (571, 4260);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (571, 4256);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (572, 4143);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (572, 4144);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (572, 4147);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (572, 4148);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (573, 247);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (573, 4142);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (573, 4146);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (573, 4155);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (573, 4156);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (573, 4149);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (573, 4157);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (573, 4168);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (573, 4171);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (573, 4177);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (574, 4346);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (574, 4347);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (574, 8003);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (574, 4356);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (575, 618);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (575, 743);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (575, 4136);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (575, 189);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (575, 669);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (575, 4205);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (575, 4236);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (575, 4338);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (575, 4343);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (576, 1076);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (576, 1137);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (576, 1077);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 976);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 984);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 985);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 1060);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 1087);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 1088);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 1089);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 1090);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 1134);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 1137);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 956);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 961);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 969);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 977);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 1062);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 1069);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (577, 1092);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (578, 1532);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (578, 1533);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (578, 1534);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (578, 1535);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (578, 1536);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (578, 1568);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (579, 9158);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (580, 8355);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (580, 8364);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (580, 8384);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (580, 8438);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (580, 8440);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (580, 8485);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (580, 8491);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (580, 9614);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (580, 8546);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (580, 9248);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (581, 7460);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (581, 7467);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (581, 7475);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (581, 7481);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (581, 7491);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (582, 317);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (583, 1219);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (584, 1172);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (584, 1213);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (584, 1220);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (584, 1224);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (585, 1486);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (585, 1487);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (585, 1488);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (585, 1604);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (585, 1759);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (585, 1471);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (585, 1622);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (585, 1700);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (586, 8568);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (586, 8575);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (586, 8576);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (586, 8578);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (586, 8641);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (586, 8643);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (586, 8649);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (586, 8650);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (586, 9261);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (586, 9266);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (586, 13739);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (587, 6140);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (588, 7613);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (589, 7626);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (589, 7636);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (589, 7844);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (590, 6115);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (591, 6130);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (591, 6131);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (591, 6132);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (591, 6133);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 298);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 301);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 303);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 304);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 305);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 306);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 307);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 318);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6124);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6125);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6126);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6127);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6128);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6134);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6135);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6142);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6144);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6147);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6148);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6149);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6150);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6153);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6154);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6155);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6156);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6158);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6159);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6160);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6161);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6185);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6186);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 14117);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (592, 6162);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (593, 13890);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (593, 13891);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (593, 13892);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (593, 13893);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (593, 13894);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (594, 13881);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (594, 13889);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (595, 13885);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (595, 13886);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (595, 13887);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (595, 13888);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (595, 13893);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (595, 13894);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (596, 13897);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (596, 13898);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (596, 13899);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (596, 13900);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (596, 13901);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (596, 13902);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (596, 13903);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (597, 13856);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (597, 13857);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (597, 13858);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (597, 13859);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (597, 13860);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (597, 13861);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (597, 13862);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (597, 13863);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (598, 13855);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (599, 13846);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (600, 13892);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (601, 13943);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (601, 13944);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (601, 13945);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (601, 13946);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (602, 13941);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (602, 13996);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (603, 13996);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (604, 9629);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (604, 9632);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (604, 13926);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (605, 13926);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (606, 13932);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (607, 13930);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (607, 13931);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (608, 9629);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (608, 9632);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (608, 13934);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (608, 13904);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (608, 13915);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (609, 13932);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (610, 13930);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (611, 9629);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (611, 13927);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (611, 13934);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (612, 13927);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (612, 13935);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (613, 13932);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (613, 13933);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (614, 13930);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (615, 13935);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (616, 9630);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (616, 9631);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (616, 9633);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (616, 9634);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (616, 13947);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (616, 13948);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (617, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (618, 13984);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (618, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13875);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13876);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13877);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13878);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13879);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13880);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13882);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13883);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13928);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13929);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13933);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13934);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13935);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13938);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13949);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13950);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13976);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13977);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13978);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13985);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13987);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 13988);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (619, 14011);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (620, 13671);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (620, 13672);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (620, 13673);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (620, 13674);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (620, 13675);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (620, 13677);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (620, 13678);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (620, 13679);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (620, 6362);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (621, 6735);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (622, 6836);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (623, 6847);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (623, 6848);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (623, 6849);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (624, 8132);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (625, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (626, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (627, 6525);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (628, 6797);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (628, 6800);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (628, 6802);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (629, 6623);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (629, 6757);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (629, 6758);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (629, 6801);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (629, 6803);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (629, 6804);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (629, 6509);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (629, 6853);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (630, 1212);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (631, 6392);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (632, 9151);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (633, 6872);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (634, 13682);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (634, 13683);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (634, 13684);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (634, 13699);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (635, 13682);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (635, 13937);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (636, 6386);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (637, 6474);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (637, 6479);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (637, 6489);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (637, 6467);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (637, 6475);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (637, 6480);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (637, 6484);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (638, 6396);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (638, 6401);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (638, 6423);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (638, 6434);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (639, 13665);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (639, 6412);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6518);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6519);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6520);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6521);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6523);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6524);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6620);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6864);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6865);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6866);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6867);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6868);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6869);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6870);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6871);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6555);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6561);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6566);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6576);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6587);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6598);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6609);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6631);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 6636);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (640, 13688);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (641, 6522);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (642, 13709);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (642, 13717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (642, 6765);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (642, 13718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (642, 13728);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (643, 13710);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (643, 13717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6755);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6756);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6759);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6760);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6761);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6762);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6763);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6764);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 13711);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 13714);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 13717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6626);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6639);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6652);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6653);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6658);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6666);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6671);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6680);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6689);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6698);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6702);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6709);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6724);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6740);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6770);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6777);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6783);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 6791);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 13718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (644, 13728);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6755);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6756);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6759);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6760);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6761);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6762);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6763);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6764);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 13710);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 13712);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 13713);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 13715);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 13716);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 13717);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6626);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6639);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6652);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6653);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6658);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6666);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6671);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6680);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6689);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6698);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6702);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6709);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6718);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6724);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6740);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6770);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6777);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6783);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (645, 6791);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (646, 6837);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (647, 6842);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (647, 6843);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (647, 6844);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (647, 6845);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (647, 6846);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (648, 6833);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (648, 6835);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (648, 6836);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (648, 6805);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6622);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6624);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6625);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6651);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6834);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6850);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6851);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6852);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6445);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6456);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6500);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6525);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6536);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6647);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6812);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (649, 6863);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (650, 6352);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (650, 8010);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (651, 6349);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (651, 6350);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (651, 6351);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (652, 6345);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (653, 6346);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (653, 6347);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (654, 6325);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (655, 6333);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (655, 6335);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (655, 6337);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (656, 6333);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (656, 6334);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (656, 6338);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (656, 6339);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (657, 6336);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (657, 6342);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (657, 6343);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (658, 6352);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (658, 6353);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (659, 13669);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (660, 6356);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (660, 6357);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (660, 6358);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (660, 6359);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (660, 6360);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (661, 6355);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (662, 6341);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (663, 6312);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (664, 6312);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (664, 6313);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (665, 4984);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (665, 6324);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (666, 6352);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (666, 6353);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (667, 6183);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (668, 6177);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (669, 6179);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (669, 6184);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (670, 6175);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (670, 6176);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (670, 6182);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (670, 6184);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (670, 6185);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (670, 6186);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (671, 8132);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (672, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (673, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (674, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (675, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (676, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (677, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (677, 14117);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (678, 6352);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (678, 6353);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (678, 8085);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (679, 320);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (679, 6209);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (679, 259);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (679, 269);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (679, 277);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (679, 285);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (680, 6210);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (680, 288);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (681, 620);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (681, 621);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (682, 309);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (683, 6212);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (683, 6187);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (683, 6191);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (683, 6196);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (684, 1189);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (685, 1172);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (686, 1188);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (686, 1201);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (686, 1202);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (686, 1182);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (686, 1194);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (686, 1203);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (687, 1605);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (688, 1604);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (689, 1615);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (689, 1610);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (689, 1616);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (690, 1482);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (690, 1483);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (690, 1484);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (690, 1485);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (690, 1759);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (690, 1471);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (690, 1476);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (690, 1694);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 8568);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 8577);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 8578);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 8634);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 8635);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 8636);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 8641);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 8643);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 8649);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 8650);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 9179);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 9180);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 9261);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 9266);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (691, 13739);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (692, 7583);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (692, 7591);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (692, 7602);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (692, 7636);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (692, 7844);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (693, 6218);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (693, 6227);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (694, 6195);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (694, 6273);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (694, 6289);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (694, 6295);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (695, 6290);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (695, 8298);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (696, 6241);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (697, 6185);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (697, 6186);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (697, 6167);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (698, 6348);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (699, 312);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (700, 317);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (701, 300);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (701, 301);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (701, 302);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (701, 303);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (701, 304);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (701, 305);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (701, 6211);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 298);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 306);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 307);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 318);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6175);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6180);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6181);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6185);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6186);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6272);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6274);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6275);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6276);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6277);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6304);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6305);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6306);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6307);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6308);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6309);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6310);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6311);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6315);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6316);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6317);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6318);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6319);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6320);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6321);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6322);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6323);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6352);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6353);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6361);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 14111);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 14117);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6213);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6231);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6251);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6260);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6278);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6370);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (702, 6377);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (703, 6149);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (704, 6160);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (704, 8010);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (705, 8085);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (706, 6149);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (706, 6150);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (707, 4983);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (707, 6160);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (707, 6161);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (708, 6127);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (708, 6128);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (709, 6146);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (710, 6145);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (710, 6149);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (711, 6139);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (711, 13671);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (711, 13675);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (711, 13677);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (711, 13678);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (711, 13679);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (712, 13664);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (713, 13662);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (713, 13668);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (713, 13669);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (714, 6176);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (714, 6177);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (714, 6184);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (715, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (716, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (717, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (718, 13960);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (719, 13986);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (719, 14117);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (720, 6160);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (720, 6161);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (721, 320);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (721, 259);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (721, 269);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (721, 277);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (721, 285);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (722, 288);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (723, 312);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (724, 309);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (724, 6152);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (724, 6116);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (725, 301);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (725, 6136);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (726, 318);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (726, 621);
INSERT INTO rl_ciap_cid10 (co_ciap, co_cid10) VALUES (726, 6143);

DROP TABLE AGENDAMENTO_EXAME_LISTA CASCADE;

insert into permissoes (perm_descricao,perm_programa,perm_objeto) values ('ZF -Relatrio Exames agendados por paciente','zf/relatorio/laboratorio/form-rel-por-paciente','zf/relatorio/laboratorio/form-rel-por-paciente');
alter table usuario add column usu_sit_rua boolean;