UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.91.90' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.71.59' WHERE conf_chave='VERSAO_COMUM';
update usuarios set con_codigo = null;
DELETE FROM conselho;
ALTER TABLE conselho
  ADD COLUMN no_conselho character varying;
ALTER TABLE conselho
  ADD COLUMN no_curto_conselho character varying;

INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (19, 'CREF', 'CONSELHO REGIONAL DE EDUCAO FSICA', 'EDUCAO FSICA');
INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (23, 'CRR', 'CONSELHO REGIONAL RADIOLOGIA', 'RADIOLOGIA');
INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (17, 'CRFA', 'CONSELHO REGIONAL DE FONOAUDIOLOGIA', 'FONOAUDIOLOGIA');
INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (66, 'COREN', 'CONSELHO REGIONAL DE ENFERMAGEM', 'ENFERMAGEM');
INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (62, 'CRESS', 'CONSELHO REGIONAL DE ASSISTNCIA SOCIAL', 'ASSISTNCIA SOCIAL');
INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (69, 'CRF', 'CONSELHO REGIONAL DE FARMCIA', 'FARMCIA');
INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (70, 'CREFITO', 'CONSELHO REGIONAL DE FISIOTERAPIA', 'FISIOTERAPIA');
INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (71, 'CRM', 'CONSELHO REGIONAL DE MEDICINA', 'MEDICINA');
INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (74, 'CRN', 'CONSELHO REGIONAL DE NUTRIO', 'NUTRIO');
INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (75, 'CRO', 'CONSELHO REGIONAL DE ODONTOLOGIA', 'ODONTOLOGIA');
INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (77, 'CRP', 'CONSELHO REGIONAL DE PSICOLOGIA', 'PSICOLOGIA');
INSERT INTO conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) VALUES (83, 'RMS', 'MINISTRIO DA SADE', 'REGISTRO DO MINISTRIO DA SADE');
insert into conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) values (15, 'CRBM', 'CONSELHO REGIONAL DE BIOMEDICINA','BIOMEDICINA');
insert into conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) values (18, 'CRBIO','CONSELHO REGIONAL DE BIOLOGIA','BIOLOGIA');
insert into conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) values (26, 'CRTR','CONSELHO REGIONAL DE TCNICOS DE RADIOLOGIA','RADIOLOGIA');
insert into conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) values (61, 'CRA','CONSELHO REGIONAL DE ADMINISTRAO','ADM');
insert into conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) values (64, 'CRC','CONSELHO REGIONAL DE CONTABILIDADE','CONTABILIDADE');
insert into conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) values (67, 'CREA','CONSELHO REGIONAL DE ENGENHARIA, ARQUITETURA E AGRONOMIA','AGRONOMIA');
insert into conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) values (72, 'CRMV','CONSELHO REGIONAL DE MEDICINA VETERINRIA','MEDICINA VETERINRIA');
insert into conselho (con_codigo, con_descricao, no_conselho, no_curto_conselho) values (78, 'CRQ','CONSELHO REGIONAL DE QUMICA','QUMICA');

insert into permissoes (perm_descricao,perm_programa,perm_objeto)values ('ZF - CNES WEB','zf/programasfederais/cnes-web','zf/programasfederais/cnes-web');

CREATE TABLE tb_complexidade
(
  co_complexidade bigint NOT NULL,
  no_complexidade character varying,
  sg_complexidade character varying,
  CONSTRAINT tb_complexidade_pkey PRIMARY KEY (co_complexidade)
)
WITH (
  OIDS=FALSE
);

INSERT INTO tb_complexidade (co_complexidade, no_complexidade, sg_complexidade) VALUES (1, 'ATENO BSICA', 'AB');
INSERT INTO tb_complexidade (co_complexidade, no_complexidade, sg_complexidade) VALUES (2, 'MDIA COMPLEXIDADE', 'MC');
INSERT INTO tb_complexidade (co_complexidade, no_complexidade, sg_complexidade) VALUES (3, 'ALTA COMPLEXIDADE', 'AC');
INSERT INTO tb_complexidade (co_complexidade, no_complexidade, sg_complexidade) VALUES (0, 'NO SE APLICA', 'NA');
INSERT INTO tb_complexidade (co_complexidade, no_complexidade, sg_complexidade) VALUES (4, 'MDIA COMPLEXIDADE HOSPITALAR', 'MH');
INSERT INTO tb_complexidade (co_complexidade, no_complexidade, sg_complexidade) VALUES (5, 'ALTA COMPLEXIDADE HOSPITALAR', 'AH');
INSERT INTO tb_complexidade (co_complexidade, no_complexidade, sg_complexidade) VALUES (6, 'INTERNAO HOSPITALAR', 'IH');


CREATE TABLE social.unidade_complexidade
(
   unc_codigo bigserial, 
   uni_codigo bigint, 
   co_complexidade bigint, 
   PRIMARY KEY (unc_codigo), 
   FOREIGN KEY (uni_codigo) REFERENCES unidade (uni_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   FOREIGN KEY (co_complexidade) REFERENCES tb_complexidade (co_complexidade) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
);

CREATE TABLE social.TB_LOCAL_ATEND (
    CO_LOCAL_ATEND bigint NOT NULL,
    NO_LOCAL_ATEND VARCHAR(255),
    NO_LOCAL_ATEND_FILTRO VARCHAR(100),
    ST_LOCAL_CDS integer,
    ST_LOCAL_AD integer,
	CONSTRAINT co_local_atend_pkey PRIMARY KEY(CO_LOCAL_ATEND)
);

CREATE SEQUENCE social.seq_co_local_atend
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
GRANT SELECT, UPDATE ON TABLE seq_co_local_atend TO public;
ALTER TABLE TB_LOCAL_ATEND ALTER COLUMN CO_LOCAL_ATEND SET DEFAULT nextval(('seq_co_local_atend'::text)::regclass);

INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('1','01 - UBS','01 - ubs','1','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('2','02 - UNIDADE MVEL','02 - unidade movel','1','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('3','03 - RUA','03 - rua','1','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('4','04 - DOMICLIO','04 - domicilio','1','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('5','05 - ESCOLA/CRECHE','05 - escola/creche','1','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('6','06 - OUTROS','06 - outros','1','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('7','07 - POLO (ACADEMIA DA SADE)','07 - polo (academia da saude)','1','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('8','08 - INSTITUIO/ABRIGO','08 - instituicao/abrigo','1','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('9','09 - UNIDADE PRISIONAL OU CONGNERES','09 - unidade prisional ou congeneres','1','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('10','10 - UNIDADE SOCIOEDUCATIVA','10 - unidade socioeducativa','1','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('11','11 - HOSPITAL','11 - hospital','0','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('12','12 - UNIDADE DE PRONTO ATENDIMENTO','12 - unidade de pronto atendimento','0','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('13','13 - CACON/UNACON','13 - cacon/unacon','0','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('14','14 - EMERGNCIA HOSPITAL SOS','14 - emergencia hospital sos','0','1');
INSERT INTO TB_LOCAL_ATEND (CO_LOCAL_ATEND,NO_LOCAL_ATEND,NO_LOCAL_ATEND_FILTRO,ST_LOCAL_CDS,ST_LOCAL_AD) VALUES ('15','15 - HOSPITAL SOS DEMAIS SETORES','15 - hospital sos demais setores','0','1');

CREATE TABLE social.tb_equipe
(
   co_seq_equipe bigserial, 
   nu_ine bigint, 
   st_ativo character(1), 
   uni_codigo bigint, 
   qt_referencia bigint, 
   tp_equipe bigint, 
   ds_area character varying, 
   no_equipe character varying, 
   no_equipe_filtro character varying, 
   PRIMARY KEY (co_seq_equipe), 
   FOREIGN KEY (uni_codigo) REFERENCES unidade (uni_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;

CREATE TABLE social.tb_tipo_equipe
(
   co_seq_tipo_equipe bigint, 
   sg_tipo_equipe character varying, 
   no_tipo_equipe character varying, 
   sg_tipo_equipe_filtro character varying, 
   no_tipo_equipe_filtro character varying, 
   tp_emad character varying, 
   tp_emap character varying, 
   nu_ms character varying, 
   no_identificador character varying, 
   PRIMARY KEY (co_seq_tipo_equipe)
) 
WITH (
  OIDS = FALSE
)
;


INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (1, 'ESF', 'EQUIPE DE SAUDE DA FAMILIA', 'esf', 'equipe de saude da familia', '0', '0', '01', 'ESF');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (2, 'ESFSB_M1', 'ESF COM SAUDE BUCAL - M I', 'esfsb_m1', 'esf com saude bucal - m i', '0', '0', '02', 'ESFSB_M1');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (3, 'ESFSB_M2', 'ESF COM SAUDE BUCAL - M II', 'esfsb_m2', 'esf com saude bucal - m ii', '0', '0', '03', 'ESFSB_M2');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (4, 'EACS', 'EQUIPE DE AGENTES COMUNITARIOS DE SAUDE', 'eacs', 'equipe de agentes comunitarios de saude', '0', '0', '04', 'EACS');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (5, 'EPEN', 'EQUIPE DE AT. SAUDE SIST. PENITENCIARIO', 'epen', 'equipe de at. saude sist. penitenciario', '0', '0', '05', 'EPEN');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (6, 'ENASF1', 'EQUIPE DO NUCLEO DE APOIO A SAUDE DA FAMILIA 1', 'emasf1', 'equipe do nucleo de apoio a saude da familia 1', '0', '0', '06', 'ENASF1');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (7, 'ENASF2', 'EQUIPE DO NUCLEO DE APOIO A SAUDE DA FAMILIA 2', 'enasf2', 'equipe do nucleo de apoio a saude da familia 2', '0', '0', '07', 'ENASF2');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (8, 'EMSI', 'EQ MULTIDISC AT BASICA SAUDE INDIGENA', 'emsi', 'eq multidisc at basica saude indigena', '0', '0', '08', 'EMSI');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (9, 'EMSIAL', 'EQ MULTIDISC AT BASICA SAUDE INDIGENA-AMAZONIA LEGAL', 'emsial', 'eq multidisc at basica saude indigena-amazonia legal', '0', '0', '09', 'EMSIAL');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (10, 'EACSSB_M1', 'EQ AGENTES COMUNITRIOS COM SAUDE BUCAL - MI', 'eacssb_m1', 'eq agentes comunitrios com saude bucal - mi', '0', '0', '10', 'EACSSB_M1');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (11, 'EACSSB_M2', 'EQ AGENTES COMUNITRIOS COM SAUDE BUCAL - MII', 'eacssb_m2', 'eq agentes comunitrios com saude bucal - mii', '0', '0', '11', 'EACSSB_M2');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (12, 'ESFR', 'EQUIPE DE SAUDE DA FAMILIA RIBEIRINHA', 'esfr', 'equipe de saude da familia ribeirinha', '0', '0', '12', 'ESFR');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (13, 'ESFRSB_MI', 'ESF RIBEIRINHA COM SAUDE BUCAL MI', 'esfrsb_mi', 'esf ribeirinha com saude bucal mi', '0', '0', '13', 'ESFRSB_MI');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (14, 'ESFF', 'EQUIPE DE SAUDE DA FAMILIA FLUVIAL', 'esff', 'equipe de saude da familia fluvial', '0', '0', '14', 'ESFF');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (15, 'ESFFSB', 'ESF FLUVIAL COM SAUDE BUCAL', 'esffsb', 'esf fluvial com saude bucal', '0', '0', '15', 'ESFFSB');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (16, 'EAB1', 'EQUIPE DE ATENCAO BASICA TIPO I', 'eab1', 'equipe de atencao basica tipo i', '0', '0', '16', 'EAB1');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (17, 'EAB2', 'EQUIPE DE ATENCAO BASICA TIPO II', 'eab2', 'equipe de atencao basica tipo ii', '0', '0', '17', 'EAB2');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (18, 'EAB3', 'EQUIPE DE ATENCAO BASICA TIPO III ', 'eab3', 'equipe de atencao basica tipo iii', '0', '0', '18', 'EAB3');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (19, 'EAB1SB', 'EQUIPE DE ATENCAO BASICA TIPO I COM SAUDE BUCAL', 'eab1sb', 'equipe de atencao basica tipo i com saude bucal', '0', '0', '19', 'EAB1SB');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (20, 'EAB2SB', 'EQUIPE DE ATENCAO BASICA TIPO II COM SAUDE BUCAL', 'eab2sb', 'equipe de atencao basica tipo ii com saude bucal', '0', '0', '20', 'EAB2SB');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (21, 'EAB3SB', 'EQUIPE DE ATENCAO BASICA TIPO III COM SAUDE BUCAL', 'eab3sb', 'equipe de atencao basica tipo iii com saude bucal', '0', '0', '21', 'EAB3SB');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (22, 'EMAD', 'EQUIPE MULTIDISCIPLINAR DE ATENCAO DOMICILIAR', 'emad', 'equipe multidisciplinar de atencao domiciliar', '1', '0', '22', 'EMAD');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (23, 'EMAP', 'EQUIPE MULTIDISCIPLINAR DE APOIO', 'emap', 'equipe multidisciplinar de apoio', '0', '1', '23', 'EMAP');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (24, 'ESF1', 'ESTRATEGIA DE SAUDE DA FAMILIA TIPO I', 'esf1', 'estrategia de saude da familia tipo i', '0', '0', '24', 'ESF1');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (25, 'ESF1SB_M1', 'ESF TIPO I COM SAUDE BUCAL MODALIDADE I', 'esf1sb_m1', 'esf tipo i com saude bucal modalidade i', '0', '0', '25', 'ESF1SB_M1');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (26, 'ESF1SB_M2', 'ESF TIPO I COM SAUDE BUCAL MODALIDADE II', 'esf1sb_m2', 'esf tipo i com saude bucal modalidade ii', '0', '0', '26', 'ESF1SB_M2');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (27, 'ESF2', 'ESTRATEGIA DE SAUDE DA FAMILIA TIPO II', 'esf2', 'estrategia de saude da familia tipo ii', '0', '0', '27', 'ESF2');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (28, 'ESF2SB_M1', 'ESF TIPO II COM SAUDE BUCAL MODALIDADE I', 'esf2sb_m1', 'esf tipo ii com saude bucal modalidade i', '0', '0', '28', 'ESF2SB_M1');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (29, 'ESF2SB_M2', 'ESF TIPO II COM SAUDE BUCAL MODALIDADE II', 'esf2sb_m2', 'esf tipo ii com saude bucal modalidade ii', '0', '0', '29', 'ESF2SB_M2');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (30, 'ESF3', 'ESTRATEGIA DE SAUDE DA FAMILIA TIPO III', 'esf3', 'estrategia de saude da familia tipo iii', '0', '0', '30', 'ESF3');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (31, 'ESF3SB_M1', 'ESF TIPO III COM SAUDE BUCAL MODALIDADE I', 'esf3sb_m1', 'esf tipo iii com saude bucal modalidade i', '0', '0', '31', 'ESF3SB_M1');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (32, 'ESF3SB_M2', 'ESF TIPO III COM SAUDE BUCAL MODALIDADE II', 'esf3sb_m2', 'esf tipo iii com saude bucal modalidade ii', '0', '0', '32', 'ESF3SB_M2');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (33, 'ESF4', 'ESTRATEGIA DE SAUDE DA FAMILIA TIPO IV', 'esf4', 'estrategia de saude da familia tipo iv', '0', '0', '33', 'ESF4');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (34, 'ESF4SB_M1', 'ESF TIPO IV COM SAUDE BUCAL MODALIDADE I', 'esf4sb_m1', 'esf tipo iv com saude bucal modalidade i', '0', '0', '34', 'ESF4SB_M1');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (35, 'ESF4SB_M2', 'ESF TIPO IV COM SAUDE BUCAL MODALIDADE II', 'esf4sb_m2', 'esf tipo iv com saude bucal modalidade ii', '0', '0', '35', 'ESF4SB_M2');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (36, 'ESFTRANS', 'ESF TRANSITORIA', 'esftrans', 'esf transitoria', '0', '0', '36', 'ESFTRANS');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (37, 'ESFTRANSSB_M1', 'ESF TRANSITORIA COM SAUDE BUCAL MI', 'esftranssb_m1', 'esf transitoria com saude bucal mi', '0', '0', '37', 'ESFTRANSSB_M1');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (38, 'ESFTRANSSB_M2', 'ESF TRANSITORIA COM SAUDE BUCAL MII', 'esftranssb_m2', 'esf transitoria com saude bucal mii', '0', '0', '38', 'ESFTRANSSB_M2');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (39, 'ESFRSB_MII', 'ESF RIBEIRINHA COM SAUDE BUCAL MII', 'esfrsb_mii', 'esf ribeirinha com saude bucal mii', '0', '0', '39', 'ESFRSB_MII');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (40, 'ECR MI', 'EQUIPE DOS CONSULTORIOS NA RUA MODALIDADE I', 'ecr mi', 'equipe dos consultorios na rua modalidade i', '0', '0', '40', 'ECR_MI');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (41, 'ECR MII', 'EQUIPE DOS CONSULTORIOS NA RUA MODALIDADE II', 'ecr mii', 'equipe dos consultorios na rua modalidade ii', '0', '0', '41', 'ECR_MII');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (42, 'ECR MIII', 'EQUIPE DOS CONSULTORIOS NA RUA MODALIDADE III', 'ecr miii', 'equipe dos consultorios na rua modalidade iii', '0', '0', '42', 'ECR_MIII');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (43, 'ESB MI', 'EQUIPE DE SAUDE BUCAL MODALIDADE I', 'esb mi', 'equipe de saude bucal modalidade i', '0', '0', '43', 'ESB_MI');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (44, 'ESB MII', 'EQUIPE DE SAUDE BUCAL MODALIDADE II', 'esb mii', 'equipe de saude bucal modalidade ii', '0', '0', '44', 'ESB_MII');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (45, 'NASF3', 'NUCLEO DE APOIO A SAUDE DA FAMILIA-NASF MODALIDADE 3', 'nasf3', 'nucleo de apoio a saude da familia-nasf modalidade 3', '0', '0', '45', 'NASF3');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (46, 'EMAD_T2', 'EQUIPE MULTIDISCIPLINAR ATENCAO DOMICILIAR TIPO 2', 'emad_t2', 'equipe multidisciplinar atencao domiciliar tipo 2', '1', '0', '46', 'EMAD_T2');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (47, 'ECD', 'EQUIPE DE CUIDADOS DOMICILIARES', 'ecd', 'equipe de cuidados domiciliares', '0', '0', '47', 'ECD');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (48, 'ESSE', 'EQUIPE EXCLUSIVA DE SADE NA ESCOLA', 'eese', 'equipe exclusiva de saude na escola', '0', '0', '48', 'ESSE');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (49, 'EAP', 'EQUIPE DE AVALIAO E ACOMPANHAMENTO DE MEDIDAS TERAPUTICAS APLICVEIS  PESSOA COM TRANSTORNO MENTAL EM CONFLITO COM A LEI', 'eap', 'equipe de avaliacao e acompanhamento de medidas terapeuticas aplicaveis a pessoa com transtorno mental em conflito com a lei', '0', '0', '49', 'EAP');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (50, 'EABP-I', 'EQUIPE DE ATENO BSICA PRISIONAL TIPO I', 'eabp-i', 'equipe de atencao basica prisional tipo i', '0', '0', '50', 'EABP_I');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (51, 'EABP-I COM SADE MENTAL', 'EQUIPE DE ATENO BSICA PRISIONAL TIPO I COM SADE MENTAL', 'eabp-i com saude mental', 'equipe de atencao basica prisional tipo i com saude mental', '0', '0', '51', 'EABP_I_COM_SAUDE_MENTAL');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (52, 'EABP-II', 'EQUIPE DE ATENO BSICA PRISIONAL TIPO II', 'eabp-ii', 'equipe de atencao basica prisional tipo ii', '0', '0', '52', 'EABP_II');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (53, 'EABP-II COM SADE MENTAL', 'EQUIPE DE ATENO BSICA PRISIONAL TIPO II COM SADE MENTAL', 'eabp-ii com saude mental', 'equipe de atencao basica prisional tipo ii com saude mental', '0', '0', '53', 'EABP_II_COM_SAUDE_MENTAL');
INSERT INTO tb_tipo_equipe (co_seq_tipo_equipe, sg_tipo_equipe, no_tipo_equipe, sg_tipo_equipe_filtro, no_tipo_equipe_filtro, tp_emad, tp_emap, nu_ms, no_identificador) VALUES (54, 'EABP-III', 'EQUIPE DE ATENO BSICA PRISIONAL TIPO III', 'eabp-iii', 'equipe de atencao basica prisional tipo iii', '0', '0', '54', 'EABP_III');


alter table usuarios add column usr_ibge integer;

ALTER TABLE atendimento ADD COLUMN co_local_atend bigint;
ALTER TABLE atendimento ADD CONSTRAINT co_local_atend_fkey 
FOREIGN KEY (co_local_atend) REFERENCES tb_local_atend(co_local_atend)
MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION;

CREATE TABLE social.usuarios_equipe
(
   co_equipe bigint, 
   usr_codigo bigint, 
   PRIMARY KEY (usr_codigo, co_equipe)
) 
WITH (
  OIDS = FALSE
)
;


CREATE TABLE social.rl_cds_atend_individual_condut (
    co_rl_cds_atend_individual_condut bigint NOT NULL,
	ate_codigo bigint NOT NULL,
    tp_cds_conduta bigint NOT NULL,
	CONSTRAINT co_rl_cds_atend_individual_condut_pkey PRIMARY KEY(co_rl_cds_atend_individual_condut),
	CONSTRAINT ate_codigo_fkey FOREIGN KEY(ate_codigo)
	REFERENCES atendimento(ate_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT tp_cds_conduta_fkey FOREIGN KEY(tp_cds_conduta)
	REFERENCES tb_cds_tipo_conduta(co_cds_tipo_conduta) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION 
);

CREATE SEQUENCE social.seq_co_rl_cds_atend_individual_condut
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
GRANT SELECT, UPDATE ON TABLE seq_co_rl_cds_atend_individual_condut TO public;

ALTER TABLE RL_CDS_ATEND_INDIVIDUAL_CONDUT ALTER COLUMN co_rl_cds_atend_individual_condut SET DEFAULT nextval(('seq_co_rl_cds_atend_individual_condut'::text)::regclass);

CREATE TABLE usuario_deficiencias
(
  usud_codigo bigint NOT NULL,
  co_pergunta_detalhe bigint NOT NULL,
  usu_codigo bigint NOT NULL,
  CONSTRAINT pk_usud_codigo PRIMARY KEY (usud_codigo),
  CONSTRAINT fk_co_pergunta_detalhe FOREIGN KEY (co_pergunta_detalhe)
      REFERENCES tb_pergunta_detalhe(co_pergunta_detalhe) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usu_codigo FOREIGN KEY (usu_codigo)
      REFERENCES usuario (usu_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
);

CREATE SEQUENCE social.seq_usud_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
GRANT SELECT, UPDATE ON TABLE seq_usud_codigo TO public;
ALTER TABLE usuario_deficiencias ALTER COLUMN usud_codigo SET DEFAULT nextval(('seq_usud_codigo'::text)::regclass);

ALTER TABLE usuario ADD COLUMN usu_deficiencia boolean;


insert into permissoes (perm_descricao,perm_programa,perm_objeto)values ('ZF - FICHA ODONTOLOGICA','zf/programasfederais/ficha-odontologica/','zf/programasfederais/ficha-odontologica');

UPDATE tb_cds_visita_dom_motivo SET no_cds_visita_dom_motivo = 'CONDICIONALIDADES DO BOLSA FAMLIA' WHERE co_cds_visita_dom_motivo = 30;

ALTER TABLE agendamento DROP CONSTRAINT agendamento_coni_codigo_fkey;

ALTER TABLE atendimento ALTER COLUMN ate_hora DROP NOT NULL;

