UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.93.92' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.71.59' WHERE conf_chave='VERSAO_COMUM';

insert into config (conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool,cac_codigo) values('COMPROVANTE_COLETA','Comprovante de Coleta','f',2,'f',1);

CREATE OR REPLACE FUNCTION remove_tipo_rua_nome()
  RETURNS numeric AS
$BODY$ 
DECLARE
    row   RECORD;
    linhas bigint;
BEGIN

    linhas = 0; 
    FOR row IN 
          SELECT rua_codigo,rua_nome 
            FROM rua
       LOOP
	       update rua set rua_nome = upper(row.rua_nome) where rua_codigo = row.rua_codigo;
		linhas = linhas + 1;
    END LOOP;
    return linhas;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

  select remove_tipo_rua_nome();
  drop function remove_tipo_rua_nome();
  
 CREATE OR REPLACE FUNCTION remove_tipo_rua_nome()
  RETURNS numeric AS
$BODY$ 
DECLARE
    row   RECORD;
    linhas bigint;
BEGIN

    linhas = 0; 
    FOR row IN 
          SELECT rua_codigo,rua_nome 
            FROM rua
       LOOP
	       update rua set rua_nome = (SELECT REPLACE(UPPER(rua_nome), 'RUA', '') from rua where rua_codigo = row.rua_codigo) where rua_codigo = row.rua_codigo;
	       update rua set rua_nome = (SELECT REPLACE(UPPER(rua_nome), 'AVENIDA', '') from rua where rua_codigo = row.rua_codigo) where rua_codigo = row.rua_codigo;
	       update rua set rua_nome = (SELECT REPLACE(UPPER(rua_nome), 'AV ', '') from rua where rua_codigo = row.rua_codigo) where rua_codigo = row.rua_codigo;
	       update rua set rua_nome = (SELECT REPLACE(UPPER(rua_nome), 'AV.', '') from rua where rua_codigo = row.rua_codigo) where rua_codigo = row.rua_codigo;
	       update rua set rua_nome = (SELECT REPLACE(UPPER(rua_nome), 'AV:', '') from rua where rua_codigo = row.rua_codigo) where rua_codigo = row.rua_codigo;
	       update rua set rua_nome = (SELECT REPLACE(UPPER(rua_nome), 'R.', '') from rua where rua_codigo = row.rua_codigo) where rua_codigo = row.rua_codigo;
	       update rua set rua_nome = (SELECT REPLACE(UPPER(rua_nome), 'R:', '') from rua where rua_codigo = row.rua_codigo) where rua_codigo = row.rua_codigo;
	       update rua set rua_nome = (SELECT REPLACE(UPPER(rua_nome), 'R ', '') from rua where rua_codigo = row.rua_codigo) where rua_codigo = row.rua_codigo;
	       update rua set rua_nome = (SELECT REPLACE(UPPER(rua_nome), 'ESTRADA ', '') from rua where rua_codigo = row.rua_codigo) where rua_codigo = row.rua_codigo;
	       update rua set rua_nome = (SELECT REPLACE(UPPER(rua_nome), 'PRACA ', '') from rua where rua_codigo = row.rua_codigo) where rua_codigo = row.rua_codigo;
	       update rua set rua_nome = (SELECT REPLACE(UPPER(rua_nome), 'PRAA ', '') from rua where rua_codigo = row.rua_codigo) where rua_codigo = row.rua_codigo;
		linhas = linhas + 1;
    END LOOP;
    return linhas;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

  SELECT remove_tipo_rua_nome();
  drop function remove_tipo_rua_nome();

CREATE TABLE esus_ficha_procedimento (
	efp_codigo bigserial,
	pat_codigo bigint NOT NULL,
	age_codigo bigint NOT NULL,
	proc_codigo bigint NOT NULL,
	co_local_atend bigint NOT NULL,
	efp_profissional_cns character varying(60) NOT NULL,
	efp_cbo_codigo_2002 character varying(60) NOT NULL,
	efp_cnes character varying(60) NOT NULL,
	efp_ine character varying(60),
	efp_dtatendimento date,
	efp_codigo_ibge_mun character varying(60) NOT NULL,
	efp_num_cartao_sus character varying(60),
	efp_dtnascimento date NOT NULL,
	efp_sexo character varying(20),
	efp_tipo_dado_serializado character varying(20) NOT NULL,
	efp_numprontuario character varying(30),
	efp_dtcadastro date,
	CONSTRAINT efp_codigo_pk PRIMARY KEY(efp_codigo),
	CONSTRAINT age_codigo_fk FOREIGN KEY(age_codigo)
	REFERENCES agendamento(age_codigo) MATCH SIMPLE 
	ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT proc_codigo_fk FOREIGN KEY(proc_codigo)
	REFERENCES procedimento(proc_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT co_local_atend_fk FOREIGN KEY(co_local_atend)
	REFERENCES tb_local_atend(co_local_atend) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION
); 

CREATE OR REPLACE FUNCTION esus_ficha_procedimentos() 
  RETURNS trigger AS 
$BODY$
DECLARE 
	-- Dados do Atendimento
	linha_ate RECORD;
	-- Dados da Pr-Consulta
	linha_pc RECORD;
	efp_sexo character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		--RAISE NOTICE '1111111111''.',OLD.pat_codigo;
		DELETE FROM esus_ficha_procedimento WHERE pat_codigo = OLD.pat_codigo;
		RETURN OLD;
	ELSE
		-- Valida se o procedimento est vindo do Atendimento ou da Pr-Consulta
		IF (NEW.ate_codigo IS NOT NULL) THEN
			FOR linha_ate IN
				SELECT 
					ate.age_codigo,
					pat.pat_codigo,
					pat.proc_codigo,
					tbl.co_local_atend,
					usr.cnes_cod_cns AS efp_profissional_cns,
					esp.cod_cbo AS efp_cbo_codigo_2002,
					uni.uni_cnes AS efp_cnes,
					tbe.nu_ine AS efp_ine,
					ate.ate_data AS efp_dtatendimento,
					uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
					usu.usu_cartao_sus AS efp_num_cartao_sus,
					usu.usu_datanasc AS efp_dtnascimento,
					usu.usu_prontuario AS efp_numprontuario, 
					usu.usu_sexo
				FROM 
					procedimento_atendimento AS pat 
				INNER JOIN 
					atendimento AS ate ON pat.ate_codigo=ate.ate_codigo
				INNER JOIN 
					agendamento AS age ON ate.age_codigo=age.age_codigo
				INNER JOIN 
					especialidade AS esp ON age.esp_codigo=esp.esp_codigo
				INNER JOIN 
					usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
				INNER JOIN
					usuario AS usu ON ate.usu_codigo=usu.usu_codigo
				INNER JOIN
					unidade AS uni ON ate.uni_codigo=uni.uni_codigo
				INNER JOIN 
					tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
				INNER JOIN 
					tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
				WHERE 
					pat.pat_codigo = NEW.pat_codigo LOOP
					
				IF (linha_ate.age_codigo IS NOT NULL AND linha_ate.proc_codigo IS NOT NULL AND linha_ate.co_local_atend IS NOT NULL AND linha_ate.efp_profissional_cns IS NOT NULL AND linha_ate.efp_cbo_codigo_2002 IS NOT NULL AND linha_ate.efp_cnes IS NOT NULL AND linha_ate.efp_codigo_ibge_mun IS NOT NULL AND linha_ate.efp_dtnascimento IS NOT NULL) THEN			
					-- Validao de sexo
					IF (linha_ate.usu_sexo='M') THEN 
						efp_sexo = '0 L';
					ELSE
						efp_sexo = '1 L';
					END IF;
					-- Realiza a insero dos da ficha de procedimento do E-SUS
					INSERT INTO esus_ficha_procedimento(
						age_codigo,
						pat_codigo,
						proc_codigo,
						co_local_atend,
						efp_profissional_cns,
						efp_cbo_codigo_2002,
						efp_cnes,
						efp_ine,
						efp_dtatendimento,
						efp_codigo_ibge_mun,
						efp_num_cartao_sus,
						efp_dtnascimento,
						efp_numprontuario,
						efp_sexo,
						efp_tipo_dado_serializado,
						efp_dtcadastro
					) VALUES (
						linha_ate.age_codigo,
						linha_ate.pat_codigo,
						linha_ate.proc_codigo,
						linha_ate.co_local_atend,
						linha_ate.efp_profissional_cns,
						linha_ate.efp_cbo_codigo_2002,
						linha_ate.efp_cnes,
						linha_ate.efp_ine,
						linha_ate.efp_dtatendimento,
						linha_ate.efp_codigo_ibge_mun,
						linha_ate.efp_num_cartao_sus,
						linha_ate.efp_dtnascimento,
						linha_ate.efp_numprontuario,
						efp_sexo,
						'7 L',
						'NOW()'
					);
					RETURN NEW;
					RAISE NOTICE 'Registro inserido com sucesso''.';
				END IF;	
			END LOOP;
		END IF;
		IF (NEW.pc_codigo IS NOT NULL) THEN
			--RAISE NOTICE '1111111111''.';
			FOR linha_pc IN
				SELECT 
					pc.age_codigo,
					pat.pat_codigo,
					pat.proc_codigo,
					tbl.co_local_atend,
					usr.cnes_cod_cns AS efp_profissional_cns,
					esp.cod_cbo AS efp_cbo_codigo_2002,
					uni.uni_cnes AS efp_cnes,
					tbe.nu_ine AS efp_ine,
					pc.pc_data AS efp_dtatendimento,
					uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
					usu.usu_cartao_sus AS efp_num_cartao_sus,
					usu.usu_datanasc AS efp_dtnascimento,
					usu.usu_prontuario AS efp_numprontuario, 
					usu.usu_sexo
				FROM 
					procedimento_atendimento AS pat 
				INNER JOIN 
					pre_consulta AS pc ON pat.pc_codigo=pc.pc_codigo
				INNER JOIN 
					agendamento AS age ON pc.age_codigo=age.age_codigo
				INNER JOIN 
					especialidade AS esp ON age.esp_codigo=esp.esp_codigo
				INNER JOIN 
					usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
				INNER JOIN
					usuario AS usu ON age.usu_codigo=usu.usu_codigo
				INNER JOIN
					unidade AS uni ON age.uni_codigo=uni.uni_codigo
				INNER JOIN 
					tb_local_atend AS tbl ON pc.co_local_atend=tbl.co_local_atend
				INNER JOIN 
					tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
				WHERE 
					pat.pat_codigo = NEW.pat_codigo LOOP
				
				IF (linha_pc.age_codigo IS NOT NULL AND linha_pc.proc_codigo IS NOT NULL AND linha_pc.co_local_atend IS NOT NULL AND linha_pc.efp_profissional_cns IS NOT NULL AND linha_pc.efp_cbo_codigo_2002 IS NOT NULL AND linha_pc.efp_cnes IS NOT NULL AND linha_pc.efp_codigo_ibge_mun IS NOT NULL AND linha_pc.efp_dtnascimento IS NOT NULL) THEN
					-- Validao de sexo
					IF (linha_pc.usu_sexo='M') THEN 
						efp_sexo = '0 L';
					ELSE
						efp_sexo = '1 L';
					END IF;
					-- Realiza a insero dos da ficha de procedimento do E-SUS
					INSERT INTO esus_ficha_procedimento(
						age_codigo,
						pat_codigo,
						proc_codigo,
						co_local_atend,
						efp_profissional_cns,
						efp_cbo_codigo_2002,
						efp_cnes,
						efp_ine,
						efp_dtatendimento,
						efp_codigo_ibge_mun,
						efp_num_cartao_sus,
						efp_dtnascimento,
						efp_sexo,
						efp_tipo_dado_serializado,
						efp_numprontuario,
						efp_dtcadastro
					) VALUES (
						linha_pc.age_codigo,
						linha_pc.pat_codigo,
						linha_pc.proc_codigo,
						linha_pc.co_local_atend,
						linha_pc.efp_profissional_cns,
						linha_pc.efp_cbo_codigo_2002,
						linha_pc.efp_cnes,
						linha_pc.efp_ine,
						linha_pc.efp_dtatendimento,
						linha_pc.efp_codigo_ibge_mun,
						linha_pc.efp_num_cartao_sus,
						linha_pc.efp_dtnascimento,
						efp_sexo,
						'7 L',
						linha_pc.efp_numprontuario,
						'NOW()'
					);
					RETURN NEW;
					RAISE NOTICE 'Registro inserido com sucesso''.';
				END IF;
			END LOOP;
		END IF;
	END IF;	
	RETURN NULL;
END;
$BODY$ 
LANGUAGE plpgsql;

CREATE TRIGGER atualiza_esus_ficha_procedimentos
AFTER INSERT OR UPDATE OR DELETE ON procedimento_atendimento 
FOR EACH ROW 
EXECUTE PROCEDURE esus_ficha_procedimentos();

ALTER TABLE pre_consulta ADD COLUMN co_local_atend bigint;
ALTER TABLE pre_consulta ADD CONSTRAINT co_local_atend_fk FOREIGN KEY(co_local_atend)
REFERENCES tb_local_atend(co_local_atend) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

INSERT INTO procedimento (proc_nome,proc_codigo_sus) VALUES ('EXAME DO PE DIABETICO','ABPG011');
INSERT INTO procedimento (proc_nome,proc_codigo_sus) VALUES ('AFERICAO DE TEMPERATURA','ABPG034');

CREATE OR REPLACE FUNCTION remove_chefe_familia_duplicado()
  RETURNS numeric AS
$BODY$ 
DECLARE
    row   RECORD;
    linhas bigint;
    dom_codigo_var bigint;
BEGIN

    linhas = 0; 
    FOR row IN 
          select usu_codigo_responsavel,  
		 count(usu_codigo_responsavel) as Quantidade  
	    from domicilio   
	   group by usu_codigo_responsavel   
	  having count(usu_codigo_responsavel) > 1 
    LOOP
	select dom_codigo into dom_codigo_var from usuario where usu_codigo = row.usu_codigo_responsavel;
	RAISE NOTICE 'aaaaaa %',dom_codigo_var;
        IF(dom_codigo_var is NULL) THEN 
		update domicilio set usu_codigo_responsavel = null where usu_codigo_responsavel = row.usu_codigo_responsavel;
	ELSE
		update domicilio set usu_codigo_responsavel = null where usu_codigo_responsavel = row.usu_codigo_responsavel and dom_codigo <> dom_codigo_var;
	END IF;
    END LOOP;
    return linhas;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

 SELECT remove_chefe_familia_duplicado();
 drop function remove_chefe_familia_duplicado(); 
 ALTER TABLE domicilio
  ADD UNIQUE (usu_codigo_responsavel);

  
  CREATE OR REPLACE FUNCTION maiusculo_complemento()
  RETURNS numeric AS
$BODY$ 
DECLARE
    row   RECORD;
    linhas bigint;
BEGIN

    linhas = 0; 
    FOR row IN 
          SELECT dom_codigo,dom_complemento
            FROM domicilio
       LOOP
	       update domicilio set dom_complemento = upper(row.dom_complemento) where dom_codigo = row.dom_codigo;
		linhas = linhas + 1;
    END LOOP;
    return linhas;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

select maiusculo_complemento();
drop function maiusculo_complemento();

CREATE TABLE esus_remente_originadora(
	ero_codigo bigserial,
	ero_contra_chave character varying(225),
	ero_cpf_cnpj character varying(20) NOT NULL,
	ero_nome_razao character varying(225) NOT NULL,
	ero_fone character varying(20),
	ero_email character varying(255),
	ero_status boolean DEFAULT TRUE,
	CONSTRAINT ero_codigo_pk PRIMARY KEY(ero_codigo)
);
