UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.94.93' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.71.59' WHERE conf_chave='VERSAO_COMUM';

alter table domicilio add column usr_codigo integer;
alter table domicilio add column uni_codigo integer;
alter table domicilio add column cod_equipe integer;

ALTER TABLE domicilio
   ALTER COLUMN dom_data_cadastro SET DEFAULT CURRENT_DATE;
ALTER TABLE domicilio
  ADD FOREIGN KEY (uni_codigo) REFERENCES unidade (uni_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE domicilio
  ADD FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE domicilio
  ADD FOREIGN KEY (cod_equipe) REFERENCES tb_equipe (co_seq_equipe) ON UPDATE NO ACTION ON DELETE NO ACTION;

CREATE TABLE esus_visita_domiciliar(
	esv_codigo bigserial NOT NULL,
	ate_codigo bigint NOT NULL,
	co_cds_visita_domiciliar bigint NOT NULL,
	esv_profissional_cns character varying(60) NOT NULL,
	esv_cbo_codigo_2002 character varying(60) NOT NULL,
	esv_cnes character varying(60) NOT NULL,
	esv_ine character varying(60),
	esv_turno character varying(60),
	esv_num_prontuario character varying(60),
	esv_usu_cns character varying(60),
	esv_usu_datanasc date NOT NULL,
	esv_usu_sexo character varying(20),
	esv_desfecho character varying(20),
	CONSTRAINT esv_codigo_pk PRIMARY KEY(esv_codigo),
	CONSTRAINT ate_codigo_fk FOREIGN KEY(ate_codigo)
	REFERENCES atendimento(ate_codigo) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT co_cds_visita_domiciliar_fk FOREIGN KEY(co_cds_visita_domiciliar)
	REFERENCES tb_cds_visita_domiciliar(co_seq_cds_visita_domiciliar) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION
);

ALTER TABLE esus_visita_domiciliar ADD COLUMN esv_status boolean default false;
ALTER TABLE esus_visita_domiciliar ADD COLUMN esv_dtatendimento date NOT NULL DEFAULT NOW();
ALTER TABLE esus_visita_domiciliar ADD COLUMN esv_codigo_ibge_mun character varying(20) NOT NULL;

CREATE OR REPLACE FUNCTION esus_visita_domiciliar()
	RETURNS TRIGGER AS
$BODY$
DECLARE
	linha RECORD;
	esv_sexo character varying(20);
	esv_desfecho character varying(20);
BEGIN 
	IF (TG_OP='INSERT') THEN
		FOR linha IN
			SELECT DISTINCT
				ate.ate_codigo,
				ate.ate_data,
				usr.cnes_cod_cns AS esv_profissional_cns,
				esp.cod_cbo AS esv_cbo_codigo_2002,
				uni.uni_cnes AS esv_cnes,
				uni.uni_codigo_ibge AS esv_codigo_ibge_mun,
				usu.usu_cartao_sus AS esv_usu_cns,
				usu.usu_datanasc AS esv_usu_datanasc,
				usu.usu_prontuario AS esv_num_prontuario, 
				usu.usu_sexo AS usu_sexo,
				tbvd.co_cds_visita_dom_desfecho AS desfecho,
				tbvd.co_seq_cds_visita_domiciliar AS co_cds_visita_domiciliar
			FROM 
				atendimento AS ate 
			INNER JOIN 
				agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN 
				especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN 
				usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
				usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
				unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN 
				tb_cds_visita_domiciliar AS tbvd ON ate.ate_codigo=tbvd.ate_codigo
			INNER JOIN 
				tb_cds_visita_dom_desfecho AS tbvdd ON tbvd.co_cds_visita_dom_desfecho=tbvdd.co_cds_visita_dom_desfecho
			WHERE 
				ate.ate_codigo = NEW.ate_codigo LOOP
			-- Validao Sexo
			IF (linha.usu_sexo='M') THEN esv_sexo = '0 L'; ELSE esv_sexo = '1 L'; END IF; 
			-- Validao Desfecho
			IF (linha.desfecho='1') THEN esv_desfecho = '1 L'; END IF;
			IF (linha.desfecho='2') THEN esv_desfecho = '2 L'; END IF;
			IF (linha.desfecho='3') THEN esv_desfecho = '3 L'; END IF;
			-- Valida Insero
			IF (linha.ate_codigo IS NOT NULL) THEN
				INSERT INTO esus_visita_domiciliar(
					ate_codigo,
					esv_profissional_cns,
					esv_cbo_codigo_2002,
					esv_cnes,
					esv_num_prontuario,
					esv_usu_cns,
					esv_usu_datanasc,
					esv_usu_sexo,
					esv_desfecho,
					co_cds_visita_domiciliar,
					esv_dtatendimento,
					esv_codigo_ibge_mun
				) VALUES (
					linha.ate_codigo,
					linha.esv_profissional_cns,
					linha.esv_cbo_codigo_2002,
					linha.esv_cnes,
					linha.esv_num_prontuario,
					linha.esv_usu_cns,
					linha.esv_usu_datanasc,
					esv_sexo,
					esv_desfecho,
					linha.co_cds_visita_domiciliar,
					linha.ate_data,
					linha.esv_codigo_ibge_mun
				);
				RETURN NEW;
			END IF;
		END LOOP;
	ELSE 
	
	END IF;
	RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql VOLATILE
COST 100;
	
CREATE TRIGGER atualiza_esus_visita_domiciliar
AFTER INSERT OR UPDATE OR DELETE ON tb_cds_visita_domiciliar 
FOR EACH ROW 
EXECUTE PROCEDURE esus_visita_domiciliar();

CREATE TABLE esus_atividade_coletiva(
	eav_codigo bigserial NOT NULL,
	co_cds_ficha_ativ_col bigint NOT NULL,
	eav_dt_atividade character varying(20) NOT NULL,
	eav_num_participantes_prog integer,
	eav_num_participantes integer,
	eav_local_atividade character varying(255),
	eav_hora_inicio character varying(20),
	eav_hora_fim character varying(20),
	eav_inep character varying(20),
	eav_responsavel_cns character varying(20) NOT NULL,
	eav_responsavel_cnes character varying(20) NOT NULL,
	eav_responsavel_ine character varying(20) NOT NULL,
	eav_num_aval_alteradas integer,
	eav_atividade_tipo character varying(20) NOT NULL,
	eav_codigo_ibge character varying(20) NOT NULL,
	CONSTRAINT eav_codigo_pk PRIMARY KEY(eav_codigo),
	CONSTRAINT eav_codigo_fk FOREIGN KEY(co_cds_ficha_ativ_col)
	REFERENCES tb_cds_ficha_ativ_col(co_cds_ficha_ativ_col) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION
);

ALTER TABLE esus_atividade_coletiva ADD COLUMN eav_uni_cnes character varying(20);

CREATE OR REPLACE FUNCTION esus_atividade_coletiva()
  RETURNS trigger AS
$BODY$
DECLARE
linha RECORD;
BEGIN
	FOR linha IN
		SELECT
			tb_fav.co_cds_ficha_ativ_col, 
			tb_fav.dt_ativ_col AS eav_dt_atividade,
			tb_fav.qt_participante_programado AS eav_num_participantes_prog,
			tb_fav.qt_participante_ativ AS eav_num_participantes,
			tb_fav.ds_local_ativ AS eav_local_atividade,
			tb_fav.hr_inicio AS eav_hora_inicio,
			tb_fav.hr_fim AS eav_hora_fim,
			usr.cnes_cod_cns AS eav_responsavel_cns,
			uni.uni_cnes AS eav_uni_cnes,
			tb_fav.cod_equipe_ine AS eav_responsavel_ine,
			tb_fav.cod_cnes_unidade AS eav_responsavel_cnes,
			tb_fav.qt_avaliacao_alterada AS eav_num_aval_alteradas,
			tb_fav.tp_cds_ativ_col AS eav_atividade_tipo,
			uni.uni_codigo_ibge AS eav_codigo_ibge,
			tb_fav.co_inep_escola AS eav_inep
		FROM 
			tb_cds_ficha_ativ_col AS tb_fav
		INNER JOIN
			usuarios AS usr ON tb_fav.usr_codigo=usr.usr_codigo
		INNER JOIN
			unidade AS uni ON tb_fav.uni_codigo=uni.uni_codigo
		WHERE 
			tb_fav.co_cds_ficha_ativ_col=NEW.co_cds_ficha_ativ_col	LOOP

		IF (TG_OP='INSERT') THEN
			IF linha.co_cds_ficha_ativ_col IS NOT NULL THEN				
				INSERT INTO esus_atividade_coletiva(
					co_cds_ficha_ativ_col,
					eav_dt_atividade,
					eav_num_participantes_prog,
					eav_num_participantes,
					eav_local_atividade,
					eav_hora_inicio,
					eav_hora_fim,
					eav_responsavel_cns,
					eav_responsavel_cnes,
					eav_responsavel_ine,
					eav_num_aval_alteradas,
					eav_atividade_tipo,
					eav_codigo_ibge,
					eav_inep,
					eav_uni_cnes
				) VALUES (
					linha.co_cds_ficha_ativ_col,
					linha.eav_dt_atividade,
					linha.eav_num_participantes_prog,
					linha.eav_num_participantes,
					linha.eav_local_atividade,
					linha.eav_hora_inicio,
					linha.eav_hora_fim,
					linha.eav_responsavel_cns,
					linha.eav_responsavel_cnes,
					linha.eav_responsavel_ine,
					linha.eav_num_aval_alteradas,
					linha.eav_atividade_tipo,
					linha.eav_codigo_ibge,
					linha.eav_inep,
					linha.eav_uni_cnes
				);
				RETURN NEW;
			END IF;
		ELSE 
			IF linha.co_cds_ficha_ativ_col IS NOT NULL THEN				
				UPDATE esus_atividade_coletiva 
					SET	co_cds_ficha_ativ_col = linha.co_cds_ficha_ativ_col,
						eav_dt_atividade = linha.eav_dt_atividade,
						eav_num_participantes_prog = linha.eav_num_participantes_prog,
						eav_num_participantes = linha.eav_num_participantes,
						eav_local_atividade = linha.eav_local_atividade,
						eav_hora_inicio = linha.eav_hora_inicio,
						eav_hora_fim = linha.eav_hora_fim,
						eav_responsavel_cns = linha.eav_responsavel_cns,
						eav_responsavel_cnes  = linha.eav_responsavel_cnes,
						eav_responsavel_ine  = linha.eav_responsavel_ine,
						eav_num_aval_alteradas = linha.eav_num_aval_alteradas,
						eav_atividade_tipo = linha.eav_atividade_tipo,
						eav_codigo_ibge = linha.eav_codigo_ibge,
						eav_inep = linha.eav_inep,
						eav_uni_cnes = linha.eav_uni_cnes
				WHERE 
					co_cds_ficha_ativ_col=NEW.co_cds_ficha_ativ_col;
				RETURN NEW;
			END IF;
		END IF;
	END LOOP;
RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
  
CREATE TRIGGER atualiza_esus_atividade_coletiva
AFTER INSERT OR UPDATE OR DELETE ON tb_cds_ficha_ativ_col
FOR EACH ROW EXECUTE PROCEDURE esus_atividade_coletiva();

ALTER TABLE tb_cds_ficha_ativ_col ADD COLUMN uni_codigo bigint;
ALTER TABLE tb_cds_ficha_ativ_col ADD CONSTRAINT uni_codigo_fk FOREIGN KEY(uni_codigo)
REFERENCES unidade(uni_codigo) MATCH SIMPLE
ON UPDATE NO ACTION ON DELETE NO ACTION;

insert into permissoes (perm_descricao,perm_programa,perm_objeto) values('ZF - Relatrio por entrada','zf/relatorio/materiais/form-movimento-entrada','zf/relatorio/materiais/form-movimento-entrada');
drop table tb_endereco;
drop table tb_bairro; 

CREATE TABLE distrito
(
  dis_codigo bigserial NOT NULL,
  dis_nome character varying,
  cid_codigo integer,
  CONSTRAINT distrito_pkey PRIMARY KEY (dis_codigo),
  CONSTRAINT distrito_cid_codigo_fkey FOREIGN KEY (cid_codigo)
      REFERENCES cidade (cid_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

insert into permissoes (perm_descricao,perm_programa,perm_objeto) values('ZF - Cadastro de Bairro','zf/domicilio/bairro','zf/domicilio/bairro');

ALTER TABLE bairro
  ADD COLUMN dis_codigo integer;
ALTER TABLE bairro
  ADD FOREIGN KEY (dis_codigo) REFERENCES distrito (dis_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
  
ALTER TABLE esus_atividade_coletiva ADD COLUMN eav_status boolean default false;

ALTER TABLE tb_cds_domicilio_resposta ADD COLUMN co_status boolean default false;

CREATE OR REPLACE FUNCTION migra_bairro_para_logradouro()
  RETURNS numeric AS
$BODY$ 
DECLARE
    row   RECORD;
    linhas bigint;
BEGIN

    linhas = 0; 
    FOR row IN 
          SELECT * FROM domicilio
           
       LOOP
	       update rua set bai_codigo = row.bai_codigo where rua_codigo = row.rua_codigo;
		linhas = linhas + 1;
    END LOOP;
    return linhas;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

select migra_bairro_para_logradouro();

ALTER TABLE domicilio
  DROP CONSTRAINT domicilio_bai_codigo_fkey;