UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.95.94' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.72.60' WHERE conf_chave='VERSAO_COMUM';

CREATE TABLE esus_odonto
(
  eo_codigo bigserial NOT NULL,
  odo_pcon_codigo bigint NOT NULL,
  co_local_atend bigint NOT NULL,
  eo_profissional_cns character varying(60) NOT NULL,
  eo_cbo_codigo_2002 character varying(60) NOT NULL,
  eo_cnes character varying(60) NOT NULL,
  eo_dtatendimento date NOT NULL,
  eo_codigo_ibge_mun character varying(60) NOT NULL,
  eo_dtnascimento date NOT NULL,
  eo_num_cartao_sus character varying(60),
  eo_numprontuario character varying(30),
  eo_tipo_atendimento character varying(20),
  eo_tipo_consulta character varying(20),
  eo_sexo character varying(20),
  eo_tipo_dado_serializado character varying(20) NOT NULL,
  uuid character varying(60),
  CONSTRAINT eo_codigo_pk PRIMARY KEY (eo_codigo),
  CONSTRAINT odo_pcon_codigo_fk FOREIGN KEY (odo_pcon_codigo)
      REFERENCES odonto_procedimentos_controle(odo_pcon_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT co_local_atend_fk FOREIGN KEY (co_local_atend)
      REFERENCES tb_local_atend (co_local_atend) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

CREATE OR REPLACE FUNCTION esus_odonto() 
  RETURNS trigger AS 
$BODY$
DECLARE 
	linha RECORD;
	eo_sexo character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM esus_odonto WHERE eo_codigo = OLD.eo_codigo;
		RETURN OLD;
	ELSE
		FOR linha IN
			SELECT DISTINCT
				odpc.odo_pcon_codigo,
				tbl.co_local_atend,
				usr.cnes_cod_cns AS eo_profissional_cns,
				esp.cod_cbo AS eo_cbo_codigo_2002,
				uni.uni_cnes AS eo_cnes,
				ate.ate_data AS eo_dtatendimento,
				uni.uni_codigo_ibge AS eo_codigo_ibge_mun,
				usu.usu_datanasc AS eo_dtnascimento,
				usu.usu_cartao_sus AS eo_num_cartao_sus,	
				usu.usu_prontuario AS eo_numprontuario,
				age.tat_codigo AS eo_tipo_atendimento,
				age.tp_cod AS eo_tipo_consulta,					
				usu.usu_sexo					
			FROM 
				odonto_procedimentos_controle AS odpc 
			INNER JOIN 
				atendimento AS ate ON odpc.ate_codigo=ate.ate_codigo
			INNER JOIN 
				agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN 
				especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN 
				usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
				usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
				unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN 
				tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
			WHERE 
				odpc.odo_pcon_codigo = NEW.odo_pcon_codigo LOOP
			-- Validao de sexo
			IF (linha.usu_sexo='M') THEN 
				eo_sexo = '0 L';
			ELSE
				eo_sexo = '1 L';
			END IF;
			-- Realiza a insero dos da ficha de procedimento do E-SUS
			INSERT INTO esus_odonto(
				odo_pcon_codigo,
				co_local_atend,
				eo_profissional_cns,
				eo_cbo_codigo_2002,
				eo_cnes,
				eo_dtatendimento,
				eo_codigo_ibge_mun,
				eo_dtnascimento,
				eo_num_cartao_sus,
				eo_numprontuario,
				eo_tipo_atendimento,
				eo_tipo_consulta,
				eo_sexo,
				eo_tipo_dado_serializado
			) VALUES (
				linha.odo_pcon_codigo,
				linha.co_local_atend,
				linha.eo_profissional_cns,
				linha.eo_cbo_codigo_2002,
				linha.eo_cnes,
				linha.eo_dtatendimento,
				linha.eo_codigo_ibge_mun,
				linha.eo_dtnascimento,
				linha.eo_num_cartao_sus,
				linha.eo_numprontuario,
				linha.eo_tipo_atendimento,
				linha.eo_tipo_consulta,
				eo_sexo,
				'5 L'
			);
			RETURN NEW;
			RAISE NOTICE 'Registro inserido com sucesso''.';
		END LOOP;
	END IF;	
	RETURN NULL;
END;
$BODY$ 
LANGUAGE plpgsql;

CREATE TRIGGER atualiza_esus_odonto
AFTER INSERT OR UPDATE OR DELETE ON odonto_procedimentos_controle 
FOR EACH ROW 
EXECUTE PROCEDURE esus_odonto();


insert into permissoes (perm_descricao,perm_programa,perm_objeto) values ('ZF - Cadastro de Domicilio','zf/domicilio/domicilio','zf/domicilio/domicilio');

ALTER TABLE tb_cds_domicilio_resposta ADD COLUMN uuid_ficha character varying(20);

CREATE TABLE esus_atendimento_individual
(
  eai_codigo bigserial NOT NULL,
  ate_codigo bigint NOT NULL,
  co_local_atend bigint NOT NULL,
  eai_profissional_cns character varying(60) NOT NULL,
  eai_cbo_codigo_2002 character varying(60) NOT NULL,
  eai_cnes character varying(60) NOT NULL,
  eai_dtatendimento date NOT NULL,
  eai_codigo_ibge_mun character varying(60) NOT NULL,
  eai_dtnascimento date NOT NULL,
  eai_num_cartao_sus character varying(60),
  eai_numprontuario character varying(30),
  eai_tipo_atendimento character varying(20),
  eai_sexo character varying(20),
  eai_tipo_dado_serializado character varying(20) NOT NULL,
  uuid_ficha character varying(60),
  CONSTRAINT eai_codigo_pk PRIMARY KEY (eai_codigo),
  CONSTRAINT ate_codigo_fk FOREIGN KEY (ate_codigo)
      REFERENCES atendimento(ate_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT co_local_atend_fk FOREIGN KEY (co_local_atend)
      REFERENCES tb_local_atend (co_local_atend) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

CREATE OR REPLACE FUNCTION esus_atendimento_individual() 
  RETURNS trigger AS 
$BODY$
DECLARE 
	linha RECORD;
	eai_sexo character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM esus_atendimento_individual WHERE eai_codigo = OLD.eai_codigo;
		RETURN OLD;
	ELSE
		FOR linha IN
			SELECT DISTINCT
				ate.ate_codigo,
				age.tat_codigo AS eai_tipo_atendimento,
				tbl.co_local_atend,
				usr.cnes_cod_cns AS eai_profissional_cns,
				esp.cod_cbo AS eai_cbo_codigo_2002,
				uni.uni_cnes AS eai_cnes,
				ate.ate_data AS eai_dtatendimento,
				uni.uni_codigo_ibge AS eai_codigo_ibge_mun,
				usu.usu_cartao_sus AS eai_num_cartao_sus,
				usu.usu_datanasc AS eai_dtnascimento,
				usu.usu_prontuario AS eai_numprontuario, 
				usu.usu_sexo
			FROM 
				atendimento AS ate
			INNER JOIN 
				agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN 
				especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN 
				usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
				usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
				unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN 
				tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
			INNER JOIN
				rl_cds_atend_individual_ciap AS rlai ON ate.ate_codigo=rlai.ate_codigo
			INNER JOIN 
				rl_cds_atend_individual_condut AS rlaic ON ate.ate_codigo=rlaic.ate_codigo
			WHERE 
				ate.ate_codigo = NEW.ate_codigo LOOP
			-- Validao de sexo
			IF (linha.usu_sexo='M') THEN 
				eai_sexo = '0 L';
			ELSE
				eai_sexo = '1 L';
			END IF;
			-- Realiza a insero dos da ficha de procedimento do E-SUS
			INSERT INTO esus_atendimento_individual(
				ate_codigo,
				co_local_atend,
				eai_profissional_cns,
				eai_cbo_codigo_2002,
				eai_cnes,
				eai_dtatendimento,
				eai_codigo_ibge_mun,
				eai_dtnascimento,
				eai_num_cartao_sus,
				eai_numprontuario,
				eai_tipo_atendimento,
				eai_sexo,
				eai_tipo_dado_serializado
			) VALUES (
				linha.ate_codigo,
				linha.co_local_atend,
				linha.eai_profissional_cns,
				linha.eai_cbo_codigo_2002,
				linha.eai_cnes,
				linha.eai_dtatendimento,
				linha.eai_codigo_ibge_mun,
				linha.eai_dtnascimento,
				linha.eai_num_cartao_sus,
				linha.eai_numprontuario,
				linha.eai_tipo_atendimento,
				eai_sexo,
				'4 L'
			);
			RETURN NEW;
			RAISE NOTICE 'Registro inserido com sucesso''.';
		END LOOP;
	END IF;	
	RETURN NULL;
END;
$BODY$ 
LANGUAGE plpgsql;

CREATE TRIGGER atualiza_esus_atendimento_individual
AFTER INSERT OR UPDATE OR DELETE ON rl_cds_atend_individual_condut 
FOR EACH ROW 
EXECUTE PROCEDURE esus_atendimento_individual();

CREATE TABLE esus_cadastro_individual
(
	eci_codigo bigserial NOT NULL,
	usu_codigo bigint,
	eci_usr_cnes character varying(60) NOT NULL,
	eci_usr_profissional_cns character varying(60) NOT NULL,
	eci_usr_codigo_ibge character varying(60) NOT NULL,
	eci_usr_dtatendimento date NOT NULL,
	eci_usu_codigo_ibge character varying(20) NOT NULL,
	eci_usu_dtnascimento date NOT NULL,
	eci_usu_nacionalidade character varying(20) NOT NULL,
	eci_usu_nome character varying(60) NOT NULL,
	eci_usu_mae character varying(60) NOT NULL,
	eci_usu_raca character varying(20) NOT NULL,
	eci_usu_sexo character varying(20) NOT NULL,
	eci_usu_escola character(1) NOT NULL,
	eci_usu_sit_rua boolean NOT NULL,
	eci_usu_deficiencia boolean NOT NULL,
	eci_usu_cns character varying(20),
	eci_tipo_dado_serializado character varying(20) NOT NULL,
	uuid_ficha character varying(60),
	CONSTRAINT eci_codigo_pk PRIMARY KEY (eci_codigo),
	CONSTRAINT usu_codigo_fk FOREIGN KEY (usu_codigo)
	  REFERENCES usuario(usu_codigo) MATCH SIMPLE
	  ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

CREATE OR REPLACE FUNCTION esus_cadastro_individual()
	RETURNS trigger AS 
$BODY$
DECLARE 
	usu_codigo_conf bigint;
	eci_sexo character(20);
	eci_raca character(20);
	eci_nacionalidade character(20);
	linha RECORD;
BEGIN 
	IF (TG_OP='DELETE') THEN
		DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
		RAISE NOTICE 'DELETE''.';				 
	ELSE
		FOR linha IN 
			SELECT 
				usu.usu_codigo, 
				uni.uni_cnes AS eci_cnes,
				usr.cnes_cod_cns AS eci_usr_cns,
				uni.uni_codigo_ibge AS eci_codigo_ibge,
				usu.usu_data_cad AS eci_dtatendimento,
				usu.usu_datanasc AS eci_usu_dtnascimento,
				usu.cd_nacionalidade AS eci_usu_nacionalidade,
				usu.usu_nome AS eci_usu_nome,
				usu.usu_mae AS eci_usu_mae,
				usu.rac_codigo AS eci_usu_raca,
				usu.usu_sexo AS eci_usu_sexo,
				usu.usu_freq_escolar AS eci_usu_escola,
				usu.usu_deficiencia AS eci_usu_deficiencia,
				usu.usu_sit_rua AS eci_usu_sit_rua,
				usu.usu_cartao_sus AS eci_usu_cns
			FROM 
				usuario AS usu
			INNER JOIN 
				usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
			INNER JOIN
				unidade AS uni ON usu.uni_codigo=uni.uni_codigo
			WHERE
				usu.usu_codigo = NEW.usu_codigo LOOP
				-- Validao de sexo
				IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
				-- Validao nacionalidade
				IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
				IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '2 L'; END IF;
				IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '3 L'; END IF;
				-- Validao Raa
				IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
				IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
				IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
				IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
				IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
				IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
				
				IF (TG_OP='UPDATE') THEN
					UPDATE esus_cadastro_individual SET
							eci_usr_cnes = linha.eci_cnes,
							eci_usr_profissional_cns = linha.eci_usr_cns,
							eci_usr_codigo_ibge = linha.eci_codigo_ibge,
							eci_usr_dtatendimento = linha.eci_dtatendimento,
							eci_usu_codigo_ibge = linha.eci_codigo_ibge,
							eci_usu_dtnascimento = linha.eci_usu_dtnascimento,
							eci_usu_nacionalidade = eci_nacionalidade,
							eci_usu_nome = linha.eci_usu_nome,
							eci_usu_mae = linha.eci_usu_mae,
							eci_usu_raca = eci_raca,
							eci_usu_sexo = eci_sexo,
							eci_usu_escola = linha.eci_usu_escola,
							eci_usu_deficiencia = linha.eci_usu_deficiencia,
							eci_usu_cns = linha.eci_usu_cns,
							eci_usu_sit_rua = linha.eci_usu_sit_rua
						WHERE
							usu_codigo = OLD.usu_codigo;
					RAISE NOTICE 'UPDATE''.';				 
				ELSE
					-- INSERO
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_codigo_ibge,
						linha.eci_dtatendimento,
						linha.eci_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua);
				END IF;				
			END LOOP;
		RAISE NOTICE 'INSERT''.';				 
	END IF;
	RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE TRIGGER atualiza_esus_cadastro_individual
AFTER INSERT OR UPDATE OR DELETE ON usuario 
FOR EACH ROW 
EXECUTE PROCEDURE esus_cadastro_individual();

CREATE OR REPLACE FUNCTION converte_cidade_bairro()
  RETURNS numeric AS
$BODY$ 
DECLARE
    row   RECORD;
    linhas bigint;
    cid_codigo_1 integer;
BEGIN
    linhas = 0; 
    FOR row IN 
          SELECT * FROM bairro
           
       LOOP
		select cid_codigo into cid_codigo_1 from rua where bai_codigo = row.bai_codigo;
	       update bairro set cid_codigo = cid_codigo_1 where bai_codigo = row.bai_codigo;
		linhas = linhas + 1;
    END LOOP;
    return linhas;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

select converte_cidade_bairro();
drop function converte_cidade_bairro();


