UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.100.99' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.74.62' WHERE conf_chave='VERSAO_COMUM';


ALTER TABLE tb_equipe ALTER COLUMN nu_ine TYPE character varying;

ALTER TABLE social.controlefracionado_reserva
   ALTER COLUMN usr_codigo DROP NOT NULL;

CREATE OR REPLACE FUNCTION esus_atendimento_individual()
  RETURNS trigger AS
$BODY$
DECLARE 
	linha RECORD;
	eai_sexo character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM esus_atendimento_individual WHERE ate_codigo = OLD.ate_codigo;
		RETURN OLD;
	ELSE
		FOR linha IN
			SELECT DISTINCT
				ate.ate_codigo,
				age.tat_codigo AS eai_tipo_atendimento,
				tbl.co_local_atend,
				usr.cnes_cod_cns AS eai_profissional_cns,
				esp.cod_cbo AS eai_cbo_codigo_2002,
				uni.uni_cnes AS eai_cnes,
				ate.ate_data AS eai_dtatendimento,
				uni.uni_codigo_ibge AS eai_codigo_ibge_mun,
				usu.usu_cartao_sus AS eai_num_cartao_sus,
				usu.usu_datanasc AS eai_dtnascimento,
				usu.usu_prontuario AS eai_numprontuario, 
				usu.usu_sexo
			FROM 
				atendimento AS ate
			INNER JOIN 
				agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN 
				especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN 
				usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
				usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
				unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN 
				tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
			INNER JOIN
				rl_cds_atend_individual_ciap AS rlai ON ate.ate_codigo=rlai.ate_codigo
			INNER JOIN 
				rl_cds_atend_individual_condut AS rlaic ON ate.ate_codigo=rlaic.ate_codigo
			WHERE 
				ate.ate_codigo = NEW.ate_codigo LOOP
			-- Validao de sexo
			IF (linha.usu_sexo='M') THEN 
				eai_sexo = '0 L';
			ELSE
				eai_sexo = '1 L';
			END IF;
			
			IF (TG_OP = 'INSERT') THEN
				-- Realiza a insero dos da ficha de procedimento do E-SUS
				INSERT INTO esus_atendimento_individual(
					ate_codigo,
					co_local_atend,
					eai_profissional_cns,
					eai_cbo_codigo_2002,
					eai_cnes,
					eai_dtatendimento,
					eai_codigo_ibge_mun,
					eai_dtnascimento,
					eai_num_cartao_sus,
					eai_numprontuario,
					eai_tipo_atendimento,
					eai_sexo,
					eai_tipo_dado_serializado
				) VALUES (
					linha.ate_codigo,
					linha.co_local_atend,
					linha.eai_profissional_cns,
					linha.eai_cbo_codigo_2002,
					linha.eai_cnes,
					linha.eai_dtatendimento,
					linha.eai_codigo_ibge_mun,
					linha.eai_dtnascimento,
					linha.eai_num_cartao_sus,
					linha.eai_numprontuario,
					linha.eai_tipo_atendimento,
					eai_sexo,
					'4 L'
				);
				RETURN NEW;
			END IF; 

			IF (TG_OP = 'UPDATE') THEN
				UPDATE esus_atendimento_individual
					SET ate_codigo = linha.ate_codigo,
					co_local_atend = linha.co_local_atend, 
					eai_profissional_cns = linha.eai_profissional_cns,
					eai_cbo_codigo_2002 = linha.eai_cbo_codigo_2002,
					eai_cnes = linha.eai_cnes,
					eai_dtatendimento = linha.eai_dtatendimento,
					eai_codigo_ibge_mun = linha.eai_codigo_ibge_mun,
					eai_dtnascimento = linha.eai_dtnascimento,
					eai_num_cartao_sus = linha.eai_num_cartao_sus,
					eai_numprontuario = linha.eai_numprontuario,
					eai_tipo_atendimento = linha.eai_tipo_atendimento,
					eai_sexo = eai_sexo,
					eai_tipo_dado_serializado = '4 L'
				WHERE
					eai_codigo = NEW.eai_codigo;
					
				RETURN NEW;
			END IF;
			
		END LOOP;
	END IF;	
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
  
UPDATE esus_atendimento_individual SET eai_tipo_atendimento = '5' WHERE eai_tipo_atendimento = '3';
UPDATE esus_atendimento_individual SET eai_tipo_atendimento = '5' WHERE eai_tipo_atendimento is null;

CREATE OR REPLACE FUNCTION limpa_cns(stexto text)
	RETURNS text AS
$BODY$
DECLARE
	stextonovo text;
BEGIN
	stextonovo := translate(stexto,'.','');
	RETURN stextonovo;
END;
$BODY$
	LANGUAGE plpgsql VOLATILE
	COST 100;
	
UPDATE usuario SET usu_cartao_sus = limpa_cns(usu_cartao_sus) WHERE usu_cartao_sus <> '';
UPDATE esus_cadastro_individual SET eci_usu_cns = limpa_cns(eci_usu_cns) WHERE eci_usu_cns <> '';
UPDATE esus_cadastro_individual SET eci_usr_profissional_cns = limpa_cns(eci_usr_profissional_cns) WHERE eci_usr_profissional_cns <> '';
UPDATE esus_atendimento_individual SET eai_profissional_cns = limpa_cns(eai_profissional_cns) WHERE eai_profissional_cns <> ''; 
UPDATE esus_atendimento_individual SET eai_num_cartao_sus = limpa_cns(eai_num_cartao_sus) WHERE eai_num_cartao_sus <> ''; 
UPDATE esus_atividade_coletiva SET eav_responsavel_cns = limpa_cns(eav_responsavel_cns) WHERE eav_responsavel_cns <> '';
UPDATE esus_odonto SET eo_profissional_cns = limpa_cns(eo_profissional_cns) WHERE eo_profissional_cns <> '';
UPDATE esus_odonto SET eo_num_cartao_sus = limpa_cns(eo_num_cartao_sus) WHERE eo_num_cartao_sus <> '';
UPDATE esus_visita_domiciliar SET esv_usu_cns = limpa_cns(esv_usu_cns) WHERE esv_usu_cns <> '';
UPDATE esus_visita_domiciliar SET esv_profissional_cns = limpa_cns(esv_profissional_cns) WHERE esv_profissional_cns <> '';

INSERT INTO config 
	(conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool,cac_codigo)
	VALUES
	('MODULO_RUA','Cadastro de rua(Ao Social)','f','2','t','6');

ALTER TABLE atendimento ADD COLUMN ate_nasf_aval boolean;
ALTER TABLE atendimento ADD COLUMN ate_nasf_proc boolean;
ALTER TABLE atendimento ADD COLUMN ate_nasf_presc boolean;
