﻿UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.102.101' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.74.62' WHERE conf_chave='VERSAO_COMUM';

insert into config(conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool,cac_codigo) values ('INTEGRACAO_ALMOXARIFADO','Integração Almoxarifado','f',2,'f',6);

ALTER TABLE SOCIAL.MOVIMENTO ADD ALMOX_ENTIDADE BIGINT;
ALTER TABLE SOCIAL.MOVIMENTO ADD ALMOX_EXERCICIO BIGINT;
ALTER TABLE SOCIAL.MOVIMENTO ADD ALMOX_NUMERO BIGINT;

ALTER TABLE as_atendimento_basicocras
   ALTER COLUMN asab_data TYPE date;
COMMENT ON COLUMN as_prontuario_suas_usuario.aspsu_parentesco
  IS '1 - Pessoa de referencia
2 - Conjuge / companheiro
3 - Filho
4 - Enteado;
5 - Neto
6 - Pai / Mãe 
7 - Sogro
8 - Irmão / Irmã
9 - Genro / Nora
10 - Outro Parente
11 - Não Parente';
COMMENT ON COLUMN as_prontuario_suas_usuario.aspsu_parentesco IS '1 - Pessoa de referencia
2 - Conjuge / companheiro
3 - Filho
4 - Enteado;
5 - Neto
6 - Pai / Mãe 
7 - Sogro
8 - Irmão / Irmã
9 - Genro / Nora
10 - Outro Parente
11 - Não Parente';

INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('E-SUS Inconsistência Atend. Individual','zf/programasfederais/atendimento-individual','zf/programasfederais/atendimento-individual');

CREATE OR REPLACE FUNCTION esus_atividade_coletiva()
  RETURNS trigger AS
$BODY$
DECLARE
linha RECORD;
BEGIN
	FOR linha IN
		SELECT
			tb_fav.co_cds_ficha_ativ_col, 
			tb_fav.dt_ativ_col AS eav_dt_atividade,
			tb_fav.qt_participante_programado AS eav_num_participantes_prog,
			tb_fav.qt_participante_ativ AS eav_num_participantes,
			tb_fav.ds_local_ativ AS eav_local_atividade,
			tb_fav.hr_inicio AS eav_hora_inicio,
			tb_fav.hr_fim AS eav_hora_fim,
			usr.cnes_cod_cns AS eav_responsavel_cns,
			uni.uni_cnes AS eav_uni_cnes,
			tb_fav.cod_equipe_ine AS eav_responsavel_ine,
			tb_fav.cod_cnes_unidade AS eav_responsavel_cnes,
			tb_fav.qt_avaliacao_alterada AS eav_num_aval_alteradas,
			tb_fav.tp_cds_ativ_col AS eav_atividade_tipo,
			uni.uni_codigo_ibge AS eav_codigo_ibge,
			tb_fav.co_inep_escola AS eav_inep
		FROM 
			tb_cds_ficha_ativ_col AS tb_fav
		INNER JOIN
			usuarios AS usr ON tb_fav.usr_codigo=usr.usr_codigo
		INNER JOIN
			unidade AS uni ON tb_fav.uni_codigo=uni.uni_codigo
		WHERE 
			tb_fav.co_cds_ficha_ativ_col=NEW.co_cds_ficha_ativ_col	LOOP

		IF (TG_OP='INSERT') THEN
			IF linha.co_cds_ficha_ativ_col IS NOT NULL THEN				
				INSERT INTO esus_atividade_coletiva(
					co_cds_ficha_ativ_col,
					eav_dt_atividade,
					eav_num_participantes_prog,
					eav_num_participantes,
					eav_local_atividade,
					eav_hora_inicio,
					eav_hora_fim,
					eav_responsavel_cns,
					eav_responsavel_cnes,
					eav_responsavel_ine,
					eav_num_aval_alteradas,
					eav_atividade_tipo,
					eav_codigo_ibge,
					eav_inep,
					eav_uni_cnes
				) VALUES (
					linha.co_cds_ficha_ativ_col,
					linha.eav_dt_atividade,
					linha.eav_num_participantes_prog,
					linha.eav_num_participantes,
					linha.eav_local_atividade,
					linha.eav_hora_inicio,
					linha.eav_hora_fim,
					linha.eav_responsavel_cns,
					linha.eav_responsavel_cnes,
					linha.eav_responsavel_ine,
					linha.eav_num_aval_alteradas,
					linha.eav_atividade_tipo,
					linha.eav_codigo_ibge,
					linha.eav_inep,
					linha.eav_uni_cnes
				);
				RETURN NEW;
			END IF;
		ELSE 
			IF linha.co_cds_ficha_ativ_col IS NOT NULL THEN				
				UPDATE esus_atividade_coletiva 
					SET	co_cds_ficha_ativ_col = linha.co_cds_ficha_ativ_col,
						eav_dt_atividade = linha.eav_dt_atividade,
						eav_num_participantes_prog = linha.eav_num_participantes_prog,
						eav_num_participantes = linha.eav_num_participantes,
						eav_local_atividade = linha.eav_local_atividade,
						eav_hora_inicio = linha.eav_hora_inicio,
						eav_hora_fim = linha.eav_hora_fim,
						eav_responsavel_cns = linha.eav_responsavel_cns,
						eav_responsavel_cnes  = linha.eav_responsavel_cnes,
						eav_responsavel_ine  = linha.eav_responsavel_ine,
						eav_num_aval_alteradas = linha.eav_num_aval_alteradas,
						eav_atividade_tipo = linha.eav_atividade_tipo,
						eav_codigo_ibge = linha.eav_codigo_ibge,
						eav_inep = linha.eav_inep,
						eav_uni_cnes = linha.eav_uni_cnes,
						uuid_ficha = ''
				WHERE 
					co_cds_ficha_ativ_col=NEW.co_cds_ficha_ativ_col;
				RETURN NEW;
			END IF;
		END IF;
	END LOOP;
RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
  
CREATE OR REPLACE FUNCTION esus_cadastro_individual()
  RETURNS trigger AS
$BODY$
DECLARE 
	usu_codigo_conf bigint;
	eci_sexo character(20);
	eci_raca character(20);
	eci_nacionalidade character(20);
	linha RECORD;
BEGIN 
	IF (TG_OP='DELETE') THEN
		DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
		RAISE NOTICE 'DELETE''.';				 
	ELSE
		FOR linha IN 
			SELECT 
				usu.usu_codigo, 
				uni.uni_cnes AS eci_cnes,
				usr.cnes_cod_cns AS eci_usr_cns,
				uni.uni_codigo_ibge AS eci_codigo_ibge,
				usu.usu_data_cad AS eci_dtatendimento,
				usu.usu_datanasc AS eci_usu_dtnascimento,
				usu.cd_nacionalidade AS eci_usu_nacionalidade,
				usu.usu_nome AS eci_usu_nome,
				usu.usu_mae AS eci_usu_mae,
				usu.rac_codigo AS eci_usu_raca,
				usu.usu_sexo AS eci_usu_sexo,
				usu.usu_freq_escolar AS eci_usu_escola,
				usu.usu_deficiencia AS eci_usu_deficiencia,
				usu.usu_sit_rua AS eci_usu_sit_rua,
				usu.usu_cartao_sus AS eci_usu_cns
			FROM 
				usuario AS usu
			INNER JOIN 
				usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
			INNER JOIN
				unidade AS uni ON usu.uni_codigo=uni.uni_codigo
			WHERE
				usu.usu_codigo = NEW.usu_codigo LOOP
				-- Validação de sexo
				IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
				-- Validação nacionalidade
				IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
				IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '2 L'; END IF;
				IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '3 L'; END IF;
				-- Validação Raça
				IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
				IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
				IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
				IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
				IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
				IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
				
				IF (TG_OP='UPDATE') THEN
					UPDATE esus_cadastro_individual SET
							eci_usr_cnes = linha.eci_cnes,
							eci_usr_profissional_cns = linha.eci_usr_cns,
							eci_usr_codigo_ibge = linha.eci_codigo_ibge,
							eci_usr_dtatendimento = linha.eci_dtatendimento,
							eci_usu_codigo_ibge = linha.eci_codigo_ibge,
							eci_usu_dtnascimento = linha.eci_usu_dtnascimento,
							eci_usu_nacionalidade = eci_nacionalidade,
							eci_usu_nome = linha.eci_usu_nome,
							eci_usu_mae = linha.eci_usu_mae,
							eci_usu_raca = eci_raca,
							eci_usu_sexo = eci_sexo,
							eci_usu_escola = linha.eci_usu_escola,
							eci_usu_deficiencia = linha.eci_usu_deficiencia,
							eci_usu_cns = linha.eci_usu_cns,
							eci_usu_sit_rua = linha.eci_usu_sit_rua,
							uuid_ficha = ''
						WHERE
							usu_codigo = OLD.usu_codigo;
					RAISE NOTICE 'UPDATE''.';				 
				ELSE
					-- INSERÇÃO
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_codigo_ibge,
						linha.eci_dtatendimento,
						linha.eci_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua);
				END IF;				
			END LOOP;
		RAISE NOTICE 'INSERT''.';				 
	END IF;
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
  
INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('E-SUS Inconsistência Procedimentos','zf/programasfederais/ficha-procedimento','zf/programasfederais/ficha-procedimento');
INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('E-SUS Inconsistência Visita Domiciliar','zf/programasfederais/visita-domiciliar','zf/programasfederais/visita-domiciliar');
INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('E-SUS Inconsistência Odontologia','zf/programasfederais/ficha-odontologica/inconsistencias','zf/programasfederais/ficha-odontologica/inconsistencias');
INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('E-SUS Inconsistência Cadastro Domiciliar','zf/programasfederais/cadastro-domiciliar/inconsistencias','zf/programasfederais/cadastro-domiciliar/inconsistencias');


insert into permissoes (perm_descricao,perm_programa,perm_objeto) values ('ZF - INCONSISTENCIAS CNES','zf/programasfederais/inconsistencias-cnes','zf/programasfederais/inconsistencias-cnes');
alter table usuario add column aspsu_parentesco integer;