﻿UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.107.106' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.45.43' WHERE conf_chave='VERSAO_SOCIAL';

UPDATE config SET conf_valor_data = CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.86.84' WHERE conf_chave='VERSAO_COMUM';

INSERT INTO acesso ( ace_descricao, ace_pai, ace_caminho, ace_modulo, ace_imagem, ace_item_menu) 
			VALUES ( 'Prontuário SUAS', (select ace_codigo from acesso where ace_descricao = 'Relatórios'), 'zf/relatorio/prontuario-suas/form-prontuario-suas/form-p', 13, null, null); 
			
CREATE TABLE social.as_parentesco
(
   id integer not null,
   descricao varchar(100),
   CONSTRAINT as_id_parentesco_pk PRIMARY KEY(id)
)
WITH (
  OIDS = FALSE
)
;
insert into as_parentesco values(1, 'Pessoa Referência');
insert into as_parentesco values(2, 'Cônjuge/Companheiro');
insert into as_parentesco values(3, 'Filho');
insert into as_parentesco values(4, 'Enteado');
insert into as_parentesco values(5, 'Neto(a),Bisneto');
insert into as_parentesco values(6, 'Pai/Mãe');
insert into as_parentesco values(7, 'Sogro(a)');
insert into as_parentesco values(8, 'Irmão/Irmã');
insert into as_parentesco values(9, 'Genro/Nora');
insert into as_parentesco values(10, 'Outro Parente');
insert into as_parentesco values(11, 'Não Parente');

CREATE TABLE social.as_escolaridade (
   id integer not null,
   descricao varchar(100),
   CONSTRAINT as_id_escolaridade_pk PRIMARY KEY(id)
)
WITH (
  OIDS = FALSE
)
;

insert into as_escolaridade values(101, 'Nunca Frequentou Escola');
insert into as_escolaridade values(1  , 'Creche');
insert into as_escolaridade values(2  , 'Educação Infantil');
insert into as_escolaridade values(11 , '1º ano E. Fundamental');
insert into as_escolaridade values(12 , '2º ano E. Fundamental');
insert into as_escolaridade values(13 , '3º ano E. Fundamental');
insert into as_escolaridade values(14 , '4º ano E. Fundamental');
insert into as_escolaridade values(15 , '5º ano E. Fundamental');
insert into as_escolaridade values(16 , '6º ano E. Fundamental');
insert into as_escolaridade values(17 , '7º ano E. Fundamental');
insert into as_escolaridade values(18 , '8º ano E. Fundamental');
insert into as_escolaridade values(19 , '9º ano E. Fundamental');
insert into as_escolaridade values(21 , '1º ano E. Médio');
insert into as_escolaridade values(22 , '2º ano E. Médio');
insert into as_escolaridade values(23 , '3º ano E. Médio');
insert into as_escolaridade values(30 , 'Superior Incompleto');
insert into as_escolaridade values(31 , 'Superior Completo');
insert into as_escolaridade values(40 , 'EJA – Ensino Fundamental');
insert into as_escolaridade values(41 , 'EJA – Ensino Médio');
insert into as_escolaridade values(99 , 'Outros');


CREATE OR REPLACE FUNCTION atualizaBPA() RETURNS integer AS $$
DECLARE
    row   RECORD;
BEGIN
   FOR row in SELECT * FROM bpa WHERE bpa_data is null LOOP

      UPDATE bpa set bpa_data = row.bpa_data_alt where bpa_codigo = row.bpa_codigo;

   END LOOP;
   return null;
END;

$$ LANGUAGE plpgsql;

SELECT atualizaBPA();

CREATE OR REPLACE FUNCTION operacoesodontobpa()
  RETURNS trigger AS
$BODY$
DECLARE 
linha RECORD;
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM bpa WHERE bpa_origem = 'odontograma' AND bpa_origem_codigo = OLD.odo_preal_codigo;
		RETURN OLD;
		-- Procedimento e BPA excluido com sucesso
	ELSE 
		FOR linha IN	
		SELECT 
			odpr.odo_preal_codigo,
			odpr.odo_preal_dtcadastro,
			proc.proc_codigo,
			proc.proc_bpa_tipo,
			ate.uni_codigo,
			ate.med_codigo,
			ate.usu_codigo
		FROM 
			odonto_procedimentos_realizados AS odpr
		INNER JOIN 
			procedimento AS proc ON odpr.proc_codigo = proc.proc_codigo
		INNER JOIN 
			odonto_procedimentos_controle AS odpc ON odpr.odo_pcon_codigo = odpc.odo_pcon_codigo
		INNER JOIN
			atendimento AS ate ON odpc.ate_codigo = ate.ate_codigo
		WHERE 
			odpr.odo_preal_codigo = NEW.odo_preal_codigo  LOOP
			-- Operação de Insert
			IF (TG_OP = 'INSERT') THEN
				INSERT 	INTO bpa
							(uni_codigo,usr_codigo,usu_codigo,bpa_data,proc_codigo,ci_codigo,bpa_tipo,bpa_origem,bpa_origem_codigo,bpa_ativo,bpa_data_alt)
						VALUES
							(linha.uni_codigo,linha.med_codigo,linha.usu_codigo,linha.odo_preal_dtcadastro,linha.proc_codigo,'16',linha.proc_bpa_tipo,'odontograma',linha.odo_preal_codigo,'t',linha.odo_preal_dtcadastro);
				RETURN NEW;
				-- Procedimento e BPA inserido com sucesso!
			END IF;
			-- Operação de Update
			IF (TG_OP = 'UPDATE') THEN
				UPDATE bpa
					SET 
						uni_codigo = linha.uni_codigo,
						usr_codigo = linha.med_codigo,
						usu_codigo = linha.usu_codigo,
						proc_codigo = linha.proc_codigo,
						ci_codigo = '16',
						bpa_tipo = linha.proc_bpa_tipo,
						bpa_origem = 'odontograma',
						bpa_origem_codigo = linha.odo_preal_codigo,
						bpa_ativo = 't',
						bpa_data_alt = linha.odo_preal_dtcadastro
					WHERE
						bpa_origem = 'odontograma' AND
						bpa_origem_codigo = linha.odo_preal_codigo;
				RETURN NEW;
				-- Procedimento e BPA atualizado com sucesso!
			END IF;
		END LOOP;
	END IF;
END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION operacoesodontobpa()
  OWNER TO postgres;