ALTER TABLE receita
   ALTER COLUMN rec_validade DROP DEFAULT;
ALTER TABLE requisicao_exames ADD COLUMN req_observacao text;


INSERT INTO config (conf_chave,conf_label,conf_tipo,conf_valor_int)VALUES('VALIDADE_RECEITA','Validade da receita mdica(dias)',3,30);

CREATE TABLE prescricao_enfermagem
(
  pres_codigo bigserial NOT NULL,
  io_codigo bigint,
  pres_higiene_corporal character(1),
  pres_higiene_oral character(1),
  pres_verificar_sinais character varying(60),
  pres_ingesta_hidrica character(1),
  pres_ingesta_alimentar character(1),
  pres_realizar_curativo character(1),
  pres_realizar_decubito character(1),
  pres_observar_padrao_respiratorio character(1),
  pres_observar_perfuracao_pereferica character(1),
  pres_observar_eliminacoes character(1),
  pres_observar_queixas character(1),
  pres_observar_nivel_consciencia character(1),
  pres_osbservar_aceitacao_alimentar character(1)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE prescricao_enfermagem
  OWNER TO postgres;
 

ALTER TABLE prescricao_enfermagem ADD PRIMARY KEY (pres_codigo);
COMMENT ON COLUMN prescricao_enfermagem.pres_higiene_corporal IS 'E - ENCAMINHAR
R - REALIZAR';
COMMENT ON COLUMN prescricao_enfermagem.pres_higiene_oral IS 'E - ENCAMINHAR
R - REALIZAR';
COMMENT ON COLUMN prescricao_enfermagem.pres_ingesta_hidrica IS 'E - Estimular
R - Restringir';
COMMENT ON COLUMN prescricao_enfermagem.pres_ingesta_alimentar IS 'E - Estimular
R - Restringir';
COMMENT ON COLUMN prescricao_enfermagem.pres_realizar_curativo IS 'A - Aberto
F - Fechado';
ALTER TABLE prescricao_enfermagem DROP COLUMN pres_observar_padrao_respiratorio;
ALTER TABLE prescricao_enfermagem DROP COLUMN pres_observar_perfuracao_pereferica;
ALTER TABLE prescricao_enfermagem DROP COLUMN pres_observar_eliminacoes;
ALTER TABLE prescricao_enfermagem DROP COLUMN pres_observar_queixas;
ALTER TABLE prescricao_enfermagem DROP COLUMN pres_observar_nivel_consciencia;
ALTER TABLE prescricao_enfermagem DROP COLUMN pres_osbservar_aceitacao_alimentar;
ALTER TABLE prescricao_enfermagem ADD COLUMN pres_observar_padrao_respiratorio boolean;
ALTER TABLE prescricao_enfermagem ADD COLUMN pres_observar_perfuracao_pereferica boolean;
ALTER TABLE prescricao_enfermagem ADD COLUMN pres_observar_eliminacoes boolean;
ALTER TABLE prescricao_enfermagem ADD COLUMN pres_observar_queixas boolean;
ALTER TABLE prescricao_enfermagem ADD COLUMN pres_observar_nivel_consciencia boolean;
ALTER TABLE prescricao_enfermagem ADD COLUMN pres_osbservar_aceitacao_alimentar boolean;


CREATE TABLE chamada
(
   cha_codigo bigserial, 
   age_codigo bigint, 
   usr_codigo bigint, 
   set_codigo bigint
) 
WITH (
  OIDS = FALSE
)
;
ALTER TABLE chamada ADD COLUMN cha_status character(1);
ALTER TABLE chamada ADD PRIMARY KEY (cha_codigo);
ALTER TABLE chamada ADD FOREIGN KEY (age_codigo) REFERENCES agendamento (age_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE chamada ADD FOREIGN KEY (set_codigo) REFERENCES setor (set_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE chamada ADD FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

insert into permissoes(perm_descricao,perm_programa,perm_objeto) values ('CHAMADA-MEDICO','zf/default/chamada','zf/default/chamada');

ALTER TABLE chamada DROP COLUMN set_codigo;
ALTER TABLE chamada ADD COLUMN cha_data timestamp with time zone;


INSERT INTO usuarios (usr_codigo,usr_nome,usr_login,usr_senha,usr_email,usr_tipo,usr_tipo_medico) values (99998,'ENFERMEIRO UPA','upaenf',md5('123'),'upaenf@elotech.com.br','U','E');
insert into medico_especialidade (esp_codigo,med_codigo) values (1130,99998);
insert into internacao_alta (alt_codigo,alt_descricao) values (3,'Retorno');
