﻿UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.113.112' WHERE conf_chave='VERSAO_SAUDE';

CREATE TABLE social.tipo_ficha_esus
(
   tfe_codigo bigserial, 
   tfe_descricao character varying, 
   PRIMARY KEY (tfe_codigo)
) 
WITH (
  OIDS = FALSE
)
;

INSERT INTO tipo_ficha_esus  values (1,'CADASTRO INDIVIDUAL');
INSERT INTO tipo_ficha_esus  values (2,'CADASTRO DOMICILIAR');
INSERT INTO tipo_ficha_esus  values (3,'FICHA DE PROCEDIMENTO');
INSERT INTO tipo_ficha_esus  values (4,'ATENDIMENTO INDIVIDUAL');
INSERT INTO tipo_ficha_esus  values (5,'VISITA DOMICILIAR');
INSERT INTO tipo_ficha_esus  values (7,'FICHA ODONTOLOGICA');
INSERT INTO tipo_ficha_esus  values (6,'ATIVIDADE COLETIVA');

CREATE TABLE social.esus_exportacao_historico_itens
(
   eehi_codigo bigserial, 
   tfe_codigo bigint, 
   uuid_ficha character varying, 
   eehi_data_exportacao timestamp without time zone, 
   PRIMARY KEY (eehi_codigo), 
   FOREIGN KEY (tfe_codigo) REFERENCES tipo_ficha_esus (tfe_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;

DROP TABLE a;

CREATE TABLE social.esus_exportacao_historico
(
   eeh_codigo bigserial, 
   eeh_data_inicial timestamp without time zone, 
   eeh_data_final timestamp without time zone, 
   PRIMARY KEY (eeh_codigo)
) 
WITH (
  OIDS = FALSE
)
;

ALTER TABLE esus_exportacao_historico_itens
  ADD COLUMN eeh_codigo bigint;
ALTER TABLE esus_exportacao_historico_itens
  ADD FOREIGN KEY (eeh_codigo) REFERENCES esus_exportacao_historico (eeh_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
  
  ALTER TABLE as_atendimentocol_grupo ALTER COLUMN asag_data TYPE DATE; 

  
  