﻿UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.114.113' WHERE conf_chave='VERSAO_SAUDE';


DO $$
BEGIN

IF EXISTS (
    SELECT * 
    FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS  
    WHERE CONSTRAINT_NAME='esus_exportacao_historico_itens_tfe_codigo_fkey'
    ) THEN
ALTER TABLE esus_exportacao_historico_itens  DROP CONSTRAINT esus_exportacao_historico_itens_tfe_codigo_fkey;
END IF;

END$$;

DO $$
BEGIN

IF EXISTS (
    SELECT * 
    FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS  
    WHERE CONSTRAINT_NAME='esus_exportacao_historico_itens_eehi_codigo_fkey'
    ) THEN
ALTER TABLE esus_exportacao_historico_itens  DROP CONSTRAINT esus_exportacao_historico_itens_eehi_codigo_fkey;
END IF;

END$$;


CREATE TABLE social.tb_financiamento
(
  co_financiamento character varying NOT NULL,
  no_financiamento character varying,
  dt_competencia character varying,
  CONSTRAINT tb_financiamento_pkey PRIMARY KEY (co_financiamento)
)
WITH (
  OIDS=FALSE
);

alter table coleta add column esp_codigo integer;

ALTER TABLE coleta
  ADD FOREIGN KEY (esp_codigo) REFERENCES especialidade (esp_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

 alter table bpa add column esp_codigo integer;
 
 
 CREATE OR REPLACE FUNCTION social.pattobpa()
  RETURNS trigger AS
$BODY$
DECLARE
  linha RECORD;
  ci_codigo bigint;  
    
BEGIN

	FOR linha IN SELECT ate.usu_codigo,
					    ate.ate_data, 
					    ate.med_codigo,
					    ate.uni_codigo,
					    ate.ate_acidentetrab,
					    proc.proc_bpa_tipo,
					    age.esp_codigo
				   FROM procedimento_atendimento AS pat
				   JOIN atendimento AS ate
				     ON ate.ate_codigo=pat.ate_codigo
				   JOIN procedimento AS proc
				     ON proc.proc_codigo=pat.proc_codigo
				   JOIN agendamento age
				     ON age.age_codigo = ate.age_codigo
				  WHERE pat_codigo=NEW.pat_codigo LOOP
				
						-- verificar acidente de trabalho
						SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ci_codigo;
						
						INSERT INTO BPA (uni_codigo,
										 usr_codigo,
										 usu_codigo,
										 bpa_data,
										 proc_codigo,
										 ci_codigo,
										 bpa_tipo,
										 bpa_cd10_codigo,
										 bpa_origem,
										 bpa_origem_codigo,
										 esp_codigo)
								 VALUES (linha.uni_codigo,
										 linha.med_codigo,
										 linha.usu_codigo,
										 linha.ate_data,
										 NEW.proc_codigo,
										 ci_codigo,
										 linha.proc_bpa_tipo,
										 NEW.cd10_codigo,
										 'procedimento_atendimento',
										 NEW.pat_codigo,
										 linha.esp_codigo);
				
					END LOOP;
						
						
	RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma inserção na tabela ''procedimento_atendimento''.';
				
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;


  
  
  CREATE OR REPLACE FUNCTION social.itxtobap()
  RETURNS trigger AS
$BODY$DECLARE
  linha RECORD;
  bpaCodigo bigint;
  ciCodigo bigint;
  procColetaLaboratorial bigint;  
BEGIN

	FOR linha IN SELECT a.usu_codigo,
			       ai.med_codigo_coleta,
			       ci.proc_codigo,
			       p.proc_bpa_tipo,
			       p.proc_nome,
			       'P' as itx_urgente,
			       c.col_data_coleta,
			       ai.usr_codigo
			  FROM coleta c
			  join agenda_itens ai
			    on ai.agei_codigo = c.agei_codigo
			  join agenda a 
			    on a.age_codigo = ai.age_codigo
			  join convenio_itens ci
			    on ci.coni_codigo = ai.coni_codigo
			  join procedimento p
			    on p.proc_codigo = ci.proc_codigo
			 WHERE c.col_codigo=NEW.col_codigo LOOP	
		 SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
				
						-- Buscar se já foi feito um BPA
						-- BUSCAR PROCEDIMENTO DE COLETA LABORATORIAL

					SELECT proc_codigo from procedimento where proc_codigo_sus = '0201020041' into procColetaLaboratorial;

															
					SELECT bpa_codigo 
					  FROM bpa
					 WHERE bpa_origem = 'coleta'
					   AND bpa_origem_codigo = NEW.col_codigo
					  INTO bpaCodigo;

					  
						IF FOUND THEN					
							-- Atualiza BPA
							UPDATE bpa
							   SET med_codigo  = linha.med_codigo_coleta,
							       usr_codigo  = linha.usr_codigo,
								   usu_codigo  = linha.usu_codigo,
								   bpa_data    = linha.col_data_coleta,
								   proc_codigo = linha.proc_codigo,
								   ci_codigo = ciCodigo,
								   bpa_tipo = linha.proc_bpa_tipo
							 WHERE bpa_codigo = bpaCodigo;
							 RAISE NOTICE 'Um registro na tabela ''bpa'' foi atualizado devido uma alteração na tabela ''coleta''.';
						ELSE						
							-- Se não houver,  cria	   
							INSERT INTO BPA (med_codigo,
								 usr_codigo,
								 usu_codigo,
								 bpa_data,
								 proc_codigo,
								 ci_codigo,
								 bpa_tipo,
							  -- bpa_cd10_codigo, -- NULL
								 bpa_origem,
								 bpa_origem_codigo)
							VALUES (linha.med_codigo_coleta,
								 linha.usr_codigo,
								 linha.usu_codigo,
								 linha.col_data_coleta,
								 procColetaLaboratorial,
								 ciCodigo,
								 linha.proc_bpa_tipo,
							  -- NEW.cd10_codigo,
								 'coleta',
								 NEW.col_codigo);
							RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma alteração na tabela ''coleta''.';				 
					END IF; -- status
				END LOOP;
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

