﻿UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.115.114' WHERE conf_chave='VERSAO_SAUDE';
INSERT INTO config (conf_codigo,conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_data,cac_codigo)
VALUES (87,'DATA_COMPETENCIA','Data competência minima',TRUE,4,'2016-04-11',6);



 
 
CREATE OR REPLACE FUNCTION social.itxtobap()
  RETURNS trigger AS
$BODY$DECLARE
  linha RECORD;
  bpaCodigo bigint;
  ciCodigo bigint;
  procColetaLaboratorial bigint;  
BEGIN

	FOR linha IN SELECT a.usu_codigo,
			       ai.med_codigo_coleta,
			       ci.proc_codigo,
			       p.proc_bpa_tipo,
			       p.proc_nome,
			       'P' as itx_urgente,
			       c.col_data_coleta,
			       ai.usr_codigo
			  FROM coleta c
			  join agenda_itens ai
			    on ai.agei_codigo = c.agei_codigo
			  join agenda a 
			    on a.age_codigo = ai.age_codigo
			  join convenio_itens ci
			    on ci.coni_codigo = ai.coni_codigo
			  join procedimento p
			    on p.proc_codigo = ci.proc_codigo
			 WHERE c.col_codigo=NEW.col_codigo LOOP	
		 SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
				
						-- Buscar se já foi feito um BPA
						-- BUSCAR PROCEDIMENTO DE COLETA LABORATORIAL

					SELECT proc_codigo from procedimento where proc_codigo_sus = '0201020041' into procColetaLaboratorial;

															
					SELECT bpa_codigo 
					  FROM bpa
					 WHERE bpa_origem = 'coleta'
					   AND bpa_origem_codigo = NEW.col_codigo
					  INTO bpaCodigo;

					  
						IF FOUND THEN					
							-- Atualiza BPA
							UPDATE bpa
							   SET med_codigo  = linha.med_codigo_coleta,
							       usr_codigo  = linha.usr_codigo,
								   usu_codigo  = linha.usu_codigo,
								   bpa_data    = linha.col_data_coleta,
								   proc_codigo = linha.proc_codigo,
								   ci_codigo = ciCodigo,
								   bpa_tipo = linha.proc_bpa_tipo
							 WHERE bpa_codigo = bpaCodigo;
							 RAISE NOTICE 'Um registro na tabela ''bpa'' foi atualizado devido uma alteração na tabela ''coleta''.';
						ELSE						
							-- Se não houver,  cria	   
							INSERT INTO BPA (med_codigo,
								 usr_codigo,
								 usu_codigo,
								 bpa_data,
								 proc_codigo,
								 ci_codigo,
								 bpa_tipo,
							  -- bpa_cd10_codigo, -- NULL
								 bpa_origem,
								 bpa_origem_codigo,
								 esp_codigo)
							VALUES (linha.med_codigo_coleta,
								 linha.usr_codigo,
								 linha.usu_codigo,
								 linha.col_data_coleta,
								 procColetaLaboratorial,
								 ciCodigo,
								 linha.proc_bpa_tipo,
							  -- NEW.cd10_codigo,
								 'coleta',
								 NEW.col_codigo,
								 NEW.esp_codigo);
							RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma alteração na tabela ''coleta''.';				 
					END IF; -- status
				END LOOP;
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

alter table unidade ALTER COLUMN uni_cnes TYPE integer using uni_cnes::integer;

insert into permissoes (perm_descricao,perm_programa,perm_objeto) values ('ZF - RELATORIOS PROGRAMAS FEDERAIS','zf/relatorio/programasfederais','zf/relatorio/programasfederais') ;