UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.116.115' WHERE conf_chave='VERSAO_SAUDE';
UPDATE config SET conf_valor_string='Compatvel com a verso PEC: 2.0.13 do e-SUS' WHERE conf_chave='VERSAO_ESUS';
--CRIA TABELA ADMINISTRAO DE MEDICAMENTO
CREATE TABLE social.tb_administracao_produto
(
  adm_codigo bigint,
  adm_nome character varying,
  adm_sigla character varying,
  adm_tipo character varying,
  CONSTRAINT pk_adm_codigo PRIMARY KEY (adm_codigo)
);

ALTER TABLE leito_itens_grade ADD COLUMN adm_codigo bigint;
ALTER TABLE leito_itens_grade
  ADD FOREIGN KEY (adm_codigo) REFERENCES tb_administracao_produto (adm_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

--ALIMENTAR TABELA COM TIPOS DE ADMINISTRAO
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (1,'Absoro intestinal','VO','VIA ORAL');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (2,'Absoro sublingual','SL','VIA ORAL');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (3,'Retal','VR','VIA RETAL');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (4,'Endovenosa','EV','VIA INJETVEL');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (5,'Intradrmica','ID','VIA INJETVEL');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (6,'Intramuscular','IM','VIA INJETVEL');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (7,'Subcutnea','SC','VIA INJETVEL');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (8,'Inalatria','NBZ','OUTRAS VIAS');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (9,'Drmica','','OUTRAS VIAS');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (10,'Intranasal','','OUTRAS VIAS');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (11,'Intrasseo','IO','OUTRAS VIAS');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (12,'Ocular','','OUTRAS VIAS');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (13,'Otolgico','','OUTRAS VIAS');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (14,'Tpico','','OUTRAS VIAS');
INSERT INTO tb_administracao_produto (adm_codigo, adm_nome, adm_sigla, adm_tipo) VALUES (15,'Vaginal','','OUTRAS VIAS');



-- RELACIONADO AO BPA
-- Function: social.pattobpa()

-- DROP FUNCTION social.pattobpa();

CREATE OR REPLACE FUNCTION social.pattobpa()
  RETURNS trigger AS
$BODY$
DECLARE
  linha RECORD;
  ciCodigo bigint;  
    
BEGIN

	FOR linha IN SELECT ate.usu_codigo,
					    ate.ate_data, 
					    ate.med_codigo,
					    ate.uni_codigo,
					    ate.ate_acidentetrab,
					    proc.proc_bpa_tipo,
					    age.esp_codigo
				   FROM procedimento_atendimento AS pat
				   JOIN atendimento AS ate
				     ON ate.ate_codigo=pat.ate_codigo
				   JOIN procedimento AS proc
				     ON proc.proc_codigo=pat.proc_codigo
				  JOIN agendamento age
				     ON age.age_codigo=ate.age_codigo
				  WHERE pat_codigo=NEW.pat_codigo LOOP
				
						-- verificar acidente de trabalho
						SELECT ci.ci_cod FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
					
						IF (TG_OP = 'INSERT') THEN
						
							INSERT INTO BPA (uni_codigo,
											 usr_codigo,
											 usu_codigo,
											 bpa_data,
											 proc_codigo,
											 ci_codigo,
											 bpa_tipo,
											 bpa_cd10_codigo,
											 bpa_origem,
											 bpa_origem_codigo,
											 esp_codigo)
									 VALUES (linha.uni_codigo,
											 linha.med_codigo,
											 linha.usu_codigo,
											 linha.ate_data,
											 NEW.proc_codigo,
											 ciCodigo,
											 linha.proc_bpa_tipo,
											 NEW.cd10_codigo,
											 'procedimento_atendimento',
											 NEW.pat_codigo,
											 linha.esp_codigo);	
						END IF;
						IF (TG_OP = 'UPDATE') THEN
							UPDATE bpa SET uni_codigo = linha.uni_codigo,
								 usr_codigo = linha.med_codigo,
								 usu_codigo = linha.usu_codigo,
								 bpa_data = linha.ate_data,
								 proc_codigo =NEW.proc_codigo ,
								 ci_codigo = ciCodigo,
								 bpa_tipo = linha.proc_bpa_tipo,
								 bpa_cd10_codigo = COALESCE(NEW.cd10_codigo,NULL),
								 bpa_origem = 'procedimento_atendimento',
								 bpa_origem_codigo = NEW.pat_codigo,
								 esp_codigo = linha.esp_codigo
							   WHERE bpa_origem_codigo=NEW.pat_codigo;

						END IF;
					
					END LOOP;
						
						
	RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma insero na tabela ''procedimento_atendimento''.';
				
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION social.pattobpa()
  OWNER TO postgres;


  ALTER TABLE social.bpa
  DROP CONSTRAINT fk_bpa_ci;
  
  
  --
  
  CREATE OR REPLACE FUNCTION social.atetobpa()
  RETURNS trigger AS
$BODY$
DECLARE
  linha RECORD;
  bpaCodigo bigint;
  ciCodigo bigint;  
    
BEGIN

	FOR linha IN    SELECT age.uni_codigo,
						   ate.med_codigo,
						   ate.usu_codigo,
						   ate.ate_data,
						   proc.proc_codigo,
						   proc.proc_bpa_tipo,
						   cd10.cd10_codigo,
						   sispn_codigo,
						   age.age_emergencia,
						   age.esp_codigo
					  FROM atendimento AS ate
					  JOIN agendamento AS age
						ON age.age_codigo=ate.age_codigo
					  JOIN procedimento AS proc
						ON proc.proc_codigo_sus='0301010110'
					 LEFT JOIN cid10 AS cd10
						ON cd10.cd10_codigo=ate.cd10_codigo
					 WHERE ate.ate_codigo=NEW.ate_codigo LOOP
					 
				-- verificar ci
				IF linha.age_emergencia = 'S' THEN 
					SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Urgencia' AND ci_ativo='S' INTO ciCodigo;
				ELSE
					SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
				END IF;
		
				-- somente se h um sispn_codigo (FK com Pr-Natal)
				IF linha.sispn_codigo IS NOT NULL THEN
					  
					INSERT INTO BPA (uni_codigo,
									 usr_codigo,
									 usu_codigo,
									 bpa_data,
									 proc_codigo,
									 ci_codigo,
									 bpa_tipo,
									 bpa_cd10_codigo, 
									 bpa_origem,
									 bpa_origem_codigo,
									 esp_codigo)
							 VALUES (linha.uni_codigo,
									 linha.med_codigo,
									 linha.usu_codigo,
									 linha.ate_data,
									 NEW.proc_codigo,
									 ciCodigo,
									 linha.proc_bpa_tipo,
									 NEW.cd10_codigo,
									 'atendimento',
									 NEW.ate_codigo,
									 linha.esp_codigo);
					RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma insero na tabela ''atendimento'', informando um cdigo do ''sis pr-natal''.';				 
					
				END IF;

				
			END LOOP;
				
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
  
insert into permissoes (perm_descricao,perm_programa,perm_objeto) values ('BPA','zf/programasfederais/bpa','zf/programasfederais/bpa') ;








