UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.119.118' WHERE conf_chave='VERSAO_SAUDE';

-- Function: operacoesodontobpa()

-- DROP FUNCTION operacoesodontobpa();

CREATE OR REPLACE FUNCTION social.operacoesodontobpa()
  RETURNS trigger AS
$BODY$
DECLARE 
linha RECORD;
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM bpa WHERE bpa_origem = 'odontograma' AND bpa_origem_codigo = OLD.odo_preal_codigo;
		RETURN OLD;
		-- Procedimento e BPA excluido com sucesso
	ELSE 
		FOR linha IN	
		SELECT 
			odpr.odo_preal_codigo,
			odpr.odo_preal_dtcadastro,
			proc.proc_codigo,
			proc.proc_bpa_tipo,
			ate.uni_codigo,
			ate.med_codigo,
			ate.usu_codigo,
			age.esp_codigo
		FROM 
			odonto_procedimentos_realizados AS odpr
		INNER JOIN 
			procedimento AS proc ON odpr.proc_codigo = proc.proc_codigo
		INNER JOIN 
			odonto_procedimentos_controle AS odpc ON odpr.odo_pcon_codigo = odpc.odo_pcon_codigo
		INNER JOIN
			atendimento AS ate ON odpc.ate_codigo = ate.ate_codigo
		INNER JOIN agendamento AS age
					ON age.age_codigo = ate.age_codigo
		WHERE 
			odpr.odo_preal_codigo = NEW.odo_preal_codigo  LOOP
			-- Operao de Insert
			IF (TG_OP = 'INSERT') THEN
				INSERT 	INTO bpa
							(bpa_data, uni_codigo,usr_codigo,usu_codigo,proc_codigo,ci_codigo,bpa_tipo,bpa_origem,bpa_origem_codigo,bpa_ativo,bpa_data_alt,esp_codigo)
						VALUES
							(linha.odo_preal_dtcadastro,linha.uni_codigo,linha.med_codigo,linha.usu_codigo,linha.proc_codigo,'16',linha.proc_bpa_tipo,'odontograma',linha.odo_preal_codigo,'t',linha.odo_preal_dtcadastro,linha.esp_codigo);
				RETURN NEW;
				-- Procedimento e BPA inserido com sucesso!
			END IF;
			-- Operao de Update
			IF (TG_OP = 'UPDATE') THEN
				UPDATE bpa
					SET 
						uni_codigo = linha.uni_codigo,
						usr_codigo = linha.med_codigo,
						usu_codigo = linha.usu_codigo,
						proc_codigo = linha.proc_codigo,
						ci_codigo = '16',
						bpa_tipo = linha.proc_bpa_tipo,
						bpa_origem = 'odontograma',
						bpa_origem_codigo = linha.odo_preal_codigo,
						bpa_ativo = 't',
						bpa_data_alt = linha.odo_preal_dtcadastro,
						esp_codigo = linha.esp_codigo
					WHERE
						bpa_origem = 'odontograma' AND
						bpa_origem_codigo = linha.odo_preal_codigo;
				RETURN NEW;
				-- Procedimento e BPA atualizado com sucesso!
			END IF;
		END LOOP;
	END IF;
END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION operacoesodontobpa()
  OWNER TO postgres;

  

insert into social.permissoes (perm_descricao,perm_programa,perm_objeto) 
values ('RELATORIO/CONTABIL','zf/relatorio/contabil','zf/relatorio/contabil') ;

INSERT INTO config (conf_codigo,conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_string,cac_codigo)
VALUES ((select conf_codigo + 1 from config order by conf_codigo desc limit 1),'BPA_DIA_COMPETENCIA','Dia competencia do BPA',FALSE,1,'05',6);

--
CREATE OR REPLACE FUNCTION social.operacoesiitensmovimentohorus()
  RETURNS trigger AS
$BODY$
DECLARE 
linha RECORD;
tpxml character(1);
ite_validade date;
ite_vlrunit character varying(20);
ite_lote character varying(20);
tpmov character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM horus_dados WHERE hor_dad_origem = 'itensmovimento' AND hor_dad_origem_codigo = OLD.ite_codigo;
		RETURN OLD;	
	ELSE
		FOR linha IN
			SELECT 
				mov.mov_data,
				mov.mov_tipo, 
				mov.mov_saida,
				mov.mov_entrada,
				mov.set_entrada,
				mov.set_saida,
				pro.pro_codigo,
				pro.pro_horus,
				ite.ite_vlrunit,
				ite.ite_validade,
				ite.ite_lote,
				ite.ite_quantidade,
				ite.ite_codigo,
				count(ite.ite_codigo) AS num_registros,
				uni.uni_cnes
			FROM 
				itens_movimento AS ite
			INNER JOIN
				movimento AS mov ON ite.mov_codigo=mov.mov_codigo 
			INNER JOIN 
				produto AS pro ON ite.pro_codigo=pro.pro_codigo
			INNER JOIN 
				setor AS set ON mov.set_entrada=set.set_codigo OR mov.set_saida=set.set_codigo
			INNER JOIN 
				unidade AS uni ON set.uni_codigo=uni.uni_codigo
			WHERE 
				pro.pro_horus IS NOT NULL AND
				mov.mov_tipo IS NOT NULL AND
				mov.mov_saida IS NOT NULL AND
				pro.pro_codigo IS NOT NULL AND
				ite.ite_quantidade IS NOT NULL AND
				uni.uni_cnes IS NOT NULL AND
				ite.ite_codigo = NEW.ite_codigo 
			GROUP BY 
				mov.mov_data,
				mov.mov_tipo, 
				mov.mov_saida,
				mov.mov_entrada,
				mov.set_entrada,
				mov.set_saida,
				pro.pro_codigo,
				pro.pro_horus,
				ite.ite_vlrunit,
				ite.ite_validade,
				ite.ite_lote,
				ite.ite_quantidade,
				ite.ite_codigo,
				uni.uni_cnes LOOP

				RAISE NOTICE 'ite_vlrunit: %.', NEW.ite_vlrunit;
					
				IF (linha.num_registros > 0) THEN
					-- Validando Campo Lote
					IF (linha.ite_lote IS NULL) THEN
						ite_lote = '0';
					ELSE
						ite_lote = linha.ite_lote;
					END IF;
					-- Validando Valor do Item
					IF (linha.ite_vlrunit IS NULL) THEN
						ite_vlrunit = '0.0000';
					ELSE
						ite_vlrunit = linha.ite_vlrunit;
					END IF;
					-- Validando item da validade
					IF (linha.ite_validade IS NULL) THEN 
						ite_validade = (SELECT((DATE_PART('DAY', CURRENT_DATE)||'/'||DATE_PART('MONTH', CURRENT_DATE)||'/'||DATE_PART('YEAR', CURRENT_DATE))::DATE + interval '3 year')::DATE);
					ELSE
						ite_validade = linha.ite_validade;
					END IF;
					-- Valida tipo de XML(tpxml)
					IF (linha.mov_tipo <> 'T') THEN
						IF (linha.mov_tipo = 'S' AND linha.mov_saida = 'D') THEN 
							tpxml = 'D';
							tpmov = 'D'; 
						END IF;
						IF (linha.mov_tipo = 'S' AND linha.mov_saida <> 'D' ) THEN 
							tpxml = linha.mov_tipo;
							tpmov = linha.mov_saida; 
						END IF;
						IF (linha.mov_tipo = 'E') THEN 
							tpxml = linha.mov_tipo;
							tpmov = linha.mov_entrada; 
						END IF;
						-- Insert 
						IF (TG_OP = 'INSERT') THEN
							INSERT 	INTO horus_dados 
										(hor_dad_tpxml, hor_dad_status_envio, hor_dad_counidadecnes, hor_dad_nuproduto, hor_dad_tpproduto, hor_dad_vlitem, hor_dad_dtvalidade, hor_dad_nulote, hor_dad_qtd, hor_dad_nucnspaciente, hor_dad_tpmovimentacao, hor_dad_dtcadastro, hor_dad_origem, hor_dad_origem_codigo,hor_dad_dtrecebimentoprod)
									VALUES
										(tpxml,'F',linha.uni_cnes,linha.pro_horus,'B',ite_vlrunit,ite_validade,ite_lote,linha.ite_quantidade,'0',tpmov,NOW(),'itensmovimento',linha.ite_codigo,linha.mov_data);
							RETURN NEW;
						END IF;
					ELSE 
						-- Insert 
						IF (TG_OP = 'INSERT') THEN
						
							INSERT 	INTO horus_dados 
										(hor_dad_tpxml, hor_dad_status_envio, hor_dad_counidadecnes, hor_dad_nuproduto, hor_dad_tpproduto, hor_dad_vlitem, hor_dad_dtvalidade, hor_dad_nulote, hor_dad_qtd, hor_dad_nucnspaciente, hor_dad_tpmovimentacao, hor_dad_dtcadastro, hor_dad_origem, hor_dad_origem_codigo,hor_dad_dtrecebimentoprod)
									VALUES
										('E','F',linha.uni_cnes,linha.pro_horus,'B',ite_vlrunit,ite_validade,ite_lote,linha.ite_quantidade,'0','E-AE',NOW(),'itensmovimento',linha.ite_codigo,linha.mov_data);
										
							INSERT 	INTO horus_dados 
										(hor_dad_tpxml, hor_dad_status_envio, hor_dad_counidadecnes, hor_dad_nuproduto, hor_dad_tpproduto, hor_dad_vlitem, hor_dad_dtvalidade, hor_dad_nulote, hor_dad_qtd, hor_dad_nucnspaciente, hor_dad_tpmovimentacao, hor_dad_dtcadastro, hor_dad_origem, hor_dad_origem_codigo,hor_dad_dtrecebimentoprod)
									VALUES
										('S','F',linha.uni_cnes,linha.pro_horus,'B',ite_vlrunit,ite_validade,ite_lote,linha.ite_quantidade,'0','S-AE',NOW(),'itensmovimento',linha.ite_codigo,linha.mov_data);
							RETURN NEW;
						END IF;
					END IF;
					-- Update
					IF (TG_OP = 'UPDATE') THEN
						UPDATE horus_dados 
						   SET hor_dad_tpxml = tpxml, 
							   hor_dad_counidadecnes = linha.uni_cnes, 
							   hor_dad_nuproduto = linha.pro_horus, 
							   hor_dad_tpproduto = 'B', 
							   hor_dad_vlitem = linha.ite_vlrunit, 
							   hor_dad_dtvalidade = ite_validade, 
							   hor_dad_nulote = ite_lote, 
							   hor_dad_qtd = linha.ite_quantidade, 
							   hor_dad_nucnspaciente = '0', 
							   hor_dad_tpmovimentacao = tpmov, 
							   hor_dad_dtcadastro = NOW(), 
							   hor_dad_origem = 'itensmovimento', 
							   hor_dad_origem_codigo = linha.ite_codigo
						WHERE
							   hor_dad_origem = 'itensmovimento' AND 
							   hor_dad_origem_codigo = NEW.ite_codigo;
						RETURN NEW;	
					END IF;
				END IF;
		END LOOP;
	END IF;
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION social.operacoesiitensmovimentohorus()
  OWNER TO postgres;