UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.121.120' WHERE conf_chave='VERSAO_SAUDE';


CREATE TABLE social.tb_ciap_ms
(
  co_ciap bigint NOT NULL, -- Cdigo identificador do CIAP. Chave primria da tabela. Chave estrangeira com origem na tabela TB_CIAP.
  ds_inclusao character varying(400), -- Critrio de incluso do CIAP.
  ds_exclusao character varying(400), -- Critrio de excluso do CIAP.
  ds_criterio character varying(400), -- Critrio de avaliao do CIAP.
  ds_nota character varying(400), -- Espao para nota adicional sobre o CIAP.
  ds_definicao character varying(400), -- Forma como  definido o CIAP.
  co_ciap_componente bigint, -- Cdigo identificador do componente do CIAP. Chave estrangeira com origem na tabela TB_CIAP_COMPONENTE.
  tp_ciap bigint, -- Cdigo identificador do tipo de CIAP. Chave estrangeira com origem na tabela TB_TIPO_CIAP.
  co_ciap_capitulo bigint, -- Cdigo identificador do captulo do CIAP. Chave estrangeira com origem na tabela TB_CIAP_CAPITULO.
  ds_inclusao_filtro character varying(400), -- Filtro do critrio de incluso do CIAP.
  CONSTRAINT pk_ciapms PRIMARY KEY (co_ciap),
  CONSTRAINT fk_ciap_ciapms FOREIGN KEY (co_ciap)
      REFERENCES tb_ciap (co_seq_ciap) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION

)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.tb_ciap_ms
  OWNER TO postgres;
COMMENT ON TABLE social.tb_ciap_ms
  IS 'Responsvel por armazenar informaes da Classificao Internacional de Ateno Primria em relao ao padro do Ministrio da Sade.';
COMMENT ON COLUMN tb_ciap_ms.co_ciap IS 'Cdigo identificador do CIAP. Chave primria da tabela. Chave estrangeira com origem na tabela TB_CIAP.';
COMMENT ON COLUMN tb_ciap_ms.ds_inclusao IS 'Critrio de incluso do CIAP.';
COMMENT ON COLUMN tb_ciap_ms.ds_exclusao IS 'Critrio de excluso do CIAP.';
COMMENT ON COLUMN tb_ciap_ms.ds_criterio IS 'Critrio de avaliao do CIAP.';
COMMENT ON COLUMN tb_ciap_ms.ds_nota IS 'Espao para nota adicional sobre o CIAP.';
COMMENT ON COLUMN tb_ciap_ms.ds_definicao IS 'Forma como  definido o CIAP.';
COMMENT ON COLUMN tb_ciap_ms.co_ciap_componente IS 'Cdigo identificador do componente do CIAP. Chave estrangeira com origem na tabela TB_CIAP_COMPONENTE.';
COMMENT ON COLUMN tb_ciap_ms.tp_ciap IS 'Cdigo identificador do tipo de CIAP. Chave estrangeira com origem na tabela TB_TIPO_CIAP.';
COMMENT ON COLUMN tb_ciap_ms.co_ciap_capitulo IS 'Cdigo identificador do captulo do CIAP. Chave estrangeira com origem na tabela TB_CIAP_CAPITULO.';
COMMENT ON COLUMN tb_ciap_ms.ds_inclusao_filtro IS 'Filtro do critrio de incluso do CIAP.';


-- Index: in_ciapms_cociapcapitulo

-- DROP INDEX in_ciapms_cociapcapitulo;

CREATE INDEX in_ciapms_cociapcapitulo
  ON social.tb_ciap_ms
  USING btree
  (co_ciap_capitulo);

-- Index: in_ciapms_cociapcomponente

-- DROP INDEX in_ciapms_cociapcomponente;

CREATE INDEX in_ciapms_cociapcomponente
  ON social.tb_ciap_ms
  USING btree
  (co_ciap_componente);

-- Index: in_ciapms_dsinclusaofiltro

-- DROP INDEX in_ciapms_dsinclusaofiltro;

CREATE INDEX in_ciapms_dsinclusaofiltro
  ON social.tb_ciap_ms
  USING btree
  (ds_inclusao_filtro COLLATE pg_catalog."default");

-- Index: in_ciapms_tpciap

-- DROP INDEX in_ciapms_tpciap;

CREATE INDEX in_ciapms_tpciap
  ON social.tb_ciap_ms
  USING btree
  (tp_ciap);


INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (265, 'LESO DE NERVO, LESO DA COLUNA VERTEBRAL', NULL, NULL, NULL, NULL, 7, 5, 9, 'lesao de nervo, lesao da coluna vertebral');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (219, NULL, 'LESO AGUDA DO MENISCO/LIGAMENTO INTERNO DO JOELHO L96', NULL, NULL, 'ESTIRAMENTO TRAUMTICO DA PARTE AFETADA E DOR AGRAVADA POR DISTENSO OU TENSO DA ESTRUTURA', 7, 5, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (8, 'NENHUMA DOENA OU AFECO DETECTADA DURANTE A CONSULTA', 'MEDICINA PREVENTIVA/MANUTENO DA SADE A98', NULL, 'S VEZES O PACIENTE APRESENTA UM MOTIVO DA CONSULTA QUE O PROFISSIONAL NO PODE INTERPRETAR COMO UM DIAGNSTICO DO DOMNIO DA ATENO PRIMRIA  SADE. NESTES CASOS O PROFISSIONAL DEVE USAR O CDIGO A97, INDICANDO QUE O MOTIVO DA CONSULTA DO PACIENTE SE R', NULL, 7, 7, 2, 'nenhuma doenca ou afeccao detectada durante a consulta');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (10, 'DOENA OU CONDIO DE NATUREZA OU LOCALIZAO NO ESPECIFICADAS; PORTADOR DE DOENA', NULL, NULL, NULL, NULL, 7, 7, 2, 'doenca ou condicao de natureza ou localizacao nao especificadas; portador de doenca');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (11, 'LINFADENOPATIA COM OU SEM DOR/SENSIBILIDADE', 'LINFADENITE - AGUDA B70, CRNICA B71', NULL, NULL, NULL, 1, 2, 3, 'linfadenopatia com ou sem dor/sensibilidade');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (12, NULL, 'ANEMIA B82, PALIDEZ S08', NULL, NULL, NULL, 1, 2, 3, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (13, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER AIDS OU HIV SEM OS TER, OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 3, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (14, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER A DOENA SEM A TER, OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 3, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (15, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER OUTRA DOENA SEM A TER, OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 3, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (16, 'INCAPACIDADE PROVOCADA POR PROBLEMAS DE PERDA DE SANGUE', NULL, NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA NO SANGUE/ RGOS FORMADORES DE SANGUE/ MECANISMO IMUNE', 1, 2, 3, 'incapacidade provocada por problemas de perda de sangue');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (17, NULL, 'ESPLENOMEGALIA B87', NULL, NULL, NULL, 1, 2, 3, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (18, 'ABCESSO DE GNGLIO LINFTICO', 'LINFADENITE CRNICA B71; LINFADENITE MESENTRICA B71', 'GNGLIO LINFTICO AUMENTADO B02', NULL, 'UM OU MAIS GNGLIOS LINFTICOS INFLAMADOS OU AUMENTADOS, SENSVEIS OU COM DOR, NA MESMA REGIO ANATMICA, QUE APARECERAM RECENTEMENTE (MENOS DE 6 SEMANAS) E CUJA FONTE PRIMRIA DE INFECO  DESCONHECIDA', 7, 3, 3, 'abcesso de ganglio linfatico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (19, 'LINFADENITE MESENTRICA, AGUDA OU CRNICA', 'LINFADENITE AGUDA (EXCETO MESENTRICA) B70, LINFANGITE K99', 'GNGLIO LINFTICO AUMENTADO BO2', NULL, 'GNGLIOS LINFTICOS AUMENTADOS, DOLOROSOS, PERSISTINDO MAIS DE 6 SEMANAS, OU IDENTIFICAO POR CIRURGIA, ECOGRAFIA OU LINFOGRAFIA DE GNGLIOS LINFTICOS MESENTRICOS AUMENTADOS E INFLAMADOS', 7, 3, 3, 'linfadenite mesenterica, aguda ou cronica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (20, NULL, NULL, 'OUTRAS NEOPLASIAS MALIGNAS B74; NEOPLASIAS DE BENIGNIDADE OU MALIGNIDADE NO ESPECIFICADA (QUANDO NO H DADOS HISTOLGICOS DISPONVEIS) B75', NULL, 'MANIFESTAO HISTOLGICA CARACTERSTICA', 7, 4, 3, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (21, 'TODOS OS TIPOS DE LEUCEMIA', NULL, 'NEOPLASIAS DE BENIGNIDADE OU MALIGNIDADE NO ESPECIFICADA (QUANDO NO H DADOS HISTOLGICOS DISPONVEIS) B75', NULL, 'MANIFESTAO HISTOLGICA CARACTERSTICA', 7, 4, 3, 'todos os tipos de leucemia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (22, 'DOENA MIELOPROLIFERATIVA, MIELOMA MLTIPLO', 'DOENA DE HODGKIN, LINFOMAS B72', NULL, NULL, NULL, 7, 4, 3, 'doenca mieloproliferativa, mieloma multiplo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (23, 'POLICITEMIA VERA', NULL, NULL, NULL, NULL, 7, 4, 3, 'policitemia vera');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (24, NULL, NULL, NULL, NULL, NULL, 7, 5, 3, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (25, NULL, 'RUPTURA TRAUMTICA DO BAO B76', NULL, NULL, NULL, 7, 5, 3, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (26, 'ANEMIA DE CLULAS FALCIFORMES, CARACTERSTICA DA CLULA FALCIFORME, ESFEROCITOSE, TALASSEMIA', NULL, 'OUTRAS MALFORMAES CONGNITAS B79', NULL, 'ACHADOS CARACTERSTICOS COM TESTES CLNICOS TAIS COMO ELETROFORESE DA HEMOGLOBINA, ESFREGAO DE SANGUE OU AUMENTO DA FRAGILIDADE OSMTICA DOS ERITRCITOS', 7, 6, 3, 'anemia de celulas falciformes, caracteristica da celula falciforme, esferocitose, talassemia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (27, 'ANEMIA CONGNITA', 'ANEMIA HEMOLTICA HEREDITRIA B78, HEMOFILIA B83', NULL, NULL, NULL, 7, 6, 3, 'anemia congenita');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (28, 'ANEMIA DEVIDO A PERDA DE SANGUE', 'DEFICINCIA DE FERRO SEM ANEMIA T91', 'ANEMIA NO ESPECIFICADA B82', NULL, 'DIMINUIO DA HEMOGLOBINA OU DO HEMATCRITO, ATINGINDO NVEIS INFERIORES AOS INDICADOS PARA IDADE E SEXO; E AINDA EVIDNCIA DE PERDA DE SANGUE, OU NDICES OU APARNCIA DE ERITRCITOS HIPOCRMICOS MICROCTICOS NA AUSNCIA DE TALASSEMIA, OU DIMINUIO DO N', 7, 7, 3, 'anemia devido a perda de sangue');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (195, 'SINTOMAS DA ARTICULAO TEMPORO-MANDIBULAR', 'SINAIS/SINTOMAS DOS DENTES E GENGIVAS D19', NULL, NULL, NULL, 1, 2, 8, 'sintomas da articulacao temporo-mandibular');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (196, NULL, NULL, NULL, NULL, NULL, 1, 2, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (197, NULL, 'DORES MUSCULARES, MIALGIA L18', NULL, NULL, NULL, 1, 2, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (198, NULL, NULL, NULL, NULL, NULL, 1, 2, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (199, NULL, NULL, NULL, NULL, NULL, 1, 2, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (200, NULL, NULL, NULL, NULL, NULL, 1, 2, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (201, NULL, NULL, NULL, NULL, NULL, 1, 2, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (202, 'CIBRAS NAS PERNAS', 'DORES MUSCULARES, MIALGIA L18; PERNAS INQUIETAS N04', NULL, NULL, NULL, 1, 2, 8, 'caibras nas pernas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (203, NULL, NULL, NULL, NULL, NULL, 1, 2, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (204, 'FIBROSITE, FIBROMIALGIA, MIALGIA, REUMATISMO NE', 'DORES DE COLUNA L01, L02, L03; CIBRAS NA PERNA L14', NULL, NULL, NULL, 1, 2, 8, 'fibrosite, fibromialgia, mialgia, reumatismo ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (205, 'RIGIDEZ MUSCULAR; ATROFIA, PERDA MUSCULAR; DISTENSO MUSCULAR; CANSAO MUSCULAR', 'DORES DE COLUNA L01, L02, L03; CIBRAS NA PERNA L14; DORES DE CRESCIMENTO NA CRIANA L29; SNDROME DAS PERNAS INQUIETAS N04', NULL, NULL, NULL, 1, 2, 8, 'rigidez muscular; atrofia, perda muscular; distensao muscular; cansaco muscular');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (206, 'ARTRALGIA, DERRAME ARTICULAR, DORES ARTICULARES, ARTICULAES RGIDAS, INCHADAS, ENFRAQUECIDAS', 'ARTICULAES ESPECIFICADAS, L07,L08,L10-13,L15-17', NULL, NULL, NULL, 1, 2, 8, 'artralgia, derrame articular, dores articulares, articulacoes rigidas, inchadas, enfraquecidas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (207, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER CNCER DO SISTEMA MSCULO-ESQUELTICO SEM O TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (208, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'RECEIO DE UM PACIENTE TER A DOENA SEM A TER, OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (209, NULL, 'QUEDAS A29; MANCAR N29; DIFICULDADES EM ANDAR N29; PROBLEMAS COM A FORMA DE ANDAR N29', NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA MUSCULOESQUELTICO', 1, 2, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (125, NULL, NULL, NULL, NULL, NULL, 5, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (75, 'PROBLEMAS COM A DENTADURA, INFLAMAO OU SANGRAMENTO GENGIVAL, DENTIO, DOR DE DENTES', 'CRIES D82', NULL, NULL, NULL, 1, 2, 4, 'problemas com a dentadura, inflamacao ou sangramento gengival, denticao, dor de dentes');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (210, 'DORES DE CRESCIMENTO NA CRIANA; OUTROS SINAIS, SINTOMAS E CONDIES MAL-DEFINIDAS DO SISTEMA MSCULO-ESQUELTICO', 'UNHAS EM BAQUETA S22', NULL, NULL, NULL, 1, 2, 8, 'dores de crescimento na crianca; outros sinais, sintomas e condicoes mal-definidas do sistema musculo-esqueletico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (211, 'TENOSSINOVITE INFECCIOSA; OSTEOMIELITE; ARTRITE PIOGNICA', 'DOENA DE REITER L99, EFEITOS TARDIOS DE POLIOMIELITE N70', NULL, NULL, 'INFECES LOCALIZADAS DO APARELHO MSCULO-ESQUELTICO', 7, 3, 8, 'tenossinovite infecciosa; osteomielite; artrite piogenica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (212, 'FIBROSARCOMA; OSTEOSSARCOMA', 'NEOPLASIAS SECUNDRIAS (CODIFICAR SEGUNDO LOCALIZAO PRIMRIA), NEOPLASIAS BENIGNAS/NOESPECIFICADAS L97', NULL, NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 8, 'fibrosarcoma; osteossarcoma');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (213, 'FRATURA DE COLLES', 'FRATURA PATOLGICA L95, L99; NO-UNIO L99', 'SINTOMAS NO BRAO L09; OUTROS TRAUMATISMOS L81', NULL, 'SINAIS IMAGIOLGICOS DE FRATURA, OU TRAUMATISMO E DEFORMAO VISVEL OU PALPVEL OU CREPITAO SSEA', 7, 5, 8, 'fratura de colles');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (214, 'FRATURA DE POTT', 'FRATURA DA RTULA L76, FRATURA PATOLGICA L95, L99; NO-UNIO L99', 'SINTOMAS DA PERNA L14, SINTOMAS DO TORNOZELO L16, OUTROS TRAUMATISMOS L81', NULL, 'EVIDNCIA IMAGIOLGICA DE FRATURA OU TRAUMA, E DEFORMAO VISVEL OU PALPVEL, OU CREPITAO SSEA', 7, 5, 8, 'fratura de pott');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (215, 'CARPO, METACARPO; FALANGE DA MO; FALANGE DO P; TARSO, METATARSO', 'FRATURA PATOLGICA L95,L99; NO-CONSOLIDAO L99', 'SINTOMAS DO BRAO L09 OU PERNA L14; OUTROS TRAUMATISMOS L81', NULL, 'EVIDNCIA IMAGIOLGICA DE FRATURA, OU TRAUMATISMO E DEFORMAO VISVEL OU PALPVEL, OU CREPITAO SSEA', 7, 5, 8, 'carpo, metacarpo; falange da mao; falange do pe; tarso, metatarso');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (216, 'FRATURA COLO DO FMUR', 'FRATURAS PATOLGICAS L95, L99; NO-CONSOLIDAO L99', 'SINTOMAS DA PERNA L14; OUTROS TRAUMATISMOS L81', NULL, 'EVIDNCIA IMAGIOLGICA DE FRATURA, OU TRAUMATISMO E DEFORMAO VISVEL OU PALPVEL, OU CREPITAO SSEA', 7, 5, 8, 'fratura colo do femur');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (217, 'TODAS AS FRATURAS NO-ESPECIFICADAS EM L72 A L75, N80', 'FRATURA PATOLGICA L95,L99; NO-CONSOLIDAO L99; FRATURA CRANIANA N80', 'SINTOMAS NO COMPONENTE 1', NULL, 'EVIDNCIA IMAGIOLGICA DE FRATURA, OU TRAUMATISMO E DESLOCAMENTO VISVEL OU PALPVEL DA SUPERFCIE SSEA', 7, 5, 8, 'todas as fraturas nao-especificadas em l72 a l75, n80');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (218, NULL, NULL, 'SINTOMAS DO TORNOZELO L16', NULL, 'TORO TRAUMTICA DA PARTE AFETADA E DOR AGRAVADA PELA DISTENSO OU TENSO DA ESTRUTURA AFETADA', 7, 5, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (220, 'QUAISQUER TORES E DISTENSES DAS ARTICULAES E LIGAMENTOS, EXCETO TORNOZELO, JOELHO E COLUNA VERTEBRAL', 'TORNOZELO L77; JOELHO L78; COLUNA CERVICAL, TRAUMATISMO EM CHICOTADA L83; DISTENSO DE COLUNA L84', 'SINTOMAS NA COMPONENTE 1', NULL, 'ESTIRAMENTO TRAUMTICO DA PARTE AFETADA E AINDA DORES AGRAVADAS PELA DISTENSO OU TENSO DA ESTRUTURA AFETADA', 7, 5, 8, 'quaisquer torcoes e distensoes das articulacoes e ligamentos, exceto tornozelo, joelho e coluna vertebral');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (221, 'QUAISQUER LUXAES E SUBLUXAES, INCLUINDO DA COLUNA VERTEBRAL', NULL, 'SINTOMAS NA COMPONENTE 1', 'CODIFICAR LUXAES POR FRATURA EM FRATURAS', 'LESO DA ARTICULAO E EVIDNCIA IMAGIOLGICA DE UMA LUXAO OU SUBLUXAO, OU DEFORMAO PALPVEL OU VISVEL PROVOCADA POR LUXAO', 7, 5, 8, 'quaisquer luxacoes e subluxacoes, incluindo da coluna vertebral');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (222, 'CORPO ESTRANHO PROFUNDO; HEMARTROSE; AMPUTAO TRAUMTICA', 'TRAUMATISMO INTERNO TORCICO, ABDOMINAL E DA PLVIS A81; TRAUMATISMO MLTIPLO A81; EFEITOS TARDIOS DE TRAUMATISMO: DEFORMAES, INCAPACIDADES, CICATRIZAO A82; TRAUMATISMOS DOS DENTES D80, E DO TMPANO H77; NO-CONSOLIDAO, ARTROPATIA TRAUMTICA L91; M', NULL, NULL, NULL, 7, 5, 8, 'corpo estranho profundo; hemartrose; amputacao traumatica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (223, 'GENU VARUM; P BOTO (TALIPE); LUXAO CONGNITA DO QUADRIL; GENU RECURVATUM; MALFORMAES DO CRNIO E DA FACE; OUTRAS DEFORMAES CONGNITAS DO P', 'ESCOLIOSE L85; P CHATO (ADQUIRIDO) L98; ESPINHA BFIDA N85', NULL, NULL, NULL, 7, 6, 8, 'genu varum; pe boto (talipe); luxacao congenita do quadril; genu recurvatum; malformacoes do cranio e da face; outras deformacoes congenitas do pe');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (224, 'SNDROMES COM OU SEM IRRADIAO DE DOR: LESO DO DISCO CERVICAL; SNDROME CERVICOBRAQUIAL; OSTEOARTRITE; SNDROME RADICULAR DOS MEMBROS SUPERIORES; ESPONDILOSE; TORES E DISTENSES; TORCICOLO; TRAUMATISMO EM CHICOTADA', NULL, NULL, NULL, NULL, 7, 7, 8, 'sindromes com ou sem irradiacao de dor: lesao do disco cervical; sindrome cervicobraquial; osteoartrite; sindrome radicular dos membros superiores; espondilose; torcoes e distensoes; torcicolo; traumatismo em chicotada');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (278, 'ANSIEDADE NE, SENTIR-SE AMEAADO', 'PERTURBAO DE ANSIEDADE P74', NULL, NULL, 'SENTIMENTOS RELATADOS PELO PACIENTE COMO UMA EXPERINCIA EMOCIONAL OU PSICOLGICA NO ATRIBUDA A UMA PERTURBAO MENTAL. VERIFICA-SE UMA TRANSIO GRADUAL DE SENTIMENTOS INDESEJVEIS, MAS MAIS OU MENOS NORMAIS, PARA SENTIMENTOS TO PERTURBADORES PARA O P', 1, 2, 10, 'ansiedade ne, sentir-se ameacado');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (279, 'CHOQUE DE ADAPTAO, CHOQUE CULTURAL, STRESS, PESAR, SAUDADE, ESTRESSE PS-TRAUMTICO IMEDIATO, CHOQUE (PSQUICO)', 'DEPRESSO P03, PERTURBAO DEPRESSIVA P76, PERTURBAO DEPRESSIVA PS-TRAUMTICA P82', NULL, NULL, 'REAO A UM ACONTECIMENTO QUE PROVOCA ESTRESSE OU A UMA MUDANA SIGNIFICATIVA DE VIDA QUE EXIGE UMA ADAPTAO CONSIDERVEL, QUER COMO UMA REAO ESPERADA AO ACONTECIMENTO OU COMO UMA REAO DE M ADAPTAO QUE INTERFERE COM A VIDA QUOTIDIANA E RESULTA NUM', 1, 2, 10, 'choque de adaptacao, choque cultural, stress, pesar, saudade, estresse pos-traumatico imediato, choque (psiquico)');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (280, 'SENTIR-SE POUCO  VONTADE, S, INFELIZ, PREOCUPADO', 'PERTURBAO DEPRESSIVA P76', NULL, NULL, 'SENTIMENTOS RELATADOS PELO PACIENTE COMO UMA EXPERINCIA EMOCIONAL OU PSICOLGICA NO ATRIBUDA A UMA PERTURBAO MENTAL. VERIFICA-SE UMA TRANSIO GRADUAL DE SENTIMENTOS INDESEJVEIS, MAS MAIS OU MENOS NORMAIS, PARA SENTIMENTOS QUE SO TO PERTURBADORES', 1, 2, 10, 'sentir-se pouco a vontade, so, infeliz, preocupado');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (281, 'AGITAO NE, DESASSOSSEGO NE', 'CRIANA HIPER-ATIVA P21, IRRITABILIDADE DE UM ELEMENTO DA FAMLIA Z13', NULL, NULL, 'SENTIMENTOS RELATADOS PELO PACIENTE COMO UMA EXPERINCIA EMOCIONAL OU PSICOLGICA NO ATRIBUDA A UMA PERTURBAO MENTAL. VERIFICA-SE UMA TRANSIO GRADUAL DE SENTIMENTOS INDESEJVEIS, MAS MAIS OU MENOS NORMAIS, PARA SENTIMENTOS QUE SO TO PERTURBADORES', 1, 2, 10, 'agitacao ne, desassossego ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (282, 'PREOCUPAO COM O ENVELHECIMENTO, SENESCNCIA', 'DEMNCIA P70', NULL, NULL, 'SENTIMENTOS RELATADOS PELO PACIENTE COMO UMA EXPERINCIA EMOCIONAL OU PSICOLGICA NO ATRIBUDA A UMA PERTURBAO MENTAL. VERIFICA-SE UMA TRANSIO GRADUAL DE SENTIMENTOS INDESEJVEIS, MAS MAIS OU MENOS NORMAIS, PARA SENTIMENTOS QUE SO TO PERTURBADORES', 1, 2, 10, 'preocupacao com o envelhecimento, senescencia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (42, 'HEMORRAGIA, OBSTRUO, PERFURAO', NULL, 'AZIA D03; INDIGESTO D07', NULL, 'ACHADOS IMAGIOLGICOS CARACTERSTICOS; OU SINAIS ENDOSCPICOS CARACTERSTICOS; OU SINTOMAS EXACERBADOS EM PACIENTE COM HISTRIA CLNICA DE LCERA NO DUODENO', 7, 7, 4, 'hemorragia, obstrucao, perfuracao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (142, NULL, 'DOR ATRIBUDA A CAUSAS CARDACAS K01,  PAREDE TORCICA L04, AO SISTEMA RESPIRATRIO R01', NULL, NULL, NULL, 1, 2, 2, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (283, 'INSNIA, PESADELOS, APNIA DO SONO, SONAMBULISMO, SONOLNCIA', 'CANSAO PROVOCADO PELAS VIAGENS E DIFERENA DE FUSO HORRIO A88', NULL, NULL, 'A PERTURBAO DO SONO COMO DIAGNSTICO REQUER QUE O PROBLEMA DE SONO SEJA UMA QUEIXA IMPORTANTE QUE, SEGUNDO O PACIENTE E O PROFISSIONAL, NO SEJA CAUSADA POR OUTRA PERTURBAO MAS SEJA ANTES UM PROBLEMA EM SI MESMO. A INSNIA REQUER UMA DEFICINCIA QUALI', 1, 2, 10, 'insonia, pesadelos, apneia do sono, sonambulismo, sonolencia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (284, 'FRIGIDEZ, DIMINUIO DA LIBIDO', 'IMPOTNCIA P08, NO SATISFAO SEXUAL P08, PREOCUPAO SOBRE A PREFERNCIA SEXUAL P09', NULL, NULL, 'PROBLEMAS SEXUAIS RELATIVOS AO DESEJO, NO ATRIBUVEIS A QUALQUER PERTURBAO OU DOENA ORGNICA, MAS UM REFLEXO DA INCAPACIDADE DO PACIENTE DE PARTICIPAR NA RELAO SEXUAL POR FALTA DE DESEJO, NO FUNCIONAMENTO OU AUSNCIA DE RESPOSTA GENITAL.', 1, 2, 10, 'frigidez, diminuicao da libido');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (285, NULL, 'TOSSE COM EXPECTORAO R05, HEMOPTISE R24', NULL, NULL, NULL, 1, 2, 11, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (286, 'IMPOTNCIA NO ORGNICA OU DISPAREUNIA, EJACULAO PRECOCE, VAGINISMO DE ORIGEM PSICOGNICA', 'PROBLEMAS DE DESEJO SEXUAL P07, PREOCUPAO COM A PREFERNCIA SEXUAL P09, IMPOTNCIA ORGNICA E PROBLEMAS SEXUAIS Y07, VAGINISMO NE X04', NULL, NULL, 'PROBLEMAS SEXUAIS RELATIVOS  SATISFAO, NO ATRIBUVEIS A QUALQUER PERTURBAO OU DOENA ORGNICA, MAS A UM REFLEXO DA INCAPACIDADE DO PACIENTE DE PARTICIPAR NA RELAO SEXUAL, QUE O PRPRIO DESEJA, POR INSUFICINCIA DE FUNCIONAMENTO OU DE RESPOSTA GENI', 1, 2, 10, 'impotencia nao organica ou dispareunia, ejaculacao precoce, vaginismo de origem psicogenica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (287, NULL, 'PROBLEMAS DE DESEJO SEXUAL P07 OU DE SATISFAO SEXUAL P08', NULL, NULL, 'PROBLEMAS SEXUAIS RELATIVOS  PREFERNCIA, NO CAUSADOS POR QUALQUER PERTURBAO OU DOENA ORGNICA, MAS UM REFLEXO DA INCAPACIDADE DO PACIENTE DE PARTICIPAR DA RELAO SEXUAL, QUE ELE PRPRIO DESEJA, POR PROBLEMAS COM A ORIENTAO, A PREFERNCIA OU A IDE', 1, 2, 10, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (288, NULL, 'TIQUE DOLOROSO N92', NULL, NULL, 'GAGUEIRA E BALBUCIAR: PERTURBAO DA FALA CARACTERIZADA POR REPETIES FREQUENTES OU PROLONGAMENTOS DE SONS, OU POR HESITAES CONSTANTES QUE TORNAM O DISCURSO POUCO FLUENTE', 1, 2, 10, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (289, 'PROBLEMAS DE ALIMENTAO, PROBLEMAS COM O COMPORTAMENTO ALIMENTAR DAS CRIANAS', 'ANOREXIA NERVOSA P86, PROBLEMAS DE ALIMENTAO DOS ADULTOS T05', NULL, 'PROBLEMAS RELACIONADOS COM O COMPORTAMENTO DAS CRIANAS SO ESPECIALMENTE DIFCEIS DE CLASSIFICAR, POR ISSO ESTO DISTRIBUDOS POR QUATRO CAPTULOS DA CIAP. O FATO DE OS PAIS APRESENTAREM OU NO ESTES PROBLEMAS AO CLNICO GERAL REFLETE A SUA OPINIO ACERC', NULL, 1, 2, 10, 'problemas de alimentacao, problemas com o comportamento alimentar das criancas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (153, 'TODO O TIPO DE INFECES DE TUBERCULOSE EM QUALQUER PARTE DO CORPO, EFEITOS TARDIOS', NULL, NULL, NULL, NULL, 1, 2, 2, 'todo o tipo de infeccoes de tuberculose em qualquer parte do corpo, efeitos tardios');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (266, 'HIDROCEFALIA, ESPINHA BFIDA', NULL, NULL, NULL, NULL, 7, 7, 9, 'hidrocefalia, espinha bifida');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (290, NULL, 'DEVIDO A PERTURBAES ORGNICAS U04', NULL, 'PROBLEMAS RELACIONADOS COM O COMPORTAMENTO DAS CRIANAS SO ESPECIALMENTE DIFCEIS DE CLASSIFICAR, POR ISSO ESTO DISTRIBUDOS POR QUATRO CAPTULOS DA ICPC. O FATO DE OS PAIS APRESENTAREM OU NO ESTES PROBLEMAS AO CLNICO GERAL REFLETE A SUA OPINIO ACERC', 'EMISSO INVOLUNTRIA DE URINA DURANTE O DIA OU DURANTE A NOITE E NO ATRIBUVEL A QUALQUER CAUSA ORGNICA.', 1, 2, 10, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (291, NULL, NULL, NULL, NULL, 'A ENCOPRESE REQUER UMA EMISSO FREQUENTE DE FEZES MOLDADAS EM LOCAIS IMPRPRIOS, CONSIDERADA ANORMAL PARA A IDADE, E NO CAUSADA POR OBSTIPAO, DIFICULDADES DE CONTROLE DO ESFNCTER OU OUTRA DOENA', 1, 2, 10, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (29, 'ANEMIA MACROCTICA, ANEMIA MEGALOBLSTICA, ANEMIA PERNICIOSA', 'DEFICINCIA DE VITAMINA B12 SEM ANEMIA T91', NULL, NULL, 'ANEMIA MACROCTICA POR NDICES OU ESFREGAO; E AINDA NVEL BAIXO DE VITAMINA B12 E CIDO FLICO,OU TESTE DE SCHILLING POSITIVO', 7, 7, 3, 'anemia macrocitica, anemia megaloblastica, anemia perniciosa');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (30, 'CARCINOMA DO ESTMAGO', NULL, 'OUTRAS NEOPLASIAS MALIGNAS (QUANDO A LOCALIZAO PRIMRIA  DESCONHECIDA) D77; NEOPLASIAS DE BENIGNIDADE OU MALIGNIDADE DESCONHECIDA (QUANDO A HISTOLOGIA NO SE ENCONTRA DISPONVEL) D78', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 4, 'carcinoma do estomago');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (31, NULL, NULL, 'OUTRAS NEOPLASIAS MALIGNAS (QUANDO A LOCALIZAO PRIMRIA  DESCONHECIDA) D77; NEOPLASIAS DE BENIGNIDADE OU MALIGNIDADE DESCONHECIDA(QUANDO A HISTOLOGIA NO SE ENCONTRA DISPONVEL) D78', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 4, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (32, 'CARCINOMA DO PNCREAS', NULL, 'NEOPLASIAS DE BENIGNIDADE OU MALIGNIDADE DESCONHECIDA (QUANDO A HISTOLOGIA NO SE ENCONTRA DISPONVEL) D78', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 4, 'carcinoma do pancreas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (33, 'TODO O TIPO DE MALIGNIDADE PRIMRIA DO APARELHO DIGESTIVO EXCETUANDO D74 A D76; CNCER DA VESCULA; CNCER DO FGADO', 'MALIGNIDADE SECUNDRIA DE LOCALIZAO CONHECIDA (CODIFICAR DE ACORDO COM A LOCALIZAO);LOCALIZAO DESCONHECIDA A79', 'BENIGNA/ INCERTA NEOPLASIA DIGESTIVA D78', NULL, NULL, 7, 4, 4, 'todo o tipo de malignidade primaria do aparelho digestivo excetuando d74 a d76; cancer da vesicula; cancer do figado');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (34, 'PLIPOS DO ESTMAGO, DUODENO, CLON, RETO', NULL, NULL, NULL, NULL, 7, 4, 4, 'polipos do estomago, duodeno, colon, reto');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (35, 'CORPO ESTRANHO SOB A UNHA', NULL, NULL, NULL, NULL, 1, 5, 12, 'corpo estranho sob a unha');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (36, 'CORPO ESTRANHO NO TUBO DIGESTIVO, INCLUINDO BOCA, ESFAGO E RETO', 'CORPO ESTRANHO NA LARINGE R87, INALADO R87', NULL, NULL, NULL, 7, 5, 4, 'corpo estranho no tubo digestivo, incluindo boca, esofago e reto');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (37, 'TRAUMATISMOS DOS RGOS ABDOMINAIS, DENTES E LNGUA', 'TRAUMATISMOS DE MLTIPLOS RGOS A81, RGOS PLVICOS X82, Y80', NULL, NULL, NULL, 7, 5, 4, 'traumatismos dos orgaos abdominais, dentes e lingua');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (38, 'MALFORMAES BILIARES; LBIO E PALATO LEPORINOS; DIVERTCULO DE MECKEL; MEGACLON, DOENA DE HIRSCHPRUNG; ATRESIA ESOFGICA; ESTENOSE PILRICA; LNGUA PRESA', 'HEMANGIOMA, LINFANGIOMA B79; ALTERAES CONGNITAS DO METABOLISMO T80', NULL, NULL, NULL, 7, 6, 4, 'malformacoes biliares; labio e palato leporinos; diverticulo de meckel; megacolon, doenca de hirschprung; atresia esofagica; estenose pilorica; lingua presa');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (39, 'CRIES; ABCESSOS; GENGIVITE; MAL-OCLUSO; PERTURBAO DA ARTICULAO TEMPOROMANDIBULAR; ANGINA DE VINCENT', 'DENTIO D19; PROBLEMAS COM A DENTADURA D19; TRAUMATISMO DOS DENTES E GENGIVAS D80', NULL, NULL, NULL, 7, 7, 4, 'caries; abcessos; gengivite; mal-oclusao; perturbacao da articulacao temporomandibular; angina de vincent');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (40, 'LCERA AFTOSA; QUILOSE; GLOSSITE; MUCOCELE; PAROTITE; CLCULO SALIVAR; ESTOMATITE; AFTAS', 'CAXUMBA D71; TRAUMATISMOS D80; HERPES SIMPLES S71', NULL, NULL, NULL, 7, 7, 4, 'ulcera aftosa; quilose; glossite; mucocele; parotite; calculo salivar; estomatite; aftas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (41, 'ACALASIA, DIVERTCULO, SNDROME DE MALLORY-WEISS, ESOFAGITE, REFLUXO, ULCERAO', 'CNCER DO ESFAGO D77; HRNIA DO HIATO D90; VARIZES ESOFGICAS K99', NULL, NULL, NULL, 7, 7, 4, 'acalasia, diverticulo, sindrome de mallory-weiss, esofagite, refluxo, ulceracao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (140, 'HIPERIDROSE, SUORES NOTURNOS, PROBLEMAS DE TRANSPIRAO', 'DOENA DAS GLNDULAS SUDORPARAS S92', NULL, NULL, NULL, 1, 2, 2, 'hiperidrose, suores noturnos, problemas de transpiracao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (43, 'DERMATITE; DERMATOSE DAS PLPEBRAS; HORDOLO; INFECO; CISTO DE MEIBOMIUS; CISTO TRSICO', 'DACRIOCISTITE F73', NULL, NULL, 'INFLAMAO GENERALIZADA OU LOCALIZADA E/OU PLPEBRAS INCHADAS, INCLUINDO AS GLNDULAS TRSICAS', 7, 3, 5, 'dermatite; dermatose das palpebras; hordeolo; infeccao; cisto de meibomius; cisto tarsico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (44, 'GSTRICA, GASTROJEJUNAL, MARGINAL; EROSES AGUDAS; LCERA PPTICA NE', 'LCERA ESOFGICA D84; LCERA DUODENAL D85', 'AZIA D03; INDIGESTO D07', NULL, 'SINAIS IMAGIOLGICOS CARACTERSTICOS; OU SINAIS ENDOSCPICOS CARACTERSTICOS; OU SINTOMAS EXACERBADOS NUM PACIENTE COM HISTRIA PRVIA DE LCERA', 7, 7, 4, 'gastrica, gastrojejunal, marginal; erosoes agudas; ulcera peptica ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (45, 'DILATAO AGUDA DO ESTMAGO; DUODENITE; GASTRITE (INCL ALCOLICA)', 'GASTRITE OU ENTERITE INFECCIOSA D70,D73', 'DORES ABDOMINAIS D01, D06; DORES EPIGSTRICAS D02; AZIA D03; INDIGESTO/DISPEPSIA D07; GASES INTESTINAIS D08; NUSEA D09; ESOFAGITE D84; VMITOS D10', NULL, 'RESULTADOS DE INVESTIGAO INDICANDO MAU FUNCIONAMENTO DO ESTMAGO', 7, 7, 4, 'dilatacao aguda do estomago; duodenite; gastrite (incl alcoolica)');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (46, 'ABCESSO DO APNDICE, PERFURAO', NULL, 'DORES ABDOMINAIS D01, D06; VMITOS D10', NULL, 'EVIDNCIA OBJETIVA DE APNDICE INFLAMADO, DETECTADO POR INTERVENO CIRRGICA OU EXAME HISTOLGICO', 7, 7, 4, 'abcesso do apendice, perfuracao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (47, NULL, 'HRNIA FEMURAL D91', 'INCHAO DO ABDMEN D24', NULL, 'INCHAO DA REGIO INGUINAL E IMPULSO TRANSMITIDO PELA TOSSE; OU AUMENTO DE VOLUME POR COMPRESSO; OU REDUTVEL AO ABDMEN; OU OBSTRUO INTESTINAL', 7, 7, 4, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (48, 'HRNIA DIAFRAGMTICA', 'ESOFAGITE, REFLUXO D84', 'DORES EPIGSTRICAS D02; AZIA D03; INDIGESTO D07', NULL, 'SINAIS CARACTERSTICOS POR IMAGIOLOGIA, ENDOSCOPIA, ESTUDOS DE PRESSO INTRALUMINAL; OU DURANTE INTERVENO CIRRGICA', 7, 7, 4, 'hernia diafragmatica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (49, 'FEMURAL, INCISIONAL, UMBILICAL, VENTRAL', 'HRNIA DO HIATO D90', 'INCHAO ABDOMINAL D24', NULL, 'IDENTIFICAO POR INTERVENO CIRRGICA; OU INCHAO NA ZONA ESPECIFICADA E IMPULSO TRANSMITIDO PELA TOSSE; OU AUMENTO DE VOLUME POR COMPRESSO, OU REDUTVEL AO ABDMEN, OU OBSTRUO INTESTINAL', 7, 7, 4, 'femural, incisional, umbilical, ventral');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (50, 'DIVERTICULITE; DIVERTICULOSE DO INTESTINO', 'DIVERTCULO DE MECKEL D81; DIVERTCULO ESOFGICO D84', 'DORES ABDOMINAIS D01, D06', NULL, 'SINAIS IMAGIOLGICOS DE DIVERTCULO; DEMONSTRAO DE DIVERTCULO NA CIRURGIA; OU DORES ABDOMINAIS AGUDAS COM FEBRE, E PALPAO DOLOROSA DO CLON DESCENDENTE OU DA SIGMIDE', 7, 7, 4, 'diverticulite; diverticulose do intestino');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (370, 'MEDO DE ATAQUE CARDACO', 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER UMA DOENA CARDACA SEM A TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 7, 'medo de ataque cardiaco');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (51, 'COLITE MUCOSA, COLITE ESPSTICA', 'DOENA INTESTINAL DE ORIGEM INFECCIOSA D70, D73; ENTERITE REGIONAL D94; GASTRENTERITE E COLITE ALRGICAS, DIETTICAS E TXICAS D99; INSUFICINCIA VASCULAR DO INTESTINO D99; DIARRIA PSICOGNICA P75', 'DORES ABDOMINAIS D01, D06; FLATULNCIA D08; DIARRIA D11; PRISO DE VENTRE D12', NULL, 'DORES ABDOMINAIS CONTNUAS OU INTERMITENTES E ALTERAO DO TRNSITO INTESTINAL AO LONGO DE DETERMINADO PERODO DE TEMPO; E GASES INTESTINAIS, OU CLON PALPVEL E SENSVEL, OU HISTRIA CLNICA DE FEZES COM MUCO SEM SANGUE', 7, 7, 4, 'colite mucosa, colite espastica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (52, 'DOENA DE CROHN, ENTERITE REGIONAL, COLITE ULCEROSA', NULL, 'DORES ABDOMINAIS D01, D06; DIARRIA D11; COLITE MUCOSA D93', NULL, 'MANIFESTAES CARACTERSTICAS ENDOSCPICAS, IMAGIOLGICAS OU HISTOLGICAS', 7, 7, 4, 'doenca de crohn, enterite regional, colite ulcerosa');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (53, 'ANEMIA APLSTICA, ANEMIA HEMOLTICA ADQUIRIDA, ANEMIA POR DEFICINCIA DE PROTENAS', 'ANEMIA POR DEFICINCIA DE FERRO B80; ANEMIA POR DEFICINCIA DE VIT. B12/CIDO FLICO B81; ANEMIA DA GRAVIDEZ W84', NULL, NULL, NULL, 7, 7, 3, 'anemia aplastica, anemia hemolitica adquirida, anemia por deficiencia de proteinas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (54, 'PLAQUETAS ANORMAIS, HEMOFILIA, TROMBOCITOPENIA', NULL, NULL, NULL, NULL, 7, 7, 3, 'plaquetas anormais, hemofilia, trombocitopenia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (55, 'AGRANULOCITOSE; EOSINOFILIA; LEUCOCITOSE; LINFOCITOSE; NEUTROPENIA', 'LEUCEMIA B73', NULL, NULL, NULL, 7, 7, 3, 'agranulocitose; eosinofilia; leucocitose; linfocitose; neutropenia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (56, NULL, 'HIPERESPLENISMO B99', NULL, NULL, NULL, 7, 7, 3, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (57, NULL, NULL, NULL, NULL, 'INFECO PELO HIV COMPROVADA POR TESTE SOROLGICO EM UM PACIENTE COM OU SEM SINTOMAS', 7, 7, 3, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (58, 'DOENA AUTO-IMUNE DO SANGUE; DEFEITOS DO COMPLEMENTO; HIPERESPLENISMO; IMUNODEFICINCIA; OUTRA MALFORMAO HEMATOLGICA OU NO ESPECIFICADA; VS ELEVADA; MALFORMAO DOS ERITRCITOS; SARCOIDOSE; POLICITEMIA SECUNDRIA', 'LINFADENITE B70, B71; POLICITEMIA PRIMRIA B75; DOENA DO VRUS DA IMUNODEFICINCIA HUMANA (HIV) B90; LINFOEDEMA K99', NULL, NULL, NULL, 7, 7, 3, 'doenca auto-imune do sangue; defeitos do complemento; hiperesplenismo; imunodeficiencia; outra malformacao hematologica ou nao especificada; vs elevada; malformacao dos eritrocitos; sarcoidose; policitemia secundaria');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (59, 'CLICAS ABDOMINAIS, DESCONFORTO, DOR NE; CLICAS INFANTIS', 'DORES DE ESTMAGO D02, AZIA D03, DORES ABDOMINAIS LOCALIZADAS DO6, INDIGESTO D07, DORES POR GASES D08, CLICAS BILIARES D98, CLICAS RENAIS U14, DISMENORRIA X02', NULL, NULL, NULL, 1, 2, 4, 'colicas abdominais, desconforto, dor ne; colicas infantis');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (60, 'DESCONFORTO EPIGSTRICO, ENFARTAMENTO; DORES DE ESTMAGO', 'DISPEPSIA/INDIGESTO D07; FLATULNCIA, GASES D08', NULL, NULL, NULL, 1, 2, 4, 'desconforto epigastrico, enfartamento; dores de estomago');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (61, 'ACIDEZ, PIROSE', 'DORES EPIGSTRICAS D02; INDIGESTO D07; ESOFAGITE, REFLUXO D84', NULL, NULL, NULL, 1, 2, 4, 'acidez, pirose');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (62, 'ESPASMO ANAL; PROCTALGIA FUGAZ', 'FEZES DURAS D12', NULL, NULL, NULL, 1, 2, 4, 'espasmo anal; proctalgia fugaz');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (63, 'PRURIDO PERIANAL', 'PRURIDO DA VULVA X16', NULL, NULL, NULL, 1, 2, 4, 'prurido perianal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (64, 'DORES DO CLON', 'DORES EPIGSTRICAS D02', NULL, NULL, NULL, 1, 2, 4, 'dores do colon');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (65, NULL, 'DORES EPIGSTRICAS D02, AZIA D03, ERUCTAO D08', NULL, NULL, NULL, 1, 2, 4, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (126, NULL, NULL, NULL, NULL, NULL, 6, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (66, 'ESTMAGO INCHADO; ARROTO; DORES PROVOCADAS POR GASES; DISTENSO GASOSA; GASES', 'INDIGESTO NE D07, ALTERAO DO VOLUME DO ABDMEN D25', NULL, NULL, NULL, 1, 2, 4, 'estomago inchado; arroto; dores provocadas por gases; distensao gasosa; gases');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (67, 'EVACUAO INTESTINAL FREQENTE; FEZES LQUIDAS', 'MELENAS D15, OUTRAS ALTERAES DO TRNSITO INTESTINAL D18', NULL, NULL, NULL, 1, 2, 4, 'evacuacao intestinal frequente; fezes liquidas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (68, 'FEZES DURAS', 'LEO D99', NULL, NULL, NULL, 1, 2, 4, 'fezes duras');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (69, 'ICTRICO', NULL, NULL, NULL, NULL, 1, 2, 4, 'icterico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (70, NULL, 'HEMOPTISE R24', NULL, NULL, NULL, 1, 2, 4, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (71, 'FEZES ESCURAS OU NEGRAS', 'SANGUE FRESCO EXPELIDO PELAS FEZES D16', NULL, NULL, NULL, 1, 2, 4, 'fezes escuras ou negras');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (72, 'SANGUE FRESCO EXPELIDO PELAS FEZES', 'MELENA D15', NULL, NULL, NULL, 1, 2, 4, 'sangue fresco expelido pelas fezes');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (73, 'INCONTINNCIA FECAL', 'ENCOPRESE P13', NULL, NULL, NULL, 1, 2, 4, 'incontinencia fecal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (74, NULL, 'DIARRIA D11, PRISO DE VENTRE D12, INCONTINNCIA D17', NULL, NULL, NULL, 1, 2, 4, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (76, 'MAU HLITO; LNGUA SABURROSA; LBIOS RACHADOS; SALIVAO; BOCA SECA; HALITOSE; LBIOS INCHADOS;INFLAMAO DA BOCA', 'QUILOSE D83; PROBLEMAS NOS DENTES E GENGIVAS D19; ALTERAO DO GOSTO N16; DESIDRATAO T11', NULL, NULL, NULL, 1, 2, 4, 'mau halito; lingua saburrosa; labios rachados; salivacao; boca seca; halitose; labios inchados;inflamacao da boca');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (77, 'SENSAO DE SUFOCAMENTO, DISFAGIA', NULL, NULL, NULL, NULL, 1, 2, 4, 'sensacao de sufocamento, disfagia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (78, NULL, NULL, NULL, NULL, NULL, 1, 2, 4, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (79, 'RELEVO NO ABDMEN', 'ESPLENOMEGALIA B87, HEPATOMEGALIA D23, MASSA RENAL U29', NULL, NULL, NULL, 1, 2, 4, 'relevo no abdomen');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (80, 'ABDMEN INCHADO SEM MASSA', 'ESTMAGO DILATADO, GASES D08; MASSA ABDOMINAL D24; ASCITE D29', NULL, NULL, NULL, 1, 2, 4, 'abdomen inchado sem massa');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (81, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA UM CNCER DO APARELHO DIGESTIVO SEM O TER, OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 4, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (82, 'RECEIO DE DOENA DO APARELHO DIGESTIVO DIFERENTE DE CNCER', 'SE O PACIENTE SOFRE DA DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA UMA DOENA DO APARELHO DIGESTIVO SEM A TER, OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 4, 'receio de doenca do aparelho digestivo diferente de cancer');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (83, NULL, 'COLOSTOMIA, GASTROSTOMIA A89; PERTURBAES PS-OPERATRIAS D99; SNDROME DO ESVAZIAMENTO RPIDO D99', NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA DIGESTIVO', 1, 2, 4, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (84, 'ASCITE, RANGER DE DENTES', NULL, NULL, NULL, NULL, 1, 2, 4, 'ascite, ranger de dentes');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (85, 'INFECO GASTROINTESTINAL OU DISENTERIA COM ORGANISMOS ESPECIFICADOS INCLUINDO CAMPYLOBACTER, GIRDIA, SALMONELA, SHIGELLA, FEBRE TIFIDE, CLERA', 'CONTATOS, PORTADORES DE DOENA INFECCIOSA/PARASITRIA A99; INFECES NO-ESPECFICAS OU PRESUMIDAS D73', 'PRESUMVEL INFECO DE GASTRENTERITE D73', NULL, 'PACIENTE SINTOMTICO COM EVIDNCIA DE BACTRIA PATOGNICA, VRUS OU PROTOZORIOS POR SOROLOGIA OU ISOLAMENTO NAS FEZES OU EM ALIMENTOS INGERIDOS', 7, 3, 4, 'infeccao gastrointestinal ou disenteria com organismos especificados incluindo campylobacter, giardia, salmonela, shigella, febre tifoide, colera');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (371, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER HIPERTENSO SEM A TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 7, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (86, 'MENINGITE DE CAXUMBA, ORQUITE DE CAXUMBA, PANCREATITE DE CAXUMBA', NULL, 'MASSA OU INCHAO LOCALIZADO A08', NULL, 'INFLAMAO AGUDA NO SUPURATIVA, NO-ERITEMATOSA, DIFUSA, DOLOROSA DE UMA OU MAIS GLNDULAS SALIVARES OU INFECO AGUDA DE CAXUMBA DIAGNOSTICADA POR CULTURA OU SOROLOGIA; OU ORQUITE NUMA PESSOA EXPOSTA AO VRUS DA CAXUMBA, APS O PERODO DE INCUBAO', 7, 3, 4, 'meningite de caxumba, orquite de caxumba, pancreatite de caxumba');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (87, 'TODO TIPO DE HEPATITE DE ORIGEM SUPOSTAMENTE VIRAL; HEPATITE CRNICA ATIVA', 'HEPATITE NE D97', 'ICTERCIA D13, HEPATOMEGALIA D96', NULL, 'EVIDNCIA DE INFECO VIRAL HEPTICA COM INFLAMAO, COM OU SEM ICTERCIA; OU EVIDNCIA SOROLGICA DE UMA INFECO COM UM VRUS DA HEPATITE', 7, 3, 4, 'todo tipo de hepatite de origem supostamente viral; hepatite cronica ativa');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (88, 'DIARRIA OU VMITOS PRESUMIVELMENTE INFECCIOSOS; DISENTERIA NE; INTOXICAO ALIMENTAR; GRIPE GSTRICA', 'PERTURBAES DIGESTIVAS FUNCIONAIS D93; ENTERITE E GASTRENTERITE NO-INFECCIOSAS D94, D99', NULL, NULL, NULL, 7, 3, 4, 'diarreia ou vomitos presumivelmente infecciosos; disenteria ne; intoxicacao alimentar; gripe gastrica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (89, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (90, 'TOSSE COM SANGUE', NULL, NULL, NULL, NULL, 1, 2, 11, 'tosse com sangue');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (91, NULL, 'HIPERCERATOSE S80', NULL, NULL, NULL, 1, 2, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (92, NULL, NULL, NULL, NULL, NULL, 7, 6, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (93, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (94, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (95, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (96, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (97, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (98, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (99, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (100, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (101, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (102, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (103, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (104, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (105, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (106, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (107, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (108, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (109, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (110, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (111, NULL, NULL, NULL, NULL, NULL, 2, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (112, NULL, NULL, NULL, NULL, NULL, 3, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (113, NULL, 'CATETERIZAO -53', NULL, NULL, NULL, 3, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (114, NULL, NULL, NULL, NULL, NULL, 3, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (115, NULL, NULL, NULL, NULL, NULL, 3, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (116, NULL, NULL, NULL, NULL, NULL, 3, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (117, NULL, NULL, NULL, NULL, NULL, 3, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (118, NULL, NULL, NULL, NULL, NULL, 3, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (119, NULL, NULL, NULL, NULL, NULL, 3, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (120, NULL, NULL, NULL, NULL, NULL, 3, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (121, NULL, NULL, NULL, NULL, NULL, 3, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (122, NULL, NULL, NULL, NULL, NULL, 4, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (123, NULL, NULL, NULL, NULL, NULL, 4, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (124, NULL, NULL, NULL, NULL, NULL, 5, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (127, NULL, NULL, NULL, NULL, NULL, 6, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (128, NULL, 'MDICO -67', NULL, NULL, NULL, 6, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (129, NULL, NULL, NULL, NULL, NULL, 6, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (130, NULL, NULL, NULL, NULL, NULL, 6, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (131, NULL, NULL, NULL, NULL, NULL, 6, 1, 1, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (132, 'DOR CRNICA GENERALIZADA, DORES MLTIPLAS', 'DOR NO-ESPECFICA A29', NULL, NULL, NULL, 1, 2, 2, 'dor cronica generalizada, dores multiplas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (133, 'CALAFRIOS, TREMORES', 'FEBRE A03', NULL, NULL, NULL, 1, 2, 2, 'calafrios, tremores');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (134, 'PIREXIA', 'COM EXANTEMAS A76, EXAUSTO PELO CALOR OU GOLPE DE CALOR A88', NULL, NULL, NULL, 1, 2, 2, 'pirexia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (135, 'DE FADIGA CRNICA, EXAUSTO, FADIGA, LASSIDO, LETARGIA, FADIGA PS-VIRAL', 'SENTIR-SE PACIENTE, M-DISPOSIO A05; MODORRA A29; EXAUSTO PELO CALOR A88; CANSAO POR DESFASAMENTO DE HORRIO (JETLAG) A88; SONOLNCIA P06', NULL, NULL, NULL, 1, 2, 2, 'de fadiga cronica, exaustao, fadiga, lassidao, letargia, fadiga pos-viral');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (136, 'MAL-ESTAR', 'SENESCNCIA, SENILIDADE P05, CAQUEXIA T08, MAL-NUTRIO T91', NULL, NULL, NULL, 1, 2, 2, 'mal-estar');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (137, 'PERDA MOMENTNEA DA CONSCINCIA, COLAPSO, CRISE VASOVAGAL', 'COMA A07; SENTIR-SE TONTO/TONTURAS N17', NULL, NULL, NULL, 1, 2, 2, 'perda momentanea da consciencia, colapso, crise vasovagal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (138, 'LETARGIA', 'SNCOPE A06', NULL, NULL, NULL, 1, 2, 2, 'letargia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (139, 'ALTO, MASSA NE', 'GNGLIO LINFTICO B02, EDEMA KO7,ARTICULAO L20, MAMA X19', NULL, NULL, NULL, 1, 2, 2, 'alto, massa ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (141, NULL, NULL, NULL, NULL, NULL, 1, 2, 2, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (143, 'RECEIO DAS CONSEQNCIAS DA MEDICAO OU DE QUALQUER TIPO DE TRATAMENTO', 'EFEITOS ADVERSOS DA MEDICAO A85, COMPLICAES DO TRATAMENTO MDICO OU CIRRGICO A87', NULL, NULL, NULL, 1, 2, 2, 'receio das consequencias da medicacao ou de qualquer tipo de tratamento');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (144, 'CHORO EXCESSIVO, BEB AGITADO', 'CLICAS INFANTIS D01; CRIANA OU ADULTO AGITADOS/IRRITVEIS P04', NULL, NULL, NULL, 1, 2, 2, 'choro excessivo, bebe agitado');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (145, 'PREOCUPAO COM A APARNCIA FSICA', 'PREOCUPAO COM O ASPECTO DAS ORELHAS H15, COM A APARNCIA RELACIONADA COM A GRAVIDEZ W21, MAMA X22', NULL, NULL, NULL, 1, 2, 2, 'preocupacao com a aparencia fisica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (146, NULL, NULL, NULL, NULL, NULL, 1, 2, 2, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (147, 'HISTRIA PESSOAL OU FAMILIAR, TRATAMENTO ANTERIOR, OU OUTROS FATORES DE RISCO DE MALIGNIDADE', NULL, NULL, NULL, NULL, 1, 2, 2, 'historia pessoal ou familiar, tratamento anterior, ou outros fatores de risco de malignidade');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (148, 'CONTATO COM DOENA INFECCIOSA, HISTRIA PESSOAL OU FAMILIAR, EPISDIO ANTERIOR, OU OUTROS FATORES DE RISCO DE OUTRAS DOENAS', 'FATOR DE RISCO DE MALIGNIDADE A21, DE DOENA CARDIOVASCULAR K22', NULL, NULL, NULL, 1, 2, 2, 'contato com doenca infecciosa, historia pessoal ou familiar, episodio anterior, ou outros fatores de risco de outras doencas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (149, NULL, NULL, NULL, NULL, NULL, 1, 2, 2, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (150, NULL, 'SE O PACIENTE TEM CNCER, CODIFIQUE A DOENA', NULL, NULL, 'RECEIO DE UM PACIENTE TER CNCER SEM O TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 2, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (151, NULL, 'SE O PACIENTE TIVER UMA DOENA, CODIFIQUE-A', NULL, NULL, 'RECEIO DE UM PACIENTE TER OUTRA DOENA SEM A TER, OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 2, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (152, 'RESTRIO DE UMA FUNO OU INCAPACIDADE QUE NO EST RELACIONADA COM NENHUMA DOENA INSERIDA EM QUALQUER OUTRO CAPTULO', 'QUEDAS A29', NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8 DO MANUAL).', 'LIMITAO FUNCIONAL/ INCAPACIDADE NO RELACIONADA A ALGUM PROBLEMA DE OUTRO CAPITULO', 1, 2, 2, 'restricao de uma funcao ou incapacidade que nao esta relacionada com nenhuma doenca inserida em qualquer outro capitulo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (154, 'TODO O TIPO DE INFECES DE TUBERCULOSE EM QUALQUER PARTE DO CORPO, EFEITOS TARDIOS.', NULL, 'FEBRE A03, TOSSE R05', NULL, 'CONVERSO PARA UM TESTE POSITIVO DE TUBERCULINA; OU DEMONSTRAO DE MYCOBACTERIUM TUBERCULOSIS POR MICROSCOPIA OU CULTURA; OU MANIFESTAO CARACTERSTICA NA RADIOGRAFIA DO TRAX; OU MANIFESTAO HISTOLGICA CARACTERSTICA POR BIPSIA', 7, 3, 2, 'todo o tipo de infeccoes de tuberculose em qualquer parte do corpo, efeitos tardios.');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (155, 'EMESE, HIPEREMESE, ESFORO DE VMITO', 'HEMATEMESE D14; DURANTE A GRAVIDEZ WO6', NULL, 'CODIFICAR DIARRIA E VMITOS NO MODO PROBLEMAS, COMO D11', NULL, 1, 2, 4, 'emese, hiperemese, esforco de vomito');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (156, NULL, 'CONDIES CONGNITAS A90; ATRASO DE CRESCIMENTO T10', NULL, NULL, 'MORBIDADE AT 4 SEMANAS APS O PARTO', 7, 7, 2, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (157, NULL, NULL, NULL, NULL, 'MORTE AT 4 SEMANAS APS O PARTO', 7, 7, 2, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (158, NULL, 'PERINATAL A95', NULL, NULL, NULL, 7, 7, 2, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (159, 'COMPLICAES DE SARAMPO', NULL, 'FEBRE A03, DOENA VIRAL COM EXANTEMA A76, ERUPO CUTNEA S07', NULL, 'PRDROMO COM INJEO DAS CONJUNTIVAS, FEBRE E TOSSE; MANCHAS BRANCAS EM BASE VERMELHA NAS MEMBRANAS DA MUCOSA JUGAL (MANCHAS DE KOPLIK), OU ERUPO MACULOPAPULAR CONFLUENTE NA FACE E CORPO, OU EXANTEMA ATPICO NUM INDIVDUO PARCIALMENTE IMUNE DURANTE UM S', 7, 3, 2, 'complicacoes de sarampo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (160, 'COMPLICAES DE VARICELA', 'HERPES ZOSTER S70', 'FEBRE A03, DOENA VIRAL COM EXANTEMA A76, ERUPO CUTNEA S07', NULL, ': EXANTEMA VESICULAR, EM QUE AS LESES EVOLUEM RAPIDAMENTE DE PPULAS SUPERFICIAIS A VESCULAS E, EVENTUALMENTE, A CROSTAS', 7, 3, 2, 'complicacoes de varicela');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (161, 'COMPLICAES DE MALRIA', 'PROFILAXIA DA MALRIA A44', 'FEBRE A03', NULL, 'FEBRE INTERMITENTE COM CALAFRIOS E SUORES FRIOS NUM HABITANTE OU VISITANTE RECENTE DE UMA REGIO COM MALRIA; OU DEMONSTRAO DE FORMAS DO PARASITA DA MALRIA NO SANGUE PERIFRICO', 7, 3, 2, 'complicacoes de malaria');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (162, 'COMPLICAES DA RUBOLA, RUBOLA CONGNITA', 'ROSOLA INFANTIL A76', 'FEBRE A03, DOENA VIRAL COM EXANTEMA A76, ERUPO CUTNEA S07', NULL, 'EXANTEMA AGUDO COM NDULOS LINFTICOS DILATADOS, NORMALMENTE SUBOCCIPITAL E RETROAURICULAR, ERUPO CUTNEA PRIMEIRO NA FACE, DEPOIS NO TRONCO E REGIO PROXIMAL DOS MEMBROS; OU EVIDNCIA SEROLGICA DE INFECO DE RUBOLA', 7, 3, 2, 'complicacoes da rubeola, rubeola congenita');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (163, 'FEBRE GLANDULAR', NULL, 'FEBRE A03; NDULOS LINFTICOS AUMENTADOS B02; INFECO AGUDA DO TRATO RESPIRATRIO SUPERIOR R74', NULL, 'INFLAMAO DAS AMGDALAS OU DA FARINGE COM LINFADENOPATIA NO CONFINADA AOS NDULOS CERVICAIS ANTERIORES, E LINFCITOS ATPICOS NO ESFREGAO DE SANGUE OU ESPLENOMEGALIA; OU TITULO AUMENTADO DE ANTICORPOS HETERFILOS ANORMAIS OU PESQUISA POSITIVA DE VRUS', 7, 3, 2, 'febre glandular');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (164, 'FEBRE COM ERUPO CUTNEA, QUINTA DOENA, ROSOLA INFANTIL', 'DOENAS ESPECIFICADAS EM A71, A72, A74, A75', NULL, NULL, NULL, 7, 3, 2, 'febre com erupcao cutanea, quinta doenca, roseola infantil');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (247, 'CONVULSES FEBRIS, ATAQUES', 'DESMAIOS A06, ACIDENTE ISQUMICO TEMPORRIO K89', NULL, NULL, NULL, 1, 2, 9, 'convulsoes febris, ataques');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (165, 'ADENOVRUS; VACINA; DOENAS POR COXSACKIE; DENGUE; DOENA DAS MOS, PS E BOCA; FEBRE DE ROSS RIVER', 'EXANTEMAS VIRAIS A76, GRIPE R80', NULL, NULL, NULL, 7, 3, 2, 'adenovirus; vacina; doencas por coxsackie; dengue; doenca das maos, pes e boca; febre de ross river');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (166, 'BRUCELOSE; INFECES COM LOCALIZAO NO ESPECIFICADA; DOENA DE LYME; INFECES MENINGOCCICAS; MYCOPLASMA; FEBRE Q; RIQUETSIOSE; ESCARLATINA; DOENA SEXUALMENTE TRANSMISSVEL NE; AFTAS NE; TOXOPLASMOSE', 'MENINGITE MENINGOCCICA N71', NULL, NULL, NULL, 7, 3, 2, 'brucelose; infeccoes com localizacao nao especificada; doenca de lyme; infeccoes meningococicas; mycoplasma; febre q; riquetsiose; escarlatina; doenca sexualmente transmissivel ne; aftas ne; toxoplasmose');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (167, 'NEOPLASIAS SECUNDRIAS E METASTTICAS COM LOCALIZAO PRIMRIA DESCONHECIDA', NULL, 'OUTRA DOENA GENERALIZADA A99', NULL, ': EVIDNCIA HISTOLGICA DE MALIGNIDADE', 7, 4, 2, 'neoplasias secundarias e metastaticas com localizacao primaria desconhecida');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (168, 'ACIDENTE DE TRNSITO', 'LESO TRAUMTICA MLTIPLA A81, EFEITOS TARDIOS DE LESO TRAUMTICA A82', NULL, NULL, NULL, 7, 5, 2, 'acidente de transito');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (169, 'LESES INTERNAS NE', NULL, NULL, 'NESTA CLASSIFICAO, OS TERMOS GERAL E MLTIPLO REFEREM-SE A TRS OU MAIS LOCALIZAES CORPORAIS OU SISTEMAS. AS CONDIES QUE AFETAM UMA OU DUAS ZONAS DEVERO SER CODIFICADAS NESTAS.', NULL, 7, 5, 2, 'lesoes internas ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (170, 'SEQELAS, CICATRIZES RESULTANTE DE FERIMENTOS ANTERIORES; AMPUTAO ANTERIOR', 'EFEITOS RELACIONADOS COM SISTEMAS CORPORAIS ESPECFICOS (CODIFICAR NO CAPTULO DOS SISTEMAS); EFEITOS PSICOLGICOS P02; REAO AGUDA AO STRESS P02; PERTURBAO DE ESTRESSE PS-TRAUMTICO P82; FERIDA INFECTADA S11; CICATRIZ S99', NULL, NULL, NULL, 7, 5, 2, 'sequelas, cicatrizes resultante de ferimentos anteriores; amputacao anterior');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (171, 'OVERDOSE', 'ABUSO DE MEDICAO P18; TENTATIVA DE SUICDIO P77; COMA INSULNICO T87', NULL, NULL, 'TOXICIDADE OU INCAPACIDADE PROVOCADA POR OVERDOSE ACIDENTAL OU DELIBERADA DE UM AGENTE COM PROPRIEDADES MEDICINAIS QUANDO TOMADO NA DOSE HABITUAL', 7, 5, 2, 'overdose');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (172, 'EFEITOS SECUNDRIOS, ALERGIA E ANAFILAXIA DEVIDOS A MEDICAO EM DOSE CORRETA', 'OVERDOSE OU ENVENENAMENTO A84; REAO  IMUNIZAO E TRANSFUSO A87; PARKINSONISMO N87; DEPENDNCIA OU HABITUAO P18; DERMATITE DE CONTATO S88; COMA INSULNICO T87', NULL, ' POSSVEL AINDA CODIFICAR A NATUREZA DOS EFEITOS SECUNDRIOS', 'SINAIS E SINTOMAS ATRIBUDOS  INGESTO ADEQUADA DE MEDICAMENTOS, E NO A UMA DOENA OU FERIMENTO', 7, 5, 2, 'efeitos secundarios, alergia e anafilaxia devidos a medicacao em dose correta');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (173, 'MONXIDO DE CARBONO; EFEITOS GERAIS OU LOCAIS; MATERIAIS INDUSTRIAIS; CHUMBO; ANIMAIS, INSETOS, PLANTAS, SERPENTES VENENOSAS', 'DEVIDO  AGENTES MEDICINAIS A84, A85, OU AO LCOOL, TABACO, DROGAS P16 A P19; EFEITOS TXICOS RESPIRATRIOS R99; QUEIMADURAS QUMICAS - INTERNAS OU EXTERNAS S14; MORDEDURAS NO-TXICAS S12, S13; DERMATITE DE CONTATO S88', NULL, NULL, NULL, 7, 5, 2, 'monoxido de carbono; efeitos gerais ou locais; materiais industriais; chumbo; animais, insetos, plantas, serpentes venenosas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (174, 'CHOQUE ANESTSICO; REAES A IMUNIZAO E TRANSFUSO; RUPTURA, INFECO, HEMORRAGIA DE FERIDA OPERATRIA; PROBLEMAS RESULTANTES DE RADIAO DIAGNSTICA OU TERAPUTICA', 'PERTURBAES INESPERADAS RESULTANTES DA CIRURGIA, TRATAMENTO COM MEDICAMENTOS, RADIOTERAPIA OU QUALQUER OUTRA FORMA DE TERAPUTICA', NULL, NULL, 'PERTURBAES INESPERADAS RESULTANTES DA CIRURGIA, TRATAMENTO COM MEDICAMENTOS, RADIOTERAPIA OU QUALQUER OUTRA FORMA DE TERAPUTICA', 7, 5, 2, 'choque anestesico; reacoes a imunizacao e transfusao; ruptura, infeccao, hemorragia de ferida operatoria; problemas resultantes de radiacao diagnostica ou terapeutica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (1, 'FRIO; CALAFRIOS; AFOGAMENTO; CALOR; JETLAG (CANSAO E DISTRBIOS CAUSADOS PELA DIFERENA DE FUSO HORRIO); TROVOADA; MOVIMENTO; PRESSO; RADIAO', 'EFEITOS DE RADIAO MDICA A87; CEGUEIRA DA NEVE F79; EFEITOS DO LCOOL P16; EFEITOS DO TABACO P17; QUEIMADURAS DE RADIAO S14; QUEIMADURA SOLAR S88', NULL, NULL, NULL, 7, 5, 2, 'frio; calafrios; afogamento; calor; jetlag (cansaco e disturbios causados pela diferenca de fuso horario); trovoada; movimento; pressao; radiacao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (2, 'INCAPACIDADE, DESCONFORTO, DEFICINCIA, DOR OU LIMITAO DA FUNO RESULTANTE DA UTILIZAO DE UMA PRTESE CORRETORA DE UMA DEFICINCIA; CATETER; PRTESE DENTRIA; VLVULA CARDACA; PRTESE ARTICULAR; TRANSPLANTE DE RGO; MARCAPASSO', 'EFEITO DA DENTADURA/ DENTES FALSOS D19', NULL, NULL, NULL, 7, 5, 2, 'incapacidade, desconforto, deficiencia, dor ou limitacao da funcao resultante da utilizacao de uma protese corretora de uma deficiencia; cateter; protese dentaria; valvula cardiaca; protese articular; transplante de orgao; marcapasso');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (3, 'SNDROME DE DOWN; SNDROME DE MARFAN; OUTRAS MALFORMAES CROMOSSMICAS', 'MALFORMAES RELACIONADAS COM SISTEMAS CORPORAIS ESPECFICOS (CODIFICAR NO CAPTULO DOS SISTEMAS)', NULL, NULL, NULL, 7, 6, 2, 'sindrome de down; sindrome de marfan; outras malformacoes cromossomicas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (4, 'TESTE OU IMAGIOLOGIA ANORMAL E INEXPLICVEL; PERTURBAO ELETROLTICA', 'CLULAS BRANCAS ANORMAIS B84; ANOMALIA HEMATOLGICA B99; TESTE DE URINA ANORMAL U98; ESFREGAO DE PAP ANORMAL X86', NULL, NULL, 'RESULTADOS ANORMAIS QUE NO PODEM SER ATRIBUDOS A DOENA CONHECIDA', 7, 7, 2, 'teste ou imagiologia anormal e inexplicavel; perturbacao eletrolitica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (5, 'TODAS AS REAES ALRGICAS NO ESPECIFICADAS EM QUALQUER OUTRA PARTE, EDEMA ALRGICO, CHOQUE ANAFILTICO, EDEMA ANGIONEURTICO', 'URTICRIA S98, CONSEQNCIA DE MEDICAO A85, RINITE ALRGICA R97', NULL, NULL, NULL, 7, 7, 2, 'todas as reacoes alergicas nao especificadas em qualquer outra parte, edema alergico, choque anafilatico, edema angioneurotico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (6, NULL, NULL, NULL, NULL, 'NASCIDO-VIVO COM MENOS DE 36 SEMANAS DE GESTAO', 7, 7, 2, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (7, NULL, 'SENSAO DE TER COMIDO DEMAIS D02; VMITOS D10; M DISPOSIO PROVOCADA PELO LCOOL P16;  PERDA DE APETITE T03; GRAVIDEZ WO6', NULL, 'CODIFICAR NUSEAS E VMITOS NO MODO PROBLEMAS, COMO D10', NULL, 1, 2, 4, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (342, 'MEDO DE SURDEZ', 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER UMA DOENA AUDITIVA OU SURDEZ SEM A TER, OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 6, 'medo de surdez');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (343, 'SURDEZ DE UM OUVIDO, SURDEZ TEMPORRIA', 'SURDEZ H84-86; TONTURAS, VERTIGENS N17', NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA AUDITIVO/ DOS OUVIDOS', 1, 2, 6, 'surdez de um ouvido, surdez temporaria');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (344, 'OUVIDOS ESTALANDO; COCEIRA NOS OUVIDOS', 'TONTURAS OU VERTIGENS N17, PERDA DE EQUILBRIO N17', NULL, NULL, NULL, 1, 2, 6, 'ouvidos estalando; coceira nos ouvidos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (345, 'ECZEMA EXTERNO DO MEATO AUDITIVO; FURNCULO OU ABCESSO DO MEATO AUDITIVO EXTERNO; OUVIDO DE NADADOR', NULL, NULL, NULL, 'INFLAMAO OU DESCAMAO DO CANAL AUDITIVO EXTERNO', 7, 3, 6, 'eczema externo do meato auditivo; furunculo ou abcesso do meato auditivo externo; ouvido de nadador');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (346, 'OTITE MDIA SUPURATIVA AGUDA, OTITE MDIA NE, TIMPANITE', 'OTITE SEROSA MDIA H72, OTITE MDIA CRNICA H74', 'DORES DE OUVIDOS H01, SECREO DOS OUVIDOS H04', NULL, 'PERFURAO RECENTE DA MEMBRANA DO TMPANO, PROVOCANDO UMA SECREO DE PUS; TMPANO INFLAMADO E ABAULADO; OU UM TMPANO MAIS CONGESTIONADO DO QUE O OUTRO; TMPANO CONGESTIONADO, PROVOCANDO DORES DE OUVIDOS; OU BOLHA NO TMPANO', 7, 3, 6, 'otite media supurativa aguda, otite media ne, timpanite');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (347, 'OUVIDO DE COLA; OTITE MDIA COM EFUSO (OME)', 'OTITE MDIA AGUDA H71, OTITE MDIA CRNICA H74', 'SENSAO DE OUVIDO OBSTRUDO H13, SALPINGITE EUSTAQUIANA OU BLOQUEIO H73', NULL, 'LQUIDO ACUMULADO POR TRS DO TMPANO, SEM INFLAMAO; OU MACICEZ DO TMPANO COM RETRAO OU ABAULAMENTO; MACICEZ DO TMPANO COM CONSEQENTE DIMINUIO DA CAPACIDADE AUDITIVA', 7, 3, 6, 'ouvido de cola; otite media com efusao (ome)');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (348, 'BLOQUEIO EUSTAQUIANO/CATARRO/DISFUNO/SALPINGITE', 'OTITE SEROSA MDIA H72', 'SENSAO DE OUVIDO OBSTRUDO H13', NULL, NULL, 7, 3, 6, 'bloqueio eustaquiano/catarro/disfuncao/salpingite');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (349, 'COLESTEATOMA, OTITE MDIA SUPURATIVA CRNICA, MASTOIDITE', 'OTITE MDIA COM EFUSO H72', NULL, NULL, NULL, 7, 3, 6, 'colesteatoma, otite media supurativa cronica, mastoidite');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (350, 'BENIGNA E MALIGNA; PLIPO', 'NEUROMA ACSTICO N75', NULL, NULL, NULL, 7, 4, 6, 'benigna e maligna; polipo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (351, NULL, NULL, NULL, NULL, NULL, 7, 5, 6, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (352, NULL, 'COM INFECO H71, H74; ROTURA TRAUMTICA OU POR PRESSO DO TMPANO H79', NULL, NULL, NULL, 7, 5, 6, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (353, 'MEATO EXTERNO, PAVILHO AURICULAR', 'DO TMPANO H79', NULL, NULL, NULL, 7, 5, 6, 'meato externo, pavilhao auricular');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (354, 'ROTURA TRAUMTICA OU POR PRESSO DO TMPANO', NULL, NULL, NULL, NULL, 7, 5, 6, 'rotura traumatica ou por pressao do timpano');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (355, 'ORELHA ACESSRIA, ORELHAS DE ABANO', 'SURDEZ CONGNITA H86', NULL, NULL, NULL, 7, 6, 6, 'orelha acessoria, orelhas de abano');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (356, NULL, NULL, NULL, NULL, 'SINAIS/SINTOMAS DEVIDOS A CERA NO CANAL AUDITIVO', 7, 7, 6, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (357, 'VERTIGEM PAROXSTICA E POSICIONAL BENIGNA; LABIRINTITE; DOENA DE MENIRE; NEURONITE VESTIBULAR', NULL, 'VERTIGENS, TONTURAS N17', NULL, 'VERTIGEM GIRATRIA VERDADEIRA', 7, 7, 6, 'vertigem paroxistica e posicional benigna; labirintite; doenca de meniere; neuronite vestibular');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (358, NULL, NULL, NULL, NULL, NULL, 7, 7, 6, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (359, NULL, 'SURDEZ NO ESPECIFICADA H86', 'DIMINUIO DA CAPACIDADE AUDITIVA H28', NULL, 'DESENVOLVIMENTO PROGRESSIVO DE SURDEZ SIMTRICA BILATERAL COM O ENVELHECIMENTO, PRINCIPALMENTE NA PERCEPO DE SONS DE ALTA FREQNCIA', 7, 7, 6, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (360, 'SURDEZ POR RUDO', 'TMPANO PERFURADO H77', 'SURDEZ NO ESPECIFICADA H86', NULL, 'SURDEZ PARA SONS DE ALTA FREQNCIA, COM HISTRIA DE EXPOSIO A RUDO ELEVADO', 7, 7, 6, 'surdez por ruido');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (361, 'PLIPO NO OUVIDO MDIO, ESTENOSE, CANAL AUDITIVO EXTERNO ESTREITADO', 'MASTOIDITE H74', NULL, NULL, NULL, 7, 7, 6, 'polipo no ouvido medio, estenose, canal auditivo externo estreitado');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (362, 'DORES ATRIBUDAS PELO PACIENTE AO CORAO', 'DORES TORCICAS NE A11; MEDO DE ATAQUE CARDACO K24; ANGINA DE PEITO K74; SENSAO DE APERTO TORCICO R29', NULL, NULL, NULL, 1, 2, 7, 'dores atribuidas pelo paciente ao coracao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (363, 'SENSAO DE PESO NO CORAO, SEGUNDO A DESCRIO DO PACIENTE', 'DORES TORCICAS NE A11; MEDO DE ATAQUE CARDACO K24; ANGINA DE PEITO K74; FALTA DE AR, DISPNIA R02', NULL, NULL, NULL, 1, 2, 7, 'sensacao de peso no coracao, segundo a descricao do paciente');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (364, NULL, 'DORES ATRIBUDAS AO CORAO K01; CLAUDICAO K92, ENXAQUECAS N89', NULL, NULL, NULL, 1, 2, 7, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (365, 'TAQUICARDIA', 'TAQUICARDIA PAROXSTICA K79', NULL, NULL, NULL, 1, 2, 7, 'taquicardia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (366, NULL, 'PALPITAES K04', NULL, NULL, NULL, 1, 2, 7, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (367, 'QUAISQUER VEIAS HABITUALMENTE DILATADAS, ARANHAS VASCULARES', 'VEIAS VARICOSAS K95, HEMANGIOMA S81', NULL, NULL, NULL, 1, 2, 7, 'quaisquer veias habitualmente dilatadas, aranhas vasculares');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (368, 'HIDROPSIA, RETENO DE LQUIDOS, PS E PERNAS INCHADAS', 'SINTOMAS NOS TORNOZELOS L16, INCHAO LOCALIZADO S04', NULL, NULL, NULL, 1, 2, 7, 'hidropsia, retencao de liquidos, pes e pernas inchadas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (369, 'HISTRIA PESSOAL OU FAMILIAR, EPISDIO ANTERIOR, OU OUTRO FATOR DE RISCO DE DOENA CARDIOVASCULAR', NULL, NULL, NULL, NULL, 1, 2, 7, 'historia pessoal ou familiar, episodio anterior, ou outro fator de risco de doenca cardiovascular');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (372, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER OUTRA DOENA DO SISTEMA CIRCULATRIO SEM A TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 7, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (373, NULL, 'MEDO DE DOENAS K25, K26, K27', NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'IDENTIFICAO DE UMA INCAPACIDADE QUE PODE SER ATRIBUDA A UM SINTOMA E/OU DOENA DO APARELHO CIRCULATRIO', 1, 2, 7, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (374, 'PROBLEMAS CARDACOS, PRESSO BAIXA, FRAQUEZA NO CORAO', 'LQUIDO NO PEITO R93; CIANOSE S08', NULL, NULL, NULL, 1, 2, 7, 'problemas cardiacos, pressao baixa, fraqueza no coracao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (375, 'ENDOCARDITE AGUDA E SUBAGUDA; ENDOCARDITE BACTERIANA; MIOCARDITE; PERICARDITE (EXCETO A REUMTICA)', 'DOENA CARDACA REUMTICA K71; FLEBITE E TROMBOFLEBITE K94; ARTERITE K99', NULL, NULL, NULL, 7, 3, 7, 'endocardite aguda e subaguda; endocardite bacteriana; miocardite; pericardite (exceto a reumatica)');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (376, 'CORIA, ESTENOSE MITRAL', NULL, 'DOENA VALVULAR CARDACA K83, OUTRA DOENA CARDACA K84', NULL, 'PARA A FEBRE REUMTICA AGUDA - DUAS MANIFESTAES GRAVES, OU UMA GRAVE E DUAS MENORES, E AINDA EVIDNCIA DE INFECO ESTREPTOCCICA ANTERIOR; MANIFESTAES GRAVES: POLIARTRITE MIGRATRIA; CARDITE; CORIA; ERITEMA MARGINADO; APARECIMENTO RECENTE DE NDULOS', 7, 3, 7, 'coreia, estenose mitral');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (377, 'BENIGNA E MALIGNA', 'HEMANGIOMA S81', NULL, 'CODIFICAR NEOPLASIAS SECUNDRIAS E METASTTICAS EM LOCALIZAO PRIMRIA', NULL, 7, 4, 7, 'benigna e maligna');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (378, 'MALFORMAO SEPTO-AURICULAR OU VENTRICULAR; TETRALOGIA DE FALLOT; CANAL ARTERIAL PERSISTENTE', 'HEMANGIOMA S81', NULL, NULL, NULL, 7, 6, 7, 'malformacao septo-auricular ou ventricular; tetralogia de fallot; canal arterial persistente');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (379, 'ANGINA PROVOCADA PELO ESFORO, ANGINA DE PEITO, ANGINA COM ESPASMOS; DOR TORCICA ISQUMICA; ANGINA INSTVEL', 'DOENA CARDACA ISQUMICA SEM ANGINA K76', 'DOR ATRIBUDA AO CORAO KO1', NULL, 'HISTRIA E SINAIS ELETROCARDIOGRFICOS OU IMAGIOLGICOS DE ANTIGOS ENFARTES DO MIOCRDIO; OU SINAIS DE ISQUEMIA DO MIOCRDIO NO ECG EM REPOUSO OU DE ESFORO; OU DETECO POR INVESTIGAO DE ESTENOSE DA ARTRIA CORONRIA OU ANEURISMA VENTRICULAR', 7, 7, 7, 'angina provocada pelo esforco, angina de peito, angina com espasmos; dor toracica isquemica; angina instavel');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (319, NULL, 'ESCORIAO DA CRNEA F79', NULL, NULL, NULL, 7, 5, 5, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (380, 'ENFARTE DO MIOCRDIO ESPECIFICADO COMO TENDO SIDO AGUDO, OU 4 SEMANAS (28 DIAS) APS O COMEO', 'ENFARTE DO MIOCRDIO ANTIGO OU TRATADO K74,K76', 'DOR ATRIBUDA AO CORAO KO1, ANGINA DE PEITO K74, DOENA CARDACA ISQUMICA CRNICA K76', 'POSSVEL CDIGO DUPLO K74 OU K76', 'DORES TORCICAS CARACTERSTICAS DE ISQUEMIA MIOCRDICA, COM DURAO SUPERIOR A 15 MINUTOS, E/OU ALTERAES ANORMAIS DO ST-T OU ONDAS Q NOVAS NO ELETROCARDIOGRAMA OU AUMENTO DAS ENZIMAS CARDACAS NO SANGUE', 7, 7, 7, 'enfarte do miocardio especificado como tendo sido agudo, ou 4 semanas (28 dias) apos o comeco');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (381, 'ANEURISMA CARDACO, DOENA CARDACA ARTERIOSCLERTICA OU ATEROSCLERTICA, DOENA CORONRIA, CARDIOMIOPATIA ISQUMICA, ENFARTE DO MIOCRDIO ANTIGO, ISQUEMIA MIOCRDICA SILENCIOSA', 'DOENA CARDACA ISQUMICA COM ANGINA K74', NULL, NULL, 'HISTRIA MAIS ECG, OU MANIFESTAES IMAGIOLGICAS DE UM ENFARTE DO MIOCRDIO ANTIGO; OU EVIDNCIA NO ECG EM REPOUSO OU DE ESFORO DE ISQUEMIA DO MIOCRDIO; OU EVIDNCIA, POR INVESTIGAO, DE ESTENOSE DA ARTRIA CORONRIA; OU ANEURISMA VENTRICULAR', 7, 7, 7, 'aneurisma cardiaco, doenca cardiaca arteriosclerotica ou aterosclerotica, doenca coronaria, cardiomiopatia isquemica, enfarte do miocardio antigo, isquemia miocardica silenciosa');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (382, 'ASMA CARDACA, INSUFICINCIA CARDACA CONGESTIVA, INSUFICINCIA CARDACA NE, INSUFICINCIA DO VENTRCULO ESQUERDO, EDEMA PULMONAR, INSUFICINCIA DO VENTRCULO DIREITO', 'COR PULMONALE K82', NULL, NULL, 'SINAIS MLTIPLOS, INCLUINDO EDEMA DEPENDENTE, PRESSO VENOSA JUGULAR AUMENTADA, HEPATOMEGALIA SEM A PRESENA DE DOENA HEPTICA, CONGESTO PULMONAR, DERRAME PLEURAL, CORAO AUMENTADO DE TAMANHO', 7, 7, 7, 'asma cardiaca, insuficiencia cardiaca congestiva, insuficiencia cardiaca ne, insuficiencia do ventriculo esquerdo, edema pulmonar, insuficiencia do ventriculo direito');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (250, 'TONTURAS, SENSAO DE DESMAIO, SENSAO DE CABEA LEVE, PERDA DE EQUILBRIO, ESTADO DE APARENTE EMBRIAGUEZ', 'SNCOPE A06; PERDA TEMPORRIA DE CONSCINCIA A06; ENJO DEVIDO AO MOVIMENTO A88; SNDROMES VERTIGINOSAS ESPECFICAS H82', NULL, NULL, NULL, 1, 2, 9, 'tonturas, sensacao de desmaio, sensacao de cabeca leve, perda de equilibrio, estado de aparente embriaguez');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (251, 'PARESIA', 'FRAQUEZA GERAL A04', NULL, NULL, NULL, 1, 2, 9, 'paresia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (252, 'AFASIA, DISFASIA, DISARTRIA, FALA ENROLADA', 'TARTAMUDEZ, GAGUEIRA P10; ATRASO DA FALA P22; ROUQUIDO R23', NULL, NULL, NULL, 1, 2, 9, 'afasia, disfasia, disartria, fala enrolada');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (253, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER UM CNCER SEM O TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 9, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (254, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'RECEIO DE UM PACIENTE TER OUTRA DOENA NEUROLGICA SEM A TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 9, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (547, NULL, 'EFEITOS TXICOS A86; INFECO DA MORDEDURA S11', NULL, NULL, NULL, 1, 5, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (255, 'INCAPACIDADE DEVIDO A DOENAS E PERTURBAES NEUROLGICAS', NULL, NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA NEUROLGICO', 1, 2, 9, 'incapacidade devido a doencas e perturbacoes neurologicas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (256, 'MARCHA ANORMAL; CLAUDICAO; ATAXIA; MENINGISMO', NULL, NULL, NULL, NULL, 1, 2, 9, 'marcha anormal; claudicacao; ataxia; meningismo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (257, 'EFEITOS TARDIOS, SNDROME PS-POLIOMIELITE, OUTRAS INFECES ENTEROVIRAIS', NULL, NULL, NULL, NULL, 7, 3, 9, 'efeitos tardios, sindrome pos-poliomielite, outras infeccoes enterovirais');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (258, NULL, 'ENCEFALOMIELITE MILGICA A04', 'FEBRE A03, MENINGISMO N29', NULL, 'UMA DOENA FEBRIL AGUDA COM RESULTADOS ANORMAIS DO LQUIDO CEREBROESPINAL.', 7, 3, 9, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (259, NULL, 'TETANIA N08', NULL, NULL, 'RIGIDEZ, CONTRAES HIPERTNICAS OU ESPASMOS TETNICOS E HISTRIA DE FERIMENTOS ANTERIORES', 7, 3, 9, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (260, 'ABCESSO CEREBRAL, INFECES POR VRUS LENTOS', 'POLIOMIELITE N70; MENINGITE/ENCEFALITE N71; POLINEVRITE AGUDA N94', NULL, NULL, NULL, 7, 3, 9, 'abcesso cerebral, infeccoes por virus lentos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (261, NULL, NULL, 'NEOPLASIA NO ESPECIFICADA N76', NULL, 'ASPECTO HISTOLGICO CARACTERSTICO', 7, 4, 9, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (262, 'NEOPLASIA DO SISTEMA NERVOSO NO ESPECIFICADA COMO BENIGNA OU MALIGNA OU QUANDO A HISTOLOGIA NO EST DISPONVEL', 'NEUROFIBROMATOSE A90', NULL, NULL, NULL, 7, 4, 9, 'neoplasia do sistema nervoso nao especificada como benigna ou maligna ou quando a histologia nao esta disponivel');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (263, 'EFEITOS TARDIOS', 'EFEITOS PSICOLGICOS P02', 'OUTRAS LESES CRANIANAS N80', NULL, 'TRAUMATISMO CRANIANO COM PERDA DE CONSCINCIA TEMPORRIA, FREQUENTEMENTE ACOMPANHADA DE AMNSIA, SEM CONTUSO CEREBRAL GRAVE', 7, 5, 9, 'efeitos tardios');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (264, 'LESO CEREBRAL COM OU SEM FRATURA CRANIANA; CONTUSO CEREBRAL; HEMORRAGIA INTRACEREBRAL TRAUMTICA; HEMATOMA EXTRADURAL; HEMATOMA SUBDURAL', 'CONCUSSO N79', NULL, NULL, 'TRAUMATISMO CRANIANO, COM COMPLICAES DE DANOS CEREBRAIS', 7, 5, 9, 'lesao cerebral com ou sem fratura craniana; contusao cerebral; hemorragia intracerebral traumatica; hematoma extradural; hematoma subdural');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (267, 'ESCLEROSE DISSEMINADA', NULL, 'OUTROS SINTOMAS NEUROLGICOS N29', NULL, 'EXACERBAES E REMISSES DE MANIFESTAO NEUROLGICA MLTIPLA COM DFICITS/PERTURBAES DISTRIBUDAS NO TEMPO E ESPAO (QUALQUER COMBINAO DE SINAIS E SINTOMAS NEUROLGICOS  POSSVEL)', 7, 7, 9, 'esclerose disseminada');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (268, 'INDUZIDO PELA MEDICAO; PARALISIA AGITANTE; DOENA DE PARKINSON', NULL, 'MOVIMENTOS INVOLUNTRIOS ANORMAIS N08, PERTURBAO DA FALA N19', NULL, 'POBREZA E LENTIDO DOS MOVIMENTOS VOLUNTRIOS, TREMORES EM REPOUSO QUE MELHORAM COM MOVIMENTOS ATIVOS, E RIGIDEZ MUSCULAR', 7, 7, 9, 'induzido pela medicacao; paralisia agitante; doenca de parkinson');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (269, 'TODOS OS TIPOS DE EPILEPSIA, CRISES FOCAIS, CRISES GENERALIZADAS, GRANDE MAL, PEQUENO MAL, ESTADO EPILPTICO', NULL, 'CONVULSES N07, OUTROS SINTOMAS NEUROLGICOS N29', NULL, 'EPISDIOS RECORRENTES DE ALTERAO SBITA DA CONSCINCIA, COM OU SEM CRISES/MOVIMENTOS TNICOS OU CLNICOS E TESTEMUNHO OCULAR DA CRISE, OU ALTERAO CARACTERSTICA DO ELETROENCEFALOGRAMA (EEG)', 7, 7, 9, 'todos os tipos de epilepsia, crises focais, crises generalizadas, grande mal, pequeno mal, estado epileptico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (270, 'DOR DE CABEA VASCULAR', 'CEFALIAS EM CLUSTER N90, CEFALIA DE TENSO N95', 'CEFALIA N01', NULL, 'EPISDIOS RECORRENTES DE CEFALIAS UNILATERAIS, NUSEA OU VMITOS, AURA, OUTROS SINTOMAS NEUROLGICOS, HISTRIA FAMILIAR DE ENXAQUECA', 7, 7, 9, 'dor de cabeca vascular');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (271, NULL, 'ENXAQUECA N89', NULL, NULL, 'CRISES DE DORES SEVERAS, FREQENTEMENTE LANCINANTES, UNILATERAIS, PERIORBITRIAS E/OU TEMPORAIS, REPETINDO-SE AT 8 VEZES POR DIA, POR VEZES ASSOCIADAS A INJEO CONJUNTIVAL, LACRIMEJO, CONGESTO NASAL, RINORRIA, SUORES, MIOSE, PTOSE, OU EDEMA DA PLPEBR', 7, 7, 9, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (272, NULL, NULL, 'PARALISIA, FRAQUEZA N18', NULL, 'PARALISIA UNILATERAL AGUDA DOS MSCULOS DE EXPRESSO FACIAL SEM PERDA SENSORIAL', 7, 7, 9, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (273, 'TIQUE DOLOROSO', 'NEVRALGIA PS-HERPTICA S70', 'NEVRALGIA NE N99', NULL, 'PAROXISMOS UNILATERAIS DE DOR ARDENTE FACIAL, AGRAVADA AO PALPAR PONTOS GATILHO, ASSOAR O NARIZ OU BOCEJAR, SEM PARALISIA SENSORIAL OU MOTORA', 7, 7, 9, 'tique doloroso');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (274, NULL, NULL, 'PERTURBAES SENSORIAIS N06', NULL, 'PERDA OU ENFRAQUECIMENTO DO TATO, AFETANDO O POLEGAR, INDICADOR E DEDO DO MEIO, PODENDO ATINGIR O DEDO ANELAR OU NO. DISESTESIA E DORES QUE SE INTENSIFICAM NORMALMENTE DURANTE A NOITE E PODEM IRRADIAR AO ANTEBRAO.', 7, 7, 9, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (275, 'POLINEUROPATIA INFECCIOSA AGUDA, NEUROPATIA DIABTICA, SNDROME DE GUILLAIN-BARR, LESO DO NERVO, NEUROPATIA', 'PS-HERPTICA S70', NULL, NULL, 'ALTERAES SENSORIAIS, REFLEXIVAS E MOTORAS, CINGIDAS AO ESPAO DOS NERVOS INDIVIDUAIS, POR VEZES SEM CAUSA APARENTE, POR VEZES SECUNDRIOS A UMA DOENA ESPECFICA, POR EXEMPLO DIABETES', 7, 7, 9, 'polineuropatia infecciosa aguda, neuropatia diabetica, sindrome de guillain-barre, lesao do nervo, neuropatia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (276, NULL, 'ENXAQUECA N89; CEFALIA DE CLUSTER N90', 'CEFALIA N01', NULL, 'DOR DE CABEA LATEJANTE, GENERALIZADA, ASSOCIADA AO ESTRESSE E TENSO MUSCULAR COM OU SEM A SENSIBILIDADE AUMENTADA DOS MSCULOS PERICRANIANOS', 7, 7, 9, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (277, 'PARALISIA CEREBRAL, DOENA DO NEURNIO MOTOR, MIASTENIA GRAVIS, NEVRALGIA NE, MEMBRO-FANTASMA', 'APNIA DO SONO P06', NULL, NULL, NULL, 7, 7, 9, 'paralisia cerebral, doenca do neuronio motor, miastenia gravis, nevralgia ne, membro-fantasma');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (175, 'ENDOCARDITE CRNICA; PROLAPSO DA VLVULA MITRAL; INSUFICINCIA DA VLVULA TRICSPIDE, MITRAL, PULMONAR, ARTICA NO-REUMTICA', 'DOENA VALVULAR REUMTICA K71', 'DOENA CARDACA HIPERTENSIVA K87, SOPROS CARDACOS NO-ESPECIFICADOS K81', NULL, 'AUSNCIA DE CRITRIOS DA DOENA CARDACA REUMTICA CRNICA K71 E MANIFESTAO DE DISFUNO VALVULAR QUER POR SOPRO CARDACO CARACTERSTICO, QUER POR SINAIS IMAGIOLGICOS OU ECOCARDIOGRFICOS DO FUNCIONAMENTO VALVULAR ANORMAL', 7, 7, 7, 'endocardite cronica; prolapso da valvula mitral; insuficiencia da valvula tricuspide, mitral, pulmonar, aortica nao-reumatica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (176, 'BLOQUEIO DE RAMO; PARADA CARDACA; CARDIOMEGALIA; DOENA DO PERICRDIO; CARDIOMIOPATIA;BLOQUEIO CARDACO; BLOQUEIO DO RAMO ESQUERDO; OUTROS DISTRBIOS DA CONDUO; OUTRAS DOENAS CARDACAS NO-ESPECIFICADAS', 'ARRITMIAS CARDACAS K80', NULL, NULL, NULL, 7, 7, 7, 'bloqueio de ramo; parada cardiaca; cardiomegalia; doenca do pericardio; cardiomiopatia;bloqueio cardiaco; bloqueio do ramo esquerdo; outros disturbios da conducao; outras doencas cardiacas nao-especificadas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (177, 'PRESSO ARTERIAL ELEVADA NO CORRESPONDENDO AOS CRITRIOS ESTABELECIDOS EM K86 E K87;HIPERTENSO TRANSITRIA OU INSTVEL', NULL, NULL, NULL, NULL, 7, 7, 7, 'pressao arterial elevada nao correspondendo aos criterios estabelecidos em k86 e k87;hipertensao transitoria ou instavel');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (491, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER UM CNCER DO APARELHO URINRIO SEM O TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 14, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (492, NULL, 'MEDO DE CNCER DO APARELHO URINRIO U26; SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER OUTRA DOENA DO APARELHO URINRIO SEM A TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 14, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (178, 'HIPERTENSO ESSENCIAL; HIPERTENSO NE; HIPERTENSO IDIOPTICA; HIPERTENSO INSTVEL', 'HIPERTENSO COM COMPLICAES K87, DURANTE A GRAVIDEZ W81', 'PRESSO SANGUNEA ELEVADA K85', 'TRATANDO-SE DE UMA CRIANA, CONSULTAR AS TABELAS DE PRESSO ARTERIAL PARA CRIANAS 2: EM CASO DE HIPERTENSO SECUNDRIA, CODIFIQUE A CAUSA SUBJACENTE', 'DUAS OU MAIS MEDIDAS EM CADA CONSULTA, AO LONGO DE DUAS OU MAIS CONSULTAS, COM PRESSO ARTERIAL DIASTLICA MDIA SUPERIOR A 95MMHG OU SISTLICA SUPERIOR A 160MMHG (EM PACIENTES ADULTOS); DUAS OU MAIS LEITURAS NUMA CONSULTA EM QUE O PACIENTE APRESENTA UMA', 7, 7, 7, 'hipertensao essencial; hipertensao ne; hipertensao idiopatica; hipertensao instavel');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (179, 'HIPERTENSO MALIGNA', 'HIPERTENSO SEM COMPLICAES K86', NULL, '1: PARA CRIANAS,  NECESSRIO CONSULTAR TABELAS DE PRESSO ARTERIAL PEDITRICAS APROPRIADAS 2: SE HIPERTENSO SECUNDRIA,  NECESSRIO CODIFICAR TAMBM A CAUSA/ PROBLEMA DE BASE', 'DUAS OU MAIS MEDIDAS EM CADA CONSULTA, AO LONGO DE DUAS OU MAIS CONSULTAS, COM PRESSO ARTERIAL DIASTLICA MDIA SUPERIOR A 95MMHG OU SISTLICA SUPERIOR A 160MMHG (EM PACIENTES ADULTOS); DUAS OU MAIS LEITURAS EM UMA CONSULTA EM QUE O PACIENTE APRESENTA UM', 7, 7, 7, 'hipertensao maligna');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (180, 'HIPOTENSO IDIOPTICA, ORTOSTTICA', 'DEVIDO  MEDICAO A85', 'PRESSO ARTERIAL BAIXA K29', NULL, 'SINAIS OU SINTOMAS DE INSUFICINCIA CEREBROVASCULAR (TONTURAS, SNCOPE) AO PASSAR REPENTINAMENTE DA POSIO SUPINA PARA A POSIO VERTICAL; E DIMINUIO DA PRESSO ARTERIAL EM 15MMHG EM DUAS OU MAIS CIRCUNSTNCIAS AO PASSAR DE UMA POSIO SUPINA PARA UMA', 7, 7, 7, 'hipotensao idiopatica, ortostatica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (181, 'INSUFICINCIA BASILAR; ATAQUES DE QUEDA; ACIDENTES ISQUMICOS TRANSITRIOS (AIT); AMNSIA GERAL TRANSITRIA', 'ACIDENTE CEREBROCARDIOVASCULAR K90, ENXAQUECA N89, SOPRO CAROTDEO K81', 'DESMAIOS, SINCOPE A06', 'CDIGO DUPLO COM K91', 'SINTOMAS DE HIPOFUNO CEREBRAL TEMPORRIA (MENOS DE 24 HORAS), APARECIMENTO REPENTINO, DE ORIGEM PRESUMIVELMENTE VASCULAR, SEM SEQELAS; COM EXCLUSO DE ENXAQUECA, ENXAQUECA EQUIVALENTE, OU EPILEPSIA', 7, 7, 7, 'insuficiencia basilar; ataques de queda; acidentes isquemicos transitorios (ait); amnesia geral transitoria');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (500, 'PAPILOMA DA BEXIGA; PLIPO DO APARELHO URINRIO', 'HIPERTROFIA PROSTTICA Y85', 'NEOPLASIA DO APARELHO URINRIO NE U79 (QUANDO NO H DADOS HISTOLGICOS DISPONVEIS)', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 14, 'papiloma da bexiga; polipo do aparelho urinario');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (246, 'ANESTESIA, DORMNCIA, PARESTESIA', 'FORMIGAMENTO N05; DORES, SENSIBILIDADE DA PELE S01', NULL, NULL, NULL, 1, 2, 9, 'anestesia, dormencia, parestesia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (182, 'APOPLEXIA; EMBOLIA CEREBRAL; ENFARTE CEREBRAL; TROMBOSE CEREBRAL; ACIDENTE VASCULAR CEREBRAL (AVC), OCLUSO OU ESTENOSE; HEMORRAGIA CEREBRAL; HEMORRAGIA SUBARACNIDEA', 'ISQUEMIA CEREBRAL TRANSITRIA K89', NULL, 'CDIGO DUPLO COM K91', 'SINAIS E SINTOMAS DE UMA PERTURBAO DA FUNO CEREBRAL, PRESUMIVELMENTE DE ORIGEM VASCULAR, COM DURAO SUPERIOR A 24 HORAS OU PROVOCANDO A MORTE EM QUATRO SEMANAS (28 DIAS) APS O APARECIMENTO', 7, 7, 7, 'apoplexia; embolia cerebral; enfarte cerebral; trombose cerebral; acidente vascular cerebral (avc), oclusao ou estenose; hemorragia cerebral; hemorragia subaracnoidea');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (183, 'ANEURISMA CEREBRAL, SEQELAS DE TROMBOSE', NULL, NULL, NULL, 'ISQUEMIA CEREBRAL TRANSITRIA OU TROMBOSE PRECEDENTES; OU RESULTADOS DE INVESTIGAO EVIDENCIANDO DOENA VASCULAR CEREBRAL', 7, 7, 7, 'aneurisma cerebral, sequelas de trombose');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (558, 'GARGANTA SECA, GARGANTA INFLAMADA, AMGDALAS DILATADAS, SENSAO DE APERTO NA GARGANTA, VERMELHIDO DA GARGANTA, GARGANTA IRRITADA, DOR NAS AMGDALAS', 'SINTOMAS RELATIVOS  VOZ R23, HIPERTROFIA DAS AMGDALAS R90', NULL, NULL, NULL, 1, 2, 11, 'garganta seca, garganta inflamada, amigdalas dilatadas, sensacao de aperto na garganta, vermelhidao da garganta, garganta irritada, dor nas amigdalas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (184, 'ARTERIOSCLEROSE; EMBOLIA ARTERIAL, TROMBOSE OU ESTENOSE; ATEROMA; ENDOARTERITE; GANGRENA; CLAUDICAO INTERMITENTE; ISQUEMIA DOS MEMBROS; SNDROME DE RENAUD; VASOESPASMO', 'MESENTRICA D99, OFTLMICA F99, DA RETINA F99, CORONRIA DE K74 A K76, PULMONAR K82, CEREBRAL K89,K90, ANEURISMA K99, RENAL U99; COMO COMPLICAO DE ABORTO, GRAVIDEZ, PARTO W77 OU PUERPRIO W96', NULL, NULL, NULL, 7, 7, 7, 'arteriosclerose; embolia arterial, trombose ou estenose; ateroma; endoarterite; gangrena; claudicacao intermitente; isquemia dos membros; sindrome de renaud; vasoespasmo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (185, 'ENFARTE PULMONAR (ARTERIAL OU VENOSO), TROMBOEMBOLIA, TROMBOSE', 'COMO COMPLICAO DE ABORTO, GRAVIDEZ, PARTO W77, OU PUERPRIO W96', 'DISPNIA R02', NULL, 'APARECIMENTO SBITO DE DISPNIA OU TAQUIPNIA, E PROVAS CLNICAS OU IMAGIOLGICAS DE ENFARTE PULMONAR, OU SINAIS ECG DE SOBRECARGA VENTRICULAR DIREITA AGUDA', 7, 7, 7, 'enfarte pulmonar (arterial ou venoso), tromboembolia, trombose');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (186, 'TROMBOSE VENOSA SUPERFICIAL OU PROFUNDA; FLEBOTROMBOSE; TROMBOSE PORTAL', 'TROMBOSE CEREBRAL K89 K90; TROMBOFLEBITE NA GRAVIDEZ W77 OU NO PUERPRIO W96', NULL, NULL, NULL, 7, 7, 7, 'trombose venosa superficial ou profunda; flebotrombose; trombose portal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (187, 'ECZEMA VARICOSO; INSUFICINCIA VENOSA; ESTASE VENOSA', 'LCERA VARICOSA S97', 'VEIAS PROEMINENTES K06', NULL, 'PRESENA DE VEIAS SUPERFICIAIS DILATADAS NAS EXTREMIDADES INFERIORES; OU DEMONSTRAO DE INCOMPETNCIA VALVULAR', 7, 7, 7, 'eczema varicoso; insuficiencia venosa; estase venosa');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (188, 'HEMORRIDAS INTERNAS COM OU SEM COMPLICAES, HEMATOMA PERIANAL; PLIPO CUTNEO HEMORROIDAL', NULL, 'DORES ANAIS D04, HEMORRAGIA RETAL D16, TUMOR ANAL D29', NULL, 'VISUALIZAO DE VARICOSIDADES DO PLEXO VENOSO DO NUS; OU EDEMA DE INCIO AGUDO, DOLOROSO E AZULADO, LOCALIZADO NA ZONA PERIANAL;', 7, 7, 7, 'hemorroidas internas com ou sem complicacoes, hematoma perianal; polipo cutaneo hemorroidal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (189, 'ANEURISMA DA AORTA; ARTERITE; FSTULA ARTERIOVENOSA; LINFOEDEMA; VARIZES ESOFGICAS; OUTRO ANEURISMA; POLIARTERITE NODOSA; VASCULITE; VEIAS VARICOSAS EM OUTRAS PARTES DO CORPO PARA ALM DAS EXTREMIDADES INFERIORES', 'LINFADENITE B71, ANEURISMA CEREBRAL K91, GANGRENA K92', NULL, NULL, NULL, 7, 7, 7, 'aneurisma da aorta; arterite; fistula arteriovenosa; linfoedema; varizes esofagicas; outro aneurisma; poliarterite nodosa; vasculite; veias varicosas em outras partes do corpo para alem das extremidades inferiores');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (190, 'DOR ATRIBUDA  COLUNA CERVICAL OU AO SISTEMA MUSCULOESQUELTICO', 'DOR DE CABEA, CABEA OU FACE DOLORIDA NE N01', NULL, NULL, NULL, 1, 2, 8, 'dor atribuida a coluna cervical ou ao sistema musculoesqueletico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (191, 'DORSALGIA NE; DORES TORCICAS DORSAIS', 'DORES NA REGIO LOMBAR L03', NULL, NULL, NULL, 1, 2, 8, 'dorsalgia ne; dores toracicas dorsais');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (192, 'DORES NAS COSTAS (LOMBARES OU SACROILACAS); COCCIDINIA; LUMBAGO, LOMBALGIA', 'DOR TORCICA DORSAL L02, CITICA L86', NULL, NULL, NULL, 1, 2, 8, 'dores nas costas (lombares ou sacroiliacas); coccidinia; lumbago, lombalgia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (193, 'DORES TORCICAS ATRIBUDAS AO SISTEMA MSCULO-ESQUELTICO', 'DORES TORCICAS NE A11; DOR PRECORDIAL K01; DORES PROVOCADAS PELA RESPIRAO, DORES PLEURTICAS, PLEURODINIA R01', NULL, NULL, NULL, 1, 2, 8, 'dores toracicas atribuidas ao sistema musculo-esqueletico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (194, 'DORES NO FLANCO', 'SINTOMAS RENAIS U14', NULL, NULL, NULL, 1, 2, 8, 'dores no flanco');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (487, 'URINA COM MAU ODOR, URINA ESCURA', 'ANLISES ANORMAIS DA URINA U98', NULL, NULL, NULL, 1, 2, 14, 'urina com mau odor, urina escura');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (488, NULL, NULL, NULL, NULL, NULL, 1, 2, 14, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (489, 'BEXIGA IRRITVEL', NULL, NULL, NULL, NULL, 1, 2, 14, 'bexiga irritavel');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (490, 'DORES NOS RINS, PROBLEMAS COM OS RINS, CLICAS RENAIS', 'DORES LOMBARES L05', NULL, NULL, NULL, 1, 2, 14, 'dores nos rins, problemas com os rins, colicas renais');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (493, 'TRANSPLANTE RENAL, FLUXO REDUZIDO', 'INCONTINNCIA URINRIA U04', NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA URINRIOM', 1, 2, 14, 'transplante renal, fluxo reduzido');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (494, 'INFECO DOS RINS; ABCESSO RENAL E PERIRRENAL', NULL, 'CISTITE/OUTRA INFECO URINRIA U71', NULL, 'DOIS ENTRE OS SEGUINTES: DOR NA REGIO LOMBAR, SENSIBILIDADE RENAL OU EVIDNCIA DE LESES CRNICAS RENAIS; ALM DE EVIDNCIA CLNICA OU LABORATORIAL DE INFECO DO APARELHO URINRIO', 7, 3, 14, 'infeccao dos rins; abcesso renal e perirrenal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (495, 'BACTERIRIA ASSINTOMTICA, CISTITE AGUDA E CRNICA (NO-VENREA), INFECO DO APARELHO URINRIO INFERIOR, INFECO DO APARELHO URINRIO NE', 'PIELONEFRITE U70, URETRITE U72; VAGINITE X84; BALANITE Y75;', NULL, 'EM CASO DE GRAVIDEZ CODIFIQUE TAMBM W84', NULL, 7, 3, 14, 'bacteriuria assintomatica, cistite aguda e cronica (nao-venerea), infeccao do aparelho urinario inferior, infeccao do aparelho urinario ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (496, 'URETRITE POR CHLAMYDIA, URETRITE NO ESPECFICA, SNDROME URETRAL, MEATITE', 'URETRITE GONOCCICA FEMININA X71; URETRITE TRICOMONAL FEMININA X73; URETRITE GONOCCICA MASCULINA Y71', 'MICO DOLOROSA U01; MICO FREQENTE/URGENTE U02; BEXIGA IRRITVEL U13; SECREO URETRAL X29,Y03', NULL, 'SECREO URETRAL COM FREQNCIA, ARDOR, DOR OU URGNCIA DURANTE A MICO SEM BACTERIRIA AO MICROSCPIO OU CULTURA; OU INFLAMAO DO MEATO URINRIO EXTERNO', 7, 3, 14, 'uretrite por chlamydia, uretrite nao especifica, sindrome uretral, meatite');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (497, NULL, NULL, 'NEOPLASIA DO APARELHO URINRIO NE U79 (QUANDO NO H DADOS HISTOLGICOS DISPONVEIS)', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 14, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (498, NULL, NULL, 'NEOPLASIA DO APARELHO URINRIO NE U79 (QUANDO NO H DADOS HISTOLGICOS DISPONVEIS)', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 14, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (499, 'NEOPLASIA MALIGNA DO URETER, NEOPLASIA MALIGNA DA URETRA', 'NEOPLASIA MALIGNA DA PRSTATA Y77', 'NEOPLASIA DO APARELHO URINRIO NE U79 (QUANDO NO H DADOS HISTOLGICOS DISPONVEIS)', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 14, 'neoplasia maligna do ureter, neoplasia maligna da uretra');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (501, 'NEOPLASIA DA BEXIGA/RIM/URETER/URETRA NE', 'NEOPLASIAS DO APARELHO URINRIO HISTOLOGICAMENTE COMPROVADAS U75, U76, U77, U78', NULL, NULL, NULL, 7, 4, 14, 'neoplasia da bexiga/rim/ureter/uretra ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (502, 'CONTUSO DO RIM, CORPO ESTRANHO NO APARELHO URINRIO', NULL, NULL, NULL, NULL, 7, 5, 14, 'contusao do rim, corpo estranho no aparelho urinario');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (503, 'DUPLICAO DE RIM/URETER, RIM POLICSTICO (CONGNITO)', NULL, NULL, NULL, NULL, 7, 6, 14, 'duplicacao de rim/ureter, rim policistico (congenito)');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (559, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER CNCER DO APARELHO RESPIRATRIO SEM O TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 11, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (560, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'UM MEDO EXCESSIVO DE OUTRAS DOENAS RESPIRATRIAS NUM PACIENTE QUE NO AS TEM OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 11, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (535, 'DISTRBIOS DE CONVERSO, HIPOCONDRIA, HISTERIA, PSEUDOCIESE', NULL, NULL, 'A SOMATIZAO  A APRESENTAO REPETIDA DE SINTOMAS FSICOS E DE QUEIXAS SUGESTIVAS DE DISTRBIOS FSICOS NO CONFIRMADOS POR RESULTADOS ORGNICOS VISVEIS OU MECANISMOS FISIOLGICOS, E PARA OS QUAIS EXISTE EVIDNCIA POSITIVA DE LIGAO A FATORES PSICOLG', 'A SOMATIZAO CARACTERIZA-SE POR UMA PREOCUPAO COM A APRESENTAO REPETIDA DE SINTOMAS E QUEIXAS FSICAS, ASSIM COMO PEDIDOS INSISTENTES DE EXAMES MDICOS, APESAR DE VRIOS RESULTADOS NEGATIVOS E GARANTIAS POR PARTE DOS PROFISSIONAIS. ESTA REQUER A APRE', 7, 7, 10, 'disturbios de conversao, hipocondria, histeria, pseudociese');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (536, 'PSICOSE AFETIVA NE; NEUROSE DEPRESSIVA; PSICOSE DEPRESSIVA; MISTO DE ANSIEDADE E DEPRESSO; DEPRESSO REATIVA; DEPRESSO PS-NATAL/PUERPERAL', 'REAO AGUDA AO ESTRESSE P02', 'SENSAO DE DEPRESSO P03', NULL, 'DISTRBIO IMPORTANTE DO ESTADO DE ESPRITO NO SENTIDO DA DEPRESSO. O ESTADO DE ESPRITO, A ENERGIA E A ATIVIDADE DIMINUEM, ASSIM COMO DIMINUI A ALEGRIA, O INTERESSE E A CONCENTRAO. O SONO E O APETITE SO NORMALMENTE ALTERADOS E A AUTO-ESTIMA E A CONFIA', 7, 7, 10, 'psicose afetiva ne; neurose depressiva; psicose depressiva; misto de ansiedade e depressao; depressao reativa; depressao pos-natal/puerperal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (537, 'GESTO SUICIDA; TENTATIVA SUCEDIDA (CDIGO DUPLO COM A96)', 'MEDO DE TENTATIVA DE SUICDIO P27', NULL, 'CDIGO DUPLO COM A96', NULL, 7, 7, 10, 'gesto suicida; tentativa sucedida (codigo duplo com a96)');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (538, NULL, NULL, 'FADIGA A04, FADIGA PS-VIRAL A04, FADIGA CRNICA A04', NULL, 'FADIGA CRESCENTE COM ASSOCIAES DESAGRADVEIS, DIFICULDADES DE CONCENTRAO E UM DECRSCIMO CONSTANTE DO DESEMPENHO E DA EFICINCIA; A SENSAO DE CANSAO FSICO E DE EXAUSTO DEPOIS DE UM ESFORO MENTAL OU UM ESFORO FSICO MNIMO  MUITAS VEZES ACOMPAN', 7, 7, 10, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (539, 'FOBIAS, PERTURBAES OBSESSIVO-COMPULSIVAS', NULL, NULL, NULL, 'A ANSIEDADE FBICA EXIGE A EXPRESSO DESSA ANSIEDADE EM VOZ ALTA, FEITA APENAS EM SITUAES BEM DEFINIDAS E NO CONSIDERADAS PERIGOSAS: O PACIENTE TENTA EVITAR ESTAS SITUAES OU SUPORTA-AS COM TERROR.', 7, 7, 10, 'fobias, perturbacoes obsessivo-compulsivas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (540, 'PSICOPATIA, NEUROSE DE COMPENSAO, SNDROME DE MUNCHAUSEN, PERTURBAES DE COMPORTAMENTO NUM ADULTO', NULL, NULL, NULL, 'ESTADOS E PADRES DE COMPORTAMENTO CLINICAMENTE RELEVANTES DO ESTILO DE VIDA DE UM INDIVDUO E DA SUA FORMA DE SE RELACIONAR CONSIGO MESMO E COM OS OUTROS, REFLETINDO DESVIOS SIGNIFICATIVOS OU GRAVES DA FORMA COMO A MAIORIA DOS INDIVDUOS DESSA CULTURA PE', 7, 7, 10, 'psicopatia, neurose de compensacao, sindrome de munchausen, perturbacoes de comportamento num adulto');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (541, 'FALTA DE ATENO, HIPERATIVIDADE', 'INCIO NA ADOLESCNCIA P23, PROBLEMAS DE APRENDIZAGEM P24', 'CRIANA HIPERATIVA P22', NULL, 'FALTA DE PERSISTNCIA, DE INCIO PRECOCE, AO REALIZAR ATIVIDADES QUE EXIGEM ENVOLVIMENTO COGNITIVO, COM TENDNCIA EM SALTAR DE UMA ATIVIDADE PARA OUTRA SEM COMPLETAR NENHUMA, COM COMPORTAMENTO DESORGANIZADO E DBIL E ATIVIDADE EXCESSIVA.', 7, 7, 10, 'falta de atencao, hiperatividade');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (542, 'PERTURBAO PERSISTENTE DA ADAPTAO', 'REAO AGUDA AO ESTRESSE P02', 'REAO DE ESTRESSE AGUDA P02, ANSIEDADE P01, DEPRESSO P03', NULL, 'UM ACONTECIMENTO ESTRESSANTE SEGUIDO DE ESTADOS DE PERTURBAO E DE ANGSTIA GRAVES, COM UMA REAO DIFERIDA OU PROLONGADA, FLASHBACKS, PESADELOS, EMBOTAMENTO EMOCIONAL, ANEDONIA INTERFERINDO COM O DESEMPENHO E O FUNCIONAMENTO SOCIAL, E INCLUINDO ESTADO', 7, 7, 10, 'perturbacao persistente da adaptacao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (543, NULL, 'DEVIDO A MALFORMAES CONGNITAS A90', NULL, NULL, 'INTERRUPO DO DESENVOLVIMENTO OU DESENVOLVIMENTO INCOMPLETO DO PENSAMENTO COM IMPEDIMENTO DE CERTAS COMPETNCIAS DURANTE O PERODO DE DESENVOLVIMENTO, FRACO NVEL DE INTELIGNCIA, COM OU SEM PERTURBAES COMPORTAMENTAIS.', 7, 7, 10, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (544, NULL, NULL, 'DISTRBIOS ALIMENTARES, RECUSA EM COMER P11,P29; DIFICULDADES EM COMER T04,T05', NULL, 'ANOREXIA NERVOSA: PERDA DE PESO PROVOCADA E MANTIDA DELIBERADAMENTE PELO PACIENTE, ASSOCIADA A UM MEDO EXAGERADO E SUPERVALORIZADO DA GORDURA E DA FLACIDEZ.', 7, 7, 10, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (545, 'PSICOSE REATIVA, PSICOSE PUERPERAL', NULL, NULL, NULL, 'BULIMIA: ATAQUES REPETIDOS DE FOME EM QUE SE COME DEMAIS E UMA PREOCUPAO EXCESSIVA COM O PESO, O QUE LEVA A UM COMPORTAMENTO PADRO DE EXCESSO DE COMIDA SEGUIDO DE VMITOS PROVOCADOS OU RECURSO A PURGATIVOS.', 7, 7, 10, 'psicose reativa, psicose puerperal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (546, 'AUTISMO; DOENA MENTAL NO ESPECIFICADA; NEUROSE NE', NULL, NULL, NULL, NULL, 7, 7, 10, 'autismo; doenca mental nao especificada; neurose ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (548, 'TODOS OS GRAUS; QUEIMADURAS QUMICAS', 'QUEIMADURAS SOLARES S80', NULL, NULL, NULL, 1, 5, 12, 'todos os graus; queimaduras quimicas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (549, 'RESPIRAO COM DORES, DORES PLEURTICAS, PLEURODINIA', 'DOR NO TRAX A11, DOR NO TRAX (MSCULO-ESQUELTICO) LO4, DORES NASAIS RO8, DOR NOS SEIOS PERINASAIS RO9, GARGANTA IRRITADA R21, PLEURISIA R82, SENSAO DE TRAX APERTADO R29', NULL, NULL, NULL, 1, 2, 11, 'respiracao com dores, dores pleuriticas, pleurodinia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (550, 'ORTOPNIA', 'RESPIRAO RUIDOSA RO3, ESTRIDOR R04, HIPERVENTILAO R98', NULL, NULL, NULL, 1, 2, 11, 'ortopneia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (551, 'INSPIRAO RUIDOSA OU ESTRIDOR', 'DISPNIA R02, ESTRIDOR R04, HIPERVENTILAO R98', NULL, NULL, NULL, 1, 2, 11, 'inspiracao ruidosa ou estridor');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (552, 'RESPIRAO ANORMAL, APNIA, INTERRUPO DA RESPIRAO, DIFICULDADES RESPIRATRIAS, RESSONAR, ESTRIDOR, TAQUIPNIA', 'APNIA DO SONO P06, DORES RESPIRATRIAS R01, DISPNIA R02, RESPIRAO RUIDOSA R03, TOSSE R05,  HIPERVENTILAO R98', NULL, NULL, NULL, 1, 2, 11, 'respiracao anormal, apneia, interrupcao da respiracao, dificuldades respiratorias, ressonar, estridor, taquipneia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (553, 'TOSSE (SECA OU MIDA)', 'EXPECTORAO OU MUCO R25', NULL, NULL, NULL, 1, 2, 11, 'tosse (seca ou umida)');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (554, NULL, NULL, NULL, NULL, NULL, 1, 2, 11, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (555, 'NARIZ TAPADO, RINORRIA, CORRIMENTO NASAL', NULL, NULL, NULL, NULL, 1, 2, 11, 'nariz tapado, rinorreia, corrimento nasal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (556, 'DORES NASAIS, GOTEJAMENTO PS-NASAL, NARIZ INCHADO, NARIZ VERMELHO', 'ANOSMIA N16, EPISTAXE R06, NARIZ TAPADO R07, ESPIRROS R07, QUEIXAS DOS SEIOS PERINASAIS R09, RINOFIMA S99', NULL, NULL, NULL, 1, 2, 11, 'dores nasais, gotejamento pos-nasal, nariz inchado, nariz vermelho');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (557, 'SEIOS PERINASAIS OBSTRUDOS, SEIOS PERINASAIS CONGESTIONADOS, DOR OU PRESSO NOS SEIOS PERINASAIS', 'CEFALIAS N01, DORES NA FACE N03, CONGESTO NASAL R07', NULL, NULL, NULL, 1, 2, 11, 'seios perinasais obstruidos, seios perinasais congestionados, dor ou pressao nos seios perinasais');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (243, NULL, 'DOR DE DENTES D19, CEFALIA N01, ENXAQUECA N89, NEVRALGIA DO TRIGMEO N92, DORES DOS SEIOS PERINASAIS R09, DOR PS-HERPTICA S70', NULL, NULL, NULL, 1, 2, 9, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (516, 'PLANEJAMENTO FAMILIAR POR ESTERILIZAO FEMININA', NULL, NULL, NULL, NULL, 1, 2, 15, 'planejamento familiar por esterilizacao feminina');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (318, 'OLHO NEGRO; HIFEMA; HEMORRAGIA SUBCONJUNTIVAL', 'LCERA DA CRNEA F85', NULL, NULL, NULL, 7, 5, 5, 'olho negro; hifema; hemorragia subconjuntival');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (561, 'INCAPACIDADE DEVIDO A HIPXIA, HIPERCAPNIA, FUNCIONAMENTO REDUZIDO DOS PULMES, DOENAS RESPIRATRIAS, OU DEVIDO A PROBLEMAS NASAIS, DA LARINGE OU DA GARGANTA', 'DISPNIA R02, ESPIRROS R03', NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA RESPIRATRIO', 1, 2, 11, 'incapacidade devido a hipoxia, hipercapnia, funcionamento reduzido dos pulmoes, doencas respiratorias, ou devido a problemas nasais, da laringe ou da garganta');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (562, 'SENSAO DE TRAX APERTADO, FLUIDOS NOS PULMES, SOLUOS, CONGESTO DOS PULMES, OUTROS SINTOMAS OU QUEIXAS DO APARELHO RESPIRATRIO', 'DOR R01, PROBLEMAS RESPIRATRIOS R02/R03/R04, TOSSE R05, SINTOMAS DO NARIZ OU DOS SEIOS PERINASAIS R06/R07/R08/R09, SINTOMAS DA GARGANTA R21/R22/R23, EXPECTORAO ANORMAL R24/R25', NULL, NULL, NULL, 1, 2, 11, 'sensacao de torax apertado, fluidos nos pulmoes, solucos, congestao dos pulmoes, outros sintomas ou queixas do aparelho respiratorio');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (563, 'PARAPERTUSSIS, PERTUSSIS', 'CRUPE R77', 'TOSSE R05, INFECO DO APARELHO RESPIRATRIO SUPERIOR R74', NULL, 'INFECO RESPIRATRIA COM TOSSE PAROXSTICA ENTRECORTADA CARACTERSTICA, TERMINANDO COM UMA CONTRAO INSPIRATRIA DE SOM AGUDO, OU INFECO RESPIRATRIA COM TOSSE DURANTE PELO MENOS TRS SEMANAS EM CONTATO COM TOSSE CONVULSA CONHECIDA, OU DEMONSTRAO DE', 7, 3, 11, 'parapertussis, pertussis');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (564, 'TONSILITE OU FARINGITE ESTREPTOCCICA CONFIRMADAS', 'ESCARLATINA A78; ERISIPELA, INFECO ESTREPTOCCICA DA PELE S76', 'TONSILITE R76', NULL, 'INFLAMAO AGUDA DA GARGANTA, ALM DE PROVA DE ESTREPTOCOCOS BETA-HEMOLTICOS', 7, 3, 11, 'tonsilite ou faringite estreptococica confirmadas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (565, 'INFECO LOCALIZADA NO NARIZ', 'SINUSITE AGUDA A75', NULL, NULL, NULL, 7, 3, 11, 'infeccao localizada no nariz');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (566, 'RINITE AGUDA, CORIZA, RESFRIADO, NASOFARINGITE, FARINGITE, INFECO DO TRATO RESPIRATRIO INFERIOR, INFECO DO TRATO RESPIRATRIO SUPERIOR', 'SARAMPO A71, MONONUCLEOSE INFECCIOSA A75, FARINGOCONJUNTIVITE VIRAL F70, SINUSITE R75, AMIGDALITE R76, ESQUINNCIA R76, LARINGITE R77, CRUPE R77, GRIPE R80, RINITE ALRGICA R97, FARINGITE CRNICA R99', NULL, NULL, 'EVIDNCIA DE INFLAMAO AGUDA NASAL OU DA MUCOSA FARNGEA COM AUSNCIA DE CRITRIOS QUE PERMITAM A DEFINIO ESPECFICA DE UMA INFECO RESPIRATRIA AGUDA, CLASSIFICADA NESTA SEO.', 7, 3, 11, 'rinite aguda, coriza, resfriado, nasofaringite, faringite, infeccao do trato respiratorio inferior, infeccao do trato respiratorio superior');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (567, 'SINUSITE QUE AFETE QUALQUER SEIO PERINASAL', NULL, 'CEFALIA N01, DORES FACIAIS N03, INFECO DO APARELHO RESPIRATRIO SUPERIOR R74', NULL, 'SECREO NASAL OU PS-NASAL PURULENTA, OU EPISDIOS ANTERIORES DE SINUSITE MEDICAMENTE TRATADA, ALM DE SENSIBILIDADE NA ZONA DE UM OU MAIS SEIOS PERINASAIS, OU DORES FACIAIS PROFUNDAS AGRAVADAS COM A CABEA PENDENTE, OU OPACIDADE  TRANSILUMINAO; OU EV', 7, 3, 11, 'sinusite que afete qualquer seio perinasal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (568, 'ABCESSO PERITONSILAR, ESQUINNCIA', 'MONONUCLEOSE INFECCIOSA A75, INFECO ESTREPTOCCICA DA GARGANTA R72, DIFTERIA R83, HIPERTROFIA OU INFECO CRNICA DAS AMGDALAS R90', 'INFECO AGUDA DO APARELHO RESPIRATRIO SUPERIOR R74', NULL, 'GARGANTA INFLAMADA OU FEBRE COM HIPERHEMIA DAS AMGDALAS MAIS DO QUE DA PAREDE POSTERIOR DA FARINGE, E PUS NA(S) AMGDALA(S) DILATADAS OU GNGLIOS REGIONAIS AUMENTADOS E SENSVEIS', 7, 3, 11, 'abcesso peritonsilar, esquinencia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (569, 'CRUPE', 'LARINGOTRAQUETE R78, EPIGLOTITE R83', 'INFECO DO APARELHO RESPIRATRIO SUPERIOR R74', NULL, 'ROUQUIDO OU ESTRIDOR COM OU SEM DIFICULDADE RESPIRATRIA, OU TOSSE SECA E PROFUNDA QUE PROVOCA DOR, TOSSE DE CACHORRO NAS CRIANAS, NO APRESENTANDO O TRAX QUALQUER SINAL ANORMAL', 7, 3, 11, 'crupe');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (570, 'INFECO AGUDA DO APARELHO RESPIRATRIO INFERIOR NE; BRONQUITE NE; INFECO DO TRAX NE;  LARINGOTRAQUEOBRONQUITE; TRAQUEOBRONQUITE', 'GRIPE R80, BRONQUITE CRNICA R91, BRONQUITE ALRGICA R96', 'RESPIRAO RUIDOSA R03, TOSSE R05, INFECO RESPIRATRIA SUPERIOR R74', NULL, 'EM CRIANAS E ADULTOS, TOSSE E FEBRE COM SINAIS DO TRAX ANORMAIS, EM PARTE OU EM GERAL - RESPIRAO RUIDOSA, ESTERTOR ROUCO E MIDO, RONCOS. EM CRIANAS PEQUENAS (BRONQUIOLITE) DISPNIA E HIPERINSUFLAO', 7, 3, 11, 'infeccao aguda do aparelho respiratorio inferior ne; bronquite ne; infeccao do torax ne;  laringotraqueobronquite; traqueobronquite');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (571, NULL, 'ENFISEMA, DOENA PULMONAR OBSTRUTIVA CRNICA (PULMO, VIAS RESPIRATRIAS) R95; BRONQUIECTASIAS R99', 'TOSSE R05; EXPECTORAO/MUCOSIDADE ANORMAIS R25; BRONQUITE NE R78', NULL, 'TOSSE COM EXPECTORAO QUASE DIRIA DURANTE PELO MENOS 3 MESES/ANO DURANTE PELO MENOS 2 ANOS; ESTRIDOR OU RONCOS NA AUSCULTAO DO TRAX DURANTE ESTES EPISDIOS', 7, 3, 11, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (572, 'DOENA DO TIPO DA INFLUENZA, PARA-INFLUENZA', 'GRIPE GSTRICA D70, GRIPE PNEUMNICA R81', 'FEBRE A03; INFECO VIRAL NE A77; INFECO DO APARELHO RESPIRATRIO SUPERIOR R74', NULL, 'MIALGIA E TOSSE SEM OUTROS SINAIS FSICOS RESPIRATRIOS ANORMAIS QUE NO A INFLAMAO DA MEMBRANA DA MUCOSA NASAL E DA GARGANTA, ALM DE TRS OU MAIS DOS SEGUINTES FENMENOS: INCIO REPENTINO (12 HORAS OU MENOS), TREMORES, ARREPIOS OU FEBRE, PROSTRAO E', 7, 3, 11, 'doenca do tipo da influenza, para-influenza');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (573, 'PNEUMONIA BACTERIANA E VIRAL; BRONCOPNEUMONIA; PNEUMONIA DA GRIPE; DOENA DOS LEGIONRIOS, PNEUMONITE', 'PNEUMONIA DE ASPIRAO R99', 'TOSSE R05; BRONQUITE NE R78', NULL, 'EVIDNCIA DE CONSOLIDAO PULMONAR', 7, 3, 11, 'pneumonia bacteriana e viral; broncopneumonia; pneumonia da gripe; doenca dos legionarios, pneumonite');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (574, 'EXSUDADO INFLAMATRIO PLEURAL, PLEURITE', 'TUBERCULOSE R70, PNEUMONIA R81, DERRAME MALIGNO (CODIFICAR NA ORIGEM DA MALIGNIDADE)', 'DORES PLEURTICAS R01', NULL, 'EVIDNCIA CLNICA DE EXSUDADO PLEURAL; OU DOR PLEURTICA ACOMPANHADA DE ATRITO DE FRICO PLEURAL; OU EVIDNCIA DE EXSUDADO INFLAMATRIO PLEURAL', 7, 3, 11, 'exsudado inflamatorio pleural, pleurite');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (575, 'NASOFARINGITE CRNICA; FARINGITE CRNICA; RINITE CRNICA NE; INFECES RESPIRATRIAS POR FUNGOS; INFECES POR PROTOZORIOS (SEM PNEUMONIA); ABCESSO NO PULMO; DIFTERIA; EPIGLOTITE; EMPIEMA', 'FIBROSE QUSTICA T99', NULL, 'MALIGNANT EFFUSION TO BE CODED TO ORIGIN OF MALIGNANCY', NULL, 7, 3, 11, 'nasofaringite cronica; faringite cronica; rinite cronica ne; infeccoes respiratorias por fungos; infeccoes por protozoarios (sem pneumonia); abcesso no pulmao; difteria; epiglotite; empiema');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (244, NULL, 'CLAUDICAO INTERMITENTE K92, DOR NA PERNA L14', NULL, NULL, NULL, 1, 2, 9, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (576, 'MALIGNIDADE NA TRAQUIA, BRNQUIOS, PULMO OU PLEURA', 'LOCALIZAO NO IDENTIFICADA A79; MALIGNIDADE SECUNDRIA DE ORIGEM IDENTIFICADA (CODIFICAR NO RESPECTIVO LOCAL)', 'NEOPLASIA DE NATUREZA INCERTA R92', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 11, 'malignidade na traqueia, bronquios, pulmao ou pleura');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (517, 'CONTRACEPO NE, PLANEJAMENTO FAMILIAR NE, ACONSELHAMENTO GENTICO', 'CONTRACEPO ORAL W11, DIU W12, ESTERILIZAO W13', NULL, NULL, NULL, 1, 2, 15, 'contracepcao ne, planejamento familiar ne, aconselhamento genetico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (577, 'MALIGNIDADE NA LARINGE, MEDIASTINO, NARIZ, FARINGE, SEIOS PERINASAIS; MESOTELIOMA', 'DOENA DE HODGKIN B72, MALIGNIDADE DA TRAQUIA, BRNQUIOS, PLEURA OU PULMO R84', 'NEOPLASIA DE NATUREZA INCERTA R92', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 11, 'malignidade na laringe, mediastino, nariz, faringe, seios perinasais; mesotelioma');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (578, 'NEOPLASIAS BENIGNAS DO APARELHO RESPIRATRIO', 'NEOPLASIA DE NATUREZA INCERTA R92, PLIPO NASAL R99', 'NEOPLASIAS DE NATUREZA INCERTA R92', NULL, 'APARNCIA CLNICA OU HISTOLGICA CARACTERSTICA', 7, 4, 11, 'neoplasias benignas do aparelho respiratorio');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (579, 'CORPO ESTRANHO NOS BRNQUIOS, LARINGE, PULMO OU NARIZ', 'AFOGAMENTO A88, CORPO ESTRANHO ALOJADO NO ESFAGO D79, CORPO ESTRANHO NO OUVIDO H76, PNEUMONIA DE ASPIRAO R99', 'OUTRAS QUEIXAS DO SISTEMA RESPIRATRIO R29', NULL, 'VISUALIZAO DO CORPO ESTRANHO DE FORMA DIRETA, ENDOSCPICA OU IMAGIOLGICA', 7, 5, 11, 'corpo estranho nos bronquios, laringe, pulmao ou nariz');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (580, 'TODAS AS LESES E TRAUMATISMOS DO NARIZ (EXCETO FRATURA) E DO APARELHO RESPIRATRIO; ENFISEMA CIRRGICO', 'AFOGAMENTO A88, FRATURA DO NARIZ L76, CORPO ESTRANHO R87', NULL, NULL, NULL, 7, 5, 11, 'todas as lesoes e traumatismos do nariz (exceto fratura) e do aparelho respiratorio; enfisema cirurgico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (581, 'MALFORMAO CONGNITA DO NARIZ, FARINGE, TRAQUIA, LARINGE, BRNQUIOS, PULMES OU PLEURA', 'FISSURA NO LBIO OU PALATO D81, FIBROSE CSTICA T99', NULL, NULL, NULL, 7, 6, 11, 'malformacao congenita do nariz, faringe, traqueia, laringe, bronquios, pulmoes ou pleura');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (390, 'AMIGDALITE CRNICA', 'AMIGDALITE AGUDA R76, RINITE ALRGICA R97', NULL, NULL, NULL, 7, 7, 11, 'amigdalite cronica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (391, 'INCERTEZA QUANTO  MALIGNIDADE OU  BENIGNIDADE', 'NEOPLASIA SECUNDRIA DE LOCALIZAO DESCONHECIDA A79; NEOPLASIAS MALIGNAS R84,R85; NEOPLASIA BENIGNA R86', NULL, NULL, NULL, 7, 4, 11, 'incerteza quanto a malignidade ou a benignidade');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (392, 'ENFISEMA; OBSTRUO CRNICA DAS VIAS RESPIRATRIAS, DO PULMO, DOENA PULMONAR; LIMITAO CRNICA DAS VIAS RESPIRATRIAS', 'BRONQUITE CRNICA R79, ASMA R96, BRONQUIECTASIAS R99, FIBROSE CSTICA T99', 'OUTROS PROBLEMAS RESPIRATRIOS R04', NULL, 'EVIDNCIAS OBJETIVAS DE OBSTRUO DAS VIAS RESPIRATRIAS, NO ALIVIADA OU APENAS PARCIALMENTE ALIVIADA PELOS BRONCODILATORES', 7, 7, 11, 'enfisema; obstrucao cronica das vias respiratorias, do pulmao, doenca pulmonar; limitacao cronica das vias respiratorias');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (393, 'BRONQUITE RUIDOSA, HIPERREATIVIDADE BRNQUICA', 'BRONQUIOLITE R78, BRONQUITE CRNICA R91, ENFISEMA R95', 'RESPIRAO RUIDOSA R03, TOSSE R05', NULL, 'EPISDIOS RECORRENTES DE OBSTRUO AGUDA E REVERSVEL DOS BRNQUIOS COM RUDO E/OU TOSSE SECA; OU TESTES DIAGNSTICOS QUE SATISFAAM OS CRITRIOS DE ASMA', 7, 7, 11, 'bronquite ruidosa, hiperreatividade bronquica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (394, 'FEBRE DO FENO, ALERGIA NASAL, RINITE VASOMOTORA', 'INFECO RESPIRATRIA SUPERIOR R74, RINITE NE R83', NULL, NULL, NULL, 7, 7, 11, 'febre do feno, alergia nasal, rinite vasomotora');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (395, NULL, NULL, 'PROBLEMAS RESPIRATRIOS R04', NULL, 'SINTOMAS RELACIONADOS  HIPERVENTILAO E ALIVIADOS QUANDO SE RESPIRA NOVAMENTE O AR EXPIRADO', 7, 7, 11, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (396, 'PNEUMONIA DE ASPIRAO; BRONQUIETASIAS; DESVIO DO SEPTO NASAL; COMPLICAES PULMONARES DE OUTRAS DOENAS; DOENA DO MEDIASTINO; PLIPO NASAL; OUTRAS DOENAS DA LARINGE; PNEUMOCONIOSE; PNEUMOTORAX; PNEUMONITE ALRGICA, QUMICOS, P, FUMOS, FUNGOS; COLAPSO', NULL, NULL, NULL, NULL, 7, 7, 11, 'pneumonia de aspiracao; bronquietasias; desvio do septo nasal; complicacoes pulmonares de outras doencas; doenca do mediastino; polipo nasal; outras doencas da laringe; pneumoconiose; pneumotorax; pneumonite alergica, quimicos, po, fumos, fungos; colapso');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (397, 'SENSAO DE ARDOR, LESO OU ERUPO CUTNEA DOLOROSA, DOR', 'FORMIGAMENTO, DISTRBIOS DE SENSAO N05,N06', NULL, NULL, NULL, 1, 2, 12, 'sensacao de ardor, lesao ou erupcao cutanea dolorosa, dor');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (504, 'GLOMERULONEFRITE AGUDA, NEFROPATIA POR ANALGSICOS, GLOMERULONEFRITE CRNICA, NEFRITE, NEFROPATIA, NEFROSCLEROSE, SNDROME NEFRTICA', 'INSUFICINCIA RENAL U99', 'ANLISES DE URINA ANORMAIS U98, QUEIXA DO RIM U14', NULL, 'TRS OU MAIS DOS SEGUINTES: HEMATRIA, PROTEINRIA, RETENO RENAL DE GUA E SAL, DIMINUIO DO FUNCIONAMENTO RENAL, ANOMALIAS PERSISTENTES DO SEDIMENTO URINRIO FREQENTES; OU EVIDNCIA POR BIPSIA RENAL', 7, 7, 14, 'glomerulonefrite aguda, nefropatia por analgesicos, glomerulonefrite cronica, nefrite, nefropatia, nefrosclerose, sindrome nefrotica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (505, 'PROTEINRIA POSTURAL', NULL, 'PROTEINRIA NE U98', NULL, 'ALBUMINRIA DE ESFORO, SEM ALBUMINRIA APS REPOUSO NO LEITO E SEM SINAIS DE DOENA RENAL', 7, 7, 14, 'proteinuria postural');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (237, 'FRATURAS PATOLGICAS DEVIDO A OSTEOPOROSE', NULL, NULL, NULL, 'SINAIS IMAGIOLGICOS CARACTERSTICOS', 7, 7, 8, 'fraturas patologicas devido a osteoporose');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (668, 'MAMAS INCHADAS', NULL, NULL, NULL, NULL, 1, 2, 16, 'mamas inchadas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (506, 'CLCULO OU PEDRA DA BEXIGA, RIM, URETER; UROLITASE', NULL, 'SANGUE NA URINA U06, CLICAS RENAIS U14, OUTROS SINTOMAS URINRIOS U29, RESULTADOS ANORMAIS DE ANLISE DE URINA U98', NULL, 'DORES TIPO CLICA E HEMATRIA OU HISTRIA DE CLCULO URINRIO; OU EMISSO DE CLCULO; OU EVIDNCIA IMAGIOLGICA DE CLCULO', 7, 7, 14, 'calculo ou pedra da bexiga, rim, ureter; urolitiase');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (507, 'GLICOSRIA, PROTEINRIA, PUS NA URINA, PIRIA', 'HEMATRIA/SANGUE NA URINA U06; ALBUMINRIA/PROTEINRIA ORTOSTTICA U90', NULL, NULL, NULL, 7, 7, 14, 'glicosuria, proteinuria, pus na urina, piuria');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (508, 'DIVERTCULO DA BEXIGA; HIDRONEFROSE; RIM HIPERTRFICO; OBSTRUO DO COLO VESICAL; INSUFICINCIA RENAL; CARNCULO URETRAL; APERTO URETRAL; REFLUXO URETRICO; UREMIA; E OUTRAS DOENAS DO APARELHO URINRIO NE', NULL, NULL, NULL, NULL, 7, 7, 14, 'diverticulo da bexiga; hidronefrose; rim hipertrofico; obstrucao do colo vesical; insuficiencia renal; carunculo uretral; aperto uretral; refluxo ureterico; uremia; e outras doencas do aparelho urinario ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (509, 'MENSTRUAO EM ATRASO OU SINTOMAS QUE INDICIEM UMA GRAVIDEZ', 'RECEIO DE GRAVIDEZ W02, GRAVIDEZ CONFIRMADA W78,W79', NULL, NULL, NULL, 1, 2, 15, 'menstruacao em atraso ou sintomas que indiciem uma gravidez');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (510, 'PREOCUPAO COM A POSSIBILIDADE DE UMA GRAVIDEZ INDESEJADA', 'PREOCUPAO OU MEDO NUMA GRAVIDEZ NO DESEJADA CONFIRMADA W79', NULL, NULL, NULL, 1, 2, 15, 'preocupacao com a possibilidade de uma gravidez indesejada');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (511, 'HEMORRAGIA VAGINAL DURANTE A GRAVIDEZ', 'HEMORRAGIA INTRAPARTO W17', NULL, NULL, NULL, 1, 2, 15, 'hemorragia vaginal durante a gravidez');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (512, 'HIPEREMESE, ENJOS MATINAIS NO CASO DE GRAVIDEZ CONFIRMADA', NULL, NULL, NULL, NULL, 1, 2, 15, 'hiperemese, enjoos matinais no caso de gravidez confirmada');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (513, 'PLULA DO DIA SEGUINTE', NULL, NULL, NULL, NULL, 1, 2, 15, 'pilula do dia seguinte');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (514, 'PLANEJAMENTO FAMILIAR POR TERAPIA HORMONAL', NULL, NULL, NULL, NULL, 1, 2, 15, 'planejamento familiar por terapia hormonal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (515, 'PLANEJAMENTO FAMILIAR POR DIU', NULL, NULL, NULL, NULL, 1, 2, 15, 'planejamento familiar por diu');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (518, 'PROBLEMAS DE TABAGISMO', NULL, 'FATORES DE RISCO NE A23', 'AS DEFINIES DE ABUSO DE SUBSTNCIAS DEVEM LEVAR EM CONTA AS DIFERENAS DE PAS PARA PAS E DE CULTURA PARA CULTURA. UM PACIENTE ALCOOLATRA OU UM TXICO-DEPENDENTE PRECISA DE ATENO POR PROFISSIONAL DA SADE, MAS AS DEFINIES DE ABUSO DE TABACO SO', 'PERTURBAO DEVIDA AO CONSUMO DE TABACO QUE LEVA A UMA OU MAIS INTOXICAES AGUDAS,  USO COM PREJUZO CLINICAMENTE GRAVE PARA A SADE, DEPENDNCIA OU ESTADO DE PRIVAO', 1, 2, 10, 'problemas de tabagismo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (519, 'QUALQUER DROGA PRESCRITA', NULL, NULL, 'AS DEFINIES DE ABUSO DE SUBSTNCIAS DEVEM LEVAR EM CONTA AS DIFERENAS DE PAS PARA PAS E DE CULTURA PARA CULTURA. UM PACIENTE ALCOOLATRA OU UM TXICO-DEPENDENTE PRECISA DE ATENO POR PROFISSIONAL DA SADE, MAS ALGUNS PACIENTES PEDEM E TOMAM TRANQUIL', NULL, 1, 2, 10, 'qualquer droga prescrita');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (520, 'DEPENDNCIA DE DROGAS, PRIVAO DE DROGAS', NULL, NULL, 'AS DEFINIES DE ABUSO DE SUBSTNCIAS DEVEM LEVAR EM CONTA AS DIFERENAS DE PAS PARA PAS E DE CULTURA PARA CULTURA. UM PACIENTE ALCOOLATRA OU UM TXICO-DEPENDENTE PRECISA DE ATENO POR PROFISSIONAL DA SADE, MAS AS DEFINIES DE ABUSO DE HAXIXE SO', 'PERTURBAO DEVIDA AO ABUSO DE SUBSTNCIAS PSICOATIVAS QUE PROVOCAM DEPENDNCIA, E QUE LEVA A UMA OU MAIS DAS SITUAES SEGUINTES:', 1, 2, 10, 'dependencia de drogas, privacao de drogas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (521, 'AMNSIA; DIFICULDADE DE CONCENTRAO; DESORIENTAO', NULL, NULL, NULL, NULL, 1, 2, 10, 'amnesia; dificuldade de concentracao; desorientacao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (522, 'ATRASO DE CRESCIMENTO; CIME; CRIANA HIPERATIVA; ATRASO DA FALA; CRISE DE IRA', 'ADOLESCENTE P23; ADULTO P80; PREOCUPAO COM O DESENVOLVIMENTO FSICO T10; ATRASO DE CRESCIMENTO T10', NULL, NULL, NULL, 1, 2, 10, 'atraso de crescimento; ciume; crianca hiperativa; atraso da fala; crise de ira');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (523, 'DELINQNCIA', 'CRIANA P22, P81; ADULTO P80', NULL, NULL, NULL, 1, 2, 10, 'delinquencia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (524, 'DISLEXIA', 'DIFICULDADES EM MANTER A ATENO P81, ATRASO MENTAL P85', NULL, NULL, 'DIFICULDADES DE APRENDIZAGEM DA FALA OU DA LINGUAGEM, COM INCIO NA INFNCIA, JUNTAMENTE COM DEFICINCIAS DE FUNCIONAMENTO LIGADAS  MATURAO BIOLGICA DO SISTEMA NERVOSO CENTRAL, E UM ESTADO ESTVEL AO LONGO DO TEMPO SEM REMISSES OU RECADAS ESPONTNEA', 1, 2, 10, 'dislexia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (525, 'SNDROME DO NINHO VAZIO, CRISE DA MEIA-IDADE, PROBLEMAS DECORRENTES DE INOVAES E MUDANAS', 'SENILIDADE, SENTIR-SE/COMPORTAR-SE COMO VELHO P05; MENOPAUSA X11', NULL, NULL, NULL, 1, 2, 10, 'sindrome do ninho vazio, crise da meia-idade, problemas decorrentes de inovacoes e mudancas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (526, 'PREOCUPAO COM DOENAS MENTAIS, MEDO DE TENTATIVA DE SUICDIO', 'SE O PACIENTE TEM ESSA DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER DOENAS MENTAIS SEM AS TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 10, 'preocupacao com doencas mentais, medo de tentativa de suicidio');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (527, NULL, 'EFEITOS TXICOS A86; INFECO DE PICADA S11; ESCABIOSE S72; PEDICULOSE S73', NULL, NULL, NULL, 1, 5, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (528, 'LIMITAO FUNCIONAL/ INCAPACIDADE COMO RESULTADO DE PERTURBAES PSICOLGICAS', 'AUTO-ESTIMA FRACA P03', NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA PSICOLGICO', 1, 2, 10, 'limitacao funcional/ incapacidade como resultado de perturbacoes psicologicas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (529, 'DELRIOS, PROBLEMAS ALIMENTARES NE, ALUCINAES, SINAIS/SINTOMAS PSICOLGICOS MLTIPLOS, FALTA DE HIGIENE, COMPORTAMENTOS ESTRANHOS, DESCONFIANA', 'CEFALIA DE TENSO N95', NULL, NULL, NULL, 1, 2, 10, 'delirios, problemas alimentares ne, alucinacoes, sinais/sintomas psicologicos multiplos, falta de higiene, comportamentos estranhos, desconfianca');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (530, 'DOENA DE ALZHEIMER, DEMNCIA SENIL', NULL, 'SENILIDADE P05, OUTROS SINTOMAS PSICOLGICOS P29', NULL, 'SNDROME DEVIDO A UMA DOENA DO CREBRO, GERALMENTE DE NATUREZA CRNICA E/OU PROGRESSIVA, COM PERTURBAES CLINICAMENTE SIGNIFICATIVAS DAS FUNES DO CRTEX SUPERIOR (MEMRIA, PENSAMENTO, ORIENTAO, COMPREENSO), MAS SEM AFETAR A CONSCINCIA.', 7, 7, 10, 'doenca de alzheimer, demencia senil');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (531, 'DELIRIUM', 'ORIGEM ALCOLICA P15, PSICOSE NO ESPECIFICADA P98', NULL, NULL, 'DISTRBIOS PSIQUITRICOS ORGNICOS COMO DIAGNSTICO EXIGEM SNDROMES PSICOLGICOS OU COMPORTAMENTOS DEVIDOS A UMA DOENA ORGNICA.', 7, 7, 10, 'delirium');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (532, 'TODOS OS TIPOS DE ESQUIZOFRENIA, PARANIA', 'PSICOSE AGUDA/ TRANSITRIA P98', 'PSICOSE NO ESPECIFICADA P98', NULL, 'DISTORES FUNDAMENTAIS E CARACTERSTICAS DO PENSAMENTO, PERCEPO E AFETOS QUE SO INADEQUADOS OU ENEVOADOS (POR EXEMPLO, PENSAMENTO-ECO, INSERO, RETIRADA, PERCEPES DELIRANTES, VOZES ALUCINATRIAS, DELRIOS DE CONTROLE), MAS COM PERFEITA CONSCINCIA', 7, 7, 10, 'todos os tipos de esquizofrenia, paranoia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (533, 'DISTRBIO BIPOLAR, HIPOMANIA, MANIA, DEPRESSO MANACA', 'DEPRESSO P76', 'PSICOSE NO ESPECIFICADA P98', NULL, 'DISTRBIO FUNDAMENTAL DOS AFETOS E DO HUMOR, ALTERNADAMENTE EXCITADO E DEPRIMIDO (ASSOCIADO OU NO A ANSIEDADE). NA PERTURBAO MANACA, A ENERGIA E A ATIVIDADE ESTO SIMULTANEAMENTE ESTIMULADAS. NA DOENA BIPOLAR, OBSERVAM-SE PELO MENOS DOIS PERODOS DE', 7, 7, 10, 'disturbio bipolar, hipomania, mania, depressao maniaca');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (534, 'NEUROSE ANSIOSA, PNICO', 'ANSIEDADE COM DEPRESSO P76, ANSIEDADE NE P01', 'ANSIEDADE, NERVOSISMO, TENSO P01', NULL, 'ANSIEDADE CLINICAMENTE SIGNIFICATIVA QUE NO SE RESTRINGE A NENHUM AMBIENTE OU SITUAO ESPECFICA. MANIFESTA-SE COMO EPISDIOS DE PNICO (ATAQUES RECORRENTES DE EXTREMA ANSIEDADE NO LIMITADA A NENHUMA SITUAO, COM OU SEM SINTOMAS FSICOS) OU COMO UMA A', 7, 7, 10, 'neurose ansiosa, panico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (383, NULL, 'TAQUICARDIA PAROXSTICA K79', 'PALPITAES KO4, BATIMENTOS CARDACOS IRREGULARES ANORMAIS KO5', NULL, 'MANIFESTAES CARACTERSTICAS NO ELETROCARDIOGRAMA; OU RITMO CARDACO IRREGULAR COM DFICIT DO PULSO', 7, 7, 7, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (384, 'SUPRAVENTRICULAR OU VENTRICULAR', 'TAQUICARDIA NE K04, FIBRILAO AURICULAR K78', 'PALPITAES KO4, RITMO CARDACO IRREGULAR ANORMAL KO5', NULL, 'HISTRIA CLNICA DE EPISDIOS SUCESSIVOS DE ACELERAES CARDACAS (SUPERIOR A 140/MIN) QUE SURGEM E TERMINAM ABRUPTAMENTE', 7, 7, 7, 'supraventricular ou ventricular');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (385, 'AURICULAR, BATIMENTOS CARDACOS PREMATUROS JUNCIONAIS, VENTRICULARES E AURICULARES; BRADICARDIA; BIGEMINISMO; BATIMENTOS ECTPICOS; EXTRASSTOLES; BATIMENTOS PREMATUROS; SNDROME DO SEIO PACIENTE; FIBRILAO VENTRICULAR E FLUTTER', 'TAQUICARDIA PAROXSTICA K79', 'PALPITAES KO4, RITMO CARDACO IRREGULAR K05', NULL, 'UM OU MAIS BATIMENTOS CARDACOS QUE SURGEM FORA DO RITMO CARDACO REGULAR', 7, 7, 7, 'auricular, batimentos cardiacos prematuros juncionais, ventriculares e auriculares; bradicardia; bigeminismo; batimentos ectopicos; extrasistoles; batimentos prematuros; sindrome do seio paciente; fibrilacao ventricular e flutter');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (245, 'SENSAO DE ARDOR, SENSAO DE PICADA', 'DORES, SENSIBILIDADE DA PELE S01', NULL, NULL, NULL, 1, 2, 9, 'sensacao de ardor, sensacao de picada');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (386, 'SOPRO CARDACO, SOPRO CAROTDEO, SOPRO INOCENTE INFANTIL, RUDO DA ARTRIA RENAL', 'DOENA REUMTICA CARDACA K71, DOENA VALVULAR K83, FRMITO VENOSO K84, DOENA CEREBROVASCULAR K90', NULL, NULL, NULL, 7, 7, 7, 'sopro cardiaco, sopro carotideo, sopro inocente infantil, ruido da arteria renal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (387, 'COR PULMONALE CRNICO, DOENAS DOS VASOS PULMONARES, HIPERTENSO PULMONAR PRIMRIA', 'EMBOLIA PULMONAR K93', 'INSUFICINCIA CARDACA DIREITA K77', NULL, 'PRESENA DE DOENA PULMONAR CRNICA, OU TROCA DOS GASES RESPIRATRIOS; E AINDA AUMENTO DO TAMANHO DO VENTRCULO DIREITO OU INSUFICINCIA CARDACA DIREITA', 7, 7, 7, 'cor pulmonale cronico, doencas dos vasos pulmonares, hipertensao pulmonar primaria');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (388, NULL, NULL, NULL, NULL, NULL, 1, 2, 8, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (389, 'METATARSALGIA', NULL, NULL, NULL, NULL, 1, 2, 8, 'metatarsalgia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (225, 'ESTIRAMENTO DA COLUNA; ESMAGAMENTO DA VRTEBRA NE; DEGENERAO DAS SUPERFCIES ARTICULARES; OSTEOARTROSE, OSTEOARTRITE DA COLUNA; ESPONDILOSE; ESPONDILOLISTESE', 'COCCIDINIA L03; SNDROMES RELACIONADOS COM O PESCOO L83; DORES DE COLUNA COM IRRADIAO L86; CITICA L86; DORES PSICOGNICAS DA COLUNA P75', 'SINAIS/SINTOMAS DA COLUNA L02; LOMBARES L03', NULL, 'DORES DE COLUNA SEM IRRADIAO COM LIMITAO DE MOVIMENTOS, CONFIRMADO POR EXAME FISICO', 7, 7, 8, 'estiramento da coluna; esmagamento da vertebra ne; degeneracao das superficies articulares; osteoartrose, osteoartrite da coluna; espondilose; espondilolistese');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (226, 'CIFOSCOLIOSE; CIFOSE; LORDOSE; ESCOLIOSE', 'MALFORMAES CONGNITAS L82; ESPONDILITE ANQUILOSANTE L88; ESPONDILOLISTESE L84', NULL, NULL, NULL, 7, 7, 8, 'cifoscoliose; cifose; lordose; escoliose');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (227, 'PROLAPSO OU DEGENERAO DO DISCO; CITICA', 'LESO DO DISCO CERVICAL L83; ESPONDILOLISTESE L84; DISTENSO RECENTE DA COLUNA L84', 'DORES DE COLUNA L02, L03', 'EXCLUIR REFERNCIA A DORES VAGAS', 'DORES NA REGIO LOMBAR OU TORCICA DA COLUNA, JUNTAMENTE COM DORES IRRADIADAS PARA UMA REA ESPECFICA OU DFICIT NEUROLGICO; OU CITICA, UMA DOR IRRADIADA PELA PARTE DE TRS DA PERNA, AGRAVADA PELA TOSSE, MOVIMENTOS OU POSIO; OU IDENTIFICAO DE PROLA', 7, 7, 8, 'prolapso ou degeneracao do disco; ciatica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (228, 'ESPORO SSEO, TENDO CALCIFICADO, CONTRAO DE DUPUYTREN, FASCETE, GNGLIO OU CISTO SINOVIAL, TENOSSINOVITE, DEDO EM GATILHO', 'DO OMBRO L92; COTOVELO DE TENISTA, EPICONDILITE EXTERNA L93', NULL, NULL, NULL, 7, 7, 8, 'esporao osseo, tendao calcificado, contracao de dupuytren, fasceite, ganglio ou cisto sinovial, tenossinovite, dedo em gatilho');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (229, 'CONDIES ASSOCIADAS: ESPONDILITE ANQUILOSANTE; ARTRITE JUVENIL', 'ARTROPATIA PSORITICA S91', NULL, NULL, NULL, 7, 7, 8, 'condicoes associadas: espondilite anquilosante; artrite juvenil');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (230, 'OSTEOARTRITE; SECUNDRIA A DISPLASIA, TRAUMATISMO', NULL, 'SINTOMAS NAS ARTICULAES L20; ARTRITE NE L91', NULL, 'MANIFESTAO IMAGIOLGICA CARACTERSTICA; OU PERTURBAES ARTICULARES COM DURAO MNIMA DE TRS MESES, SEM SINTOMAS CONSTITUCIONAIS, E TRS OU MAIS DAS SEGUINTES MANIFESTAES: EDEMA INTERMITENTE; CREPITAO; RIGIDEZ OU LIMITAO DOS MOVIMENTOS; VS, TEST', 7, 7, 8, 'osteoartrite; secundaria a displasia, traumatismo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (231, 'DISFONIA, AFONIA, ROUQUIDO', 'PERTURBAES NEUROLGICAS DA FALA N19, GAGUEIRA/TIQUES P10, GARGANTA IRRITADA R21', NULL, NULL, NULL, 1, 2, 11, 'disfonia, afonia, rouquidao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (232, 'OSTEOARTRITE, SECUNDRIA A TRAUMATISMO', NULL, 'SINTOMAS DAS ARTICULAES L20; ARTRITE NE L91', NULL, 'MANIFESTAO IMAGIOLGICA CARACTERSTICA; OU PERTURBAES DAS ARTICULAES COM DURAO MNIMA DE TRS MESES, SEM SINTOMAS CONSTITUCIONAIS, E TRS OU MAIS DAS SEGUINTES MANIFESTAES: EDEMA INTERMITENTE; CREPITAO; RIGIDEZ OU LIMITAO DOS MOVIMENTOS; VS,', 7, 7, 8, 'osteoartrite, secundaria a traumatismo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (233, 'ARTRITE NE; NDULOS DE HEBERDEN; OSTEOARTRITE; ARTROPATIA TRAUMTICA', 'DO PESCOO L83; DA COLUNA L84; DO QUADRIL L89; DO JOELHO L90; DO OMBRO L92', 'SINTOMAS DAS ARTICULAES L20; ARTRITE NE L91', NULL, 'SINAIS IMAGIOLGICOS CARACTERSTICOS; OU NDULOS DE HEBERDEN; OU PERTURBAES DAS ARTICULAES COM DURAO MNIMA DE TRS MESES, SEM SINTOMAS CONSTITUCIONAIS E TRS OU MAIS DAS SEGUINTES MANIFESTAES: EDEMA INTERMITENTE; CREPITAO; RIGIDEZ OU LIMITAO', 7, 7, 8, 'artrite ne; nodulos de heberden; osteoartrite; artropatia traumatica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (234, 'BURSITE DO OMBRO; OMBRO CONGELADO; OSTEOARTROSE; SNDROME DO MANGUITO ROTADOR; SINOVITE DO OMBRO; TENDINITE ABARTICULAR DO OMBRO', NULL, NULL, NULL, 'DOR NOS OMBROS, COM LIMITAO DOS MOVIMENTOS OU SENSIBILIDADE LOCAL, CREPITAO; OU SINAIS IMAGIOLGICOS DE CALCIFICAO PERIARTICULAR', 7, 7, 8, 'bursite do ombro; ombro congelado; osteoartrose; sindrome do manguito rotador; sinovite do ombro; tendinite abarticular do ombro');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (235, 'EPICONDILITE LATERAL', 'OUTRAS TENDINITES L87', NULL, NULL, NULL, 7, 7, 8, 'epicondilite lateral');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (236, 'DOENA DE LEGG-CALVE-PERTHES; DOENA DE OSGOOD/SCHLATTER; OSTEOCONDRITE DISSECANTE; DOENA DE SCHEUERMANN; EPFISE FEMURAL DESLOCADA', NULL, NULL, NULL, NULL, 7, 7, 8, 'doenca de legg-calve-perthes; doenca de osgood/schlatter; osteocondrite dissecante; doenca de scheuermann; epifise femural deslocada');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (238, 'LESO AGUDA DO MENISCO OU LIGAMENTOS CRUZADOS', 'LESO AGUDA DOS LIGAMENTOS COLATERAIS L78, DESLOCAMENTO DO JOELHO L80, LESO INTERNA CRNICA DO JOELHO L99', 'SINTOMAS DO JOELHO L15; TORO DO JOELHO L78', NULL, 'TRAUMATISMO INICIAL QUE OCORREU H MENOS DE UM MS, E IDENTIFICAO POR CIRURGIA, ARTROSCOPIA OU IMAGIOLOGIA DE ROTURA DO LIGAMENTO OU MENISCO; OU POR BLOQUEIO REVERSVEL, DOR E EDEMA DO JOELHO', 7, 5, 8, 'lesao aguda do menisco ou ligamentos cruzados');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (239, 'NEOPLASIAS BENIGNAS E NO-ESPECIFICADAS DO APARELHO MSCULO-ESQUELTICO', 'NEOPLASIAS MALIGNAS L71', NULL, NULL, NULL, 7, 4, 8, 'neoplasias benignas e nao-especificadas do aparelho musculo-esqueletico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (240, 'JOANETE, JOELHO VALGO/VARO; HLUX VALGO/VARO; DEDO EM MARTELO: PS CHATOS', 'DEFORMAES E MALFORMAES CONGNITAS A90,L82', NULL, NULL, NULL, 7, 7, 8, 'joanete, joelho valgo/varo; halux valgo/varo; dedo em martelo: pes chatos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (241, 'ARTRODESE; PERTURBAO INTERNA CRNICA DO JOELHO; CONTRATURAS; COSTOCONDRITE; DERMATOMIOSITE; PERTURBAES DA RTULA; M-UNIO OU NO-UNIO DA FRATURA; MIOSITE; DOENA SSEA DE PAGET; PANICULITE; FRATURA PATOLGICA NE; POLIMIALGIA REUMTICA; ARTRITE PSORI', 'HIPERURICEMIA A91; FRATURA PATOLGICA DEVIDO A OSTEOPOROSE L95; PARALISIA PS-POLIOMIELITE N70; PARALISIA PS-AVC N81; GOTA T92; PSEUDOGOTA E ARTROPATIA POR CRISTAIS T99; OSTEOMALACIA T99', NULL, NULL, NULL, 7, 7, 8, 'artrodese; perturbacao interna cronica do joelho; contraturas; costocondrite; dermatomiosite; perturbacoes da rotula; ma-uniao ou nao-uniao da fratura; miosite; doenca ossea de paget; paniculite; fratura patologica ne; polimialgia reumatica; artrite psori');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (242, 'DOR DE CABEA, DOR DE CABEA PS-TRAUMTICA', 'DORES NA FACE N03; ENXAQUECA N89; CEFALIAS EM CLUSTER N90; CEFALIA DE TENSO N95; NEVRALGIA FACIAL ATPICA N99; DORES DOS SEIOS PERINASAIS R09; DOR PS-HERPTICA S70', NULL, NULL, NULL, 1, 2, 9, 'dor de cabeca, dor de cabeca pos-traumatica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (248, 'DISTONIA, CRISPAO (CONTRATURA), MIOCLONIA, TREMORES, ESPASMOS', 'CORIA K71; CIBRAS L12,L14,L17,L18; PERNAS INQUIETAS N04; CONVULSES N07; TIQUE DOLOROSO N92; TIQUES ORGNICOS N99; TIQUE PSICOGNICO P10', NULL, NULL, NULL, 1, 2, 9, 'distonia, crispacao (contratura), mioclonia, tremores, espasmos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (249, 'ANOSMIA', 'HALITOSE D20', NULL, NULL, NULL, 1, 2, 9, 'anosmia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (292, 'ALCOOLISMO, SNDROMES ALCOLICAS DO CREBRO, PSICOSE ALCOLICA, DELIRIUM TREMENS', NULL, NULL, 'AS DEFINIES DE PROBLEMAS POR ABUSO DE SUBSTNCIAS DEVEM LEVAR EM CONSIDERAO DIFERENAS ENTRE PASES E CULTURAS. O PROFISSIONAL PODE DECIDIR CHAMAR UM EPISDIO DE ABUSO CRNICO DE LCOOL  SEM A CONCORDNCIA DO PACIENTE E, CONSEQENTEMENTE, SEM A SUA', 'PERTURBAO DEVIDA AO CONSUMO DO LCOOL E QUE RESULTA EM UM OU MAIS EPISDIOS CLNICOS DE GRAVE PREJUZO PARA A SADE, DEPENDNCIA, ESTADO DE PRIVAO OU DISTRBIOS PSICTICOS', 1, 2, 10, 'alcoolismo, sindromes alcoolicas do cerebro, psicose alcoolica, delirium tremens');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (293, 'EMBRIAGUEZ', NULL, NULL, 'O PROFISSIONAL PODE DECIDIR CHAMAR UM EPISDIO DE ABUSO AGUDO DE LCOOL  SEM A CONCORDNCIA DO PACIENTE E, CONSEQENTEMENTE, SEM A SUA PREDISPOSIO PARA CONCORDAR COM QUALQUER INTERVENO', 'PERTURBAO DEVIDA AO CONSUMO DE LCOOL QUE LEVA A INTOXICAES AGUDAS, COM OU SEM UMA HISTRIA DE ABUSO CRNICO', 1, 2, 10, 'embriaguez');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (294, 'FSTULA ANAL, ABCESSO ISQUIORRETAL', 'ABCESSO PILONIDAL S85', NULL, NULL, NULL, 7, 7, 4, 'fistula anal, abcesso isquiorretal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (295, 'CESTIDES; PARASITAS INTESTINAIS NO-ESPECIFICADOS; TRIQUINASE; DOENA HIDTICA', NULL, NULL, NULL, 'MANIFESTAES DE HELMINTAS EM FORMA ADULTA, LARVA OU OVA; EXAMES DERMATOLGICOS POSITIVOS; OU SOROLOGIA POSITIVA', 7, 7, 4, 'cestoides; parasitas intestinais nao-especificados; triquiniase; doenca hidatica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (296, 'HEPATITE ALCOLICA, CIRROSE, FGADO GORDO, HEPATITE NE, INSUFICINCIA HEPTICA, HIPERTENSO PORTAL', 'HEPATITE VIRAL D72, DOENA HIDTICA D96', NULL, NULL, NULL, 7, 7, 4, 'hepatite alcoolica, cirrose, figado gordo, hepatite ne, insuficiencia hepatica, hipertensao portal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (297, 'CLICAS BILIARES, COLANGITE, CLCULOS', NULL, 'DORES ABDOMINAIS LOCALIZADAS D06', NULL, 'COLECISTITE: EVIDNCIA DE PATOLOGIA TPICA POR ECOGRAFIA OU INTERVENO CIRRGICA; OU QUADRANTE SUPERIOR DIREITO DOLOROSO E ICTERCIA OU FEBRE OU HISTRIA CLNICA DE CLCULOS; COLELITASE: DEMONSTRAO IMAGIOLGICA OU CIRRGICA DE CLCULOS; CLICA BILIAR', 7, 7, 4, 'colicas biliares, colangite, calculos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (298, 'ADERNCIAS ABDOMINAIS; DOENA CELACA; SNDROME DO ESVAZIAMENTO RPIDO; INTOLERNCIA ALIMENTAR;  GASTROENTEROPATIA ALRGICA, TOXICA E DIABTICA; LEO; OBSTRUO INTESTINAL; INTUSCEPO; SNDROME DE MALABSORO; DOENA VASCULAR MESENTRICA; DOENAS PANCRE', 'COLITE ASSOCIADA A ANTIBITICOS A85, DOENA MALIGNA D74-D77', NULL, NULL, NULL, 7, 7, 4, 'aderencias abdominais; doenca celiaca; sindrome do esvaziamento rapido; intolerancia alimentar;  gastroenteropatia alergica, toxica e diabetica; ileo; obstrucao intestinal; intuscepcao; sindrome de malabsorcao; doenca vascular mesenterica; doencas pancrea');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (299, NULL, 'SENSAES ANORMAIS NO OLHO F13', NULL, NULL, NULL, 1, 2, 5, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (300, 'OLHOS CONGESTIONADOS, INFLAMADOS', NULL, NULL, NULL, NULL, 1, 2, 5, 'olhos congestionados, inflamados');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (301, 'LACRIMEJO, SECREO PURULENTA', NULL, NULL, NULL, NULL, 1, 2, 5, 'lacrimejo, secrecao purulenta');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (302, 'PONTOS FIXOS OU FLUTUANTES NO CAMPO VISUAL', 'PERDA DE VISO F94', NULL, NULL, NULL, 1, 2, 5, 'pontos fixos ou flutuantes no campo visual');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (303, 'VISO TURVA; DIFICULDADE EM LER; DIPLOPIA; VISTA ESFORADA; ESCOTOMA E OFUSCAMENTO EM CASO DE SINTOMAS CONFINADOS  VISTA; CEGUEIRA TEMPORRIA NE; PERDA DE VISO; VISTA CANSADA', 'FOTOFOBIA F13, CEGUEIRA DA NEVE F79, ERROS DE REFRAO F91, CEGUEIRA PERMANENTE F94, DALTONISMO F99, CEGUEIRA NOTURNA F99', NULL, NULL, NULL, 1, 2, 5, 'visao turva; dificuldade em ler; diplopia; vista esforcada; escotoma e ofuscamento em caso de sintomas confinados a vista; cegueira temporaria ne; perda de visao; vista cansada');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (304, 'ARDOR NOS OLHOS; OLHOS SECOS; PRURIDO NOS OLHOS; FOTOFOBIA', 'DOR NO OLHO F01', NULL, NULL, NULL, 1, 2, 5, 'ardor nos olhos; olhos secos; prurido nos olhos; fotofobia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (305, 'PESTANEJAR ANORMAL, AMBLIOPIA, NISTAGMO, CONTRAO ESPASMDICA', 'ESTRABISMO F95; TIQUES DOS OLHOS P10', NULL, NULL, NULL, 1, 2, 5, 'pestanejar anormal, ambliopia, nistagmo, contracao espasmodica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (306, 'ALTERAO DA COR DOS OLHOS; OLHOS INCHADOS', 'OLHO VERMELHO F02', NULL, NULL, NULL, 1, 2, 5, 'alteracao da cor dos olhos; olhos inchados');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (307, 'PTOSE PALPEBRAL', 'PLPEBRAS INFLAMADAS F72', NULL, NULL, NULL, 1, 2, 5, 'ptose palpebral');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (308, 'PROBLEMAS COM OS CULOS AFETANDO A ESTRUTURA, FUNO OU SENSAES DOS OLHOS', 'PROBLEMAS COM LENTES DE CONTATO F18', NULL, NULL, NULL, 1, 2, 5, 'problemas com os oculos afetando a estrutura, funcao ou sensacoes dos olhos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (309, 'PROBLEMAS COM AS LENTES DE CONTATO AFETANDO A ESTRUTURA, FUNO OU SENSAES DOS OLHOS', NULL, NULL, NULL, NULL, 1, 2, 5, 'problemas com as lentes de contato afetando a estrutura, funcao ou sensacoes dos olhos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (720, NULL, NULL, NULL, '(VER CAPTULO 8).', NULL, 1, 2, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (310, 'MEDO DE CEGUEIRA', 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER UMA DOENA OCULAR SEM A TER, OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 5, 'medo de cegueira');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (311, 'CEGUEIRA DE UM OLHO; INCAPACIDADE DEVIDA AO OLHO OU PROBLEMAS DE VISO', 'CEGUEIRA F94', NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA DE VISO/ NOS OLHOS', 1, 2, 5, 'cegueira de um olho; incapacidade devida ao olho ou problemas de visao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (312, NULL, NULL, NULL, NULL, NULL, 1, 2, 5, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (313, 'BACTERIANA E VIRAL; NE', 'ALRGICA COM E SEM RINORRIA F71, QUEIMADURA POR CLARO F79, TRACOMA F86', NULL, NULL, 'INFLAMAO DAS CONJUNTIVAS SEM AS CONDIES REFERIDAS EM EXCLUSO', 7, 3, 5, 'bacteriana e viral; ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (314, 'ALRGICA COM OU SEM RINORRIA', 'CONJUNTIVITE BACTERIANA E VIRAL F70, QUEIMADURA POR CLARO F79, TRACOMA F86', NULL, NULL, 'HIPEREMIA DAS CONJUNTIVAS, LACRIMEJO EXCESSIVO, PRURIDO E POSSVEL EDEMA DA CONJUNTIVA SEM AS CONDIES REFERIDAS EM EXCLUSO', 7, 3, 5, 'alergica com ou sem rinorreia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (315, 'SURDEZ CONGNITA; SURDEZ PARCIAL OU TOTAL DOS DOIS OUVIDOS', 'SURDEZ TEMPORRIA H28, SURDEZ DE UM OUVIDO H28, OTOESCLEROSE H83, PRESBIACUSIA H84, SURDEZ DE RUDO H85', NULL, NULL, NULL, 7, 7, 6, 'surdez congenita; surdez parcial ou total dos dois ouvidos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (316, 'DACRIOCISTITE; HERPES SIMPLES SEM LCERA DA CRNEA; HERPES ZSTER OFTLMICO; IRITE; IRIDOCICLITE; QUERATITE', 'LCERA DA CRNEA (HERPES) F85, TRACOMA F86', NULL, NULL, NULL, 7, 3, 5, 'dacriocistite; herpes simples sem ulcera da cornea; herpes zoster oftalmico; irite; iridociclite; queratite');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (317, 'BENIGNAS E MALIGNAS', NULL, NULL, NULL, NULL, 7, 4, 5, 'benignas e malignas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (320, 'ESCORIAO DA CRNEA, QUEIMADURA POR CLARO, CEGUEIRA PROVOCADA PELA NEVE', 'CONTUSO/HEMORRAGIA F75, CORPO ESTRANHO F76', NULL, NULL, NULL, 7, 5, 5, 'escoriacao da cornea, queimadura por clarao, cegueira provocada pela neve');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (321, NULL, 'DACRIOCISTITE F73, EM PESSOAS IDOSAS F99', NULL, NULL, 'CORRIMENTO DE LGRIMAS SEM CHORO COM INCIO ANTES DOS TRS MESES DE IDADE', 7, 6, 5, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (322, NULL, NULL, NULL, NULL, NULL, 7, 6, 5, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (323, NULL, NULL, NULL, NULL, NULL, 7, 7, 5, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (324, 'DIABTICA, HIPERTENSIVA OU OUTRAS', NULL, NULL, 'CODIFICAR TAMBM AS DOENAS SABIDAMENTE CAUSADORAS, POR EXEMPLO, DIABETES T89, T90 OU HIPERTENSO K87', NULL, 7, 7, 5, 'diabetica, hipertensiva ou outras');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (325, NULL, 'RETINOPATIA F83', NULL, NULL, NULL, 7, 7, 5, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (326, 'LCERA DENDRTICA; QUERATITE VIRAL', 'ESCORIAO DA CRNEA F75, OUTROS TRAUMATISMOS F79', NULL, NULL, NULL, 7, 7, 5, 'ulcera dendritica; queratite viral');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (327, NULL, NULL, 'OLHO VERMELHO F02, CORRIMENTO DO SACO LACRIMAL F03', NULL, 'EVIDNCIA DE INFECO COM CHLAMYDIA TRACHOMATIS OU CARACTERSTICAS CLNICAS TPICAS, INCLUINDO INFLAMAO E HIPERTROFIA DA CONJUNTIVA COM FORMAO DE GRNULOS AMARELADOS OU ACINZENTADOS', 7, 7, 5, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (328, 'ASTIGMATISMO; HIPERMETROPIA; VISO LONGA; MIOPIA; PRESBIOPIA; VISO CURTA', 'CEGUEIRA E ACUIDADE VISUAL REDUZIDA NE F94', NULL, NULL, 'DFICIT VISUAL CORRIGVEL COM LENTES APROPRIADAS', 7, 7, 5, 'astigmatismo; hipermetropia; visao longa; miopia; presbiopia; visao curta');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (329, NULL, 'CONGNITAS F81', NULL, NULL, 'OPACIDADE TOTAL OU PARCIAL DA LENTE PTICA, REDUZINDO OU ENFRAQUECENDO A VISO', 7, 7, 5, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (330, 'AUMENTO DA PRESSO INTRA-OCULAR', 'CONGNITO F81', NULL, NULL, NULL, 7, 7, 5, 'aumento da pressao intra-ocular');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (331, 'CEGUEIRA PARCIAL OU TOTAL DOS DOIS OLHOS', 'VISO TURVA F05; CEGUEIRA TEMPORRIA F05; CEGUEIRA DE UMA VISTA F28; CEGUEIRA PROVOCADA PELA NEVE F79; ERROS DE REFRAO F91; DALTONISMO F99; CEGUEIRA NOTURNA F99', NULL, NULL, NULL, 7, 7, 5, 'cegueira parcial ou total dos dois olhos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (332, 'OLHOS CRUZADOS, OLHOS TORTOS', NULL, 'MOVIMENTOS OCULARES ANORMAIS F15', NULL, 'FALTA DE PARALELISMO DO EIXO VISUAL DOS OLHOS DIAGNOSTICADO DURANTE EXAME MDICO', 7, 7, 5, 'olhos cruzados, olhos tortos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (333, 'ARCO SENIL; AMBLIOPIA; DALTONISMO; OPACIDADE DA CRNEA; ECTRPIO; ENTRPIO; EPISCLERITE; PESTANA ENCRAVADA; IRITE; CEGUEIRA NOTURNA; PAPILEDEMA; PTERGIO; ESCLERITE; E OUTRAS DOENAS OCULARES NE', NULL, NULL, NULL, NULL, 7, 7, 5, 'arco senil; ambliopia; daltonismo; opacidade da cornea; ectropio; entropio; episclerite; pestana encravada; irite; cegueira noturna; papiledema; pterigio; esclerite; e outras doencas oculares ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (334, NULL, NULL, NULL, NULL, NULL, 1, 2, 6, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (335, 'HIPERACUSIA, DISTRBIO DA DISCRIMINAO AUDITIVA, DIPLACUSIA E SENSAO DE PERDA AUDITIVA', 'SURDEZ DE UM OUVIDO H28, AMBOS OUVIDOS H86', NULL, NULL, NULL, 1, 2, 6, 'hiperacusia, disturbio da discriminacao auditiva, diplacusia e sensacao de perda auditiva');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (336, 'ECO NOS OUVIDOS, TINIDO', 'OUVIDOS A ESTALAR H29', NULL, NULL, NULL, 1, 2, 6, 'eco nos ouvidos, tinido');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (337, NULL, 'SANGUE H05', NULL, NULL, NULL, 1, 2, 6, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (338, 'SANGUE DENTRO DOS OUVIDOS/EXPELIDO PELOS OUVIDOS', NULL, NULL, NULL, NULL, 1, 2, 6, 'sangue dentro dos ouvidos/expelido pelos ouvidos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (339, 'OUVIDOS OBSTRUDOS', 'CERA NOS OUVIDOS H81', NULL, NULL, NULL, 1, 2, 6, 'ouvidos obstruidos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (340, NULL, 'ORELHAS DE ABANO H80, MALFORMAES CONGNITAS H80', NULL, NULL, NULL, 1, 2, 6, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (341, 'NEURINOMA DO ACSTICO, MENINGIOMA', NULL, NULL, NULL, NULL, 7, 4, 9, 'neurinoma do acustico, meningioma');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (605, 'INFIDELIDADE, ABUSO FSICO', NULL, NULL, 'O DIAGNSTICO DE PROBLEMAS DECORRENTES DO COMPORTAMENTO DO PARCEIRO REQUER O RECONHECIMENTO POR PARTE DO PACIENTE DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, 'infidelidade, abuso fisico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (606, NULL, NULL, NULL, 'O DIAGNSTICO DE PROBLEMAS DECORRENTES DE DOENA DE UM OU AMBOS OS PARCEIROS REQUER O RECONHECIMENTO POR PARTE DO PACIENTE DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (607, 'FALECIMENTO, DIVRCIO, SEPARAO', NULL, NULL, 'O DIAGNSTICO DE PROBLEMAS SOCIAIS DECORRENTES DA PERDA OU FALECIMENTO DO PARCEIRO REQUER O RECONHECIMENTO POR PARTE DO PACIENTE DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, 'falecimento, divorcio, separacao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (608, 'ABUSO EMOCIONAL', 'ABUSO FSICO Z25', NULL, 'O DIAGNSTICO DE PROBLEMAS RELACIONAIS ENTRE UM ADULTO E UMA CRIANA REQUER O RECONHECIMENTO POR PARTE DO PACIENTE DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA', NULL, 1, 2, 18, 'abuso emocional');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (609, NULL, NULL, NULL, 'O DIAGNSTICO DE PROBLEMAS SOCIAIS DECORRENTES DO FATO DE UMA CRIANA ESTAR DOENTE REQUER O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (610, NULL, NULL, NULL, 'O DIAGNSTICO DE PROBLEMAS DECORRENTES DA PERDA OU MORTE DE UMA CRIANA DA FAMLIA REQUER O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (721, 'SFILIS QUALQUER QUE SEJA A SUA LOCALIZAO', NULL, NULL, NULL, 'EVIDNCIA DE TREPONEMA PALLIDUM AO MICROSCPIO, OU TESTE SOROLGICO POSITIVO PARA A SFILIS', 7, 3, 17, 'sifilis qualquer que seja a sua localizacao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (611, 'PAIS, IRMO(S) ADULTO(S), OUTROS ELEMENTOS DA FAMLIA', 'PARCEIRO Z12, CRIANA Z16, AMIGO Z24', NULL, 'O DIAGNSTICO DE PROBLEMAS RELACIONAIS ENTRE FAMILIARES REQUER O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, 'pais, irmao(s) adulto(s), outros elementos da familia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (612, NULL, 'COMPORTAMENTO DA CRIANA P22, ADOLESCENTE P23, PARCEIRO Z13', NULL, 'O DIAGNSTICO DE PROBLEMAS DECORRENTES DO COMPORTAMENTO DE UM ELEMENTO DA FAMLIA REQUER O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (613, NULL, 'PARCEIRO DOENTE Z14', NULL, 'O DIAGNSTICO DE PROBLEMAS DECORRENTES DA DOENA DE UM ELEMENTO DA FAMLIA REQUER O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (614, NULL, 'PERDA DE UMA CRIANA Z19, PERDA DO PARCEIRO Z15', NULL, 'O DIAGNSTICO DE PROBLEMAS DECORRENTES DA PERDA OU FALECIMENTO DE UM ELEMENTO DA FAMLIA REQUER O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (615, NULL, 'FAMILIARES Z20', NULL, 'O DIAGNSTICO DE PROBLEMAS RELACIONAIS ENTRE AMIGOS REQUER O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (616, 'ABUSO FSICO DE CRIANA OU PARCEIRO, VIOLAO, ASSDIO SEXUAL', 'PROBLEMAS FSICOS TM ENTRADAS ESPECFICAS NOUTROS CAPTULOS; PROBLEMAS PSICOLGICOS VER CAPTULO P', NULL, 'O DIAGNSTICO DE PROBLEMAS SOCIAIS DECORRENTES DE ATAQUES OU OUTRO ACONTECIMENTO VIOLENTO REQUER O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, 'abuso fisico de crianca ou parceiro, violacao, assedio sexual');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (617, 'PREOCUPAO COM O FATO DE VIR A TER PROBLEMAS SOCIAIS', 'SE O PACIENTE TEM O PROBLEMA, CODIFIQUE-O', NULL, NULL, 'PACIENTE PREOCUPADO COM PROBLEMAS DE ORDEM SOCIAL SEM OS TER OU ENQUANTO O PROBLEMA NO EST CONFIRMADO', 1, 2, 18, 'preocupacao com o fato de vir a ter problemas sociais');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (618, 'ISOLAMENTO SOCIAL, VIVER SOZINHO', NULL, NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE CAUSADA POR PROBLEMAS SOCIAIS, INCLUINDO ISOLAMENTO/ VIVER SOZINHO/ SOLIDO', 1, 2, 18, 'isolamento social, viver sozinho');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (619, 'PROBLEMAS COM O AMBIENTE NO QUAL SE EST INSERIDO, SIMULAO DE DOENA, POLUIO', NULL, NULL, NULL, NULL, 1, 2, 18, 'problemas com o ambiente no qual se esta inserido, simulacao de doenca, poluicao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (620, 'ESTERILIDADE', NULL, 'SINAIS/SINTOMAS DA GRAVIDEZ W29', NULL, 'INCAPACIDADE DE ENGRAVIDAR APS 2 ANOS DE TENTATIVAS', 1, 2, 15, 'esterilidade');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (621, 'SANGRAMENTO PS-PARTO', NULL, 'SINAIS/SINTOMAS DO PS-PARTO W18', NULL, 'HEMORRAGIA FRANCA NO, DURANTE OU AT 6 SEMANAS APS O PARTO', 1, 2, 15, 'sangramento pos-parto');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (622, 'QUEIXAS NO PARTO E DURANTE AS 6 SEMANAS PS-PARTO', 'DEPRESSO PUERPERAL P76, HEMORRAGIA W17, QUEIXAS SOBRE O ALEITAMENTO W19, COMPLICAES W96', NULL, NULL, 'QUEIXAS RELACIONADAS COM PARTO E AT SEIS SEMANAS DE PUERPRIO', 1, 2, 15, 'queixas no parto e durante as 6 semanas pos-parto');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (623, 'GALACTORRIA, ABLACTAO, DESMAME', 'MASTITE PUERPERAL W94, MAMILOS RACHADOS W95', NULL, NULL, NULL, 1, 2, 15, 'galactorreia, ablactacao, desmame');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (624, NULL, NULL, NULL, NULL, NULL, 1, 2, 15, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (625, 'RECEIO DE MALFORMAES CONGNITAS NO BEB', 'SE A PACIENTE TEM COMPLICAES, CODIFIQUE-AS', NULL, NULL, 'PACIENTE QUE RECEIA COMPLICAES SEM AS TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 15, 'receio de malformacoes congenitas no bebe');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (626, 'INCAPACIDADE DEVIDA OU RELACIONADA COM A GRAVIDEZ OU COM INSTABILIDADE PLVICA', NULL, NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DA PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A OU RELACIONADA A GESTAO/ GRAVIDEZ', 1, 2, 15, 'incapacidade devida ou relacionada com a gravidez ou com instabilidade pelvica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (627, 'SINAL/SINTOMA SOBRE O PLANEJAMENTO FAMILIAR', NULL, NULL, NULL, NULL, 1, 2, 15, 'sinal/sintoma sobre o planejamento familiar');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (628, NULL, 'TTANO OBSTTRICO N72', NULL, NULL, 'INFECO DO CANAL DE NASCIMENTO OU DOS RGOS REPRODUTORES AT 6 SEMANAS PS-PARTO', 7, 3, 15, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (629, 'INFECES MATERNAS QUE COMPLICAM A GRAVIDEZ OU O PUERPRIO', 'INFECO PUERPERAL W70', NULL, NULL, NULL, 7, 3, 15, 'infeccoes maternas que complicam a gravidez ou o puerperio');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (630, 'CORIOEPITELIOMA, CORIOCARCINOMA', NULL, NULL, NULL, NULL, 7, 4, 15, 'corioepitelioma, coriocarcinoma');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (631, 'MOLA HIDATIFORME', NULL, NULL, NULL, NULL, 7, 4, 15, 'mola hidatiforme');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (632, 'CONSEQNCIAS DE TRAUMATISMOS QUE INTERFEREM COM A GRAVIDEZ', 'NOVO TRAUMATISMO CAUSADO PELO PARTO W92,W93', NULL, NULL, NULL, 7, 5, 15, 'consequencias de traumatismos que interferem com a gravidez');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (633, 'MALFORMAES MATERNAS QUE PODEM AFETAR A GRAVIDEZ OU O PARTO', NULL, NULL, NULL, NULL, 7, 6, 15, 'malformacoes maternas que podem afetar a gravidez ou o parto');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (634, 'GRAVIDEZ CONFIRMADA', 'GRAVIDEZ NO DESEJADA W79, GRAVIDEZ ECTPICA W80, GRAVIDEZ DE ALTO RISCO W84', NULL, NULL, NULL, 7, 7, 15, 'gravidez confirmada');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (707, 'NDULO NO TESTCULO, TESTCULO RETRTIL', 'DOR NO TESTCULO/ ESCROTO Y02', NULL, NULL, NULL, 1, 2, 17, 'nodulo no testiculo, testiculo retratil');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (708, 'PROSTATISMO', 'RETENO URINRIA U08', NULL, NULL, NULL, 1, 2, 17, 'prostatismo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (709, 'IMPOTNCIA DE ORIGEM ORGNICA', 'DIMINUIO DO DESEJO SEXUAL P07, DIMINUIO DA SATISFAO SEXUAL P08, IMPOTNCIA PSICOGNICA P08', NULL, NULL, NULL, 1, 2, 17, 'impotencia de origem organica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (710, 'PRIAPISMO', 'DIMINUIO DO DESEJO SEXUAL P07, DIMINUIO DA SATISFAO SEXUAL P08, IMPOTNCIA PSICOGNICA P08', NULL, NULL, NULL, 1, 2, 17, 'priapismo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (711, NULL, NULL, NULL, NULL, 'INCAPACIDADE DE ENGRAVIDAR APS DOIS ANOS DE TENTATIVAS', 1, 2, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (712, 'PLANEJAMENTO FAMILIAR ENVOLVENDO ESTERILIZAO MASCULINA, VASECTOMIA', NULL, NULL, NULL, NULL, 1, 2, 17, 'planejamento familiar envolvendo esterilizacao masculina, vasectomia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (713, 'CONTRACEPO NE, PLANEJAMENTO FAMILIAR NE, ACONSELHAMENTO GENTICO', 'ACONSELHAMENTO GENTICO A98', NULL, NULL, NULL, 1, 2, 17, 'contracepcao ne, planejamento familiar ne, aconselhamento genetico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (714, 'NDULO NA MAMA MASCULINA, GINECOMASTIA', 'DOENA DA MAMA MASCULINA Y99', NULL, NULL, NULL, 1, 2, 17, 'nodulo na mama masculina, ginecomastia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (715, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE PREOCUPADO COM UMA DISFUNO SEXUAL SEM A TER', 1, 2, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (716, NULL, 'MEDO DE HIV OU AIDS B25; SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE PREOCUPADO COM UMA DOENA VENREA SEM A TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (717, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE PREOCUPADO COM A POSSIBILIDADE DE TER CNCER SEM O TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (718, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE PREOCUPADO COM OUTRA DOENA GENITAL SEM A TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (719, NULL, 'DISFUNO SEXUAL P07,P08', NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA NO APARELHO REPRODUTOR MASCULINO (INCLUI MAMA)', 1, 2, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (722, 'GONORRIA QUALQUER QUE SEJA A SUA LOCALIZAO', NULL, 'URETRITE U72; SECREO URETRAL Y03', NULL, 'CORRIMENTO URETRAL OU RETAL COM DEMONSTRAO DE DIPLOCOCOS INTRACELULARES GRAM-NEGATIVOS OU CULTURA POSITIVA DE NEISSERIA GONORRIA', 7, 3, 17, 'gonorreia qualquer que seja a sua localizacao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (723, 'HERPES ANOGENITAL; HERPES GENITAL MASCULINO', NULL, NULL, NULL, 'PEQUENAS VESCULAS DE APARNCIA E LOCALIZAO CARACTERSTICAS QUE EVOLUEM PARA LCERAS DOLOROSAS E CROSTAS', 7, 3, 17, 'herpes anogenital; herpes genital masculino');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (724, NULL, NULL, NULL, NULL, 'PRSTATA OU VESCULAS SEMINAIS SENSVEIS  PALPAO E ANLISES  URINA COMPATVEIS COM INFLAMAO', 7, 3, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (725, NULL, 'CAXUMBA D71; TUBERCULOSE R70; GONORRIA Y71; TORO DOS TESTCULOS Y99', 'SINTOMAS DOS TESTCULOS Y05', NULL, 'EDEMA E SENSIBILIDADE DOS TESTCULOS OU EPIDDIMO E AUSNCIA DE UMA ETIOLOGIA ESPECFICA (CAXUMBA, GONORRIA, TUBERCULOSE, TRAUMA, OU TORO)', 7, 3, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (726, 'CANDIDASE', 'SFILIS Y70, GONORRIA Y71, HERPES Y72, ESCABIOSE S73', NULL, NULL, 'SINAIS DE INFLAMAO DO PREPCIO OU GLANDE', 7, 3, 17, 'candidiase');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (635, NULL, NULL, NULL, NULL, NULL, 7, 7, 15, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (636, NULL, NULL, 'HEMORRAGIA PR-PARTO W03, OUTROS SINTOMAS DURANTE A GRAVIDEZ W29', NULL, 'CONFIRMAO POR ECOGRAFIA, LAPAROSCOPIA, CULDOSCOPIA OU CIRURGIA', 7, 7, 15, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (637, 'ECLAMPSIA; HIPERTENSO, EDEMA, PROTEINRIA DURANTE A GRAVIDEZ; PR-ECLAMPSIA', NULL, 'OUTROS SINAIS OU SINTOMAS DURANTE A GRAVIDEZ W29', NULL, NULL, 7, 7, 15, 'eclampsia; hipertensao, edema, proteinuria durante a gravidez; pre-eclampsia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (638, 'ABORTO - AMEAA, COMPLETO, INCOMPLETO, RETIDO, HABITUAL', 'ABORTO PROVOCADO W83, HEMORRAGIA PR-PARTO W03, CONTRAES PREMATURAS DEPOIS DA 28 SEMANA DE GRAVIDEZ W92,W93, MORTE FETAL, NASCIDO MORTO APS A 28 SEMANA DE GRAVIDEZ W93', NULL, NULL, NULL, 7, 7, 15, 'aborto - ameaca, completo, incompleto, retido, habitual');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (639, 'INTERRUPO DA GRAVIDEZ, TODO O TIPO DE COMPLICAES', NULL, NULL, NULL, NULL, 7, 7, 15, 'interrupcao da gravidez, todo o tipo de complicacoes');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (640, 'PRIMPARA IDOSA; ANEMIA DA GRAVIDEZ; DIABETES OU OUTRA DOENA CRNICA ANTERIOR QUE AFETE A GRAVIDEZ; INCOMPATIBILIDADE FETO-PLVICA; HIDRMNIO; M POSIO DO FETO; GRAVIDEZ MLTIPLA; PLACENTA PRVIA; CESARIANA ANTERIOR; TRABALHOS DE PARTO PREMATUROS; ATRA', 'INFECES QUE COMPLICAM A GRAVIDEZ W71, GRAVIDEZ ECTPICA W80, TOXEMIA DA GRAVIDEZ W81, DIABETES GESTACIONAL W85', NULL, NULL, NULL, 7, 7, 15, 'primipara idosa; anemia da gravidez; diabetes ou outra doenca cronica anterior que afete a gravidez; incompatibilidade feto-pelvica; hidramnio; ma posicao do feto; gravidez multipla; placenta previa; cesariana anterior; trabalhos de parto prematuros; atra');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (641, 'DIABETES MANIFESTADA DURANTE A GRAVIDEZ', 'DIABETES ANTERIOR T89 OU T90', 'HIPERGLICEMIA A91', NULL, 'GLICOSE PLASMTICA EM JEJUM ACIMA DE 5.5 MMOL/L E/OU NVEL DE GLICOSE PLASMTICA SUPERIOR A 8.0 MMOL/L (140MG/DL) DUAS HORAS DEPOIS DE UM TESTE DE TOLERNCIA  GLICOSE ORAL (75G)', 7, 7, 15, 'diabetes manifestada durante a gravidez');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (642, 'TRABALHO DE PARTO, PARTO NORMAL NE', NULL, NULL, NULL, NULL, 7, 7, 15, 'trabalho de parto, parto normal ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (643, 'TRABALHO DE PARTO', NULL, NULL, NULL, NULL, 7, 7, 15, 'trabalho de parto');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (644, 'PARTO ASSISTIDO; PARTO PLVICO; CESARIANA; DISTOCIA; PARTO INDUZIDO; LESES CAUSADAS PELO PARTO; PLACENTA PRVIA DURANTE O PARTO; VERSO', 'HEMORRAGIA W17, ECLAMPSIA W81', NULL, NULL, NULL, 7, 7, 15, 'parto assistido; parto pelvico; cesariana; distocia; parto induzido; lesoes causadas pelo parto; placenta previa durante o parto; versao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (645, 'PARTO ASSISTIDO; PARTO PLVICO; CESARIANA; DISTOCIA; PARTO INDUZIDO; LESES CAUSADAS PELO PARTO;  PLACENTA PRVIA DURANTE O PARTO; VERSO', 'HEMORRAGIA W17, ECLAMPSIA W81', NULL, NULL, NULL, 7, 7, 15, 'parto assistido; parto pelvico; cesariana; distocia; parto induzido; lesoes causadas pelo parto;  placenta previa durante o parto; versao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (646, 'ABCESSO NA MAMA', 'MASTITE PUERPERAL NA AUSNCIA DE LACTAO X21', 'PROBLEMAS DA LACTAO W19', NULL, 'DOR, INFLAMAO DA MAMA NAS 6 SEMANAS APS O PARTO OU DURANTE O ALEITAMENTO', 7, 7, 15, 'abcesso na mama');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (647, 'PROBLEMAS DA MAMA DURANTE O PUERPRIO, MAMILO RACHADO', 'PROBLEMAS DA LACTAO W19; MASTITE W94; PROBLEMA NO RELACIONADO COM A GRAVIDEZ OU A LACTAO X21', NULL, NULL, NULL, 7, 7, 15, 'problemas da mama durante o puerperio, mamilo rachado');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (648, NULL, 'DEPRESSO PUERPERAL P76, INFECO PUERPERAL W70, TOXEMIA W81, PROBLEMAS DA MAMA W95', NULL, NULL, NULL, 7, 7, 15, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (649, NULL, 'PSEUDOCIESE P75', NULL, NULL, NULL, 7, 7, 15, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (650, 'DOR PLVICA, DOR VULVAR', 'DORES MENSTRUAIS X02, DISPAREUNIA X04, DOR NA MAMA X18', NULL, NULL, NULL, 1, 2, 16, 'dor pelvica, dor vulvar');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (651, 'DISMENORRIA', NULL, NULL, NULL, NULL, 1, 2, 16, 'dismenorreia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (652, 'MITTELSCHMERZ, DORES DURANTE A OVULAO', NULL, NULL, NULL, NULL, 1, 2, 16, 'mittelschmerz, dores durante a ovulacao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (653, 'DISPAREUNIA, VAGINISMO NE', 'PROBLEMAS SEXUAIS PSICOGNICOS P07,P08', NULL, NULL, NULL, 1, 2, 16, 'dispareunia, vaginismo ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (654, 'AMENORRIA, ATRASO MENSTRUAL, OLIGOMENORRIA', 'QUESTO SOBRE A GRAVIDEZ W01, MEDO DE GRAVIDEZ W02', NULL, NULL, NULL, 1, 2, 16, 'amenorreia, atraso menstrual, oligomenorreia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (655, 'MENORRAGIA', NULL, NULL, NULL, NULL, 1, 2, 16, 'menorragia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (656, 'POLIMENORRIA', 'MENORRAGIA X06, HEMORRAGIA PUBERTRIA X08', NULL, NULL, NULL, 1, 2, 16, 'polimenorreia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (657, 'HEMORRAGIA UTERINA DISFUNCIONAL, METRORRAGIA, HEMORRAGIA DURANTE A OVULAO, HEMORRAGIA PUBERTRIA, SPOTTING', 'HEMORRAGIA PS-MENOPAUSA X12, HEMORRAGIA PS-COITO X13', NULL, NULL, NULL, 1, 2, 16, 'hemorragia uterina disfuncional, metrorragia, hemorragia durante a ovulacao, hemorragia pubertaria, spotting');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (658, 'QUALQUER SINTOMA RELACIONADO COM O PERODO PR-MENSTRUAL', 'SNDROME DE TENSO PR-MENSTRUAL X89', NULL, NULL, NULL, 1, 2, 16, 'qualquer sintoma relacionado com o periodo pre-menstrual');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (659, NULL, NULL, NULL, NULL, 'ADIAMENTO DA MENSTRUAO GRAAS A UM TRATAMENTO HORMONAL', 1, 2, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (660, 'SINTOMAS RELACIONADOS COM A MENOPAUSA, SNDROME DA MENOPAUSA, VAGINITE ATRFICA, VAGINITE SENIL', 'HEMORRAGIA PS-MENOPAUSA X12', NULL, NULL, NULL, 1, 2, 16, 'sintomas relacionados com a menopausa, sindrome da menopausa, vaginite atrofica, vaginite senil');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (661, NULL, NULL, 'MENSTRUAO IRREGULAR X07', NULL, 'SANGRAMENTO VAGINAL APS PELO MENOS SEIS MESES DE AMENORRIA OU COMPROVAO DE MENOPAUSA EM TESTE LABORATORIAL APROPRIADO', 1, 2, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (662, 'HEMORRAGIA DE CONTATO', NULL, NULL, NULL, NULL, 1, 2, 16, 'hemorragia de contato');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (663, 'CORRIMENTO VAGINAL, LEUCORRIA', 'HEMORRAGIA X06 A X08, VAGINITE ATRFICA X11, GONORRIA X71, CANDIDASE UROGENITAL X72, TRICOMONASE UROGENITAL X73, CHLAMYDIA X92', NULL, NULL, NULL, 1, 2, 16, 'corrimento vaginal, leucorreia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (664, 'RESSECAMENTO', 'DORES GENITAIS X01, VAGINISMO ORGNICO X04, VAGINITE ATRFICA X11', NULL, NULL, NULL, 1, 2, 16, 'ressecamento');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (665, 'PRURIDO, RESSECAMENTO', 'DOR VULVAR X01, ABCESSO NA VULVA X99', NULL, NULL, NULL, 1, 2, 16, 'prurido, ressecamento');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (666, NULL, 'DORES GENITAIS X01', NULL, NULL, NULL, 1, 2, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (667, 'MASTODINIA', 'DURANTE A GRAVIDEZ OU LACTAO W19', NULL, NULL, NULL, 1, 2, 16, 'mastodinia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (669, 'SECREO DOS MAMILOS, FISSURA, DOR, PRURIDO, RETRAO', 'DURANTE A GRAVIDEZ OU LACTAO W19', NULL, NULL, NULL, 1, 2, 16, 'secrecao dos mamilos, fissura, dor, prurido, retracao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (670, 'MASTITE (NO PUERPERAL), MASTOPATIA, GALACTORRIA', 'MASTITE (PUERPERAL) W94', NULL, NULL, NULL, 1, 2, 16, 'mastite (nao puerperal), mastopatia, galactorreia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (671, NULL, NULL, NULL, NULL, NULL, 1, 2, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (672, NULL, 'SE A PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER UMA DOENA SEXUALMENTE TRANSMISSVEL SEM A TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (673, NULL, 'SE A PACIENTE TIVER DISFUNO SEXUAL P07 OU P08', NULL, NULL, 'PACIENTE QUE RECEIA UMA DISFUNO SEXUAL SEM A TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (674, NULL, 'SE A PACIENTE TIVER A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER UM CNCER DO APARELHO GENITAL SEM O TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (675, NULL, 'SE PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER UM CNCER DA MAMA SEM O TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (676, NULL, 'SE A PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER OUTRA DOENA GENITAL/DA MAMA SEM A TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (677, NULL, 'DISFUNO SEXUAL P07,P08; RELAES SEXUAIS DOLOROSAS X04, VAGINISMO X04', NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DA PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA NO APARELHO REPRODUTOR FEMININO (INCLUINDO MAMAS)', 1, 2, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (678, 'SECREO URETRAL NA MULHER', NULL, NULL, NULL, NULL, 1, 2, 16, 'secrecao uretral na mulher');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (679, 'SFILIS EM QUALQUER LOCALIZAO', NULL, NULL, NULL, 'EVIDNCIA DE TREPONEMA PALLIDUM AO MICROSCPIO, OU TESTE SOROLGICO POSITIVO PARA A SFILIS', 7, 3, 16, 'sifilis em qualquer localizacao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (680, 'GONORRIA EM QUALQUER LOCALIZAO', NULL, 'URETRITE U72; SECREO URETRAL X29', NULL, 'CORRIMENTO PURULENTO URETRAL OU VAGINAL, NUM CONTATO COM UM CASO DEMONSTRADO; OU DIPLOCOCOS INTRA-CELULARES GRAM-NEGATIVOS ENCONTRADOS NO CORRIMENTO; OU CULTURA DE NEISSERIA GONORRHEAE', 7, 3, 16, 'gonorreia em qualquer localizacao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (681, 'INFECO MONILIAL DA VAGINA OU DO COLO; AFTAS', NULL, 'SECREO VAGINAL X14; VAGINITE X84', NULL, 'MUCOSA UROGENITAL INFLAMADA OU PELE COM EXSUDADO BRANCO ADERENTE, CARACTERSTICO, OU EVIDNCIA DE CNDIDA', 7, 3, 16, 'infeccao monilial da vagina ou do colo; aftas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (682, NULL, NULL, 'SECREO VAGINAL X14; VAGINITE X84', NULL, 'CORRIMENTO COM MAU ODOR CARACTERSTICO OU EVIDNCIA DE TRICOMONAS AO MICROSCPIO', 7, 3, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (683, 'ENDOMETRITE; OOFORITE; SALPINGITE', 'DOENAS VENREAS X70-X73; INFECO POR CHLAMYDIA X92', 'SNDROME DE CONGESTO PLVICA X99', NULL, 'DORES NO ABDMEN INFERIOR, SENDO O TERO OU ANEXOS SENSVEIS  PALPAO, ALM DE OUTROS SINAIS DE INFLAMAO', 7, 3, 16, 'endometrite; ooforite; salpingite');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (600, NULL, NULL, NULL, 'PROBLEMAS COM O SISTEMA DE SEGURANA SOCIAL EXIGEM A MANIFESTAO DE PREOCUPAO POR PARTE DO PACIENTE, ASSIM COMO O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA. QUAISQUER QUE SEJAM AS CONDIES DE SEGURANA SOCIAL OBJETIVAS DO PACIENTE,', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (601, NULL, NULL, NULL, 'PROBLEMAS LEGAIS OU JURDICOS EXIGEM A MANIFESTAO DE PREOCUPAO POR PARTE DO PACIENTE, ASSIM COMO O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA. QUAISQUER QUE SEJAM AS QUESTES LEGAIS OBJETIVAS DO PACIENTE, ESTE PODE CONSIDER-LAS UM', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (602, NULL, NULL, NULL, 'PROBLEMAS COM O SISTEMA DE SADE EXIGEM A MANIFESTAO DE PREOCUPAO POR PARTE DO PACIENTE, ASSIM COMO O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA. QUAISQUER QUE SEJAM AS CONDIES DO SISTEMA DE SADE OBJETIVAS, O PACIENTE PODE CONSID', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (603, 'M ACEITAO', NULL, NULL, 'O DIAGNSTICO DE PROBLEMAS SOCIAIS DECORRENTES DO FATO DE SE ESTAR DOENTE REQUER O RECONHECIMENTO POR PARTE DO PACIENTE DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, 'ma aceitacao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (604, 'ABUSO EMOCIONAL', 'ABUSO FSICO Z25', NULL, 'O DIAGNSTICO DE PROBLEMAS RELACIONAIS ENTRE PARCEIROS REQUER O RECONHECIMENTO POR PARTE DO PACIENTE DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA.', NULL, 1, 2, 18, 'abuso emocional');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (684, NULL, 'CARCINOMA IN-SITU X81; NEOPLASIA CERVICAL INTRAEPITELIAL (CIN) GRAU 3 X81; ESFREGAO DE PAP ANORMAL X86; CIN GRAUS 1 E 2 X86', 'OUTRAS NEOPLASIAS MALIGNAS (QUANDO O LOCAL PRIMRIO  INCERTO) X77; NEOPLASIAS QUANDO NO H DADOS HISTOLGICOS DISPONVEIS X81', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (685, 'CARCINOMA-IN-SITU, CARCINOMA INTRADUCTAL', NULL, 'NDULO NA MAMA X19', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 16, 'carcinoma-in-situ, carcinoma intraductal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (686, 'MALIGNIDADE NOS OVRIOS, TERO, VAGINA, VULVA OU ZONAS ADJACENTES', 'CARCINOMA IN-SITU X81', 'NEOPLASIA GENITAL X80 QUANDO NO H DADOS HISTOLGICOS DISPONVEIS', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 16, 'malignidade nos ovarios, utero, vagina, vulva ou zonas adjacentes');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (687, 'TERO FIBROMIOMATOSO, FIBROMIOMA DO COLO; MIOMA', 'PLIPO CERVICAL (ADENOMATOSO) X80, PLIPO CERVICAL MUCOSO X85', NULL, NULL, 'AUMENTO DO TERO NO DEVIDO A GRAVIDEZ OU A MALIGNIDADE, COM UM OU MAIS TUMORES SLIDOS DO TERO', 7, 4, 16, 'utero fibromiomatoso, fibromioma do colo; mioma');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (688, 'FIBROADENOMA', 'DOENA FIBROCSTICA DA MAMA X88', 'NDULO NA MAMA X19', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 16, 'fibroadenoma');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (689, NULL, 'PLIPO DO COLO X85; CISTO FUNCIONAL DO OVRIO X99', NULL, NULL, NULL, 7, 4, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (690, 'CARCINOMA IN-SITU, NEOPLASIA CERVICAL INTRAEPITELIAL (CIN) DE GRAU 3 CONFIRMADA POR BIPSIA,  PLIPO ENDOMETRIAL', 'PLIPO ENDOMETRIAL X99', NULL, NULL, NULL, 7, 4, 16, 'carcinoma in-situ, neoplasia cervical intraepitelial (cin) de grau 3 confirmada por biopsia,  polipo endometrial');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (691, 'CORPO ESTRANHO NA VAGINA, CIRCUNCISO FEMININA', 'CAUSADA PELO PARTO W92, W93', NULL, NULL, NULL, 7, 5, 16, 'corpo estranho na vagina, circuncisao feminina');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (692, 'HERMAFRODITISMO, HMEN NO PERFURADO', 'OUTROS SNDROMES GENTICOS A90', NULL, NULL, NULL, 7, 6, 16, 'hermafroditismo, himen nao perfurado');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (693, 'VAGINOSE POR GARDNERELLA', 'CANDIDASE GENITAL X72; TRICOMONASE GENITAL X73; VAGINITE ATRFICA X11', NULL, NULL, NULL, 7, 7, 16, 'vaginose por gardnerella');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (694, 'DISPLASIA CERVICAL; EROSO CERVICAL; LEUCOPLASIA CERVICAL; CERVICITE; PLIPO CERVICAL MUCOSO; LACERAO ANTIGA', 'ANOMALIAS DO COLO DURANTE A GRAVIDEZ, PARTO E PUERPRIO W77; PLIPO ADENOMATOSO X78;  ESFREGAO DE PAP ANORMAL NE X86', NULL, NULL, NULL, 7, 7, 16, 'displasia cervical; erosao cervical; leucoplasia cervical; cervicite; polipo cervical mucoso; laceracao antiga');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (695, 'NEOPLASIA CERVICAL INTRAEPITELIAL (NIC) GRAUS I E II; NIC GRAU III NO DEMONSTRADA POR BIPSIA; DISPLASIA', 'NEOPLASIA CERVICAL INTRAEPITELIAL (NIC) DE GRAU III CONFIRMADA POR BIPSIA X81, CARCINOMA IN-SITU CONFIRMADO POR BIPSIA X81', NULL, NULL, NULL, 7, 7, 16, 'neoplasia cervical intraepitelial (nic) graus i e ii; nic grau iii nao demonstrada por biopsia; displasia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (696, 'CISTOCELE; RETOCELE; PROCIDNCIA', 'INCONTINNCIA DE ESFORO U04', NULL, NULL, NULL, 7, 7, 16, 'cistocele; retocele; procidencia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (697, 'DOENA FIBROCSTICA CRNICA DA MAMA, FIBROADENOSE CSTICA, DISPLASIA, CISTO DA MAMA', NULL, NULL, NULL, NULL, 7, 7, 16, 'doenca fibrocistica cronica da mama, fibroadenose cistica, displasia, cisto da mama');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (403, 'MCULAS, ERITEMA, VERMELHIDO EM VRIOS LOCAIS', 'ERUPO CUTNEA COM FEBRE A76, INCHAOS S06', NULL, NULL, NULL, 1, 2, 12, 'maculas, eritema, vermelhidao em varios locais');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (698, NULL, NULL, 'SINTOMA PR-MENSTRUAL X09', NULL, 'OCORRNCIA REGULAR NO CICLO MENSTRUAL DE PELO MENOS DOIS DOS SEGUINTES: EDEMA, MAMA SENSVEL OU INCHADA, DOR DE CABEA, IRRITABILIDADE, ALTERAES DE HUMOR', 7, 7, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (699, 'HERPES SIMPLES ANO-GENITAL', NULL, NULL, NULL, 'PEQUENAS VESCULAS COM APARNCIA E LOCALIZAO CARACTERSTICAS QUE ENVOLVE LCERAS DOLOROSAS E ESCARAS', 7, 3, 16, 'herpes simples ano-genital');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (700, 'VERRUGAS VENREAS, INFECO PELO VRUS PAPILOMA HUMANO', NULL, NULL, NULL, 'APARNCIA CARACTERSTICA DAS LESES OU HISTOLOGIA CARACTERSTICA', 7, 3, 16, 'verrugas venereas, infeccao pelo virus papiloma humano');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (701, NULL, NULL, NULL, NULL, 'INFECO POR CLAMDIA COMPROVADA', 7, 3, 16, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (702, 'CISTO OU ABCESSO DE BARTHOLIN; ENDOMETRIOSE; FSTULA DO APARELHO GENITAL; SNDROME DE CONGESTO PLVICA; CISTO FUNCIONAL DO OVRIO', 'DOENA SEXUALMENTE TRANSMISSVEL NE A78', NULL, NULL, NULL, 7, 7, 16, 'cisto ou abcesso de bartholin; endometriose; fistula do aparelho genital; sindrome de congestao pelvica; cisto funcional do ovario');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (703, NULL, 'PRIAPISMO, EREO DOLOROSA Y08', NULL, NULL, NULL, 1, 2, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (704, 'PERNEO, PLVIS', NULL, NULL, NULL, NULL, 1, 2, 17, 'perineo, pelvis');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (705, NULL, NULL, NULL, NULL, NULL, 1, 2, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (706, 'SINAIS/SINTOMAS DO PREPCIO', 'PRIAPISMO Y08', NULL, NULL, NULL, 1, 2, 17, 'sinais/sintomas do prepucio');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (582, 'VERRUGAS VENREAS; INFECO DO VRUS PAPILOMA HUMANO', NULL, NULL, NULL, 'APARNCIA CARACTERSTICA DE LESES, OU APARNCIA HISTOLGICA CARACTERSTICA', 7, 3, 17, 'verrugas venereas; infeccao do virus papiloma humano');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (583, NULL, NULL, 'NEOPLASIA BENIGNA/INCERTA (QUANDO NO H DADOS HISTOLGICOS DISPONVEIS) Y79', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (584, 'TESTCULOS, SEMINOMA, CARCINOMA MASCULINO DA MAMA', NULL, 'NEOPLASIA BENIGNA/INCERTA (QUANDO NO H DADOS HISTOLGICOS DISPONVEIS) Y79', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 17, 'testiculos, seminoma, carcinoma masculino da mama');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (585, 'NEOPLASIA GENITAL BENIGNA, NEOPLASIA GENITAL NO ESPECIFICADA COMO BENIGNA OU MALIGNA OU QUANDO A HISTOLOGIA NO EST DISPONVEL, NEOPLASIA BENIGNA NA MAMA MASCULINA, CARCINOMA IN-SITU', 'HIPERTROFIA PROSTTICA Y85', NULL, NULL, NULL, 7, 4, 17, 'neoplasia genital benigna, neoplasia genital nao especificada como benigna ou maligna ou quando a histologia nao esta disponivel, neoplasia benigna na mama masculina, carcinoma in-situ');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (586, 'CIRCUNCISO', NULL, NULL, NULL, NULL, 7, 5, 17, 'circuncisao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (587, 'PARAFIMOSE', NULL, NULL, NULL, 'PREPCIO REDUNDANTE: COMPRIMENTO EXCESSIVO DO PREPCIO, COM INCAPACIDADE DE RETRAO SOBRE A GLANDE', 7, 6, 17, 'parafimose');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (588, 'CRIPTORQUIDIA', 'TESTCULO RETRTIL Y05', NULL, NULL, 'O TESTCULO NUNCA FOI OBSERVADO NO ESCROTO, O TESTCULO NO  PALPVEL NO ESCROTO', 7, 6, 17, 'criptorquidia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (589, 'HERMAFRODITISMO', NULL, NULL, NULL, NULL, 7, 6, 17, 'hermafroditismo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (590, 'FIBROMA; HIPERPLASIA; BARRA MEDIANA PROSTTICA; OBSTRUO DA PRSTATA; PROSTATOMEGALIA', NULL, 'SINTOMAS, SINAIS DA MICO U01 A U05; RETENO DA URINA U08', NULL, 'PRSTATA AUMENTADA, LISA, DURA, REVELADA POR PALPAO, CISTOSCOPIA, OU IMAGIOLOGIA, SEM SINAIS DE CARCINOMA PROSTTICO', 7, 7, 17, 'fibroma; hiperplasia; barra mediana prostatica; obstrucao da prostata; prostatomegalia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (591, NULL, NULL, 'SINAIS/SINTOMAS DO ESCROTO OU DOS TESTCULOS U05', NULL, 'TUMEFAO FLUTUANTE NO DOLOROSA, NA ZONA DOS TESTCULOS OU DO CORDO ESPERMTICO COM TRANSILUMINAO DA TUMEFAO OU EVIDNCIA IMAGIOLGICA', 7, 7, 17, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (592, 'DOENA DA MAMA MASCULINA; CISTO EPIDIDIMAL; ESPERMATOCELE; TORO DO TESTCULO; OUTRA DOENA DOS GENITAIS MASCULINOS NE', 'DOENA SEXUALMENTE TRANSMISSVEL NE A78; GINECOMASTIA Y16; CARCINOMA DA MAMA MASCULINA Y78', NULL, NULL, NULL, 7, 7, 17, 'doenca da mama masculina; cisto epididimal; espermatocele; torcao do testiculo; outra doenca dos genitais masculinos ne');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (593, NULL, NULL, NULL, 'PROBLEMAS COM AS CONDIES DE VIDA EXIGEM A MANIFESTAO DE PREOCUPAO POR PARTE DO PACIENTE, ASSIM COMO O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA. QUAISQUER QUE SEJAM AS CONDIES DE VIDA OBJETIVAS DO PACIENTE, ESTE PODE CONSIDER-', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (594, NULL, NULL, NULL, 'PROBLEMAS COM AS CONDIES DE VIDA EXIGEM A MANIFESTAO DE PREOCUPAO POR PARTE DO PACIENTE, ASSIM COMO O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA. QUAISQUER QUE SEJAM AS CONDIES DE VIDA OBJETIVAS DO PACIENTE, ESTE PODE CONSIDER-', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (595, NULL, NULL, NULL, 'PROBLEMAS COM AS CONDIES DE VIDA EXIGEM A MANIFESTAO DE PREOCUPAO POR PARTE DO PACIENTE, ASSIM COMO O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA. QUAISQUER QUE SEJAM AS CONDIES DE VIDA OBJETIVAS DO PACIENTE, ESTE PODE CONSIDER-', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (596, 'GRAVIDEZ ILEGTIMA', 'GRAVIDEZ INDESEJADA W79', NULL, 'PROBLEMAS COM AS CONDIES DE VIDA EXIGEM A MANIFESTAO DE PREOCUPAO POR PARTE DO PACIENTE, ASSIM COMO O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA. QUAISQUER QUE SEJAM AS CONDIES DE VIDA OBJETIVAS DO PACIENTE, ESTE PODE CONSIDER-', NULL, 1, 2, 18, 'gravidez ilegitima');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (597, NULL, NULL, NULL, 'PROBLEMAS COM AS CONDIES DE VIDA EXIGEM A MANIFESTAO DE PREOCUPAO POR PARTE DO PACIENTE, ASSIM COMO O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA. QUAISQUER QUE SEJAM AS CONDIES DE VIDA OBJETIVAS DO PACIENTE, ESTE PODE CONSIDER-', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (598, NULL, 'PROBLEMAS DECORRENTES DE INOVAES E MUDANAS P25', NULL, 'PROBLEMAS RELACIONADOS COM O DESEMPREGO EXIGEM A MANIFESTAO DE PREOCUPAO POR PARTE DO PACIENTE, ASSIM COMO O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA. QUAISQUER QUE SEJAM AS CONDIES DE EMPREGO/DESEMPREGO OBJETIVAS DO PACIENTE, E', NULL, 1, 2, 18, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (599, 'ANALFABETISMO', NULL, NULL, 'PROBLEMAS RELACIONADOS COM A EDUCAO EXIGEM A MANIFESTAO DE PREOCUPAO POR PARTE DO PACIENTE, ASSIM COMO O RECONHECIMENTO DA EXISTNCIA DO PROBLEMA E UM DESEJO DE AJUDA. QUAISQUER QUE SEJAM AS QUALIFICAES DO PACIENTE, ESTE PODE CONSIDER-LAS UM PROB', NULL, 1, 2, 18, 'analfabetismo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (398, 'IRRITAO DA PELE', 'ANOGENITAL D05, DERMATITE ARTEFACTA S99, DA VULVA X16, DOS MAMILOS X20', NULL, NULL, NULL, 1, 2, 12, 'irritacao da pele');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (399, 'VERRUGAS VULGARES', 'MOLUSCO CONTAGIOSO S95, VERRUGA GENITAL X91, Y76', NULL, NULL, NULL, 1, 3, 12, 'verrugas vulgares');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (400, 'PPULA', 'PICADA DE INSETO S12; NDULO NA MAMA X19', NULL, NULL, NULL, 1, 2, 12, 'papula');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (401, 'PPULAS, TUMORES OU INCHAOS EM VRIOS LOCAIS', 'TORNOZELOS INCHADOS/EDEMA K07', NULL, NULL, NULL, 1, 2, 12, 'papulas, tumores ou inchacos em varios locais');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (402, 'MCULAS, ERITEMA, VERMELHIDO', 'INCHAOS S05', NULL, NULL, NULL, 1, 2, 12, 'maculas, eritema, vermelhidao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (404, 'OLHEIRAS, CIANOSE, RUBOR, SARDAS, PALIDEZ, PIGMENTAO', 'CONTUSO S16, VITILIGO S99', NULL, NULL, NULL, 1, 2, 12, 'olheiras, cianose, rubor, sardas, palidez, pigmentacao');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (405, 'PERONQUIA', 'PS-TRAUMTICA S11; TINEA S74; MONLIA, CNDIDA S75', NULL, NULL, NULL, 1, 3, 12, 'peroniquia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (406, 'ABCESSO; FURNCULO; FOLICULITE', 'LINFADENITE B70; PERIANAL D95; NO MEATO AUDITIVO EXTERNO H70; NO INTERIOR DO NARIZ R73; NO DEDO DA MO OU DO P INFECTADO, S09; FERIDA INFECTADA S11; ERISIPELA S76; ABCESSO PILONIDAL S85; HIDRADENITE S92; NOS GENITAIS EXTERNOS FEMININOS X99; NOS GENITAIS', NULL, NULL, NULL, 1, 3, 12, 'abcesso; furunculo; foliculite');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (407, 'INFECO PS-TRAUMTICA DE UMA FERIDA OU MORDEDURA', 'INFECO DE UMA FERIDA CIRRGICA A87; ERISIPELA S76; PIODERMIA S76; IMPETIGO S84', NULL, NULL, NULL, 1, 3, 12, 'infeccao pos-traumatica de uma ferida ou mordedura');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (408, 'HEMATOMA, EQUIMOSE', 'COM CORTE NA PELE S17', NULL, NULL, 'SUPERFCIE CUTNEA INTACTA', 1, 5, 12, 'hematoma, equimose');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (409, 'CONTUSO SE HOUVER SOLUO DE CONTINUIDADE; ESFOLADELA', NULL, NULL, NULL, NULL, 1, 5, 12, 'contusao se houver solucao de continuidade; esfoladela');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (410, 'PELE, TECIDOS SUBCUTNEOS', 'MORDEDURA S13', NULL, NULL, NULL, 1, 5, 12, 'pele, tecidos subcutaneos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (411, 'AVULSO DA UNHA, PICADA COM UMA AGULHA, PUNCTURA', 'MORDEDURA S13', NULL, NULL, NULL, 1, 5, 12, 'avulsao da unha, picada com uma agulha, punctura');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (412, 'PELE SECA, DESCAMAO, RUGAS', 'PROBLEMAS DE TRANSPIRAO A09, QUEIXAS DO COURO CABELUDO S24, PROBLEMAS DAS GLNDULAS SUDORPARAS S92, ICTIOSE S99, QUEIXAS DA VULVA X10', NULL, NULL, NULL, 1, 2, 12, 'pele seca, descamacao, rugas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (413, 'DILATAO DAS EXTREMIDADES DOS DEDOS', 'PERONQUIA S09, UNHA ENCRAVADA S94', NULL, NULL, NULL, 1, 2, 12, 'dilatacao das extremidades dos dedos');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (414, 'ALOPECIA', NULL, NULL, NULL, NULL, 1, 2, 12, 'alopecia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (415, 'COURO CABELUDO SECO, HIRSUTISMO', 'TRICOTILOMANIA P29, FOLICULITE S10, QUEDA DE CABELO/CALVCIE S23, CASPA S86', NULL, NULL, NULL, 1, 2, 12, 'couro cabeludo seco, hirsutismo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (416, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER CNCER DA PELE SEM O TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (417, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER OUTRA DOENA CUTNEA SEM A TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (418, 'INCAPACIDADE DEVIDA AO ESTADO DA PELE', NULL, NULL, 'OS QUADROS COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA NA PELE', 1, 2, 12, 'incapacidade devida ao estado da pele');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (419, 'PELE SANGRANDO, CELULITE, PETQUIAS, PROBLEMAS DO UMBIGO, LESO DA PELE, FERIMENTO(S)', 'CICATRIZ S99', NULL, NULL, NULL, 1, 2, 12, 'pele sangrando, celulite, petequias, problemas do umbigo, lesao da pele, ferimento(s)');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (420, 'NEVRALGIA PS-HERPTICA, ZONA', 'HERPES ZOSTER OFTLMICO F73', 'DOR CUTNEA S01, ERUPO CUTNEA S06', NULL, 'CONJUNTO DE ERUPES VESICULARES, DISTRIBUIO UNILATERAL NA REA DE UM NICO DERMATOMA', 7, 3, 12, 'nevralgia pos-herpetica, zona');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (421, 'HERPES SIMPLES', 'OLHO F85; INFECES GENITAIS X90,Y72', 'ERUPES CUTNEAS S06', NULL, 'VESCULAS COM BASE ERITEMATOSA NUMA REA LOCALIZADA; ALM DE HISTRIA DE LESES SEMELHANTES, OU EVIDNCIAS VIROLGICAS OU SEROLGICAS', 7, 3, 12, 'herpes simples');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (422, NULL, NULL, 'PRURIDO S02', NULL, 'LESES CUTNEAS COM PRURIDO INTENSO ALM DE UMA SRIA DE GALERIAS NAS PALMAS, DEDOS, PNIS OU DOBRAS DA PELE, OU EVIDNCIA DE PARASITAS OU OVOS NAS LESES', 7, 3, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (423, 'PULGAS, PIOLHOS, CAROS, CARRAPATOS/CARRAAS', 'MORDEDURAS DE INSETOS S12, MORDEDURAS DE INSETOS INFECTADAS S11', 'PRURIDO S02, ERUPES CUTNEAS S06', NULL, 'EVIDNCIA DE LNDEAS NO CABELO OU DE INSETOS NA PELE OU NA ROUPA', 7, 3, 12, 'pulgas, piolhos, acaros, carrapatos/carracas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (424, 'INFECO CUTNEA A FUNGOS, ONICOMICOSE, PITIRASE VERSICOLOR, TINHA', 'MONLIA, CNDIDA S75', NULL, NULL, 'LESES ESCAMOSAS E PRURIGINOSAS MAIS CLARAS NO CENTRO E PEQUENAS VESCULAS  VOLTA; OU EVIDNCIA DE FUNGO', 7, 3, 12, 'infeccao cutanea a fungos, onicomicose, pitiriase versicolor, tinha');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (425, 'LESES QUE ENVOLVEM AS UNHAS, REGIO PERIANAL, PELE; INTERTRIGO MONILIAL', 'AFTAS ORAIS D83, INFECES GENITAIS X72,Y75', NULL, NULL, NULL, 7, 3, 12, 'lesoes que envolvem as unhas, regiao perianal, pele; intertrigo monilial');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (426, 'CELULITE, ERISIPELA, PIODERMIA', 'FURNCULO, ANTRAZ, OUTRA INFECO CUTNEA LOCALIZADA S11; IMPETIGO S84; MOLUSCO CONTAGIOSO S95; ACNE S96', NULL, NULL, NULL, 7, 3, 12, 'celulite, erisipela, piodermia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (427, 'CARCINOMA DE CLULAS BASAIS (BASALIOMA), DOENA DE BOWEN, MELANOMA MALIGNO, ULCUS RODENS, CARCINOMA DE CLULAS ESCAMOSAS (ESPINOCELULAR)', 'LESES PR-MALIGNAS S79', 'OUTRAS NEOPLASIAS MALIGNAS (QUANDO A LOCALIZAO PRIMRIA  INCERTA) A79; NEOPLASIAS NO ESPECIFICADAS QUER BENIGNAS QUER MALIGNAS S79 (QUANDO NO H DADOS HISTOLGICOS DISPONVEIS)', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 12, 'carcinoma de celulas basais (basalioma), doenca de bowen, melanoma maligno, ulcus rodens, carcinoma de celulas escamosas (espinocelular)');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (428, NULL, NULL, NULL, NULL, NULL, 7, 4, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (429, 'CISTO DERMIDE, LESES PR-MALIGNAS', 'PLIPOS CUTNEOS HEMORROIDAIS RESIDUAIS K96; HIPERQUERATOSES S80; QUERATOSES SOLARES S80;  HEMANGIOMA S81; MANCHA NA PELE S82; NEVO PIGMENTADO S82; QUELIDE S99; VERRUGAS SEBORRICAS OU SENIS S99', NULL, NULL, NULL, 7, 4, 12, 'cisto dermoide, lesoes pre-malignas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (430, 'HIPERQUERATOSE, FOTOSSENSIBLIDADE, LESES CUTNEAS PROVOCADAS PELAS RADIAES, QUERATOSE SENIL, ERUPO POLIMRFICA LEVE', 'LESES CUTNEAS DEVIDO A RADIAES CRIADAS PELO HOMEM A87 OU A88', NULL, NULL, NULL, 7, 4, 12, 'hiperqueratose, fotossensiblidade, lesoes cutaneas provocadas pelas radiacoes, queratose senil, erupcao polimorfica leve');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (431, 'MARCA DE NASCIMENTO ANGIOMATOSA, MANCHA COR VINHO DO PORTO', NULL, 'INCHAO LOCALIZADO S04', NULL, 'TUMOR VASCULAR OU LINFTICO, QUE SE ELEVA ACIMA DA PELE E DIMINUI SOB PRESSO', 7, 6, 12, 'marca de nascimento angiomatosa, mancha cor vinho do porto');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (432, NULL, NULL, NULL, NULL, NULL, 7, 6, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (433, 'MARCA DE NASCENA; ICTIOSE', 'HEMANGIOMA, LINFANGIOMA S81', NULL, NULL, NULL, 7, 6, 12, 'marca de nascenca; ictiose');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (434, 'IMPETIGO SECUNDRIO A OUTRAS DERMATOSES', NULL, 'OUTRAS LESES CUTNEAS LOCALIZADAS S11', NULL, 'LESO CUTNEA CRESCENTE, CONSISTINDO EM MCULAS, VESCULAS, PSTULAS OU CROSTA COM UMA REA CIRCUNDANTE EM CARNE VIVA', 7, 3, 12, 'impetigo secundario a outras dermatoses');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (435, 'ABCESSO PILONIDAL', 'CISTO DERMIDE S79', NULL, NULL, NULL, 7, 7, 12, 'abcesso pilonidal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (470, 'NANISMO, CRETINISMO', 'CANAL TIREOGLOSSO (CISTO) T78', NULL, NULL, NULL, 7, 6, 13, 'nanismo, cretinismo');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (436, 'CROSTA LCTEA, CASPA', 'VERRUGAS SEBORRICAS S99', 'ERUPES CUTNEAS LOCALIZADAS S06, ERUPES CUTNEAS GENERALIZADAS S07', NULL, 'LESES OLEOSAS E ESCAMOSAS COM ERITEMA SUBJACENTE EM UMA OU MAIS REAS DO COURO CABELUDO, FACE, ESTERNO, ZONAS INTERESCAPULARES, EM VOLTA DO UMBIGO E NAS PREGAS DA PELE, NO ATRIBUVEIS A OUTRAS DOENAS CUTNEAS', 7, 7, 12, 'crosta lactea, caspa');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (437, 'ECZEMA INFANTIL, DERMATITE FLEXURAL', 'AFETANDO APENAS O MEATO AUDITIVO EXTERNO H70, DERMATITE ALRGICA S88, ERITEMA DAS FRALDAS S89', 'ERUPES CUTNEAS S06,S07; PRURIDO S02', NULL, 'LESES EXSUDATIVAS PRURIGINOSAS COM OU SEM LIQUENIFICAO NA FACE E NO PESCOO, PULSOS E MOS, TRAX, REGIO POPLTEA E SANGRADOURO', 7, 7, 12, 'eczema infantil, dermatite flexural');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (438, NULL, 'CRETINISMO T80', 'OUTRAS QUEIXAS DO METABOLISMO T29', NULL, 'EVIDNCIAS LABORATORIAIS DE DIMINUIO DA ATIVIDADE HORMONAL DA TIREIDE E EXCESSO DO HORMNIO ESTIMULANTE DA TIREIDE; OU QUATRO OU MAIS DOS SEGUINTES: FRAQUEZA, CANSAO, ALTERAES MENTAIS: APATIA, MEMRIA FRACA, LENTIDO; ALTERAES DA VOZ: MAIS ROUCA,', 7, 7, 13, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (439, 'DERMATITE ALRGICA, DERMATITE QUMICA, DERMATITE NE, ECZEMA NE, INTERTRIGO, PICADELA POR PLANTA, ALERGIA CUTNEA', 'ALERGIA NO ESPECIFICADA, REAO ALRGICA NO ESPECIFICADA A92; DERMATITE DE CONTATO E OUTRAS DERMATITES DAS PLPEBRAS F71; MEATO AUDITIVO EXTERNO H70; ECZEMA ATPICO S87; ERITEMA DAS FRALDAS S89; DERMATITE ARTEFACTA S99; URTICRIA S98; NEURODERMATITE S99', 'PRURIDO S02; ERUPES CUTNEAS S06,S07', NULL, 'LESES ERITEMATOSAS PRURIGINOSAS LIGADAS A UMA EXPOSIO A SUBSTNCIAS QUMICAS', 7, 7, 12, 'dermatite alergica, dermatite quimica, dermatite ne, eczema ne, intertrigo, picadela por planta, alergia cutanea');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (440, 'ERUPO CUTNEA PROVOCADA PELAS FRALDAS', NULL, NULL, NULL, 'DERMATITE, PRINCIPALMENTE NA ZONA DAS FRALDAS E DAS PREGAS, EM BEBS', 7, 7, 12, 'erupcao cutanea provocada pelas fraldas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (441, NULL, NULL, 'ERUPES CUTNEAS S06,S07', NULL, 'ERUPES OVAIS E ESCAMOSAS AO LONGO DAS LINHAS DE CLIVAGEM DA PELE DO TRONCO, COM HISTRIA DE UMA NICA LESO MAIOR QUE PRECEDE A ERUPO ATUAL', 7, 7, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (442, NULL, NULL, NULL, 'CODIFIQUE DUPLAMENTE A ARTRITE PSORITICA L99', 'MANCHAS DESCAMATIVAS PRATEADAS NOS JOELHOS, COTOVELOS OU COURO CABELUDO E/OU PICOTADO UNGUEAL', 7, 7, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (443, 'DESIDROSE; ERUPO PROVOCADA PELO CALOR; HIDRADENITE; MILIRIA; CALOR PRURIGINOSO; ERUPO PROVOCADA PELO SUOR; PONFLIGE', 'HIPERIDROSE A09', NULL, NULL, NULL, 7, 7, 12, 'desidrose; erupcao provocada pelo calor; hidradenite; miliaria; calor pruriginoso; erupcao provocada pelo suor; ponfolige');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (444, NULL, NULL, NULL, NULL, NULL, 7, 7, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (445, NULL, 'PERONQUIA S09', NULL, NULL, NULL, 7, 7, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (446, NULL, NULL, NULL, NULL, NULL, 7, 3, 12, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (447, 'PONTOS NEGROS, CRAVOS, ESPINHAS', 'PROVOCADO POR MEDICAO A85', NULL, NULL, NULL, 7, 7, 12, 'pontos negros, cravos, espinhas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (448, 'LCERA DE DECBITO, LCERA DE PRESSO, LCERA VARICOSA', 'GANGRENA K92', NULL, NULL, NULL, 7, 7, 12, 'ulcera de decubito, ulcera de pressao, ulcera varicosa');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (449, 'ERUPES DA PELE,VERGES', 'ALERGIA A DROGAS A85; ANGIOEDEMA, EDEMA ALRGICO A92', NULL, NULL, NULL, 7, 7, 12, 'erupcoes da pele,vergoes');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (450, 'DERMATITE ARTEFACTA; LUPUS ERITEMATOSO DISCIDE; ERITEMA MULTIFORME; ERITEMA NODOSO; GRANULOMA; GRANULOMA ANULAR; QUELIDE; QUERATOACANTOMA; LQUEN PLANO; NEURODERMATITE; ONICOGRIFOSE; ROSCEA; RINOFIMA; CICATRIZ; VERRUGAS SEBORRICAS OU SENIS; ESTRIAS AT', NULL, NULL, NULL, NULL, 7, 7, 12, 'dermatite artefacta; lupus eritematoso discoide; eritema multiforme; eritema nodoso; granuloma; granuloma anular; queloide; queratoacantoma; liquen plano; neurodermatite; onicogrifose; rosacea; rinofima; cicatriz; verrugas seborreicas ou senis; estrias at');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (451, 'POLIDIPSIA', NULL, NULL, NULL, NULL, 1, 2, 13, 'polidipsia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (452, 'COMER DE FORMA EXAGERADA, POLIFAGIA', 'BULIMIA P86', NULL, NULL, NULL, 1, 2, 13, 'comer de forma exagerada, polifagia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (453, 'ANOREXIA', 'ANOREXIA NERVOSA P86', NULL, NULL, NULL, 1, 2, 13, 'anorexia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (454, 'PROBLEMAS PARA COMER (O QUE E COMO)', 'ALERGIA A ALIMENTOS A98; CAUSAS PSICOLGICAS P11; PERTURBAES ALIMENTARES P11; INTOLERNCIA  COMIDA T99', NULL, NULL, NULL, 1, 2, 13, 'problemas para comer (o que e como)');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (455, 'PROBLEMAS PARA COMER (O QUE E COMO)', 'ALERGIA A ALIMENTOS A98; DISFAGIA D21; PERTURBAES ALIMENTARES DE ORDEM PSICOLGICA, RECUSA ALIMENTAR P29; ANOREXIA/BULIMIA NERVOSA P86; PERDA DE APETITE T03; INTOLERNCIA  COMIDA T99', NULL, NULL, NULL, 1, 2, 13, 'problemas para comer (o que e como)');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (456, NULL, 'OBESIDADE T82, EXCESSO DE PESO T83', NULL, NULL, NULL, 1, 2, 13, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (457, 'CAQUEXIA', 'ANOREXIA NERVOSA P86', NULL, NULL, NULL, 1, 2, 13, 'caquexia');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (458, 'CRIANA QUE NO CRESCE, ATRASO PSICOLGICO', 'ATRASO DE CRESCIMENTO P22; DIFICULDADES DE APRENDIZAGEM P24; ATRASO MENTAL P85; PUBERDADE ATRASADA T99', NULL, NULL, NULL, 1, 2, 13, 'crianca que nao cresce, atraso psicologico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (459, 'DEPLEO HDRICA', 'DEPLEO DE SAL T94, ALTERAES ELECTROLTICAS T94', NULL, NULL, NULL, 1, 2, 13, 'deplecao hidrica');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (460, NULL, 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'PACIENTE QUE RECEIA TER CNCER DO SISTEMA ENDCRINO SEM O TER OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 13, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (461, NULL, 'BEXIGA IRRITVEL, DORES NA BEXIGA U13; PROBLEMAS DOS RINS U14', NULL, NULL, NULL, 1, 2, 14, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (462, 'MEDO DE TER DIABETES', 'SE O PACIENTE TEM A DOENA, CODIFIQUE-A', NULL, NULL, 'RECEIO DE TER OUTRA DOENA ENDCRINA, METABLICA OU NUTRICIONAL NUM PACIENTE QUE NO A TEM OU AT O DIAGNSTICO SER CONFIRMADO', 1, 2, 13, 'medo de ter diabetes');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (463, 'LIMITAO FUNCIONAL/INCAPACIDADE RELACIONADA COM O SISTEMA ENDCRINO OU COM FATORES METABLICOS OU NUTRICIONAIS', NULL, NULL, 'AS TABELAS DA COOP/WONCA PERMITEM CODIFICAR O ESTADO FUNCIONAL DO PACIENTE (VER CAPTULO 8).', 'LIMITAO FUNCIONAL/ INCAPACIDADE DEVIDO A PROBLEMA NO SISTEMA ENDCRINO/ METABLICO/ NUTRICIONAL', 1, 2, 13, 'limitacao funcional/incapacidade relacionada com o sistema endocrino ou com fatores metabolicos ou nutricionais');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (464, 'DESEJO DE CERTO ALIMENTO, PICA, PESO INFERIOR AO NORMAL', 'HIPERGLICEMIA A91; RETENO DE FLUIDOS K07', NULL, NULL, NULL, 1, 2, 13, 'desejo de certo alimento, pica, peso inferior ao normal');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (465, NULL, 'TIREOIDITE T99', NULL, NULL, NULL, 7, 3, 13, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (466, NULL, NULL, 'BCIO T81, NEOPLASIA NO ESPECIFICADA T73', NULL, 'APARNCIA HISTOLGICA CARACTERSTICA', 7, 4, 13, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (467, NULL, 'BCIO T81, NEOPLASIA NO ESPECIFICADA T73', NULL, NULL, NULL, 7, 4, 13, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (468, 'OUTRA NEOPLASIA ENDCRINA NO ESPECIFICADA COMO BENIGNA OU MALIGNA OU QUANDO A HISTOLOGIA NO EST DISPONVEL', NULL, NULL, NULL, NULL, 7, 4, 13, 'outra neoplasia endocrina nao especificada como benigna ou maligna ou quando a histologia nao esta disponivel');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (469, NULL, 'BCIO T81', NULL, NULL, NULL, 7, 6, 13, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (471, 'NDULO DA TIREIDE, BCIO NO TXICO', 'NEOPLASIA DA GLNDULA TIREIDE T71-T73, BCIO TXICO T85, HIPOTIREOIDISMO T86', NULL, NULL, NULL, 7, 7, 13, 'nodulo da tireoide, bocio nao toxico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (472, NULL, 'EXCESSO DE PESO T83', NULL, NULL, 'NDICE DE MASSA CORPORAL SUPERIOR A 30', 7, 7, 13, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (473, NULL, 'OBESIDADE T82', NULL, NULL, 'NDICE DE MASSA CORPORAL SUPERIOR A 25 MAS INFERIOR A 30', 7, 7, 13, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (474, 'DOENA DE GRAVES, BCIO TXICO', 'BCIO NO TXICO T81', NULL, NULL, 'EVIDNCIAS LABORATORIAIS DE EXCESSO DE HORMNIOS DA TIREIDE; OU NDULO DA TIREIDE; OU BCIO E TREMOR, PERDA DE PESO, E PULSAO MUITO RPIDA (SUPERIOR A 100/MIN EM DESCANSO) OU SINAIS DOS OLHOS (EXOFTALMIA, PLPEBRAS QUE SE MOVEM MAIS LENTAMENTE DO QUE', 7, 7, 13, 'doenca de graves, bocio toxico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (475, 'HIPERINSULINISMO, COMA INSULNICO', NULL, NULL, NULL, 'HIPOGLICEMIA PROVADA POR TESTES BIOQUMICOS, OU SINTOMAS CARACTERSTICOS DE UM PACIENTE DIABTICO ALIVIADOS PELA INGESTO OU INJEO DE ACAR', 7, 7, 13, 'hiperinsulinismo, coma insulinico');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (476, 'DIABETES JUVENIL, DIABETES DO TIPO 1', '.', 'HIPERGLICEMIA A91; DIABETES, NO INSULINO-DEPENDENTE T90', '1.DOUBLE CODE COMPLICATIONS SUCH AS RETINOPATHY F83, NEPHROPATHY U882. IN PREGNANCY, DOUBLE CODE WITH W84', 'PACIENTE QUE NECESSITA DE TRATAMENTO REGULAR COM INSULINA APS UM DIAGNSTICO CONFIRMADO POR UM DOS SEGUINTES MEIOS:', 7, 7, 13, 'diabetes juvenil, diabetes do tipo 1');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (477, 'DIABETES NE, DIABETES COM INCIO TARDIO, DIABETES DE TIPO 2', 'HIPERGLICEMIA PROVOCADA POR MEDICAO A85, HIPERGLICEMIA COMO ACHADO ISOLADO A91', 'HIPERGLICEMIA A91; DIABETES, INSULINO-DEPENDENTE T89', '1. DOUBLE CODE COMPLICATIONS SUCH AS RETINOPATHY F83, NEPHROPATHY U88 2. IN PREGNANCY, DOUBLE CODE WITH W84', 'PACIENTE QUE NO NECESSITA DE TRATAMENTO REGULAR COM INSULINA APS UM DIAGNSTICO CONFIRMADO POR UM DOS MEIOS SEGUINTES:', 7, 7, 13, 'diabetes ne, diabetes com inicio tardio, diabetes de tipo 2');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (478, 'BERIBRI; DIETA DEFICIENTE DE MINERAIS; DEFICINCIA DE FERRO SEM ANEMIA; MALNUTRIO; MARASMO; ESCORBUTO', 'ANEMIA POR FALTA DE FERRO B80; ANEMIA; ANEMIA MEGALOBLSTICA (PERNICIOSA) B81; SINDROME DE M ABSORO, ESPRU, PSILOSE D99', NULL, NULL, '(A) SINTOMAS CLSSICOS DE DIABETES, COMO POLIRIA, POLIDIPSIA, PERDA RPIDA DE PESO, JUNTAMENTE COM AUMENTO INEQUVOCO DA GLICOSE PLASMTICA', 7, 7, 13, 'beriberi; dieta deficiente de minerais; deficiencia de ferro sem anemia; malnutricao; marasmo; escorbuto');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (479, NULL, 'GOTA PROVOCADA POR DROGAS A85; CIDO RICO ELEVADO A91; PSEUDO-GOTA E OUTRAS ARTROPATIAS POR CRISTAIS T99', NULL, NULL, '(B) NVEIS DE GLICOSE SANGUNEA EM JEJUM DE 8MMOL/L (L40MG/DL) OU SUPERIOR EM DUAS OU MAIS OCASIES', 7, 7, 13, NULL);
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (480, 'HIPERLIPIDEMIA; NVEIS ANORMAIS DE LIPOPROTENAS; NVEIS ELEVADOS DE COLESTEROL E TRIGLICERDEOS; XANTOMA', NULL, NULL, NULL, '(C) NVEIS DE GLICOSE SANGUNEA SEM SER EM JEJUM DE 11MMOL/L (200MG/DL) OU SUPERIOR EM DUAS OU MAIS OCASIES', 7, 7, 13, 'hiperlipidemia; niveis anormais de lipoproteinas; niveis elevados de colesterol e triglicerideos; xantoma');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (481, 'ACROMEGALIA; AMILOIDOSE; PERTURBAES METABLICAS CONGNITAS; ARTROPATIA A CRISTAIS; SNDROME DE CUSHING; FIBROSE CSTICA; DIABETES INSPIDA; SNDROME DE GILBERTS; HIPERALDOSTERONISMO; INTOLERNCIA  LACTOSE; OSTEOMALACIA; DISFUNO ADRENAL/OVRIA/ /PITUI', 'ALERGIA A ALIMENTOS A98; INTOLERNCIA  ALIMENTOS D99; OSTEOPOROSE L95', NULL, NULL, '(D) UM TESTE DE TOLERNCIA  GLICOSE ORAL (75MG GLICOSE) COM UM VALOR DE GLICOSE PLASMTICA ENTRE UMA A DUAS HORAS DE 11MMOL/L (200MG/DL) OU MAIS, E GLICOSE PLASMTICA EM DUAS HORAS DE 11MOL/L (200MG/DL) OU MAIS', 7, 7, 13, 'acromegalia; amiloidose; perturbacoes metabolicas congenitas; artropatia a cristais; sindrome de cushing; fibrose cistica; diabetes insipida; sindrome de gilberts; hiperaldosteronismo; intolerancia a lactose; osteomalacia; disfuncao adrenal/ovaria/ /pitui');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (482, 'MICO COM ARDOR', 'MICO FREQENTE/URGENTE U02, SNDROME URETRAL U72', NULL, NULL, NULL, 1, 2, 14, 'miccao com ardor');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (483, 'NOCTRIA, POLIRIA', NULL, NULL, NULL, NULL, 1, 2, 14, 'nocturia, poliuria');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (484, 'ENURESE DE ORIGEM ORGNICA, MICO INVOLUNTRIA, INCONTINNCIA PROVOCADA PELO STRESS', 'DE ORIGEM PSICOLGICA P12', NULL, NULL, NULL, 1, 2, 14, 'enurese de origem organica, miccao involuntaria, incontinencia provocada pelo stress');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (485, 'ANRIA, OLIGRIA, URINA EM GOTAS', 'RETENO URINRIA U08', NULL, NULL, NULL, 1, 2, 14, 'anuria, oliguria, urina em gotas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (486, 'SANGUE NA URINA, ANLISES MACROSCPICAS, MICROSCPICAS OU QUMICAS POSITIVAS', NULL, NULL, NULL, 'SANGUE NA URINA COMPROVADO POR TESTE MACROSCPICO, MICROSCPICO OU BIOQUMICO', 1, 2, 14, 'sangue na urina, analises macroscopicas, microscopicas ou quimicas positivas');
INSERT INTO social.tb_ciap_ms (co_ciap, ds_inclusao, ds_exclusao, ds_criterio, ds_nota, ds_definicao, co_ciap_componente, tp_ciap, co_ciap_capitulo, ds_inclusao_filtro) VALUES (9, 'ACONSELHAMENTO/PROCEDIMENTO MDICO COM O PROPSITO PREVENTIVO, INCLUINDO ACONSELHAMENTO GENTICO', 'SEM DOENA A97', NULL, NULL, NULL, 7, 7, 2, 'aconselhamento/procedimento medico com o proposito preventivo, incluindo aconselhamento genetico');