ALTER TABLE usuario
   ADD COLUMN usr_codigo bigint;
COMMENT ON COLUMN usuario.usr_codigo IS 'Quem Fez o cadastro';
ALTER TABLE atendimento ADD COLUMN ate_outros boolean;
ALTER TABLE atendimento ALTER COLUMN ate_outros SET NOT NULL;
ALTER TABLE atendimento ALTER COLUMN ate_outros SET DEFAULT false;

ALTER TABLE geladeira ADD COLUMN gel_data_cadastro timestamp with time zone;
ALTER TABLE geladeira ADD COLUMN usr_codigo bigint;
ALTER TABLE geladeira DROP COLUMN gel_data_cadastro;
ALTER TABLE geladeira ADD COLUMN gel_data_cadastro timestamp without time zone;

COMMENT ON COLUMN temperatura_geladeira.temp_periodo IS '1 => Madrugada
2 => Manha
3 => Tarde
4 => Noite';


ALTER TABLE pre_consulta ADD COLUMN pc_hora_final timestamp without time zone;

CREATE TABLE retorno
(
   ret_codigo bigserial, 
   ate_codigo_origem integer, 
   ate_codigo integer, 
   pc_codigo integer, 
    PRIMARY KEY (ret_codigo), 
    FOREIGN KEY (ate_codigo_origem) REFERENCES atendimento (ate_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
    FOREIGN KEY (ate_codigo) REFERENCES atendimento (ate_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
    FOREIGN KEY (pc_codigo) REFERENCES pre_consulta (pc_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;

COMMENT ON COLUMN atendimento.ate_encaminhamento IS 'S = ENCAMINHADO PARA RETORNO
N = RETORNO FINALIZADO
NULL = ATENDIMENTO SEM RETORNO';

COMMENT ON COLUMN agendamento.age_atendido IS 'S - Recepcionado
A - Atendido
N - Agendado
T - Transferido
F - Faltoso
E - Em atendimento
I - Atendimento Incluso';




