UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.123.122' WHERE conf_chave='VERSAO_SAUDE';



CREATE OR REPLACE FUNCTION social.operacoesodontobpa()
  RETURNS trigger AS
$BODY$
DECLARE 
linha RECORD;
ciCodigo bigint;  
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM bpa WHERE bpa_origem = 'odontograma' AND bpa_origem_codigo = OLD.odo_preal_codigo;
		RETURN OLD;
		-- Procedimento e BPA excluido com sucesso
	ELSE 
		FOR linha IN	
		SELECT 
			odpr.odo_preal_codigo,
			odpr.odo_preal_dtcadastro,
			proc.proc_codigo,
			proc.proc_bpa_tipo,
			ate.uni_codigo,
			ate.med_codigo,
			ate.usu_codigo,
			age.esp_codigo
		FROM 
			odonto_procedimentos_realizados AS odpr
		INNER JOIN 
			procedimento AS proc ON odpr.proc_codigo = proc.proc_codigo
		INNER JOIN 
			odonto_procedimentos_controle AS odpc ON odpr.odo_pcon_codigo = odpc.odo_pcon_codigo
		INNER JOIN
			atendimento AS ate ON odpc.ate_codigo = ate.ate_codigo
		INNER JOIN agendamento AS age
					ON age.age_codigo = ate.age_codigo
		WHERE 
			odpr.odo_preal_codigo = NEW.odo_preal_codigo  LOOP
			-- Operao de Insert
			
			SELECT ci.ci_cod FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
			
			IF (TG_OP = 'INSERT') THEN
				INSERT 	INTO bpa
							(bpa_data, uni_codigo,usr_codigo,usu_codigo,proc_codigo,ci_codigo,bpa_tipo,bpa_origem,bpa_origem_codigo,bpa_ativo,bpa_data_alt,esp_codigo)
						VALUES
							(linha.odo_preal_dtcadastro,linha.uni_codigo,linha.med_codigo,linha.usu_codigo,linha.proc_codigo,ciCodigo,linha.proc_bpa_tipo,'odontograma',linha.odo_preal_codigo,'t',linha.odo_preal_dtcadastro,linha.esp_codigo);
				RETURN NEW;
				-- Procedimento e BPA inserido com sucesso!
			END IF;
			-- Operao de Update
			IF (TG_OP = 'UPDATE') THEN
				UPDATE bpa
					SET 
						uni_codigo = linha.uni_codigo,
						usr_codigo = linha.med_codigo,
						usu_codigo = linha.usu_codigo,
						proc_codigo = linha.proc_codigo,
						ci_codigo = ciCodigo,
						bpa_tipo = linha.proc_bpa_tipo,
						bpa_origem = 'odontograma',
						bpa_origem_codigo = linha.odo_preal_codigo,
						bpa_ativo = 't',
						bpa_data_alt = linha.odo_preal_dtcadastro,
						esp_codigo = linha.esp_codigo
					WHERE
						bpa_origem = 'odontograma' AND
						bpa_origem_codigo = linha.odo_preal_codigo;
				RETURN NEW;
				-- Procedimento e BPA atualizado com sucesso!
			END IF;
		END LOOP;
	END IF;
END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION operacoesodontobpa()
  OWNER TO postgres;
  
  
-- Function: esus_cadastro_individual()

-- DROP FUNCTION esus_cadastro_individual();

CREATE OR REPLACE FUNCTION social.esus_cadastro_individual()
  RETURNS trigger AS
$BODY$
DECLARE 
	usu_codigo_conf bigint;
	eci_sexo character(20);
	eci_raca character(20);
	eci_nacionalidade character(20);
	eci_exportado integer;
	linha RECORD;
BEGIN 
	IF (TG_OP='DELETE') THEN
		DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
		RAISE NOTICE 'DELETE''.';				 
	ELSE
		FOR linha IN 
			SELECT 
				usu.usu_codigo, 
				uni.uni_cnes AS eci_cnes,
				usr.cnes_cod_cns AS eci_usr_cns,
				uni.uni_codigo_ibge AS eci_usr_codigo_ibge,
				usu.usu_data_cad AS eci_dtatendimento,
				cid.cid_codigo_ibge AS eci_usu_codigo_ibge,
				usu.usu_datanasc AS eci_usu_dtnascimento,
				usu.cd_nacionalidade AS eci_usu_nacionalidade,
				usu.usu_nome AS eci_usu_nome,
				usu.usu_mae AS eci_usu_mae,
				usu.rac_codigo AS eci_usu_raca,
				usu.usu_sexo AS eci_usu_sexo,
				usu.usu_freq_escolar AS eci_usu_escola,
				usu.usu_deficiencia AS eci_usu_deficiencia,
				usu.usu_sit_rua AS eci_usu_sit_rua,
				usu.usu_cartao_sus AS eci_usu_cns
			FROM 
				usuario AS usu
			INNER JOIN 
				usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
			INNER JOIN
				unidade AS uni ON usu.uni_codigo=uni.uni_codigo
			JOIN 
				cidade AS cid ON usu.cid_codigo_nasc=cid.cid_codigo 
			WHERE
				usu.usu_codigo = NEW.usu_codigo LOOP
				-- Validao de sexo
				IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
				-- Validao nacionalidade
				IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
				IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '2 L'; END IF;
				IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '3 L'; END IF;
				-- Validao Raa
				IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
				IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
				IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
				IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
				IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
				IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
				SELECT count(*) into eci_exportado from esus_cadastro_individual where usu_codigo = NEW.usu_codigo;
				IF (TG_OP='UPDATE' AND eci_exportado > 0) THEN
					
					
						UPDATE esus_cadastro_individual SET
								eci_usr_cnes = linha.eci_cnes,
								eci_usr_profissional_cns = linha.eci_usr_cns,
								eci_usr_codigo_ibge = linha.eci_usr_codigo_ibge,
								eci_usr_dtatendimento = linha.eci_dtatendimento,
								eci_usu_codigo_ibge = linha.eci_usu_codigo_ibge,
								eci_usu_dtnascimento = linha.eci_usu_dtnascimento,
								eci_usu_nacionalidade = eci_nacionalidade,
								eci_usu_nome = linha.eci_usu_nome,
								eci_usu_mae = linha.eci_usu_mae,
								eci_usu_raca = eci_raca,
								eci_usu_sexo = eci_sexo,
								eci_usu_escola = linha.eci_usu_escola,
								eci_usu_deficiencia = linha.eci_usu_deficiencia,
								eci_usu_cns = linha.eci_usu_cns,
								eci_usu_sit_rua = linha.eci_usu_sit_rua,
								uuid_ficha = ''
							WHERE
								usu_codigo = OLD.usu_codigo;
						RAISE NOTICE 'UPDATE''.';
					 
				ELSE
					-- INSERO
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_usr_codigo_ibge,
						linha.eci_dtatendimento,
						linha.eci_usu_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua);
				END IF;				
			END LOOP;
		RAISE NOTICE 'INSERT''.';				 
	END IF;
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION esus_cadastro_individual()
  OWNER TO postgres;
  
ALTER TABLE social.agendamento
ADD usr_cod_atendendo bigint
  
