UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.127.126' WHERE conf_chave='VERSAO_SAUDE';

ALTER TABLE microarea RENAME area_codigo TO co_seq_equipe;
ALTER TABLE microarea DROP CONSTRAINT "$1";
ALTER TABLE microarea DROP CONSTRAINT microarea_mic_descricao_key;
ALTER TABLE microarea ADD COLUMN ativo BOOLEAN;
ALTER TABLE microarea ALTER COLUMN ativo SET DEFAULT TRUE;

CREATE OR REPLACE FUNCTION attEspCodigoNaBpa()
  RETURNS integer AS
$BODY$
DECLARE 
	linha RECORD;
	cont integer = 0;
BEGIN
	FOR linha IN
		SELECT  b.bpa_codigo,
			b.esp_codigo,
			b.usr_codigo,
			ag.esp_codigo as age_esp,
			ag.med_codigo as age_med
		FROM bpa b
		INNER JOIN procedimento_atendimento pa ON b.bpa_origem_codigo = pa.pat_codigo AND b.bpa_origem = 'procedimento_atendimento'
		INNER JOIN atendimento a ON a.ate_codigo = pa.ate_codigo
		INNER JOIN agendamento ag ON ag.age_codigo = a.age_codigo
		INNER JOIN especialidade e ON e.esp_codigo = b.esp_codigo
		WHERE b.usr_codigo = ag.med_codigo 
		     AND b.esp_codigo != ag.esp_codigo
		ORDER BY b.bpa_codigo desc
	LOOP
		cont := cont+1;
		UPDATE bpa
			SET esp_codigo = linha.age_esp
		WHERE bpa_codigo = linha.bpa_codigo;
	END LOOP;
	RETURN cont;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

SELECT attEspCodigoNaBpa();