UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.128.127.1' WHERE conf_chave='VERSAO_SAUDE';
UPDATE config SET conf_valor_string = 'Compatível com a versão PEC: 2.1.06 do e-SUS' WHERE conf_chave='VERSAO_ESUS';

ALTER TABLE atendimento ADD COLUMN turno integer;

ALTER TABLE tb_cds_ficha_ativ_col  ADD COLUMN turno integer;

ALTER TABLE atendimento  ADD COLUMN st_fora_area boolean;

CREATE TABLE social.tb_cds_tipo_imovel
(
  co_cds_tipo_imovel bigint NOT NULL,
  no_cds_tipo_imovel character varying(255),
  no_identificador character varying(255),
  CONSTRAINT pk_cdstipoimovel PRIMARY KEY (co_cds_tipo_imovel)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE social.tb_cds_tipo_imovel
  OWNER TO postgres;
  
  
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (1, '01 - DOMICÍLIO', 'DOMICILIO');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (2, '02 - COMÉRCIO', 'COMERCIO');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (3, '03 - TERRENO BALDIO', 'TERRENO_BALDIO');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (4, '04 - PONTO ESTRATÉGICO (CEMITÉRIO, BORRACHARIA, FERRO-VELHO, DEPÓSITO DE SUCATA OU MATERIAIS DE CONSTRUÇÃO, GARAGEM DE ÔNIBUS OU VEÍCULO DE GRANDE PORTE)', 'PONTO_ESTRATEGICO');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (5, '05 - ESCOLA', 'ESCOLA');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (6, '06 - CRECHE', 'CRECHE');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (7, '07 - ABRIGO', 'ABRIGO');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (8, '08 - INSTITUIÇÃO DE LONGA PERMANÊNCIA PARA IDOSOS', 'INSTITUICAO_LONGA_PERMANENCIA_PARA_IDOSOS');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (9, '09 - UNIDADE PRISIONAL', 'UNIDADE_PRISIONAL');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (10, '10 - UNIDADE DE MEDIDA SOCIOEDUCATIVA', 'UNIDADE_MEDIDA_SOCIOEDUCATIVA');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (11, '11 - DELEGACIA', 'DELEGACIA');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (12, '12 - ESTABELECIMENTO RELIGIOSO', 'ESTABELECIMENTO_RELIGIOSO');
INSERT INTO social.tb_cds_tipo_imovel (co_cds_tipo_imovel, no_cds_tipo_imovel, no_identificador) VALUES (99, '99 - OUTROS', 'OUTROS');  


ALTER TABLE usuario ADD COLUMN usu_tem_diabete BOOLEAN;
ALTER TABLE usuario ADD COLUMN usu_esta_gestante BOOLEAN;
ALTER TABLE usuario ADD COLUMN usu_tem_hipertensao BOOLEAN;

ALTER TABLE usuario ALTER COLUMN usu_celular SET DATA TYPE VARCHAR(17);
ALTER TABLE usuario ALTER COLUMN usu_fone SET DATA TYPE VARCHAR(17);


CREATE TABLE social.rl_ate_tipo_imovel
(
  ati_codigo bigint NOT NULL DEFAULT nextval(('ati_codigo_seq'::text)::regclass),
  no_cds_tipo_imovel bigint,
  ate_codigo bigint,
  CONSTRAINT pk_ati_codigo PRIMARY KEY (ati_codigo)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rl_ate_tipo_imovel
  OWNER TO postgres;

CREATE SEQUENCE "ati_codigo_seq"
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE "rl_ate_tipo_imovel"
  OWNER TO postgres;

ALTER TABLE domicilio ADD COLUMN tipo_imovel integer;


ALTER TABLE estado ADD COLUMN uf_cod_esus varchar(2);
update estado set uf_cod_esus = '01' where uf_sigla = 'AC';
update estado set uf_cod_esus = '02' where uf_sigla = 'AL';
update estado set uf_cod_esus = '03' where uf_sigla = 'AP';
update estado set uf_cod_esus = '04' where uf_sigla = 'AM';
update estado set uf_cod_esus = '05' where uf_sigla = 'BA';
update estado set uf_cod_esus = '06' where uf_sigla = 'CE';
update estado set uf_cod_esus = '07' where uf_sigla = 'DF';
update estado set uf_cod_esus = '08' where uf_sigla = 'ES';
update estado set uf_cod_esus = '10' where uf_sigla = 'GO';
update estado set uf_cod_esus = '11' where uf_sigla = 'MA';
update estado set uf_cod_esus = '12' where uf_sigla = 'MT';
update estado set uf_cod_esus = '13' where uf_sigla = 'MS';
update estado set uf_cod_esus = '14' where uf_sigla = 'MG';
update estado set uf_cod_esus = '15' where uf_sigla = 'PA';
update estado set uf_cod_esus = '16' where uf_sigla = 'PB';
update estado set uf_cod_esus = '17' where uf_sigla = 'PR';
update estado set uf_cod_esus = '18' where uf_sigla = 'PE';
update estado set uf_cod_esus = '19' where uf_sigla = 'PI';
update estado set uf_cod_esus = '20' where uf_sigla = 'RJ';
update estado set uf_cod_esus = '21' where uf_sigla = 'RN';
update estado set uf_cod_esus = '22' where uf_sigla = 'RS';
update estado set uf_cod_esus = '23' where uf_sigla = 'RO';
update estado set uf_cod_esus = '09' where uf_sigla = 'RR';
update estado set uf_cod_esus = '25' where uf_sigla = 'SC';
update estado set uf_cod_esus = '26' where uf_sigla = 'SP';
update estado set uf_cod_esus = '27' where uf_sigla = 'SE';
update estado set uf_cod_esus = '24' where uf_sigla = 'TO';



ALTER TABLE esus_cadastro_individual ADD COLUMN uuid_ficha_ori varchar;

-- Function: esus_cadastro_individual()

-- DROP FUNCTION esus_cadastro_individual();

CREATE OR REPLACE FUNCTION esus_cadastro_individual()
  RETURNS trigger AS
$BODY$
DECLARE 
	usu_codigo_conf bigint;
	eci_sexo character(20);
	eci_raca character(20);
	eci_nacionalidade character(20);
	eci_exportado integer;
	linha RECORD;
BEGIN 
	IF (TG_OP='DELETE') THEN
		DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
		RAISE NOTICE 'DELETE''.';				 
	ELSE
		FOR linha IN 
			SELECT 
				usu.usu_codigo, 
				uni.uni_cnes AS eci_cnes,
				usr.cnes_cod_cns AS eci_usr_cns,
				uni.uni_codigo_ibge AS eci_usr_codigo_ibge,
				usu.usu_data_cad AS eci_dtatendimento,
				cid.cid_codigo_ibge AS eci_usu_codigo_ibge,
				usu.usu_datanasc AS eci_usu_dtnascimento,
				usu.cd_nacionalidade AS eci_usu_nacionalidade,
				usu.usu_nome AS eci_usu_nome,
				usu.usu_mae AS eci_usu_mae,
				usu.rac_codigo AS eci_usu_raca,
				usu.usu_sexo AS eci_usu_sexo,
				usu.usu_freq_escolar AS eci_usu_escola,
				usu.usu_deficiencia AS eci_usu_deficiencia,
				usu.usu_sit_rua AS eci_usu_sit_rua,
				usu.usu_cartao_sus AS eci_usu_cns
			FROM 
				usuario AS usu
			INNER JOIN 
				usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
			INNER JOIN
				unidade AS uni ON usu.uni_codigo=uni.uni_codigo
			JOIN 
				cidade AS cid ON usu.cid_codigo_nasc=cid.cid_codigo 
			WHERE
				usu.usu_codigo = NEW.usu_codigo LOOP
				-- Validação de sexo
				IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
				-- Validação nacionalidade
				IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
				IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '2 L'; END IF;
				IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '3 L'; END IF;
				-- Validação Raça
				IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
				IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
				IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
				IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
				IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
				IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
				SELECT count(*) into eci_exportado from esus_cadastro_individual where usu_codigo = NEW.usu_codigo;
				IF (TG_OP='UPDATE' AND eci_exportado > 0) THEN
													
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua,
						uuid_ficha_ori)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_usr_codigo_ibge,
						linha.eci_dtatendimento,
						linha.eci_usu_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua,
						(select uuid_ficha 
						 from esus_cadastro_individual 
						 where usu_codigo = linha.usu_codigo
						 order by eci_codigo asc 
						 limit 1));	
								
						RAISE NOTICE 'UPDATE''.';
					 
				ELSE
					-- INSERÇÃO
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_usr_codigo_ibge,
						linha.eci_dtatendimento,
						linha.eci_usu_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua);
				END IF;				
			END LOOP;
		RAISE NOTICE 'INSERT''.';				 
	END IF;
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION esus_cadastro_individual()
  OWNER TO postgres;





