UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.129.128' WHERE conf_chave='VERSAO_SAUDE';

ALTER TABLE atendimento ADD COLUMN neces_especial boolean;
ALTER TABLE atendimento ADD COLUMN gestante boolean;


CREATE OR REPLACE FUNCTION social.esus_cadastro_individual()
  RETURNS trigger AS
$BODY$
DECLARE 
	usu_codigo_conf bigint;
	eci_sexo character(20);
	eci_raca character(20);
	eci_nacionalidade character(20);
	eci_exportado integer;
	linha RECORD;
BEGIN 
	IF (TG_OP='DELETE') THEN
		DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
		RAISE NOTICE 'DELETE''.';				 
	ELSE
		FOR linha IN 
			SELECT 
				usu.usu_codigo, 
				uni.uni_cnes AS eci_cnes,
				usr.cnes_cod_cns AS eci_usr_cns,
				uni.uni_codigo_ibge AS eci_usr_codigo_ibge,
				usu.usu_data_cad AS eci_dtatendimento,
				cid.cid_codigo_ibge AS eci_usu_codigo_ibge,
				usu.usu_datanasc AS eci_usu_dtnascimento,
				usu.cd_nacionalidade AS eci_usu_nacionalidade,
				usu.usu_nome AS eci_usu_nome,
				usu.usu_mae AS eci_usu_mae,
				usu.rac_codigo AS eci_usu_raca,
				usu.usu_sexo AS eci_usu_sexo,
				usu.usu_freq_escolar AS eci_usu_escola,
				usu.usu_deficiencia AS eci_usu_deficiencia,
				usu.usu_sit_rua AS eci_usu_sit_rua,
				usu.usu_cartao_sus AS eci_usu_cns
			FROM 
				usuario AS usu
			INNER JOIN 
				usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
			INNER JOIN
				unidade AS uni ON usu.uni_codigo=uni.uni_codigo
			JOIN 
				cidade AS cid ON usu.cid_codigo_nasc=cid.cid_codigo 
			WHERE
				usu.usu_codigo = NEW.usu_codigo LOOP
				-- Validação de sexo
				IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
				-- Validação nacionalidade
				IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
				IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '2 L'; END IF;
				IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '3 L'; END IF;
				-- Validação Raça
				IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
				IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
				IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
				IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
				IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
				IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
				SELECT count(*) into eci_exportado from esus_cadastro_individual where usu_codigo = NEW.usu_codigo;
				IF (TG_OP='UPDATE' AND eci_exportado > 0) THEN
													
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua,
						uuid_ficha_ori)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_usr_codigo_ibge,
						linha.eci_dtatendimento,
						linha.eci_usu_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua,
						(select uuid_ficha 
						 from esus_cadastro_individual 
						 where usu_codigo = linha.usu_codigo
						 order by eci_codigo asc 
						 limit 1));	
								
						RAISE NOTICE 'UPDATE''.';
					 
				ELSE
					-- INSERÇÃO
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_usr_codigo_ibge,
						linha.eci_dtatendimento,
						linha.eci_usu_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua);
				END IF;				
			END LOOP;
		RAISE NOTICE 'INSERT''.';				 
	END IF;
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION esus_cadastro_individual()
  OWNER TO postgres;

  
CREATE OR REPLACE FUNCTION social.attEspCodigoNaBpa()
  RETURNS integer AS
$BODY$
DECLARE 
	linha RECORD;
	cont integer = 0;
BEGIN
	FOR linha IN
		SELECT  b.bpa_codigo,
			b.esp_codigo,
			b.usr_codigo,
			ag.esp_codigo as age_esp,
			ag.med_codigo as age_med
		FROM bpa b
		INNER JOIN procedimento_atendimento pa ON b.bpa_origem_codigo = pa.pat_codigo AND b.bpa_origem = 'procedimento_atendimento'
		INNER JOIN atendimento a ON a.ate_codigo = pa.ate_codigo
		INNER JOIN agendamento ag ON ag.age_codigo = a.age_codigo
		INNER JOIN especialidade e ON e.esp_codigo = b.esp_codigo
		WHERE b.usr_codigo = ag.med_codigo 
		     AND b.esp_codigo != ag.esp_codigo
		ORDER BY b.bpa_codigo desc
	LOOP
		cont := cont+1;
		UPDATE bpa
			SET esp_codigo = linha.age_esp
		WHERE bpa_codigo = linha.bpa_codigo;
	END LOOP;
	RETURN cont;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

SELECT attEspCodigoNaBpa();

CREATE OR REPLACE FUNCTION social.esus_odonto()
  RETURNS trigger AS
$BODY$
DECLARE 
	linha RECORD;
	eo_sexo character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM esus_odonto WHERE eo_codigo = OLD.eo_codigo;
		RETURN OLD;
	ELSE
		FOR linha IN
			SELECT DISTINCT
				odpc.odo_pcon_codigo,
				tbl.co_local_atend,
				usr.cnes_cod_cns AS eo_profissional_cns,
				esp.cod_cbo AS eo_cbo_codigo_2002,
				uni.uni_cnes AS eo_cnes,
				ate.ate_data AS eo_dtatendimento,
				uni.uni_codigo_ibge AS eo_codigo_ibge_mun,
				usu.usu_datanasc AS eo_dtnascimento,
				usu.usu_cartao_sus AS eo_num_cartao_sus,	
				usu.usu_prontuario AS eo_numprontuario,
				age.tat_codigo AS eo_tipo_atendimento,
				age.tp_cod AS eo_tipo_consulta,					
				usu.usu_sexo					
			FROM 
				odonto_procedimentos_controle AS odpc 
			INNER JOIN 
				atendimento AS ate ON odpc.ate_codigo=ate.ate_codigo
			INNER JOIN 
				agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN 
				especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN 
				usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
				usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
				unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN 
				tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
			WHERE 
				odpc.odo_pcon_codigo = NEW.odo_pcon_codigo LOOP
			-- Validação de sexo
			IF (linha.usu_sexo='M') THEN 
				eo_sexo = '0 L';
			ELSE
				eo_sexo = '1 L';
			END IF;
			-- Realiza a inserção dos da ficha de procedimento do E-SUS
			INSERT INTO esus_odonto(
				odo_pcon_codigo,
				co_local_atend,
				eo_profissional_cns,
				eo_cbo_codigo_2002,
				eo_cnes,
				eo_dtatendimento,
				eo_codigo_ibge_mun,
				eo_dtnascimento,
				eo_num_cartao_sus,
				eo_numprontuario,
				eo_tipo_atendimento,
				eo_tipo_consulta,
				eo_sexo,
				eo_tipo_dado_serializado
			) VALUES (
				linha.odo_pcon_codigo,
				linha.co_local_atend,
				linha.eo_profissional_cns,
				linha.eo_cbo_codigo_2002,
				linha.eo_cnes,
				linha.eo_dtatendimento,
				linha.eo_codigo_ibge_mun,
				linha.eo_dtnascimento,
				linha.eo_num_cartao_sus,
				linha.eo_numprontuario,
				linha.eo_tipo_atendimento,
				linha.eo_tipo_consulta,
				eo_sexo,
				'5 L'
			);
			RETURN NEW;
			RAISE NOTICE 'Registro inserido com sucesso''.';
		END LOOP;
	END IF;	
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION esus_odonto()
  OWNER TO postgres;


DROP TRIGGER atualiza_esus_odonto ON odonto_procedimentos_controle;

CREATE TRIGGER atualiza_esus_odonto
  AFTER INSERT OR UPDATE 
  ON odonto_procedimentos_controle
  FOR EACH ROW
  EXECUTE PROCEDURE esus_odonto();
  
