<?php

header('Content-Type: text/html; charset=utf-8');
error_reporting(E_ALL & ~E_NOTICE);
ini_set("display_errors", 1);
ini_set("ignore_repeated_errors", 0);

class update {

    private $raizDaWeb;
    private $banco;
    private $versao;
    private $servidor = "http://saude.elotech.com.br";
    private $versaoServidor;

    public function __construct() {
        try {
            $this->acharRaizDaWeb();
            $this->redirecionar(FALSE);
            $this->pegarInformacoesDoBanco();
            $this->pegarVersoesLocal();
            $this->pegarVersoesServidor();
            $this->atualizarTudo();
        } catch (Exception $e) {
            echo $e->getMessage();
        }
        
        $this->redirecionar(TRUE);
    }
    
    private function redirecionar($acessoNormal) {
		return FALSE;
        $file = $this->raizDaWeb . "/WebSocialSaude/.htaccess";

        if ($acessoNormal) {
            @unlink($file);
        } else {
            if(!file_exists($file)){
                $h = fopen($file, "a+");
                fputs($h, "redirectMatch 302 ^(.*)$ " . $this->servidor . "/WebSocialUpdate/aguarde.php?l=$1");
                fclose($h);
            }
        }
    }

    private function acharRaizDaWeb() {
        $this->raizDaWeb = dirname(dirname(__FILE__));
    }

    private function pegarInformacoesDoBanco() {
        $file = $this->raizDaWeb . "/WebSocialComum/library/conf/dbConfig.xml";

        if (!file_exists($file)) {
            throw new Exception("Arquivo de configuração do banco de dados não encontrado. ($file)");
        }

        //carrega o arquivo XML e retornando um Array
        $xml = simplexml_load_file($file);
        $this->banco = array(
            "host" => base64_decode($xml->conexao->host),
            "dbname" => base64_decode($xml->conexao->dbname),
            "user" => base64_decode($xml->conexao->user),
            "password" => base64_decode($xml->conexao->password),
            "port" => base64_decode($xml->conexao->porta)
        );
    }

    private function conectarComOBanco() {
        $str = "";
        foreach ($this->banco as $key => $value)
            $str .= "$key=$value ";

        pg_connect($str." options='--client_encoding=UTF8'");
        pg_set_client_encoding( UNICODE);
    }

    private function getConfig($chave) {
        $this->conectarComOBanco();
        $query = pg_query("SELECT * FROM config WHERE conf_chave='$chave';");
        $row = pg_fetch_object($query);

        switch ($row->conf_tipo) {
            case 1:
                return (string) $row->conf_valor_string;
                break;
            case 2:
                return ($row->conf_valor_bool == 't' ? TRUE : FALSE);
                break;
            case 3:
                return (int) $row->conf_valor_int;
                break;
            case 4:
                return (string) $row->conf_valor_data;
                break;
            default:
                return (string) $row->conf_valor_string;
                break;
        }
    }

    private function pegarVersoesLocal() {
        $this->versao = array(
            "COMUM" => $this->getConfig("VERSAO_COMUM"),
            "SAUDE" => $this->getConfig("VERSAO_SAUDE"),
            "SOCIAL" => $this->getConfig("VERSAO_SOCIAL")
        );
    }

    private function pegarVersoesServidor() {
        $jsonStr = '{"COMUM":"3.11.3","SAUDE":"3.25.24.1","SOCIAL":"3.14.12"}';//@file_get_contents($this->servidor . "/WebSocialUpdate/last.json");
		
		if(!$jsonStr)
			throw new Exception( "Não foi possível conectar-se ao servidor ".$this->servidor );
		
        $this->versaoServidor = (array) json_decode($jsonStr);
    }

    private function baixar($de, $para) {
        $de = $this->servidor . "/WebSocialUpdate/repo/" . strtolower($de);
        $para = dirname(__FILE__) . "/temp/" . strtolower($para);
        $this->log($de);
        $this->log($para);

        $temp = dirname($para);
        if (!file_exists($temp)){
            mkdir($temp, 0777, TRUE);
		}
		
        $this->log($temp);

        $h = fopen($para, "a+");
        //fputs($h, file_get_contents($de));
        fclose($h);

        return $para;
    }

    private function atualizarTudo(){
        //$this->atualizar("COMUM");
        $this->atualizar("SAUDE");
        //$this->atualizar("SOCIAL");
    }
    
    private function atualizar($modulo) {
        $dif = version_compare($this->versao[$modulo], $this->versaoServidor[$modulo]);

        if (!$this->versao[$modulo])
            return FALSE;
            //throw new Exception(sprintf("Atualização automtica precisa da versão WebSocialComum.3.9.2/WebSocialSaude.3.22.21/WebSocialSocial.3.14.12 ou superior.<br /><small>Encontrado: <pre>%s</pre></small>", $this->versao[$modulo]));

        if ($dif == 0) { // já possui a versão mais recente
            $this->log("M�dulo $modulo está na ultima versão! " . $this->versao[$modulo] . " x " . $this->versaoServidor[$modulo]);
            return TRUE;
        }

        if ($dif == 1)
            throw new Exception("A versão instalada parece ser maior que a versão atual. " . $this->versao[$modulo] . " x " . $this->versaoServidor[$modulo]);

        $this->baixar($modulo . "/" . $this->versaoServidor[$modulo] . ".zip", $this->versaoServidor[$modulo] . ".zip");
        $this->extrair($this->versaoServidor[$modulo]);
        $moduloName = "WebSocial" . ucfirst(strtolower($modulo));
        $this->backup($moduloName, $this->versao[$modulo]);
        $this->mover("temp2/".$this->versaoServidor[$modulo], $moduloName);
        
        return TRUE;
    }

    private function extrair($file) {
        $zip = new ZipArchive;
        if (!file_exists("temp2/$file"))
            mkdir("temp2/$file", 0777, TRUE);

        $res = $zip->open("temp2/" . $file . ".zip");
        if ($res === TRUE) {
            $zip->extractTo("temp2/" . $file);
            $zip->close();
        }
        @unlink("temp2/" . $file . ".zip");
    }
    
    private function backup($de, $versao){
        // copiar: WebSocialSaude para WebSociaSaude.3.22.21
		//$this->recursiveCopy($this->raizDaWeb."/$de", $this->raizDaWeb."/$de.$versao");
    }
    
    private function mover($de, $para){
		//$this->recursiveCopy($de, $this->raizDaWeb."/$de");
		//$this->rrmdir($de);
        
    }

    private function log($msg) {
        //return FALSE;
        printf("%s<br />", $msg);
    }
	
	private function recursiveCopy($source, $dest, $diffDir = ''){
		$sourceHandle = opendir($source);
		if(!$diffDir)
				$diffDir = $source;

		mkdir($dest . '/' . $diffDir);

		while($res = readdir($sourceHandle)){
			if($res == '.' || $res == '..')
				continue;

			if(is_dir($source . '/' . $res)){
				$this->recursiveCopy($source . '/' . $res, $dest, $diffDir . '/' . $res);
			} else {
				copy($source . '/' . $res, $dest . '/' . $diffDir . '/' . $res);

			}
		}
	} 

	/**
	 * Remove os arquivos, recursivamente.
	 */
	private function rrmdir($dir) {
		foreach (glob($dir . '/*') as $file) {
			if (is_dir($file))
				$this->rrmdir($file);
			else
				unlink($file);
		}
		rmdir($dir);
	}

}

$update = new update();
//echo var_dump(version_compare('5.9.9', '5.0.0'));