<?php

class Hemograma {

	private $sexo;
	private $meses;
	private $valores = FALSE;
	private $dataAtual;

	public function __construct() {
		$this->dataAtual = time();
	}
	
	/**
	 * A data atual, ou data final, para comparar com data de nascimento do paciente. Formato: d/m/Y
	 * @param string $data 
	 */
	public function setDataAtual($data){
		list($d, $m, $a) = explode("/", $data);
		$this->dataAtual = mktime(0, 0, 0, $m, $d, $y);
	}

	/**
	 * Converte a data informada (d/m/Y) em meses até a data atual ou a data informada em setDataAtual()
	 * @param string $dn Data de Nascimento
	 */
	private function calculaMesesDeVida($data) {
		list($d, $m, $a) = explode("/", $data);
		$this->meses = floor(( $this->dataAtual - mktime(0, 0, 0, $m, $d, $a)) / 2592000);
	}

	/**
	 * Informa o sexo do paciente
	 * @param char $sexo
	 */
	public function setSexo($sexo) {
		$this->sexo = $sexo;
	}

	/**
	 * Converte a data informada (d/m/Y) em meses até a data atual ou a data informada em setDataAtual()
	 * @param string $dn Data de Nascimento
	 */
	public function setMesesDeVida($dataNascimento) {
		$this->calculaMesesDeVida($dataNascimento);
	}

	/**
	 * Recupera o valor de referencia 
	 * @param integer $ite_codigo Código do item do exame
	 */
	public function getValor($ite_codigo) {
		if (!$this->valores)
			$this->carregar();

		return $this->valores[$ite_codigo];
	}

	/**
	 * Busca os valores de referencia no banco de dados
	 */
	private function carregar() {
		$this->valores = array();

		$query = pg_query(" SELECT v.ite_codigo, v.vlr_valordereferencia || ' ' || i.ite_tipo_medida as valor
							  FROM valoresdereferencia v
							  JOIN itensanalise i
							    ON i.ite_codigo = v.ite_codigo
							 WHERE v.vlr_sexo='" . $this->sexo . "'
							   AND v.vlr_faixa_etaria_inicio <= " . $this->meses . "
							   AND v.vlr_faixa_etaria_fim > " . $this->meses);

		while ($r = pg_fetch_array($query))
			$this->valores[$r['ite_codigo']] = $r['valor'];

		return true;
	}

	/**
	 * @assert (40, 4.5) == 88.89
	 */
public function calculoVcm($hematocrito,$eritrocitos){
			/*fórmula para calcular o VCM
			 * VCM = HT * 10 / ER
			 */
			$eritrocitos =  str_replace(".",",",$eritrocitos);
			$hematocrito =  str_replace(".",",",$hematocrito);
			$calc = $hematocrito * 10 / moeda2($eritrocitos);
			return moeda($calc);
		}

		public function calculoHcm($hemoglobina,$eritrocitos){
			/*
			 * HCM = HB * 10 / ER 
			 */
			$hemoglobina = str_replace(".",",",$hemoglobina);
			$eritrocitos = str_replace(".",",",$eritrocitos);
			$calc = moeda2($hemoglobina) * 10 / moeda2($eritrocitos);
			return moeda($calc);
		}
		
		public function calculoChcm($hemoglobina, $hematocrito){
			/*
			 * CHCM = HM / HB * 100
			 */
			$hemoglobina =  str_replace(".",",",$hemoglobina);
			$hematocrito = str_replace(".",",",$hematocrito);
			$calc = moeda2($hemoglobina) / $hematocrito * 100;
			return moeda($calc);
			
		}
		
		public function somaLeucograma ($eosinofilos,$linfocitos,$monocitos,$segmentados){
			
			$calc = $eosinofilos + $linfocitos + $monocitos + $segmentados;
			//$calc = "aoaokakoaokko";
			return($calc);
		}
		
		public function porcentagemLeucograma ($leucocitos,$digitadoLeuc){
			//$digitadoLeuc = substr($digitadoLeuc, 0, -2);
			$digitadoLeuc = str_replace("%", "", $digitadoLeuc);
			$leucocitos = str_replace(".", "", $leucocitos);
			$porcentagem = $digitadoLeuc / 100;
			$calc = $leucocitos * $porcentagem;
			//$calc = "$leucocitos * $porcentagem";
			return $calc;
		}
				
	}
