<?php


function db_query_execute($queryString){

	$resultQuery = @pg_query($queryString);

	if (!$resultQuery){
		fdebug($queryString);
		throw new Exception(pg_last_error());
	}

	return  $resultQuery;
}


interface Command
{
	public function execute();

	public function msgErr($msg);
}


class CommandExecute {


	public function execute($command){

		try{
			db_query_execute('BEGIN TRANSACTION');
			$command->execute();
			db_query_execute('COMMIT TRANSACTION');
			return true;
		}catch (Exception $e){
			db_query_execute('ROLLBACK TRANSACTION');
			$command->msgErr($e->getMessage());
			return false;
		}

	}

}


?>