<?php

// global.php
require_once COMUM.'/class/transactionControl.php';

class DispensarMedicamento implements Command {
	
	private $movimento = false;
	private $usu_codigo;
	private $uni_codigo;
	private $set_codigo;
	private $usr_codigo;
	private $medico_usr = "NULL";
	private $medico_med = "NULL";
	private $itens = array();
	private $item;
	private $temp = 0;
	
	/**
	 * Registra um movimento com vários itens, usando 'BEGIN TRANSACTION'
	 * @param int $usu código do paciente
	 * @param int $set código do setor
	 * @param int $usr código do usuário (atendendente)
	 * @param int $medico código do médico, interno ou externo
	 * @param bool $interno true para médico interno, false para médico externo
	 * @author Falci <fernando@elotech.com.br>
	 */
	public function __construct($usu,$set,$uni,$usr,$medico,$interno=FALSE){
		fdebug("DispensarMedicamento::__construct();");
		$this->usu_codigo = $usu;
		$this->set_codigo = $set;
		$this->usr_codigo = $usr;
		$this->uni_codigo = $uni;
		if($interno)
			$this->medico_usr = $medico;
		else
		 	$this->medico_med = $medico;
	}
	
	/**
	 * Cria um registro na tabela 'movimento'
	 */
	private function criarMovimento(){
		$ip = $_SERVER['REMOTE_ADDR'];
		$query = db_query_execute("SELECT NEXTVAL('seq_mov_codigo');");
		$this->movimento = pg_result($query,0);
		$sql =   "INSERT INTO movimento (
                              mov_codigo, 
                              mov_data, 
                              mov_tipo, 
                              usu_codigo, 
					          set_saida, 
					          usr_codigo, 
					          mov_ip,
					          mov_data_inclusao, 
					          mov_saida,  
					          med_codigo_interno,
					          med_codigo_externo) 
					  VALUES (".$this->movimento.",
					          NOW(),
					          'S',
					          ".$this->usu_codigo.",
					          ".$this->set_codigo.",
					          ".$this->usr_codigo.",
					          '$ip',
					          NOW(),
					          'D',
					          ".$this->medico_usr.",
					          ".$this->medico_med.");";	
		
		db_query_execute($sql);
	}
	
	/** 
	 * Adiciona os itens que seráo inseridos no 'itens_movimento'
	 * @param string $arr "$pro_codigo|$lote|$validade|$qtd|$duracao"
	 */
	public function addItensMovimento($arr){
		$this->itens []= $arr;
	}
	
	/**
	 * Insere os itens na tabela 'itens_movimento'
	 * @param string $arr "$pro_codigo|$lote|$validade|$qtd|$usarSaldo|$fracionado"
	 */
	private function insereItensMovimento($arr){
		$this->item = $arr;
		list($pro_codigo,$lote,$validade,$qtd,$usarSaldo,$fracionado,$dose_lote,$duracao) = explode("|",$arr);
		
		if($fracionado){
			$quantidade = ceil($qtd / $dose_lote);
			$temp = $qtd;
			
			for ($i=0; $i<$quantidade; $i++){
				if($temp > $dose_lote){
					$temp -=$dose_lote;
					$qtd2 = $dose_lote;
				}else{
					$qtd2 = $temp;
				}
				fdebug("quantidade de unidades desse lote: ".$quantidade." com $dose_lote fracao cada");
				fdebug("baixar: ".$qtd2);
				$this->atualizaFracionado($pro_codigo,$qtd2);
			}
						
		} else{
			$this->_insereItensMovimento($arr);
		}
		
		
	}	
	
	private function nextVal($seq){
		$query = pg_query("SELECT nextval('$seq');");
		$res = pg_fetch_array($query);
		return $res[0];		
	}
	
	private function _insereItensMovimento($arr,&$doseLote){
		list($pro_codigo,$lote,$validade,$qtd,$usarSaldo,$fracionado,$doseLote,$duracao) = explode("|",$arr);
		
		$ite_codigo = $this->nextVal("seq_ite_codigo");
		
		$sql = "INSERT INTO itens_movimento
							(ite_codigo,
							 mov_codigo, 
						  	 pro_codigo, 
						  	 ite_quantidade, 
						  	 ite_lote,
						  	 ite_validade,
						  	 ite_consolidado, 
						  	 ite_status,
						  	 ite_dose, 
						  	 ite_vlrunit,
						  	 ite_duracao)
					 VALUES 
							($ite_codigo,
							 '".$this->movimento."', 
						  	 '$pro_codigo', 
						  	 '$qtd', 
						  	 '$lote',
						  	 '$validade',
						  	 'S', 
						  	 'A',
						  	  $doseLote,
						  	 verifica_preco('".$arr['pro_codigo']."', '".$this->set_codigo."', '".date("Y-m-d")."'),
						  	 ".($duracao != "" ? "$duracao" : "NULL").");";
			db_query_execute($sql);
			fdebug("movimentou $qtd");
			return $ite_codigo;
	}
	
	/**
	 * Pega o ite_codigo do item movimento que gerou o controlefracionado
	 * @param int $pro_codigo
	 * @return int ite_codigo
	 */
	private function pegaIteByPro($pro_codigo,&$doseLote){
		$sql = "SELECT im.ite_codigo,
					   im.ite_dose
				  FROM itens_movimento AS im
				  JOIN controlefracionado AS c
				    ON c.ite_codigo = im.ite_codigo
				 WHERE im.pro_codigo = $pro_codigo   
				   AND cont_dose > 0";
		
		$query = db_query_execute($sql);
		
		if(!pg_num_rows($query)){
			list($pro_codigo,$lote,$validade,$qtd,$usarSaldo,$fracionado,$doseLote) = explode("|",$this->item);
			return $this->_insereItensMovimento("$pro_codigo|$lote|$validade|1|null|null|$doseLote",$doseLote);
		}
		
		$row = pg_fetch_array($query);
		$doseLote = $row[1];
		return $row[0];
	}
	
	/**
	 * Pega a PK do controlefracionado pelo ite_codigo
	 * @param int $ite_codigo
	 * @return int $cont_codigo
	 */
	private function pegaContByIte($ite_codigo,$cont_dose=false){
		$sql = "SELECT cont_codigo 
				  FROM controlefracionado AS c
				 WHERE ite_codigo = $ite_codigo";
		
		$query = db_query_execute($sql);
		fdebug("controlefracao");
		if(!pg_num_rows($query)){
			fdebug("não encontrou o controlefracao e ira criar");
			list($pro_codigo,$lote,$validade,$qtd,$usarSaldo,$fracionado) = explode("|",$this->item);
			//fdebug($qtd);exit;
			$cont_codigo = $this->nextVal("controlevacina_cont_codigo_seq");
			$sql = "INSERT INTO controlefracionado( cont_codigo,
													cont_dose, 
													set_codigo, 
											  		ite_codigo)
						  VALUES($cont_codigo,
						  		$cont_dose,						  		
						  		$this->set_codigo,
						  		$ite_codigo)";
			
	  		db_query_execute($sql);
	  		fdebug("criado controlefracao com $cont_dose doses;");
	  		return $cont_codigo;
		}
		
		$row = pg_fetch_array($query);
		return $row[0];
		
	}
	
	/**
	 * Baixa o 'estoque' fracionado, que na vdd  a tabela controlefracionado
	 * Depois, registra que o paciente 'tomou' aquele medicamento
	 * @param int $pro_codigo
	 * @param int $qtd
	 */
	private function atualizaFracionado($pro_codigo,$qtd){
		$ite_codigo = $this->pegaIteByPro($pro_codigo,$doseLote);
		$cont_codigo = $this->pegaContByIte($ite_codigo,$doseLote);
		
		$sql    = "UPDATE controlefracionado 
					  SET cont_dose = cont_dose - $qtd  
					WHERE ite_codigo = $ite_codigo";		
		db_query_execute($sql);
		
		
		$sql   = "INSERT 
					INTO vacina_usuario(usu_codigo, 
										pro_codigo, 
										vac_acao, 
										vac_dose, 
										vac_data, 
            							vac_unidade, 
            							cont_codigo, 
            							vac_qtde)
            		VALUES($this->usu_codigo,
            			   $pro_codigo,
            			   'D',
            			   1,
            			   NOW(),
            			   $this->uni_codigo,
            			   $cont_codigo,
            			   $qtd)";
        fdebug($sql);
		db_query_execute($sql);
		
	}
	
	/**
	 * @see class/Command::execute()
	 */
	public function execute(){
		$this->criarMovimento();
		
		foreach($this->itens as $item){
			fdebug($item);
			$this->insereItensMovimento($item);
		}		
		// evitar mov sem filho		
	}

	/**
	 * @see class/Command::msgErr()
	 */
	public function msgErr($msg){	
		fdebug($msg);
		//$this->modalMsg("ERRO","Não foi possivel realiza Dispensação.","dispensarProdutoDoEvento.php?acao=dispensar&eve_codigo=$eve_codigo",$msg);	
	}

	
}
