<?php
$autorizacao = $_GET['autorizacao'];
$sistema = $_GET['sistema'];
if (!$sistema) {
	$sistema = 'saude';
}
if (!$autorizacao) {
	header("location: ../forms/formLogin.php?sistema=$sistema");
}
$file = __DIR__ . "/../library/conf/dbConfig.xml";
$file_exist = false;
if (file_exists($file)) {
	$file_exist = true;
	$xml = simplexml_load_file($file);
	$banco = base64_decode($xml->conexao->adapter);
	$host = base64_decode($xml->conexao->host);
	$dbname = base64_decode($xml->conexao->dbname);
	$usuario = base64_decode($xml->conexao->user);
	$porta = base64_decode($xml->conexao->porta);
	$senha = base64_decode($xml->conexao->password);
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link href="../library/css/bootstrap.min.css" media="screen" rel="stylesheet" type="text/css">
    <link href="../library/css/jquery-ui-1.8.16.custom.css" media="screen" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="../library/js/jquery-1.6.2.min.js"></script>
    <script type="text/javascript" src="../library/js/jquery-ui-1.8.16.custom.min.js"></script>
    <style>
        .principal {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            width: 100vw;
        }

        .formulario {
            width: 300px;
        }
    </style>
    <script>
        $(function () {
            $(document).bind('keypress', function (e) {
                if (e.keyCode == 13) {
                    gerarArquivo();
                }
            });
        });

        function gerarArquivo() {
            var host = $(location).attr('hostname');
            var conexao = $("#conexao :selected").val();
            var host = $("#host").val();
            var banco = $("#banco").val();
            var porta = $("#porta").val();
            var usuario = $("#usuario").val();
            var senha = $("#senha").val();
            var sistema = $("#sistema").val();
            $.ajax({
                url: "geraArquivoConexao.php",
                data: {
                    conexao: conexao,
                    host: host,
                    banco: banco,
                    porta: porta,
                    usuario: usuario,
                    senha: senha,
                },
                success: function (ret) {
                    var titulo = (ret.status ? "Sucesso" : "Erro");
                    mensagem(titulo, ret.msg, 400, "auto", sistema, ret.status);
                }
            });
        }

        function mensagem(titulo, mensagem, x, y, sistema, status) {
            var conteudo_detalhe = "";
            var modal = "<div id=\"mensagem-dialog\" title=\"" + titulo + "\">"
                + mensagem
                + "<br/>"
                + conteudo_detalhe
                + "</div>";
            $("body").append(modal);
            $("#mensagem-dialog").dialog({
                modal: true,
                width: x,
                height: y,
                close: function () {
                    $(this).remove();
                },
                buttons: {
                    "Ok":
                        function () {
                            $(this).dialog('close');
                            if (status) {
                                location.href = (sistema === "saude" ? "/WebSocialSaude/" : "/WebSocialSocial/");
                            }
                        }
                }
            });
        }

        function isNumberKey(evt) {
            var charCode = (evt.which) ? evt.which : evt.keyCode
            return !(charCode > 31 && (charCode < 48 || charCode > 57));
        }
    </script>
</head>
<body>
<div class="principal">
    <input type="hidden" id="sistema" value="<?= $sistema ?>">
	<?php session_start();
	$compare_hash = $_SESSION['hash_auth'];
	if ($compare_hash == $autorizacao) { ?>
        <div class="container-fluid">
			<?php if (!$file_exist) { ?>
                <div class="alert alert-info text-center">
                    <h5><strong>Arquivo de configuração do banco de dados não encontrado.</strong></h5>
                    <h6>Preencha as informações abaixo para criar um novo arquivo.</h6>
                </div>
			<?php } ?>
            <div class="container-fluid formulario">
                <label for="">Conexão</label>
                <select class="form-control" id="conexao">
                    <option value="PDO_PGSQL" <?= ($banco === "PDO_PGSQL" ? "selected" : "") ?>>Postgres</option>
                    <option value="PDO_OCI" <?= ($banco === "PDO_OCI" ? "selected" : "") ?>>Oracle</option>
                </select>
            </div>
            <div class="container-fluid formulario">
                <label for="">HOST</label>
                <input type="text" class="form-control" id="host" value="<?= $host ?>">
            </div>
            <div class="container-fluid formulario">
                <label for="">Banco</label>
                <input type="text" class="form-control" id="banco" value="<?= $dbname ?>">
            </div>
            <div class="container-fluid formulario">
                <label for="">Porta</label>
                <input type="text" class="form-control" id="porta" maxlength="4" onkeypress="return isNumberKey(event);"
                       value="<?= $porta ?>">
            </div>
            <div class="container-fluid formulario">
                <label for="">Usuário</label>
                <input type="text" class="form-control" id="usuario" value="<?= $usuario ?>">
            </div>
            <div class="container-fluid formulario">
                <label for="">Senha</label>
                <input type="password" class="form-control" id="senha" value="<?= $senha ?>">
            </div>
            <div class="container-fluid formulario text-right" style="margin-top: 5px;">
                <button class="btn btn-primary" onclick="gerarArquivo();">Gerar Arquivo</button>
            </div>
        </div>
	<? } else { ?>
        <script>
            $(function () {
                var sistema = $("#sistema").val();
                window.location.href = window.location.href + "/../formLogin.php?sistema=" + sistema;
            });
        </script>
	<? } ?>
</div>
</body>
</html>
